/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivGroup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivRankings;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "header", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "getFixedContent", "core"})
@SourceDebugExtension(value={"SMAP\nVictoryScreenCivRankings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryScreenCivRankings.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenCivRankings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n766#2:55\n857#2,2:56\n1549#2:59\n1620#2,3:60\n1045#2:63\n1054#2:64\n1#3:58\n*S KotlinDebug\n*F\n+ 1 VictoryScreenCivRankings.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenCivRankings\n*L\n24#1:55\n24#1:56,2\n37#1:59\n37#1:60,3\n38#1:63\n39#1:64\n*E\n"})
public final class VictoryScreenCivRankings
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final Table header;

    /*
     * WARNING - void declaration
     */
    public VictoryScreenCivRankings(@NotNull WorldScreen worldScreen) {
        Object it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.header = new Table();
        this.align(10);
        this.header.align(10);
        this.defaults().pad(10.0f);
        Iterable $this$filter$iv = worldScreen.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!((Civilization)it).isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List majorCivs2 = (List)destination$iv$iv;
        for (RankingType category : RankingType.values()) {
            void $this$sortedByDescending$iv;
            Iterable $this$sortedBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Table textAndIcon = new Table();
            Image columnImage = category.getGetImage().invoke();
            if (columnImage != null) {
                textAndIcon.add((Actor)columnImage).size(13.5f).padRight(2.0f).padTop(-2.0f);
            }
            textAndIcon.add((Actor)Scene2dExtensionsKt.toLabel(category.getLabel())).row();
            this.header.add((Actor)textAndIcon).pad(10.0f);
            Object $this$_init__u24lambda_u241 = it = new Table();
            boolean bl = false;
            ((Table)$this$_init__u24lambda_u241).defaults().space(10.0f);
            Object column = it;
            $this$_init__u24lambda_u241 = majorCivs2;
            boolean $i$f$map = false;
            void var13_17 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Civilization civilization = (Civilization)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new VictoryScreen.CivWithStat((Civilization)it2, category));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    VictoryScreen.CivWithStat it = (VictoryScreen.CivWithStat)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getCiv().getCivName());
                    it = (VictoryScreen.CivWithStat)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getCiv().getCivName()));
                }
            });
            boolean $i$f$sortedByDescending = false;
            List<VictoryScreen.CivWithStat> civData = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    VictoryScreen.CivWithStat it = (VictoryScreen.CivWithStat)b;
                    boolean bl = false;
                    int n = it.getCiv().isDefeated() ? Integer.MIN_VALUE : it.getValue();
                    it = (VictoryScreen.CivWithStat)a;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, it.getCiv().isDefeated() ? Integer.MIN_VALUE : it.getValue());
                }
            });
            for (VictoryScreen.CivWithStat civEntry : civData) {
                ((Table)column).add((Actor)new VictoryScreenCivGroup(civEntry, worldScreen.getViewingCiv(), null, 4, null)).fillX().row();
            }
            this.add((Actor)column);
        }
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(this.header, color, 0, 0.0f, 6, null);
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        Table[] tableArray = new Table[]{this.header, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.header;
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.DefaultImpls.deactivated(this, index, caption, pager);
    }
}

