/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.map.MapVisualization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.multiplayer.MultiplayerGameUpdated;
import com.unciv.logic.multiplayer.storage.FileStorageRateLimitReached;
import com.unciv.logic.multiplayer.storage.MultiplayerAuthException;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.input.KeyboardPanningListener;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.AuthPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.mainmenuscreen.MainMenuScreen;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.pickerscreens.DiplomaticVoteResultScreen;
import com.unciv.ui.screens.pickerscreens.GreatPersonPickerScreen;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.ui.screens.savescreens.QuickSave;
import com.unciv.ui.screens.savescreens.SaveGameScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.worldscreen.AlertPopup;
import com.unciv.ui.screens.worldscreen.NotificationsScroll;
import com.unciv.ui.screens.worldscreen.RenderEvent;
import com.unciv.ui.screens.worldscreen.TechPolicyDiplomacyButtons;
import com.unciv.ui.screens.worldscreen.TradePopup;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.WorldScreenKt;
import com.unciv.ui.screens.worldscreen.ZoomButtonPair;
import com.unciv.ui.screens.worldscreen.bottombar.BattleTable;
import com.unciv.ui.screens.worldscreen.bottombar.TileInfoTable;
import com.unciv.ui.screens.worldscreen.mainmenu.WorldScreenMusicPopup;
import com.unciv.ui.screens.worldscreen.minimap.MinimapHolder;
import com.unciv.ui.screens.worldscreen.status.AutoPlayStatusButton;
import com.unciv.ui.screens.worldscreen.status.MultiplayerStatusButton;
import com.unciv.ui.screens.worldscreen.status.NextTurnButton;
import com.unciv.ui.screens.worldscreen.status.NextTurnProgress;
import com.unciv.ui.screens.worldscreen.status.StatusButtons;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBar;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsTable;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002\u0091\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010]\u001a\u00020^H\u0002J\b\u0010_\u001a\u00020^H\u0002J\u0006\u0010`\u001a\u00020^J\b\u0010a\u001a\u00020^H\u0002J\b\u0010b\u001a\u00020^H\u0002J\b\u0010c\u001a\u00020^H\u0002J\b\u0010d\u001a\u00020^H\u0016J\b\u0010e\u001a\u00020fH\u0016J\n\u0010g\u001a\u0004\u0018\u00010hH\u0002J\u0006\u0010i\u001a\u00020\tJ)\u0010j\u001a#\u0012\u0015\u0012\u0013\u0018\u00010l\u00a2\u0006\f\bm\u0012\b\bn\u0012\u0004\b\b(o\u0012\u0004\u0012\u00020p0kj\u0002`qH\u0016J\r\u0010r\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\bsJ\u0011\u0010t\u001a\u00020^H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ\u0006\u0010v\u001a\u00020^J\u0006\u0010w\u001a\u00020^J\u0012\u0010x\u001a\u00020^2\n\b\u0002\u0010y\u001a\u0004\u0018\u00010zJ\u0006\u0010{\u001a\u00020^J'\u0010|\u001a\u00020^2\u0006\u0010}\u001a\u00020O2\u0006\u0010~\u001a\u00020\u00162\r\u0010\u007f\u001a\t\u0012\u0004\u0012\u00020^0\u0080\u0001H\u0016J\u0007\u0010\u0081\u0001\u001a\u00020^J\u0013\u0010\u0082\u0001\u001a\u00020^2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0016J\u001b\u0010\u0085\u0001\u001a\u00020^2\u0007\u0010\u0086\u0001\u001a\u00020O2\u0007\u0010\u0087\u0001\u001a\u00020OH\u0016J\u0011\u0010\u0088\u0001\u001a\u00020^2\u0006\u0010\b\u001a\u00020\tH\u0002J\t\u0010\u0089\u0001\u001a\u00020^H\u0002J\u0007\u0010\u008a\u0001\u001a\u00020^J\t\u0010\u008b\u0001\u001a\u00020^H\u0002J\t\u0010\u008c\u0001\u001a\u00020^H\u0002J\t\u0010\u008d\u0001\u001a\u00020^H\u0002J\t\u0010\u008e\u0001\u001a\u00020^H\u0002J\t\u0010\u008f\u0001\u001a\u00020^H\u0002J\t\u0010\u0090\u0001\u001a\u00020^H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001eR\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u000205X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0018\"\u0004\bA\u0010\u001eR\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010D\u001a\u00020EX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0014\u0010H\u001a\u00020IX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u000e\u0010L\u001a\u00020MX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010Q\u001a\u00020RX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010<R\u001a\u0010X\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0018\"\u0004\bZ\u0010\u001eR\u000e\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0092\u0001"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "autoPlay", "Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "restoreState", "Lcom/unciv/ui/screens/worldscreen/WorldScreen$RestoreState;", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/worldscreen/WorldScreen$RestoreState;)V", "getAutoPlay", "()Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "battleTable", "Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTable;", "bottomTileInfoTable", "Lcom/unciv/ui/screens/worldscreen/bottombar/TileInfoTable;", "bottomUnitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "getBottomUnitTable$core", "()Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "canChangeState", "", "getCanChangeState", "()Z", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "fogOfWar", "getFogOfWar", "setFogOfWar", "(Z)V", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "<set-?>", "isPlayersTurn", "setPlayersTurn$core", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "getMapHolder", "()Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "mapVisualization", "Lcom/unciv/logic/map/MapVisualization;", "minimapWrapper", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;", "getMinimapWrapper$core", "()Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;", "nextTurnButton", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "getNextTurnButton$core", "()Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "nextTurnUpdateJob", "Lkotlinx/coroutines/Job;", "notificationsScroll", "Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;", "getNotificationsScroll$core", "()Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;", "resizeDeferTimer", "Ljava/util/Timer;", "selectedCiv", "getSelectedCiv", "()Lcom/unciv/logic/civilization/Civilization;", "setSelectedCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "shouldUpdate", "getShouldUpdate", "setShouldUpdate", "statusButtons", "Lcom/unciv/ui/screens/worldscreen/status/StatusButtons;", "techPolicyAndDiplomacy", "Lcom/unciv/ui/screens/worldscreen/TechPolicyDiplomacyButtons;", "getTechPolicyAndDiplomacy$core", "()Lcom/unciv/ui/screens/worldscreen/TechPolicyDiplomacyButtons;", "topBar", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "getTopBar$core", "()Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "tutorialTaskTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "tutorialTaskTableHash", "", "uiEnabled", "undoHandler", "Lcom/unciv/ui/screens/worldscreen/UndoHandler;", "getUndoHandler$core", "()Lcom/unciv/ui/screens/worldscreen/UndoHandler;", "unitActionsTable", "Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable;", "getViewingCiv", "waitingForAutosave", "getWaitingForAutosave$core", "setWaitingForAutosave$core", "zoomController", "Lcom/unciv/ui/screens/worldscreen/ZoomButtonPair;", "addKeyboardListener", "", "addKeyboardPresses", "autoSave", "backButtonAndESCHandler", "displayTutorialTaskOnUpdate", "displayTutorialsOnUpdate", "dispose", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "getCurrentTutorialTask", "Lcom/unciv/models/ruleset/Event;", "getRestoreState", "getShortcutDispatcherVetoer", "Lkotlin/Function1;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/ParameterName;", "name", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "isNextTurnUpdateRunning", "isNextTurnUpdateRunning$core", "loadLatestMultiplayerState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nextTurn", "openDeveloperConsole", "openEmpireOverview", "category", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewCategories;", "openNewGameScreen", "openOptionsPopup", "startingPage", "withDebug", "onClose", "Lkotlin/Function0;", "openSaveGameScreen", "render", "delta", "", "resize", "width", "height", "restore", "showTutorialsOnNextTurn", "switchToNextUnit", "toggleUI", "update", "updateAutoPlayStatusButton", "updateGameplayButtons", "updateMultiplayerStatusButton", "updateSelectedCiv", "RestoreState", "core"})
@SourceDebugExtension(value={"SMAP\nWorldScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScreen.kt\ncom/unciv/ui/screens/worldscreen/WorldScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,826:1\n800#2,11:827\n1774#2,4:838\n288#2,2:845\n187#3,3:842\n1#4:847\n*S KotlinDebug\n*F\n+ 1 WorldScreen.kt\ncom/unciv/ui/screens/worldscreen/WorldScreen\n*L\n225#1:827,11\n293#1:838,4\n463#1:845,2\n459#1:842,3\n*E\n"})
public final class WorldScreen
extends BaseScreen {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final AutoPlay autoPlay;
    @NotNull
    private final Civilization viewingCiv;
    private boolean shouldUpdate;
    private boolean isPlayersTurn;
    @NotNull
    private Civilization selectedCiv;
    private boolean fogOfWar;
    @NotNull
    private final WorldMapHolder mapHolder;
    private boolean waitingForAutosave;
    @NotNull
    private final MapVisualization mapVisualization;
    @NotNull
    private final WorldScreenTopBar topBar;
    @NotNull
    private final TechPolicyDiplomacyButtons techPolicyAndDiplomacy;
    @NotNull
    private final UnitActionsTable unitActionsTable;
    @NotNull
    private final UnitTable bottomUnitTable;
    @NotNull
    private final BattleTable battleTable;
    @NotNull
    private final ZoomButtonPair zoomController;
    @NotNull
    private final MinimapHolder minimapWrapper;
    @NotNull
    private final TileInfoTable bottomTileInfoTable;
    @NotNull
    private final NotificationsScroll notificationsScroll;
    @NotNull
    private final NextTurnButton nextTurnButton;
    @NotNull
    private final StatusButtons statusButtons;
    @NotNull
    private final Table tutorialTaskTable;
    private int tutorialTaskTableHash;
    @Nullable
    private Job nextTurnUpdateJob;
    @NotNull
    private final EventBus.EventReceiver events;
    private boolean uiEnabled;
    @NotNull
    private final UndoHandler undoHandler;
    @Nullable
    private Timer resizeDeferTimer;

    /*
     * WARNING - void declaration
     */
    public WorldScreen(@NotNull GameInfo gameInfo2, @NotNull AutoPlay autoPlay, @NotNull Civilization viewingCiv, @Nullable RestoreState restoreState) {
        Vector2 vector2;
        void $this$tutorialTaskTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
        Intrinsics.checkNotNullParameter(autoPlay, "autoPlay");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.gameInfo = gameInfo2;
        this.autoPlay = autoPlay;
        this.viewingCiv = viewingCiv;
        this.isPlayersTurn = this.viewingCiv.isCurrentPlayer();
        this.selectedCiv = this.viewingCiv;
        this.fogOfWar = true;
        this.mapHolder = new WorldMapHolder(this, this.gameInfo.getTileMap());
        this.mapVisualization = new MapVisualization(this.gameInfo, this.viewingCiv);
        this.topBar = new WorldScreenTopBar(this);
        this.techPolicyAndDiplomacy = new TechPolicyDiplomacyButtons(this);
        this.unitActionsTable = new UnitActionsTable(this);
        this.bottomUnitTable = new UnitTable(this);
        this.battleTable = new BattleTable(this);
        this.zoomController = new ZoomButtonPair(this.mapHolder);
        this.minimapWrapper = new MinimapHolder(this.mapHolder);
        this.bottomTileInfoTable = new TileInfoTable(this);
        this.notificationsScroll = new NotificationsScroll(this);
        this.nextTurnButton = new NextTurnButton(this);
        this.statusButtons = new StatusButtons(this.nextTurnButton, null, null, 6, null);
        Table table3 = table2 = new Table();
        WorldScreen worldScreen = this;
        boolean bl = false;
        $this$tutorialTaskTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/TutorialTaskTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
        worldScreen.tutorialTaskTable = table2;
        this.events = new EventBus.EventReceiver();
        this.uiEnabled = true;
        this.undoHandler = new UndoHandler(this);
        this.notificationsScroll.setWidth(this.getStage().getWidth() / (float)2);
        this.minimapWrapper.setX(this.getStage().getWidth() - this.minimapWrapper.getWidth());
        this.mapHolder.addTiles$core();
        this.mapHolder.reloadMaxZoom();
        MusicController.resume$default(UncivGame.Companion.getCurrent().getMusicController(), 0.0f, 1, null);
        this.getStage().addActor(this.mapHolder);
        this.getStage().setScrollFocus(this.mapHolder);
        this.getStage().addActor(this.notificationsScroll);
        this.getStage().addActor(this.minimapWrapper);
        this.getStage().addActor(this.tutorialTaskTable);
        this.getStage().addActor(this.topBar);
        this.getStage().addActor(this.statusButtons);
        this.getStage().addActor(this.techPolicyAndDiplomacy);
        this.getStage().addActor(this.zoomController);
        this.zoomController.setVisible(UncivGame.Companion.getCurrent().getSettings().getShowZoomButtons());
        this.getStage().addActor(this.bottomUnitTable);
        this.getStage().addActor(this.bottomTileInfoTable);
        this.battleTable.setWidth(this.getStage().getWidth() / (float)3);
        this.battleTable.setX(this.getStage().getWidth() / (float)3);
        this.getStage().addActor(this.battleTable);
        this.getStage().addActor(this.unitActionsTable);
        if (Civilization.getCapital$default(this.viewingCiv, false, 1, null) != null) {
            City city2 = Civilization.getCapital$default(this.viewingCiv, false, 1, null);
            Intrinsics.checkNotNull(city2);
            vector2 = city2.getLocation();
        } else if (SequencesKt.any(this.viewingCiv.getUnits().getCivUnits())) {
            vector2 = SequencesKt.first(this.viewingCiv.getUnits().getCivUnits()).getTile().getPosition();
        } else {
            Vector2 vector22 = Vector2.Zero;
            vector2 = vector22;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
        }
        Vector2 tileToCenterOn = vector2;
        this.mapHolder.setAutoScrollEnabled(Gdx.app.getType() == Application.ApplicationType.Desktop && this.getGame().getSettings().getMapAutoScroll());
        this.mapHolder.setMapPanningSpeed(this.getGame().getSettings().getMapPanningSpeed());
        if (this.viewingCiv.isSpectator()) {
            WorldMapHolder.setCenterPosition$default(this.mapHolder, tileToCenterOn, true, false, null, 8, null);
        } else {
            WorldMapHolder.setCenterPosition$default(this.mapHolder, tileToCenterOn, true, true, null, 8, null);
        }
        this.getTutorialController().setAllTutorialsShowedCallback(new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setShouldUpdate(true);
            }
        });
        this.addKeyboardListener();
        this.addKeyboardPresses();
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer() && !this.gameInfo.isUpToDate()) {
            this.isPlayersTurn = false;
        }
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer()) {
            final String gameId = this.gameInfo.getGameId();
            this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdated.class), (Function1)new Function1<MultiplayerGameUpdated, Boolean>(){

                @Override
                @NotNull
                public final Boolean invoke(@NotNull MultiplayerGameUpdated it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it.getPreview().getGameId(), gameId);
                }
            }, (Function1)new Function1<MultiplayerGameUpdated, Unit>(){

                @Override
                public final void invoke(@NotNull MultiplayerGameUpdated it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (this.isNextTurnUpdateRunning$core() || this.getGame().getOnlineMultiplayer().hasLatestGameState(this.getGameInfo(), it.getPreview())) {
                        return;
                    }
                    Concurrency.run$default(Concurrency.INSTANCE, "Load latest multiplayer state", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ WorldScreen this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.label = 1;
                                    Object object3 = this.this$0.loadLatestMultiplayerState(this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure($result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Override
                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Override
                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 2, null);
                }
            });
        }
        if (restoreState != null) {
            this.restore(restoreState);
        }
        this.shouldUpdate = true;
    }

    public /* synthetic */ WorldScreen(GameInfo gameInfo2, AutoPlay autoPlay, Civilization civilization, RestoreState restoreState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            restoreState = null;
        }
        this(gameInfo2, autoPlay, civilization, restoreState);
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @NotNull
    public final AutoPlay getAutoPlay() {
        return this.autoPlay;
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    public final boolean getShouldUpdate() {
        return this.shouldUpdate;
    }

    public final void setShouldUpdate(boolean bl) {
        this.shouldUpdate = bl;
    }

    public final boolean isPlayersTurn() {
        return this.isPlayersTurn;
    }

    public final void setPlayersTurn$core(boolean bl) {
        this.isPlayersTurn = bl;
    }

    @NotNull
    public final Civilization getSelectedCiv() {
        return this.selectedCiv;
    }

    public final void setSelectedCiv(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.selectedCiv = civilization;
    }

    public final boolean getFogOfWar() {
        return this.fogOfWar;
    }

    public final void setFogOfWar(boolean bl) {
        this.fogOfWar = bl;
    }

    public final boolean getCanChangeState() {
        return this.isPlayersTurn && !this.viewingCiv.isSpectator();
    }

    @NotNull
    public final WorldMapHolder getMapHolder() {
        return this.mapHolder;
    }

    public final boolean getWaitingForAutosave$core() {
        return this.waitingForAutosave;
    }

    public final void setWaitingForAutosave$core(boolean bl) {
        this.waitingForAutosave = bl;
    }

    @NotNull
    public final WorldScreenTopBar getTopBar$core() {
        return this.topBar;
    }

    @NotNull
    public final TechPolicyDiplomacyButtons getTechPolicyAndDiplomacy$core() {
        return this.techPolicyAndDiplomacy;
    }

    @NotNull
    public final UnitTable getBottomUnitTable$core() {
        return this.bottomUnitTable;
    }

    @NotNull
    public final MinimapHolder getMinimapWrapper$core() {
        return this.minimapWrapper;
    }

    @NotNull
    public final NotificationsScroll getNotificationsScroll$core() {
        return this.notificationsScroll;
    }

    @NotNull
    public final NextTurnButton getNextTurnButton$core() {
        return this.nextTurnButton;
    }

    @NotNull
    public final UndoHandler getUndoHandler$core() {
        return this.undoHandler;
    }

    @Override
    public void dispose() {
        Timer timer2 = this.resizeDeferTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        this.events.stopReceiving();
        this.statusButtons.dispose();
        super.dispose();
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.gameInfo.getRuleset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openOptionsPopup(int startingPage, boolean withDebug, @NotNull Function0<Unit> onClose2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(onClose2, "onClose");
        DelayedRemovalArray<EventListener> delayedRemovalArray = this.getStage().getRoot().getListeners();
        Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "stage.root.listeners");
        Iterable $this$filterIsInstance$iv = delayedRemovalArray;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KeyboardPanningListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KeyboardPanningListener oldListener = (KeyboardPanningListener)CollectionsKt.firstOrNull((List)destination$iv$iv);
        if (oldListener != null) {
            this.getStage().removeListener(oldListener);
        }
        super.openOptionsPopup(startingPage, withDebug, new Function0<Unit>(this, onClose2){
            final /* synthetic */ WorldScreen this$0;
            final /* synthetic */ Function0<Unit> $onClose;
            {
                this.this$0 = $receiver;
                this.$onClose = $onClose;
                super(0);
            }

            public final void invoke() {
                WorldScreen.access$addKeyboardListener(this.this$0);
                this.$onClose.invoke();
            }
        });
    }

    public final void openEmpireOverview(@Nullable EmpireOverviewCategories category) {
        this.getGame().pushScreen(new EmpireOverviewScreen(this.selectedCiv, category, null, 4, null));
    }

    public static /* synthetic */ void openEmpireOverview$default(WorldScreen worldScreen, EmpireOverviewCategories empireOverviewCategories, int n, Object object) {
        if ((n & 1) != 0) {
            empireOverviewCategories = null;
        }
        worldScreen.openEmpireOverview(empireOverviewCategories);
    }

    public final void openNewGameScreen() {
        GameSetupInfo newGameSetupInfo = new GameSetupInfo(this.gameInfo);
        newGameSetupInfo.getMapParameters().reseed();
        NewGameScreen newGameScreen = new NewGameScreen(newGameSetupInfo);
        this.getGame().pushScreen(newGameScreen);
    }

    public final void openSaveGameScreen() {
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer()) {
            return;
        }
        this.getGame().pushScreen(new SaveGameScreen(this.gameInfo));
    }

    private final void addKeyboardPresses() {
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.DeselectOrQuit, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldScreen.access$backButtonAndESCHandler(this.this$0);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.Civilopedia, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BaseScreen.openCivilopedia$default(this.this$0, null, 1, null);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewTrades, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openEmpireOverview(EmpireOverviewCategories.Trades);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewUnits, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openEmpireOverview(EmpireOverviewCategories.Units);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewPolitics, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openEmpireOverview(EmpireOverviewCategories.Politics);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewNotifications, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openEmpireOverview(EmpireOverviewCategories.Notifications);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.VictoryScreen, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGame().pushScreen(new VictoryScreen(this.this$0, 0, 2, null));
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewStats, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openEmpireOverview(EmpireOverviewCategories.Stats);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewResources, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openEmpireOverview(EmpireOverviewCategories.Resources);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.QuickSave, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                QuickSave.INSTANCE.save(this.this$0.getGameInfo(), this.this$0);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.QuickLoad, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                QuickSave.INSTANCE.load(this.this$0);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ViewCapitalCity, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                City capital = Civilization.getCapital$default(this.this$0.getGameInfo().getCurrentPlayerCivilization(), false, 1, null);
                if (capital != null && !WorldMapHolder.setCenterPosition$default(this.this$0.getMapHolder(), capital.getLocation(), false, false, null, 14, null)) {
                    this.this$0.getGame().pushScreen(new CityScreen(capital, null, null, null, 14, null));
                }
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.Options, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BaseScreen.openOptionsPopup$default(this.this$0, 0, false, new Function0<Unit>(this.this$0){
                    final /* synthetic */ WorldScreen this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getNextTurnButton$core().update();
                    }
                }, 3, null);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.SaveGame, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openSaveGameScreen();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.LoadGame, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGame().pushScreen(new LoadGameScreen());
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.QuitGame, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGame().popScreen();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.NewGame, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.openNewGameScreen();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.MusicPlayer, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                new WorldScreenMusicPopup(this.this$0).open(true);
            }
        }, 2, null);
        this.getGlobalShortcuts().add(157, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ZoomableScrollPane.zoomIn$default(this.this$0.getMapHolder(), false, 1, null);
            }
        });
        this.getGlobalShortcuts().add(156, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ZoomableScrollPane.zoomOut$default(this.this$0.getMapHolder(), false, 1, null);
            }
        });
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleUI, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldScreen.access$toggleUI(this.this$0);
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleResourceDisplay, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getMinimapWrapper$core().getResourceImageButton().toggle();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleYieldDisplay, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getMinimapWrapper$core().getYieldImageButton().toggle();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleWorkedTilesDisplay, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getMinimapWrapper$core().getPopulationImageButton().toggle();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleMovementDisplay, 0, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getMinimapWrapper$core().getMovementsImageButton().toggle();
            }
        }, 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.DeveloperConsole, 0, new Function0<Unit>((Object)this){

            public final void invoke() {
                ((WorldScreen)this.receiver).openDeveloperConsole();
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void openDeveloperConsole() {
        boolean bl;
        Iterable $this$count$iv = this.gameInfo.getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            bl = false;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl2 = false;
                if (!it.isHuman() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            bl = var3_3;
        }
        if (bl > true) {
            return;
        }
        new DevConsolePopup(this);
    }

    private final void toggleUI() {
        this.uiEnabled = !this.uiEnabled;
        this.topBar.setVisible(this.uiEnabled);
        this.statusButtons.setVisible(this.uiEnabled);
        this.techPolicyAndDiplomacy.setVisible(this.uiEnabled);
        this.tutorialTaskTable.setVisible(this.uiEnabled);
        this.bottomTileInfoTable.setVisible(this.uiEnabled);
        this.unitActionsTable.setVisible(this.uiEnabled);
        this.notificationsScroll.setVisible(this.uiEnabled);
        this.minimapWrapper.setVisible(this.uiEnabled);
        this.bottomUnitTable.setVisible(this.uiEnabled);
        if (this.uiEnabled) {
            this.battleTable.update();
        } else {
            this.battleTable.setVisible(false);
        }
    }

    private final void addKeyboardListener() {
        this.getStage().addListener(new KeyboardPanningListener(this.mapHolder, true));
    }

    @Override
    @NotNull
    public Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> getShortcutDispatcherVetoer() {
        return KeyShortcutDispatcherVeto.INSTANCE.createTileGroupMapDispatcherVetoer();
    }

    private final Object loadLatestMultiplayerState(Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        if (!Intrinsics.areEqual(this.this$0.getGame().getScreen(), this.this$0)) {
                            return Unit.INSTANCE;
                        }
                        loadingGamePopup = new Popup(this.this$0, null, 0.0f, 6, null);
                        ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loadingGamePopup, null){
                            int label;
                            final /* synthetic */ Popup $loadingGamePopup;
                            {
                                this.$loadingGamePopup = $loadingGamePopup;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        Popup.addGoodSizedLabel$default(this.$loadingGamePopup, "Loading latest game state...", 0, false, 6, null);
                                        Popup.open$default(this.$loadingGamePopup, false, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        var4_5 = new Object[]{this.this$0.getGameInfo().getGameId(), Boxing.boxInt(this.this$0.getGameInfo().getTurns()), this.this$0.getGameInfo().getCurrentPlayer()};
                        LogKt.debug("loadLatestMultiplayerState current game: gameId: %s, turn: %s, curCiv: %s", var4_5);
                        this.L$0 = $this$coroutineScope;
                        this.L$1 = loadingGamePopup;
                        this.label = 1;
                        v0 = this.this$0.getGame().getOnlineMultiplayer().downloadGame(this.this$0.getGameInfo().getGameId(), this);
                        ** if (v0 != var6_2) goto lbl21
lbl20:
                        // 1 sources

                        return var6_2;
lbl21:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        loadingGamePopup = (Popup)this.L$1;
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl29:
                            // 2 sources

                            latestGame = (GameInfo)v0;
                            var5_7 = new Object[]{latestGame.getGameId(), Boxing.boxInt(latestGame.getTurns()), latestGame.getCurrentPlayer()};
                            LogKt.debug("loadLatestMultiplayerState downloaded game: gameId: %s, turn: %s, curCiv: %s", var5_7);
                            if (Intrinsics.areEqual(this.this$0.getViewingCiv().getCivName(), latestGame.getCurrentPlayer()) || Intrinsics.areEqual(this.this$0.getViewingCiv().getCivName(), "Spectator")) {
                                this.this$0.getGame().notifyTurnStarted();
                            }
                            ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loadingGamePopup, null){
                                int label;
                                final /* synthetic */ Popup $loadingGamePopup;
                                {
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$loadingGamePopup.close();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            WorldScreenKt.startNewScreenJob$default(latestGame, this.this$0.getAutoPlay(), false, 4, null);
                        }
                        catch (Throwable ex) {
                            ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ex, loadingGamePopup, this.this$0, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ Throwable $ex;
                                final /* synthetic */ Popup $loadingGamePopup;
                                final /* synthetic */ WorldScreen this$0;
                                {
                                    this.$ex = $ex;
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            CoroutineScope $this$launchOnGLThread = (CoroutineScope)this.L$0;
                                            String message2 = LoadGameScreen.Companion.getLoadExceptionMessage(this.$ex, "Couldn't download the latest game state!").component1();
                                            this.$loadingGamePopup.clear();
                                            Popup.addGoodSizedLabel$default(this.$loadingGamePopup, message2, 0, false, 6, null).colspan(2).row();
                                            Popup.addButton$default(this.$loadingGamePopup, "Retry", null, null, (Function0)new Function0<Unit>($this$launchOnGLThread, this.this$0){
                                                final /* synthetic */ CoroutineScope $$this$launchOnGLThread;
                                                final /* synthetic */ WorldScreen this$0;
                                                {
                                                    this.$$this$launchOnGLThread = $$this$launchOnGLThread;
                                                    this.this$0 = $receiver;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    ConcurrencyKt.launchOnThreadPool(this.$$this$launchOnGLThread, "Load latest multiplayer state after error", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                        int label;
                                                        final /* synthetic */ WorldScreen this$0;
                                                        {
                                                            this.this$0 = $receiver;
                                                            super(2, $completion);
                                                        }

                                                        /*
                                                         * WARNING - void declaration
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object object) {
                                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure(object);
                                                                    this.label = 1;
                                                                    Object object3 = WorldScreen.access$loadLatestMultiplayerState(this.this$0, this);
                                                                    if (object3 != object2) return Unit.INSTANCE;
                                                                    return object2;
                                                                }
                                                                case 1: {
                                                                    void $result;
                                                                    ResultKt.throwOnFailure($result);
                                                                    Object object3 = $result;
                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                                        }

                                                        @Nullable
                                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    });
                                                }
                                            }, 6, null).right();
                                            Popup.addButton$default(this.$loadingGamePopup, "Main menu", null, null, (Function0)new Function0<Unit>(this.this$0){
                                                final /* synthetic */ WorldScreen this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    this.this$0.getGame().pushScreen(new MainMenuScreen());
                                                }
                                            }, 6, null).left();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    function2.L$0 = value;
                                    return (Continuation)((Object)function2);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void update() {
        if (this.uiEnabled) {
            this.displayTutorialsOnUpdate();
            this.bottomUnitTable.update();
            this.updateSelectedCiv();
            if (this.fogOfWar) {
                this.minimapWrapper.update(this.selectedCiv);
            } else {
                this.minimapWrapper.update(this.viewingCiv);
            }
            if (this.fogOfWar) {
                this.bottomTileInfoTable.setSelectedCiv(this.selectedCiv);
            } else {
                this.bottomTileInfoTable.setSelectedCiv(this.viewingCiv);
            }
            this.bottomTileInfoTable.updateTileTable$core(this.mapHolder.getSelectedTile$core());
            this.bottomTileInfoTable.setX(this.getStage().getWidth() - this.bottomTileInfoTable.getWidth());
            this.bottomTileInfoTable.setY(this.getGame().getSettings().getShowMinimap() ? this.minimapWrapper.getHeight() : 0.0f);
            this.battleTable.update();
            this.displayTutorialTaskOnUpdate();
        }
        this.mapHolder.resetArrows();
        if (UncivGame.Companion.getCurrent().getSettings().getShowUnitMovements()) {
            Sequence allUnits2 = SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), update.allUnits.1.INSTANCE);
            Sequence allAttacks2 = SequencesKt.plus(SequencesKt.flatten(SequencesKt.map(allUnits2, update.allAttacks.1.INSTANCE)), SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), update.allAttacks.2.INSTANCE));
            this.mapHolder.updateMovementOverlay$core(SequencesKt.filter(allUnits2, (Function1)new Function1<MapUnit, Boolean>((Object)this.mapVisualization){

                @NotNull
                public final Boolean invoke(@NotNull MapUnit p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((MapVisualization)this.receiver).isUnitPastVisible(p0);
                }
            }), SequencesKt.filter(allUnits2, (Function1)new Function1<MapUnit, Boolean>((Object)this.mapVisualization){

                @NotNull
                public final Boolean invoke(@NotNull MapUnit p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((MapVisualization)this.receiver).isUnitFutureVisible(p0);
                }
            }), SequencesKt.map(SequencesKt.filter(allAttacks2, (Function1)new Function1<Triple<? extends Civilization, ? extends Vector2, ? extends Vector2>, Boolean>(this){
                final /* synthetic */ WorldScreen this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Triple<Civilization, ? extends Vector2, ? extends Vector2> triple) {
                    Intrinsics.checkNotNullParameter(triple, "<name for destructuring parameter 0>");
                    Civilization attacker = triple.component1();
                    Vector2 source = triple.component2();
                    Vector2 target = triple.component3();
                    return WorldScreen.access$getMapVisualization$p(this.this$0).isAttackVisible(attacker, source, target);
                }
            }), update.4.INSTANCE));
        }
        this.zoomController.setVisible(UncivGame.Companion.getCurrent().getSettings().getShowZoomButtons());
        if (this.fogOfWar) {
            this.mapHolder.updateTiles$core(this.selectedCiv);
        } else {
            this.mapHolder.updateTiles$core(this.viewingCiv);
        }
        this.topBar.update$core(this.selectedCiv);
        if (this.tutorialTaskTable.isVisible()) {
            this.tutorialTaskTable.setY(this.topBar.getYForTutorialTask$core() - this.tutorialTaskTable.getHeight());
        }
        if (this.techPolicyAndDiplomacy.update()) {
            BaseScreen.displayTutorial$default(this, TutorialTrigger.OtherCivEncountered, null, 2, null);
        }
        if (this.uiEnabled) {
            this.unitActionsTable.setY(this.bottomUnitTable.getHeight());
            this.unitActionsTable.update(this.bottomUnitTable.getSelectedUnit());
        }
        if (this.autoPlay.isAutoPlaying() && !this.gameInfo.getOneMoreTurnMode() && (this.viewingCiv.isDefeated() || this.gameInfo.checkForVictory())) {
            this.autoPlay.stopAutoPlay();
        }
        if (!PopupKt.hasOpenPopups(this) && !this.autoPlay.isAutoPlaying() && this.isPlayersTurn) {
            if (this.viewingCiv.shouldShowDiplomaticVotingResults()) {
                UncivGame.Companion.getCurrent().pushScreen(new DiplomaticVoteResultScreen(this.gameInfo.getDiplomaticVictoryVotesCast(), this.viewingCiv));
            } else if (!this.gameInfo.getOneMoreTurnMode() && (this.viewingCiv.isDefeated() || this.gameInfo.checkForVictory())) {
                this.getGame().pushScreen(new VictoryScreen(this, 0, 2, null));
            } else if (this.viewingCiv.getGreatPeople().getFreeGreatPeople() > 0) {
                this.getGame().pushScreen(new GreatPersonPickerScreen(this, this.viewingCiv));
            } else if (CollectionsKt.any((Iterable)this.viewingCiv.getPopupAlerts())) {
                new AlertPopup(this, (PopupAlert)CollectionsKt.first((List)this.viewingCiv.getPopupAlerts()));
            } else if (!((Collection)this.viewingCiv.getTradeRequests()).isEmpty()) {
                for (TradeRequest tradeRequest : CollectionsKt.toList((Iterable)this.viewingCiv.getTradeRequests())) {
                    if (new TradeEvaluation().isTradeValid(tradeRequest.getTrade(), this.viewingCiv, this.gameInfo.getCivilization(tradeRequest.getRequestingCiv()))) continue;
                    this.viewingCiv.getTradeRequests().remove(tradeRequest);
                }
                if (!((Collection)this.viewingCiv.getTradeRequests()).isEmpty()) {
                    Popup.open$default(new TradePopup(this), false, 1, null);
                }
            }
        }
        this.updateGameplayButtons();
        float coveredNotificationsTop = this.getStage().getHeight() - this.statusButtons.getY();
        float coveredNotificationsBottom = this.bottomTileInfoTable.getHeight() + (this.getGame().getSettings().getShowMinimap() ? this.minimapWrapper.getHeight() : 0.0f);
        this.notificationsScroll.update$core((List<Notification>)this.viewingCiv.getNotifications(), coveredNotificationsTop, coveredNotificationsBottom);
        float posZoomFromRight = this.getGame().getSettings().getShowMinimap() ? this.minimapWrapper.getWidth() : this.bottomTileInfoTable.getWidth();
        this.zoomController.setPosition(this.getStage().getWidth() - posZoomFromRight - 10.0f, 10.0f, 20);
    }

    private final Event getCurrentTutorialTask() {
        Object v3;
        block7: {
            if (!this.getGame().getSettings().getTutorialTasksCompleted().contains("Create a trade route")) {
                boolean bl;
                block6: {
                    Map<City, Set<String>> $this$any$iv = this.viewingCiv.getCache().getCitiesConnectedToCapitalToMediums();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<Map.Entry<City, Set<String>>> iterator2 = $this$any$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<City, Set<String>> element$iv;
                            Map.Entry<City, Set<String>> it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getKey().getCiv(), this.viewingCiv)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.getGame().getSettings().addCompletedTutorialTask("Create a trade route");
                }
            }
            StateForConditionals stateForConditionals = new StateForConditionals(this.viewingCiv, null, null, null, null, null, null, null, null, false, 1022, null);
            Collection<Event> collection = this.gameInfo.getRuleset().getEvents().values();
            Intrinsics.checkNotNullExpressionValue(collection, "gameInfo.ruleset.events.values");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Event it = (Event)element$iv;
                boolean bl = false;
                boolean bl3 = it.getPresentation() == Event.Presentation.Floating && it.isAvailable(stateForConditionals);
                if (!bl3) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        return v3;
    }

    private final void displayTutorialsOnUpdate() {
        BaseScreen.displayTutorial$default(this, TutorialTrigger.Introduction, null, 2, null);
        this.displayTutorial(TutorialTrigger.EnemyCityNeedsConqueringWithMeleeUnit, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    void $this$any$iv;
                    Collection<DiplomacyManager> collection = this.this$0.getViewingCiv().getDiplomacy().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "viewingCiv.diplomacy.values");
                    Sequence<R> sequence = SequencesKt.flatMap(SequencesKt.filter(SequencesKt.flatMap(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), displayTutorialsOnUpdate.1.INSTANCE), displayTutorialsOnUpdate.2.INSTANCE), displayTutorialsOnUpdate.3.INSTANCE), displayTutorialsOnUpdate.4.INSTANCE), displayTutorialsOnUpdate.5.INSTANCE);
                    WorldScreen worldScreen = this.this$0;
                    boolean $i$f$any = false;
                    for (T element$iv : $this$any$iv) {
                        boolean bl2;
                        block2: {
                            Tile it = (Tile)element$iv;
                            boolean bl3 = false;
                            Sequence<MapUnit> $this$any$iv2 = it.getUnits();
                            boolean $i$f$any2 = false;
                            Iterator<MapUnit> iterator2 = $this$any$iv2.iterator();
                            while (iterator2.hasNext()) {
                                MapUnit element$iv2;
                                MapUnit unit = element$iv2 = iterator2.next();
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual(unit.getCiv(), worldScreen.getViewingCiv())) continue;
                                bl2 = true;
                                break block2;
                            }
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.AfterConquering, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.this$0.getViewingCiv().getCities();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            City it = (City)element$iv;
                            boolean bl2 = false;
                            if (!it.getHasJustBeenConquered()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.InjuredUnits, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<MapUnit> $this$any$iv = this.this$0.getGameInfo().getCurrentPlayerCivilization().getUnits().getCivUnits();
                    boolean $i$f$any = false;
                    Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        MapUnit element$iv;
                        MapUnit it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(it.getHealth() < 100)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.Workers, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<MapUnit> $this$any$iv = this.this$0.getGameInfo().getCurrentPlayerCivilization().getUnits().getCivUnits();
                    boolean $i$f$any = false;
                    Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        MapUnit element$iv;
                        MapUnit it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(it.getCache().getHasUniqueToBuildImprovements() && it.isCivilian() && !it.isGreatPerson())) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void displayTutorialTaskOnUpdate() {
        if (!this.getGame().getSettings().getShowTutorials() || this.viewingCiv.isDefeated()) {
            WorldScreen.displayTutorialTaskOnUpdate$setInvisible(this);
            return;
        }
        Event event = this.getCurrentTutorialTask();
        if (event == null) {
            WorldScreen.displayTutorialTaskOnUpdate$setInvisible(this);
            return;
        }
        Event tutorialTask = event;
        if (!UncivGame.Companion.getCurrent().isTutorialTaskCollapsed()) {
            int hash = tutorialTask.hashCode();
            if (hash != this.tutorialTaskTableHash) {
                RenderEvent renderEvent2 = new RenderEvent(tutorialTask, this, (Function1<? super EventChoice, Unit>)new Function1<EventChoice, Unit>(this){
                    final /* synthetic */ WorldScreen this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull EventChoice it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        this.this$0.setShouldUpdate(true);
                    }
                });
                if (!renderEvent2.isValid()) {
                    WorldScreen.displayTutorialTaskOnUpdate$setInvisible(this);
                    return;
                }
                this.tutorialTaskTable.clear();
                this.tutorialTaskTable.add((Actor)renderEvent2).pad(10.0f);
                this.tutorialTaskTableHash = hash;
            }
        } else {
            void $this$displayTutorialTaskOnUpdate_u24lambda_u244;
            Image image2;
            this.tutorialTaskTable.clear();
            Image renderEvent2 = image2 = ImageGetter.INSTANCE.getImage("OtherIcons/HiddenTutorialTask");
            Table table2 = this.tutorialTaskTable;
            boolean bl = false;
            $this$displayTutorialTaskOnUpdate_u24lambda_u244.setSize(30.0f, 30.0f);
            table2.add((Actor)image2).pad(5.0f);
            this.tutorialTaskTableHash = 0;
        }
        this.tutorialTaskTable.pack();
        Scene2dExtensionsKt.centerX((Actor)this.tutorialTaskTable, this.getStage());
        this.tutorialTaskTable.setY(this.topBar.getYForTutorialTask$core() - this.tutorialTaskTable.getHeight());
        ActivationExtensionsKt.onClick(this.tutorialTaskTable, new Function0<Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                UncivGame.Companion.getCurrent().setTutorialTaskCollapsed(!UncivGame.Companion.getCurrent().isTutorialTaskCollapsed());
                WorldScreen.access$displayTutorialTaskOnUpdate(this.this$0);
            }
        });
        this.tutorialTaskTable.setVisible(true);
    }

    private final void updateSelectedCiv() {
        Civilization civilization;
        if (this.bottomUnitTable.getSelectedUnit() != null) {
            MapUnit mapUnit = this.bottomUnitTable.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            civilization = mapUnit.getCiv();
        } else if (this.bottomUnitTable.getSelectedCity() != null) {
            City city2 = this.bottomUnitTable.getSelectedCity();
            Intrinsics.checkNotNull(city2);
            civilization = city2.getCiv();
        } else {
            civilization = this.viewingCiv;
        }
        this.selectedCiv = civilization;
    }

    @NotNull
    public final RestoreState getRestoreState() {
        return new RestoreState(this.mapHolder, this.selectedCiv.getCivName(), this.viewingCiv.getCivName(), this.fogOfWar);
    }

    private final void restore(RestoreState restoreState) {
        if (Intrinsics.areEqual(this.viewingCiv.getCivName(), restoreState.getViewingCivName())) {
            this.mapHolder.zoom(restoreState.getZoom());
            this.mapHolder.setScrollX(restoreState.getScrollX());
            this.mapHolder.setScrollY(restoreState.getScrollY());
            this.mapHolder.updateVisualScroll();
        }
        this.selectedCiv = this.gameInfo.getCivilization(restoreState.getSelectedCivName());
        this.fogOfWar = restoreState.getFogOfWar();
    }

    public final void nextTurn() {
        this.isPlayersTurn = false;
        this.shouldUpdate = true;
        NextTurnProgress progressBar = new NextTurnProgress(this.nextTurnButton);
        progressBar.start(this);
        this.nextTurnUpdateJob = Concurrency.INSTANCE.runOnNonDaemonThreadPool("NextTurn", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, progressBar, null){
            Object L$1;
            Object L$2;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WorldScreen this$0;
            final /* synthetic */ NextTurnProgress $progressBar;
            {
                this.this$0 = $receiver;
                this.$progressBar = $progressBar;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        LogKt.debug("Next turn starting", new Object[0]);
                        startTime = System.currentTimeMillis();
                        originalGameInfo = this.this$0.getGameInfo();
                        gameInfoClone = originalGameInfo.clone();
                        gameInfoClone.setTransients();
                        this.$progressBar.increment();
                        gameInfoClone.nextTurn(this.$progressBar);
                        if (originalGameInfo.getGameParameters().isOnlineMultiplayer()) {
                            this.L$0 = $this$runOnNonDaemonThreadPool;
                            this.L$1 = originalGameInfo;
                            this.L$2 = gameInfoClone;
                            this.J$0 = startTime;
                            this.label = 1;
                            v0 = this.this$0.getGame().getOnlineMultiplayer().updateGame(gameInfoClone, this);
                            ** if (v0 != var14_2) goto lbl24
lbl23:
                            // 1 sources

                            return var14_2;
                        }
lbl24:
                        // 3 sources

                        ** GOTO lbl52
                    }
                    case 1: {
                        startTime = this.J$0;
                        gameInfoClone = (GameInfo)this.L$2;
                        originalGameInfo = (GameInfo)this.L$1;
                        $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
                        }
                        catch (Exception ex) {
                            var8_9 = ex;
                            if (var8_9 instanceof MultiplayerAuthException) {
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ WorldScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                new AuthPopup(this.this$0, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(this.this$0){
                                                    final /* synthetic */ WorldScreen this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(1);
                                                    }

                                                    public final void invoke(boolean success) {
                                                        if (success) {
                                                            this.this$0.nextTurn();
                                                        }
                                                    }
                                                }).open(true);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            } else if (var8_9 instanceof FileStorageRateLimitReached) {
                                message = "Server limit reached! Please wait for [" + ((FileStorageRateLimitReached)ex).getLimitRemainingSeconds() + "] seconds";
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, message, null){
                                    int label;
                                    final /* synthetic */ WorldScreen this$0;
                                    final /* synthetic */ String $message;
                                    {
                                        this.this$0 = $receiver;
                                        this.$message = $message;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                Popup cantUploadNewGamePopup = new Popup(this.this$0, null, 0.0f, 6, null);
                                                Popup.addGoodSizedLabel$default(cantUploadNewGamePopup, this.$message, 0, false, 6, null).row();
                                                Popup.addCloseButton$default(cantUploadNewGamePopup, null, null, null, null, 15, null);
                                                Popup.open$default(cantUploadNewGamePopup, false, 1, null);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            } else {
                                message = "Could not upload game!";
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, message, null){
                                    int label;
                                    final /* synthetic */ WorldScreen this$0;
                                    final /* synthetic */ String $message;
                                    {
                                        this.this$0 = $receiver;
                                        this.$message = $message;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                Popup cantUploadNewGamePopup = new Popup(this.this$0, null, 0.0f, 6, null);
                                                Popup.addGoodSizedLabel$default(cantUploadNewGamePopup, this.$message, 0, false, 6, null).row();
                                                Popup.addCloseButton$default(cantUploadNewGamePopup, null, null, null, null, 15, null);
                                                Popup.open$default(cantUploadNewGamePopup, false, 1, null);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            }
                            this.this$0.setPlayersTurn$core(true);
                            this.this$0.setShouldUpdate(true);
                            return Unit.INSTANCE;
                        }
lbl52:
                        // 2 sources

                        if (!Intrinsics.areEqual(this.this$0.getGame().getGameInfo(), originalGameInfo)) {
                            return Unit.INSTANCE;
                        }
                        ex = new Object[]{Boxing.boxLong(System.currentTimeMillis() - startTime)};
                        LogKt.debug("Next turn took %sms", ex);
                        if (this.this$0.getGameInfo().getGameParameters().isOnlineMultiplayer()) {
                            $this$count$iv = gameInfoClone.getCivilizations();
                            $i$f$count = false;
                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                v1 = 0;
                            } else {
                                count$iv = 0;
                                for (T element$iv : $this$count$iv) {
                                    it = (Civilization)element$iv;
                                    $i$a$-count-WorldScreen$nextTurn$1$4 = false;
                                    if (!(it.isAlive() != false && it.getPlayerType() == PlayerType.Human) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                v1 = count$iv;
                            }
                            if (v1 == 1) {
                                gameInfoClone.setUpToDate(true);
                            }
                        }
                        this.$progressBar.increment();
                        WorldScreenKt.startNewScreenJob$default(gameInfoClone, this.this$0.getAutoPlay(), false, 4, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void switchToNextUnit() {
        MapUnit nextDueUnit;
        if (this.bottomUnitTable.getSelectedUnit() != null) {
            MapUnit mapUnit = this.bottomUnitTable.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            mapUnit.setDue(false);
        }
        if ((nextDueUnit = this.viewingCiv.getUnits().cycleThroughDueUnits(this.bottomUnitTable.getSelectedUnit())) != null) {
            WorldMapHolder.setCenterPosition$default(this.mapHolder, nextDueUnit.getCurrentTile().getPosition(), false, false, null, 8, null);
            UnitTable.selectUnit$default(this.bottomUnitTable, nextDueUnit, false, 2, null);
        } else {
            this.mapHolder.removeAction(this.mapHolder.getBlinkAction());
            this.mapHolder.setSelectedTile$core(null);
            UnitTable.selectUnit$default(this.bottomUnitTable, null, false, 3, null);
        }
        this.shouldUpdate = true;
    }

    public final boolean isNextTurnUpdateRunning$core() {
        Job job2 = this.nextTurnUpdateJob;
        return job2 != null && job2.isActive();
    }

    private final void updateGameplayButtons() {
        this.nextTurnButton.update();
        this.updateAutoPlayStatusButton();
        this.updateMultiplayerStatusButton();
        this.statusButtons.wrap(false);
        this.statusButtons.pack();
        float maxWidth = this.getStage().getWidth() - this.techPolicyAndDiplomacy.getWidth() - 25.0f;
        if (this.statusButtons.getWidth() > maxWidth) {
            this.statusButtons.setWidth(maxWidth);
            this.statusButtons.wrap();
            this.statusButtons.pack();
        }
        this.statusButtons.setPosition(this.getStage().getWidth() - this.statusButtons.getWidth() - 10.0f, this.topBar.getY() - this.statusButtons.getHeight() - 10.0f);
    }

    private final void updateAutoPlayStatusButton() {
        if (this.statusButtons.getAutoPlayStatusButton() == null) {
            if (this.getGame().getSettings().getAutoPlay().getShowAutoPlayButton()) {
                this.statusButtons.setAutoPlayStatusButton(new AutoPlayStatusButton(this, this.nextTurnButton));
            }
        } else if (!this.getGame().getSettings().getAutoPlay().getShowAutoPlayButton()) {
            this.statusButtons.setAutoPlayStatusButton(null);
            this.autoPlay.stopAutoPlay();
        }
    }

    private final void updateMultiplayerStatusButton() {
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer() || this.getGame().getSettings().getMultiplayer().getStatusButtonInSinglePlayer()) {
            if (this.statusButtons.getMultiplayerStatusButton() != null) {
                return;
            }
            this.statusButtons.setMultiplayerStatusButton(new MultiplayerStatusButton(this, this.getGame().getOnlineMultiplayer().getGameByGameId(this.gameInfo.getGameId())));
        } else {
            if (this.statusButtons.getMultiplayerStatusButton() == null) {
                return;
            }
            this.statusButtons.setMultiplayerStatusButton(null);
        }
    }

    @Override
    public void resize(int width, int height) {
        Timer timer2;
        Timer timer3 = this.resizeDeferTimer;
        if (timer3 != null) {
            timer3.cancel();
        }
        if (this.resizeDeferTimer == null && this.getStage().getViewport().getScreenWidth() == width && this.getStage().getViewport().getScreenHeight() == height) {
            return;
        }
        String string = "Resize";
        boolean bl = true;
        long l = 500L;
        long l2 = Long.MAX_VALUE;
        Timer timer4 = timer2 = TimersKt.timer(string, bl);
        timer4.schedule(new TimerTask(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = worldScreen;
            }

            public void run() {
                TimerTask $this$resize_u24lambda_u245 = this;
                boolean bl = false;
                Timer timer2 = WorldScreen.access$getResizeDeferTimer$p(this.this$0);
                if (timer2 != null) {
                    timer2.cancel();
                }
                WorldScreen.access$setResizeDeferTimer$p(this.this$0, null);
                WorldScreenKt.access$startNewScreenJob(this.this$0.getGameInfo(), this.this$0.getAutoPlay(), true);
            }
        }, l, l2);
        this.resizeDeferTimer = timer2;
    }

    @Override
    public void render(float delta) {
        if (this.shouldUpdate && this.resizeDeferTimer == null) {
            this.shouldUpdate = false;
            Gdx.input.setInputProcessor(null);
            this.update();
            this.showTutorialsOnNextTurn();
            if (Gdx.input.getInputProcessor() == null) {
                Gdx.input.setInputProcessor(this.getStage());
            }
        }
        super.render(delta);
    }

    private final void showTutorialsOnNextTurn() {
        if (!this.getGame().getSettings().getShowTutorials()) {
            return;
        }
        BaseScreen.displayTutorial$default(this, TutorialTrigger.SlowStart, null, 2, null);
        this.displayTutorial(TutorialTrigger.CityExpansion, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.this$0.getViewingCiv().getCities();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            City it = (City)element$iv;
                            boolean bl2 = false;
                            if (!(it.getExpansion().tilesClaimed() > 0)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.BarbarianEncountered, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block5: {
                    Iterable $this$any$iv = this.this$0.getViewingCiv().getViewableTiles();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl2;
                            block4: {
                                Tile it = (Tile)element$iv;
                                boolean bl3 = false;
                                Sequence<MapUnit> $this$any$iv2 = it.getUnits();
                                boolean $i$f$any2 = false;
                                Iterator<MapUnit> iterator2 = $this$any$iv2.iterator();
                                while (iterator2.hasNext()) {
                                    MapUnit element$iv2;
                                    MapUnit unit = element$iv2 = iterator2.next();
                                    boolean bl4 = false;
                                    if (!unit.getCiv().isBarbarian()) continue;
                                    bl2 = true;
                                    break block4;
                                }
                                bl2 = false;
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.RoadsAndRailroads, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getViewingCiv().getCities().size() > 2;
            }
        });
        this.displayTutorial(TutorialTrigger.Happiness, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getViewingCiv().getHappiness() < 5;
            }
        });
        this.displayTutorial(TutorialTrigger.Unhappiness, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getViewingCiv().getHappiness() < 0;
            }
        });
        this.displayTutorial(TutorialTrigger.GoldenAge, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getViewingCiv().getGoldenAges().isGoldenAge();
            }
        });
        this.displayTutorial(TutorialTrigger.IdleUnits, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getGameInfo().getTurns() >= 50 && this.this$0.getGame().getSettings().getCheckForDueUnits();
            }
        });
        this.displayTutorial(TutorialTrigger.ContactMe, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getGameInfo().getTurns() >= 100;
            }
        });
        Sequence<ResourceSupplyList.ResourceSupply> resources2 = SequencesKt.filter(CollectionsKt.asSequence(this.viewingCiv.getDetailedCivResources()), showTutorialsOnNextTurn.resources.1.INSTANCE);
        this.displayTutorial(TutorialTrigger.LuxuryResource, new Function0<Boolean>(resources2){
            final /* synthetic */ Sequence<ResourceSupplyList.ResourceSupply> $resources;
            {
                this.$resources = $resources;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<ResourceSupplyList.ResourceSupply> $this$any$iv = this.$resources;
                    boolean $i$f$any = false;
                    Iterator<ResourceSupplyList.ResourceSupply> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        ResourceSupplyList.ResourceSupply element$iv;
                        ResourceSupplyList.ResourceSupply it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(it.getResource().getResourceType() == ResourceType.Luxury)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.StrategicResource, new Function0<Boolean>(resources2){
            final /* synthetic */ Sequence<ResourceSupplyList.ResourceSupply> $resources;
            {
                this.$resources = $resources;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<ResourceSupplyList.ResourceSupply> $this$any$iv = this.$resources;
                    boolean $i$f$any = false;
                    Iterator<ResourceSupplyList.ResourceSupply> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        ResourceSupplyList.ResourceSupply element$iv;
                        ResourceSupplyList.ResourceSupply it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(it.getResource().getResourceType() == ResourceType.Strategic)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.EnemyCity, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    void $this$any$iv;
                    Sequence<R> sequence = SequencesKt.flatMap(SequencesKt.filter(this.this$0.getViewingCiv().getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this.this$0){
                        final /* synthetic */ WorldScreen this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Civilization it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return this.this$0.getViewingCiv().isAtWarWith(it);
                        }
                    }), showTutorialsOnNextTurn.2.INSTANCE);
                    WorldScreen worldScreen = this.this$0;
                    boolean $i$f$any = false;
                    for (T element$iv : $this$any$iv) {
                        City it = (City)element$iv;
                        boolean bl2 = false;
                        if (!worldScreen.getViewingCiv().hasExplored(it.getCenterTile())) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.ApolloProgram, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Civilization.hasUnique$default(this.this$0.getViewingCiv(), UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null);
            }
        });
        this.displayTutorial(TutorialTrigger.SiegeUnits, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block1: {
                    Sequence<MapUnit> $this$any$iv = this.this$0.getViewingCiv().getUnits().getCivUnits();
                    boolean $i$f$any = false;
                    Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        MapUnit element$iv;
                        MapUnit it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!it.getBaseUnit().isProbablySiegeUnit()) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        this.displayTutorial(TutorialTrigger.Embarking, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return Civilization.hasUnique$default(this.this$0.getViewingCiv(), UniqueType.LandUnitEmbarkation, null, 2, null);
            }
        });
        this.displayTutorial(TutorialTrigger.NaturalWonders, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getViewingCiv().getNaturalWonders().size() > 0;
            }
        });
        this.displayTutorial(TutorialTrigger.WeLoveTheKingDay, new Function0<Boolean>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = this.this$0.getViewingCiv().getCities();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            City it = (City)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual(it.getDemandedResource(), ""))) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        });
    }

    private final void backButtonAndESCHandler() {
        if (this.bottomUnitTable.getSelectedUnit() != null) {
            UnitTable.selectUnit$default(this.bottomUnitTable, null, false, 3, null);
            this.bottomUnitTable.setVisible(false);
            this.shouldUpdate = true;
            return;
        }
        if (this.bottomUnitTable.getSelectedCity() != null) {
            this.bottomUnitTable.setSelectedCity(null);
            this.bottomUnitTable.setVisible(false);
            this.shouldUpdate = true;
            return;
        }
        if (this.bottomUnitTable.getSelectedSpy() != null) {
            this.bottomUnitTable.selectSpy(null);
            this.shouldUpdate = true;
            return;
        }
        this.getGame().popScreen();
    }

    public final void autoSave() {
        this.waitingForAutosave = true;
        this.shouldUpdate = true;
        UncivGame.Companion.getCurrent().getFiles().getAutosaves().requestAutoSave(this.gameInfo, true).invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                this.this$0.setWaitingForAutosave$core(false);
                this.this$0.setShouldUpdate(true);
            }
        });
    }

    private static final void displayTutorialTaskOnUpdate$setInvisible(WorldScreen this$0) {
        this$0.tutorialTaskTable.setVisible(false);
        this$0.tutorialTaskTable.clear();
        this$0.tutorialTaskTableHash = 0;
    }

    public static final /* synthetic */ void access$addKeyboardListener(WorldScreen $this) {
        $this.addKeyboardListener();
    }

    public static final /* synthetic */ void access$backButtonAndESCHandler(WorldScreen $this) {
        $this.backButtonAndESCHandler();
    }

    public static final /* synthetic */ void access$toggleUI(WorldScreen $this) {
        $this.toggleUI();
    }

    public static final /* synthetic */ MapVisualization access$getMapVisualization$p(WorldScreen $this) {
        return $this.mapVisualization;
    }

    public static final /* synthetic */ void access$displayTutorialTaskOnUpdate(WorldScreen $this) {
        $this.displayTutorialTaskOnUpdate();
    }

    public static final /* synthetic */ Timer access$getResizeDeferTimer$p(WorldScreen $this) {
        return $this.resizeDeferTimer;
    }

    public static final /* synthetic */ void access$setResizeDeferTimer$p(WorldScreen $this, Timer timer2) {
        $this.resizeDeferTimer = timer2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldScreen$RestoreState;", "", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "selectedCivName", "", "viewingCivName", "fogOfWar", "", "(Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;Ljava/lang/String;Ljava/lang/String;Z)V", "getFogOfWar", "()Z", "scrollX", "", "getScrollX", "()F", "scrollY", "getScrollY", "getSelectedCivName", "()Ljava/lang/String;", "getViewingCivName", "zoom", "getZoom", "core"})
    public static final class RestoreState {
        @NotNull
        private final String selectedCivName;
        @NotNull
        private final String viewingCivName;
        private final boolean fogOfWar;
        private final float zoom;
        private final float scrollX;
        private final float scrollY;

        public RestoreState(@NotNull WorldMapHolder mapHolder2, @NotNull String selectedCivName, @NotNull String viewingCivName, boolean fogOfWar) {
            Intrinsics.checkNotNullParameter(mapHolder2, "mapHolder");
            Intrinsics.checkNotNullParameter(selectedCivName, "selectedCivName");
            Intrinsics.checkNotNullParameter(viewingCivName, "viewingCivName");
            this.selectedCivName = selectedCivName;
            this.viewingCivName = viewingCivName;
            this.fogOfWar = fogOfWar;
            this.zoom = mapHolder2.getScaleX();
            this.scrollX = mapHolder2.getScrollX();
            this.scrollY = mapHolder2.getScrollY();
        }

        @NotNull
        public final String getSelectedCivName() {
            return this.selectedCivName;
        }

        @NotNull
        public final String getViewingCivName() {
            return this.viewingCivName;
        }

        public final boolean getFogOfWar() {
            return this.fogOfWar;
        }

        public final float getZoom() {
            return this.zoom;
        }

        public final float getScrollX() {
            return this.scrollX;
        }

        public final float getScrollY() {
            return this.scrollY;
        }
    }
}

