/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.bottombar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileDescription;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.DebugUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002J\u0017\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u0010R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/TileInfoTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "selectedCiv", "Lcom/unciv/logic/civilization/Civilization;", "getSelectedCiv", "()Lcom/unciv/logic/civilization/Civilization;", "setSelectedCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "getStatsTable", "tile", "Lcom/unciv/logic/map/tile/Tile;", "updateTileTable", "", "updateTileTable$core", "core"})
public final class TileInfoTable
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private Civilization selectedCiv;

    public TileInfoTable(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.worldScreen = worldScreen;
        this.selectedCiv = this.worldScreen.getSelectedCiv();
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/TileInfoTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
    }

    @NotNull
    public final Civilization getSelectedCiv() {
        return this.selectedCiv;
    }

    public final void setSelectedCiv(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.selectedCiv = civilization;
    }

    public final void updateTileTable$core(@Nullable Tile tile) {
        this.clearChildren();
        if (tile != null && (DebugUtils.INSTANCE.getVISIBLE_MAP() || this.selectedCiv.hasExplored(tile))) {
            this.add((Actor)this.getStatsTable(tile));
            this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, TileDescription.INSTANCE.toMarkup(tile, this.selectedCiv), 0.0f, 0.0f, FormattedLine.IconDisplay.None, new Function1<String, Unit>(this){
                final /* synthetic */ TileInfoTable this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    TileInfoTable.access$getWorldScreen$p(this.this$0).openCivilopedia(it);
                }
            }, 2, null)).pad(5.0f).row();
            if (DebugUtils.INSTANCE.getVISIBLE_MAP()) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(FormattingExtensionsKt.toPrettyString(tile.getPosition()))).colspan(2).pad(5.0f);
            }
        }
        this.pack();
        Group group = this;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        Scene2dExtensionsKt.addBorderAllowOpacity(group, 1.0f, color);
    }

    private final Table getStatsTable(Tile tile) {
        Table table2 = new Table();
        table2.defaults().pad(2.0f);
        for (Stats.StatValuePair statValuePair : TileStatFunctions.getTileStats$default(tile.getStats(), this.selectedCiv, null, 2, null)) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            table2.add((Actor)ImageGetter.INSTANCE.getStatIcon(key.name())).size(20.0f).align(16).padLeft(10.0f);
            table2.add((Actor)Scene2dExtensionsKt.toLabel((int)value)).align(8).padRight(5.0f);
            table2.row();
        }
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, new Function0<Unit>(this, tile){
            final /* synthetic */ TileInfoTable this$0;
            final /* synthetic */ Tile $tile;
            {
                this.this$0 = $receiver;
                this.$tile = $tile;
                super(0);
            }

            public final void invoke() {
                Popup popup2 = new Popup(TileInfoTable.access$getWorldScreen$p(this.this$0), null, 0.0f, 6, null);
                Tile tile = this.$tile;
                TileInfoTable tileInfoTable = this.this$0;
                Popup $this$invoke_u24lambda_u240 = popup2;
                boolean bl = false;
                for (Pair pair : TileStatFunctions.getTileStatsBreakdown$default(tile.getStats(), tile.getCity(), tileInfoTable.getSelectedCiv(), null, 4, null)) {
                    String name2 = (String)pair.component1();
                    Stats stats2 = (Stats)pair.component2();
                    $this$invoke_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(TranslationsKt.tr$default(name2, false, 1, null) + ": {" + stats2.clone() + '}')).row();
                }
                Popup.addCloseButton$default($this$invoke_u24lambda_u240, null, null, null, null, 15, null);
                Popup.open$default(popup2, false, 1, null);
            }
        });
        return table2;
    }

    public static final /* synthetic */ WorldScreen access$getWorldScreen$p(TileInfoTable $this) {
        return $this.worldScreen;
    }
}

