/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.multiplayer.HasMultiplayerGameName;
import com.unciv.logic.multiplayer.MultiplayerGameNameChanged;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateEnded;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateStarted;
import com.unciv.logic.multiplayer.MultiplayerGameUpdated;
import com.unciv.logic.multiplayer.OnlineMultiplayerGame;
import com.unciv.logic.multiplayer.OnlineMultiplayerKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.LoadingImage;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.status.MultiplayerStatusPopup;
import com.unciv.ui.screens.worldscreen.status.TurnIndicator;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u0012\u0010\u001d\u001a\u00020\u00162\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/ui/screens/worldscreen/status/MultiplayerStatusButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "Lcom/badlogic/gdx/utils/Disposable;", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "curGame", "Lcom/unciv/logic/multiplayer/OnlineMultiplayerGame;", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;Lcom/unciv/logic/multiplayer/OnlineMultiplayerGame;)V", "curGameName", "", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "gameNamesWithCurrentTurn", "", "loadingImage", "Lcom/unciv/ui/components/widgets/LoadingImage;", "turnIndicator", "Lcom/unciv/ui/screens/worldscreen/status/TurnIndicator;", "turnIndicatorCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "dispose", "", "findGamesToBeNotifiedAbout", "games", "", "getInitialGamesWithCurrentTurn", "startLoading", "stopLoading", "updateTurnIndicator", "flash", "", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerStatusButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerStatusButton.kt\ncom/unciv/ui/screens/worldscreen/status/MultiplayerStatusButton\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n766#2:158\n857#2,2:159\n766#2:161\n857#2,2:162\n1549#2:164\n1620#2,3:165\n*S KotlinDebug\n*F\n+ 1 MultiplayerStatusButton.kt\ncom/unciv/ui/screens/worldscreen/status/MultiplayerStatusButton\n*L\n91#1:158\n91#1:159,2\n92#1:161\n92#1:162,2\n93#1:164\n93#1:165,3\n*E\n"})
public final class MultiplayerStatusButton
extends Button
implements Disposable {
    @Nullable
    private String curGameName;
    @NotNull
    private final LoadingImage loadingImage;
    @NotNull
    private final TurnIndicator turnIndicator;
    @NotNull
    private final Cell<Actor> turnIndicatorCell;
    @NotNull
    private final Set<String> gameNamesWithCurrentTurn;
    @NotNull
    private final EventBus.EventReceiver events;

    public MultiplayerStatusButton(final @NotNull BaseScreen screen, @Nullable OnlineMultiplayerGame curGame) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        super(BaseScreen.Companion.getSkin());
        OnlineMultiplayerGame onlineMultiplayerGame = curGame;
        this.curGameName = onlineMultiplayerGame != null ? onlineMultiplayerGame.getName() : null;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.loadingImage = new LoadingImage(0.0f, new LoadingImage.Style(null, null, color, 500, null, "OtherIcons/Multiplayer", null, 0.0f, 0.0f, 0.0f, 0.0f, 2003, null), 1, null);
        this.turnIndicator = new TurnIndicator();
        this.gameNamesWithCurrentTurn = this.getInitialGamesWithCurrentTurn();
        this.events = new EventBus.EventReceiver();
        Cell cell2 = this.add().padTop(10.0f).padBottom(10.0f);
        Intrinsics.checkNotNullExpressionValue(cell2, "add().padTop(10f).padBottom(10f)");
        this.turnIndicatorCell = cell2;
        this.add((Actor)this.loadingImage).pad(5.0f);
        this.updateTurnIndicator(false);
        EventBus.EventReceiver.receive$default(this.events, Reflection.getOrCreateKotlinClass(MultiplayerGameUpdated.class), null, new Function1<MultiplayerGameUpdated, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdated it) {
                boolean shouldUpdate;
                Intrinsics.checkNotNullParameter(it, "it");
                boolean bl = shouldUpdate = OnlineMultiplayerKt.isUsersTurn(it.getPreview()) ? gameNamesWithCurrentTurn.add(it.getName()) : gameNamesWithCurrentTurn.remove(it.getName());
                if (shouldUpdate) {
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ MultiplayerStatusButton this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        @Override
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    MultiplayerStatusButton.updateTurnIndicator$default(this.this$0, false, 1, null);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Override
                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Override
                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            }
        }, 2, null);
        Function1 curGameFilter2 = new Function1<HasMultiplayerGameName, Boolean>(this){
            final /* synthetic */ MultiplayerStatusButton this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HasMultiplayerGameName it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getName(), MultiplayerStatusButton.access$getCurGameName$p(this.this$0));
            }
        };
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameNameChanged.class), curGameFilter2, (Function1)new Function1<MultiplayerGameNameChanged, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameNameChanged it) {
                Intrinsics.checkNotNullParameter(it, "it");
                curGameName = it.getNewName();
            }
        });
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateStarted.class), curGameFilter2, (Function1)new Function1<MultiplayerGameUpdateStarted, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdateStarted it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.startLoading();
            }
        });
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateEnded.class), curGameFilter2, (Function1)new Function1<MultiplayerGameUpdateEnded, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdateEnded it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.stopLoading();
            }
        });
        ActivationExtensionsKt.onClick(this, new Function0<Unit>(){

            @Override
            public final void invoke() {
                Popup.open$default(new MultiplayerStatusPopup(screen), false, 1, null);
            }
        });
    }

    private final void startLoading() {
        this.loadingImage.show();
    }

    private final void stopLoading() {
        LoadingImage.hide$default(this.loadingImage, null, 1, null);
    }

    private final Set<String> getInitialGamesWithCurrentTurn() {
        return this.findGamesToBeNotifiedAbout((Iterable<OnlineMultiplayerGame>)UncivGame.Companion.getCurrent().getOnlineMultiplayer().getGames());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> findGamesToBeNotifiedAbout(Iterable<OnlineMultiplayerGame> games) {
        void $this$mapTo$iv$iv;
        OnlineMultiplayerGame it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = games;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OnlineMultiplayerGame)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getName(), this.curGameName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OnlineMultiplayerGame)element$iv$iv;
            boolean bl = false;
            GameInfoPreview gameInfoPreview = it.getPreview();
            boolean bl2 = gameInfoPreview != null ? OnlineMultiplayerKt.isUsersTurn(gameInfoPreview) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (OnlineMultiplayerGame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toMutableSet((List)destination$iv$iv);
    }

    private final void updateTurnIndicator(boolean flash2) {
        if (this.gameNamesWithCurrentTurn.size() == 0) {
            this.turnIndicatorCell.clearActor();
        } else {
            this.turnIndicatorCell.setActor((Actor)this.turnIndicator);
            this.turnIndicator.update(this.gameNamesWithCurrentTurn.size());
        }
        if (flash2) {
            this.turnIndicator.flash();
        }
    }

    static /* synthetic */ void updateTurnIndicator$default(MultiplayerStatusButton multiplayerStatusButton, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        multiplayerStatusButton.updateTurnIndicator(bl);
    }

    @Override
    public void dispose() {
        this.events.stopReceiving();
        this.turnIndicator.dispose();
        this.loadingImage.dispose();
    }

    public static final /* synthetic */ String access$getCurGameName$p(MultiplayerStatusButton $this) {
        return $this.curGameName;
    }
}

