/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.graphics.Color;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.overviewscreen.EspionageOverviewScreen;
import com.unciv.ui.screens.pickerscreens.DiplomaticVotePickerScreen;
import com.unciv.ui.screens.pickerscreens.PantheonPickerScreen;
import com.unciv.ui.screens.pickerscreens.PolicyPickerScreen;
import com.unciv.ui.screens.pickerscreens.ReligiousBeliefsPickerScreen;
import com.unciv.ui.screens.pickerscreens.TechPickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.NextTurnAction;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0086\u0001\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bj\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#\u00a8\u0006%"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "", "text", "", "color", "Lcom/badlogic/gdx/graphics/Color;", "(Ljava/lang/String;ILjava/lang/String;Lcom/badlogic/gdx/graphics/Color;)V", "getColor", "()Lcom/badlogic/gdx/graphics/Color;", "icon", "getIcon", "()Ljava/lang/String;", "getText", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "Default", "AutoPlay", "Working", "Waiting", "PickConstruction", "PickTech", "PickPolicy", "MoveSpies", "FoundPantheon", "ExpandPantheon", "FoundReligion", "EnhanceReligion", "ReformReligion", "WorldCongressVote", "NextUnit", "MoveAutomatedUnits", "NextTurn", "Companion", "core"})
public abstract class NextTurnAction
extends Enum<NextTurnAction> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String text;
    @NotNull
    private final Color color;
    public static final /* enum */ NextTurnAction Default;
    public static final /* enum */ NextTurnAction AutoPlay;
    public static final /* enum */ NextTurnAction Working;
    public static final /* enum */ NextTurnAction Waiting;
    public static final /* enum */ NextTurnAction PickConstruction;
    public static final /* enum */ NextTurnAction PickTech;
    public static final /* enum */ NextTurnAction PickPolicy;
    public static final /* enum */ NextTurnAction MoveSpies;
    public static final /* enum */ NextTurnAction FoundPantheon;
    public static final /* enum */ NextTurnAction ExpandPantheon;
    public static final /* enum */ NextTurnAction FoundReligion;
    public static final /* enum */ NextTurnAction EnhanceReligion;
    public static final /* enum */ NextTurnAction ReformReligion;
    public static final /* enum */ NextTurnAction WorldCongressVote;
    public static final /* enum */ NextTurnAction NextUnit;
    public static final /* enum */ NextTurnAction MoveAutomatedUnits;
    public static final /* enum */ NextTurnAction NextTurn;
    private static final /* synthetic */ NextTurnAction[] $VALUES;

    private NextTurnAction(String text2, Color color) {
        this.text = text2;
        this.color = color;
    }

    @NotNull
    protected final String getText() {
        return this.text;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @Nullable
    public String getIcon() {
        return !Intrinsics.areEqual(this.text, "AutoPlay") ? "NotificationIcons/" + this.name() : "NotificationIcons/Working";
    }

    @NotNull
    public String getText(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        return this.text;
    }

    public abstract boolean isChoice(@NotNull WorldScreen var1);

    public void action(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
    }

    public static NextTurnAction[] values() {
        return (NextTurnAction[])$VALUES.clone();
    }

    public static NextTurnAction valueOf(String value) {
        return Enum.valueOf(NextTurnAction.class, value);
    }

    public /* synthetic */ NextTurnAction(String $enum$name, int $enum$ordinal, String text2, Color color, DefaultConstructorMarker $constructor_marker) {
        this(text2, color);
    }

    static {
        Default = new Default("Default", 0);
        AutoPlay = new AutoPlay("AutoPlay", 1);
        Working = new Working("Working", 2);
        Waiting = new Waiting("Waiting", 3);
        PickConstruction = new PickConstruction("PickConstruction", 4);
        PickTech = new PickTech("PickTech", 5);
        PickPolicy = new PickPolicy("PickPolicy", 6);
        MoveSpies = new MoveSpies("MoveSpies", 7);
        FoundPantheon = new FoundPantheon("FoundPantheon", 8);
        ExpandPantheon = new ExpandPantheon("ExpandPantheon", 9);
        FoundReligion = new FoundReligion("FoundReligion", 10);
        EnhanceReligion = new EnhanceReligion("EnhanceReligion", 11);
        ReformReligion = new ReformReligion("ReformReligion", 12);
        WorldCongressVote = new WorldCongressVote("WorldCongressVote", 13);
        NextUnit = new NextUnit("NextUnit", 14);
        MoveAutomatedUnits = new MoveAutomatedUnits("MoveAutomatedUnits", 15);
        NextTurn = new NextTurn("NextTurn", 16);
        $VALUES = nextTurnActionArray = new NextTurnAction[]{NextTurnAction.Default, NextTurnAction.AutoPlay, NextTurnAction.Working, NextTurnAction.Waiting, NextTurnAction.PickConstruction, NextTurnAction.PickTech, NextTurnAction.PickPolicy, NextTurnAction.MoveSpies, NextTurnAction.FoundPantheon, NextTurnAction.ExpandPantheon, NextTurnAction.FoundReligion, NextTurnAction.EnhanceReligion, NextTurnAction.ReformReligion, NextTurnAction.WorldCongressVote, NextTurnAction.NextUnit, NextTurnAction.MoveAutomatedUnits, NextTurnAction.NextTurn};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$AutoPlay;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class AutoPlay
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        AutoPlay() {
            void var1_1;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getAutoPlay().isAutoPlaying();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getAutoPlay().stopAutoPlay();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J7\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u001d\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\r\u00a2\u0006\u0002\b\u0011H\u0002J\f\u0010\u0012\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0013\u001a\u00020\u000b*\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$Companion;", "", "()V", "getCityWithNoProductionSet", "Lcom/unciv/logic/city/City;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "moveAutomatedUnits", "", "openReligionPicker", "pickIconAndName", "", "getBeliefs", "Lkotlin/Function1;", "Lcom/unciv/logic/civilization/managers/ReligionManager;", "Lcom/unciv/models/Counter;", "Lcom/unciv/models/ruleset/BeliefType;", "Lkotlin/ExtensionFunctionType;", "confirmedNextTurn", "isMoveAutomatedUnits", "core"})
    @SourceDebugExtension(value={"SMAP\nNextTurnAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextTurnAction.kt\ncom/unciv/ui/screens/worldscreen/status/NextTurnAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,205:1\n288#2,2:206\n1229#3,2:208\n*S KotlinDebug\n*F\n+ 1 NextTurnAction.kt\ncom/unciv/ui/screens/worldscreen/status/NextTurnAction$Companion\n*L\n148#1:206,2\n169#1:208,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final City getCityWithNoProductionSet(WorldScreen worldScreen) {
            Object v1;
            block1: {
                Iterable $this$firstOrNull$iv = worldScreen.getViewingCiv().getCities();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    City it = (City)element$iv;
                    boolean bl = false;
                    boolean bl2 = !it.isPuppet() && ((CharSequence)it.getCityConstructions().getCurrentConstructionFromQueue()).length() == 0;
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private final void openReligionPicker(WorldScreen worldScreen, boolean pickIconAndName, Function1<? super ReligionManager, ? extends Counter<BeliefType>> getBeliefs2) {
            worldScreen.getGame().pushScreen(new ReligiousBeliefsPickerScreen(worldScreen.getViewingCiv(), getBeliefs2.invoke(worldScreen.getViewingCiv().getReligionManager()), pickIconAndName));
        }

        private final boolean isMoveAutomatedUnits(WorldScreen $this$isMoveAutomatedUnits) {
            boolean bl;
            block2: {
                if ($this$isMoveAutomatedUnits.getGame().getSettings().getAutomatedUnitsMoveOnTurnStart() || $this$isMoveAutomatedUnits.getViewingCiv().getHasMovedAutomatedUnits()) {
                    return false;
                }
                Sequence<MapUnit> $this$any$iv = $this$isMoveAutomatedUnits.getViewingCiv().getUnits().getCivUnits();
                boolean $i$f$any = false;
                Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    MapUnit element$iv;
                    MapUnit it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    boolean bl3 = it.getCurrentMovement() > 0.05f && (it.isMoving() || it.isAutomated() || it.isExploring());
                    if (!bl3) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private final void moveAutomatedUnits(WorldScreen worldScreen) {
            if (!worldScreen.isPlayersTurn()) {
                return;
            }
            worldScreen.setPlayersTurn$core(false);
            worldScreen.getViewingCiv().setHasMovedAutomatedUnits(true);
            Scene2dExtensionsKt.disable(worldScreen.getNextTurnButton$core());
            Concurrency.run$default(Concurrency.INSTANCE, "Move automated units", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(worldScreen, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ WorldScreen $worldScreen;
                {
                    this.$worldScreen = $worldScreen;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            CoroutineScope $this$run = (CoroutineScope)this.L$0;
                            Iterator<MapUnit> iterator2 = this.$worldScreen.getViewingCiv().getUnits().getCivUnits().iterator();
                            while (iterator2.hasNext()) {
                                MapUnit unit = iterator2.next();
                                unit.doAction();
                            }
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$worldScreen, null){
                                int label;
                                final /* synthetic */ WorldScreen $worldScreen;
                                {
                                    this.$worldScreen = $worldScreen;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$worldScreen.setShouldUpdate(true);
                                            this.$worldScreen.setPlayersTurn$core(true);
                                            Scene2dExtensionsKt.enable(this.$worldScreen.getNextTurnButton$core());
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }

        private final void confirmedNextTurn(WorldScreen $this$confirmedNextTurn) {
            if ($this$confirmedNextTurn.getGame().getSettings().getConfirmNextTurn()) {
                Popup.open$default(new ConfirmPopup($this$confirmedNextTurn, "Confirm next turn", "Next turn", true, null, (Function0)new Function0<Unit>($this$confirmedNextTurn){
                    final /* synthetic */ WorldScreen $this_confirmedNextTurn;
                    {
                        this.$this_confirmedNextTurn = $receiver;
                        super(0, Intrinsics.Kotlin.class, "action", "confirmedNextTurn$action(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", 0);
                    }

                    public final void invoke() {
                        com.unciv.ui.screens.worldscreen.status.NextTurnAction$Companion.access$confirmedNextTurn$action(this.$this_confirmedNextTurn);
                    }
                }, 16, null), false, 1, null);
            } else {
                com.unciv.ui.screens.worldscreen.status.NextTurnAction$Companion.confirmedNextTurn$action($this$confirmedNextTurn);
            }
        }

        private static final void confirmedNextTurn$action(WorldScreen $this_confirmedNextTurn) {
            $this_confirmedNextTurn.getGame().getSettings().addCompletedTutorialTask("Pass a turn");
            $this_confirmedNextTurn.nextTurn();
        }

        public static final /* synthetic */ void access$confirmedNextTurn$action(WorldScreen $this_confirmedNextTurn) {
            com.unciv.ui.screens.worldscreen.status.NextTurnAction$Companion.confirmedNextTurn$action($this_confirmedNextTurn);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$Default;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "icon", "", "getIcon", "()Ljava/lang/Void;", "isChoice", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "core"})
    static final class Default
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        Default() {
            void var1_1;
            Color color = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color, "BLACK");
        }

        @Nullable
        public Void getIcon() {
            return null;
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$EnhanceReligion;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class EnhanceReligion
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        EnhanceReligion() {
            void var1_1;
            Color color = Color.valueOf(BeliefType.Enhancer.getColor());
            Intrinsics.checkNotNullExpressionValue(color, "valueOf(BeliefType.Enhancer.color)");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().getReligionManager().getReligionState() == ReligionState.EnhancingReligion;
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            Companion.openReligionPicker(worldScreen, false, action.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$ExpandPantheon;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class ExpandPantheon
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        ExpandPantheon() {
            void var1_1;
            Color color = Color.valueOf(BeliefType.Pantheon.getColor());
            Intrinsics.checkNotNullExpressionValue(color, "valueOf(BeliefType.Pantheon.color)");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            ReligionManager $this$isChoice_u24lambda_u240 = worldScreen.getViewingCiv().getReligionManager();
            boolean bl = false;
            return $this$isChoice_u24lambda_u240.getReligionState() == ReligionState.Pantheon && $this$isChoice_u24lambda_u240.canFoundOrExpandPantheon();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getGame().pushScreen(new PantheonPickerScreen(worldScreen.getViewingCiv()));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$FoundPantheon;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class FoundPantheon
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        FoundPantheon() {
            void var1_1;
            Color color = Color.valueOf(BeliefType.Pantheon.getColor());
            Intrinsics.checkNotNullExpressionValue(color, "valueOf(BeliefType.Pantheon.color)");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            ReligionManager $this$isChoice_u24lambda_u240 = worldScreen.getViewingCiv().getReligionManager();
            boolean bl = false;
            return $this$isChoice_u24lambda_u240.getReligionState() != ReligionState.Pantheon && $this$isChoice_u24lambda_u240.canFoundOrExpandPantheon();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getGame().pushScreen(new PantheonPickerScreen(worldScreen.getViewingCiv()));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$FoundReligion;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class FoundReligion
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        FoundReligion() {
            void var1_1;
            Color color = Color.valueOf(BeliefType.Founder.getColor());
            Intrinsics.checkNotNullExpressionValue(color, "valueOf(BeliefType.Founder.color)");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().getReligionManager().getReligionState() == ReligionState.FoundingReligion;
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            Companion.openReligionPicker(worldScreen, true, action.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$MoveAutomatedUnits;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class MoveAutomatedUnits
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        MoveAutomatedUnits() {
            void var1_1;
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return Companion.isMoveAutomatedUnits(worldScreen);
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            Companion.moveAutomatedUnits(worldScreen);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$MoveSpies;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class MoveSpies
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        MoveSpies() {
            void var1_1;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getGameInfo().isEspionageEnabled() && worldScreen.getViewingCiv().getEspionageManager().shouldShowMoveSpies();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getGame().pushScreen(new EspionageOverviewScreen(worldScreen.getSelectedCiv(), worldScreen));
            worldScreen.getViewingCiv().getEspionageManager().setDismissedShouldMoveSpies(true);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$NextTurn;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class NextTurn
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        NextTurn() {
            void var1_1;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return true;
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            Companion.confirmedNextTurn(worldScreen);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$NextUnit;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class NextUnit
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        NextUnit() {
            void var1_1;
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().getUnits().shouldGoToDueUnit();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.switchToNextUnit();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$PickConstruction;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class PickConstruction
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        PickConstruction() {
            void var1_1;
            Color color = Color.CORAL;
            Intrinsics.checkNotNullExpressionValue(color, "CORAL");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return Companion.getCityWithNoProductionSet(worldScreen) != null;
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            City city2 = Companion.getCityWithNoProductionSet(worldScreen);
            if (city2 == null) {
                return;
            }
            City city3 = city2;
            worldScreen.getGame().pushScreen(new CityScreen(city3, null, null, null, 14, null));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$PickPolicy;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class PickPolicy
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        PickPolicy() {
            void var1_1;
            Color color = Color.VIOLET;
            Intrinsics.checkNotNullExpressionValue(color, "VIOLET");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().getPolicies().shouldShowPolicyPicker();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getGame().pushScreen(new PolicyPickerScreen(worldScreen.getSelectedCiv(), worldScreen.getCanChangeState(), null, 4, null));
            worldScreen.getViewingCiv().getPolicies().setShouldOpenPolicyPicker(false);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$PickTech;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class PickTech
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        PickTech() {
            void var1_1;
            Color color = Color.SKY;
            Intrinsics.checkNotNullExpressionValue(color, "SKY");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().shouldOpenTechPicker();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getGame().pushScreen(new TechPickerScreen(worldScreen.getViewingCiv(), null, worldScreen.getViewingCiv().getTech().getFreeTechs() != 0));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$ReformReligion;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class ReformReligion
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        ReformReligion() {
            void var1_1;
            Color color = Color.valueOf(BeliefType.Enhancer.getColor());
            Intrinsics.checkNotNullExpressionValue(color, "valueOf(BeliefType.Enhancer.color)");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().getReligionManager().hasFreeBeliefs();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            Companion.openReligionPicker(worldScreen, false, action.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$Waiting;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "getText", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class Waiting
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        Waiting() {
            void var1_1;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        }

        @Override
        @NotNull
        public String getText(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getGameInfo().getGameParameters().isOnlineMultiplayer() ? "Waiting for [" + worldScreen.getGameInfo().getCurrentPlayerCiv() + "]..." : this.getText();
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return !worldScreen.isPlayersTurn();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$Working;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "isChoice", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "core"})
    static final class Working
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        Working() {
            void var1_1;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.isNextTurnUpdateRunning$core();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction$WorldCongressVote;", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnAction;", "action", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "isChoice", "", "core"})
    static final class WorldCongressVote
    extends NextTurnAction {
        /*
         * WARNING - void declaration
         */
        WorldCongressVote() {
            void var1_1;
            Color color = Color.MAROON;
            Intrinsics.checkNotNullExpressionValue(color, "MAROON");
        }

        @Override
        public boolean isChoice(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            return worldScreen.getViewingCiv().mayVoteForDiplomaticVictory();
        }

        @Override
        public void action(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            worldScreen.getGame().pushScreen(new DiplomaticVotePickerScreen(worldScreen.getViewingCiv()));
        }
    }
}

