/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.topbar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontMetricsCommon;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.worldscreen.BackgroundActor;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.mainmenu.WorldScreenMenuPopup;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBarResources;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBarStats;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0014\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "baseHeight", "", "leftFiller", "Lcom/unciv/ui/screens/worldscreen/BackgroundActor;", "overviewButton", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$OverviewAndSupplyTable;", "resourceTable", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarResources;", "rightFiller", "selectedCivTable", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$SelectedCivilizationTable;", "statsTable", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarStats;", "getWorldScreen$core", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getYForTutorialTask", "getYForTutorialTask$core", "update", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "update$core", "updateLayout", "Companion", "OverviewAndSupplyTable", "SelectedCivilizationTable", "core"})
public final class WorldScreenTopBar
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final WorldScreenTopBarStats statsTable;
    @NotNull
    private final WorldScreenTopBarResources resourceTable;
    @NotNull
    private final SelectedCivilizationTable selectedCivTable;
    @NotNull
    private final OverviewAndSupplyTable overviewButton;
    @NotNull
    private final BackgroundActor leftFiller;
    @NotNull
    private final BackgroundActor rightFiller;
    private float baseHeight;
    public static final float gapFillingExtraHeight = 1.0f;

    public WorldScreenTopBar(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.statsTable = new WorldScreenTopBarStats(this);
        this.resourceTable = new WorldScreenTopBarResources(this);
        this.selectedCivTable = new SelectedCivilizationTable(this.worldScreen);
        this.overviewButton = new OverviewAndSupplyTable(this.worldScreen);
        this.defaults().center();
        this.setRound(false);
        Color backColor = Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f);
        this.statsTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/TopBar/StatsTable", null, backColor, 2, null));
        this.resourceTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/TopBar/ResourceTable", null, backColor, 2, null));
        NinePatchDrawable leftFillerBG = BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/TopBar/LeftAttachment", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), backColor);
        this.leftFiller = new BackgroundActor(leftFillerBG, 10);
        NinePatchDrawable rightFillerBG = BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/TopBar/RightAttachment", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), backColor);
        this.rightFiller = new BackgroundActor(rightFillerBG, 18);
    }

    @NotNull
    public final WorldScreen getWorldScreen$core() {
        return this.worldScreen;
    }

    public final void update$core(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setLayoutEnabled(false);
        this.statsTable.update(civInfo);
        this.resourceTable.update(civInfo);
        this.selectedCivTable.update(this.worldScreen);
        this.overviewButton.update(this.worldScreen);
        this.updateLayout();
        this.setLayoutEnabled(true);
    }

    public final float getYForTutorialTask$core() {
        return this.getY() + this.getHeight() - this.baseHeight;
    }

    private final void updateLayout() {
        float f;
        float targetWidth = this.getStage().getWidth();
        float statsWidth = this.statsTable.getPrefWidth();
        float resourceWidth = this.resourceTable.getPrefWidth();
        float overviewWidth = this.overviewButton.getMinWidth();
        float overviewHeight = this.overviewButton.getMinHeight();
        float selectedCivWidth = this.selectedCivTable.getMinWidth();
        float selectedCivHeight = this.selectedCivTable.getMinHeight();
        float leftRightNeeded = Math.max(selectedCivWidth, overviewWidth);
        float overlayHeight = Math.max(overviewHeight, selectedCivHeight);
        this.clear();
        this.add((Actor)this.statsTable).colspan(3).growX().width(targetWidth).row();
        this.add((Actor)this.resourceTable).colspan(3).growX().width(targetWidth).row();
        this.layout();
        float statsRowHeight = this.getRowHeight(0);
        this.baseHeight = statsRowHeight + this.getRowHeight(1);
        if (leftRightNeeded * 2.0f > targetWidth - resourceWidth) {
            WorldScreenTopBar.updateLayout$addFillers(this, selectedCivWidth, overviewWidth, overlayHeight);
            f = overlayHeight;
        } else if (leftRightNeeded * 2.0f > targetWidth - statsWidth) {
            WorldScreenTopBar.updateLayout$addFillers(this, selectedCivWidth, overviewWidth, statsRowHeight);
            f = overlayHeight;
        } else {
            f = this.baseHeight;
        }
        float centerButtonsToHeight = f;
        this.setSize(targetWidth, this.getPrefHeight());
        this.setPosition(0.0f, this.getStage().getHeight() - this.getPrefHeight());
        this.selectedCivTable.setPosition(0.0f, (centerButtonsToHeight - selectedCivHeight) / 2.0f);
        this.overviewButton.setPosition(targetWidth - overviewWidth, (centerButtonsToHeight - overviewHeight) / 2.0f);
        this.addActor(this.selectedCivTable);
        this.addActor(this.overviewButton);
    }

    private static final void updateLayout$addFillers(WorldScreenTopBar this$0, float selectedCivWidth, float overviewWidth, float fillerHeight) {
        this$0.add((Actor)this$0.leftFiller).size(selectedCivWidth, fillerHeight + 1.0f);
        this$0.add().growX();
        this$0.add((Actor)this$0.rightFiller).size(overviewWidth, fillerHeight + 1.0f);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$Companion;", "", "()V", "gapFillingExtraHeight", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$OverviewAndSupplyTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "unitSupplyCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getUnitSupplyCell", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "unitSupplyImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getUnitSupplyImage", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "update", "", "core"})
    @SourceDebugExtension(value={"SMAP\nWorldScreenTopBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScreenTopBar.kt\ncom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$OverviewAndSupplyTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
    private static final class OverviewAndSupplyTable
    extends Table {
        @NotNull
        private final Image unitSupplyImage;
        @NotNull
        private final Cell<Actor> unitSupplyCell;

        /*
         * WARNING - void declaration
         */
        public OverviewAndSupplyTable(final @NotNull WorldScreen worldScreen) {
            void $this$unitSupplyImage_u24lambda_u240;
            Image image2;
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            super(BaseScreen.Companion.getSkin());
            Image image3 = image2 = ImageGetter.INSTANCE.getImage("OtherIcons/ExclamationMark");
            OverviewAndSupplyTable overviewAndSupplyTable = this;
            boolean bl = false;
            $this$unitSupplyImage_u24lambda_u240.setColor(Color.FIREBRICK);
            overviewAndSupplyTable.unitSupplyImage = image2;
            ActivationExtensionsKt.onClick(this.unitSupplyImage, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    worldScreen.openEmpireOverview(EmpireOverviewCategories.Units);
                }
            });
            TextButton overviewButton = Scene2dExtensionsKt.toTextButton$default("Overview", null, false, 3, null);
            ActivationExtensionsKt.onActivation$default(overviewButton, null, KeyboardBinding.EmpireOverview, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    WorldScreen.openEmpireOverview$default(worldScreen, null, 1, null);
                }
            }, 1, null);
            Cell cell2 = this.add();
            Intrinsics.checkNotNullExpressionValue(cell2, "add()");
            this.unitSupplyCell = cell2;
            this.add((Actor)overviewButton).pad(10.0f);
            this.pack();
        }

        @NotNull
        public final Image getUnitSupplyImage() {
            return this.unitSupplyImage;
        }

        @NotNull
        public final Cell<Actor> getUnitSupplyCell() {
            return this.unitSupplyCell;
        }

        public final void update(@NotNull WorldScreen worldScreen) {
            boolean newVisible;
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            boolean bl = newVisible = worldScreen.getSelectedCiv().getStats().getUnitSupplyDeficit() > 0;
            if (newVisible == this.unitSupplyCell.hasActor()) {
                return;
            }
            if (newVisible) {
                this.unitSupplyCell.setActor((Actor)this.unitSupplyImage).size(50.0f).padLeft(10.0f);
            } else {
                this.unitSupplyCell.setActor(null).size(0.0f).pad(0.0f);
            }
            this.invalidate();
            this.pack();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$SelectedCivilizationTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "menuButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "selectedCiv", "", "selectedCivIcon", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "selectedCivIconCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "selectedCivLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "update", "", "core"})
    @SourceDebugExtension(value={"SMAP\nWorldScreenTopBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScreenTopBar.kt\ncom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar$SelectedCivilizationTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
    private static final class SelectedCivilizationTable
    extends Table {
        @NotNull
        private String selectedCiv;
        @NotNull
        private Group selectedCivIcon;
        @NotNull
        private final Cell<Group> selectedCivIconCell;
        @NotNull
        private final Label selectedCivLabel;
        @NotNull
        private final Image menuButton;

        public SelectedCivilizationTable(final @NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            super(BaseScreen.Companion.getSkin());
            this.selectedCiv = "";
            this.selectedCivIcon = new Group();
            this.selectedCivLabel = Scene2dExtensionsKt.toLabel("");
            this.menuButton = ImageGetter.INSTANCE.getImage("OtherIcons/MenuIcon");
            FontMetricsCommon $this$_init__u24lambda_u240 = Fonts.INSTANCE.getFontImplementation().getMetrics();
            boolean bl = false;
            float descenderHeight = $this$_init__u24lambda_u240.getDescent() / $this$_init__u24lambda_u240.getHeight() * 25.0f;
            this.left();
            this.pad(10.0f);
            this.padTop(RangesKt.coerceAtLeast(10.0f - descenderHeight, 0.0f));
            this.menuButton.setColor(Color.WHITE);
            ActivationExtensionsKt.onActivation$default(this.menuButton, null, KeyboardBinding.Menu, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    new WorldScreenMenuPopup(worldScreen, false, 2, null);
                }
            }, 1, null);
            ActivationExtensionsKt.onRightClick$default(this.menuButton, null, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    new WorldScreenMenuPopup(worldScreen, true);
                }
            }, 1, null);
            Function0 onNationClick2 = new Function0<Unit>(worldScreen){
                final /* synthetic */ WorldScreen $worldScreen;
                {
                    this.$worldScreen = $worldScreen;
                    super(0);
                }

                public final void invoke() {
                    this.$worldScreen.openCivilopedia(this.$worldScreen.getSelectedCiv().getNation().makeLink());
                }
            };
            Scene2dExtensionsKt.setFontSize(this.selectedCivLabel, 25);
            ActivationExtensionsKt.onClick(this.selectedCivLabel, onNationClick2);
            ActivationExtensionsKt.onClick(this.selectedCivIcon, onNationClick2);
            this.add((Actor)this.menuButton).size(50.0f);
            Cell<Actor> cell2 = this.add((Actor)this.selectedCivIcon).padLeft(10.0f);
            Intrinsics.checkNotNullExpressionValue(cell2, "add(selectedCivIcon).padLeft(10f)");
            this.selectedCivIconCell = cell2;
            this.add((Actor)this.selectedCivLabel).padTop(descenderHeight);
            this.pack();
        }

        public final void update(@NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            String newCiv = worldScreen.getSelectedCiv().getCivName();
            if (Intrinsics.areEqual(this.selectedCiv, newCiv)) {
                return;
            }
            this.selectedCiv = newCiv;
            this.selectedCivIcon = ImageGetter.INSTANCE.getNationPortrait(worldScreen.getSelectedCiv().getNation(), 25.0f);
            this.selectedCivIconCell.setActor((Actor)this.selectedCivIcon);
            this.selectedCivLabel.setText(TranslationsKt.tr(newCiv, true));
            this.invalidate();
            this.pack();
        }
    }
}

