/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit;

import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.Concurrency;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\fJ.\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"J\u0006\u0010#\u001a\u00020\fJ\u0006\u0010$\u001a\u00020\u0018J\u0006\u0010%\u001a\u00020\u0018R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "", "autoPlaySettings", "Lcom/unciv/models/metadata/GameSettings$GameSettingsAutoPlay;", "(Lcom/unciv/models/metadata/GameSettings$GameSettingsAutoPlay;)V", "autoPlayJob", "Lkotlinx/coroutines/Job;", "getAutoPlayJob", "()Lkotlinx/coroutines/Job;", "setAutoPlayJob", "(Lkotlinx/coroutines/Job;)V", "autoPlayTurnInProgress", "", "getAutoPlayTurnInProgress", "()Z", "setAutoPlayTurnInProgress", "(Z)V", "turnsToAutoPlay", "", "getTurnsToAutoPlay", "()I", "setTurnsToAutoPlay", "(I)V", "endTurnMultiturnAutoPlay", "", "isAutoPlaying", "isAutoPlayingAndFullAutoPlayAI", "runAutoPlayJobInNewThread", "jobName", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "setPlayerTurnAfterEnd", "job", "Lkotlin/Function0;", "shouldContinueAutoPlaying", "startMultiturnAutoPlay", "stopAutoPlay", "core"})
public final class AutoPlay {
    @NotNull
    private GameSettings.GameSettingsAutoPlay autoPlaySettings;
    private int turnsToAutoPlay;
    private boolean autoPlayTurnInProgress;
    @Nullable
    private Job autoPlayJob;

    public AutoPlay(@NotNull GameSettings.GameSettingsAutoPlay autoPlaySettings) {
        Intrinsics.checkNotNullParameter(autoPlaySettings, "autoPlaySettings");
        this.autoPlaySettings = autoPlaySettings;
    }

    public final int getTurnsToAutoPlay() {
        return this.turnsToAutoPlay;
    }

    public final void setTurnsToAutoPlay(int n) {
        this.turnsToAutoPlay = n;
    }

    public final boolean getAutoPlayTurnInProgress() {
        return this.autoPlayTurnInProgress;
    }

    public final void setAutoPlayTurnInProgress(boolean bl) {
        this.autoPlayTurnInProgress = bl;
    }

    @Nullable
    public final Job getAutoPlayJob() {
        return this.autoPlayJob;
    }

    public final void setAutoPlayJob(@Nullable Job job2) {
        this.autoPlayJob = job2;
    }

    public final void startMultiturnAutoPlay() {
        this.autoPlayTurnInProgress = false;
        this.turnsToAutoPlay = this.autoPlaySettings.getAutoPlayMaxTurns();
    }

    public final void endTurnMultiturnAutoPlay() {
        if (!this.autoPlaySettings.getAutoPlayUntilEnd() && this.turnsToAutoPlay > 0) {
            int n = this.turnsToAutoPlay;
            this.turnsToAutoPlay = n + -1;
        }
    }

    public final void stopAutoPlay() {
        this.turnsToAutoPlay = 0;
        this.autoPlayTurnInProgress = false;
    }

    public final void runAutoPlayJobInNewThread(@NotNull String jobName, @NotNull WorldScreen worldScreen, boolean setPlayerTurnAfterEnd, @NotNull Function0<Unit> job2) {
        Intrinsics.checkNotNullParameter(jobName, "jobName");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(job2, "job");
        if (this.autoPlayTurnInProgress) {
            throw new IllegalStateException("Trying to start an AutoPlay job while a job is currently running");
        }
        this.autoPlayTurnInProgress = true;
        worldScreen.setPlayersTurn$core(false);
        this.autoPlayJob = Concurrency.INSTANCE.runOnNonDaemonThreadPool(jobName, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job2, this, setPlayerTurnAfterEnd, worldScreen, null){
            int label;
            final /* synthetic */ Function0<Unit> $job;
            final /* synthetic */ AutoPlay this$0;
            final /* synthetic */ boolean $setPlayerTurnAfterEnd;
            final /* synthetic */ WorldScreen $worldScreen;
            {
                this.$job = $job;
                this.this$0 = $receiver;
                this.$setPlayerTurnAfterEnd = $setPlayerTurnAfterEnd;
                this.$worldScreen = $worldScreen;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.$job.invoke();
                        this.this$0.setAutoPlayTurnInProgress(false);
                        if (this.$setPlayerTurnAfterEnd) {
                            this.$worldScreen.setPlayersTurn$core(true);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ void runAutoPlayJobInNewThread$default(AutoPlay autoPlay, String string, WorldScreen worldScreen, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        autoPlay.runAutoPlayJobInNewThread(string, worldScreen, bl, function0);
    }

    public final boolean isAutoPlaying() {
        return this.turnsToAutoPlay > 0 || this.autoPlayTurnInProgress;
    }

    public final boolean isAutoPlayingAndFullAutoPlayAI() {
        return this.isAutoPlaying() && this.autoPlaySettings.getFullAutoPlayAI();
    }

    public final boolean shouldContinueAutoPlaying() {
        return !this.autoPlayTurnInProgress && this.turnsToAutoPlay > 0;
    }
}

