/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.compression;

import io.ktor.client.HttpClient;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.compression.ContentEncoder;
import io.ktor.client.plugins.compression.ContentEncodingKt;
import io.ktor.client.plugins.compression.DeflateEncoder;
import io.ktor.client.plugins.compression.GZipEncoder;
import io.ktor.client.plugins.compression.IdentityEncoder;
import io.ktor.client.plugins.compression.UnsupportedContentEncodingException;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestPipeline;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseContainer;
import io.ktor.client.statement.HttpResponsePipeline;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.util.AttributeKey;
import io.ktor.util.CaseInsensitiveMap;
import io.ktor.util.Encoder;
import io.ktor.util.KtorDsl;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteReadChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B/\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/ktor/client/plugins/compression/ContentEncoding;", "", "encoders", "", "", "Lio/ktor/client/plugins/compression/ContentEncoder;", "qualityValues", "", "(Ljava/util/Map;Ljava/util/Map;)V", "requestHeader", "setRequestHeaders", "", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "decode", "Lio/ktor/utils/io/ByteReadChannel;", "Lkotlinx/coroutines/CoroutineScope;", "response", "Lio/ktor/client/statement/HttpResponse;", "content", "Companion", "Config", "ktor-client-encoding"})
public final class ContentEncoding {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, ContentEncoder> encoders;
    @NotNull
    private final Map<String, Float> qualityValues;
    @NotNull
    private final String requestHeader;
    @NotNull
    private static final AttributeKey<ContentEncoding> key = new AttributeKey("HttpEncoding");

    /*
     * WARNING - void declaration
     */
    private ContentEncoding(Map<String, ? extends ContentEncoder> encoders, Map<String, Float> qualityValues) {
        StringBuilder stringBuilder;
        this.encoders = encoders;
        this.qualityValues = qualityValues;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        ContentEncoding contentEncoding = this;
        boolean bl = false;
        for (ContentEncoder encoder2 : this.encoders.values()) {
            void $this$requestHeader_u24lambda_u241;
            if ($this$requestHeader_u24lambda_u241.length() > 0) {
                $this$requestHeader_u24lambda_u241.append(',');
            }
            $this$requestHeader_u24lambda_u241.append(encoder2.getName());
            Float f = this.qualityValues.get(encoder2.getName());
            if (f == null) {
                continue;
            }
            float quality = f.floatValue();
            double d = quality;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Invalid quality value: " + quality + " for encoder: " + encoder2;
                throw new IllegalStateException(string.toString());
            }
            String qualityValue = StringsKt.take(String.valueOf(quality), 5);
            $this$requestHeader_u24lambda_u241.append(";q=" + qualityValue);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        contentEncoding.requestHeader = string;
    }

    private final void setRequestHeaders(HttpRequestBuilder request2) {
        if (request2.getHeaders().contains(HttpHeaders.INSTANCE.getAcceptEncoding())) {
            return;
        }
        ContentEncodingKt.access$getLOGGER$p().trace("Adding Accept-Encoding=" + request2 + " for " + request2.getUrl());
        request2.getHeaders().set(HttpHeaders.INSTANCE.getAcceptEncoding(), this.requestHeader);
    }

    /*
     * WARNING - void declaration
     */
    private final ByteReadChannel decode(CoroutineScope $this$decode, HttpResponse response2, ByteReadChannel content2) {
        Collection destination$iv$iv;
        String[] stringArray;
        Object object = response2.getHeaders().get(HttpHeaders.INSTANCE.getContentEncoding());
        if (object != null && (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{","}, false, 0, 6, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = ((Object)StringsKt.trim((CharSequence)it)).toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                collection.add(string2);
            }
        } else {
            CoroutineScope $this$decode_u24lambda_u243 = $this$decode;
            boolean bl = false;
            ContentEncodingKt.access$getLOGGER$p().trace("Empty or no Content-Encoding header in response. Skipping ContentEncoding for " + response2.getCall().getRequest().getUrl());
            return content2;
        }
        List encodings = (List)destination$iv$iv;
        ByteReadChannel current = null;
        current = content2;
        for (String encoding : CollectionsKt.reversed(encodings)) {
            ContentEncoder contentEncoder = this.encoders.get(encoding);
            if (contentEncoder == null) {
                throw new UnsupportedContentEncodingException(encoding);
            }
            Encoder encoder2 = contentEncoder;
            ContentEncodingKt.access$getLOGGER$p().trace("Recoding response with " + encoder2 + " for " + response2.getCall().getRequest().getUrl());
            Encoder $this$decode_u24lambda_u244 = encoder2;
            boolean bl = false;
            current = $this$decode_u24lambda_u244.decode($this$decode, current);
        }
        return current;
    }

    public static final /* synthetic */ void access$setRequestHeaders(ContentEncoding $this, HttpRequestBuilder request2) {
        $this.setRequestHeaders(request2);
    }

    public static final /* synthetic */ ByteReadChannel access$decode(ContentEncoding $this, CoroutineScope $receiver, HttpResponse response2, ByteReadChannel content2) {
        return $this.decode($receiver, response2, content2);
    }

    public /* synthetic */ ContentEncoding(Map encoders, Map qualityValues, DefaultConstructorMarker $constructor_marker) {
        this(encoders, qualityValues);
    }

    @KtorDsl
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0012R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/ktor/client/plugins/compression/ContentEncoding$Config;", "", "()V", "encoders", "", "", "Lio/ktor/client/plugins/compression/ContentEncoder;", "getEncoders$ktor_client_encoding", "()Ljava/util/Map;", "qualityValues", "", "getQualityValues$ktor_client_encoding", "customEncoder", "", "encoder", "quality", "(Lio/ktor/client/plugins/compression/ContentEncoder;Ljava/lang/Float;)V", "deflate", "(Ljava/lang/Float;)V", "gzip", "identity", "ktor-client-encoding"})
    public static final class Config {
        @NotNull
        private final Map<String, ContentEncoder> encoders = new CaseInsensitiveMap();
        @NotNull
        private final Map<String, Float> qualityValues = new CaseInsensitiveMap();

        @NotNull
        public final Map<String, ContentEncoder> getEncoders$ktor_client_encoding() {
            return this.encoders;
        }

        @NotNull
        public final Map<String, Float> getQualityValues$ktor_client_encoding() {
            return this.qualityValues;
        }

        public final void gzip(@Nullable Float quality) {
            this.customEncoder(GZipEncoder.INSTANCE, quality);
        }

        public static /* synthetic */ void gzip$default(Config config2, Float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = null;
            }
            config2.gzip(f);
        }

        public final void deflate(@Nullable Float quality) {
            this.customEncoder(DeflateEncoder.INSTANCE, quality);
        }

        public static /* synthetic */ void deflate$default(Config config2, Float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = null;
            }
            config2.deflate(f);
        }

        public final void identity(@Nullable Float quality) {
            this.customEncoder(IdentityEncoder.INSTANCE, quality);
        }

        public static /* synthetic */ void identity$default(Config config2, Float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = null;
            }
            config2.identity(f);
        }

        public final void customEncoder(@NotNull ContentEncoder encoder2, @Nullable Float quality) {
            Intrinsics.checkNotNullParameter(encoder2, "encoder");
            String name2 = encoder2.getName();
            String string = name2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.encoders.put(string, encoder2);
            if (quality == null) {
                this.qualityValues.remove(name2);
            } else {
                this.qualityValues.put(name2, quality);
            }
        }

        public static /* synthetic */ void customEncoder$default(Config config2, ContentEncoder contentEncoder, Float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = null;
            }
            config2.customEncoder(contentEncoder, f);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J!\u0010\u000e\u001a\u00020\u00032\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\u0002\b\u0011H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/ktor/client/plugins/compression/ContentEncoding$Companion;", "Lio/ktor/client/plugins/HttpClientPlugin;", "Lio/ktor/client/plugins/compression/ContentEncoding$Config;", "Lio/ktor/client/plugins/compression/ContentEncoding;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "install", "", "plugin", "scope", "Lio/ktor/client/HttpClient;", "prepare", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ktor-client-encoding"})
    public static final class Companion
    implements HttpClientPlugin<Config, ContentEncoding> {
        private Companion() {
        }

        @Override
        @NotNull
        public AttributeKey<ContentEncoding> getKey() {
            return key;
        }

        @Override
        @NotNull
        public ContentEncoding prepare(@NotNull Function1<? super Config, Unit> block2) {
            Config config2;
            Intrinsics.checkNotNullParameter(block2, "block");
            Config config3 = new Config();
            block2.invoke(config3);
            Config $this$prepare_u24lambda_u240 = config2 = config3;
            boolean bl = false;
            return new ContentEncoding($this$prepare_u24lambda_u240.getEncoders$ktor_client_encoding(), $this$prepare_u24lambda_u240.getQualityValues$ktor_client_encoding(), null);
        }

        @Override
        public void install(@NotNull ContentEncoding plugin, @NotNull HttpClient scope2) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(scope2, "scope");
            scope2.getRequestPipeline().intercept(HttpRequestPipeline.Phases.getState(), (Function3)new Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ ContentEncoding $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            ContentEncoding.access$setRequestHeaders(this.$plugin, (HttpRequestBuilder)$this$intercept.getContext());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<Object, HttpRequestBuilder> p1, @NotNull Object p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    return function3.invokeSuspend(Unit.INSTANCE);
                }
            });
            scope2.getResponsePipeline().intercept(HttpResponsePipeline.Phases.getReceive(), (Function3)new Function3<PipelineContext<HttpResponseContainer, HttpClientCall>, HttpResponseContainer, Continuation<? super Unit>, Object>(plugin, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ ContentEncoding $plugin;
                {
                    this.$plugin = $plugin;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Long contentLength;
                            ResultKt.throwOnFailure(object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            HttpResponseContainer httpResponseContainer = (HttpResponseContainer)this.L$1;
                            TypeInfo type2 = httpResponseContainer.component1();
                            Object content2 = httpResponseContainer.component2();
                            HttpMethod method = ((HttpClientCall)$this$intercept.getContext()).getRequest().getMethod();
                            Long l = contentLength = HttpMessagePropertiesKt.contentLength(((HttpClientCall)$this$intercept.getContext()).getResponse());
                            long l2 = 0L;
                            if (l != null && l == l2) {
                                return Unit.INSTANCE;
                            }
                            if (contentLength == null && Intrinsics.areEqual(method, HttpMethod.Companion.getHead())) {
                                return Unit.INSTANCE;
                            }
                            if (!(content2 instanceof ByteReadChannel)) {
                                return Unit.INSTANCE;
                            }
                            ContentEncoding $this$invokeSuspend_u24lambda_u240 = this.$plugin;
                            boolean bl = false;
                            HttpResponseContainer response2 = new HttpResponseContainer(type2, ContentEncoding.access$decode($this$invokeSuspend_u24lambda_u240, (CoroutineScope)$this$intercept.getContext(), ((HttpClientCall)$this$intercept.getContext()).getResponse(), (ByteReadChannel)content2));
                            this.L$0 = null;
                            this.label = 1;
                            Object object3 = $this$intercept.proceedWith(response2, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<HttpResponseContainer, HttpClientCall> p1, @NotNull HttpResponseContainer p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<HttpResponseContainer, HttpClientCall>, HttpResponseContainer, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

