/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\b\u001b\u001c\u001d\u001e\u001f !\"B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006#"}, d2={"Lio/ktor/http/ContentType;", "Lio/ktor/http/HeaderValueWithParameters;", "contentType", "", "contentSubtype", "parameters", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "existingContent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getContentSubtype", "()Ljava/lang/String;", "getContentType", "equals", "", "other", "", "hasParameter", "name", "value", "hashCode", "", "match", "pattern", "withParameter", "withoutParameters", "Application", "Audio", "Companion", "Image", "Message", "MultiPart", "Text", "Video", "ktor-http"})
public final class ContentType
extends HeaderValueWithParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentSubtype;
    @NotNull
    private static final ContentType Any = new ContentType("*", "*", null, 4, null);

    private ContentType(String contentType2, String contentSubtype, String existingContent, List<HeaderValueParam> parameters2) {
        super(existingContent, parameters2);
        this.contentType = contentType2;
        this.contentSubtype = contentSubtype;
    }

    /* synthetic */ ContentType(String string, String string2, String string3, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list2);
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContentSubtype() {
        return this.contentSubtype;
    }

    public ContentType(@NotNull String contentType2, @NotNull String contentSubtype, @NotNull List<HeaderValueParam> parameters2) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        Intrinsics.checkNotNullParameter(contentSubtype, "contentSubtype");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this(contentType2, contentSubtype, contentType2 + '/' + contentSubtype, parameters2);
    }

    public /* synthetic */ ContentType(String string, String string2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, string2, list2);
    }

    @NotNull
    public final ContentType withParameter(@NotNull String name2, @NotNull String value) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.hasParameter(name2, value)) {
            return this;
        }
        return new ContentType(this.contentType, this.contentSubtype, this.getContent(), CollectionsKt.plus((Collection)this.getParameters(), new HeaderValueParam(name2, value)));
    }

    private final boolean hasParameter(String name2, String value) {
        boolean bl;
        block0 : switch (this.getParameters().size()) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                HeaderValueParam it = this.getParameters().get(0);
                boolean bl2 = false;
                if (StringsKt.equals(it.getName(), name2, true) && StringsKt.equals(it.getValue(), value, true)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                Iterable $this$any$iv = this.getParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    boolean bl3 = false;
                    if (!(StringsKt.equals(it.getName(), name2, true) && StringsKt.equals(it.getValue(), value, true))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ContentType withoutParameters() {
        return this.getParameters().isEmpty() ? this : new ContentType(this.contentType, this.contentSubtype, null, 4, null);
    }

    public final boolean match(@NotNull ContentType pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        if (!Intrinsics.areEqual(pattern.contentType, "*") && !StringsKt.equals(pattern.contentType, this.contentType, true)) {
            return false;
        }
        if (!Intrinsics.areEqual(pattern.contentSubtype, "*") && !StringsKt.equals(pattern.contentSubtype, this.contentSubtype, true)) {
            return false;
        }
        for (HeaderValueParam headerValueParam : pattern.getParameters()) {
            boolean matches;
            boolean bl;
            block10: {
                String patternName = headerValueParam.component1();
                String patternValue = headerValueParam.component2();
                if (Intrinsics.areEqual(patternName, "*")) {
                    if (Intrinsics.areEqual(patternValue, "*")) {
                        bl = true;
                    } else {
                        Iterable $this$any$iv = this.getParameters();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                HeaderValueParam p = (HeaderValueParam)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.equals(p.getValue(), patternValue, true)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                } else {
                    String value = this.parameter(patternName);
                    bl = Intrinsics.areEqual(patternValue, "*") ? value != null : StringsKt.equals(value, patternValue, true);
                }
            }
            if (matches = bl) continue;
            return false;
        }
        return true;
    }

    public final boolean match(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return this.match(Companion.parse(pattern));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ContentType && StringsKt.equals(this.contentType, ((ContentType)other).contentType, true) && StringsKt.equals(this.contentSubtype, ((ContentType)other).contentSubtype, true) && Intrinsics.areEqual(this.getParameters(), ((ContentType)other).getParameters());
    }

    public int hashCode() {
        String string = this.contentType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        int result2 = string.hashCode();
        String string2 = this.contentSubtype.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        result2 += 31 * result2 + string2.hashCode();
        return result2 += 31 * ((Object)this.getParameters()).hashCode();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "parse", "value", "", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ContentType parse(@NotNull String value) {
            void parameters2;
            Intrinsics.checkNotNullParameter(value, "value");
            if (StringsKt.isBlank(value)) {
                return this.getAny();
            }
            HeaderValueWithParameters.Companion this_$iv = HeaderValueWithParameters.Companion;
            boolean $i$f$parse = false;
            HeaderValue headerValue$iv = CollectionsKt.last(HttpHeaderValueParserKt.parseHeaderValue(value));
            List<HeaderValueParam> list2 = headerValue$iv.getParams();
            String parts = headerValue$iv.getValue();
            boolean bl = false;
            int slash = StringsKt.indexOf$default((CharSequence)parts, '/', 0, false, 6, null);
            if (slash == -1) {
                if (Intrinsics.areEqual(((Object)StringsKt.trim((CharSequence)parts)).toString(), "*")) {
                    return Companion.getAny();
                }
                throw new BadContentTypeFormatException(value);
            }
            String string = parts.substring(0, slash);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String type2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)type2).length() == 0) {
                throw new BadContentTypeFormatException(value);
            }
            String string2 = parts.substring(slash + 1);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            String subtype = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (StringsKt.contains$default((CharSequence)type2, ' ', false, 2, null) || StringsKt.contains$default((CharSequence)subtype, ' ', false, 2, null)) {
                throw new BadContentTypeFormatException(value);
            }
            if (((CharSequence)subtype).length() == 0 || StringsKt.contains$default((CharSequence)subtype, '/', false, 2, null)) {
                throw new BadContentTypeFormatException(value);
            }
            return new ContentType(type2, subtype, (List<HeaderValueParam>)parameters2);
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b-\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006\u00a8\u00061"}, d2={"Lio/ktor/http/ContentType$Application;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Atom", "getAtom", "Cbor", "getCbor", "Docx", "getDocx", "FontWoff", "getFontWoff", "FormUrlEncoded", "getFormUrlEncoded", "GZip", "getGZip", "HalJson", "getHalJson", "JavaScript", "getJavaScript", "Json", "getJson", "OctetStream", "getOctetStream", "Pdf", "getPdf", "Pptx", "getPptx", "ProblemJson", "getProblemJson", "ProblemXml", "getProblemXml", "ProtoBuf", "getProtoBuf", "Rss", "getRss", "Wasm", "getWasm", "Xlsx", "getXlsx", "Xml", "getXml", "Xml_Dtd", "getXml_Dtd", "Zip", "getZip", "ktor-http"})
    public static final class Application {
        @NotNull
        public static final Application INSTANCE = new Application();
        @NotNull
        private static final ContentType Any = new ContentType("application", "*", null, 4, null);
        @NotNull
        private static final ContentType Atom = new ContentType("application", "atom+xml", null, 4, null);
        @NotNull
        private static final ContentType Cbor = new ContentType("application", "cbor", null, 4, null);
        @NotNull
        private static final ContentType Json = new ContentType("application", "json", null, 4, null);
        @NotNull
        private static final ContentType HalJson = new ContentType("application", "hal+json", null, 4, null);
        @NotNull
        private static final ContentType JavaScript = new ContentType("application", "javascript", null, 4, null);
        @NotNull
        private static final ContentType OctetStream = new ContentType("application", "octet-stream", null, 4, null);
        @NotNull
        private static final ContentType FontWoff = new ContentType("application", "font-woff", null, 4, null);
        @NotNull
        private static final ContentType Rss = new ContentType("application", "rss+xml", null, 4, null);
        @NotNull
        private static final ContentType Xml = new ContentType("application", "xml", null, 4, null);
        @NotNull
        private static final ContentType Xml_Dtd = new ContentType("application", "xml-dtd", null, 4, null);
        @NotNull
        private static final ContentType Zip = new ContentType("application", "zip", null, 4, null);
        @NotNull
        private static final ContentType GZip = new ContentType("application", "gzip", null, 4, null);
        @NotNull
        private static final ContentType FormUrlEncoded = new ContentType("application", "x-www-form-urlencoded", null, 4, null);
        @NotNull
        private static final ContentType Pdf = new ContentType("application", "pdf", null, 4, null);
        @NotNull
        private static final ContentType Xlsx = new ContentType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet", null, 4, null);
        @NotNull
        private static final ContentType Docx = new ContentType("application", "vnd.openxmlformats-officedocument.wordprocessingml.document", null, 4, null);
        @NotNull
        private static final ContentType Pptx = new ContentType("application", "vnd.openxmlformats-officedocument.presentationml.presentation", null, 4, null);
        @NotNull
        private static final ContentType ProtoBuf = new ContentType("application", "protobuf", null, 4, null);
        @NotNull
        private static final ContentType Wasm = new ContentType("application", "wasm", null, 4, null);
        @NotNull
        private static final ContentType ProblemJson = new ContentType("application", "problem+json", null, 4, null);
        @NotNull
        private static final ContentType ProblemXml = new ContentType("application", "problem+xml", null, 4, null);

        private Application() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getAtom() {
            return Atom;
        }

        @NotNull
        public final ContentType getCbor() {
            return Cbor;
        }

        @NotNull
        public final ContentType getJson() {
            return Json;
        }

        @NotNull
        public final ContentType getHalJson() {
            return HalJson;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getOctetStream() {
            return OctetStream;
        }

        @NotNull
        public final ContentType getFontWoff() {
            return FontWoff;
        }

        @NotNull
        public final ContentType getRss() {
            return Rss;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getXml_Dtd() {
            return Xml_Dtd;
        }

        @NotNull
        public final ContentType getZip() {
            return Zip;
        }

        @NotNull
        public final ContentType getGZip() {
            return GZip;
        }

        @NotNull
        public final ContentType getFormUrlEncoded() {
            return FormUrlEncoded;
        }

        @NotNull
        public final ContentType getPdf() {
            return Pdf;
        }

        @NotNull
        public final ContentType getXlsx() {
            return Xlsx;
        }

        @NotNull
        public final ContentType getDocx() {
            return Docx;
        }

        @NotNull
        public final ContentType getPptx() {
            return Pptx;
        }

        @NotNull
        public final ContentType getProtoBuf() {
            return ProtoBuf;
        }

        @NotNull
        public final ContentType getWasm() {
            return Wasm;
        }

        @NotNull
        public final ContentType getProblemJson() {
            return ProblemJson;
        }

        @NotNull
        public final ContentType getProblemXml() {
            return ProblemXml;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/ktor/http/ContentType$Audio;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "ktor-http"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE = new Audio();
        @NotNull
        private static final ContentType Any = new ContentType("audio", "*", null, 4, null);
        @NotNull
        private static final ContentType MP4 = new ContentType("audio", "mp4", null, 4, null);
        @NotNull
        private static final ContentType MPEG = new ContentType("audio", "mpeg", null, 4, null);
        @NotNull
        private static final ContentType OGG = new ContentType("audio", "ogg", null, 4, null);

        private Audio() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/ContentType$Image;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "GIF", "getGIF", "JPEG", "getJPEG", "PNG", "getPNG", "SVG", "getSVG", "XIcon", "getXIcon", "ktor-http"})
    public static final class Image {
        @NotNull
        public static final Image INSTANCE = new Image();
        @NotNull
        private static final ContentType Any = new ContentType("image", "*", null, 4, null);
        @NotNull
        private static final ContentType GIF = new ContentType("image", "gif", null, 4, null);
        @NotNull
        private static final ContentType JPEG = new ContentType("image", "jpeg", null, 4, null);
        @NotNull
        private static final ContentType PNG = new ContentType("image", "png", null, 4, null);
        @NotNull
        private static final ContentType SVG = new ContentType("image", "svg+xml", null, 4, null);
        @NotNull
        private static final ContentType XIcon = new ContentType("image", "x-icon", null, 4, null);

        private Image() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getGIF() {
            return GIF;
        }

        @NotNull
        public final ContentType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final ContentType getPNG() {
            return PNG;
        }

        @NotNull
        public final ContentType getSVG() {
            return SVG;
        }

        @NotNull
        public final ContentType getXIcon() {
            return XIcon;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/ktor/http/ContentType$Message;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Http", "getHttp", "ktor-http"})
    public static final class Message {
        @NotNull
        public static final Message INSTANCE = new Message();
        @NotNull
        private static final ContentType Any = new ContentType("message", "*", null, 4, null);
        @NotNull
        private static final ContentType Http = new ContentType("message", "http", null, 4, null);

        private Message() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getHttp() {
            return Http;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/ContentType$MultiPart;", "", "()V", "Alternative", "Lio/ktor/http/ContentType;", "getAlternative", "()Lio/ktor/http/ContentType;", "Any", "getAny", "ByteRanges", "getByteRanges", "Encrypted", "getEncrypted", "FormData", "getFormData", "Mixed", "getMixed", "Related", "getRelated", "Signed", "getSigned", "ktor-http"})
    public static final class MultiPart {
        @NotNull
        public static final MultiPart INSTANCE = new MultiPart();
        @NotNull
        private static final ContentType Any = new ContentType("multipart", "*", null, 4, null);
        @NotNull
        private static final ContentType Mixed = new ContentType("multipart", "mixed", null, 4, null);
        @NotNull
        private static final ContentType Alternative = new ContentType("multipart", "alternative", null, 4, null);
        @NotNull
        private static final ContentType Related = new ContentType("multipart", "related", null, 4, null);
        @NotNull
        private static final ContentType FormData = new ContentType("multipart", "form-data", null, 4, null);
        @NotNull
        private static final ContentType Signed = new ContentType("multipart", "signed", null, 4, null);
        @NotNull
        private static final ContentType Encrypted = new ContentType("multipart", "encrypted", null, 4, null);
        @NotNull
        private static final ContentType ByteRanges = new ContentType("multipart", "byteranges", null, 4, null);

        private MultiPart() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMixed() {
            return Mixed;
        }

        @NotNull
        public final ContentType getAlternative() {
            return Alternative;
        }

        @NotNull
        public final ContentType getRelated() {
            return Related;
        }

        @NotNull
        public final ContentType getFormData() {
            return FormData;
        }

        @NotNull
        public final ContentType getSigned() {
            return Signed;
        }

        @NotNull
        public final ContentType getEncrypted() {
            return Encrypted;
        }

        @NotNull
        public final ContentType getByteRanges() {
            return ByteRanges;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/ktor/http/ContentType$Text;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "CSS", "getCSS", "CSV", "getCSV", "EventStream", "getEventStream", "Html", "getHtml", "JavaScript", "getJavaScript", "Plain", "getPlain", "VCard", "getVCard", "Xml", "getXml", "ktor-http"})
    public static final class Text {
        @NotNull
        public static final Text INSTANCE = new Text();
        @NotNull
        private static final ContentType Any = new ContentType("text", "*", null, 4, null);
        @NotNull
        private static final ContentType Plain = new ContentType("text", "plain", null, 4, null);
        @NotNull
        private static final ContentType CSS = new ContentType("text", "css", null, 4, null);
        @NotNull
        private static final ContentType CSV = new ContentType("text", "csv", null, 4, null);
        @NotNull
        private static final ContentType Html = new ContentType("text", "html", null, 4, null);
        @NotNull
        private static final ContentType JavaScript = new ContentType("text", "javascript", null, 4, null);
        @NotNull
        private static final ContentType VCard = new ContentType("text", "vcard", null, 4, null);
        @NotNull
        private static final ContentType Xml = new ContentType("text", "xml", null, 4, null);
        @NotNull
        private static final ContentType EventStream = new ContentType("text", "event-stream", null, 4, null);

        private Text() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getPlain() {
            return Plain;
        }

        @NotNull
        public final ContentType getCSS() {
            return CSS;
        }

        @NotNull
        public final ContentType getCSV() {
            return CSV;
        }

        @NotNull
        public final ContentType getHtml() {
            return Html;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getVCard() {
            return VCard;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getEventStream() {
            return EventStream;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/ktor/http/ContentType$Video;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "QuickTime", "getQuickTime", "ktor-http"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE = new Video();
        @NotNull
        private static final ContentType Any = new ContentType("video", "*", null, 4, null);
        @NotNull
        private static final ContentType MPEG = new ContentType("video", "mpeg", null, 4, null);
        @NotNull
        private static final ContentType MP4 = new ContentType("video", "mp4", null, 4, null);
        @NotNull
        private static final ContentType OGG = new ContentType("video", "ogg", null, 4, null);
        @NotNull
        private static final ContentType QuickTime = new ContentType("video", "quicktime", null, 4, null);

        private Video() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        @NotNull
        public final ContentType getQuickTime() {
            return QuickTime;
        }
    }
}

