/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t\u001a>\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00020\u000fj\b\u0012\u0004\u0012\u00020\u0002`\u00100\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a6\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00130\u000fj\b\u0012\u0004\u0012\u00020\u0013`\u00100\u000eH\u0002\u001a$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0018\u001a\u00020\t*\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u001a\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0001*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00150\u001c\u001a$\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0001\"\u0004\b\u0000\u0010\u001e*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u00010\u000eH\u0002\u00a8\u0006\u001f"}, d2={"parseAndSortContentTypeHeader", "", "Lio/ktor/http/HeaderValue;", "header", "", "parseAndSortHeader", "parseHeaderValue", "text", "parametersOnly", "", "parseHeaderValueItem", "", "start", "items", "Lkotlin/Lazy;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "parseHeaderValueParameter", "parameters", "Lio/ktor/http/HeaderValueParam;", "parseHeaderValueParameterValue", "Lkotlin/Pair;", "value", "parseHeaderValueParameterValueQuoted", "nextIsSemicolonOrEnd", "subtrim", "end", "toHeaderParamsList", "", "valueOrEmpty", "T", "ktor-http"})
public final class HttpHeaderValueParserKt {
    @NotNull
    public static final List<HeaderValue> parseAndSortHeader(@Nullable String header) {
        Iterable $this$sortedByDescending$iv = HttpHeaderValueParserKt.parseHeaderValue(header);
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                HeaderValue it = (HeaderValue)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getQuality());
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseAndSortContentTypeHeader(@Nullable String header) {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                HeaderValue it = (HeaderValue)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getQuality());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    HeaderValue it = (HeaderValue)a;
                    boolean bl = false;
                    ContentType contentType2 = ContentType.Companion.parse(it.getValue());
                    int asterisks = 0;
                    if (Intrinsics.areEqual(contentType2.getContentType(), "*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual(contentType2.getContentSubtype(), "*")) {
                        ++asterisks;
                    }
                    it = (HeaderValue)b;
                    Comparable comparable = Integer.valueOf(asterisks);
                    bl = false;
                    contentType2 = ContentType.Companion.parse(it.getValue());
                    asterisks = 0;
                    if (Intrinsics.areEqual(contentType2.getContentType(), "*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual(contentType2.getContentSubtype(), "*")) {
                        ++asterisks;
                    }
                    n = ComparisonsKt.compareValues(comparable, asterisks);
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)HttpHeaderValueParserKt.parseHeaderValue(header), new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    HeaderValue it = (HeaderValue)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getParams().size());
                    it = (HeaderValue)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getParams().size());
                }
                return n;
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text2) {
        return HttpHeaderValueParserKt.parseHeaderValue(text2, false);
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text2, boolean parametersOnly) {
        if (text2 == null) {
            return CollectionsKt.emptyList();
        }
        int position = 0;
        Lazy items2 = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)parseHeaderValue.items.1.INSTANCE);
        while (position <= StringsKt.getLastIndex(text2)) {
            position = HttpHeaderValueParserKt.parseHeaderValueItem(text2, position, items2, parametersOnly);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(items2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HeaderValueParam> toHeaderParamsList(@NotNull Iterable<Pair<String, String>> $this$toHeaderParamsList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderParamsList, "<this>");
        Iterable<Pair<String, String>> $this$map$iv = $this$toHeaderParamsList;
        boolean $i$f$map = false;
        Iterable<Pair<String, String>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HeaderValueParam((String)it.getFirst(), (String)it.getSecond()));
        }
        return (List)destination$iv$iv;
    }

    private static final <T> List<T> valueOrEmpty(Lazy<? extends List<? extends T>> $this$valueOrEmpty) {
        return $this$valueOrEmpty.isInitialized() ? $this$valueOrEmpty.getValue() : CollectionsKt.emptyList();
    }

    private static final String subtrim(String $this$subtrim, int start2, int end2) {
        String string = $this$subtrim.substring(start2, end2);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final int parseHeaderValueItem(String text2, int start2, Lazy<? extends ArrayList<HeaderValue>> items2, boolean parametersOnly) {
        Integer valueEnd;
        int position = start2;
        Lazy parameters2 = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)parseHeaderValueItem.parameters.1.INSTANCE);
        Integer n = valueEnd = parametersOnly ? Integer.valueOf(position) : null;
        while (position <= StringsKt.getLastIndex(text2)) {
            char c = text2.charAt(position);
            if (c == ',') {
                Integer n2 = valueEnd;
                items2.getValue().add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text2, start2, n2 != null ? n2 : position), HttpHeaderValueParserKt.valueOrEmpty(parameters2)));
                return position + 1;
            }
            if (c == ';') {
                if (valueEnd == null) {
                    valueEnd = position;
                }
                position = HttpHeaderValueParserKt.parseHeaderValueParameter(text2, position + 1, parameters2);
                continue;
            }
            position = parametersOnly ? HttpHeaderValueParserKt.parseHeaderValueParameter(text2, position, parameters2) : position + 1;
        }
        Integer n3 = valueEnd;
        items2.getValue().add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text2, start2, n3 != null ? n3 : position), HttpHeaderValueParserKt.valueOrEmpty(parameters2)));
        return position;
    }

    private static final int parseHeaderValueParameter(String text2, int start2, Lazy<? extends ArrayList<HeaderValueParam>> parameters2) {
        int position;
        for (position = start2; position <= StringsKt.getLastIndex(text2); ++position) {
            char c = text2.charAt(position);
            if (c == '=') {
                Pair<Integer, String> pair = HttpHeaderValueParserKt.parseHeaderValueParameterValue(text2, position + 1);
                int paramEnd = ((Number)pair.component1()).intValue();
                String paramValue = pair.component2();
                HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters2, text2, start2, position, paramValue);
                return paramEnd;
            }
            if (!(c == ';' ? true : c == ',')) continue;
            HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters2, text2, start2, position, "");
            return position;
        }
        HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters2, text2, start2, position, "");
        return position;
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValue(String value, int start2) {
        int position;
        if (value.length() == start2) {
            return TuplesKt.to(start2, "");
        }
        if (value.charAt(start2) == '\"') {
            return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(value, position + 1);
        }
        for (position = start2; position <= StringsKt.getLastIndex(value); ++position) {
            char c = value.charAt(position);
            if (!(c == ';' ? true : c == ',')) continue;
            return TuplesKt.to(position, HttpHeaderValueParserKt.subtrim(value, start2, position));
        }
        return TuplesKt.to(position, HttpHeaderValueParserKt.subtrim(value, start2, position));
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String value, int start2) {
        int position = start2;
        StringBuilder builder = new StringBuilder();
        while (position <= StringsKt.getLastIndex(value)) {
            char currentChar = value.charAt(position);
            if (currentChar == '\"' && HttpHeaderValueParserKt.nextIsSemicolonOrEnd(value, position)) {
                Integer n = position + 1;
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue(string, "builder.toString()");
                return TuplesKt.to(n, string);
            }
            if (currentChar == '\\' && position < StringsKt.getLastIndex(value) - 2) {
                builder.append(value.charAt(position + 1));
                position += 2;
                continue;
            }
            builder.append(currentChar);
            ++position;
        }
        Integer n = position;
        char c = '\"';
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "builder.toString()");
        String string2 = string;
        return TuplesKt.to(n, c + string2);
    }

    private static final boolean nextIsSemicolonOrEnd(String $this$nextIsSemicolonOrEnd, int start2) {
        int position;
        for (position = start2 + 1; position < $this$nextIsSemicolonOrEnd.length() && $this$nextIsSemicolonOrEnd.charAt(position) == ' '; ++position) {
        }
        return position == $this$nextIsSemicolonOrEnd.length() || $this$nextIsSemicolonOrEnd.charAt(position) == ';';
    }

    private static final void parseHeaderValueParameter$addParam(Lazy<? extends ArrayList<HeaderValueParam>> $parameters, String text2, int start2, int end2, String value) {
        String name2 = HttpHeaderValueParserKt.subtrim(text2, start2, end2);
        if (((CharSequence)name2).length() == 0) {
            return;
        }
        $parameters.getValue().add(new HeaderValueParam(name2, value));
    }
}

