/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.CertificateInfo;
import io.ktor.network.tls.CertificateType;
import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.Digest;
import io.ktor.network.tls.EncryptionInfo;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.SecretExchangeType;
import io.ktor.network.tls.TLSClientHandshake;
import io.ktor.network.tls.TLSClientHandshakeKt;
import io.ktor.network.tls.TLSConfig;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.UtilsKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.CloseableJVMKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import io.ktor.utils.io.core.PreviewKt;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010/\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0011\u00102\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J5\u00105\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\b\u00100\u001a\u0004\u0018\u000101H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010<J\u0011\u0010=\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010>\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010?\u001a\u00020.H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u0010@\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u001b\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020;H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ!\u0010E\u001a\u0002032\u0006\u0010C\u001a\u00020;2\u0006\u0010F\u001a\u00020BH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0019\u0010H\u001a\u0002032\u0006\u0010I\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJ\u0011\u0010K\u001a\u000203H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J3\u0010L\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010M\u001a\u00020\u00122\b\u00100\u001a\u0004\u0018\u000101H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ2\u0010O\u001a\u0002032\u0006\u0010P\u001a\u00020Q2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002030S\u00a2\u0006\u0002\bUH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ\u0010\u0010W\u001a\u0002032\u0006\u0010-\u001a\u00020.H\u0002R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0010\u001a\u0004\b#\u0010$R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u001c\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006X"}, d2={"Lio/ktor/network/tls/TLSClientHandshake;", "Lkotlinx/coroutines/CoroutineScope;", "rawInput", "Lio/ktor/utils/io/ByteReadChannel;", "rawOutput", "Lio/ktor/utils/io/ByteWriteChannel;", "config", "Lio/ktor/network/tls/TLSConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lio/ktor/network/tls/TLSConfig;Lkotlin/coroutines/CoroutineContext;)V", "cipher", "Lio/ktor/network/tls/cipher/TLSCipher;", "getCipher", "()Lio/ktor/network/tls/cipher/TLSCipher;", "cipher$delegate", "Lkotlin/Lazy;", "clientSeed", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "digest", "Lio/ktor/network/tls/Digest;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "handshakes", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lio/ktor/network/tls/TLSHandshake;", "getHandshakes$annotations", "()V", "input", "Lio/ktor/network/tls/TLSRecord;", "getInput$annotations", "getInput", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "keyMaterial", "getKeyMaterial", "()[B", "keyMaterial$delegate", "masterSecret", "Ljavax/crypto/spec/SecretKeySpec;", "output", "Lkotlinx/coroutines/channels/SendChannel;", "getOutput$annotations", "getOutput", "()Lkotlinx/coroutines/channels/SendChannel;", "serverHello", "Lio/ktor/network/tls/TLSServerHello;", "generatePreSecret", "encryptionInfo", "Lio/ktor/network/tls/EncryptionInfo;", "handleCertificatesAndKeys", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleServerDone", "exchangeType", "Lio/ktor/network/tls/SecretExchangeType;", "serverCertificate", "Ljava/security/cert/Certificate;", "certificateInfo", "Lio/ktor/network/tls/CertificateInfo;", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;Lio/ktor/network/tls/CertificateInfo;Lio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "negotiate", "receiveServerFinished", "receiveServerHello", "sendChangeCipherSpec", "sendClientCertificate", "Lio/ktor/network/tls/CertificateAndKey;", "info", "(Lio/ktor/network/tls/CertificateInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientCertificateVerify", "certificateAndKey", "(Lio/ktor/network/tls/CertificateInfo;Lio/ktor/network/tls/CertificateAndKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientFinished", "masterKey", "(Ljavax/crypto/spec/SecretKeySpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendClientHello", "sendClientKeyExchange", "preSecret", "(Lio/ktor/network/tls/SecretExchangeType;Ljava/security/cert/Certificate;[BLio/ktor/network/tls/EncryptionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendHandshakeRecord", "handshakeType", "Lio/ktor/network/tls/TLSHandshakeType;", "block", "Lkotlin/Function1;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/network/tls/TLSHandshakeType;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyHello", "ktor-network-tls"})
public final class TLSClientHandshake
implements CoroutineScope {
    @NotNull
    private final TLSConfig config;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final BytePacketBuilder digest;
    @NotNull
    private final byte[] clientSeed;
    private volatile TLSServerHello serverHello;
    private volatile SecretKeySpec masterSecret;
    @NotNull
    private final Lazy keyMaterial$delegate;
    @NotNull
    private final Lazy cipher$delegate;
    @NotNull
    private final ReceiveChannel<TLSRecord> input;
    @NotNull
    private final SendChannel<TLSRecord> output;
    @NotNull
    private final ReceiveChannel<TLSHandshake> handshakes;

    public TLSClientHandshake(@NotNull ByteReadChannel rawInput, @NotNull ByteWriteChannel rawOutput, @NotNull TLSConfig config2, @NotNull CoroutineContext coroutineContext2) {
        Intrinsics.checkNotNullParameter(rawInput, "rawInput");
        Intrinsics.checkNotNullParameter(rawOutput, "rawOutput");
        Intrinsics.checkNotNullParameter(config2, "config");
        Intrinsics.checkNotNullParameter(coroutineContext2, "coroutineContext");
        this.config = config2;
        this.coroutineContext = coroutineContext2;
        this.digest = UtilsKt.Digest();
        this.clientSeed = TLSClientHandshakeKt.access$generateClientSeed(this.config.getRandom());
        this.keyMaterial$delegate = LazyKt.lazy((Function0)new Function0<byte[]>(this){
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final byte[] invoke() {
                TLSServerHello tLSServerHello = TLSClientHandshake.access$getServerHello$p(this.this$0);
                if (tLSServerHello == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                    tLSServerHello = null;
                }
                CipherSuite cipherSuite = tLSServerHello.getCipherSuite();
                TLSClientHandshake tLSClientHandshake = this.this$0;
                CipherSuite $this$invoke_u24lambda_u240 = cipherSuite;
                boolean bl = false;
                SecretKeySpec secretKeySpec = TLSClientHandshake.access$getMasterSecret$p(tLSClientHandshake);
                if (secretKeySpec == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("masterSecret");
                    secretKeySpec = null;
                }
                SecretKey secretKey = secretKeySpec;
                TLSServerHello tLSServerHello2 = TLSClientHandshake.access$getServerHello$p(tLSClientHandshake);
                if (tLSServerHello2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                    tLSServerHello2 = null;
                }
                return KeysKt.keyMaterial(secretKey, ArraysKt.plus(tLSServerHello2.getServerSeed(), TLSClientHandshake.access$getClientSeed$p(tLSClientHandshake)), $this$invoke_u24lambda_u240.getKeyStrengthInBytes(), $this$invoke_u24lambda_u240.getMacStrengthInBytes(), $this$invoke_u24lambda_u240.getFixedIvLength());
            }
        });
        this.cipher$delegate = LazyKt.lazy((Function0)new Function0<TLSCipher>(this){
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TLSCipher invoke() {
                TLSServerHello tLSServerHello = TLSClientHandshake.access$getServerHello$p(this.this$0);
                if (tLSServerHello == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                    tLSServerHello = null;
                }
                return TLSCipher.Companion.fromSuite(tLSServerHello.getCipherSuite(), TLSClientHandshake.access$getKeyMaterial(this.this$0));
            }
        });
        this.input = ProduceKt.produce$default(this, new CoroutineName("cio-tls-parser"), 0, new Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object>(rawInput, this, null){
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ByteReadChannel $rawInput;
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.$rawInput = $rawInput;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super TLSRecord> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        this.output = ActorKt.actor$default(this, new CoroutineName("cio-tls-encoder"), 0, null, null, new Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object>(this, rawOutput, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ ByteWriteChannel $rawOutput;
            {
                this.this$0 = $receiver;
                this.$rawOutput = $rawOutput;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ActorScope<TLSRecord>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull ActorScope<TLSRecord> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 14, null);
        this.handshakes = ProduceKt.produce$default(this, new CoroutineName("cio-tls-handshake"), 0, new Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$produce = (ProducerScope)this.L$0;
                        while (true) {
                            this.L$0 = $this$produce;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 1;
                            v0 = this.this$0.getInput().receive(this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl20
                            break;
                        }
                    }
                    case 1: {
                        $this$produce = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if ((record = (TLSRecord)v0).getType() != TLSRecordType.Handshake) {
                            record.getPacket().release();
                            var4_5 = "TLS handshake expected, got " + (Object)record.getType();
                            throw new IllegalStateException(var4_5.toString());
                        }
                        packet = record.getPacket();
lbl25:
                        // 2 sources

                        while (true) {
                            $this$isNotEmpty$iv = packet;
                            $i$f$isNotEmpty = false;
                            if (!($this$isNotEmpty$iv.getEndOfInput() == false)) ** continue;
                            handshake = ParserKt.readTLSHandshake(packet);
                            if (handshake.getType() == TLSHandshakeType.HelloRequest) continue;
                            if (handshake.getType() != TLSHandshakeType.Finished) {
                                UtilsKt.plusAssign-Hh8V18w(TLSClientHandshake.access$getDigest$p(this.this$0), handshake);
                            }
                            this.L$0 = $this$produce;
                            this.L$1 = packet;
                            this.L$2 = handshake;
                            this.label = 2;
                            v1 = $this$produce.getChannel().send(handshake, this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl47
                            break;
                        }
                    }
                    case 2: {
                        handshake = (TLSHandshake)this.L$2;
                        packet = (ByteReadPacket)this.L$1;
                        $this$produce = (ProducerScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl47:
                        // 2 sources

                        if (handshake.getType() == TLSHandshakeType.Finished) ** break;
                        ** continue;
                        packet.release();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super TLSHandshake>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super TLSHandshake> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final byte[] getKeyMaterial() {
        Lazy lazy = this.keyMaterial$delegate;
        return (byte[])lazy.getValue();
    }

    private final TLSCipher getCipher() {
        Lazy lazy = this.cipher$delegate;
        return (TLSCipher)lazy.getValue();
    }

    @NotNull
    public final ReceiveChannel<TLSRecord> getInput() {
        return this.input;
    }

    public static /* synthetic */ void getInput$annotations() {
    }

    @NotNull
    public final SendChannel<TLSRecord> getOutput() {
        return this.output;
    }

    public static /* synthetic */ void getOutput$annotations() {
    }

    private static /* synthetic */ void getHandshakes$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object negotiate(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof negotiate.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.negotiate(this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$use$iv = Digest.box-impl(this.digest);
                $i$f$use = false;
                closed$iv = 0;
                $this$use$iv.unbox-impl();
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.I$0 = closed$iv;
                $continuation.label = 1;
                v0 = this.sendClientHello($continuation);
                ** if (v0 != var10_4) goto lbl27
lbl26:
                // 1 sources

                return var10_4;
lbl27:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl38:
                // 2 sources

                var7_16 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.L$2 = var7_16;
                $continuation.I$0 = closed$iv;
                $continuation.label = 2;
                v1 = this.receiveServerHello($continuation);
                ** if (v1 != var10_4) goto lbl47
lbl46:
                // 1 sources

                return var10_4;
lbl47:
                // 1 sources

                ** GOTO lbl59
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                var7_16 = (TLSClientHandshake)$continuation.L$2;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl59:
                // 2 sources

                var7_16.serverHello = (TLSServerHello)v1;
                v2 = this.serverHello;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                    v2 = null;
                }
                this.verifyHello(v2);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.L$2 = null;
                $continuation.I$0 = closed$iv;
                $continuation.label = 3;
                v3 = this.handleCertificatesAndKeys($continuation);
                ** if (v3 != var10_4) goto lbl73
lbl72:
                // 1 sources

                return var10_4;
lbl73:
                // 1 sources

                ** GOTO lbl84
            }
            case 3: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$1;
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl84:
                // 2 sources

                $continuation.L$0 = $this$use$iv;
                $continuation.L$1 = null;
                $continuation.I$0 = closed$iv;
                $continuation.label = 4;
                v4 = this.receiveServerFinished($continuation);
                ** if (v4 != var10_4) goto lbl91
lbl90:
                // 1 sources

                return var10_4;
lbl91:
                // 1 sources

                ** GOTO lbl101
            }
            case 4: {
                $i$f$use = false;
                $i$a$-use-TLSClientHandshake$negotiate$2 = false;
                closed$iv = $continuation.I$0;
                $this$use$iv = (Digest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v4 = $result;
lbl101:
                    // 2 sources

                    var5_18 = Unit.INSTANCE;
                }
                catch (Throwable first$iv) {
                    try {
                        try {
                            closed$iv = 1;
                            $this$use$iv.close();
                        }
                        catch (Throwable second$iv) {
                            CloseableJVMKt.addSuppressedInternal(first$iv, second$iv);
                        }
                        throw first$iv;
                    }
                    catch (Throwable var6_15) {
                        if (closed$iv == 0) {
                            $this$use$iv.close();
                        }
                        throw var6_15;
                    }
                }
                $this$use$iv.close();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyHello(TLSServerHello serverHello) {
        boolean bl;
        List<HashAndSign> serverExchanges;
        List clientExchanges;
        block8: {
            void $this$filterTo$iv$iv;
            CipherSuite suite = serverHello.getCipherSuite();
            if (!this.config.getCipherSuites().contains(suite)) {
                boolean $i$a$-check-TLSClientHandshake$verifyHello$22 = false;
                String $i$a$-check-TLSClientHandshake$verifyHello$22 = "Unsupported cipher suite " + suite.getName() + " in SERVER_HELLO";
                throw new IllegalStateException($i$a$-check-TLSClientHandshake$verifyHello$22.toString());
            }
            Iterable $this$filter$iv = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HashAndSign it = (HashAndSign)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getHash() == suite.getHash() && it.getSign() == suite.getSignatureAlgorithm())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            clientExchanges = (List)destination$iv$iv;
            if (clientExchanges.isEmpty()) {
                throw new TLSException("No appropriate hash algorithm for suite: " + suite, null, 2, null);
            }
            serverExchanges = serverHello.getHashAndSignAlgorithms();
            if (serverExchanges.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = clientExchanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HashAndSign it = (HashAndSign)element$iv;
                    boolean bl3 = false;
                    if (!serverExchanges.contains(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            String message2 = "No sign algorithms in common. \nServer candidates: " + serverExchanges + " \nClient candidates: " + clientExchanges;
            throw new TLSException(message2, null, 2, null);
        }
    }

    private final Object sendClientHello(Continuation<? super Unit> $completion) {
        Object object = this.sendHandshakeRecord(TLSHandshakeType.ClientHello, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(this){
            final /* synthetic */ TLSClientHandshake this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkNotNullParameter($this$sendHandshakeRecord, "$this$sendHandshakeRecord");
                RenderKt.writeTLSClientHello($this$sendHandshakeRecord, TLSVersion.TLS12, TLSClientHandshake.access$getConfig$p(this.this$0).getCipherSuites(), TLSClientHandshake.access$getClientSeed$p(this.this$0), new byte[32], TLSClientHandshake.access$getConfig$p(this.this$0).getServerName());
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object receiveServerHello(Continuation<? super TLSServerHello> var1_1) {
        if (!(var1_1 instanceof receiveServerHello.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$receiveServerHello(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.label = 1;
                v0 = this.handshakes.receive($continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl20:
                // 2 sources

                if (!((handshake = (TLSHandshake)v0).getType() == TLSHandshakeType.ServerHello)) {
                    $i$a$-check-TLSClientHandshake$receiveServerHello$2 = false;
                    var3_7 = "Expected TLS handshake ServerHello but got " + (Object)handshake.getType();
                    throw new IllegalStateException(var3_7.toString());
                }
                return ParserKt.readTLSServerHello(handshake.getPacket());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object handleCertificatesAndKeys(Continuation<? super Unit> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleServerDone(SecretExchangeType var1_1, Certificate var2_2, CertificateInfo var3_3, EncryptionInfo var4_4, Continuation<? super Unit> var5_5) {
        block19: {
            block18: {
                if (!(var5_5 instanceof handleServerDone.1)) ** GOTO lbl-1000
                var12_6 = var5_5;
                if ((var12_6.label & -2147483648) != 0) {
                    var12_6.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var5_5){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        /* synthetic */ Object result;
                        final /* synthetic */ TLSClientHandshake this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return TLSClientHandshake.access$handleServerDone(this.this$0, null, null, null, null, this);
                        }
                    };
                }
                $result = $continuation.result;
                var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        v0 = certificateInfo;
                        if (v0 == null) break;
                        it = v0;
                        $i$a$-let-TLSClientHandshake$handleServerDone$chain$1 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = exchangeType;
                        $continuation.L$2 = serverCertificate;
                        $continuation.L$3 = certificateInfo;
                        $continuation.L$4 = encryptionInfo;
                        $continuation.label = 1;
                        v1 = this.sendClientCertificate((CertificateInfo)it, $continuation);
                        if (v1 == var13_8) {
                            return var13_8;
                        }
                        ** GOTO lbl35
                    }
                    case 1: {
                        $i$a$-let-TLSClientHandshake$handleServerDone$chain$1 = false;
                        encryptionInfo = (EncryptionInfo)$continuation.L$4;
                        certificateInfo = (CertificateInfo)$continuation.L$3;
                        serverCertificate = (Certificate)$continuation.L$2;
                        exchangeType = (SecretExchangeType)$continuation.L$1;
                        this = (TLSClientHandshake)$continuation.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl35:
                        // 2 sources

                        v2 = (CertificateAndKey)v1;
                        break block18;
                    }
                }
                v2 = null;
            }
            chain = v2;
            preSecret = this.generatePreSecret(encryptionInfo);
            $continuation.L$0 = this;
            $continuation.L$1 = certificateInfo;
            $continuation.L$2 = chain;
            $continuation.L$3 = preSecret;
            $continuation.L$4 = null;
            $continuation.label = 2;
            v3 = this.sendClientKeyExchange(var1_1, var2_2, preSecret, encryptionInfo, $continuation);
            if (v3 == var13_8) {
                return var13_8;
            }
            ** GOTO lbl59
            {
                case 2: {
                    preSecret = (byte[])$continuation.L$3;
                    chain = (CertificateAndKey)$continuation.L$2;
                    certificateInfo = (CertificateInfo)$continuation.L$1;
                    this = (TLSClientHandshake)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v3 = $result;
lbl59:
                    // 2 sources

                    if ((v4 = this.serverHello) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                        v4 = null;
                    }
                    v5 = new SecretKeySpec(preSecret, v4.getCipherSuite().getHash().getMacName());
                    v6 = this.serverHello;
                    if (v6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                        v6 = null;
                    }
                    this.masterSecret = KeysKt.masterSecret(v5, this.clientSeed, v6.getServerSeed());
                    ArraysKt.fill$default(preSecret, (byte)0, 0, 0, 6, null);
                    v7 = chain;
                    if (v7 == null) break;
                    it = v7;
                    $i$a$-let-TLSClientHandshake$handleServerDone$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.label = 3;
                    v8 = this.sendClientCertificateVerify(certificateInfo, it, $continuation);
                    if (v8 == var13_8) {
                        return var13_8;
                    }
                    break block19;
                }
                case 3: {
                    $i$a$-let-TLSClientHandshake$handleServerDone$2 = false;
                    this = (TLSClientHandshake)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v8 = $result;
                    break block19;
                }
            }
        }
        $continuation.L$0 = this;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.label = 4;
        v9 = this.sendChangeCipherSpec($continuation);
        if (v9 == var13_8) {
            return var13_8;
        }
        ** GOTO lbl104
        {
            case 4: {
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v9 = $result;
lbl104:
                // 2 sources

                if ((v10 = this.masterSecret) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("masterSecret");
                    v10 = null;
                }
                $continuation.L$0 = null;
                $continuation.label = 5;
                v11 = this.sendClientFinished(v10, $continuation);
                if (v11 == var13_8) {
                    return var13_8;
                }
                ** GOTO lbl116
            }
            case 5: {
                ResultKt.throwOnFailure($result);
                v11 = $result;
lbl116:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final byte[] generatePreSecret(EncryptionInfo encryptionInfo) {
        byte[] byArray;
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException("serverHello");
            tLSServerHello = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[tLSServerHello.getCipherSuite().getExchangeType().ordinal()]) {
            case 2: {
                byte[] byArray2;
                byte[] it = byArray2 = new byte[48];
                boolean bl = false;
                this.config.getRandom().nextBytes(it);
                it[0] = 3;
                it[1] = 3;
                byArray = byArray2;
                break;
            }
            case 1: {
                KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                Intrinsics.checkNotNull(keyAgreement);
                KeyAgreement $this$generatePreSecret_u24lambda_u2413 = keyAgreement;
                boolean bl = false;
                if (encryptionInfo == null) {
                    throw new TLSException("ECDHE_ECDSA: Encryption info should be provided", null, 2, null);
                }
                $this$generatePreSecret_u24lambda_u2413.init(encryptionInfo.getClientPrivate());
                $this$generatePreSecret_u24lambda_u2413.doPhase(encryptionInfo.getServerPublic(), true);
                byte[] byArray3 = $this$generatePreSecret_u24lambda_u2413.generateSecret();
                byArray = byArray3;
                Intrinsics.checkNotNull(byArray3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    private final Object sendClientKeyExchange(SecretExchangeType exchangeType, Certificate serverCertificate, byte[] preSecret, EncryptionInfo encryptionInfo, Continuation<? super Unit> $completion) {
        ByteReadPacket byteReadPacket;
        switch (WhenMappings.$EnumSwitchMapping$0[exchangeType.ordinal()]) {
            case 2: {
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    BytePacketBuilder $this$sendClientKeyExchange_u24lambda_u2414 = builder$iv;
                    boolean bl = false;
                    PublicKey publicKey = serverCertificate.getPublicKey();
                    Intrinsics.checkNotNullExpressionValue(publicKey, "serverCertificate.publicKey");
                    RenderKt.writeEncryptedPreMasterSecret($this$sendClientKeyExchange_u24lambda_u2414, preSecret, publicKey, this.config.getRandom());
                    byteReadPacket = builder$iv.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
            }
            case 1: {
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    BytePacketBuilder $this$sendClientKeyExchange_u24lambda_u2415 = builder$iv;
                    boolean bl = false;
                    if (encryptionInfo == null) {
                        throw new TLSException("ECDHE: Encryption info should be provided", null, 2, null);
                    }
                    RenderKt.writePublicKeyUncompressed($this$sendClientKeyExchange_u24lambda_u2415, encryptionInfo.getClientPublic());
                    byteReadPacket = builder$iv.build();
                    break;
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ByteReadPacket packet2 = byteReadPacket;
        Object object = this.sendHandshakeRecord(TLSHandshakeType.ClientKeyExchange, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(packet2){
            final /* synthetic */ ByteReadPacket $packet;
            {
                this.$packet = $packet;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkNotNullParameter($this$sendHandshakeRecord, "$this$sendHandshakeRecord");
                $this$sendHandshakeRecord.writePacket(this.$packet);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendClientCertificate(CertificateInfo var1_1, Continuation<? super CertificateAndKey> var2_2) {
        if (!(var2_2 instanceof sendClientCertificate.1)) ** GOTO lbl-1000
        var24_3 = var2_2;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$sendClientCertificate(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var4_6 = this.config.getCertificates();
                for (T var6_8 : var4_6) {
                    candidate = (CertificateAndKey)var6_8;
                    $i$a$-find-TLSClientHandshake$sendClientCertificate$chainAndKey$1 = false;
                    leaf = ArraysKt.first(candidate.getCertificateChain());
                    var10_12 = leaf.getPublicKey().getAlgorithm();
                    v0 = Intrinsics.areEqual(var10_12, "RSA") != false ? ArraysKt.contains(info.getTypes(), CertificateType.INSTANCE.getRSA()) : (validAlgorithm = Intrinsics.areEqual(var10_12, "DSS") != false ? ArraysKt.contains(info.getTypes(), CertificateType.INSTANCE.getDSS()) : false);
                    if (validAlgorithm) ** GOTO lbl22
                    v1 = false;
                    ** GOTO lbl66
lbl22:
                    // 1 sources

                    $this$none$iv = info.getHashAndSign();
                    $i$f$none = false;
                    var15_19 = $this$none$iv.length;
                    for (var14_17 = 0; var14_17 < var15_19; ++var14_17) {
                        it = element$iv = $this$none$iv[var14_17];
                        $i$a$-none-TLSClientHandshake$sendClientCertificate$chainAndKey$1$hasHashAndSignInCommon$1 = false;
                        if (!StringsKt.equals(it.getName(), leaf.getSigAlgName(), true)) continue;
                        v2 = false;
                        ** GOTO lbl32
                    }
                    v2 = hasHashAndSignInCommon = true;
lbl32:
                    // 2 sources

                    if (!hasHashAndSignInCommon) ** GOTO lbl35
                    v1 = false;
                    ** GOTO lbl66
lbl35:
                    // 1 sources

                    if (info.getAuthorities().isEmpty()) ** GOTO lbl-1000
                    $this$map$iv = candidate.getCertificateChain();
                    $i$f$map = false;
                    var14_18 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    $i$f$mapTo = false;
                    var18_26 = ((void)$this$mapTo$iv$iv).length;
                    for (it = 0; it < var18_26; ++it) {
                        var20_28 = item$iv$iv = $this$mapTo$iv$iv[it];
                        var21_29 = destination$iv$iv;
                        $i$a$-map-TLSClientHandshake$sendClientCertificate$chainAndKey$1$1 = false;
                        var21_29.add(new X500Principal(it.getIssuerX500Principal().getName()));
                    }
                    $this$any$iv = (List)destination$iv$iv;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl54
                    v3 = false;
                    ** GOTO lbl61
lbl54:
                    // 2 sources

                    for (E element$iv : $this$any$iv) {
                        it = (X500Principal)element$iv;
                        $i$a$-any-TLSClientHandshake$sendClientCertificate$chainAndKey$1$2 = false;
                        if (!info.getAuthorities().contains(it)) continue;
                        v3 = true;
                        ** GOTO lbl61
                    }
                    v3 = false;
lbl61:
                    // 3 sources

                    if (v3) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
lbl66:
                    // 4 sources

                    if (!v1) continue;
                    v4 = var6_8;
                    ** GOTO lbl70
                }
                v4 = null;
lbl70:
                // 2 sources

                chainAndKey = v4;
                $continuation.L$0 = chainAndKey;
                $continuation.label = 1;
                v5 = this.sendHandshakeRecord(TLSHandshakeType.Certificate, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(chainAndKey){
                    final /* synthetic */ CertificateAndKey $chainAndKey;
                    {
                        this.$chainAndKey = $chainAndKey;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                        Intrinsics.checkNotNullParameter($this$sendHandshakeRecord, "$this$sendHandshakeRecord");
                        X509Certificate[] x509CertificateArray = this.$chainAndKey;
                        if (this.$chainAndKey == null || (x509CertificateArray = x509CertificateArray.getCertificateChain()) == null) {
                            boolean $i$f$emptyArray = false;
                            x509CertificateArray = (X509Certificate[])((Object[])new X509Certificate[0]);
                        }
                        RenderKt.writeTLSCertificates($this$sendHandshakeRecord, x509CertificateArray);
                    }
                }, $continuation);
                if (v5 == var25_5) {
                    return var25_5;
                }
                ** GOTO lbl81
            }
            case 1: {
                chainAndKey = (CertificateAndKey)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v5 = $result;
lbl81:
                // 2 sources

                return chainAndKey;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object sendClientCertificateVerify(CertificateInfo info2, CertificateAndKey certificateAndKey, Continuation<? super Unit> $completion) {
        HashAndSign hashAndSign;
        block4: {
            X509Certificate leaf = ArraysKt.first(certificateAndKey.getCertificateChain());
            HashAndSign[] $this$firstOrNull$iv = info2.getHashAndSign();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                HashAndSign element$iv;
                HashAndSign it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), leaf.getSigAlgName(), true)) continue;
                hashAndSign = element$iv;
                break block4;
            }
            hashAndSign = null;
        }
        if (hashAndSign == null) {
            return Unit.INSTANCE;
        }
        HashAndSign hashAndSign2 = hashAndSign;
        if (hashAndSign2.getSign() == SignatureAlgorithm.DSA) {
            return Unit.INSTANCE;
        }
        Signature signature2 = Signature.getInstance(ArraysKt.first(certificateAndKey.getCertificateChain()).getSigAlgName());
        Intrinsics.checkNotNull(signature2);
        Signature sign = signature2;
        sign.initSign(certificateAndKey.getKey());
        Object object = this.sendHandshakeRecord(TLSHandshakeType.CertificateVerify, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(hashAndSign2, this, sign){
            final /* synthetic */ HashAndSign $hashAndSign;
            final /* synthetic */ TLSClientHandshake this$0;
            final /* synthetic */ Signature $sign;
            {
                this.$hashAndSign = $hashAndSign;
                this.this$0 = $receiver;
                this.$sign = $sign;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                void $this$preview$iv;
                Intrinsics.checkNotNullParameter($this$sendHandshakeRecord, "$this$sendHandshakeRecord");
                $this$sendHandshakeRecord.writeByte(this.$hashAndSign.getHash().getCode());
                $this$sendHandshakeRecord.writeByte(this.$hashAndSign.getSign().getCode());
                BytePacketBuilder bytePacketBuilder = TLSClientHandshake.access$getDigest$p(this.this$0);
                Signature signature2 = this.$sign;
                boolean $i$f$preview = false;
                ByteReadPacket packet$iv = PreviewKt.preview((BytePacketBuilder)$this$preview$iv);
                try {
                    ByteReadPacket it = packet$iv;
                    boolean bl = false;
                    signature2.update(io.ktor.utils.io.core.StringsKt.readBytes$default(it, 0, 1, null));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    packet$iv.release();
                }
                byte[] byArray = this.$sign.sign();
                Intrinsics.checkNotNull(byArray);
                byte[] signBytes = byArray;
                OutputPrimitivesKt.writeShort($this$sendHandshakeRecord, (short)signBytes.length);
                OutputKt.writeFully$default((Output)$this$sendHandshakeRecord, signBytes, 0, 0, 6, null);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendChangeCipherSpec(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof sendChangeCipherSpec.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$sendChangeCipherSpec(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $i$f$buildPacket = false;
                builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    $this$sendChangeCipherSpec_u24lambda_u2421 = builder$iv;
                    $i$a$-buildPacket-TLSClientHandshake$sendChangeCipherSpec$packet$1 = false;
                    $this$sendChangeCipherSpec_u24lambda_u2421.writeByte((byte)1);
                    v0 = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                packet = v0;
                $continuation.L$0 = packet;
                $continuation.label = 1;
                v1 = this.output.send(new TLSRecord(TLSRecordType.ChangeCipherSpec, null, packet, 2, null), $continuation);
                ** if (v1 != var9_4) goto lbl33
lbl32:
                // 1 sources

                return var9_4;
lbl33:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                packet = (ByteReadPacket)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v1 = $result;
                }
                catch (Throwable cause) {
                    packet.release();
                    throw cause;
                }
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object sendClientFinished(SecretKeySpec masterKey, Continuation<? super Unit> $completion) {
        TLSServerHello tLSServerHello = this.serverHello;
        if (tLSServerHello == null) {
            Intrinsics.throwUninitializedPropertyAccessException("serverHello");
            tLSServerHello = null;
        }
        byte[] checksum = Digest.doHash-impl(this.digest, tLSServerHello.getCipherSuite().getHash().getOpenSSLName());
        ByteReadPacket finished = RenderKt.finished(checksum, masterKey);
        Object object = this.sendHandshakeRecord(TLSHandshakeType.Finished, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(finished){
            final /* synthetic */ ByteReadPacket $finished;
            {
                this.$finished = $finished;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$sendHandshakeRecord) {
                Intrinsics.checkNotNullParameter($this$sendHandshakeRecord, "$this$sendHandshakeRecord");
                $this$sendHandshakeRecord.writePacket(this.$finished);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object receiveServerFinished(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof receiveServerFinished.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$receiveServerFinished(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.handshakes.receive($continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (TLSClientHandshake)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((finished = (TLSHandshake)v0).getType() != TLSHandshakeType.Finished) {
                    throw new TLSException("Finished handshake expected, received: " + finished, null, 2, null);
                }
                receivedChecksum = io.ktor.utils.io.core.StringsKt.readBytes$default(finished.getPacket(), 0, 1, null);
                v1 = this.serverHello;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serverHello");
                    v1 = null;
                }
                v2 = Digest.doHash-impl(this.digest, v1.getCipherSuite().getHash().getOpenSSLName());
                v3 = this.masterSecret;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("masterSecret");
                    v3 = null;
                }
                if (!Arrays.equals(receivedChecksum, expectedChecksum = RenderKt.serverFinished(v2, v3, receivedChecksum.length))) {
                    throw new TLSException(StringsKt.trimMargin$default("Handshake: ServerFinished verification failed:\n                |Expected: " + ArraysKt.joinToString$default(expectedChecksum, null, null, null, 0, null, null, 63, null) + "\n                |Actual: " + ArraysKt.joinToString$default(receivedChecksum, null, null, null, 0, null, null, 63, null) + "\n            ", null, 1, null), null, 2, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object sendHandshakeRecord(TLSHandshakeType var1_1, Function1<? super BytePacketBuilder, Unit> var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof sendHandshakeRecord.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TLSClientHandshake this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TLSClientHandshake.access$sendHandshakeRecord(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $i$f$buildPacket = false;
                builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    block.invoke(builder$iv);
                    v0 = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                handshakeBody = v0;
                $i$f$buildPacket = false;
                builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    $this$sendHandshakeRecord_u24lambda_u2422 = builder$iv;
                    $i$a$-buildPacket-TLSClientHandshake$sendHandshakeRecord$recordBody$1 = false;
                    RenderKt.writeTLSHandshakeType($this$sendHandshakeRecord_u24lambda_u2422, (TLSHandshakeType)handshakeType, (int)handshakeBody.getRemaining());
                    $this$sendHandshakeRecord_u24lambda_u2422.writePacket(handshakeBody);
                    v1 = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                recordBody = v1;
                Digest.update-impl(this.digest, recordBody);
                element = new TLSRecord(TLSRecordType.Handshake, null, recordBody, 2, null);
                $continuation.L$0 = element;
                $continuation.label = 1;
                v2 = this.output.send(element, $continuation);
                ** if (v2 != var13_6) goto lbl50
lbl49:
                // 1 sources

                return var13_6;
lbl50:
                // 1 sources

                ** GOTO lbl61
            }
            case 1: {
                element = (TLSRecord)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v2 = $result;
                }
                catch (Throwable cause) {
                    element.getPacket().release();
                    throw cause;
                }
lbl61:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$sendClientHello(TLSClientHandshake $this, Continuation $completion) {
        return $this.sendClientHello($completion);
    }

    public static final /* synthetic */ TLSConfig access$getConfig$p(TLSClientHandshake $this) {
        return $this.config;
    }

    public static final /* synthetic */ byte[] access$getClientSeed$p(TLSClientHandshake $this) {
        return $this.clientSeed;
    }

    public static final /* synthetic */ Object access$receiveServerHello(TLSClientHandshake $this, Continuation $completion) {
        return $this.receiveServerHello($completion);
    }

    public static final /* synthetic */ Object access$handleCertificatesAndKeys(TLSClientHandshake $this, Continuation $completion) {
        return $this.handleCertificatesAndKeys($completion);
    }

    public static final /* synthetic */ Object access$handleServerDone(TLSClientHandshake $this, SecretExchangeType exchangeType, Certificate serverCertificate, CertificateInfo certificateInfo, EncryptionInfo encryptionInfo, Continuation $completion) {
        return $this.handleServerDone(exchangeType, serverCertificate, certificateInfo, encryptionInfo, $completion);
    }

    public static final /* synthetic */ Object access$sendClientKeyExchange(TLSClientHandshake $this, SecretExchangeType exchangeType, Certificate serverCertificate, byte[] preSecret, EncryptionInfo encryptionInfo, Continuation $completion) {
        return $this.sendClientKeyExchange(exchangeType, serverCertificate, preSecret, encryptionInfo, $completion);
    }

    public static final /* synthetic */ Object access$sendClientCertificate(TLSClientHandshake $this, CertificateInfo info2, Continuation $completion) {
        return $this.sendClientCertificate(info2, $completion);
    }

    public static final /* synthetic */ Object access$sendClientCertificateVerify(TLSClientHandshake $this, CertificateInfo info2, CertificateAndKey certificateAndKey, Continuation $completion) {
        return $this.sendClientCertificateVerify(info2, certificateAndKey, $completion);
    }

    public static final /* synthetic */ BytePacketBuilder access$getDigest$p(TLSClientHandshake $this) {
        return $this.digest;
    }

    public static final /* synthetic */ Object access$sendChangeCipherSpec(TLSClientHandshake $this, Continuation $completion) {
        return $this.sendChangeCipherSpec($completion);
    }

    public static final /* synthetic */ Object access$sendClientFinished(TLSClientHandshake $this, SecretKeySpec masterKey, Continuation $completion) {
        return $this.sendClientFinished(masterKey, $completion);
    }

    public static final /* synthetic */ Object access$receiveServerFinished(TLSClientHandshake $this, Continuation $completion) {
        return $this.receiveServerFinished($completion);
    }

    public static final /* synthetic */ Object access$sendHandshakeRecord(TLSClientHandshake $this, TLSHandshakeType handshakeType, Function1 block2, Continuation $completion) {
        return $this.sendHandshakeRecord(handshakeType, block2, $completion);
    }

    public static final /* synthetic */ TLSServerHello access$getServerHello$p(TLSClientHandshake $this) {
        return $this.serverHello;
    }

    public static final /* synthetic */ SecretKeySpec access$getMasterSecret$p(TLSClientHandshake $this) {
        return $this.masterSecret;
    }

    public static final /* synthetic */ byte[] access$getKeyMaterial(TLSClientHandshake $this) {
        return $this.getKeyMaterial();
    }

    public static final /* synthetic */ TLSCipher access$getCipher(TLSClientHandshake $this) {
        return $this.getCipher();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SecretExchangeType.values().length];
            try {
                nArray[SecretExchangeType.ECDHE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SecretExchangeType.RSA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TLSHandshakeType.values().length];
            try {
                nArray[TLSHandshakeType.Certificate.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TLSHandshakeType.CertificateRequest.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TLSHandshakeType.ServerKeyExchange.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TLSHandshakeType.ServerDone.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

