/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.io.PrintStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryUtil;

public abstract class GLFWErrorCallback
extends Callback
implements GLFWErrorCallbackI {
    public static GLFWErrorCallback create(long functionPointer) {
        GLFWErrorCallbackI instance = (GLFWErrorCallbackI)Callback.get(functionPointer);
        return instance instanceof GLFWErrorCallback ? (GLFWErrorCallback)instance : new Container(functionPointer, instance);
    }

    @Nullable
    public static GLFWErrorCallback createSafe(long functionPointer) {
        return functionPointer == 0L ? null : GLFWErrorCallback.create(functionPointer);
    }

    public static GLFWErrorCallback create(GLFWErrorCallbackI instance) {
        return instance instanceof GLFWErrorCallback ? (GLFWErrorCallback)instance : new Container(instance.address(), instance);
    }

    protected GLFWErrorCallback() {
        super(CIF);
    }

    GLFWErrorCallback(long functionPointer) {
        super(functionPointer);
    }

    public static String getDescription(long description2) {
        return MemoryUtil.memUTF8(description2);
    }

    public static GLFWErrorCallback createPrint() {
        return GLFWErrorCallback.createPrint(APIUtil.DEBUG_STREAM);
    }

    public static GLFWErrorCallback createPrint(final PrintStream stream) {
        return new GLFWErrorCallback(){
            private Map<Integer, String> ERROR_CODES = APIUtil.apiClassTokens((field2, value) -> 65536 < value && value < 131072, null, GLFW.class);

            @Override
            public void invoke(int error2, long description2) {
                String msg = 1.getDescription(description2);
                StringBuilder sb = new StringBuilder(512);
                sb.append("[LWJGL] ").append(this.ERROR_CODES.get(error2)).append(" error\n").append("\tDescription : ").append(msg).append("\n").append("\tStacktrace  :\n");
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i = 4; i < stack.length; ++i) {
                    sb.append("\t\t");
                    sb.append(stack[i]);
                    sb.append("\n");
                }
                stream.print(sb);
            }
        };
    }

    public static GLFWErrorCallback createThrow() {
        return new GLFWErrorCallback(){

            @Override
            public void invoke(int error2, long description2) {
                throw new IllegalStateException(String.format("GLFW error [0x%X]: %s", error2, 2.getDescription(description2)));
            }
        };
    }

    public GLFWErrorCallback set() {
        GLFW.glfwSetErrorCallback(this);
        return this;
    }

    private static final class Container
    extends GLFWErrorCallback {
        private final GLFWErrorCallbackI delegate;

        Container(long functionPointer, GLFWErrorCallbackI delegate2) {
            super(functionPointer);
            this.delegate = delegate2;
        }

        @Override
        public void invoke(int error2, long description2) {
            this.delegate.invoke(error2, description2);
        }
    }
}

