/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.LongBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SOFTDeviceClock {
    public static final int ALC_DEVICE_CLOCK_SOFT = 5632;
    public static final int ALC_DEVICE_LATENCY_SOFT = 5633;
    public static final int ALC_DEVICE_CLOCK_LATENCY_SOFT = 5634;
    public static final int AL_SAMPLE_OFFSET_CLOCK_SOFT = 4610;
    public static final int AL_SEC_OFFSET_CLOCK_SOFT = 4611;

    protected SOFTDeviceClock() {
        throw new UnsupportedOperationException();
    }

    public static void nalcGetInteger64vSOFT(long device, int pname, int size2, long values2) {
        long __functionAddress = ALC.getICD().alcGetInteger64vSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePPV(device, pname, size2, values2, __functionAddress);
    }

    @NativeType(value="ALCvoid")
    public static void alcGetInteger64vSOFT(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCenum") int pname, @NativeType(value="ALCint64SOFT *") LongBuffer values2) {
        SOFTDeviceClock.nalcGetInteger64vSOFT(device, pname, values2.remaining(), MemoryUtil.memAddress(values2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ALCvoid")
    public static long alcGetInteger64vSOFT(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer values2 = stack.callocLong(1);
            SOFTDeviceClock.nalcGetInteger64vSOFT(device, pname, 1, MemoryUtil.memAddress(values2));
            long l = values2.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="ALCvoid")
    public static void alcGetInteger64vSOFT(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCenum") int pname, @NativeType(value="ALCint64SOFT *") long[] values2) {
        long __functionAddress = ALC.getICD().alcGetInteger64vSOFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePPV(device, pname, values2.length, values2, __functionAddress);
    }
}

