/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFTreasure;
import twilightforest.entity.boss.EntityTFThrownAxe;
import twilightforest.entity.boss.EntityTFThrownPick;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFKnightPhantom
extends EntityFlying
implements IMob {
    private static final float CIRCLE_SMALL_RADIUS = 2.5f;
    private static final float CIRCLE_LARGE_RADIUS = 8.5f;
    private static final int FLAG_CHARGING = 17;
    int number;
    int ticksProgress;
    Formation currentFormation;
    private ChunkCoordinates homePosition = new ChunkCoordinates(0, 0, 0);
    private float maximumHomeDistance = -1.0f;
    private int chargePosX;
    private int chargePosY;
    private int chargePosZ;

    public EntityTFKnightPhantom(World par1World) {
        super(par1World);
        this.func_70105_a(1.5f, 3.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.currentFormation = Formation.HOVER;
        this.field_70728_aV = 93;
        this.func_70062_b(0, new ItemStack(TFItems.knightlySword));
        this.func_70062_b(3, new ItemStack(TFItems.phantomPlate));
        this.func_70062_b(4, new ItemStack(TFItems.phantomHelm));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (par1DamageSource == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                Item particleID = this.field_70146_Z.nextBoolean() ? TFItems.phantomHelm : TFItems.knightlySword;
                this.field_70170_p.func_72869_a("iconcrack_" + Item.func_150891_b((Item)particleID), this.field_70165_t + ((double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat()) - 0.5) * (double)this.field_70130_N, this.field_70163_u + (double)this.field_70146_Z.nextFloat() * ((double)this.field_70131_O - 0.75) + 0.5, this.field_70161_v + ((double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat()) - 0.5) * (double)this.field_70130_N, 0.0, -0.1, 0.0);
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t + ((double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat()) - 0.5) * (double)this.field_70130_N, this.field_70163_u + (double)this.field_70146_Z.nextFloat() * ((double)this.field_70131_O - 0.75) + 0.5, this.field_70161_v + ((double)(this.field_70146_Z.nextFloat() * this.field_70146_Z.nextFloat()) - 0.5) * (double)this.field_70130_N, 0.0, 0.1, 0.0);
            }
        }
    }

    protected void func_70609_aI() {
        List<EntityTFKnightPhantom> nearbyKnights;
        super.func_70609_aI();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a("explode", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K && (nearbyKnights = this.getNearbyKnights()).size() <= 1) {
            this.makeATreasure();
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76364_f() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.func_76364_f()).func_71029_a((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.func_76364_f()).func_71029_a((StatBase)TFAchievementPage.twilightProgressKnights);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest) {
            int dx = this.getHomePosition().field_71574_a;
            int dy = this.getHomePosition().field_71572_b;
            int dz = this.getHomePosition().field_71573_c;
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.field_70170_p.field_73011_w).getChunkProvider();
            TFFeature nearbyFeature = ((TFWorldChunkManager)this.field_70170_p.field_73011_w.field_76578_c).getFeatureAt(dx, dz, this.field_70170_p);
            if (nearbyFeature == TFFeature.tfStronghold) {
                chunkProvider.setStructureConquered(dx, dy, dz, true);
            }
        }
    }

    private void makeATreasure() {
        TFTreasure.stronghold_boss.generate(this.field_70170_p, null, this.getHomePosition().field_71574_a, this.getHomePosition().field_71572_b - 1, this.getHomePosition().field_71573_c);
    }

    protected void func_70626_be() {
        float seekRange;
        EntityPlayer target;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        this.field_70145_X = this.ticksProgress % 20 != 0;
        ++this.ticksProgress;
        if (this.ticksProgress >= this.getMaxTicksForFormation()) {
            this.switchToNextFormation();
        }
        if ((target = this.field_70170_p.func_72856_b((Entity)this, (double)(seekRange = this.isChargingAtPlayer() ? 24.0f : 9.0f))) != null && this.currentFormation == Formation.ATTACK_PLAYER_START) {
            int targetZ;
            int targetY;
            int targetX = MathHelper.func_76128_c((double)target.field_70142_S);
            if (this.isWithinHomeArea(targetX, targetY = MathHelper.func_76128_c((double)target.field_70137_T), targetZ = MathHelper.func_76128_c((double)target.field_70136_U))) {
                this.chargePosX = targetX;
                this.chargePosY = targetY;
                this.chargePosZ = targetZ;
            } else {
                this.chargePosX = this.getHomePosition().field_71574_a;
                this.chargePosY = this.getHomePosition().field_71572_b;
                this.chargePosZ = this.getHomePosition().field_71573_c;
            }
        }
        Vec3 dest = this.getDestination();
        double moveX = dest.field_72450_a - this.field_70165_t;
        double moveY = dest.field_72448_b - this.field_70163_u;
        double moveZ = dest.field_72449_c - this.field_70161_v;
        double factor = moveX * moveX + moveY * moveY + moveZ * moveZ;
        factor = MathHelper.func_76133_a((double)factor);
        double speed = 0.1;
        this.field_70159_w += moveX / factor * speed;
        this.field_70181_x += moveY / factor * speed;
        this.field_70179_y += moveZ / factor * speed;
        if (target != null) {
            this.func_70625_a((Entity)target, 10.0f, 500.0f);
            if (target.func_70089_S()) {
                float f1 = target.func_70032_d((Entity)this);
                if (this.func_70685_l((Entity)target)) {
                    this.attackEntity((Entity)target, f1);
                }
            }
            if (this.isAxeKnight() && this.currentFormation == Formation.ATTACK_PLAYER_ATTACK && this.ticksProgress % 4 == 0) {
                this.launchAxeAt((Entity)target);
            }
            if (this.isPickKnight() && this.currentFormation == Formation.ATTACK_PLAYER_ATTACK && this.ticksProgress % 4 == 0) {
                this.launchPicks();
            }
        }
    }

    protected void attackEntity(Entity par1Entity, float par2) {
        if (this.field_70724_aR <= 0 && par2 < 2.0f && par1Entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && par1Entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(par1Entity);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        boolean flag;
        float f = this.getAttackDamage();
        int i = 0;
        if (par1Entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
        }
        if (flag = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                par1Entity.func_70015_d(j * 4);
            }
            if (par1Entity instanceof EntityLivingBase) {
                // empty if block
            }
        }
        return flag;
    }

    private float getAttackDamage() {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.isChargingAtPlayer()) {
            damage += 7.0f;
        }
        return damage;
    }

    protected void launchAxeAt(Entity targetedEntity) {
        float bodyFacingAngle = this.field_70761_aq * 3.141593f / 180.0f;
        double sx = this.field_70165_t + (double)(MathHelper.func_76134_b((float)bodyFacingAngle) * 1.0f);
        double sy = this.field_70163_u + (double)this.field_70131_O * 0.82;
        double sz = this.field_70161_v + (double)(MathHelper.func_76126_a((float)bodyFacingAngle) * 1.0f);
        double tx = targetedEntity.field_70165_t - sx;
        double ty = targetedEntity.field_70121_D.field_72338_b + (double)(targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double tz = targetedEntity.field_70161_v - sz;
        this.field_70170_p.func_72956_a((Entity)this, "random.bow", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.4f);
        EntityTFThrownAxe projectile = new EntityTFThrownAxe(this.field_70170_p, (EntityLivingBase)this);
        float speed = 0.75f;
        projectile.func_70186_c(tx, ty, tz, speed, 1.0f);
        projectile.func_70012_b(sx, sy, sz, this.field_70177_z, this.field_70125_A);
        this.field_70170_p.func_72838_d((Entity)projectile);
    }

    protected void launchPicks() {
        this.field_70170_p.func_72956_a((Entity)this, "random.bow", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.4f);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)i * 3.1415915f / 4.0f;
            double sx = this.field_70165_t + (double)(MathHelper.func_76134_b((float)throwAngle) * 1.0f);
            double sy = this.field_70163_u + (double)this.field_70131_O * 0.82;
            double sz = this.field_70161_v + (double)(MathHelper.func_76126_a((float)throwAngle) * 1.0f);
            double vx = MathHelper.func_76134_b((float)throwAngle);
            double vy = 0.0;
            double vz = MathHelper.func_76126_a((float)throwAngle);
            EntityTFThrownPick projectile = new EntityTFThrownPick(this.field_70170_p, (EntityLivingBase)this);
            projectile.func_70012_b(sx, sy, sz, (float)i * 45.0f, this.field_70125_A);
            float speed = 0.5f;
            projectile.func_70186_c(vx, vy, vz, speed, 1.0f);
            this.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70653_a(Entity par1Entity, float damage, double par3, double par5) {
        this.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(par3 * par3 + par5 * par5));
        float distance = 0.2f;
        this.field_70159_w /= 2.0;
        this.field_70181_x /= 2.0;
        this.field_70179_y /= 2.0;
        this.field_70159_w -= par3 / (double)f * (double)distance;
        this.field_70181_x += (double)distance;
        this.field_70179_y -= par5 / (double)f * (double)distance;
        if (this.field_70181_x > (double)0.4f) {
            this.field_70181_x = 0.4f;
        }
    }

    public void switchToNextFormation() {
        List<EntityTFKnightPhantom> nearbyKnights = this.getNearbyKnights();
        if (this.currentFormation == Formation.ATTACK_PLAYER_START) {
            this.switchToFormation(Formation.ATTACK_PLAYER_ATTACK);
        } else if (this.currentFormation == Formation.ATTACK_PLAYER_ATTACK) {
            if (nearbyKnights.size() > 1) {
                this.switchToFormation(Formation.WAITING_FOR_LEADER);
            } else {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.func_70062_b(0, new ItemStack(TFItems.knightlySword));
                        break;
                    }
                    case 1: {
                        this.func_70062_b(0, new ItemStack(TFItems.knightlyAxe));
                        break;
                    }
                    case 2: {
                        this.func_70062_b(0, new ItemStack(TFItems.knightlyPick));
                    }
                }
                this.switchToFormation(Formation.ATTACK_PLAYER_START);
            }
        } else if (this.currentFormation == Formation.WAITING_FOR_LEADER) {
            if (nearbyKnights.size() > 1) {
                this.switchToFormation(nearbyKnights.get((int)1).currentFormation);
                this.ticksProgress = nearbyKnights.get((int)1).ticksProgress;
            } else {
                this.switchToFormation(Formation.ATTACK_PLAYER_START);
            }
        } else if (this.isThisTheLeader(nearbyKnights)) {
            this.pickRandomFormation();
            this.broadcastMyFormation(nearbyKnights);
            if (this.isNobodyCharging(nearbyKnights)) {
                this.makeARandomKnightCharge(nearbyKnights);
            }
        }
    }

    private List<EntityTFKnightPhantom> getNearbyKnights() {
        List nearbyKnights = this.field_70170_p.func_72872_a(EntityTFKnightPhantom.class, AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)).func_72314_b(32.0, 8.0, 32.0));
        return nearbyKnights;
    }

    protected void pickRandomFormation() {
        switch (this.field_70146_Z.nextInt(8)) {
            case 0: {
                this.currentFormation = Formation.SMALL_CLOCKWISE;
                break;
            }
            case 1: {
                this.currentFormation = Formation.SMALL_ANTICLOCKWISE;
                break;
            }
            case 2: {
                this.currentFormation = Formation.SMALL_ANTICLOCKWISE;
                break;
            }
            case 3: {
                this.currentFormation = Formation.CHARGE_PLUSX;
                break;
            }
            case 4: {
                this.currentFormation = Formation.CHARGE_MINUSX;
                break;
            }
            case 5: {
                this.currentFormation = Formation.CHARGE_PLUSZ;
                break;
            }
            case 6: {
                this.currentFormation = Formation.CHARGE_MINUSZ;
                break;
            }
            case 7: {
                this.currentFormation = Formation.SMALL_CLOCKWISE;
            }
        }
        this.switchToFormation(this.currentFormation);
    }

    private boolean isThisTheLeader(List<EntityTFKnightPhantom> nearbyKnights) {
        boolean iAmTheLowest = true;
        for (EntityTFKnightPhantom knight : nearbyKnights) {
            if (knight.getNumber() >= this.getNumber()) continue;
            iAmTheLowest = false;
            break;
        }
        return iAmTheLowest;
    }

    private boolean isNobodyCharging(List<EntityTFKnightPhantom> nearbyKnights) {
        boolean noCharge = true;
        for (EntityTFKnightPhantom knight : nearbyKnights) {
            if (!knight.isChargingAtPlayer()) continue;
            noCharge = false;
            break;
        }
        return noCharge;
    }

    private void makeARandomKnightCharge(List<EntityTFKnightPhantom> nearbyKnights) {
        int randomNum = this.field_70146_Z.nextInt(nearbyKnights.size());
        nearbyKnights.get(randomNum).switchToFormation(Formation.ATTACK_PLAYER_START);
    }

    private void broadcastMyFormation(List<EntityTFKnightPhantom> nearbyKnights) {
        for (EntityTFKnightPhantom knight : nearbyKnights) {
            if (knight.isChargingAtPlayer()) continue;
            knight.switchToFormation(this.currentFormation);
        }
    }

    public boolean isChargingAtPlayer() {
        return this.field_70180_af.func_75683_a(17) != 0;
    }

    public void setChargingAtPlayer(boolean flag) {
        if (flag) {
            this.field_70180_af.func_75692_b(17, (Object)127);
        } else {
            this.field_70180_af.func_75692_b(17, (Object)0);
        }
    }

    protected String func_70639_aQ() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected String func_70621_aR() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected String func_70673_aS() {
        return "TwilightForest:mob.wraith.wraith";
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    public int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        switch (this.currentFormation) {
            default: {
                return 90;
            }
            case LARGE_CLOCKWISE: {
                return 180;
            }
            case SMALL_CLOCKWISE: {
                return 90;
            }
            case LARGE_ANTICLOCKWISE: {
                return 180;
            }
            case SMALL_ANTICLOCKWISE: {
                return 90;
            }
            case CHARGE_PLUSX: {
                return 180;
            }
            case CHARGE_MINUSX: {
                return 180;
            }
            case CHARGE_PLUSZ: {
                return 180;
            }
            case CHARGE_MINUSZ: {
                return 180;
            }
            case ATTACK_PLAYER_START: {
                return 50;
            }
            case ATTACK_PLAYER_ATTACK: {
                return 50;
            }
            case WAITING_FOR_LEADER: 
        }
        return 10;
    }

    private Vec3 getDestination() {
        if (!this.hasHome()) {
            // empty if block
        }
        switch (this.currentFormation) {
            case LARGE_CLOCKWISE: {
                return this.getCirclePosition(8.5f, true);
            }
            case SMALL_CLOCKWISE: {
                return this.getCirclePosition(2.5f, true);
            }
            case LARGE_ANTICLOCKWISE: {
                return this.getCirclePosition(8.5f, false);
            }
            case SMALL_ANTICLOCKWISE: {
                return this.getCirclePosition(2.5f, false);
            }
            case CHARGE_PLUSX: {
                return this.getMoveAcrossPosition(true, true);
            }
            case CHARGE_MINUSX: {
                return this.getMoveAcrossPosition(false, true);
            }
            case CHARGE_PLUSZ: {
                return this.getMoveAcrossPosition(true, false);
            }
            case HOVER: 
            case ATTACK_PLAYER_START: {
                return this.getHoverPosition(8.5f);
            }
            case CHARGE_MINUSZ: {
                return this.getMoveAcrossPosition(false, false);
            }
            case WAITING_FOR_LEADER: {
                return this.getLoiterPosition();
            }
            case ATTACK_PLAYER_ATTACK: {
                return this.getAttackPlayerPosition();
            }
        }
        return this.getLoiterPosition();
    }

    private Vec3 getMoveAcrossPosition(boolean plus, boolean alongX) {
        float offset0 = (float)this.getNumber() * 3.0f - 7.5f;
        float offset1 = this.ticksProgress < 60 ? -7.0f : -7.0f + (float)(this.ticksProgress - 60) / 120.0f * 14.0f;
        if (!plus) {
            offset1 *= -1.0f;
        }
        double dx = (float)this.getHomePosition().field_71574_a + (alongX ? offset0 : offset1);
        double dy = (double)this.getHomePosition().field_71572_b + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double dz = (float)this.getHomePosition().field_71573_c + (alongX ? offset1 : offset0);
        return Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
    }

    protected Vec3 getCirclePosition(float distance, boolean clockwise) {
        float angle = (float)this.ticksProgress * 2.0f;
        if (!clockwise) {
            angle *= -1.0f;
        }
        double dx = (double)this.getHomePosition().field_71574_a + Math.cos((double)(angle += 60.0f * (float)this.getNumber()) * Math.PI / 180.0) * (double)distance;
        double dy = (double)this.getHomePosition().field_71572_b + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double dz = (double)this.getHomePosition().field_71573_c + Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
    }

    private Vec3 getHoverPosition(float distance) {
        double dx = this.field_70142_S;
        double dy = (double)this.getHomePosition().field_71572_b + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double ox = (double)this.getHomePosition().field_71574_a - dx;
        double dz = this.field_70136_U;
        double oz = (double)this.getHomePosition().field_71573_c - dz;
        double dDist = Math.sqrt(ox * ox + oz * oz);
        if (dDist > (double)distance) {
            dx = (double)this.getHomePosition().field_71574_a + ox / dDist * (double)distance;
            dz = (double)this.getHomePosition().field_71573_c + oz / dDist * (double)distance;
        }
        return Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
    }

    private Vec3 getLoiterPosition() {
        double dx = this.getHomePosition().field_71574_a;
        double dy = (double)this.getHomePosition().field_71572_b + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double dz = this.getHomePosition().field_71573_c;
        return Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
    }

    private Vec3 getAttackPlayerPosition() {
        if (this.isSwordKnight()) {
            return Vec3.func_72443_a((double)this.chargePosX, (double)this.chargePosY, (double)this.chargePosZ);
        }
        return this.getHoverPosition(8.5f);
    }

    public boolean isSwordKnight() {
        return this.func_71124_b(0).func_77973_b() == TFItems.knightlySword;
    }

    public boolean isAxeKnight() {
        return this.func_71124_b(0).func_77973_b() == TFItems.knightlyAxe;
    }

    public boolean isPickKnight() {
        return this.func_71124_b(0).func_77973_b() == TFItems.knightlyPick;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        switch (number % 3) {
            case 0: {
                this.func_70062_b(0, new ItemStack(TFItems.knightlySword));
                break;
            }
            case 1: {
                this.func_70062_b(0, new ItemStack(TFItems.knightlyAxe));
                break;
            }
            case 2: {
                this.func_70062_b(0, new ItemStack(TFItems.knightlyPick));
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        ChunkCoordinates home = this.getHomePosition();
        nbttagcompound.func_74782_a("Home", (NBTBase)this.func_70087_a(new double[]{home.field_71574_a, home.field_71572_b, home.field_71573_c}));
        nbttagcompound.func_74757_a("HasHome", this.hasHome());
        nbttagcompound.func_74768_a("MyNumber", this.getNumber());
        nbttagcompound.func_74768_a("Formation", this.getFormationAsNumber());
        nbttagcompound.func_74768_a("TicksProgress", this.getTicksProgress());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_150297_b("Home", 9)) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Home", 6);
            int hx = (int)nbttaglist.func_150309_d(0);
            int hy = (int)nbttaglist.func_150309_d(1);
            int hz = (int)nbttaglist.func_150309_d(2);
            this.setHomeArea(hx, hy, hz, 20);
        }
        if (!nbttagcompound.func_74767_n("HasHome")) {
            this.detachHome();
        }
        this.setNumber(nbttagcompound.func_74762_e("MyNumber"));
        this.switchToFormationByNumber(nbttagcompound.func_74762_e("Formation"));
        this.setTicksProgress(nbttagcompound.func_74762_e("TicksProgress"));
    }

    public boolean isWithinHomeArea(int par1, int par2, int par3) {
        return this.maximumHomeDistance == -1.0f ? true : this.homePosition.func_71569_e(par1, par2, par3) < this.maximumHomeDistance * this.maximumHomeDistance;
    }

    public void setHomeArea(int par1, int par2, int par3, int par4) {
        this.homePosition.func_71571_b(par1, par2, par3);
        this.maximumHomeDistance = par4;
    }

    public ChunkCoordinates getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public static enum Formation {
        HOVER,
        LARGE_CLOCKWISE,
        SMALL_CLOCKWISE,
        LARGE_ANTICLOCKWISE,
        SMALL_ANTICLOCKWISE,
        CHARGE_PLUSX,
        CHARGE_MINUSX,
        CHARGE_PLUSZ,
        CHARGE_MINUSZ,
        WAITING_FOR_LEADER,
        ATTACK_PLAYER_START,
        ATTACK_PLAYER_ATTACK;

    }
}

