/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils.sm.cert;

import com.ruoyi.common.utils.sm.cert.SM2PublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2PrivateKey
extends BCECPrivateKey {
    private transient ASN1BitString sm2PublicKey;
    private boolean withCompression;

    public SM2PrivateKey(BCECPrivateKey privateKey, BCECPublicKey publicKey) {
        super(privateKey.getAlgorithm(), privateKey);
        this.sm2PublicKey = this.getSM2PublicKeyDetails(new SM2PublicKey(publicKey.getAlgorithm(), publicKey));
        this.withCompression = false;
    }

    public byte[] getEncoded() {
        ECParameterSpec ecSpec = this.getParams();
        ProviderConfiguration configuration = BouncyCastleProvider.CONFIGURATION;
        ASN1ObjectIdentifier params = SM2PublicKey.ID_SM2_PUBKEY_PARAM;
        int orderBitLength = ecSpec == null ? ECUtil.getOrderBitLength((ProviderConfiguration)configuration, null, (BigInteger)this.getS()) : ECUtil.getOrderBitLength((ProviderConfiguration)configuration, (BigInteger)ecSpec.getOrder(), (BigInteger)this.getS());
        ECPrivateKey keyStructure = this.sm2PublicKey != null ? new ECPrivateKey(orderBitLength, this.getS(), this.sm2PublicKey, (ASN1Encodable)params) : new ECPrivateKey(orderBitLength, this.getS(), (ASN1Encodable)params);
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), (ASN1Encodable)keyStructure);
            return info.getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    private ASN1BitString getSM2PublicKeyDetails(SM2PublicKey pub) {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])pub.getEncoded()));
            return info.getPublicKeyData();
        }
        catch (IOException e) {
            return null;
        }
    }
}

