/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.typetools;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

class ReifiedParameterizedType
implements ParameterizedType {
    private final ParameterizedType original;
    private final Type[] reifiedTypeArguments;

    ReifiedParameterizedType(ParameterizedType original) {
        this.original = original;
        this.reifiedTypeArguments = new Type[original.getActualTypeArguments().length];
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.reifiedTypeArguments;
    }

    @Override
    public Type getRawType() {
        return this.original.getRawType();
    }

    @Override
    public Type getOwnerType() {
        return this.original.getOwnerType();
    }

    void setReifiedTypeArguments(Type[] reifiedTypeArguments) {
        System.arraycopy(reifiedTypeArguments, 0, this.reifiedTypeArguments, 0, this.reifiedTypeArguments.length);
    }

    public String toString() {
        Type ownerType = this.getOwnerType();
        Type rawType = this.getRawType();
        Type[] actualTypeArguments = this.getActualTypeArguments();
        StringBuilder sb = new StringBuilder();
        if (ownerType != null) {
            if (ownerType instanceof Class) {
                sb.append(((Class)ownerType).getName());
            } else {
                sb.append(ownerType.toString());
            }
            sb.append(".");
            if (ownerType instanceof ParameterizedType) {
                sb.append(rawType.getTypeName().replace(((ParameterizedType)ownerType).getRawType().getTypeName() + "$", ""));
            } else {
                sb.append(rawType.getTypeName());
            }
        } else {
            sb.append(rawType.getTypeName());
        }
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            sb.append("<");
            boolean first = true;
            for (Type t : actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(t == null ? "null" : t.getTypeName());
                first = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReifiedParameterizedType that = (ReifiedParameterizedType)o;
        return this.original.equals(that.original) && Arrays.equals(this.reifiedTypeArguments, that.reifiedTypeArguments);
    }

    public int hashCode() {
        int result = this.original.hashCode();
        result = 31 * result + Arrays.hashCode(this.reifiedTypeArguments);
        return result;
    }
}

