/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import javafx.geometry.Orientation;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.SliderSkin;
import javafx.scene.layout.StackPane;

public class ProgressSliderSkin
extends SliderSkin {
    protected final StackPane thumb;
    protected final StackPane track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
    protected final StackPane progressTrack;

    public ProgressSliderSkin(Slider slider) {
        super(slider);
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.progressTrack = new StackPane();
        this.progressTrack.getStyleClass().add((Object)"progress");
        this.progressTrack.setMouseTransparent(true);
        ((Slider)this.getSkinnable()).getStyleClass().add((Object)"progress-slider");
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.progressTrack);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double progressHeight;
        double progressWidth;
        double progressY;
        super.layoutChildren(x, y, w, h);
        double progressX = this.track.getLayoutX();
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            progressY = this.track.getLayoutY();
            progressWidth = this.thumb.getLayoutX() - this.track.getLayoutX() + this.thumb.getLayoutBounds().getCenterX() - this.snappedLeftInset();
            progressHeight = this.track.getHeight();
        } else {
            progressY = this.thumb.getLayoutY() + this.thumb.getLayoutBounds().getCenterY();
            progressWidth = this.track.getWidth();
            progressHeight = this.track.getLayoutBounds().getMaxY() + this.track.getLayoutY() - this.thumb.getLayoutY() - this.thumb.getLayoutBounds().getCenterY() - this.snappedBottomInset();
        }
        this.progressTrack.resizeRelocate(progressX, progressY, progressWidth, progressHeight);
    }
}

