/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.util.Objects;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public final class Animations {
    public static final Interpolator EASE = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);

    public static Timeline flash(Node node) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(Duration.millis((double)250.0), new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(Duration.millis((double)750.0), new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
            }
        });
        return t;
    }

    public static Timeline pulse(Node node) {
        return Animations.pulse(node, 1.05);
    }

    public static Timeline pulse(Node node, double scale) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1, EASE)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)scale, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)scale, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)scale, EASE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setScaleX(1.0);
                node.setScaleY(1.0);
                node.setScaleZ(1.0);
            }
        });
        return t;
    }

    public static Timeline shakeX(Node node) {
        return Animations.shakeX(node, 10.0);
    }

    public static Timeline shakeX(Node node, double offset) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)}), new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)800.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)900.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline shakeY(Node node) {
        return Animations.shakeY(node, 10.0);
    }

    public static Timeline shakeY(Node node, double offset) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)}), new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)800.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)offset, EASE)}), new KeyFrame(Duration.millis((double)900.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-offset), EASE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline wobble(Node node) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)0, EASE)}), new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-0.25 * node.getBoundsInParent().getWidth()), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)-5, EASE)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(0.2 * node.getBoundsInParent().getWidth()), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)3, EASE)}), new KeyFrame(Duration.millis((double)450.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-0.15 * node.getBoundsInParent().getWidth()), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)-3, EASE)}), new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(0.1 * node.getBoundsInParent().getWidth()), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)2, EASE)}), new KeyFrame(Duration.millis((double)750.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-0.05 * node.getBoundsInParent().getWidth()), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)-1, EASE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateX(0.0);
                node.setRotate(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeIn(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
            }
        });
        return t;
    }

    public static Timeline fadeOut(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
            }
        });
        return t;
    }

    public static Timeline fadeInDown(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)(-node.getBoundsInParent().getHeight()), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeOutDown(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)node.getBoundsInParent().getHeight(), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeInLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInParent().getWidth()), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeOutLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInParent().getWidth()), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeInRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)node.getBoundsInParent().getWidth(), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeOutRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)node.getBoundsInParent().getWidth(), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeInUp(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)node.getBoundsInParent().getHeight(), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline fadeOutUp(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateYProperty(), (Object)(-node.getBoundsInParent().getHeight()), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline rollIn(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInLocal().getWidth()), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)-120, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateX(0.0);
                node.setRotate(0.0);
            }
        });
        return t;
    }

    public static Timeline rollOut(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.translateXProperty(), (Object)node.getBoundsInLocal().getWidth(), EASE), new KeyValue((WritableValue)node.rotateProperty(), (Object)120, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setTranslateX(0.0);
                node.setRotate(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateIn(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        node.setRotationAxis(Rotate.Z_AXIS);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.rotateProperty(), (Object)-200, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.rotateProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setRotate(0.0);
                node.setOpacity(1.0);
            }
        });
        return t;
    }

    public static Timeline rotateOut(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        node.setRotationAxis(Rotate.Z_AXIS);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.rotateProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.rotateProperty(), (Object)200, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                node.setRotate(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateInDownLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, 0.0, node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)-45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateOutDownLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, 0.0, node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateInDownRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, node.getBoundsInLocal().getWidth(), node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateOutDownRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, node.getBoundsInLocal().getWidth(), node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)-45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateInUpLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, 0.0, node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateOutUpLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, 0.0, node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)-45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateInUpRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, node.getBoundsInLocal().getWidth(), node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)-45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline rotateOutUpRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Rotate rotate = new Rotate(0.0, node.getBoundsInLocal().getWidth(), node.getBoundsInLocal().getHeight());
        node.setRotationAxis(Rotate.Z_AXIS);
        node.getTransforms().add((Object)rotate);
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)0, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)rotate.angleProperty(), (Object)45, EASE), new KeyValue((WritableValue)node.opacityProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setOpacity(1.0);
                rotate.setAngle(0.0);
            }
        });
        return t;
    }

    public static Timeline slideInDown(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-node.getBoundsInParent().getHeight()), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline slideOutDown(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)node.getBoundsInParent().getHeight(), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline slideInLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInParent().getWidth()), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline slideOutLeft(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInParent().getWidth()), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline slideInRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)node.getBoundsInParent().getWidth(), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline slideOutRight(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateXProperty(), (Object)node.getBoundsInParent().getWidth(), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateX(0.0);
            }
        });
        return t;
    }

    public static Timeline slideInUp(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)node.getBoundsInParent().getHeight(), EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline slideOutUp(Node node, Duration duration) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)0, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.translateYProperty(), (Object)(-node.getBoundsInParent().getHeight()), EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setTranslateY(0.0);
            }
        });
        return t;
    }

    public static Timeline zoomIn(Node node, Duration duration) {
        return Animations.zoomIn(node, duration, 0.3);
    }

    public static Timeline zoomIn(Node node, Duration duration, double startValue) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)startValue, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)startValue, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)startValue, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setScaleX(1.0);
                node.setScaleY(1.0);
                node.setScaleZ(1.0);
            }
        });
        return t;
    }

    public static Timeline zoomOut(Node node, Duration duration) {
        return Animations.zoomOut(node, duration, 0.3);
    }

    public static Timeline zoomOut(Node node, Duration duration, double endValue) {
        Objects.requireNonNull(node, "Node cannot be null!");
        Objects.requireNonNull(duration, "Duration cannot be null!");
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1, EASE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)endValue, EASE), new KeyValue((WritableValue)node.scaleYProperty(), (Object)endValue, EASE), new KeyValue((WritableValue)node.scaleZProperty(), (Object)endValue, EASE)})});
        t.statusProperty().addListener((obs, old, val) -> {
            if (val == Animation.Status.STOPPED) {
                node.setScaleX(1.0);
                node.setScaleY(1.0);
                node.setScaleZ(1.0);
            }
        });
        return t;
    }
}

