/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.jetbrains.annotations.Nullable;

public interface BBCodeHandler {
    public void startDocument(char[] var1);

    public void endDocument();

    public void startTag(String var1, @Nullable Map<String, String> var2, int var3, int var4);

    public void endTag(String var1, int var2, int var3);

    public void characters(int var1, int var2);

    public record Tag(String name, Type type, @Nullable Map<String, String> params, Set<String> styleClasses, Set<String> styles) {
        public Tag(String name, Type type, @Nullable Map<String, String> params, Set<String> styleClasses, Set<String> styles) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(type);
            params = Objects.requireNonNullElse(params, Collections.emptyMap());
            styleClasses = Objects.requireNonNullElse(styleClasses, Collections.emptySet());
            styles = Objects.requireNonNullElse(styles, Collections.emptySet());
        }

        public boolean hasParam(String name) {
            return this.params != null && this.params.containsKey(name);
        }

        public String getParam(String name) {
            return this.params != null ? this.params.get(name) : null;
        }

        public String getParam(String name, String defaultValue) {
            return this.params != null ? this.params.getOrDefault(name, defaultValue) : defaultValue;
        }

        public boolean isBlock() {
            return this.type == Type.BLOCK;
        }

        public boolean isSelfClose() {
            return this.type == Type.SELF_CLOSE;
        }

        public static enum Type {
            BLOCK,
            TEXT,
            SELF_CLOSE;

        }
    }

    public record Block(Pane node, @Nullable TextFlow text) {
        public Block(Pane node, @Nullable TextFlow text) {
            Objects.requireNonNull(node);
        }

        public void addText(Node child) {
            if (this.canContainText()) {
                this.text.getChildren().add((Object)child);
            }
        }

        public List<Node> children() {
            return this.node.getChildren();
        }

        public int size() {
            return this.node.getChildren().size();
        }

        public boolean isEmpty() {
            return this.node.getChildren().isEmpty();
        }

        public boolean canContainText() {
            return this.text != null;
        }
    }

    public static class Default<T extends Pane>
    implements BBCodeHandler {
        protected static final int OL_LETTER_OFFSET = 100000;
        protected final Block root;
        protected final Deque<Tag> openTags = new ArrayDeque<Tag>();
        protected final Deque<Block> openBlocks = new ArrayDeque<Block>();
        protected char[] doc;
        protected int textCursor;

        public Default(T root) {
            Block block;
            Objects.requireNonNull(root, "Root container cannot be null.");
            if (root instanceof TextFlow) {
                TextFlow tf = (TextFlow)root;
                block = new Block((Pane)root, tf);
            } else {
                block = new Block((Pane)root, new TextFlow());
            }
            this.root = block;
            this.root.node().getStyleClass().add((Object)"bb-code");
        }

        @Override
        public void startDocument(char[] doc) {
            this.doc = doc;
        }

        @Override
        public void endDocument() {
            this.doc = null;
        }

        @Override
        public void startTag(String name, @Nullable Map<String, String> params, int start, int length) {
            Tag tag = this.createTag(name, params);
            if (tag == null) {
                return;
            }
            if (!this.openTags.isEmpty()) {
                this.appendTextToCurrentBranch(this.openTags.getFirst(), this.textCursor, start - this.textCursor);
            }
            if (!tag.isSelfClose()) {
                this.openTags.addFirst(tag);
                if (tag.isBlock()) {
                    this.createBranch();
                }
            } else {
                this.appendSelfCloseTag(tag);
            }
            this.textCursor = start + length;
        }

        @Override
        public void endTag(String name, int start, int length) {
            Tag tag = this.openTags.getFirst();
            this.appendTextToCurrentBranch(tag, this.textCursor, start - this.textCursor);
            this.textCursor = start + length;
            this.openTags.removeFirst();
            if (tag.isBlock()) {
                this.openBlocks.removeFirst();
            }
        }

        @Override
        public void characters(int start, int length) {
            if (length > 0) {
                Text text = new Text(new String(this.doc, start, length));
                if (this.root.node() instanceof TextFlow) {
                    this.root.children().add((Node)text);
                } else {
                    this.appendTextToRoot((Node)text);
                }
            }
        }

        @Nullable
        protected Tag createTag(String name, @Nullable Map<String, String> params) {
            Tag.Type tagType = null;
            HashSet<String> stylesClass = new HashSet<String>();
            HashSet<String> style = new HashSet<String>();
            switch (name) {
                case "b": {
                    stylesClass.add("text-bold");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "i": {
                    stylesClass.add("text-italic");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "u": {
                    stylesClass.add("text-underlined");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "s": {
                    stylesClass.add("text-strikethrough");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "color": {
                    this.addStyleIfPresent(params, "-fx-fill", "color", style);
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "font": {
                    this.addStyleIfPresent(params, "-fx-font-family", "font", style);
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "style": {
                    this.addStyleIfPresent(params, "style", style, ";");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "sub": {
                    stylesClass.add("sub");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "sup": {
                    stylesClass.add("sup");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "heading": {
                    if (params != null && params.containsKey("heading")) {
                        stylesClass.add("title-" + this.getParamOrDefault(params, "heading", "3"));
                    }
                    stylesClass.add("heading");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "caption": {
                    stylesClass.add("text-caption");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "size": {
                    this.addStyleIfPresent(params, "-fx-font-size", "size", style);
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "small": {
                    stylesClass.add("text-small");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "url": 
                case "email": {
                    this.addStyleIfPresent(params, "class", stylesClass, " ");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "code": {
                    stylesClass.add("code");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "span": {
                    this.addStyleIfPresent(params, "span", stylesClass, " ");
                    this.addStyleIfPresent(params, "class", stylesClass, " ");
                    this.addStyleIfPresent(params, "style", style, ";");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "label": {
                    this.addStyleIfPresent(params, "label", stylesClass, " ");
                    this.addStyleIfPresent(params, "class", stylesClass, " ");
                    this.addStyleIfPresent(params, "style", style, ";");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "abbr": {
                    stylesClass.add("abbr");
                    tagType = Tag.Type.TEXT;
                    break;
                }
                case "ol": 
                case "ul": {
                    this.addStyleIfPresent(params, "class", stylesClass, " ");
                    tagType = Tag.Type.BLOCK;
                    break;
                }
                case "align": 
                case "li": 
                case "left": 
                case "center": 
                case "right": 
                case "indent": {
                    tagType = Tag.Type.BLOCK;
                    break;
                }
                case "hr": {
                    tagType = Tag.Type.SELF_CLOSE;
                }
            }
            return tagType != null ? new Tag(name, tagType, params, stylesClass, style) : null;
        }

        protected void appendTextToRoot(Node node) {
            TextFlow parent;
            if (this.root.isEmpty() || !(this.root.children().get(this.root.size() - 1) instanceof TextFlow)) {
                parent = new TextFlow();
                this.root.children().add((Node)parent);
            } else {
                parent = (TextFlow)this.root.children().get(this.root.size() - 1);
            }
            parent.getChildren().add((Object)node);
        }

        protected void appendTextToCurrentBranch(Tag tag, int textStart, int textLength) {
            if (textLength > 0) {
                Node node = this.createTextNode(tag, new String(this.doc, textStart, textLength));
                node.getStyleClass().addAll(this.getStyleClass());
                node.setStyle(this.getStyle());
                if (this.openBlocks.isEmpty()) {
                    this.appendTextToRoot(node);
                } else {
                    this.openBlocks.getFirst().addText(node);
                }
            }
        }

        protected Node createTextNode(Tag tag, String text) {
            return switch (tag.name()) {
                case "label", "code" -> new Label(text);
                case "url" -> {
                    Hyperlink node = new Hyperlink(text);
                    node.setUserData((Object)tag.getParam("url"));
                    node.getStyleClass().add((Object)"url");
                    yield node;
                }
                case "email" -> {
                    Hyperlink node = new Hyperlink(text);
                    node.setUserData((Object)tag.getParam("email"));
                    node.getStyleClass().add((Object)"email");
                    yield node;
                }
                case "abbr" -> {
                    Label node = new Label(text);
                    String tooltip = tag.getParam("abbr");
                    if (tooltip != null) {
                        node.setTooltip(new Tooltip(tooltip));
                    }
                    yield node;
                }
                default -> {
                    Text node = new Text(text);
                    node.getStyleClass().add((Object)"text");
                    yield node;
                }
            };
        }

        protected void createBranch() {
            Tag tag = this.openTags.getFirst();
            if (!tag.isBlock()) {
                return;
            }
            int hgap = 10;
            int vgap = 10;
            boolean isGrid = false;
            Block parent = !this.openBlocks.isEmpty() ? this.openBlocks.getFirst() : this.root;
            Block current = switch (tag.name()) {
                case "ul" -> {
                    VBox pane = new VBox(10.0);
                    pane.setUserData((Object)tag.getParam("ul", "\u2022"));
                    pane.getStyleClass().addAll((Object[])new String[]{"ul", "list"});
                    yield new Block((Pane)pane, null);
                }
                case "ol" -> {
                    GridPane grid = new GridPane();
                    grid.setVgap(10.0);
                    grid.setHgap(10.0);
                    grid.setUserData((Object)this.getListStartNumber(tag.getParam("ol")));
                    grid.getStyleClass().addAll((Object[])new String[]{"ol", "list"});
                    grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(Double.NEGATIVE_INFINITY, -1.0, Double.NEGATIVE_INFINITY, Priority.NEVER, HPos.LEFT, false), new ColumnConstraints(-1.0, -1.0, -1.0, Priority.SOMETIMES, HPos.LEFT, false)});
                    yield new Block((Pane)grid, null);
                }
                case "li" -> {
                    Pane var11_10;
                    TextFlow text = new TextFlow();
                    if (parent.node().getStyleClass().contains((Object)"ol") && (var11_10 = parent.node()) instanceof GridPane) {
                        GridPane grid = (GridPane)var11_10;
                        isGrid = true;
                        grid.addRow(grid.getRowCount(), new Node[]{new Label(this.getListItemNumber(grid)), text});
                        grid.getRowConstraints().add((Object)new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false));
                        yield new Block((Pane)text, text);
                    }
                    if (parent.node().getStyleClass().contains((Object)"ul")) {
                        String bullet = String.valueOf(parent.node().getUserData());
                        HBox pane = new HBox(10.0, new Node[]{new Text(bullet), text});
                        pane.setAlignment(Pos.BASELINE_LEFT);
                        pane.getStyleClass().add((Object)"li");
                        yield new Block((Pane)pane, text);
                    }
                    throw new UnsupportedOperationException("Invalid parent tag: 'ul' or 'ol' required.");
                }
                case "align" -> {
                    TextFlow text = new TextFlow();
                    HBox pane = new HBox(new Node[]{text});
                    pane.setAlignment(this.getEnumValue(Pos.class, tag.getParam("align"), Pos.TOP_LEFT));
                    yield new Block((Pane)pane, text);
                }
                case "left" -> {
                    TextFlow text = new TextFlow();
                    text.setTextAlignment(TextAlignment.LEFT);
                    HBox pane = new HBox(new Node[]{text});
                    pane.setAlignment(Pos.TOP_LEFT);
                    yield new Block((Pane)pane, text);
                }
                case "center" -> {
                    TextFlow text = new TextFlow();
                    text.setTextAlignment(TextAlignment.CENTER);
                    HBox pane = new HBox(new Node[]{text});
                    pane.setAlignment(Pos.TOP_CENTER);
                    yield new Block((Pane)pane, text);
                }
                case "right" -> {
                    TextFlow text = new TextFlow();
                    text.setTextAlignment(TextAlignment.RIGHT);
                    HBox pane = new HBox(new Node[]{text});
                    pane.setAlignment(Pos.TOP_RIGHT);
                    yield new Block((Pane)pane, text);
                }
                case "indent" -> {
                    TextFlow text = new TextFlow();
                    HBox pane = new HBox(new Node[]{text});
                    int indent = this.parseIntOrDefault(tag.getParam("indent"), 1);
                    pane.setPadding(new Insets(0.0, 0.0, 0.0, (double)(indent * 10)));
                    pane.getStyleClass().add((Object)"indent");
                    yield new Block((Pane)pane, text);
                }
                default -> new Block((Pane)new VBox(), null);
            };
            current.node().getStyleClass().addAll(this.getStyleClass());
            String currentStyle = current.node().getStyle();
            String newStyle = this.getStyle();
            current.node().setStyle((String)(currentStyle != null && !currentStyle.isEmpty() ? currentStyle + ";" + newStyle : this.getStyle()));
            if (!isGrid) {
                parent.children().add((Node)current.node());
            }
            this.openBlocks.push(current);
        }

        protected void appendSelfCloseTag(Tag tag) {
            Block parent = !this.openBlocks.isEmpty() ? this.openBlocks.getFirst() : this.root;
            HBox node = null;
            if ("hr".equals(tag.name())) {
                node = new HBox();
                node.getStyleClass().add((Object)"hr");
                int thickness = this.parseIntOrDefault(tag.getParam("hr"), 1);
                node.setStyle(String.format("-fx-border-width:0 0 %d 0", thickness));
            }
            if (node != null) {
                parent.children().add((Node)node);
            }
        }

        protected void addStyleIfPresent(Map<String, String> params, String name, String key, Collection<String> c) {
            if (params != null && params.containsKey(key)) {
                c.add(name + ":" + params.get(key));
            }
        }

        protected void addStyleIfPresent(Map<String, String> params, String key, Collection<String> c, String sep) {
            if (params != null && params.containsKey(key)) {
                Collections.addAll(c, params.get(key).split(sep));
            }
        }

        protected <E extends Enum<E>> E getEnumValue(Class<E> c, @Nullable String value, E defaultValue) {
            if (value == null) {
                return defaultValue;
            }
            try {
                return Enum.valueOf(c, value.toUpperCase());
            }
            catch (Exception ignore) {
                return defaultValue;
            }
        }

        protected int getListStartNumber(@Nullable String param) {
            int start;
            block3: {
                start = 1;
                if (param == null) {
                    return start;
                }
                try {
                    start = Integer.parseInt(param);
                }
                catch (Exception ignore) {
                    if (param.length() != 1 || !Character.isLetter(param.charAt(0))) break block3;
                    start = 100000 + param.charAt(0);
                }
            }
            return start;
        }

        protected int parseIntOrDefault(@Nullable String s, int defaultValue) {
            if (s == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (Exception ignore) {
                return defaultValue;
            }
        }

        protected String getParamOrDefault(Map<String, String> params, String key, String defaultValue) {
            if (params != null) {
                return params.getOrDefault(key, defaultValue);
            }
            return defaultValue;
        }

        protected String getListItemNumber(GridPane grid) {
            int start = Objects.requireNonNullElse(grid.getUserData(), 1);
            return start < 100000 ? start + grid.getRowCount() + "." : (char)(start + grid.getRowCount() - 100000) + ".";
        }

        protected Set<String> getStyleClass() {
            Iterator<Tag> it = this.openTags.descendingIterator();
            LinkedHashSet<String> styleClass = new LinkedHashSet<String>();
            while (it.hasNext()) {
                Tag tag = it.next();
                styleClass.addAll(tag.styleClasses());
            }
            return styleClass;
        }

        protected String getStyle() {
            Iterator<Tag> it = this.openTags.descendingIterator();
            LinkedHashSet<String> style = new LinkedHashSet<String>();
            while (it.hasNext()) {
                Tag tag = it.next();
                style.addAll(tag.styles());
            }
            return String.join((CharSequence)";", style);
        }
    }
}

