/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.Property;

class BeanPropertyField<T, M, R extends Property<T>>
implements PropertyField<T, M, R> {
    private final R targetProperty;
    private T defaultValue;
    private final Function<M, T> getter;
    private final BiConsumer<M, T> setter;

    public BeanPropertyField(SideEffect updateFunction, Function<M, T> getter, BiConsumer<M, T> setter, Supplier<R> propertySupplier) {
        this(updateFunction, getter, setter, null, propertySupplier);
    }

    public BeanPropertyField(SideEffect updateFunction, Function<M, T> getter, BiConsumer<M, T> setter, T defaultValue, Supplier<R> propertySupplier) {
        this.defaultValue = defaultValue;
        this.getter = getter;
        this.setter = setter;
        this.targetProperty = (Property)propertySupplier.get();
        this.targetProperty.addListener((observable, oldValue, newValue) -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
        this.setter.accept(wrappedObject, this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        this.targetProperty.setValue(this.getter.apply(wrappedObject));
    }

    @Override
    public void resetToDefault() {
        this.targetProperty.setValue(this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = this.getter.apply(wrappedObject);
    }

    @Override
    public R getProperty() {
        return this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        Object wrapperValue;
        T modelValue = this.getter.apply(wrappedObject);
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty.getValue());
    }
}

