﻿--[[--

--]]--
----------------------------------------------------------------------------------------------------
local math, table, string = math, table, string;
local ipairs, pairs, type, select, tonumber, unpack = ipairs, pairs, type, select, tonumber, unpack;
local gsub = gsub;
local acos, ceil, max, min = acos, ceil, max, min;
local _G=_G;
local GameTooltip=GameTooltip;
----------------------------------------------------------------------------------------------------
local size = 60;
local nCoord = 12;
local nCell = nCoord * nCoord;
local coordCell = 1/nCoord;
local color = { 0.25, 1.00, 0.75, 1.00 };
local PI = ‭3.1415926536‬;
----------------------------------------------------------------------------------------------------

local function create()
	local F = CreateFrame("Frame");
	F:ClearAllPoints();
	F:SetPoint("TOP", UIParent, "TOP", 0, -180);
	F:SetSize(size, size);
	F:SetMovable(false);
	F:SetResizable(false);
	F:EnableMouse(false);
	F:SetClampedToScreen(true);
	F:Hide();

	local T = F:CreateTexture(nil, "ARTWORK");
	T:SetAllPoints(true);
	T:SetTexture("Interface\\AddOns\\ClassicGuide\\Arrow");
	T:SetTexCoord(0.0, coordCell, 0.0, coordCell);
	T:SetVertexColor(color[1], color[2], color[3], color[4]);
	F.T = T;

	return F;

end
local function angel(T, A)
	local index = min(ceil(0.5 + A / 2 / PI * nCell), nCell) - 1;
	local lRow = ceil(index / nCoord);
	local lCol = index - row * nCoord;
	local hRow = lRow + 1;
	local hCol = lCol + 1;
	
	T:SetTexCoord(lCol * coordCell, hCol * coordCell, lRow * coordCell, hRow * coordCell);
end
local function arc(C, S)
	if S > 0 then
		return acos(C);
	elseif S < 0 then
		return PI + acos(C);
	else
		if C > 0 then
			return 0;
		else
			return PI;
		end
	end
	return 0;
end

local F = create();

CLASSICGUIDE_ARROW = {};
CLASSICGUIDE_ARROW.F = F;
CLASSICGUIDE_ARROW.T = F.T;

function CLASSICGUIDE_ARROW:Show()
	self.F:Show();
end
function CLASSICGUIDE_ARROW:Hide()
	self.F:Hide()
end
function CLASSICGUIDE_ARROW:WayTo(map, x, y)
end
function CLASSICGUIDE_ARROW:WayToA(A)
	angel(self.T, A);
end
function CLASSICGUIDE_ARROW:UP()
end
function CLASSICGUIDE_ARROW:DOWN()
end
function CLASSICGUIDE_ARROW:FLAT()
end
local function applyMapTransforms(instanceID, left, right, top, bottom)
	if transforms[instanceID] then
		for _, data in ipairs(transforms[instanceID]) do
			if left <= data.maxX and right >= data.minX and top <= data.maxY and bottom >= data.minY then
				instanceID = data.newInstanceID
				left   = left   + data.offsetX
				right  = right  + data.offsetX
				top    = top    + data.offsetY
				bottom = bottom + data.offsetY
				break
			end
		end
	end
	return instanceID, left, right, top, bottom
end
local function processMap(id, data, parent)
	if not id or not data or mapData[id] then return end

	if data.parentMapID and data.parentMapID ~= 0 then
		parent = data.parentMapID
	elseif not parent then
		parent = 0
	end

	-- get two positions from the map, we use 0/0 and 0.5/0.5 to avoid issues on some maps where 1/1 is translated inaccurately
	local vector00, vector05 = CreateVector2D(0, 0), CreateVector2D(0.5, 0.5);
	local instance, topLeft = C_Map.GetWorldPosFromMapPos(id, vector00)
	local _, bottomRight = C_Map.GetWorldPosFromMapPos(id, vector05)
	if topLeft and bottomRight then
		local top, left = topLeft:GetXY()
		local bottom, right = bottomRight:GetXY()
		bottom = top + (bottom - top) * 2
		right = left + (right - left) * 2

		instance, left, right, top, bottom = applyMapTransforms(instance, left, right, top, bottom)
		mapData[id] = {left - right, top - bottom, left, top, instance = instance, name = data.name, mapType = data.mapType, parent = parent }
	else
		mapData[id] = {0, 0, 0, 0, instance = instance or -1, name = data.name, mapType = data.mapType, parent = parent }
	end
end
function CLASSICGUIDE_ARROW:Init()
	self.mapData = self.mapData or {};
	local mapData = self.mapData;
	for i = 1, 2000 do
		if not mapData[i] then
			local mapInfo = C_Map.GetMapInfo(i)
			if mapInfo and mapInfo.name then
				processMap(i, mapInfo, nil)
			end
		end
	end
end