﻿--[[--
	alex@0
--]]--
----------------------------------------------------------------------------------------------------
local addon, ns = ...;
ns.cn = ns.cn or {};
ns.en = ns.en or {};
ns.version = "113r.190812";
local L = ns.L;
--if not L then return;end
----------------------------------------------------------------------------------------------------
local math, table, string = math, table, string;
local ipairs, pairs, type, select, tonumber, unpack = ipairs, pairs, type, select, tonumber, unpack;
local gsub = gsub;
local _G=_G;
local GameTooltip=GameTooltip;
----------------------------------------------------------------------------------------------------
local borderSize = 10;
local artwork_path = "Interface\\AddOns\\ClassicGuide\\ARTWORK\\";
local mainFrameMinW = 240;
local mainFrameMinH = 120;
local mainFrameMaxW = 640;
local mainFrameMaxH = 480;
local titleCurProgressW = 90;
local titleCurProgressH = 16;
local viewHeight = 180;
local curTaskViewW = 240;
local curTaskViewH = 30;
local mainFrameBackdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = nil;--"Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true,
		tileSize = 2,
		edgeSize = 2,
		insets = { left = 0, right = 0, top = 0, bottom = 0 }
	};
local mainFrameBackdropColor = { 0.25, 0.25, 0.25, 0.5 };
local titleCurProgressBackdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = nil;--"Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true,
		tileSize = 2,
		edgeSize = 2,
		insets = { left = 0, right = 0, top = 0, bottom = 0 }
	};
local titleCurProgressBackdropColor = { 0.15, 0.15, 0.15, 0.33 };
local viewBackdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = nil;--"Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true,
		tileSize = 2,
		edgeSize = 2,
		insets = { left = 0, right = 0, top = 0, bottom = 0 }
	};
local viewBackdropColor = { 0.15, 0.15, 0.15, 0.33 };
local dropMenuBackdrop = {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true,
		tileSize = 2,
		edgeSize = 2,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
	};
local dropMenuBackdropColor = { 0.25, 0.25, 0.25, 0.9 };

local COUNTING_DOWN_TIMER_PERIOD = 1.5;
local dropMenuButtonHeight = 20;
local dropMenuButtonInterval = 0;
local dropMenuButtonTopBottomInterval = 2;
-----------------------------------------------------------------------------------------------------main
local setting;
local default;
L = {
	zhCN = {
		["01"] = "介绍",
		["02"] = "出生地",
		["A21"] = "矮人 & 侏儒",
		["A22"] = "人类",
		["A23"] = "暗夜精灵",
		["H21"] = "兽人 & 巨魔",
		["H22"] = "牛头人",
		["H23"] = "被遗忘者",
		["03"] = "升级",
		["31"] = "12-20",
		["32"] = "20-30",
		["33"] = "30-40",
		["34"] = "40-50",
		["35"] = "50-60",
		["04"] = "商业技能",
		["05"] = "\124cffff8f00关闭\124r",
	},
	enUS = {
		["01"] = "Intro",
		["02"] = "Borne Area",
		["A21"] = "Dwarf & Gnome",
		["A22"] = "Human",
		["A23"] = "NightElf",
		["H21"] = "Orc & Throll",
		["H22"] = "Tauren",
		["H23"] = "Scourge",
		["03"] = "Level up",
		["31"] = "12-20",
		["32"] = "20-30",
		["33"] = "30-40",
		["34"] = "40-50",
		["35"] = "50-60",
		["04"] = "Profession",
		["05"] = "\124cffff8f00Close\124r",
	},
};
local locale = GetLocale();
BINDING_HEADER_CLASSICGUIDE = "Classic Guide"
if locale == "zhCN" then
	BINDING_NAME_CLASSICGUIDE_TOGGLE = "切换"
	BINDING_NAME_CLASSICGUIDE_PREV_STEP = "上一步"
	BINDING_NAME_CLASSICGUIDE_NEXT_STEP = "下一步"
	--BINDING_NAME_CLASSICGUIDE_PREV_GUIDE = "上一指引"
	--BINDING_NAME_CLASSICGUIDE_NEXT_GUIDE = "下一指引"
else
	BINDING_NAME_CLASSICGUIDE_TOGGLE = "Toggle UI"
	BINDING_NAME_CLASSICGUIDE_PREV_STEP = "Prev Step"
	BINDING_NAME_CLASSICGUIDE_NEXT_STEP = "Next Step"
	--BINDING_NAME_CLASSICGUIDE_PREV_GUIDE = "Prev Guide"
	--BINDING_NAME_CLASSICGUIDE_NEXT_GUIDE = "Next Guide"
end
-----------------------------------------------------------------------------------------------------main
--GetRealZoneText();
--GetZoneText();
--GetPlayerFacing();--[0.00,2pi),ccw
local F = CreateFrame("frame");
local mainFrame = nil;
local view = nil;
local lockButton = nil;

local function PRINT(...)
	print(...);
end

local prevTomTomWayPoint = nil;
local function arrow(d)
	local TomTom = TomTom;
	if TomTom and TomTom.NameToMapId then
		if prevTomTomWayPoint then
			TomTom:RemoveWaypoint(prevTomTomWayPoint);
		end
		local NameToMapId = TomTom.NameToMapId;
		local mapId = TomTom.NameToMapId[d.zone];
		if mapId then
			prevTomTomWayPoint = TomTom:AddWaypoint(mapId, d.x / 100, d.y / 100, { title = "" });
		end
	else
	end
	-- if SlashCmdList["TOMTOM_WAY"] then
	-- 	if d.x and d.y and d.zone then
	-- 		SlashCmdList["TOMTOM_WAY"](d.zone .. " " .. d.x .. " " .. d.y);
	-- 	end
	-- else
	-- end
end

local function apply(mainFrame)
	local data = mainFrame.data;

	local D = nil;
	if setting.control_cur_L == 1 then
		D = data[setting.control_cur_L1];
	elseif setting.control_cur_L == 2 then
		D = data[setting.control_cur_L1][setting.control_cur_L2];
	elseif setting.control_cur_L == 3 then
		D = data[setting.control_cur_L1][setting.control_cur_L2][setting.control_cur_L3];
	end
	local d = D.items;
	if not d then
		--PRINT("NO d");
		return -1;
	end
	if D.title then
		mainFrame.curTaskText:SetText(D.title);
	end
	if d[setting.control_cur_I] then
		if d[setting.control_cur_I].str then
			mainFrame.viewText:SetText(d[setting.control_cur_I].str);
		end
		arrow(d[setting.control_cur_I]);
		mainFrame.titleCurProgressText:SetText(setting.control_cur_I .. " / " .. #d);
	else
		--PRINT("NO CUR INDEX DATA");
	end
	return 0;
end

local dropMenuButtonOnClick;
local dropMenuButtonOnEnter;
local dropMenuButtonOnLeave;
local showMenu;

dropMenuButtonOnClick = function(self, button)
	local level = self.level;
	local packIndex = self.packIndex;
	local action = self.action;
	local data = mainFrame.data;
	if level == 1 then
		local action1 = action[1];
		if action1 == 5 then
			self.parent:Hide();
			return;
		end

		if data[action1].items then
			setting.control_cur_L = 1;
			setting.control_cur_L1 = action1;
			setting.control_cur_L2 = 0;
			setting.control_cur_L3 = 0;
			setting.control_cur_I = 1;
			
			--PRINT(action1);

			apply(mainFrame);
			self.parent:Hide();
		end
	elseif level == 2 then
		local action1 = action[1];
		local action2 = action[2];

		if data[action1][action2].items then
			setting.control_cur_L = 2;
			setting.control_cur_L1 = action1;
			setting.control_cur_L2 = action2;
			setting.control_cur_L3 = 0;
			setting.control_cur_I = 1;

			--PRINT(action1, action2);

			apply(mainFrame);
			self.parent.parent:Hide();
		end
	elseif level == 3 then
		local action1 = action[1];
		local action2 = action[2];
		local action3 = action[3];

		if data[action1][action2][action3].items then
			setting.control_cur_L = 3;
			setting.control_cur_L1 = action1;
			setting.control_cur_L2 = action2;
			setting.control_cur_L3 = action3;
			setting.control_cur_I = 1;

			--PRINT(action1, action2, action3);
			
			apply(mainFrame);
			self.parent.parent.parent:Hide();
		end
	end
end
dropMenuButtonOnEnter = function(self)
	local data = mainFrame.data;
	local level = self.level;
	local action = self.action;
	if level == 1 then
		self.parent.isCountingDown = false;
		local action1 = action[1]
		local data1 = data[action1];
		if data1.L then
			local menu2 = mainFrame.dropMenu2;
			showMenu(menu2, data1, action, level + 1);
			menu2:ClearAllPoints();
			menu2:SetPoint("TOPLEFT", self, "TOPRIGHT", 2, 0);
		else
			mainFrame.dropMenu2:Hide();
		end
		mainFrame.dropMenu3:Hide();
	elseif level == 2 then
		self.parent.parent.isCountingDown = false;
		local action1 = action[1];
		local action2 = action[2];
		local data2 = data[action1][action2];
		if data2.L then
			local menu3 = mainFrame.dropMenu3;
			showMenu(menu3, data2, action, level + 1);
			menu3:ClearAllPoints();
			menu3:SetPoint("TOPLEFT", self, "TOPRIGHT", 2, 0);
		else
			mainFrame.dropMenu3:Hide();
		end
	elseif level == 3 then
		self.parent.parent.parent.isCountingDown = false;
	else
		PRINT("ERROR dropMenuButtonOnEnter");
	end
end
dropMenuButtonOnLeave = function(self)
	local level = self.level;
	if level == 1 then
		local P = self.parent;
		P.isCountingDown = true;
		P.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
	elseif level == 2 then
		local P = self.parent.parent;
		P.isCountingDown = true;
		P.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
	elseif level == 3 then
		local P = self.parent.parent.parent;
		P.isCountingDown = true;
		P.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
	else
		PRINT("ERROR dropMenuButtonOnEnter");
	end
end
showMenu = function(menu, data, action, level)
	local buttons = menu.buttons;
	if #buttons < #data then
		for i = #buttons + 1, #data do
			local button = CreateFrame("Button", nil, menu);
			button:SetHeight(dropMenuButtonHeight);
			--button:SetNormalTexture("Interface\\Buttons\\UI-StopButton");
			--button:SetPushedTexture("Interface\\Buttons\\UI-StopButton");
			button:SetHighlightTexture("Interface\TargetingFrame\UI-StatusBar");
			button:GetHighlightTexture():SetVertexColor(0.5, 0.5, 0.0, 0.75);
			button:SetPoint("TOP", menu, 0, -((i - 1) * (dropMenuButtonHeight + dropMenuButtonInterval) + dropMenuButtonTopBottomInterval));

			local text = button:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
			text:SetPoint("LEFT", 2, 0);
			text:SetTextColor(0.9, 0.9, 0.9, 0.9);
			text.parent = button;
			button.text = text;

			local texture = button:CreateTexture(nil, "ARTWORK");
			texture:SetSize(dropMenuButtonHeight / 2, dropMenuButtonHeight);
			texture:SetPoint("RIGHT", -2, 0);
			texture:SetTexture("interface\\buttons\\ui-colorpicker-buttons");
			texture:SetTexCoord(0.25, 0.375, 0.0, 1.0);
			texture:SetVertexColor(1.0, 1.0, 0.25, 1.0);
			texture.parent = button;
			button.texture = texture;
			
			button:SetScript("OnClick", dropMenuButtonOnClick);
			button:SetScript("OnEnter", dropMenuButtonOnEnter);
			button:SetScript("OnLeave", dropMenuButtonOnLeave);
	
			button.parent = menu;
			
			buttons[i] = button;
		end
	elseif #buttons > #data then
		for i = #data + 1, #buttons do
			buttons[i]:Hide();
		end
	end

	local width = -1;
	for i = 1, #data do
		local button = buttons[i];

		button.level = level;
		button.action = {};
		for k, v in pairs(action) do
			button.action[k] = v;
		end
		button.action[level] = i;
	
		button:Show();

		button.text:SetText(data[i].title);
		local w = button.text:GetWidth();
		if w > width then
			width = w;
		end

		if data[i].L then
			button.texture:Show();
		else
			button.texture:Hide();
		end
	end
	width = width + dropMenuButtonHeight;
	for i = 1, #data do
		buttons[i]:SetWidth(width);
	end
	menu:SetWidth(width);
	menu:SetHeight(dropMenuButtonHeight * #data + dropMenuButtonInterval * (#data - 1) + dropMenuButtonTopBottomInterval * 2);

	menu:Show();
end

local function dropButtonOnClick(self, button)
	local menu1 = self.dropMenu1;
	if menu1:IsShown() then
		menu1:Hide();
		return;
	end
	self.dropMenu2:Hide();
	self.dropMenu3:Hide();
	showMenu(menu1, mainFrame.data, {}, 1);
end
local function prevButtonOnClick(self, button)
	local data = mainFrame.data;
	setting.control_cur_I = max(setting.control_cur_I - 1, 1);
	apply(mainFrame);
end
local function nextButtonOnClick(self, button)
	local data = mainFrame.data;
	setting.control_cur_I = setting.control_cur_I + 1;

	local data = mainFrame.data;
	local D = nil;
	if setting.control_cur_L == 1 then
		D = data[setting.control_cur_L1];
		if D.items and setting.control_cur_I > #D.items then
			--setting.control_cur_L1 = min(setting.control_cur_L1 + 1, #data);
			setting.control_cur_I = #D.items;
		end
		--PRINT(setting.control_cur_L, setting.control_cur_I , D.items and #D.items);
	elseif setting.control_cur_L == 2 then
		D = data[setting.control_cur_L1][setting.control_cur_L2];
		if D.items and setting.control_cur_I > #D.items then
			if D.nextUpperLevel then
				setting.control_cur_L1 = min(D.nextUpperLevel, #data);
				setting.control_cur_L2 = 1;
				setting.control_cur_I = 1;
			elseif D.seq then
				setting.control_cur_L2 = setting.control_cur_L2 + 1;
				if setting.control_cur_L2 <= #data[setting.control_cur_L1] then
					setting.control_cur_I = 1;
				else
					if D.nextUpperLevelInc and setting.control_cur_L2 < #data then
						setting.control_cur_L1 = setting.control_cur_L1 + 1;
						setting.control_cur_L2 = 1;
						setting.control_cur_I = 1;
					else
						setting.control_cur_L2 = #data[setting.control_cur_L1];
						setting.control_cur_I = #D.items;
					end
				end
			else
				setting.control_cur_I = #D.items;
			end
		end
		--PRINT(setting.control_cur_L, setting.control_cur_I , D.items and #D.items);
	elseif setting.control_cur_L == 3 then
		D = data[setting.control_cur_L1][setting.control_cur_L2][setting.control_cur_L3];
		if D.items and setting.control_cur_I > #D.items then
			if D.nextUpperLevel then
				setting.control_cur_L2 = min(D.nextUpperLevel, #data[setting.control_cur_L1]);
				setting.control_cur_L3 = 1;
				setting.control_cur_I = 1;
			elseif D.nextUpperUpperLevel then
				setting.control_cur_L1 = min(D.nextUpperUpperLevel, #data);
				setting.control_cur_L2 = 1;
				setting.control_cur_L3 = 1;
				setting.control_cur_I = 1;
			elseif D.seq then
				setting.control_cur_L3 = setting.control_cur_L3 + 1;
				if setting.control_cur_L3 <= #data[setting.control_cur_L1][setting.control_cur_L2] then
					setting.control_cur_I = 1;
				else
					if D.nextUpperLevelInc and setting.control_cur_L2 < #data[setting.control_cur_L1] then
						setting.control_cur_L2 = setting.control_cur_L2 + 1;
						setting.control_cur_L3 = 1;
						setting.control_cur_I = 1;
					else
						setting.control_cur_L3 = #data[setting.control_cur_L1][setting.control_cur_L2];
						setting.control_cur_I = #D.items;
					end
				end
			else
				setting.control_cur_I = #D.items;
			end
		end
		--PRINT(setting.control_cur_L, setting.control_cur_L1, setting.control_cur_L2, setting.control_cur_L3, setting.control_cur_I , D.items and #D.items);
	end

	apply(mainFrame);
end

local function Lock(self)
	if setting.isLocked then
		self:GetNormalTexture():SetVertexColor(0.5, 0.5, 0.5, 0.75);
		setting.isLocked = false;
		mainFrame:Show();
	else
		self:GetNormalTexture():SetVertexColor(1, 1, 1, 1);
		setting.isLocked = true;
		mainFrame:Hide();
	end
end
local function recordPos()
	local a, b, c, d, e = mainFrame:GetPoint();
	if a and (type(a) == "table") then
		a = a:GetName() or nil;
	elseif b and (type(b) == "table") then
		b = b:GetName() or nil;
	end
	if e then setting.point = { a, b, c, d, e };
	elseif d then setting.point = { a, b, c, d };
	elseif c then setting.point = { a, b, c };
	elseif b then setting.point = { a, b };
	elseif a then setting.point = { a };
	else setting.point = {};
	end
	default.point = setting.point;
end

local function viewTextSetFontSize(size)
	view.viewText:SetFont(view.viewText:GetFont(), size, false);
end

local function sliderDisable(self)
	self.text:SetTextColor(GRAY_FONT_COLOR.r,GRAY_FONT_COLOR.g,GRAY_FONT_COLOR.b)
	self.minText:SetTextColor(GRAY_FONT_COLOR.r,GRAY_FONT_COLOR.g,GRAY_FONT_COLOR.b)
	self.maxText:SetTextColor(GRAY_FONT_COLOR.r,GRAY_FONT_COLOR.g,GRAY_FONT_COLOR.b)
	self.valueBox:SetTextColor(GRAY_FONT_COLOR.r,GRAY_FONT_COLOR.g,GRAY_FONT_COLOR.b)
	self.valueBox:SetEnabled(false)
end
local function sliderEnable(self)
	self.text:SetTextColor(HIGHLIGHT_FONT_COLOR.r,HIGHLIGHT_FONT_COLOR.g,HIGHLIGHT_FONT_COLOR.b)
	self.minText:SetTextColor(HIGHLIGHT_FONT_COLOR.r,HIGHLIGHT_FONT_COLOR.g,HIGHLIGHT_FONT_COLOR.b)
	self.maxText:SetTextColor(HIGHLIGHT_FONT_COLOR.r,HIGHLIGHT_FONT_COLOR.g,HIGHLIGHT_FONT_COLOR.b)
	self.valueBox:SetTextColor(HIGHLIGHT_FONT_COLOR.r,HIGHLIGHT_FONT_COLOR.g,HIGHLIGHT_FONT_COLOR.b)
	self.valueBox:SetEnabled(true)
end
local function sliderRefresh(self)
	self:SetValue(setting.fontSize);
	self.valueBox:SetText(setting.fontSize);
end
local function sliderOnValueChanged(self,value,userInput)
	local value=floor(value / self.stepSize + 0.5) * self.stepSize;
	if userInput then
		setting.fontSize = value;
		viewTextSetFontSize(value);
	end
	self.valueBox:SetText(value);
end
local function sliderValueBoxOnEscapePressed(self)
	self:SetText(setting.fontSize);
	self:ClearFocus()
end
local function sliderValueBoxOnEnterPressed(self)
	local value = tonumber(self:GetText()) or 0.0
	value = floor(value / self.parent.stepSize + 0.5) * self.parent.stepSize
	value = max(self.parent.minRange, min(self.parent.maxRange, value))
	self.parent:SetValue(value)
	setting.fontSize=value;
	self:SetText(value);
	viewTextSetFontSize(value);
	self:ClearFocus();
end
local function sliderValueBoxOnOnChar(self)
	self:SetText(self:GetText():gsub("[^%.0-9]+",""):gsub("(%..*)%.","%1"))
end
local function createSlider(parent, height, minVal, maxVal)
	local slider = CreateFrame("Slider", "ClassicGuideSlider", parent, "OptionsSliderTemplate");

	slider:ClearAllPoints();
	slider:SetHeight(height);

	slider:SetScript("OnShow", sliderRefresh);
	slider:HookScript("OnValueChanged", sliderOnValueChanged)
	slider:HookScript("OnDisable", sliderDisable)
	slider:HookScript("OnEnable", sliderEnable)
	slider.stepSize = 1;
	slider:SetValueStep(1);
	slider:SetObeyStepOnDrag(true);

	slider:SetMinMaxValues(minVal, maxVal)
	slider.minRange = minVal;
	slider.maxRange = maxVal;
	slider.minText = _G[slider:GetName() .. "Low"];
	slider.maxText = _G[slider:GetName() .. "High"];
	slider.text = _G[slider:GetName() .. "Text"];
	slider.minText:SetText(minVal)
	slider.maxText:SetText(maxVal)
	slider.text:SetText("字体大小");

	local valueBox = CreateFrame("editbox", nil, slider);
	valueBox:SetPoint("TOP", slider, "BOTTOM", 0, 0);
	valueBox:SetSize(60, 14);
	valueBox:SetFontObject(GameFontHighlightSmall);
	valueBox:SetAutoFocus(false);
	valueBox:SetJustifyH("CENTER");
	valueBox:SetScript("OnEscapePressed", sliderValueBoxOnEscape);
	valueBox:SetScript("OnEnterPressed", sliderValueBoxOnEnterPressed);
	valueBox:SetScript("OnChar", sliderValueBoxOnOnChar);
	valueBox:SetMaxLetters(5);

	valueBox:SetBackdrop({
		bgFile = "Interface/ChatFrame/ChatFrameBackground",
		edgeFile = "Interface/ChatFrame/ChatFrameBackground",
		tile = true,
		edgeSize = 1,
		tileSize = 5,
	})
	valueBox:SetBackdropColor(0,0,0,0.5)
	valueBox:SetBackdropBorderColor(0.3,0.3,0.3,0.8)
	valueBox.parent = slider;

	slider.valueBox = valueBox;

	return slider;
end

local function createMainFrame()
	local mainFrame = CreateFrame("Frame");
	mainFrame:ClearAllPoints();
	mainFrame:SetPoint(unpack(setting.point));
	mainFrame:SetMinResize(mainFrameMinW, mainFrameMinH);
	mainFrame:SetMaxResize(mainFrameMaxW, mainFrameMaxH);
	mainFrame:SetSize(setting.mainFrameCurW, setting.mainFrameCurH);
	mainFrame:SetMovable(true);
	mainFrame:SetResizable(true);
	mainFrame:SetBackdrop(mainFrameBackdrop);
	mainFrame:SetBackdropColor(mainFrameBackdropColor[1], mainFrameBackdropColor[2], mainFrameBackdropColor[3], mainFrameBackdropColor[4]);
	mainFrame:EnableMouse(true);
	mainFrame:SetClampedToScreen(true);
	mainFrame:RegisterForDrag("LeftButton");
	mainFrame:SetScript("OnMouseDown", function(self, button)
			local x, y = GetCursorPosition();
			local s = self:GetEffectiveScale();
			x = x / s;
			y = y / s;
			local bottom = self:GetBottom();
			local top = self:GetTop();
			local left = self:GetLeft();
			local right = self:GetRight();

			if button == "LeftButton" and not self.isMoving and not self.isResizing and not self.bLocked then
				if (x < left + borderSize and y < bottom + borderSize) then
					self:StartSizing("BOTTOMLEFT")
					self.isResizing = true
				elseif (x < left + borderSize and y > top - borderSize) then
					self:StartSizing("TOPLEFT")
					self.isResizing = true
				elseif (x > right - borderSize and y < bottom + borderSize) then
					self:StartSizing("BOTTOMRIGHT")
					self.isResizing = true
				elseif (x > right - borderSize and y > top - borderSize) then
					self:StartSizing("TOPRIGHT")
					self.isResizing = true
				elseif (x < left + borderSize) then
					self:StartSizing("LEFT")
					self.isResizing = true
				elseif (x > right - borderSize) then
					self:StartSizing("RIGHT")
					self.isResizing = true
				elseif (y < bottom + borderSize) then
					self:StartSizing("BOTTOM")
					self.isResizing = true
				elseif (y > top - borderSize) then
					self:StartSizing("TOP")
					self.isResizing = true
				-- elseif StepFrame and ScrollFrame and (x > left + borderSize and y > topScroll and y < bottomStep and x < right + borderSize) then
				-- 	local nH = self:GetHeight()
				-- 	local nGapMin = nH * 0.85 - (nH /2)
				-- 	local nGapMax = nH * 0.45 - (nH /2)
				-- 	local nC = nH / 2
				-- 	local nT = fStep:GetTop()
				-- 	local nMinH = nC - nGapMin - 23
				-- 	local nMaxH = nC - nGapMax - 23
				-- 	fStep:SetMinResize(fStep:GetWidth(), nMinH)
				-- 	fStep:SetMaxResize(fStep:GetWidth(), nMaxH)
				-- 	fStep.isResizing = true
				-- 	fStep:StartSizing("BOTTOM")
				--elseif
				else
					self:StartMoving()
					self.isMoving = true
				end
			else
			end
		end
	);
	mainFrame:SetScript("OnMouseUp", function(self, button)
			if button == "LeftButton" then
				if self.isMoving then
					self:StopMovingOrSizing()
					self.isMoving = false
					recordPos();
				elseif self.isResizing then
					self:StopMovingOrSizing()
					self.isResizing = false
				end
			end
		end
	);
	mainFrame:SetScript("OnSizeChanged", function(self, width, height)
				setting.mainFrameCurW = width;
				setting.mainFrameCurH = height;
				default.mainFrameCurW = width;
				default.mainFrameCurH = height;
			end
	);
	mainFrame:SetScript("OnShow", function(self)
		end
	);
	mainFrame:SetScript("OnHide", function(self)
			if self.isMoving then
				self:StopMovingOrSizing();
				self.isMoving = false;
			end
			if self.isResizing then
				self:StopMovingOrSizing();
				self.isResizing = false;
			end
		end
	);
	
	local titleCurProgress = CreateFrame("Frame", nil)
	titleCurProgress:SetPoint("TOP" , mainFrame, "TOP", 0, titleCurProgressH - 18 - 2);
	titleCurProgress:SetSize(titleCurProgressW, titleCurProgressH);
	titleCurProgress:EnableMouse(true);
	titleCurProgress:SetBackdrop(titleCurProgressBackdrop);
	titleCurProgress:SetBackdropColor(titleCurProgressBackdropColor[1], titleCurProgressBackdropColor[2], titleCurProgressBackdropColor[3], titleCurProgressBackdropColor[4]);
	titleCurProgress:RegisterForDrag("LeftButton");
	titleCurProgress:SetScript("OnDragStart", function(self)
			mainFrame:StartMoving();
		end
	);
	titleCurProgress:SetScript("OnDragStop", function(self)
			mainFrame:StopMovingOrSizing();
			recordPos();
		end
	);
	--titleCurProgress:SetScript("OnSizeChanged", function()
	--end)
	titleCurProgress.mainFrame = mainFrame;
	mainFrame.titleCurProgress = titleCurProgress;
	mainFrame:HookScript("OnShow", function() titleCurProgress:Show();end)

	local titleCurProgressText = titleCurProgress:CreateFontString(sName, "ARTWORK", "GameFontNormalSmall");
	titleCurProgressText:SetPoint("CENTER")
	titleCurProgressText:SetTextColor(0.9, 0.9, 0.9, 0.9)
	titleCurProgressText:SetJustifyH("LEFT")
	titleCurProgressText:SetJustifyV("TOP")
	titleCurProgressText.parent = titleCurProgress;
	titleCurProgress.titleCurProgressText = titleCurProgressText;
	mainFrame.titleCurProgressText = titleCurProgressText;

	local view = CreateFrame("Frame", nil)
	view:SetPoint("TOP", titleCurProgress, "BOTTOM");
	view:SetPoint("BOTTOMRIGHT", mainFrame, "BOTTOMRIGHT", -4, -28);
	view:SetPoint("BOTTOMLEFT", mainFrame, "BOTTOMLEFT", 4, 28);
	view:SetHeight(viewHeight);
	view:SetResizable(true)
	view:EnableMouse(false);
	view:SetBackdrop(viewBackdrop);
	view:SetBackdropColor(viewBackdropColor[1], viewBackdropColor[2], viewBackdropColor[3], viewBackdropColor[4]);
	--view:SetScript("OnSizeChanged", function()
	--end)
	view.mainFrame = mainFrame;
	mainFrame.view = view;
	mainFrame:HookScript("OnShow", function() view:Show();end)

	local viewText = view:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall")
	viewText:SetPoint("TOPLEFT", 5, -5)
	viewText:SetPoint("BOTTOMRIGHT", -5, 5)
	viewText:SetTextColor(0.9, 0.9, 0.9, 0.9)
	viewText:SetJustifyH("LEFT")
	viewText:SetJustifyV("TOP")
	viewText:SetText("")
	viewText.parent = view;
	view.viewText = viewText;
	mainFrame.viewText = viewText;
	if not setting.fontSize then
		setting.fontSize = select(2, viewText:GetFont());
	else
		viewText:SetText(viewText:GetFont(), setting.fontSize, false);
	end

	local lockButton = CreateFrame("Button", nil);
	lockButton:SetSize(18, 18);
	lockButton:SetNormalTexture("Interface\\petbattles\\petbattle-lockicon");
	lockButton:SetPushedTexture("Interface\\petbattles\\petbattle-lockicon");
	lockButton:GetNormalTexture():SetVertexColor(0.5, 0.5, 0.5, 0.75)
	lockButton:SetHighlightTexture("Interface\\Buttons\\CheckButtonHilight");
	lockButton:SetPoint("TOPLEFT", mainFrame, "TOPLEFT", 6, -4);
	lockButton:SetScript("OnClick", Lock);
	lockButton:SetFrameLevel(mainFrame:GetFrameLevel() + 1);
	lockButton.mainFrame = mainFrame;
	mainFrame.lockButton = lockButton;
	mainFrame:HookScript("OnShow", function() lockButton:Show();end)

	local fontSlider = createSlider(mainFrame, 20, 6, 36);
	fontSlider:ClearAllPoints();
	fontSlider:SetPoint("BOTTOMLEFT", mainFrame, "TOPLEFT", 0, 16);
	fontSlider:SetPoint("BOTTOMRIGHT", mainFrame, "TOPRIGHT", 0, 16);
	fontSlider:Hide();

	local fontButton = CreateFrame("Button", nil, mainFrame);
	fontButton:SetSize(18, 18);
	fontButton:SetNormalTexture("Interface\\MAINMENUBAR\\ui-mainmenu-scrollupbutton-up");
	fontButton:SetPushedTexture("Interface\\MAINMENUBAR\\ui-mainmenu-scrollupbutton-down");
	--fontButton:GetNormalTexture():SetVertexColor(0.5, 0.5, 0.5, 0.75)
	fontButton:SetHighlightTexture("Interface\\MAINMENUBAR\\ui-mainmenu-scrollupbutton-highlight");
	fontButton:GetNormalTexture():SetTexCoord(0.25, 0.75, 0.25, 0.75);
	fontButton:GetPushedTexture():SetTexCoord(0.25, 0.75, 0.25, 0.75);
	fontButton:GetHighlightTexture():SetTexCoord(0.25, 0.75, 0.25, 0.75);
	fontButton:SetPoint("LEFT", lockButton, "RIGHT", 6, 0);
	fontButton:SetScript("OnClick", function(self)
			if fontSlider:IsShown() then
				fontSlider:Hide();
			else
				fontSlider:Show();
			end
		end
	);
	fontButton:SetFrameLevel(mainFrame:GetFrameLevel() + 1);
	fontButton.mainFrame = mainFrame;
	mainFrame.fontButton = fontButton;
	mainFrame:HookScript("OnShow", function() fontButton:Show();end)

	local closeButton = CreateFrame("Button", nil, mainFrame);
	closeButton:SetSize(18, 18);
	closeButton:SetNormalTexture("Interface\\Buttons\\UI-StopButton");
	closeButton:SetPushedTexture("Interface\\Buttons\\UI-StopButton");
	closeButton:SetHighlightTexture("Interface\\Buttons\\CheckButtonHilight");
	closeButton:SetPoint("TOPRIGHT", -6, -4);
	closeButton:SetScript("OnClick", function(self, button)
			self.mainFrame:Hide();
			titleCurProgress:Hide();
			view:Hide();
			lockButton:Hide();
		end
	);
	closeButton.mainFrame = mainFrame;
	mainFrame.closeButton = closeButton;

	local dropButton = CreateFrame("Button", nil, mainFrame);
	dropButton:SetSize(18, 18);
	dropButton:SetNormalTexture(artwork_path .. "Button-DDMonRight-ArrowDown-Normal");
	dropButton:SetPushedTexture(artwork_path .. "Button-DDMonRight-ArrowDown-Pushed");
	dropButton:SetHighlightTexture(artwork_path .. "Button-Details-Highlight");
	dropButton:SetPoint("BOTTOMLEFT", 6, 6);
	dropButton:SetText("QUEST");
	dropButton:SetScript("OnClick", dropButtonOnClick);
	dropButton:SetScript("OnEnter", function(self)
			if self.dropMenu1:IsShown() then
				self.dropMenu1.isCountingDown = false;
			end
		end
	);
	dropButton:SetScript("OnLeave", function(self)
			if self.dropMenu1:IsShown() then
				self.dropMenu1.isCountingDown = true;
				self.dropMenu1.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
			end
		end
	);
	dropButton.mainFrame = mainFrame;
	mainFrame.dropButton = dropButton;

	local dropMenu1 = CreateFrame("Button", nil, mainFrame);
	dropMenu1:SetClampedToScreen(true);
	dropMenu1:Hide();
	dropMenu1:SetPoint("TOPLEFT", dropButton, "BOTTOMLEFT", 0, -6);
	dropMenu1:SetBackdrop(dropMenuBackdrop);
	dropMenu1:SetBackdropColor(dropMenuBackdropColor[1], dropMenuBackdropColor[2], dropMenuBackdropColor[3], dropMenuBackdropColor[4]);
	dropMenu1:SetScript("OnClick", function(self, button)
			self:Hide();
		end
	);
	dropMenu1:SetScript("OnEnter", function(self)
			self.isCountingDown = false;
		end
	);
	dropMenu1:SetScript("OnLeave", function(self)
			self.isCountingDown = true;
			self.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
		end
	);
	dropMenu1:SetScript("OnUpdate", function(self, elasped)
			if self:IsShown() and self.isCountingDown then
				self.countingDownTimer = self.countingDownTimer - elasped;
				if self.countingDownTimer <= 0 then
					self.isCountingDown = false;
					self:Hide();
				end
			end
		end
	);
	dropMenu1:SetScript("OnHide", function(self)
			self.isCountingDown = false;
		end
	);
	dropMenu1.mainFrame = mainFrame;
	dropMenu1.dropButton = dropButton;
	dropButton.dropMenu1 = dropMenu1;
	mainFrame.dropMenu1 = dropMenu1;
	dropMenu1.buttons = {};

	local dropMenu2 = CreateFrame("Button", nil, dropMenu1);
	dropMenu2:SetClampedToScreen(true);
	dropMenu2:Hide();
	dropMenu2:SetPoint("TOPLEFT", dropButton, "BOTTOMLEFT", 0, -6);
	dropMenu2:SetPoint("TOPRIGHT", -6, -4);
	dropMenu2:SetBackdrop(dropMenuBackdrop);
	dropMenu2:SetBackdropColor(dropMenuBackdropColor[1], dropMenuBackdropColor[2], dropMenuBackdropColor[3], dropMenuBackdropColor[4]);
	dropMenu2:SetScript("OnClick", function(self, button)
			self:Hide();
		end
	);
	dropMenu2:SetScript("OnEnter", function(self)
			self.isCountingDown = false;
			self.parent.isCountingDown = false;
		end
	);
	dropMenu2:SetScript("OnLeave", function(self)
			self.isCountingDown = true;
			self.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
			self.parent.isCountingDown = true;
			self.parent.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
		end
	);
	dropMenu2:SetScript("OnUpdate", function(self, elasped)
			if self:IsShown() and self.isCountingDown then
				self.countingDownTimer = self.countingDownTimer - elasped;
				if self.countingDownTimer <= 0 then
					self.isCountingDown = false;
					self:Hide();
				end
			end
		end
	);
	dropMenu2:SetScript("OnHide", function(self)
			self.isCountingDown = false;
		end
	);
	dropMenu2.mainFrame = mainFrame;
	dropMenu2.parent = dropMenu1
	dropButton.dropMenu2 = dropMenu2;
	mainFrame.dropMenu2 = dropMenu2;
	dropMenu1.child = dropMenu2;
	dropMenu2.buttons = {};

	local dropMenu3 = CreateFrame("Button", nil, dropMenu2);
	dropMenu3:SetClampedToScreen(true);
	dropMenu3:Hide();
	dropMenu3:SetPoint("TOPLEFT", dropButton, "BOTTOMLEFT", 0, -6);
	dropMenu3:SetPoint("TOPRIGHT", -6, -4);
	dropMenu3:SetBackdrop(dropMenuBackdrop);
	dropMenu3:SetBackdropColor(dropMenuBackdropColor[1], dropMenuBackdropColor[2], dropMenuBackdropColor[3], dropMenuBackdropColor[4]);
	dropMenu3:SetScript("OnClick", function(self, button)
			self:Hide();
		end
	);
	dropMenu3:SetScript("OnEnter", function(self)
			self.isCountingDown = false;
			self.parent.isCountingDown = false;
			self.parent.parent.isCountingDown = false;
		end
	);
	dropMenu3:SetScript("OnLeave", function(self)
			self.isCountingDown = true;
			self.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
			self.parent.isCountingDown = true;
			self.parent.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
			self.parent.parent.isCountingDown = true;
			self.parent.parent.countingDownTimer = COUNTING_DOWN_TIMER_PERIOD;
		end
	);
	dropMenu3:SetScript("OnUpdate", function(self, elasped)
			if self:IsShown() and self.isCountingDown then
				self.countingDownTimer = self.countingDownTimer - elasped;
				if self.countingDownTimer <= 0 then
					self.isCountingDown = false;
					self:Hide();
				end
			end
		end
	);
	dropMenu3:SetScript("OnHide", function(self)
			self.isCountingDown = false;
		end
	);
	dropMenu3.mainFrame = mainFrame;
	dropMenu3.parent = dropMenu2;
	dropButton.dropMenu3 = dropMenu3;
	mainFrame.dropMenu3 = dropMenu3;
	dropMenu2.child = dropMenu3;
	dropMenu3.buttons = {};

	local nextButton = CreateFrame("Button", nil, mainFrame);
	nextButton:SetSize(18, 18);
	nextButton:SetNormalTexture(artwork_path .. "Button-DoubleArrowRight-Normal");
	nextButton:SetPushedTexture(artwork_path .. "Button-DoubleArrowRight-Pushed");
	nextButton:SetHighlightTexture(artwork_path .. "Button-DoubleArrowRight-Highlight");
	nextButton:SetPoint("BOTTOMRIGHT", mainFrame, -6, 6);
	nextButton:SetText("QUEST");
	nextButton:SetScript("OnClick", nextButtonOnClick);
	nextButton.mainFrame = mainFrame;
	mainFrame.nextButton = nextButton;

	local prevButton = CreateFrame("Button", nil, mainFrame);
	prevButton:SetSize(18, 18);
	prevButton:SetNormalTexture(artwork_path .. "Button-DoubleArrowLeft-Normal");
	prevButton:SetPushedTexture(artwork_path .. "Button-DoubleArrowLeft-Pushed");
	prevButton:SetHighlightTexture(artwork_path .. "Button-DoubleArrowLeft-Highlight");
	prevButton:SetPoint("RIGHT", nextButton, "LEFT", -6, 0);
	prevButton:SetText("QUEST");
	prevButton:SetScript("OnClick", prevButtonOnClick);
	prevButton.mainFrame = mainFrame;
	mainFrame.prevButton = prevButton;

	local curTaskView = CreateFrame("Frame", nil, mainFrame);
	curTaskView:SetPoint("LEFT", dropButton, "RIGHT", 6, 0);
	curTaskView:SetPoint("RIGHT", prevButton, "LEFT", -6, 0);
	curTaskView:SetSize(curTaskViewW, curTaskViewH);
	curTaskView:EnableMouse(false);
	curTaskView:SetBackdrop(
		{
			bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile = nil;--"Interface\\Tooltips\\UI-Tooltip-Border",
			tile = true,
			tileSize = 2,
			edgeSize = 2,
			insets = { left = 2, right = 2, top = 2, bottom = 2 }
		}
	);
	curTaskView:SetBackdropColor(0.15, 0.15, 0.15, 0.9)
	--curTaskView:SetScript("OnSizeChanged", function()
	--end)
	curTaskView.mainFrame = mainFrame;
	mainFrame.curTaskView = curTaskView;

	local curTaskText = curTaskView:CreateFontString(sName, "ARTWORK", "GameFontNormalSmall")
	curTaskText:SetPoint("LEFT", curTaskView, 6, 0)
	curTaskText:SetTextColor(0.9, 0.9, 0.9, 0.9)
	curTaskText:SetJustifyH("LEFT")
	curTaskText:SetJustifyV("TOP")
	curTaskText.parent = curTaskView;
	curTaskView.curTaskText = curTaskText;
	mainFrame.curTaskText = curTaskText;

	

	return mainFrame, titleCurProgress, view, lockButton;

end


local function OnEvent(self, event)
end

local opentext = {
	[1] = {
		["find"] = "#GET#",
		["replace"] = "|c0000ffff"
	},
	[2] = {
		["find"] = "#DO#",
		["replace"] = "|c000079d2"
	},
	[3] = {
		["find"] = "#POST#",
		["replace"] = "|c0000ff00"
	},
	[4] = {
		["find"] = "#SKIP#", 
		["replace"] = "|c00a80000"
	},
	[5] = {
		["find"] = "#COORD#",
		["replace"] = "|c00ffff00"
	},
	[6] = {
		["find"] = "#NPC#",
		["replace"] = "|c00ff00ff"
	},
	[7] = {
		["find"] = "#ITEM#",
		["replace"] = "|c00fca742"
	},
	[8] = {
		["find"] = "#VIDEO#",
		["replace"] = "|c00ff0000"
	},
}

local function genSeqTable(T, title, L, seq)
	local t = {};
	for k, _ in pairs(T) do
		table.insert(t, k);
	end
	table.sort(t);
	local R = {};
	for k, v in ipairs(t) do
		R[k] = T[v];
	end

	for k1, v1 in ipairs(R) do
		for k2, v2 in ipairs(v1.items) do
			for n = 1, #opentext do
				R[k1].items[k2].str = gsub(R[k1].items[k2].str, opentext[n]["find"], opentext[n]["replace"]);
			end
			R[k1].items[k2].str = gsub(R[k1].items[k2].str, "#","|r");
			--PRINT(R[k1].items[k2].str);
		end
		R[k1].seq = seq;
	end

	R.title = title;
	R.L = L;
	
	return R;
end
local function setNextUUL(T, next)
	T[#T].nextUpperUpperLevel = next;
end
local function enableNextUL(T)
	T[#T].nextUpperLevelInc = true;
end
local function initData(factionGroup)
	local data = {};
	data[1] = Table_001_Introduction[0001];
	data[1].title = L[locale]["01"];
	data[2] = { title = L[locale]["02"], L = true };
	data[3] = { title = L[locale]["03"], L = true };
	if factionGroup == "Alliance" then
		data[2][1] = genSeqTable(Table_002_DunMorogh, L[locale]["A21"], true, true);
		data[2][2] = genSeqTable(Table_002_ElwynnForest, L[locale]["A22"], true, true);
		data[2][3] = genSeqTable(Table_002_Teldrassil, L[locale]["A23"], true, true);
		data[3][1] = genSeqTable(Table_003_Alliance_12to20, L[locale]["31"], true, true);
		data[3][2] = genSeqTable(Table_003_Alliance_20to30, L[locale]["32"], true, true);
		data[3][3] = genSeqTable(Table_003_Alliance_30to40, L[locale]["33"], true, true);
		data[3][4] = genSeqTable(Table_003_Alliance_40to50, L[locale]["34"], true, true);
		data[3][5] = genSeqTable(Table_003_Alliance_50to60, L[locale]["35"], true, true);
	else
		data[2][1] = genSeqTable(Table_002_Durotar, L[locale]["H21"], true, true);
		data[2][2] = genSeqTable(Table_002_Mulgore, L[locale]["H22"], true, true);
		data[2][3] = genSeqTable(Table_002_TirisfalGlades, L[locale]["H23"], true, true);
		data[3][1] = genSeqTable(Table_003_Horde_12to20, L[locale]["31"], true, true);
		data[3][2] = genSeqTable(Table_003_Horde_20to30, L[locale]["32"], true, true);
		data[3][3] = genSeqTable(Table_003_Horde_30to40, L[locale]["33"], true, true);
		data[3][4] = genSeqTable(Table_003_Horde_40to50, L[locale]["34"], true, true);
		data[3][5] = genSeqTable(Table_003_Horde_50to60, L[locale]["35"], true, true);
	end
	setNextUUL(data[2][1], 3);
	setNextUUL(data[2][2], 3);
	setNextUUL(data[2][3], 3);
	enableNextUL(data[3][1]);
	enableNextUL(data[3][2]);
	enableNextUL(data[3][3]);
	enableNextUL(data[3][4]);
	enableNextUL(data[3][5]);
	data[4] = genSeqTable(Table_004_Professions, L[locale]["04"], true, false);
	data[5] = { title = L[locale]["05"] };

	for k2, v2 in ipairs(data[1].items) do
		for n = 1, #opentext do
			data[1].items[k2].str = gsub(data[1].items[k2].str, opentext[n]["find"], opentext[n]["replace"])
		end
		data[1].items[k2].str = gsub(data[1].items[k2].str, "#","|r")
	end
	
	return data;
end

local playerName = nil;
local function Init(self, event)
	self:UnregisterEvent("PLAYER_ENTERING_WORLD");


	local pn = UnitName('player');
	local rn = GetRealmName();
	playerName = pn .. "-" .. rn;

	ClassicGuideSaved = ClassicGuideSaved or { default = { point = { "CENTER", "UIParent", "CENTER", 0, 0 } } };
	if not ClassicGuideSaved[playerName] then
		ClassicGuideSaved[playerName] = {};
		for k, v in pairs(ClassicGuideSaved["default"]) do
			ClassicGuideSaved[playerName][k] = v;
		end
	end

	setting = ClassicGuideSaved[playerName];
	default = ClassicGuideSaved["default"];
	
	setting.control_cur_L = setting.control_cur_L or 1;
	setting.control_cur_L1 = setting.control_cur_L1 or 1;
	setting.control_cur_L2 = setting.control_cur_L2 or 0;
	setting.control_cur_L3 = setting.control_cur_L3 or 0;
	setting.control_cur_I = setting.control_cur_I or 1;
	setting.mainFrameCurW = setting.mainFrameCurW or 360;
	setting.mainFrameCurH = setting.mainFrameCurH or 320;
	
	
	mainFrame, titleCurProgress, view, lockButton = createMainFrame();
	mainFrame.locale = GetLocale();
	mainFrame.factionGroup =  UnitFactionGroup('player');
	mainFrame.data = initData(mainFrame.factionGroup);

	mainFrame.viewText:SetText("TESTING")
	mainFrame.curTaskText:SetText("Current Mission")

	apply(mainFrame);
	setting.isLocked = not setting.isLocked;
	Lock(lockButton);

	F.mainFrame = mainFrame;

end
F:RegisterEvent("PLAYER_ENTERING_WORLD");
F:SetScript("OnEvent", Init);

function ClassicGuide_Toggle()
	if mainFrame:IsShown() then
		mainFrame:Hide();
	else
		mainFrame:Show();
	end
end
function ClassicGuide_PrevStep()
	if view:IsShown() then
		prevButtonOnClick(mainFrame.prevButton, "LeftButton");
	end
end
function ClassicGuide_NextStep()
	if view:IsShown() then
		nextButtonOnClick(mainFrame.nextButton, "LeftButton");
	end
end

