local E, L, V, P, G = unpack(select(2, ...)); --Import: Engine, Locales, PrivateDB, ProfileDB, GlobalDB
local oUF = E.oUF

-- Cache global variables
-- Lua functions
-- WoW API / Variables
local function Update(self)
	local element = self.ClassificationIndicator

	if (element.PreUpdate) then
		element:PreUpdate()
	end

	local classification = self.classification
	if classification == "elite" or classification == "worldboss" then
		element:SetAtlas("nameplates-icon-elite-gold")
		element:Show()
	elseif classification == "rareelite" or classification == 'rare' then
		element:SetAtlas("nameplates-icon-elite-silver")
		element:Show()
	else
		element:Hide()
	end

	if (element.PostUpdate) then
		return element:PostUpdate(classification)
	end
end

local function Path(self, ...)
	return (self.ClassificationIndicator.Override or Update) (self, ...)
end

local function ForceUpdate(element)
	return Path(element.__owner, 'ForceUpdate', element.__owner.unit)
end

local function Enable(self)
	local element = self.ClassificationIndicator
	if (element) then
		element.__owner = self
		element.ForceUpdate = ForceUpdate

		if (element:IsObjectType('Texture') and not element:GetTexture()) then
			element:SetTexture([[Interface\TARGETINGFRAME\Nameplates]])
		end

		self:UnregisterEvent("UNIT_CLASSIFICATION_CHANGED", Path)

		return true
	end
end

local function Disable(self)
	local element = self.ClassificationIndicator
	if (element) then
		element:Hide()
		self:UnregisterEvent("UNIT_CLASSIFICATION_CHANGED")
	end
end

oUF:AddElement('ClassificationIndicator', Path, Enable, Disable)
