<instrumentationManifest xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events" xmlns="http://schemas.microsoft.com/win/2004/08/events" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <instrumentation>
    <events>
      <provider name="NVFT-ETW" guid="{B37F4CA5-5507-42CF-B8C7-BABE280601D2}" symbol="ETW_PROVIDER_NVFT_GUID"
                resourceFileName="res" messageFileName="msg">

        <!-- These are GPU side wall _ clock times, and since GPU queries are double _ buffered, the starting point of reference is m_flSystemTimeInSeconds  -->
        <!-- of the previous frame.Generally speaking, this is equal to the current frame’s m_flSystemTimeInSeconds minus one vsync interval. -->
        <!-- All CPU side timers are from frame N, and all GPU side timers are from frame N – 1,  -->
        <!-- so you need to have two frame’s worth of data to calculate everything that you want. -->
        <!--                                                                                      -->
        <!--                                                                                      -->
        <!-- App render completion : m_flSystemTimeInSeconds(N) + m_flSceneRenderGpuMs(N + 1) -->
        <!-- Warp render completion : m_flSystemTimeInSeconds(N) + m_flTotalRenderGpuMs(N + 1) -->
        <!-- HMD Sample begin : This one I assume is CPU _ side time, so the time at which the app thread called WaitGetPoses is  -->
        <!-- m_flSystemTimeInSeconds(N) + m_flWaitGetPosesCalledMs(N) -->
        <!-- Available render headroom : vsync interval – flTotalRenderGpuMs(N + 1) -->
        <!--                                                                                      -->
        <!-- For example, this is two frames’ worth of counters : -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | FrameIndex | NumFramePresents | NumDroppedFrames | SystemTimeInSeconds | SceneRenderGpuM | TotalRenderGpuMs | CompositorRenderGpuMs | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | 2429       | 1                | 0                | 31.30377            | 7.70304         | 8.63264          | 0.563744              | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | 2430       | 1                | 0                | 31.31494            | 7.906336        | 8.8376           | 0.56112               | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!--                                                                                      -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | CompositorRenderCpuMs | CompositorIdleCpuMs | ClientFrameIntervalMs | PresentCallCpuMs | WaitForPresentCpuMs | WaitGetPosesCalledMs | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | 0.18885               | 7.890638            | 1.465346              | 0.040761         | 0.023166            | -12.7471             | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | 0.178                 | 7.927294            | 1.40611               | 0.031964         | 0.006451            | -12.8063             | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!--                                                                                      -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | SubmitFrameMs | NewPosesReadyMs | NewFrameReadyMs | CompositorUpdateStartMs | CompositorUpdateEndMs | CompositorRenderStartMs| -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | 0.005572      | -3.05122        | -1.87882        | -1.80141                | -1.79056              | -1.62077               | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!-- | 0.004985      | -3.03039        | -1.83894        | -1.76211                | -1.75067              | -1.58528               | -->
        <!-- _______________________________________________________________________________________________________________________________________ -->
        <!--                                                                                      -->
        <!--                                                                                      -->
        <!-- These are the values for frame index 2429 -->
        <!-- 0. App render completion : 31.30377secs + 7.906336ms -->
        <!-- 1  Warp render completion : 31.30377secs + 8.8376ms -->
        <!-- 2. HMD Sample begin : 31.30377secs - 12.7471ms -->
        <!-- 3. Available render headroom : 11.1ms – 8.8376ms -->
        <!-- 4. Vsyncs -->
        <!-- a.When GPU started rendering : 31.30377secs -->
        <!-- b.When image is sent to HMD : 31.31494secs -->
        <!-- c.When HMD flashes image and photons hit eye : 31.31494 + 11.1ms -->


        <templates>
          <template tid="tid_openvr_timings">
            <data name="ProcessID" inType="win:UInt32" outType="xs:unsignedInt"/>
            <data name="API version" inType="win:UInt32" outType="xs:unsignedInt"/>
            <data name="Frame index" inType="win:Double" outType="xs:double"/>
            <!-- VSync timestamp of frame start: when it's shown on HMD -->
            <data name="frameStart" inType="win:Double" outType="xs:double"/>

            <!-- 
                     
                      With openvr_api ver 005-010 some timings are not provided.
                      In this case provided values will be incorrect
                      All times in sec.
                      -->
            <data name="renderComplete" inType="win:Double" outType="xs:double"/>
            <data name="warpComplete" inType="win:Double" outType="xs:double"/>
            <data name="HMDSampleBegin" inType="win:Double" outType="xs:double"/>

            <!-- Time spent rendering the scene -->
            <data name="SceneRenderGpu" inType="win:Float" outType="xs:float"/>
            <!-- Time between work submitted immediately after present (ideally vsync) until the end of compositor submitted work -->
            <data name="TotalGPURenderTime" inType="win:Float" outType="xs:float"/>
            <!-- Time spend performing distortion correction, rendering chaperone, overlays, etc. -->
            <data name="CompositorRenderGpu" inType="win:Float" outType="xs:float"/>
            <!-- Time spent on cpu submitting the above work for this frame. -->
            <data name="CompositorRenderCpu" inType="win:Float" outType="xs:float"/>
            <!-- Time spent waiting for running start (application could have used this much more time). -->
            <data name="CompositorIdleCpu" inType="win:Float" outType="xs:float"/>
            <!-- Time between calls to WaitGetPoses. -->
            <data name="ClientFrameInterval" inType="win:Float" outType="xs:float"/>
            <!-- Time blocked on call to present (usually 0.0, but can go long). -->
            <data name="PresentCallCpu" inType="win:Float" outType="xs:float"/>
            <!-- Time spent spin-waiting for frame index to change (not near-zero indicates wait object failure). -->
            <data name="WaitForPresentCpu" inType="win:Float" outType="xs:float"/>
            <!-- Time spent in IVRCompositor::Submit (not near-zero indicates driver issue). -->
            <data name="SubmitFrame" inType="win:Float" outType="xs:float"/>

            <data name="NewPosesReady" inType="win:Double" outType="xs:double"/>
            <!--  Second call to IVRCompositor::Submit. -->
            <data name="NewFrameReady" inType="win:Double" outType="xs:double"/>
            <data name="CompositorUpdateStar" inType="win:Double" outType="xs:double"/>
            <data name="CompositorUpdateEnd" inType="win:Double" outType="xs:double"/>
            <data name="CompositorRenderStart" inType="win:Double" outType="xs:double"/>

            <!--  Number of additional times frame missed. -->
            <data name="Frame missed" inType="win:UInt32" outType="xs:unsignedInt"/>
            <!--  Number of times this frame was presented. -->
            <data name="FramePresents" inType="win:UInt32" outType="xs:unsignedInt"/>
          </template>
          <template tid="tid_oculus_timings">
            <data name="HmdVsyncIndex" inType="win:Int32" outType="xs:int"/>
            <data name="AppFrameIndex" inType="win:Int32" outType="xs:int"/>
            <data name="AppDroppedFrameCount" inType="win:Int32" outType="xs:int"/>
            <data name="AppMotionToPhotonLatency" inType="win:Float" outType="xs:float"/>
            <data name="AppQueueAheadTime" inType="win:Float" outType="xs:float"/>
            <data name="AppCpuElapsedTime" inType="win:Float" outType="xs:float"/>
            <data name="AppGpuElapsedTime" inType="win:Float" outType="xs:float"/>
            <data name="CompositorFrameIndex" inType="win:Int32" outType="xs:int"/>
            <data name="CompositorDroppedFrameCount" inType="win:Int32" outType="xs:int"/>
            <data name="CompositorLatency" inType="win:Float" outType="xs:float"/>
            <data name="CompositorCpuElapsedTime" inType="win:Float" outType="xs:float"/>
            <data name="CompositorGpuElapsedTime" inType="win:Float" outType="xs:float"/>
            <data name="CompositorCpuStartToGpuEndElapsedTime" inType="win:Float" outType="xs:float"/>
            <data name="CompositorGpuEndToVsyncElapsedTime" inType="win:Float" outType="xs:float"/>
            <data name="AswIsActive" inType="win:Int32" outType="xs:int"/>
            <data name="AswActivatedToggleCount" inType="win:Int32" outType="xs:int"/>
            <data name="AswPresentedFrameCount" inType="win:Int32" outType="xs:int"/>
            <data name="AswFailedFrameCount" inType="win:Int32" outType="xs:int"/>
          </template>
        </templates>
        <events>
          <event symbol="OpenVRTimings" value="0" version="0" channel="NVFT-ETW/Analytic" level="win:Verbose" task="Timings" opcode="Timings" template="tid_openvr_timings">
          </event>
          <event symbol="OculusTimings" value="1" version="0" channel="NVFT-ETW/Analytic" level="win:Verbose" task="Timings" opcode="Timings" template="tid_oculus_timings">
          </event>
        </events>
        <opcodes>
          <opcode name="Timings" symbol="Opcode_Timings" value="11">
          </opcode>
        </opcodes>
        <tasks>
          <task name="Timings" symbol="Task_Timings" value="1" eventGUID="{00000000-0000-0000-0000-000000000000}">
          </task>
        </tasks>
        <channels>
          <channel name="NVFT-ETW/Analytic" chid="NVFT-ETW/Analytic" symbol="Analytic" type="Analytic" enabled="false">
          </channel>
        </channels>
      </provider>
    </events>
  </instrumentation>
  <localization xmlns="http://schemas.microsoft.com/win/2004/08/events">
    <resources culture="en-US">
      <stringTable>
        <!-- NvFT Event Messages -->
        <string id="string.NVFT-ETW.event.message" value="OpenVR Timings Received" />
      </stringTable>
    </resources>
  </localization>
</instrumentationManifest>

