local AtlasLoot = _G.AtlasLoot
local Recipe = {}
AtlasLoot.Data.Recipe = Recipe
local Profession = AtlasLoot.Data.Profession
local AL = AtlasLoot.Locales

local format = string.format
local pairs = _G.pairs


local LOC_STRING = AL["|cff00ff00Left-Click:|r %s"]
local LOC_STRING2 = AL["|cff00ff00Left-Click:|r Show reagents."]
local RECIPE_PROF_DEFAULT = 0
local RECIPE_PROF_TEXT = Profession.PROFESSION_TEXT

local RECIPE = {
	-- [itemID] = { profession, profRank, creationSpell }
	[728] = 	{ 6,	75,  	2543 }, -- Recipe: Westfall Stew
	[2404] = 	{ 3,	30,  	2156 }, -- Deprecated Pattern: Light Winter Cloak
	[2405] = 	{ 3,	35,  	2157 }, -- Deprecated Pattern: Light Winter Boots
	[2406] = 	{ 3,	90,  	2158 }, -- Pattern: Fine Leather Boots
	[2407] = 	{ 3,	60,  	2163 }, -- Pattern: White Leather Jerkin
	[2408] = 	{ 3,	75,  	2164 }, -- Pattern: Fine Leather Gloves
	[2409] = 	{ 3,	100,  	2169 }, -- Pattern: Dark Leather Tunic
	[2553] = 	{ 4,	50,  	3230 }, -- Recipe: Elixir of Minor Agility
	[2554] = 	{ 4,	50,  	2334 }, -- Deprecated Recipe: Elixir of Fortitude
	[2555] = 	{ 4,	60,  	2335 }, -- Recipe: Swiftness Potion
	[2556] = 	{ 4,	70,  	2336 }, -- Recipe: Elixir of Tongues
	[2598] = 	{ 8,	40,  	2389 }, -- Pattern: Red Linen Robe
	[2601] = 	{ 8,	105,  	2403 }, -- Pattern: Gray Woolen Robe
	[2697] = 	{ 6,	50,  	2542 }, -- Recipe: Goretusk Liver Pie
	[2698] = 	{ 6,	85,  	2545 }, -- Recipe: Cooked Crab Claw
	[2699] = 	{ 6,	100,  	2547 }, -- Recipe: Redridge Goulash
	[2700] = 	{ 6,	110,  	2548 }, -- Recipe: Succulent Pork Ribs
	[2701] = 	{ 6,	100,  	2549 }, -- Recipe: Seasoned Wolf Kabob
	[2881] = 	{ 2,	80,  	2667 }, -- Plans: Runed Copper Breastplate
	[2882] = 	{ 2,	125,  	3330 }, -- Plans: Silvered Bronze Shoulders
	[2883] = 	{ 2,	125,  	3295 }, -- Plans: Deadly Bronze Poniard
	[2889] = 	{ 6,	25,  	2795 }, -- Recipe: Beer Basted Boar Ribs
	[3393] = 	{ 4,	110,  	3172 }, -- Recipe: Minor Magic Resistance Potion
	[3394] = 	{ 4,	120,  	3174 }, -- Recipe: Elixir of Poison Resistance
	[3395] = 	{ 4,	250,  	3175 }, -- Recipe: Limited Invulnerability Potion
	[3396] = 	{ 4,	140,  	2333 }, -- Recipe: Elixir of Lesser Agility
	[3608] = 	{ 2,	145,  	3297 }, -- Plans: Mighty Iron Hammer
	[3609] = 	{ 2,	35,  	3321 }, -- Plans: Copper Chain Vest
	[3610] = 	{ 2,	60,  	3325 }, -- Plans: Gemmed Copper Gauntlets
	[3611] = 	{ 2,	145,  	3334 }, -- Plans: Green Iron Boots
	[3612] = 	{ 2,	150,  	3336 }, -- Plans: Green Iron Gauntlets
	[3678] = 	{ 6,	80,  	3370 }, -- Recipe: Crocolisk Steak
	[3679] = 	{ 6,	60,  	3371 }, -- Recipe: Blood Sausage
	[3680] = 	{ 6,	90,  	3372 }, -- Recipe: Murloc Fin Soup
	[3681] = 	{ 6,	120,  	3373 }, -- Recipe: Crocolisk Gumbo
	[3682] = 	{ 6,	130,  	3376 }, -- Recipe: Curiously Tasty Omelet
	[3683] = 	{ 6,	110,  	3377 }, -- Recipe: Gooey Spider Cake
	[3734] = 	{ 6,	110,  	3397 }, -- Recipe: Big Bear Steak
	[3735] = 	{ 6,	125,  	3398 }, -- Recipe: Hot Lion Chops
	[3736] = 	{ 6,	150,  	3399 }, -- Recipe: Tasty Lion Steak
	[3737] = 	{ 6,	175,  	3400 }, -- Recipe: Soothing Turtle Bisque
	[3830] = 	{ 4,	175,  	3450 }, -- Recipe: Elixir of Fortitude
	[3831] = 	{ 4,	180,  	3451 }, -- Recipe: Mighty Troll's Blood Potion
	[3832] = 	{ 4,	195,  	3453 }, -- Recipe: Elixir of Detect Lesser Invisibility
	[3866] = 	{ 2,	175,  	3493 }, -- Plans: Jade Serpentblade
	[3867] = 	{ 2,	170,  	3495 }, -- Plans: Golden Iron Destroyer
	[3868] = 	{ 2,	200,  	3497 }, -- Plans: Frost Tiger Blade
	[3869] = 	{ 2,	200,  	3500 }, -- Plans: Shadow Crescent Axe
	[3870] = 	{ 2,	160,  	3504 }, -- Plans: Green Iron Shoulders
	[3871] = 	{ 2,	175,  	3505 }, -- Plans: Golden Scale Shoulders
	[3872] = 	{ 2,	170,  	3507 }, -- Plans: Golden Scale Leggings
	[3873] = 	{ 2,	195,  	3511 }, -- Plans: Golden Scale Cuirass
	[3874] = 	{ 2,	185,  	3513 }, -- Plans: Polished Steel Boots
	[3875] = 	{ 2,	200,  	3515 }, -- Plans: Golden Scale Boots
	[4292] = 	{ 8,	95,  	3758 }, -- Pattern: Green Woolen Bag
	[4293] = 	{ 3,	100,  	3762 }, -- Pattern: Hillman's Leather Vest
	[4294] = 	{ 3,	120,  	3767 }, -- Pattern: Hillman's Belt
	[4295] = 	{ 3,	125,  	7153 }, -- Pattern: Double-stitched Leather Gloves OLD
	[4296] = 	{ 3,	140,  	3769 }, -- Pattern: Dark Leather Shoulders
	[4297] = 	{ 3,	150,  	3771 }, -- Pattern: Barbaric Gloves
	[4298] = 	{ 3,	170,  	3775 }, -- Pattern: Guardian Belt
	[4299] = 	{ 3,	175,  	3773 }, -- Pattern: Guardian Armor
	[4300] = 	{ 3,	195,  	3777 }, -- Pattern: Guardian Leather Bracers
	[4301] = 	{ 3,	200,  	3779 }, -- Pattern: Barbaric Belt
	[4345] = 	{ 8,	95,  	3847 }, -- Pattern: Red Woolen Boots
	[4346] = 	{ 8,	100,  	3844 }, -- Pattern: Heavy Woolen Cloak
	[4347] = 	{ 8,	120,  	3849 }, -- Pattern: Reinforced Woolen Shoulders
	[4348] = 	{ 8,	125,  	3868 }, -- Pattern: Phoenix Gloves
	[4349] = 	{ 8,	125,  	3851 }, -- Pattern: Phoenix Pants
	[4350] = 	{ 8,	140,  	3856 }, -- Pattern: Spider Silk Slippers
	[4351] = 	{ 8,	170,  	3858 }, -- Pattern: Shadow Hood
	[4352] = 	{ 8,	175,  	3860 }, -- Pattern: Boots of the Enchanter
	[4353] = 	{ 8,	180,  	3863 }, -- Pattern: Spider Belt
	[4354] = 	{ 8,	185,  	3872 }, -- Pattern: Rich Purple Silk Shirt
	[4355] = 	{ 8,	200,  	3862 }, -- Pattern: Icy Cloak
	[4356] = 	{ 8,	200,  	3864 }, -- Pattern: Star Belt
	[4408] = 	{ 9,	75,  	3928 }, -- Schematic: Mechanical Squirrel
	[4409] = 	{ 9,	100,  	3933 }, -- Schematic: Small Seaforium Charge
	[4410] = 	{ 9,	120,  	3940 }, -- Schematic: Shadow Goggles
	[4411] = 	{ 9,	125,  	3944 }, -- Schematic: Flame Deflector
	[4412] = 	{ 9,	145,  	3954 }, -- Schematic: Moonsight Rifle
	[4413] = 	{ 9,	160,  	3959 }, -- Schematic: Discombobulator Ray
	[4414] = 	{ 9,	165,  	3960 }, -- Schematic: Portable Bronze Mortar
	[4415] = 	{ 9,	185,  	3966 }, -- Schematic: Craftsman's Monocle
	[4416] = 	{ 9,	195,  	3968 }, -- Schematic: Goblin Land Mine
	[4417] = 	{ 9,	200,  	3972 }, -- Schematic: Large Seaforium Charge
	[4597] = 	{ 4,	50,  	4508 }, -- Recipe: Discolored Healing Potion
	[4609] = 	{ 6,	175,  	4094 }, -- Recipe: Barbecued Buzzard Wing
	[4624] = 	{ 4,	215,  	4942 }, -- Recipe: Lesser Stoneshield Potion
	[5083] = 	{ 3,	40,  	5244 }, -- Pattern: Kodo Hide Bag
	[5482] = 	{ 6,	10,  	6412 }, -- Recipe: Kaldorei Spider Kabob
	[5483] = 	{ 6,	20,  	6413 }, -- Recipe: Scorpid Surprise
	[5484] = 	{ 6,	35,  	6414 }, -- Recipe: Roasted Kodo Meat
	[5485] = 	{ 6,	50,  	6415 }, -- Recipe: Fillet of Frenzy
	[5486] = 	{ 6,	50,  	6416 }, -- Recipe: Strider Stew
	[5487] = 	{ 6,	90,  	6417 }, -- Recipe: Dig Rat Stew
	[5488] = 	{ 6,	100,  	6418 }, -- Recipe: Crispy Lizard Tail
	[5489] = 	{ 6,	110,  	6419 }, -- Recipe: Lean Venison
	[5528] = 	{ 6,	90,  	6501 }, -- Recipe: Clam Chowder
	[5543] = 	{ 2,	140,  	6518 }, -- Plans: Iridescent Hammer
	[5577] = 	{ 2,	100,  	2671 }, -- Plans: Rough Bronze Bracers
	[5578] = 	{ 2,	130,  	2673 }, -- Plans: Silvered Bronze Breastplate
	[5640] = 	{ 4,	60,  	6617 }, -- Recipe: Rage Potion
	[5641] = 	{ 4,	125,  	6619 }, -- Recipe: Cowardly Flight Potion
	[5642] = 	{ 4,	150,  	6624 }, -- Recipe: Free Action Potion
	[5643] = 	{ 4,	175,  	6618 }, -- Recipe: Great Rage Potion
	[5771] = 	{ 8,	70,  	6686 }, -- Pattern: Red Linen Bag
	[5772] = 	{ 8,	115,  	6688 }, -- Pattern: Red Woolen Bag
	[5773] = 	{ 8,	150,  	6692 }, -- Pattern: Robes of Arcana
	[5774] = 	{ 8,	175,  	6693 }, -- Pattern: Green Silk Pack
	[5775] = 	{ 8,	185,  	6695 }, -- Pattern: Black Silk Pack
	[5786] = 	{ 3,	90,  	6702 }, -- Pattern: Murloc Scale Belt
	[5787] = 	{ 3,	95,  	6703 }, -- Pattern: Murloc Scale Breastplate
	[5788] = 	{ 3,	170,  	6704 }, -- Pattern: Thick Murloc Armor
	[5789] = 	{ 3,	190,  	6705 }, -- Pattern: Murloc Scale Bracers
	[5972] = 	{ 3,	105,  	7133 }, -- Pattern: Fine Leather Pants
	[5973] = 	{ 3,	170,  	7149 }, -- Pattern: Barbaric Leggings
	[5974] = 	{ 3,	185,  	7153 }, -- Pattern: Guardian Cloak
	[6039] = 	{ 6,	175,  	7213 }, -- Recipe: Giant Clam Scorcho
	[6044] = 	{ 2,	150,  	7221 }, -- Plans: Iron Shield Spike
	[6045] = 	{ 2,	165,  	7222 }, -- Plans: Iron Counterweight
	[6046] = 	{ 2,	190,  	7224 }, -- Plans: Steel Weapon Chain
	[6047] = 	{ 2,	190,  	3503 }, -- Plans: Golden Scale Coif
	[6053] = 	{ 4,	100,  	7255 }, -- Recipe: Holy Protection Potion
	[6054] = 	{ 4,	135,  	7256 }, -- Recipe: Shadow Protection Potion
	[6055] = 	{ 4,	165,  	7257 }, -- Recipe: Fire Protection Potion
	[6056] = 	{ 4,	190,  	7258 }, -- Recipe: Frost Protection Potion
	[6057] = 	{ 4,	190,  	7259 }, -- Recipe: Nature Protection Potion
	[6068] = 	{ 4,	165,  	3449 }, -- Recipe: Shadow Oil
	[6211] = 	{ 4,	150,  	3188 }, -- Recipe: Elixir of Ogre's Strength
	[6222] = 	{ 10,	60,  	7451 }, -- Formula: Imbue Chest - Minor Spirit
	[6270] = 	{ 8,	55,  	7630 }, -- Pattern: Blue Linen Vest
	[6271] = 	{ 8,	55,  	7629 }, -- Pattern: Red Linen Vest
	[6272] = 	{ 8,	70,  	7633 }, -- Pattern: Blue Linen Robe
	[6273] = 	{ 8,	90,  	7636 }, -- Pattern: Green Woolen Robe
	[6274] = 	{ 8,	100,  	7639 }, -- Pattern: Blue Overalls
	[6275] = 	{ 8,	115,  	7643 }, -- Pattern: Greater Adept's Robe
	[6325] = 	{ 6,	1,  	7751 }, -- Recipe: Brilliant Smallfish
	[6326] = 	{ 6,	1,  	7752 }, -- Recipe: Slitherskin Mackerel
	[6328] = 	{ 6,	50,  	7753 }, -- Recipe: Longjaw Mud Snapper
	[6329] = 	{ 6,	50,  	7754 }, -- Recipe: Loch Frenzy Delight
	[6330] = 	{ 6,	100,  	7755 }, -- Recipe: Bristle Whisker Catfish
	[6342] = 	{ 10,	20,  	7443 }, -- Formula: Enchant Chest - Minor Mana
	[6343] = 	{ 10,	60,  	7451 }, -- Formula: Imbue Chest - Spirit
	[6344] = 	{ 10,	60,  	7766 }, -- Formula: Enchant Bracer - Minor Spirit
	[6345] = 	{ 10,	90,  	7771 }, -- Formula: Imbue Cloak - Protection
	[6346] = 	{ 10,	80,  	7776 }, -- Formula: Enchant Chest - Lesser Mana
	[6347] = 	{ 10,	80,  	7782 }, -- Formula: Enchant Bracer - Minor Strength
	[6348] = 	{ 10,	90,  	7786 }, -- Formula: Enchant Weapon - Minor Beastslayer
	[6349] = 	{ 10,	100,  	7793 }, -- Formula: Enchant 2H Weapon - Lesser Intellect
	[6368] = 	{ 6,	50,  	7827 }, -- Recipe: Rainbow Fin Albacore
	[6369] = 	{ 6,	175,  	7828 }, -- Recipe: Rockscale Cod
	[6375] = 	{ 10,	120,  	7859 }, -- Formula: Enchant Bracer - Lesser Spirit
	[6376] = 	{ 10,	125,  	7863 }, -- Formula: Enchant Boots - Minor Stamina
	[6377] = 	{ 10,	125,  	7867 }, -- Formula: Enchant Boots - Minor Agility
	[6390] = 	{ 8,	120,  	7892 }, -- Pattern: Stylish Blue Shirt
	[6391] = 	{ 8,	120,  	7893 }, -- Pattern: Stylish Green Shirt
	[6401] = 	{ 8,	155,  	3870 }, -- Pattern: Dark Silk Shirt
	[6454] = 	{ 1,	130,  	7935 }, -- Manual: Strong Anti-Venom
	[6474] = 	{ 3,	90,  	7953 }, -- Pattern: Deviate Scale Cloak
	[6475] = 	{ 3,	105,  	7954 }, -- Pattern: Deviate Scale Gloves
	[6476] = 	{ 3,	115,  	7955 }, -- Pattern: Deviate Scale Belt
	[6661] = 	{ 6,	85,  	8238 }, -- Recipe: Savory Deviate Delight
	[6663] = 	{ 4,	90,  	8240 }, -- Recipe: Elixir of Giant Growth
	[6672] = 	{ 9,	185,  	8243 }, -- Schematic: Flash Bomb
	[6710] = 	{ 3,	90,  	8322 }, -- Pattern: Moonglow Vest
	[6716] = 	{ 9,	100,  	8339 }, -- Schematic: EZ-Thro Dynamite
	[6734] = 	{ 2,	70,  	8366 }, -- Plans: Ironforge Chain
	[6735] = 	{ 2,	100,  	8367 }, -- Plans: Ironforge Breastplate
	[6736] = 	{ 2,	140,  	8368 }, -- Plans: Ironforge Gauntlets
	[6891] = 	{ 6,	1,  	8604 }, -- Recipe: Herb Baked Egg
	[6892] = 	{ 6,	40,  	8607 }, -- Recipe: Smoked Bear Meat
	[7084] = 	{ 8,	190,  	8793 }, -- Pattern: Crimson Silk Shoulders
	[7085] = 	{ 8,	190,  	8795 }, -- Pattern: Azure Shoulders
	[7086] = 	{ 8,	195,  	8797 }, -- Pattern: Earthen Silk Belt
	[7087] = 	{ 8,	180,  	8789 }, -- Pattern: Crimson Silk Cloak
	[7088] = 	{ 8,	205,  	8802 }, -- Pattern: Crimson Silk Robe
	[7089] = 	{ 8,	175,  	8786 }, -- Pattern: Azure Silk Cloak
	[7090] = 	{ 8,	165,  	8784 }, -- Pattern: Green Silk Armor
	[7091] = 	{ 8,	150,  	8782 }, -- Pattern: Truefaith Gloves
	[7092] = 	{ 8,	145,  	8780 }, -- Pattern: Hands of Darkness
	[7093] = 	{ 8,	140,  	8778 }, -- Pattern: Boots of Darkness
	[7114] = 	{ 8,	145,  	3854 }, -- Pattern: Azure Silk Gloves
	[7192] = 	{ 9,	130,  	8895 }, -- Schematic: Goblin Rocket Boots
	[7288] = 	{ 3,	35,  	9064 }, -- Pattern: Rugged Leather Pants
	[7289] = 	{ 3,	100,  	9070 }, -- Pattern: Black Whelp Cloak
	[7290] = 	{ 3,	120,  	9072 }, -- Pattern: Red Whelp Gloves
	[7360] = 	{ 3,	120,  	3765 }, -- Pattern: Dark Leather Gloves
	[7361] = 	{ 3,	135,  	9146 }, -- Pattern: Herbalist's Gloves
	[7362] = 	{ 3,	135,  	9147 }, -- Pattern: Earthen Leather Shoulders
	[7363] = 	{ 3,	140,  	9148 }, -- Pattern: Pilferer's Gloves
	[7364] = 	{ 3,	145,  	9149 }, -- Pattern: Heavy Earthen Gloves
	[7449] = 	{ 3,	165,  	9195 }, -- Pattern: Dusky Leather Leggings
	[7450] = 	{ 3,	175,  	9197 }, -- Pattern: Green Whelp Armor
	[7451] = 	{ 3,	190,  	9202 }, -- Pattern: Green Whelp Bracers
	[7452] = 	{ 3,	200,  	9207 }, -- Pattern: Dusky Boots
	[7453] = 	{ 3,	200,  	9208 }, -- Pattern: Swift Boots
	[7560] = 	{ 9,	125,  	9269 }, -- Schematic: Gnomish Universal Remote
	[7561] = 	{ 9,	165,  	9273 }, -- Schematic: Goblin Jumper Cables
	[7613] = 	{ 3,	155,  	3772 }, -- Pattern: Green Leather Armor
	[7678] = 	{ 6,	60,  	9513 }, -- Recipe: Thistle Tea
	[7742] = 	{ 9,	200,  	3971 }, -- Schematic: Gnomish Cloaking Device
	[7975] = 	{ 2,	210,  	9933 }, -- Plans: Heavy Mithril Pants
	[7976] = 	{ 2,	215,  	9939 }, -- Plans: Mithril Shield Spike
	[7977] = 	{ 2,	220,  	9942 }, -- Plans: Mithril Scale Gloves
	[7978] = 	{ 2,	160,  	9811 }, -- Plans: Barbaric Iron Shoulders
	[7979] = 	{ 2,	160,  	9813 }, -- Plans: Barbaric Iron Breastplate
	[7980] = 	{ 2,	175,  	9814 }, -- Plans: Barbaric Iron Helm
	[7981] = 	{ 2,	180,  	9818 }, -- Plans: Barbaric Iron Boots
	[7982] = 	{ 2,	185,  	9820 }, -- Plans: Barbaric Iron Gloves
	[7983] = 	{ 2,	220,  	9945 }, -- Plans: Ornate Mithril Pants
	[7984] = 	{ 2,	220,  	9950 }, -- Plans: Ornate Mithril Gloves
	[7985] = 	{ 2,	225,  	9952 }, -- Plans: Ornate Mithril Shoulder
	[7986] = 	{ 2,	240,  	9972 }, -- Plans: Ornate Mithril Breastplate
	[7987] = 	{ 2,	245,  	9980 }, -- Plans: Ornate Mithril Helm
	[7988] = 	{ 2,	245,  	9979 }, -- Plans: Ornate Mithril Boots
	[7989] = 	{ 2,	235,  	9964 }, -- Plans: Mithril Spurs
	[7990] = 	{ 2,	245,  	9970 }, -- Plans: Heavy Mithril Helm
	[7991] = 	{ 2,	235,  	9966 }, -- Plans: Mithril Scale Shoulders
	[7992] = 	{ 2,	220,  	9995 }, -- Plans: Blue Glittering Axe
	[7993] = 	{ 2,	240,  	10005 }, -- Plans: Dazzling Mithril Rapier
	[7994] = 	{ 2,	230,  	9957 }, -- Plans: Orcish War Leggings
	[7995] = 	{ 2,	215,  	9937 }, -- Plans: Mithril Scale Bracers
	[8028] = 	{ 2,	245,  	10009 }, -- Plans: Runed Mithril Hammer
	[8029] = 	{ 2,	225,  	9997 }, -- Plans: Wicked Mithril Blade
	[8030] = 	{ 2,	255,  	10013 }, -- Plans: Ebon Shiv
	[8384] = 	{ 3,	200,  	10490 }, -- Pattern: Comfortable Leather Hat
	[8385] = 	{ 3,	205,  	10509 }, -- Pattern: Turtle Scale Gloves
	[8386] = 	{ 3,	215,  	10520 }, -- Pattern: Big Voodoo Robe
	[8387] = 	{ 3,	220,  	10531 }, -- Pattern: Big Voodoo Mask
	[8388] = 	{ 3,	230,  	10550 }, -- Pattern: Nightscape Cloak
	[8389] = 	{ 3,	240,  	10560 }, -- Pattern: Big Voodoo Pants
	[8390] = 	{ 3,	240,  	10562 }, -- Pattern: Big Voodoo Cloak
	[8395] = 	{ 3,	220,  	10525 }, -- Pattern: Tough Scorpid Breastplate
	[8397] = 	{ 3,	220,  	10533 }, -- Pattern: Tough Scorpid Bracers
	[8398] = 	{ 3,	225,  	10542 }, -- Pattern: Tough Scorpid Gloves
	[8399] = 	{ 3,	235,  	10554 }, -- Pattern: Tough Scorpid Boots
	[8400] = 	{ 3,	240,  	10564 }, -- Pattern: Tough Scorpid Shoulders
	[8401] = 	{ 3,	245,  	10568 }, -- Pattern: Tough Scorpid Leggings
	[8402] = 	{ 3,	250,  	10570 }, -- Pattern: Tough Scorpid Helm
	[8403] = 	{ 3,	220,  	10529 }, -- Pattern: Wild Leather Shoulders
	[8404] = 	{ 3,	225,  	10544 }, -- Pattern: Wild Leather Vest
	[8405] = 	{ 3,	225,  	10546 }, -- Pattern: Wild Leather Helmet
	[8406] = 	{ 3,	245,  	10566 }, -- Pattern: Wild Leather Boots
	[8407] = 	{ 3,	250,  	10572 }, -- Pattern: Wild Leather Leggings
	[8408] = 	{ 3,	250,  	10574 }, -- Pattern: Wild Leather Cloak
	[8409] = 	{ 3,	210,  	10516 }, -- Pattern: Nightscape Shoulders
	[8547] = 	{ 1,	250,  	10844 }, -- Formula: Powerful Smelling Salts
	[9293] = 	{ 4,	210,  	11453 }, -- Recipe: Magic Resistance Potion
	[9294] = 	{ 4,	225,  	11458 }, -- Recipe: Wildvine Potion
	[9295] = 	{ 4,	235,  	11464 }, -- Recipe: Invisibility Potion
	[9296] = 	{ 4,	240,  	11466 }, -- Recipe: Gift of Arthas
	[9297] = 	{ 4,	240,  	11468 }, -- Recipe: Elixir of Dream Vision
	[9298] = 	{ 4,	245,  	11472 }, -- Recipe: Elixir of Giants
	[9300] = 	{ 4,	250,  	11477 }, -- Recipe: Elixir of Demonslaying
	[9301] = 	{ 4,	250,  	11476 }, -- Recipe: Elixir of Shadow Power
	[9302] = 	{ 4,	245,  	11473 }, -- Recipe: Ghost Dye
	[9303] = 	{ 4,	225,  	11459 }, -- Recipe: Philosopher's Stone
	[9304] = 	{ 4,	225,  	11479 }, -- Recipe: Transmute Iron to Gold
	[9305] = 	{ 4,	225,  	11480 }, -- Recipe: Transmute Mithril to Truesilver
	[9367] = 	{ 2,	205,  	11643 }, -- Plans: Golden Scale Gauntlets
	[10300] = 	{ 8,	215,  	12056 }, -- Pattern: Red Mageweave Vest
	[10301] = 	{ 8,	215,  	12059 }, -- Pattern: White Bandit Mask
	[10302] = 	{ 8,	215,  	12060 }, -- Pattern: Red Mageweave Pants
	[10303] = 	{ 8,	220,  	12062 }, -- Pattern: Stormcloth Pants
	[10304] = 	{ 8,	220,  	12063 }, -- Pattern: Stormcloth Gloves
	[10311] = 	{ 8,	220,  	12064 }, -- Pattern: Orange Martial Shirt
	[10312] = 	{ 8,	225,  	12066 }, -- Pattern: Red Mageweave Gloves
	[10313] = 	{ 8,	225,  	12068 }, -- Pattern: Stormcloth Vest
	[10314] = 	{ 8,	230,  	12075 }, -- Pattern: Lavender Mageweave Shirt
	[10315] = 	{ 8,	235,  	12078 }, -- Pattern: Red Mageweave Shoulders
	[10316] = 	{ 8,	120,  	12047 }, -- Pattern: Colorful Kilt
	[10317] = 	{ 8,	235,  	12080 }, -- Pattern: Pink Mageweave Shirt
	[10318] = 	{ 8,	240,  	12081 }, -- Pattern: Admiral's Hat
	[10319] = 	{ 8,	240,  	12083 }, -- Pattern: Stormcloth Headband
	[10320] = 	{ 8,	240,  	12084 }, -- Pattern: Red Mageweave Headband
	[10321] = 	{ 8,	240,  	12085 }, -- Pattern: Tuxedo Shirt
	[10322] = 	{ 8,	245,  	12087 }, -- Pattern: Stormcloth Shoulders
	[10323] = 	{ 8,	245,  	12089 }, -- Pattern: Tuxedo Pants
	[10324] = 	{ 8,	250,  	12090 }, -- Pattern: Stormcloth Boots
	[10325] = 	{ 8,	250,  	12091 }, -- Pattern: White Wedding Dress
	[10326] = 	{ 8,	250,  	12093 }, -- Pattern: Tuxedo Jacket
	[10424] = 	{ 2,	155,  	12259 }, -- Plans: Silvered Bronze Leggings
	[10463] = 	{ 8,	245,  	12086 }, -- Pattern: Shadoweave Mask
	[10601] = 	{ 9,	175,  	12587 }, -- Schematic: Bright-Eye Goggles
	[10602] = 	{ 9,	210,  	12597 }, -- Schematic: Deadly Scope
	[10603] = 	{ 9,	220,  	12607 }, -- Schematic: Catseye Ultra Goggles
	[10604] = 	{ 9,	220,  	12614 }, -- Schematic: Mithril Heavy-bore Rifle
	[10605] = 	{ 9,	225,  	12615 }, -- Schematic: Spellpower Goggles Xtreme
	[10606] = 	{ 9,	225,  	12616 }, -- Schematic: Parachute Cloak
	[10607] = 	{ 9,	230,  	12617 }, -- Schematic: Deepdive Helmet
	[10608] = 	{ 9,	240,  	12620 }, -- Schematic: Sniper Scope
	[10609] = 	{ 9,	250,  	12624 }, -- Schematic: Mithril Mechanical Dragonling
	[10644] = 	{ 4,	210,  	11456 }, -- Recipe: Goblin Rocket Fuel
	[10713] = 	{ 2,	200,  	11454 }, -- Plans: Inlaid Mithril Cylinder
	[10728] = 	{ 8,	200,  	3873 }, -- Pattern: Black Swashbuckler's Shirt
	[10858] = 	{ 2,	155,  	3494 }, -- Plans: Solid Iron Maul
	[11038] = 	{ 10,	110,  	13380 }, -- Formula: Enchant 2H Weapon - Lesser Spirit
	[11039] = 	{ 10,	110,  	13419 }, -- Formula: Enchant Cloak - Minor Agility
	[11081] = 	{ 10,	115,  	13464 }, -- Formula: Enchant Shield - Lesser Protection
	[11098] = 	{ 10,	135,  	13522 }, -- Formula: Enchant Cloak - Lesser Shadow Resistance
	[11101] = 	{ 10,	140,  	13536 }, -- Formula: Enchant Bracer - Lesser Strength
	[11150] = 	{ 10,	145,  	13612 }, -- Formula: Enchant Gloves - Mining
	[11151] = 	{ 10,	145,  	13617 }, -- Formula: Enchant Gloves - Herbalism
	[11152] = 	{ 10,	145,  	13620 }, -- Formula: Enchant Gloves - Fishing
	[11163] = 	{ 10,	170,  	13646 }, -- Formula: Enchant Bracer - Lesser Deflection
	[11164] = 	{ 10,	175,  	13653 }, -- Formula: Enchant Weapon - Lesser Beastslayer
	[11165] = 	{ 10,	175,  	13655 }, -- Formula: Enchant Weapon - Lesser Elemental Slayer
	[11166] = 	{ 10,	200,  	13698 }, -- Formula: Enchant Gloves - Skinning
	[11167] = 	{ 10,	190,  	13687 }, -- Formula: Enchant Boots - Lesser Spirit
	[11168] = 	{ 10,	195,  	13689 }, -- Formula: Enchant Shield - Lesser Block
	[11202] = 	{ 10,	210,  	13817 }, -- Formula: Enchant Shield - Stamina
	[11203] = 	{ 10,	215,  	13841 }, -- Formula: Enchant Gloves - Advanced Mining
	[11204] = 	{ 10,	220,  	13846 }, -- Formula: Enchant Bracer - Greater Spirit
	[11205] = 	{ 10,	225,  	13868 }, -- Formula: Enchant Gloves - Advanced Herbalism
	[11206] = 	{ 10,	225,  	13882 }, -- Formula: Enchant Cloak - Lesser Agility
	[11207] = 	{ 10,	265,  	13898 }, -- Formula: Enchant Weapon - Fiery Weapon
	[11208] = 	{ 10,	230,  	13915 }, -- Formula: Enchant Weapon - Demonslaying
	[11223] = 	{ 10,	235,  	13931 }, -- Formula: Enchant Bracer - Deflection
	[11224] = 	{ 10,	235,  	13933 }, -- Formula: Enchant Shield - Frost Resistance
	[11225] = 	{ 10,	245,  	13945 }, -- Formula: Enchant Bracer - Greater Stamina
	[11226] = 	{ 10,	250,  	13947 }, -- Formula: Enchant Gloves - Riding Skill
	[11610] = 	{ 2,	265,  	15292 }, -- Plans: Dark Iron Pulverizer
	[11611] = 	{ 2,	275,  	15294 }, -- Plans: Dark Iron Sunderer
	[11612] = 	{ 2,	285,  	15296 }, -- Plans: Dark Iron Plate
	[11614] = 	{ 2,	270,  	15293 }, -- Plans: Dark Iron Mail
	[11615] = 	{ 2,	280,  	15295 }, -- Plans: Dark Iron Shoulders
	[11813] = 	{ 10,	265,  	15596 }, -- Formula: Smoking Heart of the Mountain
	[11827] = 	{ 9,	205,  	15633 }, -- Schematic: Lil' Smoky
	[11828] = 	{ 9,	205,  	15628 }, -- Schematic: Pet Bombling
	[12162] = 	{ 2,	160,  	3492 }, -- Plans: Hardened Iron Shortsword
	[12163] = 	{ 2,	180,  	3496 }, -- Plans: Moonsteel Broadsword
	[12164] = 	{ 2,	185,  	3498 }, -- Plans: Massive Iron Axe
	[12226] = 	{ 6,	1,  	15935 }, -- Recipe: Crispy Bat Wing
	[12227] = 	{ 6,	125,  	15853 }, -- Recipe: Lean Wolf Steak
	[12228] = 	{ 6,	175,  	15855 }, -- Recipe: Roast Raptor
	[12229] = 	{ 6,	175,  	15856 }, -- Recipe: Hot Wolf Ribs
	[12231] = 	{ 6,	175,  	15861 }, -- Recipe: Jungle Stew
	[12232] = 	{ 6,	175,  	15863 }, -- Recipe: Carrion Surprise
	[12233] = 	{ 6,	175,  	15865 }, -- Recipe: Mystery Stew
	[12239] = 	{ 6,	200,  	15906 }, -- Recipe: Dragonbreath Chili
	[12240] = 	{ 6,	200,  	15910 }, -- Recipe: Heavy Kodo Stew
	[12261] = 	{ 2,	190,  	15973 }, -- Plans: Searing Golden Blade
	[12682] = 	{ 2,	250,  	16642 }, -- Plans: Thorium Armor
	[12683] = 	{ 2,	250,  	16643 }, -- Plans: Thorium Belt
	[12684] = 	{ 2,	255,  	16644 }, -- Plans: Thorium Bracers
	[12685] = 	{ 2,	260,  	16645 }, -- Plans: Radiant Belt
	[12687] = 	{ 2,	265,  	16646 }, -- Plans: Imperial Plate Shoulders
	[12688] = 	{ 2,	265,  	16647 }, -- Plans: Imperial Plate Belt
	[12689] = 	{ 2,	270,  	16648 }, -- Plans: Radiant Breastplate
	[12690] = 	{ 2,	270,  	16649 }, -- Plans: Imperial Plate Bracers
	[12691] = 	{ 2,	270,  	16650 }, -- Plans: Wildthorn Mail
	[12692] = 	{ 2,	275,  	16651 }, -- Plans: Thorium Shield Spike
	[12693] = 	{ 2,	280,  	16652 }, -- Plans: Thorium Boots
	[12694] = 	{ 2,	280,  	16653 }, -- Plans: Thorium Helm
	[12695] = 	{ 2,	285,  	16654 }, -- Plans: Radiant Gloves
	[12696] = 	{ 2,	285,  	16667 }, -- Plans: Demon Forged Breastplate
	[12697] = 	{ 2,	290,  	16656 }, -- Plans: Radiant Boots
	[12698] = 	{ 2,	290,  	16660 }, -- Plans: Dawnbringer Shoulders
	[12699] = 	{ 2,	290,  	16655 }, -- Plans: Fiery Plate Gauntlets
	[12700] = 	{ 2,	295,  	16657 }, -- Plans: Imperial Plate Boots
	[12701] = 	{ 2,	295,  	16658 }, -- Plans: Imperial Plate Helm
	[12702] = 	{ 2,	295,  	16659 }, -- Plans: Radiant Circlet
	[12703] = 	{ 2,	295,  	16661 }, -- Plans: Storm Gauntlets
	[12704] = 	{ 2,	300,  	16662 }, -- Plans: Thorium Leggings
	[12705] = 	{ 2,	300,  	16663 }, -- Plans: Imperial Plate Chest
	[12706] = 	{ 2,	300,  	16664 }, -- Plans: Runic Plate Shoulders
	[12707] = 	{ 2,	300,  	16665 }, -- Plans: Runic Plate Boots
	[12711] = 	{ 2,	300,  	16724 }, -- Plans: Whitesoul Helm
	[12713] = 	{ 2,	300,  	16725 }, -- Plans: Radiant Leggings
	[12714] = 	{ 2,	300,  	16726 }, -- Plans: Runic Plate Helm
	[12715] = 	{ 2,	300,  	16730 }, -- Plans: Imperial Plate Leggings
	[12716] = 	{ 2,	300,  	16728 }, -- Plans: Helm of the Great Chief
	[12717] = 	{ 2,	300,  	16729 }, -- Plans: Lionheart Helm
	[12718] = 	{ 2,	300,  	16731 }, -- Plans: Runic Breastplate
	[12719] = 	{ 2,	300,  	16732 }, -- Plans: Runic Plate Leggings
	[12720] = 	{ 2,	300,  	16741 }, -- Plans: Stronghold Gauntlets
	[12725] = 	{ 2,	300,  	16742 }, -- Plans: Enchanted Thorium Helm
	[12726] = 	{ 2,	300,  	16744 }, -- Plans: Enchanted Thorium Leggings
	[12727] = 	{ 2,	300,  	16745 }, -- Plans: Enchanted Thorium Breastplate
	[12728] = 	{ 2,	300,  	16746 }, -- Plans: Invulnerable Mail
	[12816] = 	{ 2,	260,  	16960 }, -- Plans: Thorium Greatsword
	[12817] = 	{ 2,	270,  	16965 }, -- Plans: Bleakwood Hew
	[12818] = 	{ 2,	270,  	16967 }, -- Plans: Inlaid Thorium Hammer
	[12819] = 	{ 2,	275,  	16969 }, -- Plans: Ornate Thorium Handaxe
	[12821] = 	{ 2,	275,  	16970 }, -- Plans: Dawn's Edge
	[12823] = 	{ 2,	280,  	16971 }, -- Plans: Huge Thorium Battleaxe
	[12824] = 	{ 2,	280,  	16973 }, -- Plans: Enchanted Battlehammer
	[12825] = 	{ 2,	280,  	16978 }, -- Plans: Blazing Rapier
	[12826] = 	{ 2,	285,  	16980 }, -- Plans: Rune Edge
	[12827] = 	{ 2,	285,  	16983 }, -- Plans: Serenity
	[12828] = 	{ 2,	290,  	16984 }, -- Plans: Volcanic Hammer
	[12830] = 	{ 2,	290,  	16985 }, -- Plans: Corruption
	[12831] = 	{ 2,	300,  	16986 }, -- Plans: Blood Talon
	[12832] = 	{ 2,	300,  	16987 }, -- Plans: Darkspear
	[12833] = 	{ 2,	300,  	16988 }, -- Plans: Hammer of the Titans
	[12834] = 	{ 2,	300,  	16990 }, -- Plans: Arcanite Champion
	[12835] = 	{ 2,	300,  	16991 }, -- Plans: Annihilator
	[12836] = 	{ 2,	300,  	16992 }, -- Plans: Frostguard
	[12837] = 	{ 2,	300,  	16993 }, -- Plans: Masterwork Stormhammer
	[12838] = 	{ 2,	300,  	16994 }, -- Plans: Arcanite Reaper
	[12839] = 	{ 2,	300,  	16995 }, -- Plans: Heartseeker
	[12958] = 	{ 4,	275,  	17187 }, -- Recipe: Transmute Arcanite
	[13287] = 	{ 3,	165,  	4096 }, -- Pattern: Raptor Hide Harness
	[13288] = 	{ 3,	165,  	4097 }, -- Pattern: Raptor Hide Belt
	[13308] = 	{ 9,	155,  	3957 }, -- Schematic: Ice Deflector
	[13309] = 	{ 9,	120,  	3939 }, -- Schematic: Lovingly Crafted Boomstick
	[13310] = 	{ 9,	180,  	3979 }, -- Schematic: Accurate Scope
	[13311] = 	{ 9,	200,  	3969 }, -- Schematic: Mechanical Dragonling
	[13476] = 	{ 4,	255,  	17552 }, -- Recipe: Mighty Rage Potion
	[13477] = 	{ 4,	260,  	17553 }, -- Recipe: Superior Mana Potion
	[13478] = 	{ 4,	265,  	17554 }, -- Recipe: Elixir of Superior Defense
	[13479] = 	{ 4,	270,  	17555 }, -- Recipe: Elixir of the Sages
	[13480] = 	{ 4,	275,  	17556 }, -- Recipe: Major Healing Potion
	[13481] = 	{ 4,	275,  	17557 }, -- Recipe: Elixir of Brute Force
	[13482] = 	{ 4,	275,  	17559 }, -- Recipe: Transmute Air to Fire
	[13483] = 	{ 4,	275,  	17560 }, -- Recipe: Transmute Fire to Earth
	[13484] = 	{ 4,	275,  	17561 }, -- Recipe: Transmute Earth to Water
	[13485] = 	{ 4,	275,  	17562 }, -- Recipe: Transmute Water to Air
	[13486] = 	{ 4,	275,  	17563 }, -- Recipe: Transmute Undeath to Water
	[13487] = 	{ 4,	275,  	17564 }, -- Recipe: Transmute Water to Undeath
	[13488] = 	{ 4,	275,  	17565 }, -- Recipe: Transmute Life to Earth
	[13489] = 	{ 4,	275,  	17566 }, -- Recipe: Transmute Earth to Life
	[13490] = 	{ 4,	280,  	17570 }, -- Recipe: Greater Stoneshield Potion
	[13491] = 	{ 4,	280,  	17571 }, -- Recipe: Elixir of the Mongoose
	[13492] = 	{ 4,	285,  	17572 }, -- Recipe: Purification Potion
	[13493] = 	{ 4,	285,  	17573 }, -- Recipe: Greater Arcane Elixir
	[13494] = 	{ 4,	290,  	17574 }, -- Recipe: Greater Fire Protection Potion
	[13495] = 	{ 4,	290,  	17575 }, -- Recipe: Greater Frost Protection Potion
	[13496] = 	{ 4,	290,  	17576 }, -- Recipe: Greater Nature Protection Potion
	[13497] = 	{ 4,	290,  	17577 }, -- Recipe: Greater Arcane Protection Potion
	[13499] = 	{ 4,	290,  	17578 }, -- Recipe: Greater Shadow Protection Potion
	[13500] = 	{ 4,	290,  	17579 }, -- Recipe: Greater Holy Protection Potion
	[13501] = 	{ 4,	295,  	17580 }, -- Recipe: Major Mana Potion
	[13517] = 	{ 4,	300,  	17632 }, -- Recipe: Alchemists' Stone
	[13518] = 	{ 4,	300,  	17634 }, -- Recipe: Flask of Petrification
	[13519] = 	{ 4,	300,  	17635 }, -- Recipe: Flask of the Titans
	[13520] = 	{ 4,	300,  	17636 }, -- Recipe: Flask of Distilled Wisdom
	[13521] = 	{ 4,	300,  	17637 }, -- Recipe: Flask of Supreme Power
	[13522] = 	{ 4,	300,  	17638 }, -- Recipe: Flask of Chromatic Resistance
	[13939] = 	{ 6,	225,  	18238 }, -- Recipe: Spotted Yellowtail
	[13940] = 	{ 6,	225,  	18239 }, -- Recipe: Cooked Glossy Mightfish
	[13941] = 	{ 6,	225,  	18241 }, -- Recipe: Filet of Redgill
	[13942] = 	{ 6,	240,  	18240 }, -- Recipe: Grilled Squid
	[13943] = 	{ 6,	240,  	18242 }, -- Recipe: Hot Smoked Bass
	[13945] = 	{ 6,	250,  	18243 }, -- Recipe: Nightfin Soup
	[13946] = 	{ 6,	250,  	18244 }, -- Recipe: Poached Sunscale Salmon
	[13947] = 	{ 6,	275,  	18245 }, -- Recipe: Lobster Stew
	[13948] = 	{ 6,	275,  	18246 }, -- Recipe: Mightfish Steak
	[13949] = 	{ 6,	275,  	18247 }, -- Recipe: Baked Salmon
	[14466] = 	{ 8,	255,  	18403 }, -- Pattern: Frostweave Tunic
	[14467] = 	{ 8,	255,  	18404 }, -- Pattern: Frostweave Robe
	[14468] = 	{ 8,	260,  	18405 }, -- Pattern: Runecloth Bag
	[14469] = 	{ 8,	260,  	18406 }, -- Pattern: Runecloth Robe
	[14470] = 	{ 8,	260,  	18407 }, -- Pattern: Runecloth Tunic
	[14471] = 	{ 8,	260,  	18408 }, -- Pattern: Cindercloth Vest
	[14472] = 	{ 8,	265,  	18409 }, -- Pattern: Runecloth Cloak
	[14473] = 	{ 8,	265,  	18410 }, -- Pattern: Ghostweave Belt
	[14474] = 	{ 8,	265,  	18411 }, -- Pattern: Frostweave Gloves
	[14476] = 	{ 8,	270,  	18412 }, -- Pattern: Cindercloth Gloves
	[14477] = 	{ 8,	270,  	18413 }, -- Pattern: Ghostweave Gloves
	[14478] = 	{ 8,	270,  	18414 }, -- Pattern: Brightcloth Robe
	[14479] = 	{ 8,	270,  	18415 }, -- Pattern: Brightcloth Gloves
	[14480] = 	{ 8,	275,  	18416 }, -- Pattern: Ghostweave Vest
	[14481] = 	{ 8,	275,  	18417 }, -- Pattern: Runecloth Gloves
	[14482] = 	{ 8,	275,  	18418 }, -- Pattern: Cindercloth Cloak
	[14483] = 	{ 8,	275,  	18419 }, -- Pattern: Felcloth Pants
	[14484] = 	{ 8,	275,  	18420 }, -- Pattern: Brightcloth Cloak
	[14485] = 	{ 8,	275,  	18421 }, -- Pattern: Wizardweave Leggings
	[14486] = 	{ 8,	275,  	18422 }, -- Pattern: Cloak of Fire
	[14488] = 	{ 8,	280,  	18423 }, -- Pattern: Runecloth Boots
	[14489] = 	{ 8,	280,  	18424 }, -- Pattern: Frostweave Pants
	[14490] = 	{ 8,	280,  	18434 }, -- Pattern: Cindercloth Pants
	[14491] = 	{ 8,	285,  	18438 }, -- Pattern: Runecloth Pants
	[14492] = 	{ 8,	285,  	18437 }, -- Pattern: Felcloth Boots
	[14493] = 	{ 8,	285,  	18436 }, -- Pattern: Robe of Winter Night
	[14494] = 	{ 8,	290,  	18439 }, -- Pattern: Brightcloth Pants
	[14495] = 	{ 8,	290,  	18441 }, -- Pattern: Ghostweave Pants
	[14496] = 	{ 8,	290,  	18442 }, -- Pattern: Felcloth Hood
	[14497] = 	{ 8,	290,  	18440 }, -- Pattern: Mooncloth Leggings
	[14498] = 	{ 8,	295,  	18444 }, -- Pattern: Runecloth Headband
	[14499] = 	{ 8,	300,  	18445 }, -- Pattern: Mooncloth Bag
	[14500] = 	{ 8,	300,  	18446 }, -- Pattern: Wizardweave Robe
	[14501] = 	{ 8,	300,  	18447 }, -- Pattern: Mooncloth Vest
	[14504] = 	{ 8,	300,  	18449 }, -- Pattern: Runecloth Shoulders
	[14505] = 	{ 8,	300,  	18450 }, -- Pattern: Wizardweave Turban
	[14506] = 	{ 8,	300,  	18451 }, -- Pattern: Felcloth Robe
	[14507] = 	{ 8,	300,  	18448 }, -- Pattern: Mooncloth Shoulders
	[14508] = 	{ 8,	300,  	18453 }, -- Pattern: Felcloth Shoulders
	[14509] = 	{ 8,	300,  	18452 }, -- Pattern: Mooncloth Circlet
	[14510] = 	{ 8,	300,  	18455 }, -- Pattern: Bottomless Bag
	[14511] = 	{ 8,	300,  	18454 }, -- Pattern: Gloves of Spell Mastery
	[14512] = 	{ 8,	300,  	18456 }, -- Pattern: Truefaith Vestments
	[14513] = 	{ 8,	300,  	18457 }, -- Pattern: Robe of the Archmage
	[14514] = 	{ 8,	300,  	18458 }, -- Pattern: Robe of the Void
	[14526] = 	{ 8,	250,  	18560 }, -- Pattern: Mooncloth
	[14627] = 	{ 8,	135,  	3869 }, -- Pattern: Bright Yellow Shirt
	[14630] = 	{ 8,	165,  	3857 }, -- Pattern: Enchanter's Cowl
	[14634] = 	{ 4,	200,  	3454 }, -- Recipe: Frost Oil
	[14635] = 	{ 3,	185,  	3778 }, -- Pattern: Gem-studded Leather Belt
	[14639] = 	{ 9,	140,  	3952 }, -- Schematic: Minor Recombobulator
	[15724] = 	{ 3,	255,  	19048 }, -- Pattern: Heavy Scorpid Bracers
	[15725] = 	{ 3,	260,  	19049 }, -- Pattern: Wicked Leather Gauntlets
	[15726] = 	{ 3,	260,  	19050 }, -- Pattern: Green Dragonscale Breastplate
	[15727] = 	{ 3,	265,  	19051 }, -- Pattern: Heavy Scorpid Vest
	[15728] = 	{ 3,	265,  	19052 }, -- Pattern: Wicked Leather Bracers
	[15729] = 	{ 3,	265,  	19053 }, -- Pattern: Chimeric Gloves
	[15730] = 	{ 3,	300,  	19054 }, -- Pattern: Red Dragonscale Breastplate
	[15731] = 	{ 3,	270,  	19055 }, -- Pattern: Runic Leather Gauntlets
	[15732] = 	{ 3,	270,  	19059 }, -- Pattern: Volcanic Leggings
	[15733] = 	{ 3,	270,  	19060 }, -- Pattern: Green Dragonscale Leggings
	[15734] = 	{ 3,	270,  	19061 }, -- Pattern: Living Shoulders
	[15735] = 	{ 3,	270,  	19062 }, -- Pattern: Ironfeather Shoulders
	[15737] = 	{ 3,	275,  	19063 }, -- Pattern: Chimeric Boots
	[15738] = 	{ 3,	275,  	19064 }, -- Pattern: Heavy Scorpid Gauntlets
	[15739] = 	{ 3,	275,  	19065 }, -- Pattern: Runic Leather Bracers
	[15740] = 	{ 3,	275,  	19066 }, -- Pattern: Frostsaber Boots
	[15741] = 	{ 3,	275,  	19067 }, -- Pattern: Stormshroud Pants
	[15742] = 	{ 3,	275,  	19068 }, -- Pattern: Warbear Harness
	[15743] = 	{ 3,	280,  	19070 }, -- Pattern: Heavy Scorpid Belt
	[15744] = 	{ 3,	280,  	19071 }, -- Pattern: Wicked Leather Headband
	[15745] = 	{ 3,	280,  	19072 }, -- Pattern: Runic Leather Belt
	[15746] = 	{ 3,	280,  	19073 }, -- Pattern: Chimeric Leggings
	[15747] = 	{ 3,	285,  	19074 }, -- Pattern: Frostsaber Leggings
	[15748] = 	{ 3,	285,  	19075 }, -- Pattern: Heavy Scorpid Leggings
	[15749] = 	{ 3,	285,  	19076 }, -- Pattern: Volcanic Breastplate
	[15751] = 	{ 3,	285,  	19077 }, -- Pattern: Blue Dragonscale Breastplate
	[15752] = 	{ 3,	285,  	19078 }, -- Pattern: Living Leggings
	[15753] = 	{ 3,	285,  	19079 }, -- Pattern: Stormshroud Armor
	[15754] = 	{ 3,	285,  	19080 }, -- Pattern: Warbear Woolies
	[15755] = 	{ 3,	290,  	19081 }, -- Pattern: Chimeric Vest
	[15756] = 	{ 3,	290,  	19082 }, -- Pattern: Runic Leather Headband
	[15757] = 	{ 3,	290,  	19083 }, -- Pattern: Wicked Leather Pants
	[15758] = 	{ 3,	290,  	19084 }, -- Pattern: Devilsaur Gauntlets
	[15759] = 	{ 3,	290,  	19085 }, -- Pattern: Black Dragonscale Breastplate
	[15760] = 	{ 3,	290,  	19086 }, -- Pattern: Ironfeather Breastplate
	[15761] = 	{ 3,	295,  	19087 }, -- Pattern: Frostsaber Gloves
	[15762] = 	{ 3,	295,  	19088 }, -- Pattern: Heavy Scorpid Helm
	[15763] = 	{ 3,	295,  	19089 }, -- Pattern: Blue Dragonscale Shoulders
	[15764] = 	{ 3,	295,  	19090 }, -- Pattern: Stormshroud Shoulders
	[15765] = 	{ 3,	300,  	19091 }, -- Pattern: Runic Leather Pants
	[15768] = 	{ 3,	300,  	19092 }, -- Pattern: Wicked Leather Belt
	[15769] = 	{ 3,	300,  	19093 }, -- Pattern: Onyxia Scale Cloak
	[15770] = 	{ 3,	300,  	19094 }, -- Pattern: Black Dragonscale Shoulders
	[15771] = 	{ 3,	300,  	19095 }, -- Pattern: Living Breastplate
	[15772] = 	{ 3,	300,  	19097 }, -- Pattern: Devilsaur Leggings
	[15773] = 	{ 3,	300,  	19098 }, -- Pattern: Wicked Leather Armor
	[15774] = 	{ 3,	300,  	19100 }, -- Pattern: Heavy Scorpid Shoulders
	[15775] = 	{ 3,	300,  	19101 }, -- Pattern: Volcanic Shoulders
	[15776] = 	{ 3,	300,  	19102 }, -- Pattern: Runic Leather Armor
	[15777] = 	{ 3,	300,  	19103 }, -- Pattern: Runic Leather Shoulders
	[15779] = 	{ 3,	300,  	19104 }, -- Pattern: Frostsaber Tunic
	[15780] = 	{ 3,	300,  	19106 }, -- Pattern: Onyxia Scale Breastplate
	[15781] = 	{ 3,	300,  	19107 }, -- Pattern: Black Dragonscale Leggings
	[16041] = 	{ 9,	260,  	19790 }, -- Schematic: Thorium Grenade
	[16042] = 	{ 9,	260,  	19791 }, -- Schematic: Thorium Widget
	[16043] = 	{ 9,	260,  	19792 }, -- Schematic: Thorium Rifle
	[16044] = 	{ 9,	265,  	19793 }, -- Schematic: Lifelike Mechanical Toad
	[16045] = 	{ 9,	270,  	19794 }, -- Schematic: Spellpower Goggles Xtreme Plus
	[16046] = 	{ 9,	275,  	19814 }, -- Schematic: Masterwork Target Dummy
	[16047] = 	{ 9,	275,  	19795 }, -- Schematic: Thorium Tube
	[16048] = 	{ 9,	275,  	19796 }, -- Schematic: Dark Iron Rifle
	[16049] = 	{ 9,	285,  	19799 }, -- Schematic: Dark Iron Bomb
	[16050] = 	{ 9,	285,  	19815 }, -- Schematic: Delicate Arcanite Converter
	[16051] = 	{ 9,	285,  	19800 }, -- Schematic: Thorium Shells
	[16052] = 	{ 9,	290,  	19819 }, -- Schematic: Voice Amplification Modulator
	[16053] = 	{ 9,	290,  	19825 }, -- Schematic: Master Engineer's Goggles
	[16054] = 	{ 9,	300,  	19830 }, -- Schematic: Arcanite Dragonling
	[16055] = 	{ 9,	300,  	19831 }, -- Schematic: Arcane Bomb
	[16056] = 	{ 9,	300,  	19833 }, -- Schematic: Flawless Arcanite Rifle
	[16110] = 	{ 6,	225,  	15933 }, -- Recipe: Monster Omelet
	[16111] = 	{ 6,	225,  	15915 }, -- Recipe: Spiced Chili Crab
	[16112] = 	{ 1,	180,  	7929 }, -- Manual: Heavy Silk Bandage
	[16113] = 	{ 1,	210,  	10840 }, -- Manual: Mageweave Bandage
	[16214] = 	{ 10,	255,  	20008 }, -- Formula: Enchant Bracer - Greater Intellect
	[16215] = 	{ 10,	260,  	20020 }, -- Formula: Enchant Boots - Greater Stamina
	[16216] = 	{ 10,	265,  	20014 }, -- Formula: Enchant Cloak - Greater Resistance
	[16217] = 	{ 10,	265,  	20017 }, -- Formula: Enchant Shield - Greater Stamina
	[16218] = 	{ 10,	270,  	20009 }, -- Formula: Enchant Bracer - Superior Spirit
	[16219] = 	{ 10,	270,  	20012 }, -- Formula: Enchant Gloves - Greater Agility
	[16220] = 	{ 10,	275,  	20024 }, -- Formula: Enchant Boots - Spirit
	[16221] = 	{ 10,	275,  	20026 }, -- Formula: Enchant Chest - Major Health
	[16222] = 	{ 10,	280,  	20016 }, -- Formula: Enchant Shield - Superior Spirit
	[16223] = 	{ 10,	285,  	20029 }, -- Formula: Enchant Weapon - Icy Chill
	[16224] = 	{ 10,	285,  	20015 }, -- Formula: Enchant Cloak - Superior Defense
	[16242] = 	{ 10,	290,  	20028 }, -- Formula: Enchant Chest - Major Mana
	[16243] = 	{ 10,	290,  	20051 }, -- Formula: Runed Arcanite Rod
	[16244] = 	{ 10,	295,  	20013 }, -- Formula: Enchant Gloves - Greater Strength
	[16245] = 	{ 10,	295,  	20023 }, -- Formula: Enchant Boots - Greater Agility
	[16246] = 	{ 10,	295,  	20010 }, -- Formula: Enchant Bracer - Superior Strength
	[16247] = 	{ 10,	295,  	20030 }, -- Formula: Enchant 2H Weapon - Superior Impact
	[16248] = 	{ 10,	295,  	20033 }, -- Formula: Enchant Weapon - Unholy
	[16249] = 	{ 10,	300,  	20036 }, -- Formula: Enchant 2H Weapon - Major Intellect
	[16250] = 	{ 10,	300,  	20031 }, -- Formula: Enchant Weapon - Superior Striking
	[16251] = 	{ 10,	300,  	20011 }, -- Formula: Enchant Bracer - Superior Stamina
	[16252] = 	{ 10,	300,  	20034 }, -- Formula: Enchant Weapon - Crusader
	[16253] = 	{ 10,	300,  	20025 }, -- Formula: Enchant Chest - Greater Stats
	[16254] = 	{ 10,	300,  	20032 }, -- Formula: Enchant Weapon - Lifestealing
	[16255] = 	{ 10,	300,  	20035 }, -- Formula: Enchant 2H Weapon - Major Spirit
	[16767] = 	{ 6,	225,  	20626 }, -- Recipe: Undermine Clam Chowder
	[17017] = 	{ 8,	300,  	20848 }, -- Pattern: Flarecore Mantle
	[17018] = 	{ 8,	300,  	20849 }, -- Pattern: Flarecore Gloves
	[17022] = 	{ 3,	295,  	20853 }, -- Pattern: Corehound Boots
	[17023] = 	{ 3,	300,  	20854 }, -- Pattern: Molten Helm
	[17025] = 	{ 3,	300,  	20855 }, -- Pattern: Black Dragonscale Boots
	[17049] = 	{ 2,	295,  	20872 }, -- Plans: Fiery Chain Girdle
	[17051] = 	{ 2,	295,  	20874 }, -- Plans: Dark Iron Bracers
	[17052] = 	{ 2,	300,  	20876 }, -- Plans: Dark Iron Leggings
	[17053] = 	{ 2,	300,  	20873 }, -- Plans: Fiery Chain Shoulders
	[17059] = 	{ 2,	300,  	20890 }, -- Plans: Dark Iron Reaver
	[17060] = 	{ 2,	300,  	20897 }, -- Plans: Dark Iron Destroyer
	[17062] = 	{ 6,	175,  	20916 }, -- Recipe: Mithril Head Trout
	[17200] = 	{ 6,	1,  	21143 }, -- Recipe: Gingerbread Cookie
	[17201] = 	{ 6,	35,  	21144 }, -- Recipe: Egg Nog
	[17706] = 	{ 2,	190,  	21913 }, -- Plans: Edge of Winter
	[17709] = 	{ 4,	190,  	21923 }, -- Recipe: Elixir of Frost Power
	[17720] = 	{ 9,	190,  	21940 }, -- Schematic: Snowmaster 9000
	[17722] = 	{ 3,	190,  	21943 }, -- Pattern: Gloves of the Greatfather
	[17724] = 	{ 8,	190,  	21945 }, -- Pattern: Green Holiday Shirt
	[17725] = 	{ 10,	190,  	21931 }, -- Formula: Enchant Weapon - Winter's Might
	[18046] = 	{ 6,	225,  	22480 }, -- Recipe: Tender Wolf Steak
	[18160] = 	{ 6,	60,  	9513 }, -- Recipe: Thistle Tea
	[18235] = 	{ 9,	300,  	22704 }, -- Schematic: Field Repair Bot 74A
	[18239] = 	{ 3,	200,  	22711 }, -- Pattern: Shadowskin Gloves
	[18252] = 	{ 3,	300,  	22727 }, -- Pattern: Core Armor Kit
	[18257] = 	{ 4,	300,  	22732 }, -- Recipe: Major Rejuvenation Potion
	[18259] = 	{ 10,	300,  	22749 }, -- Formula: Enchant Weapon - Spell Power
	[18260] = 	{ 10,	300,  	22750 }, -- Formula: Enchant Weapon - Healing Power
	[18264] = 	{ 2,	300,  	22757 }, -- Plans: Elemental Sharpening Stone
	[18265] = 	{ 8,	300,  	22759 }, -- Pattern: Flarecore Wraps
	[18267] = 	{ 6,	275,  	22761 }, -- Recipe: Runn Tum Tuber Surprise
	[18290] = 	{ 9,	300,  	22793 }, -- Schematic: Biznicks 247x128 Accurascope
	[18291] = 	{ 9,	300,  	22797 }, -- Schematic: Force Reactive Disk
	[18292] = 	{ 9,	300,  	22795 }, -- Schematic: Core Marksman Rifle
	[18414] = 	{ 8,	300,  	22866 }, -- Pattern: Belt of the Archmage
	[18415] = 	{ 8,	300,  	22867 }, -- Pattern: Felcloth Gloves
	[18416] = 	{ 8,	300,  	22868 }, -- Pattern: Inferno Gloves
	[18417] = 	{ 8,	300,  	22869 }, -- Pattern: Mooncloth Gloves
	[18418] = 	{ 8,	300,  	22870 }, -- Pattern: Cloak of Warding
	[18487] = 	{ 8,	300,  	22902 }, -- Pattern: Mooncloth Robe
	[18514] = 	{ 3,	300,  	22921 }, -- Pattern: Girdle of Insight
	[18515] = 	{ 3,	300,  	22922 }, -- Pattern: Mongoose Boots
	[18516] = 	{ 3,	300,  	22923 }, -- Pattern: Swift Flight Bracers
	[18517] = 	{ 3,	300,  	22926 }, -- Pattern: Chromatic Cloak
	[18518] = 	{ 3,	300,  	22927 }, -- Pattern: Hide of the Wild
	[18519] = 	{ 3,	300,  	22928 }, -- Pattern: Shifting Cloak
	[18592] = 	{ 2,	300,  	21161 }, -- Plans: Sulfuron Hammer
	[18647] = 	{ 9,	150,  	23066 }, -- Schematic: Red Firework
	[18648] = 	{ 9,	150,  	23068 }, -- Schematic: Green Firework
	[18649] = 	{ 9,	150,  	23067 }, -- Schematic: Blue Firework
	[18650] = 	{ 9,	200,  	23069 }, -- Schematic: EZ-Thro Dynamite II
	[18651] = 	{ 9,	260,  	23071 }, -- Schematic: Truesilver Transformer
	[18652] = 	{ 9,	260,  	23077 }, -- Schematic: Gyrofreeze Ice Reflector
	[18653] = 	{ 9,	265,  	23078 }, -- Schematic: Goblin Jumper Cables XL
	[18654] = 	{ 9,	265,  	23096 }, -- Schematic: Gnomish Alarm-O-Bot
	[18655] = 	{ 9,	275,  	23079 }, -- Schematic: Major Recombobulator
	[18656] = 	{ 9,	275,  	23080 }, -- Schematic: Powerful Seaforium Charge
	[18657] = 	{ 9,	290,  	23081 }, -- Schematic: Hyper-Radiant Flame Reflector
	[18658] = 	{ 9,	300,  	23082 }, -- Schematic: Ultra-Flash Shadow Reflector
	[18661] = 	{ 9,	260,  	23129 }, -- Schematic: World Enlarger
	[18731] = 	{ 3,	150,  	23190 }, -- Pattern: Heavy Leather Ball
	[18949] = 	{ 3,	155,  	23399 }, -- Pattern: Barbaric Bracers
	[19027] = 	{ 9,	250,  	23507 }, -- Schematic: Snake Burst Firework
	[19202] = 	{ 2,	290,  	23628 }, -- Plans: Heavy Timbermaw Belt
	[19203] = 	{ 2,	290,  	23632 }, -- Plans: Girdle of the Dawn
	[19204] = 	{ 2,	300,  	23629 }, -- Plans: Heavy Timbermaw Boots
	[19205] = 	{ 2,	300,  	23633 }, -- Plans: Gloves of the Dawn
	[19206] = 	{ 2,	300,  	23636 }, -- Plans: Dark Iron Helm
	[19207] = 	{ 2,	300,  	23637 }, -- Plans: Dark Iron Gauntlets
	[19208] = 	{ 2,	300,  	23638 }, -- Plans: Black Amnesty
	[19209] = 	{ 2,	300,  	23639 }, -- Plans: Blackfury
	[19210] = 	{ 2,	300,  	23650 }, -- Plans: Ebon Hand
	[19211] = 	{ 2,	300,  	23652 }, -- Plans: Blackguard
	[19212] = 	{ 2,	300,  	23653 }, -- Plans: Nightfall
	[19215] = 	{ 8,	290,  	23662 }, -- Pattern: Wisdom of the Timbermaw
	[19216] = 	{ 8,	290,  	23664 }, -- Pattern: Argent Boots
	[19217] = 	{ 8,	300,  	23665 }, -- Pattern: Argent Shoulders
	[19218] = 	{ 8,	300,  	23663 }, -- Pattern: Mantle of the Timbermaw
	[19219] = 	{ 8,	300,  	23666 }, -- Pattern: Flarecore Robe
	[19220] = 	{ 8,	300,  	23667 }, -- Pattern: Flarecore Leggings
	[19326] = 	{ 3,	290,  	23703 }, -- Pattern: Might of the Timbermaw
	[19327] = 	{ 3,	300,  	23704 }, -- Pattern: Timbermaw Brawlers
	[19328] = 	{ 3,	290,  	23705 }, -- Pattern: Dawn Treaders
	[19329] = 	{ 3,	300,  	23706 }, -- Pattern: Golden Mantle of the Dawn
	[19330] = 	{ 3,	300,  	23707 }, -- Pattern: Lava Belt
	[19331] = 	{ 3,	300,  	23708 }, -- Pattern: Chromatic Gauntlets
	[19332] = 	{ 3,	300,  	23709 }, -- Pattern: Corehound Belt
	[19333] = 	{ 3,	300,  	23710 }, -- Pattern: Molten Belt
	[19442] = 	{ 1,	300,  	23787 }, -- Formula: Powerful Anti-Venom
	[19444] = 	{ 10,	290,  	23799 }, -- Formula: Enchant Weapon - Strength
	[19445] = 	{ 10,	290,  	23800 }, -- Formula: Enchant Weapon - Agility
	[19446] = 	{ 10,	290,  	23801 }, -- Formula: Enchant Bracer - Mana Regeneration
	[19447] = 	{ 10,	300,  	23802 }, -- Formula: Enchant Bracer - Healing
	[19448] = 	{ 10,	300,  	23803 }, -- Formula: Enchant Weapon - Mighty Spirit
	[19449] = 	{ 10,	300,  	23804 }, -- Formula: Enchant Weapon - Mighty Intellect
	[19764] = 	{ 8,	300,  	24091 }, -- Pattern: Bloodvine Vest
	[19765] = 	{ 8,	300,  	24092 }, -- Pattern: Bloodvine Leggings
	[19766] = 	{ 8,	300,  	24093 }, -- Pattern: Bloodvine Boots
	[19769] = 	{ 3,	300,  	24121 }, -- Pattern: Primal Batskin Jerkin
	[19770] = 	{ 3,	300,  	24122 }, -- Pattern: Primal Batskin Gloves
	[19771] = 	{ 3,	300,  	24123 }, -- Pattern: Primal Batskin Bracers
	[19772] = 	{ 3,	300,  	24124 }, -- Pattern: Blood Tiger Breastplate
	[19773] = 	{ 3,	300,  	24125 }, -- Pattern: Blood Tiger Shoulders
	[19776] = 	{ 2,	300,  	24136 }, -- Plans: Bloodsoul Breastplate
	[19777] = 	{ 2,	300,  	24137 }, -- Plans: Bloodsoul Shoulders
	[19778] = 	{ 2,	300,  	24138 }, -- Plans: Bloodsoul Gauntlets
	[19779] = 	{ 2,	300,  	24139 }, -- Plans: Darksoul Breastplate
	[19780] = 	{ 2,	300,  	24140 }, -- Plans: Darksoul Leggings
	[19781] = 	{ 2,	300,  	24141 }, -- Plans: Darksoul Shoulders
	[20000] = 	{ 9,	300,  	24356 }, -- Schematic: Bloodvine Goggles
	[20001] = 	{ 9,	300,  	24357 }, -- Schematic: Bloodvine Lens
	[20011] = 	{ 4,	275,  	24365 }, -- Recipe: Mageblood Potion
	[20012] = 	{ 4,	275,  	24366 }, -- Recipe: Greater Dreamless Sleep
	[20013] = 	{ 4,	285,  	24367 }, -- Recipe: Living Action Potion
	[20014] = 	{ 4,	290,  	24368 }, -- Recipe: Major Troll's Blood Potion
	[20040] = 	{ 2,	300,  	24399 }, -- Plans: Dark Iron Boots
	[20075] = 	{ 6,	150,  	24418 }, -- Recipe: Heavy Crocolisk Stew
	[20253] = 	{ 3,	275,  	19068 }, -- Pattern: Warbear Harness
	[20254] = 	{ 3,	285,  	19080 }, -- Pattern: Warbear Woolies
	[20382] = 	{ 3,	300,  	24703 }, -- Pattern: Dreamscale Breastplate
	[20506] = 	{ 3,	300,  	24846 }, -- Pattern: Spitfire Bracers
	[20507] = 	{ 3,	300,  	24847 }, -- Pattern: Spitfire Gauntlets
	[20508] = 	{ 3,	300,  	24848 }, -- Pattern: Spitfire Breastplate
	[20509] = 	{ 3,	300,  	24849 }, -- Pattern: Sandstalker Bracers
	[20510] = 	{ 3,	300,  	24850 }, -- Pattern: Sandstalker Gauntlets
	[20511] = 	{ 3,	300,  	24851 }, -- Pattern: Sandstalker Breastplate
	[20546] = 	{ 8,	300,  	24901 }, -- Pattern: Runed Stygian Leggings
	[20547] = 	{ 8,	300,  	24903 }, -- Pattern: Runed Stygian Boots
	[20548] = 	{ 8,	300,  	24902 }, -- Pattern: Runed Stygian Belt
	[20553] = 	{ 2,	300,  	24912 }, -- Plans: Darkrune Gauntlets
	[20554] = 	{ 2,	300,  	24914 }, -- Plans: Darkrune Breastplate
	[20555] = 	{ 2,	300,  	24913 }, -- Plans: Darkrune Helm
	[20576] = 	{ 3,	100,  	24940 }, -- Pattern: Black Whelp Tunic
	[20726] = 	{ 10,	300,  	25072 }, -- Formula: Enchant Gloves - Threat
	[20727] = 	{ 10,	300,  	25073 }, -- Formula: Enchant Gloves - Shadow Power
	[20728] = 	{ 10,	300,  	25074 }, -- Formula: Enchant Gloves - Frost Power
	[20729] = 	{ 10,	300,  	25078 }, -- Formula: Enchant Gloves - Fire Power
	[20730] = 	{ 10,	300,  	25079 }, -- Formula: Enchant Gloves - Healing Power
	[20731] = 	{ 10,	300,  	25080 }, -- Formula: Enchant Gloves - Superior Agility
	[20732] = 	{ 10,	300,  	25081 }, -- Formula: Enchant Cloak - Greater Fire Resistance
	[20733] = 	{ 10,	300,  	25082 }, -- Formula: Enchant Cloak - Greater Nature Resistance
	[20734] = 	{ 10,	300,  	25083 }, -- Formula: Enchant Cloak - Stealth
	[20735] = 	{ 10,	300,  	25084 }, -- Formula: Enchant Cloak - Subtlety
	[20736] = 	{ 10,	300,  	25086 }, -- Formula: Enchant Cloak - Dodge
	[20752] = 	{ 10,	150,  	25125 }, -- Formula: Minor Mana Oil
	[20753] = 	{ 10,	200,  	25126 }, -- Formula: Lesser Wizard Oil
	[20754] = 	{ 10,	250,  	25127 }, -- Formula: Lesser Mana Oil
	[20755] = 	{ 10,	275,  	25128 }, -- Formula: Wizard Oil
	[20756] = 	{ 10,	300,  	25129 }, -- Formula: Brilliant Wizard Oil
	[20757] = 	{ 10,	300,  	25130 }, -- Formula: Brilliant Mana Oil
	[20758] = 	{ 10,	45,  	25124 }, -- Formula: Minor Wizard Oil
	[20761] = 	{ 4,	300,  	25146 }, -- Recipe: Transmute Elemental Fire
	[21025] = 	{ 6,	300,  	25659 }, -- Recipe: Dirge's Kickin' Chimaerok Chops
	[21099] = 	{ 6,	80,  	25704 }, -- Recipe: Smoked Sagefish
	[21219] = 	{ 6,	175,  	25954 }, -- Recipe: Sagefish Delight
	[21358] = 	{ 8,	260,  	26085 }, -- Pattern: Soul Pouch
	[21369] = 	{ 8,	285,  	26086 }, -- Pattern: Felcloth Bag
	[21371] = 	{ 8,	300,  	26087 }, -- Pattern: Core Felcloth Bag
	[21547] = 	{ 4,	250,  	26277 }, -- Recipe: Elixir of Greater Firepower
	[21548] = 	{ 3,	300,  	26279 }, -- Pattern: Stormshroud Gloves
	[21722] = 	{ 8,	250,  	26403 }, -- Pattern: Festival Dress
	[21723] = 	{ 8,	250,  	26407 }, -- Pattern: Festival Suit
	[21724] = 	{ 9,	125,  	26416 }, -- Schematic: Small Blue Rocket
	[21725] = 	{ 9,	125,  	26417 }, -- Schematic: Small Green Rocket
	[21726] = 	{ 9,	125,  	26418 }, -- Schematic: Small Red Rocket
	[21727] = 	{ 9,	175,  	26420 }, -- Schematic: Large Blue Rocket
	[21728] = 	{ 9,	175,  	26421 }, -- Schematic: Large Green Rocket
	[21729] = 	{ 9,	175,  	26422 }, -- Schematic: Large Red Rocket
	[21730] = 	{ 9,	225,  	26423 }, -- Schematic: Blue Rocket Cluster
	[21731] = 	{ 9,	225,  	26424 }, -- Schematic: Green Rocket Cluster
	[21732] = 	{ 9,	225,  	26425 }, -- Schematic: Red Rocket Cluster
	[21733] = 	{ 9,	275,  	26426 }, -- Schematic: Large Blue Rocket Cluster
	[21734] = 	{ 9,	275,  	26427 }, -- Schematic: Large Green Rocket Cluster
	[21735] = 	{ 9,	275,  	26428 }, -- Schematic: Large Red Rocket Cluster
	[21737] = 	{ 9,	275,  	26443 }, -- Schematic: Cluster Launcher
	[21738] = 	{ 9,	225,  	26442 }, -- Schematic: Firework Launcher
	[22209] = 	{ 2,	300,  	27585 }, -- Plans: Heavy Obsidian Belt
	[22214] = 	{ 2,	300,  	27588 }, -- Plans: Light Obsidian Belt
	[22219] = 	{ 2,	300,  	27586 }, -- Plans: Jagged Obsidian Shield
	[22220] = 	{ 2,	300,  	27589 }, -- Plans: Black Grasp of the Destroyer
	[22221] = 	{ 2,	300,  	27590 }, -- Plans: Obsidian Mail Tunic
	[22222] = 	{ 2,	300,  	27587 }, -- Plans: Thick Obsidian Breastplate
	[22307] = 	{ 8,	225,  	27658 }, -- Pattern: Enchanted Mageweave Pouch
	[22308] = 	{ 8,	275,  	27659 }, -- Pattern: Enchanted Runecloth Bag
	[22309] = 	{ 8,	300,  	27660 }, -- Pattern: Big Bag of Enchantment
	[22310] = 	{ 8,	275,  	27724 }, -- Pattern: Cenarion Herb Bag
	[22312] = 	{ 8,	300,  	27725 }, -- Pattern: Satchel of Cenarius
	[22388] = 	{ 2,	300,  	27829 }, -- Plans: Titanic Leggings
	[22389] = 	{ 2,	300,  	27832 }, -- Plans: Sageblade
	[22390] = 	{ 2,	300,  	27830 }, -- Plans: Persuader
	[22392] = 	{ 10,	290,  	27837 }, -- Formula: Enchant 2H Weapon - Agility
	[22683] = 	{ 8,	300,  	28210 }, -- Pattern: Gaea's Embrace
	[22684] = 	{ 8,	300,  	28205 }, -- Pattern: Glacial Gloves
	[22685] = 	{ 8,	300,  	28208 }, -- Pattern: Glacial Cloak
	[22686] = 	{ 8,	300,  	28207 }, -- Pattern: Glacial Vest
	[22687] = 	{ 8,	300,  	28209 }, -- Pattern: Glacial Wrists
	[22692] = 	{ 3,	300,  	28219 }, -- Pattern: Polar Tunic
	[22694] = 	{ 3,	300,  	28220 }, -- Pattern: Polar Gloves
	[22695] = 	{ 3,	300,  	28221 }, -- Pattern: Polar Bracers
	[22696] = 	{ 3,	300,  	28222 }, -- Pattern: Icy Scale Breastplate
	[22697] = 	{ 3,	300,  	28223 }, -- Pattern: Icy Scale Gauntlets
	[22698] = 	{ 3,	300,  	28224 }, -- Pattern: Icy Scale Bracers
	[22703] = 	{ 2,	300,  	28242 }, -- Plans: Icebane Breastplate
	[22704] = 	{ 2,	300,  	28243 }, -- Plans: Icebane Gauntlets
	[22705] = 	{ 2,	300,  	28244 }, -- Plans: Icebane Bracers
	[22729] = 	{ 9,	275,  	28327 }, -- Schematic: Steam Tonk Controller
	[22766] = 	{ 2,	300,  	28461 }, -- Plans: Ironvine Breastplate
	[22767] = 	{ 2,	300,  	28462 }, -- Plans: Ironvine Gloves
	[22768] = 	{ 2,	300,  	28463 }, -- Plans: Ironvine Belt
	[22769] = 	{ 3,	300,  	28474 }, -- Pattern: Bramblewood Belt
	[22770] = 	{ 3,	300,  	28473 }, -- Pattern: Bramblewood Boots
	[22771] = 	{ 3,	300,  	28472 }, -- Pattern: Bramblewood Helm
	[22772] = 	{ 8,	300,  	28482 }, -- Pattern: Sylvan Shoulders
	[22773] = 	{ 8,	300,  	28481 }, -- Pattern: Sylvan Crown
	[22774] = 	{ 8,	300,  	28480 }, -- Pattern: Sylvan Vest
	[23689] = 	{ 1,	300,  	30021 }, -- Manual: Crystal Infused Bandage
	[23690] = 	{ 6,	300,  	30047 }, -- Recipe: Crystal Flake Throat Lozenge
}
local RECIPE_TO_SPELL = {}
for k,v in pairs(RECIPE) do
	RECIPE_TO_SPELL[v[3]] = k
end

-- maybe weak table?
local RecipeCache = {}

function Recipe.IsRecipe(itemID)
	return RECIPE[itemID or 0] and true or false
end

function Recipe.GetRecipeData(itemID)
	return RECIPE[itemID or 0] and RECIPE[itemID or 0] or nil
end

function Recipe.GetRecipeDataForExtraFrame(itemID)
	local recipe = Recipe.GetRecipeData(itemID)
	if not itemID then return end
	return Profession.GetDataForExtraFrame(recipe[3])
end

function Recipe.GetCreatedItemID(itemID)
	return RECIPE[itemID or 0] and RECIPE[itemID or 0][3] or nil
end

function Recipe.GetRecipeDescription(itemID)
	return ( itemID and RECIPE[itemID] ) and RECIPE_PROF_TEXT[RECIPE[itemID][1] or RECIPE_PROF_DEFAULT] or nil
end

function Recipe.GetRecipeDescriptionWithRank(itemID)
	return ( itemID and RECIPE[itemID] ) and ( Profession.GetSpellDescriptionWithRank(RECIPE[itemID][3]) or Recipe.GetRecipeDescription(itemID) ) or nil
end

function Recipe.GetRecipeProfession(itemID)
	return ( itemID and RECIPE[itemID] ) and RECIPE[itemID][1] or nil
end

function Recipe.GetRecipeForSpell(spellID)
	return RECIPE_TO_SPELL[spellID or 0]
end

function Recipe.GetRecipeSkillRankForSpell(spellID)
	return RECIPE_TO_SPELL[spellID or 0] and RECIPE[ RECIPE_TO_SPELL[spellID or 0][2] ] or nil
end

function Recipe.GetPhaseTextureForItemID(itemID)
	return Profession.GetPhaseTextureForSpellID(RECIPE[itemID][3])
end