----------------------------------------------------------------------
-- 	Leatrix Plus Locale (www.leatrix.com)
----------------------------------------------------------------------

-- Create locale structure
local GameLocale = GetLocale()
local void, Leatrix_Plus = ...
local function localeFunc(L, key) return key end
local L = setmetatable({}, {__index = localeFunc})
Leatrix_Plus.L = L

-- Locale override (enUS, zhCN, zhTW, ruRU, koKR, deDE, esMX, frFR, itIT, ptBR)
-- GameLocale = "enUS"

-- zhCN: Simplified Chinese (People's Republic of China)
if GameLocale == "zhCN" then
L["A Falling Star"] = "陨落之星"
L["A Found Memento"] = "寻获的记忆碎片"
L["A friend request from"] = "你有一个好友申请，来自"
L["A New Life for Undeath"] = "亡灵的新生"
L["A Taste of Iron"] = "钢铁的滋味"
L["Accept resurrection"] = "自动接受战复"
L["Accept summon"] = "自动接受召唤"
L["Account achievements are being shared."] = "帐号成就已经共享。"
L["Account achievements are hidden."] = "账号成就已隐藏。"
L["Addon"] = "插件"
L["Adventure"] = "冒险"
L["Ahn'kahet (Old Kingdom)"] = "安卡赫特：古代王国"
L["All 3 battle pet slots need to be unlocked."] = "所有3个宠物栏位需要预先解锁。"
L["Allied Races"] = "同盟种族"
L["Alterac Valley"] = "奥特兰克山谷"
L["An Unexpected Reunion"] = "意外的团聚"
L["And Justice for Thrall"] = "萨尔的正义"
L["Anduin's Theme"] = "安度因的主题"
L["Antoran Wastes (Argus)"] = "安托兰废土（阿古斯）"
L["Antorus Ending"] = "安托鲁斯终章"
L["Antorus, the Burning Throne"] = "安托鲁斯，燃烧王座"
L["Arathi Basin"] = "阿拉希盆地"
L["Arathi Blizzard"] = "阿拉希暴风雪"
L["Arathi Highlands"] = "阿拉希高地"
L["Arcatraz"] = "禁魔监狱"
L["Arcway"] = "魔法回廊"
L["Arenas"] = "竞技场"
L["Arrival on Argus"] = "进军阿古斯"
L["Arrival to Zandalar"] = "登陆赞达拉"
L["Ashenvale"] = "灰谷"
L["Ashran"] = "阿什兰"
L["Assault on the Broken Shore"] = "破碎群岛入侵"
L["Astravar Harbor"] = "阿斯塔瓦港"
L["Atal'Dazar"] = "阿塔达萨"
L["Auchenai Crypts"] = "奥金尼地穴"
L["Auchindoun"] = "奥金顿"
L["AutoFollow"] = "自动跟随"
L["AutoFollow disabled."] = "已关闭自动跟随。"
L["Automate gossip"] = "对话自动交互"
L["Automate quests"] = "任务自动交接"
L["Automation"] = "自动交互"
L["Azjol-Nerub"] = "艾卓-尼鲁布"
L["Azshara"] = "艾萨拉"
L["Azsuna"] = "阿苏纳"
L["Azuremyst Isle"] = "秘蓝岛"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "损坏的ID"
L["Badlands"] = "荒芜之地"
L["Baradin Hold"] = "巴拉丁监狱"
L["Barrens"] = "南贫瘠之地"
L["Bastion of Twilight"] = "暮光堡垒"
L["Battle for Azeroth"] = "争霸艾泽拉斯"
L["Battle for Darkshore"] = "黑海岸之战"
L["Battle for Gilneas"] = "吉尔尼斯之战"
L["Battle for Stromgarde"] = "激流堡之战"
L["Battle of Angrathar the Wrathgate"] = "天谴之门之站"
L["Battle of Dazar'alor"] = "达萨罗之战"
L["Battle of Serpent's Heart"] = "蛇心之战"
L["Battlegrounds"] = "战场"
L["Bigger is Better (Alliance)"] = "越大越好（联盟）"
L["Bigger is Better (Horde)"] = "越大越好（部落）"
L["Black Morass"] = "幽暗沼泽"
L["Black Rook Hold"] = "黑鸦堡垒"
L["Black Temple"] = "黑暗神殿"
L["Blackfathom Deeps"] = "黑暗深渊"
L["Blackrock Caverns"] = "黑石岩窟"
L["Blackrock Depths"] = "黑石深渊"
L["Blackrock Foundry"] = "黑石铸造厂"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼血环"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "刀锋山"
L["Blasted Lands"] = "诅咒之地"
L["Block duels"] = "屏蔽决斗信息"
L["Block friend requests"] = "屏蔽好友申请"
L["Block party invites"] = "屏蔽队伍邀请"
L["Block pet battle duels"] = "屏蔽宠物对战"
L["Blocks"] = "屏蔽"
L["Bloodmaul Slag Mines"] = "血槌炉渣矿井"
L["Bloodmyst Isle"] = "秘血岛"
L["Borean Tundra"] = "北风苔原"
L["Bottom"] = "底部"
L["Broken Isles"] = "破碎群岛"
L["Broken Shore"] = "破碎海滩"
L["Buffs"] = "Buffs"
L["Burning Steppes"] = "燃烧平原"
L["Buyout Only"] = "仅限一口价"
L["Camera distance"] = "镜头距离"
L["Cape of Stranglethorn"] = "荆棘谷海角"
L["Cataclysm"] = "大地的裂变"
L["Cathedral of Eternal Night"] = "永夜大教堂"
L["Caverns of Time"] = "时光之穴"
L["Chain style"] = "边框样式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天窗口"
L["Checkbox labels are Ok."] = "复选框信息检查通过"
L["Choose an Enigma pattern"] = "选择一个“神秘莫测”图样"
L["Cinematics"] = "过场动画"
L["Class colored frames"] = "框体职业染色"
L["Class Trials"] = "职业试炼"
L["click here for new selection"] = "点击此处跳转下一曲目"
L["Click to configure the settings for this option."] = "点击进行额外的选项设置"
L["Click to reset the settings on this page."] = "点击重置此页面的设置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "点击重设屏幕尺寸以适配上下边框"
L["Click to return to the main menu."] = "点击返回到主菜单"
L["Coilfang Reservoir"] = "盘牙水库"
L["Color the backdrops based on faction"] = "根据阵营着色边框"
L["Combat log cannot be hidden while undocked."] = "战斗记录窗口被分离时无法隐藏。"
L["Combat plates"] = "自动开关姓名板"
L["Configuration Panel"] = "设置面板"
L["Connections for"] = "连接到"
L["Cooldowns"] = "冷却计时"
L["Court of Stars"] = "群星庭院"
L["Credits"] = "Credits"
L["Crucible of Storms"] = "风暴熔炉"
L["Crystalsong Forest"] = "晶歌森林"
L["Culling of Stratholme"] = "净化斯坦索姆"
L["Customise minimap"] = "自定义小地图"
L["Dalaran"] = "达拉然"
L["Dark Iron Dwarves"] = "黑铁矮人"
L["Dark Soil scanning activated.  Reload UI to exit."] = "黑色泥土扫描启用，取消需重载插件。"
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "黑色泥土扫描已经启用，你只需要进行一次操作。取消需重载插件。"
L["Darken the frame background"] = "显示深色背景"
L["Darkheart Thicket"] = "黑心林地"
L["Darkmoon Faire"] = "暗月马戏团"
L["Darkness Falls"] = "黑暗殒落"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "达纳苏斯"
L["Deadmines"] = "死亡矿井"
L["Deepholm"] = "深岩之洲"
L["Deepwind Gorge"] = "深风峡谷"
L["Desolace"] = "凄凉之地"
L["Destiny Unfulfilled"] = "未完成的使命"
L["Dire Maul"] = "厄运之槌"
L["Dire Maul: Capital Gardens"] = "厄运之槌：中心花园"
L["Dire Maul: Gordok Commons"] = "厄运之槌：戈多克议会"
L["Dire Maul: Warpwood Quarter"] = "厄运之槌：扭木广场"
L["Disable bag automation"] = "禁用自动背包"
L["Disable chat fade"] = "禁用聊天窗口淡出"
L["Disable loot warnings"] = "禁用拾取通报"
L["Disable pet automation"] = "禁用自动换宠"
L["Disable screen effects"] = "禁用屏幕特效"
L["Disable screen glow"] = "禁用屏幕泛光"
L["Disable sticky chat"] = "禁用聊天频道粘滞"
L["Draenor"] = "德拉诺"
L["Drag the frame overlay to position the frame."] = "拖动框体边框来移动。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移动面板来定位框体。|n|n如果想要改变框体尺寸，你需选定面板，然后移动滑块来选择。|n|n你一旦进入战斗，这个框体会自动关闭。"
L["Drag to set the font size of mail text."] = "拖动以调整邮件字体大小"
L["Drag to set the font size of quest text."] = "拖动以调整任务文本字体大小"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖动以缩放小地图尺寸。|n|n需要注意的是，当你使用游戏内置动作条时，缩放小地图会同时影响到右侧动作条，所以建议保持在100%。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖动以缩放LeatrixPlus面板尺寸"
L["Drag to set the scale of the selected frame."] = "拖动以缩放所选面板的尺寸"
L["Drag to set the size of the bottom border."] = "拖动以调整底部边框的尺寸"
L["Drag to set the size of the left border."] = "拖动以调整左侧边框的尺寸"
L["Drag to set the size of the right border."] = "拖动以调整右侧边框的尺寸"
L["Drag to set the size of the top border."] = "拖动以调整顶部边框的尺寸"
L["Drag to set the tooltip scale."] = "拖动以缩放鼠标提示框的尺寸"
L["Drag to set the transparency of the borders."] = "拖动以调整边框透明度"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖动以调整LeatrixPlus面板的透明度"
L["Dragon Soul"] = "巨龙之魂"
L["Dragonblight"] = "龙骨荒野"
L["Drak'Tharon Keep"] = "达克萨隆要塞"
L["Dread Wastes"] = "恐惧废土"
L["Drustvar"] = "德鲁斯瓦"
L["Dun Morogh"] = "丹莫罗"
L["Dungeon"] = "地下城"
L["Dungeons"] = "地下城"
L["Dup ID"] = "复制的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜隆塔尔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "尘泥沼泽"
L["Eastern"] = "东部王国"
L["Eastern Kingdoms"] = "东部王国"
L["Eastern Plaguelands"] = "东瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾尔文森林"
L["Embassies"] = "大使馆"
L["Embers of War"] = "战火余烬"
L["Emerald Nightmare"] = "翡翠梦魇"
L["Enable hotkey"] = "启用热键"
L["Enable viewport"] = "画面视口"
L["End Time"] = "时光之末"
L["Enhance dressup"] = "增强换装预览"
L["Enhancements"] = "增强功能"
L["Enigma"] = "神秘莫测"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "输入你想要监视冷却的法术所属的ID。|n|n如果冷却图标显示到了宠物面板下方，请检查设置中的宠物复选框。|n|n冷却监控的相关设置是依据你的职业和专精来保存的。"
L["enter zone or track name"] = "输入区域或者曲目名称"
L["Epilogue (Alliance)"] = "尾声（联盟）"
L["Epilogue (Horde)"] = "尾声（部落）"
L["Error messages will be hidden"] = "错误信息已屏蔽。"
L["Error messages will be shown"] = "错误信息已显示。"
L["Error Text"] = "错误文本"
L["Establish Your Garrison (Alliance)"] = "建造你的要塞（联盟）"
L["Establish Your Garrison (Horde)"] = "建造你的要塞（部落）"
L["Events"] = "事件"
L["Everbloom"] = "永茂林地"
L["Evermoon Terrace"] = "永月平台"
L["Eversong Woods"] = "永歌森林"
L["Extras"] = "其他"
L["Eye of Azshara"] = "艾萨拉之眼"
L["Eye of the Storm"] = "风暴之眼"
L["Falanaar"] = "法兰纳尔"
L["Fall of Deathwing"] = "死亡之翼的陨落"
L["Fall of the Lich King"] = "巫妖王的殒落"
L["False"] = "错误"
L["Faster auto loot"] = "加速自动拾取"
L["Faster movie skip"] = "快速跳过短片"
L["Fate of the Horde"] = "部落的命运"
L["Features"] = "功能"
L["Felsoul Hold"] = "邪魂堡垒"
L["Felwood"] = "费伍德森林"
L["Feralas"] = "菲拉斯"
L["Find Item"] = "查找物品"
L["Firelands"] = "火焰之地"
L["Forge of Souls"] = "灵魂熔炉"
L["Frames"] = "框体相关"
L["Freehold"] = "自由镇"
L["Frostfire Ridge"] = "霜火岭"
L["Game Options"] = "游戏设置"
L["Gate of the Setting Sun"] = "残阳关"
L["Ghost"] = "灵魂状态框体"
L["Ghostlands"] = "幽魂之地"
L["Gnomeregan"] = "诺莫瑞根"
L["Gold Only"] = "仅输入金币"
L["Gorgrond"] = "戈尔隆德"
L["Graphics and Sound"] = "界面和音效"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐轨车站"
L["Grizzly Hills"] = "灰熊丘陵"
L["Groups"] = "队伍"
L["Gruul's Lair"] = "格鲁尔的巢穴"
L["Gul'dan Ascendant"] = "古尔丹之治"
L["Gul'dan's Plan"] = "古尔丹的计策"
L["Gundrak"] = "古达克"
L["Gundrak (rear entrance)"] = "古达克（后门）"
L["Halls of Lightning"] = "闪电大厅"
L["Halls of Origination"] = "起源大厅"
L["Halls of Reflection"] = "倒映大厅"
L["Halls of Stone"] = "岩石大厅"
L["Halls of Valor"] = "勇气大厅"
L["Harbingers Gul'dan"] = "预言者古尔丹"
L["Harbingers Illidan"] = "预言者伊利丹"
L["Harbingers Khadgar"] = "预言者卡德加"
L["Havenswood"] = "湾林"
L["Heart of Fear"] = "恐惧之心"
L["Hellfire Citadel"] = "地狱火堡垒"
L["Hellfire Peninsula"] = "地狱火半岛"
L["Hellfire Ramparts"] = "地狱火城墙"
L["Hellscream's Downfall (Alliance)"] = "地狱咆哮的殒落（联盟）"
L["Hellscream's Downfall (Horde)"] = "地狱咆哮的殒落（部落）"
L["Help"] = "帮助"
L["Hide alerts"] = "隐藏信息提示"
L["Hide bodyguard gossip"] = "隐藏保镖对话"
L["Hide boss banner"] = "隐藏BOSS横幅"
L["Hide chat buttons"] = "隐藏聊天窗口按钮"
L["Hide clean-up buttons"] = "隐藏背包整理按钮"
L["Hide cooldown duration numbers (if enabled)"] = "隐藏冷却计时（若启用）"
L["Hide crafted names"] = "隐藏制造者名字"
L["Hide error messages"] = "隐藏错误信息"
L["Hide gryphons"] = "隐藏动作条狮鹫"
L["Hide level-up display"] = "隐藏升级提示"
L["Hide order hall bar"] = "隐藏职业大厅信息"
L["Hide portrait numbers"] = "隐藏头像数字"
L["Hide social button"] = "隐藏社交按钮"
L["Hide stance bar"] = "隐藏姿态条"
L["Hide talking frame"] = "隐藏对话框体"
L["Hide the clock"] = "隐藏时钟"
L["Hide the combat log"] = "隐藏战斗记录窗口"
L["Hide the zone text bar"] = "隐藏区域信息"
L["Hide the zoom buttons"] = "隐藏缩放按钮"
L["Hide tooltips for world units during combat"] = "战斗中隐藏窗口"
L["Hide zone text"] = "隐藏区域文本"
L["Highmaul"] = "悬槌堡"
L["Highmountain"] = "至高岭"
L["Highmountain Tauren"] = "至高岭牛头人"
L["Hillsbrad Foothills"] = "希尔斯布莱德丘陵"
L["Hinterlands"] = "辛特兰"
L["Home"] = "主页"
L["Hour of Twilight"] = "暮光之刻"
L["Howling Fjord"] = "嚎风峡湾"
L["Hyjal Summit"] = "海加尔山"
L["Icecrown"] = "冰冠冰川"
L["Icecrown Citadel"] = "冰冠堡垒"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾选后，一个按钮会显示在角色框体，其鼠标提示信息会显示身上的装备耐久度。|n|n当你死后，你的整体耐久度也会显示在聊天框体。"
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "勾选后，会自动邀请那些密语你“INV”的玩家。|n|n你必须不在队伍中，或者是队伍队长的情况下，才可以生效。"
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "勾选后，一个全局音量控制滑块会显示在角色信息框体。|n|n这个音量控制可以在两个位置之间切换，你可以按住SHIFT+鼠标右键进行切换。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾选后，小地图图标可用。|n|n单击 - 打开控制面板。|n|nSHIFT+左键 - 打开音乐。|n|nSHIFT+右键 - 打开计时器。|n|nCTRL+左键 - 打开小地图追踪。|n|nCTRL+右键 - 开关错误信息（需启用）。|n|nCTRL+SHIFT+左键 - 开关Zygor插件（需安装）.|n|nCTRL+SHIFT+右键 - 开关窗口模式。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction price type and duration settings will be saved account-wide."] = "勾选后，会给拍卖行添加一些额外功能。|n|n仅限一口价 - 上架物品无需输入起始价格。|n|n仅输入金币 - 自动在银币和铜币位输入99，以便加快新物品的上架。|n|n搜索按钮 - 在拍卖行搜索你正在出售的物品。|n|n另外，拍卖物品的价格模式和持续时间设置将保存为账户通用设置。"
L["If checked, additional functionality will be added to the dressup frame.|n|nNude and tabard toggle buttons will be added, model positioning controls will be removed and special model animations will be disabled."] = "勾选后，会给试衣间添加部分新功能。|n|n会添加裸体和战袍隐藏按钮，角色模型控制会被移除，角色的特殊动画也将被禁用。"
L["If checked, alert frames will not be shown."] = "勾选后，通知提示框体不再显示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你访问商贩时将自动出售背包中的杂物。|n|n当你访问时按住Shift键，可以暂时忽略该功能。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾选后，信息窗口的边框会更改为蓝色（右方）或者红色（敌方）。"
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "勾选后，被自动召唤的战斗宠物会在若干秒后被自动召回。|n|n这包括将宠物拖动到对战队伍栏位和进入宠物对战的指令。|n|n需要注意的是，战斗中自动召唤的宠物会在战斗结束后再解散。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾选后，战网好友申请会自动屏蔽。|n|n启用后，当前待处理的申请会自动拒绝。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾选后，聊天窗口的按钮会被隐藏。|n|n点击窗口标签会自动显示最新的消息。|n|n使用鼠标滚轮可以查看历史消息。按住SHIFT进行消息页面跳转，按住CTRL将滚动至消息页首/页尾。"
L["If checked, chat text will not fade out after a time period."] = "勾选后，聊天信息不会在一定时间后淡出。"
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "勾选后，会在玩家、目标和焦点面板启用职业颜色。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾选后，当你选择Roll点或者想要出售/邮寄一个可交易物品时，不再显示确认信息。"
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "勾选后，将队伍转换为团队时，低等级玩家不再受限。|n|n小队里的玩家必须都安装Leatrix Plus插件才可以生效。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾选后，冷却计时数字不再显示。|n|n如果未勾选，在界面-动作条中启用冷却计时后，在相关的冷却中的法术图标会显示计时数字。"
L["If checked, crafted items will no longer show the name of the crafter."] = "勾选后，制造物品不再显示制造者的名字。"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾选后，在玩家头像和宠物头像上的伤害及治疗数字不再显示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾选后，对锁定的聊天窗口进行拖动，会使其竖直拉伸。|n|n对已解锁的聊天窗口进行拖动，会使其移动。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的决斗信息会被屏蔽。"
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "勾选后，当你处于下列情况时将关闭表情音效：|n|n休息时|n处于宠物对战中|n在半山集市|n在黑铁酒吧|n|n当你不处于上述位置时将恢复表情音效。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾选后，敌对姓名板会在战斗中自动开启，离开战斗后关闭。"
L["If checked, guild ranks will be shown for players in your guild."] = "勾选后，显示公会会阶。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾选后，除了部分特殊提示，大部分的错误信息（例如怒气不足）都不再显示。|n|n如果你启用了小地图按钮，你可以按住CTRL+鼠标右键来单独控制错误信息的开关。"
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "勾选后，如果你不在地下城队列中，你的好友或公会成员发送的组队申请会被自动接受。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的组队邀请会被屏蔽。"
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾选后，对于非好友和非公会成员的宠物对战信息会被屏蔽。"
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "勾选后，专业过滤设置会保存你最近一次的操作。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "勾选后，将对任务进行自动交互。|n|n任务需求金币，货币或者材料的不会自动交接。|n|n当按住SHIFT键打开对话时，可以忽略这项设置。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾选后，团队和副本聊天信息会改为蓝色（与小队一致）。"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "勾选后，当公会修理可用时，将优先使用公会资金。"
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "勾选后，如果你的小队队长是你的好友或公会成员，其申请的地下城请求会被自动接受。|n|n这个选项不会自动将你传送到副本中。|n|n这个选项需要你在地下城页面选择一个职责。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "勾选后，会自动接受在战斗外对你发起的战复。|n|n不会自动接受来自觉醒火盆或者工程晶塔的战复。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾选后，在Buff框体和目标头像下方的相关法术图标的鼠标提示框中，会显示它们的法术ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾选后，会禁用聊天频道的粘滞。|n|n此选项不会影响临时对话窗口。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾选后，当你不处于战斗状态时会自动接受召唤。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾选后，插件列表（游戏菜单处）会显示默认的对角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾选后，自动拾取的耗时将会明显降低。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾选后，背包及银行的整理按钮不再显示。"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "勾选后，BOSS的横幅信息不再显示。|n|n该信息通常在BOSS被击败后显示。它显示BOSS的名字以及掉落。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾选后，打开团队信息的按钮会显示在左侧团队管理框体的上方，而不是在其内部。|n|n此选项让你无需打开团队管理框体，就可以切换团队框体。"
L["If checked, the clock will be hidden."] = "勾选后，小地图的时钟会被隐藏。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾选后，战斗记录会被隐藏。|n|n战斗记录窗口必须未被分离时才能生效。|n|n如果战斗记录窗口被分离了，你可以拖动其合并至主窗口（然后重载插件），或者在聊天设置中重置设置。"
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "勾选后，“对他人只显示角色成就”的选项（界面-社交）会被永久勾选并锁定。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾选后文本框会被移动至聊天窗口上方。"
L["If checked, the game world will be resized to fit between the top and bottom borders.|n|nNote that if you enable this setting, the transparency slider will no longer affect the top and bottom borders."] = "勾选后，游戏界面的大小会修改适应顶部和底部的边框。|n|n当你启用这个选项时，透明度的调节不再影响这两个边框。"
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "勾选后，你的保镖对话时不再出现选项。|n|n对话时按住Shift键，可以暂时忽略该项设置。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾选后，将关闭死亡后的灵魂世界特效和渐隐时的特殊光效。"
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "勾选后，升级提示不再显示。|n|n升级提示功能包括副本目标、升级、小宠物奖励等等。"
L["If checked, the main bar gryphons will not be shown."] = "勾选后，动作条两边的狮鹫不再显示。"
L["If checked, the order hall command bar will not be shown."] = "勾选后，当你处于职业大厅时，顶部的信息条不再显示。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾选后，屏幕泛光会被禁用。|n|n启用这个选项的同时，也会关闭醉酒时的泛光效果。"
L["If checked, the social button and quick-join notification will be hidden."] = "勾选后，社交按钮和快速加入通知会被隐藏。"
L["If checked, the stance bar will not be shown."] = "勾选后，姿态条不再显示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾选后，对话面板不再显示。|n|n当NPC与你交流时，该框体通常出现在界面下方。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾选后，鼠标信息会被着色，你可以设置他的布局和大小尺寸。"
L["If checked, the tracking button will be merged with the calendar button.|n|nLeft-click the tracking button to show the tracking menu or right-click it to show the calendar."] = "勾选后，追踪按钮会与日历按钮合并。|n|n左键点击显示追踪信息，右键点击显示日历。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾选后，小地图的区域信息会被隐藏。追踪按钮的提示信息里会显示区域信息。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾选后，缩放按钮会被隐藏。你可以使用鼠标滚来来对小地图进行缩放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾选后，目标的信息窗口在战斗中会被隐藏。|n|n你可以按住SHIFT键暂时忽略这个设置。"
L["If checked, unit targets will be shown."] = "勾选后，目标的目标会显示在信息窗口上。"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "勾选后，wowhead的链接会显示在地图和成就面板里。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "勾选后，你可以按住ALT键来自动交互只有一个选项的对话窗口。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾选后，你可以按住CTRL键，点击聊天标签来打开相应的历史记录窗口，以供复制。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾选后，你可以使用CTRL+Z来打开Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾选后，你可以使用方向键移动文本框中的光标。|n|n如果未被勾选，方向键将保持它所绑定的按键功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾选后，你无需确认即可快速跳过过场短片。"
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "勾选后，你可以更改任务信息文本的字体大小。|n|n启用这个选项也会影响使用同一文本模版的框体（例如地下城查找器）。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾选后，你可以更改邮件文本的字体大小。|n|n这个选项不会影响系统邮件模版（例如拍卖行的收据信息）。"
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Buffs frame|n- Widget top center frame|n- Ghost frame|n- Timer bar|n- Player power bar"] = "勾选后，你可以改变下列框体的位置和缩放：|n|n- 玩家框体|n- 目标框体|n- Buffs框体|n-顶部信息框|n-灵魂框体|n-计时条|n-玩家特殊能量条"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾选后，你会生成一个画面视口，这个可以在游戏界面周围增加黑色的边框背景。|n|n边框的层级是处于游戏界面和插件之间，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾选后，你可以开启小地图相关的自定义选项。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾选后，你可以把聊天窗口拖动到屏幕边缘。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾选后，你可以在目标框体上方监控至多5个的法术监控。"
L["If checked, you will be able to reposition the tooltip."] = "勾选后，你可以重新给鼠标提示框设置锚点。"
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "勾选后，你可以通过一个单独的指令来保存你当前宠物对战的队伍配置信息（包括技能）。|n|n一个保存的按钮会添加到宠物面板。点击该按钮会给你当前的队伍显示相关的工作指令。按下<CTRL+C>会复制并缓存你的指令。|n|n你可以通过<CTRL+V>粘贴你的指令到聊天窗口或者宏页面，以实现快速配置队伍。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾选后，会在玩家框体显示稀有、精英或者稀有精英的边框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾选后，你可以加大镜头的缩放距离。"
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "勾选后，当你处于战场或者诸如阿什兰、托尔巴拉德或者冬拥湖之类的PVP场所，会在死亡时自动释放尸体。|n|n如果你有复生类的技能，则不会自动释放尸体（灵魂石，萨满复生等等）。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾选后，当你打开商贩、银行或者邮箱时，背包不会自动开启或者关闭。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾选后，你的聊天历史记录会增涨至4096行。如果未被勾选，会保持在默认的128行。|n|n启用这个设置可能会在登录时会隐藏一些聊天信息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾选后，当你打开一个可供修理的商贩时，会自动修理身上的装备。|n|n当你打开商贩时，按住SHIFT键会让你当下忽略此项功能。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾选后，区域文本不再显示。"
L["Increase chat history"] = "增加聊天历史记录"
L["Interface"] = "界面设置"
L["Into the Portal"] = "进入传送门"
L["Invalid battle pet team parameter."] = "无效的宠物对战队伍参数。"
L["Invalid console variable."] = "无效控制台缓存。"
L["Invalid parameter."] = "无效参数"
L["Invalid quest ID."] = "无效的任务ID。"
L["Invalid sound ID"] = "无效的声音ID"
L["Invalid taint level."] = "无效的污染等级。"
L["Invalid target."] = "无效目标。"
L["Invite from whispers"] = "密语邀请"
L["Iron Docks"] = "钢铁码头"
L["Ironforge"] = "铁炉堡"
L["Island Expeditions"] = "海岛探险"
L["Isle of Conquest"] = "征服之岛"
L["Isle of Quel'Danas"] = "奎尔丹纳斯岛"
L["Isle of Thunder"] = "雷神岛"
L["Jade Forest"] = "翡翠林"
L["Jade Forest Crash"] = "翡翠林之战"
L["Jaina Joins the Battle"] = "吉安娜加入战斗"
L["Jaina Returns to Kul Tiras"] = "吉安娜重返库尔提拉斯"
L["Jaina's Nightmare"] = "吉安娜的梦魇"
L["Jaina's Siege"] = "吉安娜的围城"
L["Jaina's Theme"] = "吉安娜的主题"
L["Jorundall"] = "约伦达尔"
L["Kalimdor"] = "卡利姆多"
L["Karazhan"] = "卡拉赞"
L["Kezan"] = "科赞岛"
L["Kil'jaeden's Downfall"] = "基尔加丹的殒落"
L["Kings' Rest"] = "诸王之眠"
L["Krasarang Wilds"] = "卡桑琅丛林"
L["Krokuun (Argus)"] = "克罗库恩（阿古斯）"
L["Kul Tiran Humans"] = "库尔提拉斯人"
L["Kul Tiras"] = "库尔提拉斯"
L["Kun-Lai Summit"] = "昆莱山"
L["Last Stand"] = "背水一战"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "下次登出时不会清空LeatrixPlus的插件缓存。"
L["Leaving Kezan"] = "逃离科赞岛"
L["Leaving the Wandering Isle"] = "离开梦幻岛"
L["Left"] = "左边"
L["Legion"] = "军团再临"
L["Lifetime honorable kills"] = "荣誉击杀总数"
L["Lightforged Draenei"] = "圣光德莱尼"
L["Lion's Watch"] = "雄狮岗哨"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享锁定"
L["Lost City of the Tol'vir"] = "托维尔失落之城"
L["Lost Isles"] = "失落群岛"
L["Lower Blackrock Spire"] = "黑石塔下层"
L["Lunastre Estate"] = "月郡庄园"
L["Mac'Aree (Argus)"] = "玛凯雷（阿古斯）"
L["Madness of Deathwing"] = "死亡之翼的疯狂"
L["Maelstrom"] = "大漩涡"
L["Mag'har Orcs"] = "玛格汉兽人"
L["Magisters' Terrace"] = "魔导师平台"
L["Magtheridon's Lair"] = "玛瑟里顿的巢穴"
L["Mail Text"] = "邮件文本"
L["Main Titles"] = "主标题"
L["Manage frames"] = "管理框体面板"
L["Manage tooltip"] = "鼠标信息窗口"
L["Managed by Leatrix Plus"] = "LeatrixPlus托管"
L["Mana-Tombs"] = "法力陵墓"
L["Maraudon"] = "玛拉顿"
L["Maraudon: Earth Song Falls"] = "玛拉顿：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "玛拉顿：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "玛拉顿：邪恶洞穴"
L["Mardum"] = "马顿"
L["Maw of Souls"] = "噬魂之喉"
L["Max camera zoom"] = "最大镜头距离"
L["Mechanics"] = "特性设置"
L["Media"] = "媒体"
L["Memory Usage"] = "内存占用"
L["Merge the tracking and calendar buttons"] = "合并追踪和日历按钮"
L["message shown."] = "信息显示。"
L["messages shown."] = "信息显示。"
L["Minimap"] = "小地图"
L["Missing console variable."] = "丢失控制台缓存。"
L["Missing mount name."] = "坐骑名字缺失。"
L["Missing movie ID."] = "影片编号不存在。"
L["Missing pet name."] = "宠物名字缺失。"
L["Missing quest ID."] = "缺少任务ID。"
L["Missing sound file parameter."] = "缺失音频文件参数"
L["Missing sound ID."] = "缺少声音ID。"
L["Mists of Pandaria"] = "熊猫人之迷"
L["Mogu'shan Palace"] = "魔古山宫殿"
L["Mogu'shan Vaults"] = "魔古山宝库"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "护月堡垒"
L["Moonglade"] = "月光林地"
L["Motherlode"] = "主母"
L["Mount Hyjal"] = "海加尔山"
L["Mount not found."] = "无法找到该坐骑。"
L["Move editbox to top"] = "把文本框移动上方"
L["Movie not playable."] = "无法播放该影片。"
L["Movie number"] = "影片编号"
L["Movies"] = "电影"
L["Mulgore"] = "莫高雷"
L["Music"] = "音乐"
L["Music Rolls"] = "音乐列表"
L["My Very Own Castle (Alliance)"] = "我的要塞独一无二（联盟）"
L["My Very Own Castle (Horde)"] = "我的要塞独一无二（部落）"
L["Mystical"] = "神秘"
L["Nagrand"] = "纳格兰"
L["Nagrand (Draenor)"] = "纳格兰 (德拉诺)"
L["Narration"] = "旁白"
L["Naxxramas"] = "纳克萨玛斯"
L["Nazmir"] = "纳兹米尔"
L["Neltharion's Lair"] = "奈萨里奥的巢穴"
L["Netherstorm"] = "虚空风暴"
L["Nexus"] = "时空枢纽"
L["Nightborne"] = "夜之子"
L["Nighthold"] = "暗夜要塞"
L["No bad sound IDs found."] = "没有发现损坏的ID。"
L["No help is available for this page."] = "此页面没有帮助信息。"
L["No items with durability equipped."] = "尚未装备任何带有耐久度的物品。"
L["No media duplicates found."] = "没有发现媒体的副本。"
L["No tooltip showing."] = "目前没有任何提示信息。"
L["None"] = "无"
L["Northern Barrens"] = "北贫瘠之地"
L["Northern Stranglethorn"] = "北荆棘谷"
L["Northrend"] = "诺森德"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "注意！|n你必须重新启动游戏客户端才可以正确加载新版本的Leatrix Plus。"
L["Nude"] = "隐藏着装"
L["Obsidian Sanctum"] = "黑曜石圣殿"
L["Old Hillsbrad Foothills"] = "旧希尔斯布莱德丘陵"
L["Onyxia's Lair"] = "奥妮克希亚的巢穴"
L["Orgrimmar"] = "奥格瑞玛"
L["Outland"] = "外域"
L["Overall"] = "总计"
L["Pandaria"] = "潘达利亚"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友组队邀请"
L["Pet"] = "宠物"
L["Pet Battles"] = "宠物对战"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "无法找到该宠物。你只能搜索你所拥有的显示在藏品宠物页面中的宠物。"
L["Pit of Saron"] = "萨隆矿坑"
L["Plants vs Zombies"] = "植物大战僵尸"
L["Player"] = "玩家框体"
L["Player Chain"] = "玩家边框"
L["Portal"] = "传送门"
L["Power"] = "能量"
L["Power of the Horde"] = "部落之力"
L["Press CTRL/C to copy."] = "按住CTRL+C复制"
L["Quest completed."] = "任务已完成。"
L["Quest not completed."] = "任务未完成。"
L["Quest Text"] = "任务信息文本"
L["Queue from friends"] = "好友队列申请"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "团队副本"
L["Raid frame toggle"] = "切换团队框体"
L["Random"] = "随机"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼泽"
L["Realm Of Torment"] = "苦痛之境"
L["Recent chat window"] = "临时聊天窗口"
L["Redridge Mountains"] = "赤脊山"
L["Reincarnation of Alleria Windrunner"] = "奥蕾莉亚的再生"
L["Rejection of the Gift"] = "拒绝馈赠"
L["Release in PvP"] = "PvP自动释放尸体"
L["Reload"] = "重载插件"
L["Remove raid restrictions"] = "移除团队等级限制"
L["Repair Automatically"] = "自动修理"
L["Repair automatically"] = "自动修理装备"
L["Repair using guild funds if available"] = "优先使用公会修理"
L["Repaired for"] = "修理花费"
L["Reposition the tooltip"] = "重设提示框锚点"
L["Requires UI reload."] = "需要重载插件"
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "需要你与拉兰娜·德罗姆交流。她可以在达拉然（诺森德）的铭文店里找到。"
L["Reset"] = "重置"
L["Resize mail text"] = "重设邮件文本"
L["Resize quest text"] = "重设任务文本"
L["Resize Screen"] = "屏幕缩放"
L["Resize the game world"] = "修改界面大小"
L["Rested bubbles"] = "休息气泡信息"
L["result"] = "结果"
L["results"] = "结果"
L["Return to Karazhan"] = "重返卡拉赞"
L["Return to the Black Temple"] = "重返黑暗神殿"
L["Rev"] = "除雾"
L["Right"] = "右边"
L["Right-click to close"] = "右键关闭"
L["Right-click to close."] = "右键点击关闭。"
L["right-click to go back"] = "右键点击返回"
L["Rise of Argus"] = "阿古斯的崛起"
L["Risking It All"] = "孤注一掷"
L["Ruby Sanctum"] = "红玉圣殿"
L["Ruins of Ahn'Qiraj"] = "安其拉废墟"
L["Ruins of Elune'eth"] = "艾露尼斯废墟"
L["Ruins of Gilneas"] = "吉尔尼斯废墟"
L["Sanctum of Order"] = "秩序大殿"
L["Save profession filters"] = "保存专业过滤"
L["Scale"] = "尺寸"
L["Scarlet Halls"] = "血色大厅"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通灵学院"
L["Search"] = "搜索"
L["Searing Gorge"] = "灼热峡谷"
L["Seat of the Triumvirate"] = "执政团之座"
L["Select the settings that you want to use."] = "选择你想启用的设置。"
L["Selection of music tracks"] = "音乐列表的选择"
L["Self Markers Allowed"] = "允许自我标记"
L["Self Markers Blocked"] = "屏蔽自我标记"
L["Sell junk automatically"] = "自动出售杂物"
L["SELLING JUNK"] = "出售杂物"
L["Serpentshrine Cavern"] = "毒蛇神殿"
L["Sethekk Halls"] = "塞泰克大厅"
L["Settings"] = "设置"
L["Shaders"] = "阴影"
L["Shado-Pan Monastery"] = "影踪修道院"
L["Shadow Labyrinth"] = "暗影迷宫"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Valley (Draenor)"] = "影月谷 (德拉诺)"
L["Shipyard Construction (Alliance)"] = "建造船坞（联盟）"
L["Shipyard Construction (Horde)"] = "建造船坞（部落）"
L["Sholazar Basin"] = "索拉查盆地"
L["Show auction controls"] = "显示拍卖行控制"
L["Show character addons"] = "显示角色插件"
L["Show cooldowns"] = "显示冷却计时"
L["Show durability status"] = "显示耐久度"
L["Show guild ranks for your guild"] = "显示会阶"
L["Show minimap button"] = "显示小地图按钮"
L["Show pet save button"] = "保存宠物按钮"
L["Show player chain"] = "显示玩家边框"
L["Show the spell ID in buff icon tooltips"] = "显示法术ID"
L["Show the unit's target"] = "显示目标的目标"
L["Show volume slider"] = "显示音量控制"
L["Show Wowhead links"] = "显示wowhead链接"
L["Shrine of the Storm"] = "风暴神殿"
L["Siege of Boralus"] = "围攻伯拉勒斯"
L["Siege of Niuzao Temple"] = "围攻砮皂寺"
L["Siege of Orgrimmar"] = "决战奥格瑞玛"
L["Silence rested emotes"] = "表情禁音"
L["Silithus"] = "希利苏斯"
L["Silverpine Forest"] = "银松森林"
L["Silvershard Mines"] = "碎银矿脉"
L["Skyreach"] = "通天峰"
L["Slave Pens"] = "奴隶围栏"
L["Social"] = "社交信息"
L["Sold junk for"] = "杂物出售总计"
L["Sound system restarted."] = "声音系统已重启。"
L["Southern Barrens"] = "南贫瘠之地"
L["Spell ID"] = "法术ID"
L["Spine of Deathwing"] = "死亡之翼的脊背"
L["Spires of Arak"] = "阿兰卡峰林"
L["Steamvault"] = "蒸汽地窟"
L["Stockade"] = "暴风城监狱"
L["Stonecore"] = "巨石之核"
L["Stonetalon Mountains"] = "石爪山脉"
L["Stop"] = "停止"
L["Storm Peaks"] = "风暴峭壁"
L["Stormheim"] = "风暴峡湾"
L["Stormheim (Alliance)"] = "风暴峡湾（联盟）"
L["Stormheim (Horde)"] = "风暴峡湾（部落）"
L["Stormsong Valley"] = "斯托颂谷地"
L["Stormstout Brewery"] = "风暴酿酒厂"
L["Stormwind"] = "暴风城"
L["Strand of the Ancients"] = "远古海滩"
L["Stratholme"] = "斯坦索姆"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字军广场"
L["Stratholme: The Gauntlet"] = "斯坦索姆：后门"
L["Sunken Temple"] = "沉没的神庙"
L["Sunwell Plateau"] = "太阳之井高地"
L["Support"] = "帮助支持"
L["Suramar"] = "苏拉玛"
L["Swamp of Sorrows"] = "悲伤沼泽"
L["System"] = "系统设置"
L["Tabard"] = "隐藏战袍"
L["Taint level: Basic (1)."] = "污染等级：基本(1)。"
L["Taint level: Disabled (0)."] = "污染等级：禁用(0)。"
L["Taint level: Full (2)."] = "污染等级：全面(2)。"
L["Talador"] = "塔拉多"
L["Tanaan Jungle"] = "塔纳安丛林"
L["Tanaris"] = "塔纳利斯"
L["Target"] = "目标框体"
L["Target Tracking Disabled"] = "禁用目标追踪"
L["Target Tracking Enabled"] = "启用目标追踪"
L["Tea with Jaina"] = "与吉安娜共饮"
L["Tel'anor"] = "泰安诺"
L["Teldrassil"] = "泰达希尔"
L["Tempest Keep"] = "风暴要塞"
L["Temple of Ahn'Qiraj"] = "安其拉神殿"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神庙"
L["Temple of Kotmogu"] = "寇魔古寺"
L["Temple of Sethraliss"] = "塞塔里斯神庙"
L["Temple of the Jade Serpent"] = "青龙寺"
L["Ten Years of Warcraft"] = "魔兽十周年"
L["Terokkar Forest"] = "泰罗卡森林"
L["Terrace of Endless Spring"] = "永春台"
L["Terror of Darkshore"] = "黑海岸的恐怖"
L["Text"] = "文本信息"
L["Text size"] = "字体尺寸"
L["Text Size"] = "字体尺寸"
L["The Arcatraz"] = "禁魔监狱"
L["The Art of War"] = "战争的艺术"
L["The Bastion of Twilight"] = "暮光堡垒"
L["The Battle for Broken Shore"] = "破碎海滩之战"
L["The Battle for Shattrath"] = "沙塔斯之战"
L["The Battle of Thunder Pass"] = "雷电王座之战"
L["The Black Morass"] = "黑色沼泽"
L["The Blood Furnace"] = "鲜血熔炉"
L["The Botanica"] = "生态船"
L["The Burning Crusade"] = "燃烧的远征"
L["The Culling of Stratholme"] = "净化斯坦索姆"
L["The Deadmines"] = "死亡矿井"
L["The Demon's Trail"] = "恶魔的追踪"
L["The Dragon Soul"] = "巨龙之魂"
L["The Everbloom"] = "永茂林地"
L["The Eye"] = "风暴要塞"
L["The Eye of Eternity"] = "永恒之眼"
L["The Fall of Lordaeron"] = "洛丹伦的陨落"
L["The Fate of Val'sharah"] = "瓦尔莎拉的命运"
L["The Fleet in Krasarang (Alliance)"] = "卡桑琅的舰队（联盟）"
L["The Fleet in Krasarang (Horde)"] = "卡桑琅的舰队（部落）"
L["The Forge of Souls"] = "灵魂洪炉"
L["The Frozen Halls"] = "冰封大殿"
L["The Halls of Reflection"] = "倒映大厅"
L["The Invasion Begins"] = "入侵开始"
L["The King's Command"] = "国王的征召"
L["The Mechanar"] = "能源舰"
L["The Nexus"] = "魔枢"
L["The Nightborne Pact"] = "夜之子的公约"
L["The Nighthold"] = "暗夜要塞"
L["The Obsidian Sanctum"] = "黑曜石圣殿"
L["The Oculus"] = "魔环"
L["The Old Kingdom"] = "古代王国"
L["The Pit of Saron"] = "萨隆矿坑"
L["The Return of Hope"] = "希望重燃"
L["The Ruby Sanctum"] = "红玉圣殿"
L["The Shattered Halls"] = "破碎大厅"
L["The Stockade"] = "监狱"
L["The Stonecore"] = "巨石之核"
L["The Violet Hold"] = "紫罗兰监狱"
L["The Vortex Pinnacle"] = "旋云之巅"
L["The Waning Crescent"] = "残月酒馆"
L["Themes"] = "主题"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "这个命令会指派你的当前宠物对战队伍并保存技能选择信息。|n|n按下<CTRL+C>来复制指令，然后通过<CTRL+V>来粘贴指令到聊天窗口或者宏页面中。"
L["This panel will close automatically if you enter combat."] = "此面板在你进入战斗后自动关闭。"
L["Thousand Needles"] = "千针石林"
L["Throne of the Four Winds"] = "风神王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷电王座"
L["Thunder Bluff"] = "雷霆崖"
L["Timeless Isle"] = "永恒岛"
L["Timer"] = "计时框体"
L["Tiragarde Sound"] = "提拉加德海峡"
L["Tirisfal Glades"] = "提瑞斯法林地"
L["To begin, choose an options page."] = "请选择一项开始使用"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "你必须取消魔兽货币分类以启用寻找物品的按钮。"
L["Tol Barad"] = "托尔巴拉德"
L["Tol Dagor"] = "托尔达戈"
L["Tomb of Sargeras"] = "萨格拉斯之墓"
L["Tooltip"] = "鼠标信息窗口"
L["Tooltip title color"] = "鼠标提示信息颜色"
L["Top"] = "顶部"
L["Top Center"] = "顶级中心"
L["Townlong Steppes"] = "螳螂高原"
L["Tracing started."] = "追踪开始。"
L["Tracing stopped."] = "追踪停止。"
L["Transparency"] = "透明度"
L["Trial of Style"] = "时尚试炼"
L["Trial of the Champion"] = "冠军的试炼"
L["Trial of the Crusader"] = "十字军的试炼"
L["Trial of Valor"] = "勇气试炼"
L["True"] = "正确"
L["Twilight Highlands"] = "暮光高地"
L["Twilight Vineyards"] = "暮光酒庄"
L["Twin Peaks"] = "双子峰"
L["Uldaman"] = "奥达曼"
L["Uldir"] = "奥迪尔"
L["Ulduar"] = "奥杜尔"
L["Uldum"] = "奥丹姆"
L["Unclamp chat frame"] = "不限制窗口位置"
L["Underbog"] = "幽暗沼泽"
L["Undercity"] = "幽暗城"
L["Underrot"] = "地渊孢林"
L["Un'Goro Crater"] = "安戈洛环形山"
L["Universal group color"] = "统一队伍颜色"
L["Upper Blackrock Spire"] = "黑石塔上层"
L["Use arrow keys in chat"] = "允许使用方向键"
L["Use easy resizing"] = "使用简单拉伸"
L["Use Leatrix Plus to move that frame."] = "使用Leatrix Plues来移动框体"
L["Use Leatrix Plus to reset that frame."] = "使用Leatrix Plues来重置框体"
L["Utgarde Keep"] = "乌特加德城堡"
L["Utgarde Pinnacle"] = "乌特加德之巅"
L["Vale of Eternal Blossoms"] = "锦绣谷"
L["Valley of the Four Winds"] = "四风谷"
L["Val'sharah"] = "瓦尔莎拉"
L["Value must be a number."] = "该参数必须为数字。"
L["Various"] = "其他"
L["Vashj'ir"] = "瓦丝琪尔"
L["Vault of Archavon"] = "阿尔卡冯的宝库"
L["Vault of the Wardens"] = "守望者地窟"
L["Vendors"] = "商贩"
L["Version"] = "版本"
L["Victory at The Nighthold"] = "暗夜要塞的胜利"
L["Victory in Draenor!"] = "德拉诺的胜利！"
L["Video"] = "视频"
L["Viewport"] = "视口"
L["Violet Hold"] = "紫罗兰监狱"
L["Visibility"] = "可见性"
L["Vision of Sailor's Memory"] = "海员记忆的幻象"
L["Void Elves"] = "虚空精灵"
L["Vol'dun"] = "沃顿"
L["Vol'mar"] = "沃玛尔"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Wandering Isle"] = "迷踪岛"
L["Warbringers Azshara"] = "战争使者艾萨拉"
L["Warbringers Jaina"] = "战争使者吉安娜"
L["Warbringers Sylvanas"] = "战争使者 希尔瓦娜斯"
L["Warfronts"] = "战争前线"
L["Warlords of Draenor"] = "德拉诺之王"
L["Warsong Gulch"] = "战歌峡谷"
L["was automatically declined."] = "已经自动拒绝。"
L["Waycrest Manor"] = "维克雷斯庄园"
L["Weather density"] = "天气密度"
L["Welcome to Leatrix Plus."] = "欢迎使用Leatrix Plus"
L["Well of Eternity"] = "永恒之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "湿地"
L["Widget"] = "窗口小部件"
L["Winter"] = "冬日"
L["Wintergrasp"] = "冬拥湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔兽世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wyrmrest Temple"] = "龙眠神殿"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你无法在战斗中进行该项操作。"
L["You do not own this pet.  Only owned pets can be searched."] = "你还未拥有这只宠物。你只能搜索你拥有的宠物。"
L["You have"] = "你有"
L["You need a battle pet team."] = "你需要一个宠物对战队伍。"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要进行重载插件后才能使部分设置生效。|n|n你无需立即点击重载插件按钮，但是你完成设置并希望其生效时，必须点击它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新载入。"
L["Zandalar"] = "赞达拉"
L["Zandalari Trolls"] = "赞达拉巨魔"
L["Zangarmarsh"] = "赞加沼泽"
L["Zones"] = "区域"
L["Zul'Aman"] = "祖阿曼"
L["Zuldazar"] = "祖达萨"
L["Zul'Drak"] = "祖达克"
L["Zul'Farrak"] = "祖尔法拉克"
L["Zul'Gurub"] = "祖尔格拉布"
L["Zygor addon not found."] = "你尚未安装Zygor插件。"

end

-- zhTW: Traditional Chinese (Taiwan)
if GameLocale == "zhTW" then
L["A Falling Star"] = "殞落之星"
L["A Found Memento"] = "尋獲的記憶碎片"
L["A friend request from"] = "你有一個好友申請，來自"
L["A New Life for Undeath"] = "不死族的新生"
L["A Taste of Iron"] = "鋼鐵的滋味"
L["Accept resurrection"] = "自動接受復活"
L["Accept summon"] = "自動接受召喚"
L["Account achievements are being shared."] = "帳號成就已經共享。"
L["Account achievements are hidden."] = "帳號成就已隱藏。"
L["Addon"] = "插件"
L["Adventure"] = "探險"
L["Ahn'kahet (Old Kingdom)"] = "安卡罕特：古王國"
L["All 3 battle pet slots need to be unlocked."] = "所有的三個戰寵欄位需要解鎖。"
L["Allied Races"] = "同盟種族"
L["Alterac Valley"] = "奧特蘭克山谷"
L["An Unexpected Reunion"] = "一次意想不到的重逢"
L["And Justice for Thrall"] = "索爾的正義"
L["Anduin's Theme"] = "安度因主題"
L["Antoran Wastes (Argus)"] = "安托洛斯荒原（阿古斯）"
L["Antorus Ending"] = "安托洛斯終章"
L["Antorus, the Burning Throne"] = "安托洛斯．燃燒王座"
L["Arathi Basin"] = "阿拉希盆地"
L["Arathi Blizzard"] = "阿拉西暴風雪"
L["Arathi Highlands"] = "阿拉希高地"
L["Arcatraz"] = "奴隸監獄"
L["Arcway"] = "幽暗地道"
L["Arenas"] = "競技場"
L["Arrival on Argus"] = "抵達阿古斯"
L["Arrival to Zandalar"] = "抵達贊達拉"
L["Ashenvale"] = "梣谷"
L["Ashran"] = "艾斯蘭"
L["Assault on the Broken Shore"] = "破碎群島的襲擊"
L["Astravar Harbor"] = "艾斯特瓦港"
L["Atal'Dazar"] = "阿塔達薩"
L["Auchenai Crypts"] = "奧奇奈地穴"
L["Auchindoun"] = "奧齊頓"
L["AutoFollow"] = "自動跟隨"
L["AutoFollow disabled."] = "自動跟隨已停用。"
L["Automate gossip"] = "自動對話"
L["Automate quests"] = "任務自動化"
L["Automation"] = "自動化"
L["Azjol-Nerub"] = "阿茲歐-奈幽"
L["Azshara"] = "艾薩拉"
L["Azsuna"] = "艾蘇納"
L["Azuremyst Isle"] = "藍謎島"
L["Back to Main Menu"] = "返回"
L["Bad ID"] = "損壞的ID"
L["Badlands"] = "荒蕪之地"
L["Baradin Hold"] = "巴拉丁堡"
L["Barrens"] = "南貧瘠之地"
L["Bastion of Twilight"] = "暮光堡壘"
L["Battle for Azeroth"] = "決戰艾澤拉斯"
L["Battle for Darkshore"] = "黑海岸之戰"
L["Battle for Gilneas"] = "吉爾尼斯之戰"
L["Battle for Stromgarde"] = "斯通加德之戰"
L["Battle of Angrathar the Wrathgate"] = "安格薩憤怒之門的戰役"
L["Battle of Dazar'alor"] = "達薩亞洛之戰"
L["Battle of Serpent's Heart"] = "毒蛇之心的戰鬥"
L["Battlegrounds"] = "戰場"
L["Bigger is Better (Alliance)"] = "越大越好（聯盟）"
L["Bigger is Better (Horde)"] = "越大越好（部落）"
L["Black Morass"] = "黑色沼澤"
L["Black Rook Hold"] = "玄鴉堡"
L["Black Temple"] = "黑暗神廟"
L["Blackfathom Deeps"] = "黑澗深淵"
L["Blackrock Caverns"] = "黑石洞穴"
L["Blackrock Depths"] = "黑石深淵"
L["Blackrock Foundry"] = "黑石鑄造廠"
L["Blackrock Mountain"] = "黑石山"
L["Blackrock Spire"] = "黑石塔"
L["Blackwing Descent"] = "黑翼陷窟"
L["Blackwing Lair"] = "黑翼之巢"
L["Blade's Edge Mountains"] = "劍刃山脈"
L["Blasted Lands"] = "詛咒之地"
L["Block duels"] = "拒絕決鬥"
L["Block friend requests"] = "封鎖好友邀請"
L["Block party invites"] = "封鎖隊伍邀請"
L["Block pet battle duels"] = "封鎖寵物對戰"
L["Blocks"] = "封鎖"
L["Bloodmaul Slag Mines"] = "血槌熔渣礦場"
L["Bloodmyst Isle"] = "血謎島"
L["Borean Tundra"] = "北風凍原"
L["Bottom"] = "底部"
L["Broken Isles"] = "破碎群島"
L["Broken Shore"] = "破碎海岸"
L["Buffs"] = "增益"
L["Burning Steppes"] = "燃燒平原"
L["Buyout Only"] = "僅限直購價"
L["Camera distance"] = "鏡頭距離"
L["Cape of Stranglethorn"] = "荊棘谷海角"
L["Cataclysm"] = "浩劫與重生"
L["Cathedral of Eternal Night"] = "永夜聖殿"
L["Caverns of Time"] = "時光之穴"
L["Chain style"] = "邊框樣式"
L["Character"] = "角色"
L["Chat"] = "聊天功能"
L["Chat Frame"] = "聊天視窗"
L["Checkbox labels are Ok."] = "複選框標籤是OK的。"
L["Choose an Enigma pattern"] = "選擇謎之模式"
L["Cinematics"] = "動畫"
L["Class colored frames"] = "框架職業染色"
L["Class Trials"] = "職業試煉"
L["click here for new selection"] = "點擊這裡跳轉新選擇"
L["Click to configure the settings for this option."] = "點擊進行額外的選項設置"
L["Click to reset the settings on this page."] = "點擊重置此頁面的設置。"
L["Click to resize the screen to fit between the top and bottom borders."] = "點擊來重設螢幕大小以適配上下邊框。"
L["Click to return to the main menu."] = "點擊返回到主選單"
L["Coilfang Reservoir"] = "盤牙蓄湖"
L["Color the backdrops based on faction"] = "根據陣營著色邊框"
L["Combat log cannot be hidden while undocked."] = "戰鬥記錄視窗被分離時無法隱藏。"
L["Combat plates"] = "自動開關姓名板"
L["Configuration Panel"] = "設置面板"
L["Connections for"] = "連結在"
L["Cooldowns"] = "冷卻"
L["Court of Stars"] = "眾星之廷"
L["Credits"] = "有功人員"
L["Crucible of Storms"] = "風暴邪淵"
L["Crystalsong Forest"] = "水晶之歌森林"
L["Culling of Stratholme"] = "斯坦索姆的抉擇"
L["Customise minimap"] = "自定義小地圖"
L["Dalaran"] = "達拉然"
L["Dark Iron Dwarves"] = "黑鐵矮人"
L["Dark Soil scanning activated.  Reload UI to exit."] = "深色土壤掃描啟用，取消需重載插件。"
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "深色土壤掃描已經啟用，你只需要進行一次操作。取消需重載插件。"
L["Darken the frame background"] = "顯示深色背景"
L["Darkheart Thicket"] = "暗心灌木林"
L["Darkmoon Faire"] = "暗月馬戲團"
L["Darkness Falls"] = "黑暗殞落"
L["Darkshore"] = "黑海岸"
L["Darnassus"] = "達納蘇斯"
L["Deadmines"] = "死亡礦坑"
L["Deepholm"] = "地深之源"
L["Deepwind Gorge"] = "深風峽谷"
L["Desolace"] = "淒涼之地"
L["Destiny Unfulfilled"] = "戰亂命運"
L["Dire Maul"] = "厄運之槌"
L["Dire Maul: Capital Gardens"] = "厄運之槌：中心花園"
L["Dire Maul: Gordok Commons"] = "厄運之槌：戈多克平民區"
L["Dire Maul: Warpwood Quarter"] = "厄運之槌：杻木廣場"
L["Disable bag automation"] = "停用背包自動開啟"
L["Disable chat fade"] = "停用聊天視窗淡出"
L["Disable loot warnings"] = "停用拾取通報"
L["Disable pet automation"] = "停用寵物自動化"
L["Disable screen effects"] = "停用螢幕特效"
L["Disable screen glow"] = "停用螢幕光暈"
L["Disable sticky chat"] = "停用聊天頻道粘附"
L["Draenor"] = "德拉諾"
L["Drag the frame overlay to position the frame."] = "拖曳框架的遮罩以定位此框架。"
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "移動面板來定位框架。|n|n如果想要改變框架尺寸，你需選定面板，然後移動滑塊來選擇。|n|n你一旦進入戰鬥，這個框架會自動關閉。"
L["Drag to set the font size of mail text."] = "拖動來設置郵件文字的大小。"
L["Drag to set the font size of quest text."] = "拖動來設置任務文字的大小。"
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "拖動來設定小地圖縮放。|n|n請注意如果您使用的是預設動作列，則重新縮放小地圖也會在啟動時重新縮放右側動作列，因此您可能希望將其保留為100%。"
L["Drag to set the scale of the Leatrix Plus panel."] = "拖動來設置Leatrix Plus面板的縮放大小。"
L["Drag to set the scale of the selected frame."] = "拖動來設置所選框架的縮放大小。"
L["Drag to set the size of the bottom border."] = "拖動來設置底部邊框的大小。"
L["Drag to set the size of the left border."] = "拖動來設置左側邊框的大小。"
L["Drag to set the size of the right border."] = "拖動來設置右側邊框的大小。"
L["Drag to set the size of the top border."] = "拖動來設置頂部邊框的大小。"
L["Drag to set the tooltip scale."] = "拖動來設置工具提示的縮放大小。"
L["Drag to set the transparency of the borders."] = "拖動來設置邊框的透明度。"
L["Drag to set the transparency of the Leatrix Plus panel."] = "拖動來設置Leatrix Plus面板的透明度。"
L["Dragon Soul"] = "巨龍之魂"
L["Dragonblight"] = "龍骨荒野"
L["Drak'Tharon Keep"] = "德拉克薩隆要塞"
L["Dread Wastes"] = "悚然荒野"
L["Drustvar"] = "祖斯特瓦"
L["Dun Morogh"] = "丹莫洛"
L["Dungeon"] = "地城"
L["Dungeons"] = "地城"
L["Dup ID"] = "重複的ID"
L["durability"] = "耐久度"
L["Durability"] = "耐久度"
L["Durotar"] = "杜洛塔"
L["Duskwood"] = "暮色森林"
L["Dustwallow Marsh"] = "塵泥沼澤"
L["Eastern"] = "東部王國"
L["Eastern Kingdoms"] = "東部王國"
L["Eastern Plaguelands"] = "東瘟疫之地"
L["ELITE"] = "精英"
L["Elwynn Forest"] = "艾爾文森林"
L["Embassies"] = "特使"
L["Embers of War"] = "戰火餘燼"
L["Emerald Nightmare"] = "翡翠夢魘"
L["Enable hotkey"] = "啟用熱鍵"
L["Enable viewport"] = "啟用視窗背景"
L["End Time"] = "終焉之刻"
L["Enhance dressup"] = "增強試衣間"
L["Enhancements"] = "增強功能"
L["Enigma"] = "謎"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "輸入你想要看見冷卻圖標的法術ID。|n|n如果冷卻圖標通常出現在寵物框架下，勾選寵物複選框。|n|n冷卻圖標依據你的職業與專精儲存。"
L["enter zone or track name"] = "輸入區域或曲目名稱"
L["Epilogue (Alliance)"] = "結局（聯盟）"
L["Epilogue (Horde)"] = "結局（部落）"
L["Error messages will be hidden"] = "錯誤訊息將會隱藏"
L["Error messages will be shown"] = "錯誤訊息將會顯示"
L["Error Text"] = "錯誤文字"
L["Establish Your Garrison (Alliance)"] = "建立你的要塞（聯盟）"
L["Establish Your Garrison (Horde)"] = "建立你的要塞（部落）"
L["Events"] = "事件"
L["Everbloom"] = "永茂林"
L["Evermoon Terrace"] = "永月露臺"
L["Eversong Woods"] = "永歌森林"
L["Extras"] = "其他"
L["Eye of Azshara"] = "艾薩拉之眼"
L["Eye of the Storm"] = "暴風之眼"
L["Falanaar"] = "法拉納爾"
L["Fall of Deathwing"] = "死亡之翼的殞落"
L["Fall of the Lich King"] = "巫妖王之殞"
L["False"] = "虛假"
L["Faster auto loot"] = "加速自動拾取"
L["Faster movie skip"] = "快速動畫跳過"
L["Fate of the Horde"] = "部落的命運"
L["Features"] = "功能"
L["Felsoul Hold"] = "魔魂堡"
L["Felwood"] = "費伍德森林"
L["Feralas"] = "菲拉斯"
L["Find Item"] = "搜尋物品"
L["Firelands"] = "火源之界"
L["Forge of Souls"] = "眾魂熔爐"
L["Frames"] = "框架相關"
L["Freehold"] = "自由港"
L["Frostfire Ridge"] = "霜火峰"
L["Game Options"] = "游戲設置"
L["Gate of the Setting Sun"] = "落陽關"
L["Ghost"] = "靈魂狀態框架"
L["Ghostlands"] = "鬼魂之地"
L["Gnomeregan"] = "諾姆瑞根"
L["Gold Only"] = "僅輸入金幣"
L["Gorgrond"] = "格古隆德"
L["Graphics and Sound"] = "圖形和音效"
L["Grim Batol"] = "格瑞姆巴托"
L["Grimrail Depot"] = "恐軌車站"
L["Grizzly Hills"] = "灰白之丘"
L["Groups"] = "隊伍"
L["Gruul's Lair"] = "戈魯爾之巢"
L["Gul'dan Ascendant"] = "古爾丹支配"
L["Gul'dan's Plan"] = "古爾丹的計謀"
L["Gundrak"] = "剛德拉克"
L["Gundrak (rear entrance)"] = "剛德拉克（後方入口）"
L["Halls of Lightning"] = "雷光大廳"
L["Halls of Origination"] = "起源大廳"
L["Halls of Reflection"] = "倒影大廳"
L["Halls of Stone"] = "石之大廳"
L["Halls of Valor"] = "英靈殿"
L["Harbingers Gul'dan"] = "先知古爾丹"
L["Harbingers Illidan"] = "先知伊利丹"
L["Harbingers Khadgar"] = "先知卡德加"
L["Havenswood"] = "寧靜森林"
L["Heart of Fear"] = "恐懼之心"
L["Hellfire Citadel"] = "地獄火堡壘"
L["Hellfire Peninsula"] = "地獄火半島"
L["Hellfire Ramparts"] = "地獄火壁壘"
L["Hellscream's Downfall (Alliance)"] = "地獄吼的垮台（聯盟）"
L["Hellscream's Downfall (Horde)"] = "地獄吼的垮台（部落）"
L["Help"] = "幫助"
L["Hide alerts"] = "隱藏訊息提示"
L["Hide bodyguard gossip"] = "隱藏保鏢對話"
L["Hide boss banner"] = "隱藏BOSS橫幅"
L["Hide chat buttons"] = "隱藏聊天視窗按鈕"
L["Hide clean-up buttons"] = "隱藏背包整理按鈕"
L["Hide cooldown duration numbers (if enabled)"] = "隱藏冷卻持續時間數字(如果啟用)"
L["Hide crafted names"] = "隱藏製造者名稱"
L["Hide error messages"] = "隱藏錯誤訊息"
L["Hide gryphons"] = "隱藏動作條獅鷲"
L["Hide level-up display"] = "隱藏升級提示"
L["Hide order hall bar"] = "隱藏職業大廳條"
L["Hide portrait numbers"] = "隱藏頭像數字"
L["Hide social button"] = "隱藏社交按鈕"
L["Hide stance bar"] = "隱藏姿態條"
L["Hide talking frame"] = "隱藏對話框架"
L["Hide the clock"] = "隱藏時鐘"
L["Hide the combat log"] = "隱藏戰鬥記錄視窗"
L["Hide the zone text bar"] = "隱藏區域文字列"
L["Hide the zoom buttons"] = "隱藏縮放按紐"
L["Hide tooltips for world units during combat"] = "戰鬥中隱藏視窗"
L["Hide zone text"] = "隱藏區域文字"
L["Highmaul"] = "天槌"
L["Highmountain"] = "高嶺"
L["Highmountain Tauren"] = "高嶺牛頭人"
L["Hillsbrad Foothills"] = "希爾斯布萊德丘陵"
L["Hinterlands"] = "辛特蘭"
L["Home"] = "首頁"
L["Hour of Twilight"] = "暮光之時"
L["Howling Fjord"] = "凜風峽灣"
L["Hyjal Summit"] = "海加爾山之戰"
L["Icecrown"] = "寒冰皇冠"
L["Icecrown Citadel"] = "冰冠城寨"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "勾選後，一個按鈕會顯示在角色框架，其鼠標提示訊息會顯示身上的裝備耐久度。|n|n當你死後，你的整體耐久度也會顯示在聊天框架。"
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "勾選後，將會向所有密語你關鍵字INV的人發送組隊邀請。|n|n你需要尚未組隊或是你是自己隊伍的隊長才有作用。"
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "勾選後，一個全局音量控制桿會顯示在角色訊息視窗。|n|n這個音量控制可以在兩個位置之間切換，你可以按住SHIFT+鼠標右鍵進行切換。"
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "勾選後，小地圖按鈕將可使用。|n|n點擊 - 切換選項面板。|n|nSHIFT/左鍵點擊 - 切換音樂。|n|nSHIFT/右鍵點擊 - 切換碼表。|n|nCTRL/左鍵點擊 - 切換小地圖目標追蹤。|n|nCTRL/右鍵點擊 - 切換錯誤顯示(如果已啟用)。|n|nCTRL/SHIFT/左鍵點擊 - 切換Zygor(如果已安裝)。|n|nCTRL/SHIFT/右鍵點擊 - 切換視窗模式。"
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction price type and duration settings will be saved account-wide."] = "勾選後，拍賣場將會加入額外的功能。|n|n僅限直購價 - 建立直購拍賣無須填入起始價格。|n|n僅輸入金幣 - 設定銅幣與銀幣價格為99以加速建立新拍賣。|n|n搜尋物品 - 在拍賣場中搜尋你銷售的物品。|n|n此外，拍賣價格類型和持續時間將為帳戶共通設置保存。"
L["If checked, additional functionality will be added to the dressup frame.|n|nNude and tabard toggle buttons will be added, model positioning controls will be removed and special model animations will be disabled."] = "勾選後，額外功能會加入試衣框架。|n|n將新增裸體與外袍切換按鈕，模組定位控制將被移除並且會停用特殊模型動畫。"
L["If checked, alert frames will not be shown."] = "勾選後，警告框架將不會顯示。"
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問商販時將自動出售背包中的垃圾。|n|n當你訪問時按住Shift鍵，可以暫時忽略該功能。"
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "勾選後，訊息視窗的邊框會更改為藍色（友方）或者紅色（敵方）。"
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "勾選後，自動召喚的戰寵將在幾秒內被解散。|n|n這包含了拖曳寵物到寵物日誌第一個隊伍空格以及輸入一個戰寵隊伍儲存指令。|n|n注意在戰鬥中自動召喚的寵物會在戰鬥結束後被解散。"
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "勾選後，戰網好友邀請會自動拒絕。|n|n啟用後，當前待處理的邀請會自動拒絕。"
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "勾選後，聊天視窗的按鈕會被隱藏。|n|n點擊視窗標簽會自動顯示最新的消息。|n|n使用鼠標滾輪可以查看歷史訊息。按住SHIFT進行訊息頁面跳轉，按住CTRL將滾動至訊息頁首/頁尾。"
L["If checked, chat text will not fade out after a time period."] = "勾選後，聊天訊息不會在一定時間後淡出。"
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "勾選後，職業著色將使用在玩家框架、目標框架以及焦點目標框架上。"
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "勾選後，當你選擇一個擲骰選項或是試圖出售或郵寄可交易物品將不再確認。"
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "勾選後，即使有低等級角色在隊伍中也可以成功轉成團隊。|n|n隊伍中的每個人都需要安裝Leatrix Plus並啟用此選項。"
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "勾選後，冷卻持續時間數字將不顯示在冷卻上。|n|n取消勾選後，冷卻持續時間數字將會顯示在冷卻上如果已在遊戲選項面板中啟用('動作條'選單)。"
L["If checked, crafted items will no longer show the name of the crafter."] = "勾選後，製造物品將不再顯示製造者名稱"
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "勾選後，在玩家頭像和寵物頭像上的傷害及治療數字不再顯示。"
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "勾選後，對鎖定的聊天視窗進行拖動，會使其豎直拉伸。|n|n對已解鎖的聊天視窗進行拖動，會使其移動。"
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾選後，對於非好友與公會成員的決鬥請求會被封鎖。"
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "勾選後，表情音效將被靜音當你的角色處於：|n|n- 休息區|n- 寵物戰鬥中|n- 半丘市集|n- 黑鐵酒吧|n|n當不處於上述區域時表情音效將會啟用。"
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "勾選後，敵對姓名板會在戰鬥中自動開啟，離開戰鬥後關閉。"
L["If checked, guild ranks will be shown for players in your guild."] = "勾選後，顯示公會會階。"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "勾選後，大部分錯誤訊息將不顯示(像是'沒有足夠的怒氣')。部分重要錯誤將排除在外。|n|n如果你有啟用小地圖按鈕，你可以按下CTRL+右鍵來切換錯誤訊息的顯示而不管此設置。"
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "勾選後，如果你不在地下城佇列中，你的好友或公會成員發送的組隊邀請會被自動接受。"
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "勾選後，對於非好友與公會成員的組隊邀請會被封鎖。"
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "勾選後，對於非好友與公會成員的寵物對戰請求會被封鎖。"
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "勾選後，在你登入階段專業技能過濾設置將會保存剩餘的部分。"
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "勾選後，任務將會自動選擇、接受、與回覆。|n|n那些需求金錢、貨幣或製造材料的任務不會自動回覆。|n|n您可以在與任務交付者對話時按下Shift鍵以無視此設置。"
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "勾選後，團隊和副本聊天訊息會改為藍色（與小隊一致）。"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "勾選後，有加入公會並有權限修理的角色，修理花費會從公會資金支出。"
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "勾選後，如果小隊隊長是你的好友或公會成員，其地城搜尋器的加入請求會被自動接受。|n|n這個選項需要你在地城搜尋器中選擇一個職責。"
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "勾選後，只要復活你的玩家不在戰鬥中，復活請求將被自動接受。|n|n覺醒火盆或滅團偵測塔的復活請求不會自動接受。"
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "勾選後，位於增益框架與目標框架之下的增益圖標提示會顯示法術ID。"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "勾選後，會停用聊天頻道的粘附。|n|n此選項不會影響臨時視窗的對話。"
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "勾選後，當你不處於戰鬥狀態時會自動接受召喚。"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "勾選後，插件列表（游戲選單處）會顯示預設的對角色生效的插件。"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "勾選後，自動拾取所需的時間將大幅減少。"
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "勾選後，背包及銀行的整理按鈕不再顯示。"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "勾選後，BOSS的橫幅訊息不再顯示。|n|n該訊息通常在BOSS被擊敗後顯示。它顯示BOSS的名字以及掉落。"
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "勾選後，打開團隊訊息的按鈕會顯示在左側團隊管理框架的上方，而不是在其內部。|n|n此選項讓你無需打開團隊管理框架，就可以切換團隊框架。"
L["If checked, the clock will be hidden."] = "勾選後，時鐘將會隱藏。"
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "勾選後，戰鬥記錄會被隱藏。|n|n戰鬥記錄視窗必須未被分離時才能生效。|n|n如果戰鬥記錄視窗被分離了，你可以拖動其合併至主視窗（然後重載插件），或者在聊天設置中重置設置。"
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "勾選後，“對他人只顯示角色成就”的選項（介面-社交）會被永久勾選並鎖定。"
L["If checked, the editbox will be moved to the top of the chat frame."] = "勾選後輸入框會被移動至聊天視窗上方。"
L["If checked, the game world will be resized to fit between the top and bottom borders.|n|nNote that if you enable this setting, the transparency slider will no longer affect the top and bottom borders."] = "勾選後，游戲介面的大小會修改以適應頂部和底部的邊框。|n|n當你啟用這個選項時，透明度的調節不再影響這兩個邊框。"
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "勾選後，你的保鏢對話時不再出現選項。|n|n對話時按住Shift鍵，可以暫時忽略該項設置。"
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "勾選後，死亡後的灰色螢幕以及靈魂世界特效將會停用。"
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "勾選後，升級提示不再顯示。|n|n升級提示功能包括副本目標、升級、小寵物獎勵等等。"
L["If checked, the main bar gryphons will not be shown."] = "勾選後，動作條兩邊的獅鷲不再顯示。"
L["If checked, the order hall command bar will not be shown."] = "勾選後，職業大廳控制條將不顯示。"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "勾選後，螢幕光暈將停用。|n|n啟用此選項同時也停用醉酒霧霾效果。"
L["If checked, the social button and quick-join notification will be hidden."] = "勾選後，社交按鈕與快速加入提醒將會隱藏。"
L["If checked, the stance bar will not be shown."] = "勾選後，姿態條不再顯示。"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "勾選後，對話面板不再顯示。|n|n當NPC與你交流時，該框架通常出現在界面下方。"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "勾選後，提示訊息會被著色，你可以設置他的佈局和大小尺寸。"
L["If checked, the tracking button will be merged with the calendar button.|n|nLeft-click the tracking button to show the tracking menu or right-click it to show the calendar."] = "勾選後，追蹤按鈕將與行事曆按鈕整合。|n|n左鍵點擊追蹤按紐顯示追蹤選單，或右鍵點擊顯示行事曆。"
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "勾選後，區域文字列將隱藏。追蹤按鈕提示將顯示區域資訊。"
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "勾選後，縮放按鈕將隱藏。無論此設置如何，您都可以使用滑鼠滾輪進行縮放。"
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "勾選後，目標的訊息視窗在戰鬥中會被隱藏。|n|n你可以按住SHIFT鍵暫時忽略這個設置。"
L["If checked, unit targets will be shown."] = "勾選後，目標的目標會顯示在訊息視窗上。"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "勾選後，Wowhead連結將會顯示在世界地圖視窗與成就視窗。"
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "勾選後，你可以在開啟對話視窗時按下Alt鍵來自動選擇單個的對話選項。"
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "勾選後，你可以在點擊聊天標籤時按下Ctrl鍵，在易於複製的視窗中查看最近的聊天。"
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "勾選後，你可以透過按下CTRL+Z來開啟Leatrix Plus。"
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "勾選後，你可以使用方向鍵移動聊天框中的輸入點。|n|n如果未被勾選，方向鍵將保持它所綁定的按鍵功能。"
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "勾選後，你可以取消動畫而不經確認。"
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "勾選後，你可以更改任務訊息文字的字體大小。|n|n啟用這個選項也會影響使用同一文字模版的框架（例如地城搜尋器）。"
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "勾選後，你可以更改郵件文字的字體大小。|n|n這個選項不會影響使用系統範本的郵件（例如拍賣行的收據訊息）。"
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Buffs frame|n- Widget top center frame|n- Ghost frame|n- Timer bar|n- Player power bar"] = "勾選後，您將能夠更改以下框架的位置與大小：|n|n- 玩家框架|n- 目標框架|n- 增益框架|n- 頂部中央部件框架|n- 靈魂框架|n- 計時條|n- 玩家能量條"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "勾選後，你會生成一個視窗背景，這個可以在游戲界面周圍增加黑色的邊框背景。|n|n邊框的層級是處於游戲界面和插件之間，所以你仍可以放置插件元素在上面。"
L["If checked, you will be able to customise the minimap."] = "勾選後，您將可以自定義小地圖。"
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "勾選後，你可以把聊天視窗拖動到屏幕邊緣。"
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "勾選後，你可以在目標框架上放置最多5個有用的冷卻圖標。"
L["If checked, you will be able to reposition the tooltip."] = "勾選後，您可以重新定位工具提示。"
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "勾選後，你可以利用一個單獨的指令儲存你當前戰寵的隊伍(包含技能)。|n|n寵物日誌將會加入新的按鈕。點擊該按鈕將切換顯示您當前隊伍的分配指令。按下Ctrl+C就會複製此指令到記憶體中。|n|n你可以貼上此指令(用Ctrl+V)到聊天視窗或巨集中以立即指派你的隊伍。"
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "勾選後，會在玩家框架顯示稀有、精英或者稀有精英的邊框。"
L["If checked, you will be able to zoom out to a greater distance."] = "勾選後，你可以將鏡頭拉遠到更遠的距離。"
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "勾選後，如果你死在阿斯蘭、托巴拉德、冬握湖或任何戰場，將會自動釋放靈魂。n|n如果你有辦法自我復活(靈魂石、復生等)，則不會自動釋放。"
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "勾選後，當你打開商店、銀行或者郵箱時，背包不會自動開啟或者關閉。"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "勾選後，你的聊天歷史記錄會增漲至4096行。如果未被勾選，會保持在預設的128行。|n|n啟用這個設置可能會在登錄時會隱藏一些聊天訊息。"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "勾選後，當你訪問適用的商店時，裝備將自動修理。|n|n當你開啟商店時可以按下Shift鍵以無視此設置。"
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "勾選後，區域文字不再顯示。"
L["Increase chat history"] = "增加聊天歷史記錄"
L["Interface"] = "界面設置"
L["Into the Portal"] = "進入傳送門"
L["Invalid battle pet team parameter."] = "無效的戰寵隊伍參數。"
L["Invalid console variable."] = "無效控制台變量。"
L["Invalid parameter."] = "無效參數"
L["Invalid quest ID."] = "無效任務ID。"
L["Invalid sound ID"] = "無效聲音ID"
L["Invalid taint level."] = "無效的汙染等級。"
L["Invalid target."] = "無效的目標。"
L["Invite from whispers"] = "密語邀請"
L["Iron Docks"] = "鋼鐵碼頭"
L["Ironforge"] = "鐵爐堡"
L["Island Expeditions"] = "島嶼探險"
L["Isle of Conquest"] = "征服之島"
L["Isle of Quel'Danas"] = "奎爾達納斯之島"
L["Isle of Thunder"] = "雷王島"
L["Jade Forest"] = "翠玉林"
L["Jade Forest Crash"] = "墜毀翠玉林"
L["Jaina Joins the Battle"] = "珍娜加入戰鬥"
L["Jaina Returns to Kul Tiras"] = "珍娜返回庫爾提拉斯"
L["Jaina's Nightmare"] = "珍娜的夢魘"
L["Jaina's Siege"] = "珍娜的進攻"
L["Jaina's Theme"] = "珍娜主題"
L["Jorundall"] = "尤倫達爾"
L["Kalimdor"] = "卡林多"
L["Karazhan"] = "卡拉贊"
L["Kezan"] = "凱贊"
L["Kil'jaeden's Downfall"] = "基爾加丹的垮台"
L["Kings' Rest"] = "諸王之眠"
L["Krasarang Wilds"] = "喀撒朗蠻荒"
L["Krokuun (Argus)"] = "克庫恩（阿古斯）"
L["Kul Tiran Humans"] = "庫爾提拉斯人"
L["Kul Tiras"] = "庫爾提拉斯"
L["Kun-Lai Summit"] = "崑萊峰"
L["Last Stand"] = "背水一戰"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus將會在下次登出時覆寫LeaPlus數據庫。"
L["Leaving Kezan"] = "離開凱贊"
L["Leaving the Wandering Isle"] = "離開漂流島"
L["Left"] = "左側"
L["Legion"] = "軍臨天下"
L["Lifetime honorable kills"] = "榮譽擊殺總數"
L["Lightforged Draenei"] = "光鑄德萊尼"
L["Lion's Watch"] = "雄獅堡"
L["Loch Modan"] = "洛克莫丹"
L["Lockout sharing"] = "成就共享鎖定"
L["Lost City of the Tol'vir"] = "托維爾的失落之城"
L["Lost Isles"] = "失落群島"
L["Lower Blackrock Spire"] = "黑石塔下層"
L["Lunastre Estate"] = "路納斯特莊園"
L["Mac'Aree (Argus)"] = "麥克艾瑞（阿古斯）"
L["Madness of Deathwing"] = "死亡之翼的狂亂"
L["Maelstrom"] = "大漩渦"
L["Mag'har Orcs"] = "瑪格哈獸人"
L["Magisters' Terrace"] = "博學者殿堂"
L["Magtheridon's Lair"] = "瑪瑟里頓的巢穴"
L["Mail Text"] = "郵件文字"
L["Main Titles"] = "主標題"
L["Manage frames"] = "管理框架面板"
L["Manage tooltip"] = "管理提示訊息"
L["Managed by Leatrix Plus"] = "由Leatrix Plus管理"
L["Mana-Tombs"] = "法力墓地"
L["Maraudon"] = "瑪拉頓"
L["Maraudon: Earth Song Falls"] = "瑪拉頓：毒水瀑布"
L["Maraudon: Foulspore Cavern"] = "瑪拉頓：毒菇洞穴"
L["Maraudon: The Wicked Grotto"] = "瑪拉頓：邪惡洞穴"
L["Mardum"] = "馬爾頓"
L["Maw of Souls"] = "靈魂之喉"
L["Max camera zoom"] = "最大鏡頭縮放"
L["Mechanics"] = "特性設置"
L["Media"] = "音樂"
L["Memory Usage"] = "記憶體占用"
L["Merge the tracking and calendar buttons"] = "整合追蹤與行事曆按紐"
L["message shown."] = "顯示訊息。"
L["messages shown."] = "顯示訊息。"
L["Minimap"] = "小地圖"
L["Missing console variable."] = "缺少控制台變量。"
L["Missing mount name."] = "缺少坐騎名稱。"
L["Missing movie ID."] = "缺少動畫ID。"
L["Missing pet name."] = "缺少寵物名稱。"
L["Missing quest ID."] = "缺少任務ID。"
L["Missing sound file parameter."] = "缺少聲音檔案參數。"
L["Missing sound ID."] = "缺少聲音ID。"
L["Mists of Pandaria"] = "潘達利亞之謎"
L["Mogu'shan Palace"] = "魔古山宮"
L["Mogu'shan Vaults"] = "魔古山寶庫"
L["Molten Core"] = "熔火之心"
L["Moon Guard Stronghold"] = "月之守衛要塞"
L["Moonglade"] = "月光林地"
L["Motherlode"] = "母親大人"
L["Mount Hyjal"] = "海加爾山"
L["Mount not found."] = "坐騎未找到。"
L["Move editbox to top"] = "輸入框移動至頂部"
L["Movie not playable."] = "動畫不可播放。"
L["Movie number"] = "動畫編號"
L["Movies"] = "動畫"
L["Mulgore"] = "莫高雷"
L["Music"] = "音樂"
L["Music Rolls"] = "音樂曲單"
L["My Very Own Castle (Alliance)"] = "我自己的城堡（聯盟）"
L["My Very Own Castle (Horde)"] = "我自己的城堡（部落）"
L["Mystical"] = "神秘"
L["Nagrand"] = "納葛蘭"
L["Nagrand (Draenor)"] = "納葛蘭 (德拉諾)"
L["Narration"] = "旁白"
L["Naxxramas"] = "納克薩瑪斯"
L["Nazmir"] = "納茲米爾"
L["Neltharion's Lair"] = "奈薩里奧巢穴"
L["Netherstorm"] = "虛空風暴"
L["Nexus"] = "奧核之心"
L["Nightborne"] = "夜裔精靈"
L["Nighthold"] = "暗夜堡"
L["No bad sound IDs found."] = "沒有發現損壞的聲音ID。"
L["No help is available for this page."] = "此頁面沒有幫助訊息。"
L["No items with durability equipped."] = "沒有裝備有耐久度的物品。"
L["No media duplicates found."] = "未找到重複的媒體檔。"
L["No tooltip showing."] = "目前沒有任何提示訊息。"
L["None"] = "無"
L["Northern Barrens"] = "北貧瘠之地"
L["Northern Stranglethorn"] = "北荊棘谷"
L["Northrend"] = "北裂境"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "警示！|n您必須完全重新啟動遊戲客戶端才能使用此版本的Leatrix Plus。"
L["Nude"] = "脫光"
L["Obsidian Sanctum"] = "黑曜聖所"
L["Old Hillsbrad Foothills"] = "希爾斯布萊德丘陵舊址"
L["Onyxia's Lair"] = "奧妮克希亞的巢穴"
L["Orgrimmar"] = "奧格瑪"
L["Outland"] = "外域"
L["Overall"] = "整體"
L["Pandaria"] = "潘達利亞"
L["Particle density"] = "粒子密度"
L["Party from friends"] = "好友組隊邀請"
L["Pet"] = "寵物"
L["Pet Battles"] = "寵物戰鬥"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "寵物未找到。只有顯示在寵物日誌中已收集的寵物才能搜尋。"
L["Pit of Saron"] = "薩倫之淵"
L["Plants vs Zombies"] = "植物大戰殭屍"
L["Player"] = "玩家框架"
L["Player Chain"] = "玩家邊框"
L["Portal"] = "傳送門"
L["Power"] = "能量"
L["Power of the Horde"] = "部落的力量"
L["Press CTRL/C to copy."] = "按下CTRL/C來複製。"
L["Quest completed."] = "任務完成。"
L["Quest not completed."] = "任務未完成。"
L["Quest Text"] = "任務訊息文字"
L["Queue from friends"] = "好友佇列申請"
L["Ragefire Chasm"] = "怒焰裂谷"
L["Raid"] = "團隊副本"
L["Raid frame toggle"] = "切換團隊框架"
L["Random"] = "隨機"
L["RARE"] = "稀有"
L["RARE ELITE"] = "稀有精英"
L["Razorfen Downs"] = "剃刀高地"
L["Razorfen Kraul"] = "剃刀沼澤"
L["Realm Of Torment"] = "折磨的國度"
L["Recent chat window"] = "最近聊天視窗"
L["Redridge Mountains"] = "赤脊山"
L["Reincarnation of Alleria Windrunner"] = "艾蘭里亞‧風行者的再生"
L["Rejection of the Gift"] = "拒絕饋贈"
L["Release in PvP"] = "PvP自動釋放屍體"
L["Reload"] = "重載插件"
L["Remove raid restrictions"] = "移除團隊等級限制"
L["Repair Automatically"] = "自動修理"
L["Repair automatically"] = "自動修理裝備"
L["Repair using guild funds if available"] = "修理使用公會資金(如果可用)"
L["Repaired for"] = "修理花費"
L["Reposition the tooltip"] = "重新定位工具提示"
L["Requires UI reload."] = "需要重載插件"
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "需要你與拉蕾娜．德羅姆互動，她可以在北裂境的達拉然的雕銘師禮拜堂中找到。"
L["Reset"] = "重置"
L["Resize mail text"] = "重設郵件文字"
L["Resize quest text"] = "重設任務文字"
L["Resize Screen"] = "螢幕縮放"
L["Resize the game world"] = "遊戲介面縮放"
L["Rested bubbles"] = "休息氣泡訊息"
L["result"] = "結果"
L["results"] = "結果"
L["Return to Karazhan"] = "重返卡拉贊"
L["Return to the Black Temple"] = "重返黑暗神廟"
L["Rev"] = "揭露"
L["Right"] = "右側"
L["Right-click to close"] = "右鍵點擊來關閉"
L["Right-click to close."] = "右鍵點擊來關閉。"
L["right-click to go back"] = "右鍵點擊返回"
L["Rise of Argus"] = "阿古斯的崛起"
L["Risking It All"] = "孤注一擲"
L["Ruby Sanctum"] = "晶紅聖所"
L["Ruins of Ahn'Qiraj"] = "安琪拉廢墟"
L["Ruins of Elune'eth"] = "伊露恩斯遺址"
L["Ruins of Gilneas"] = "吉爾尼斯廢墟"
L["Sanctum of Order"] = "秩序聖所"
L["Save profession filters"] = "保存專業技能過濾"
L["Scale"] = "尺寸"
L["Scarlet Halls"] = "血色大廳"
L["Scarlet Monastery"] = "血色修道院"
L["Scholomance"] = "通靈學院"
L["Search"] = "搜尋"
L["Searing Gorge"] = "灼熱峽谷"
L["Seat of the Triumvirate"] = "三傑議會之座"
L["Select the settings that you want to use."] = "選擇你想啟用的設置。"
L["Selection of music tracks"] = "選擇的音樂曲目"
L["Self Markers Allowed"] = "允許自身標記"
L["Self Markers Blocked"] = "阻擋自身標記"
L["Sell junk automatically"] = "自動出售垃圾"
L["SELLING JUNK"] = "出售垃圾"
L["Serpentshrine Cavern"] = "毒蛇神殿洞穴"
L["Sethekk Halls"] = "塞司克大廳"
L["Settings"] = "設置"
L["Shaders"] = "陰影"
L["Shado-Pan Monastery"] = "影潘僧院"
L["Shadow Labyrinth"] = "暗影迷宮"
L["Shadowfang Keep"] = "影牙城堡"
L["Shadowmoon Burial Grounds"] = "影月墓地"
L["Shadowmoon Valley"] = "影月谷"
L["Shadowmoon Valley (Draenor)"] = "影月谷 (德拉諾)"
L["Shipyard Construction (Alliance)"] = "船塢建設（聯盟）"
L["Shipyard Construction (Horde)"] = "船塢建設（部落）"
L["Sholazar Basin"] = "休拉薩盆地"
L["Show auction controls"] = "顯示拍賣行控制"
L["Show character addons"] = "顯示角色插件"
L["Show cooldowns"] = "顯示冷卻"
L["Show durability status"] = "顯示耐久度"
L["Show guild ranks for your guild"] = "顯示會階"
L["Show minimap button"] = "顯示小地圖按鈕"
L["Show pet save button"] = "顯示寵物儲存按鈕"
L["Show player chain"] = "顯示玩家邊框"
L["Show the spell ID in buff icon tooltips"] = "在增益圖標提示顯示法術ID"
L["Show the unit's target"] = "顯示目標的目標"
L["Show volume slider"] = "顯示音量控制"
L["Show Wowhead links"] = "顯示Wowhead連結"
L["Shrine of the Storm"] = "風暴聖壇"
L["Siege of Boralus"] = "波拉勒斯圍城戰"
L["Siege of Niuzao Temple"] = "圍攻怒兆寺"
L["Siege of Orgrimmar"] = "圍攻奧格瑪"
L["Silence rested emotes"] = "表情靜音"
L["Silithus"] = "希利蘇斯"
L["Silverpine Forest"] = "銀松森林"
L["Silvershard Mines"] = "碎銀礦坑"
L["Skyreach"] = "擎天峰"
L["Slave Pens"] = "奴隸監牢"
L["Social"] = "社交訊息"
L["Sold junk for"] = "賣出垃圾為"
L["Sound system restarted."] = "聲音系統已重啟。"
L["Southern Barrens"] = "南貧瘠之地"
L["Spell ID"] = "法術ID"
L["Spine of Deathwing"] = "死亡之翼的脊背"
L["Spires of Arak"] = "阿拉卡山"
L["Steamvault"] = "蒸氣洞窟"
L["Stockade"] = "暴風城監獄"
L["Stonecore"] = "石岩之心"
L["Stonetalon Mountains"] = "石爪山脈"
L["Stop"] = "停止"
L["Storm Peaks"] = "風暴群山"
L["Stormheim"] = "斯鐸海姆"
L["Stormheim (Alliance)"] = "斯鐸海姆 (聯盟)"
L["Stormheim (Horde)"] = "斯鐸海姆 (部落)"
L["Stormsong Valley"] = "風歌谷地"
L["Stormstout Brewery"] = "風暴烈酒酒坊"
L["Stormwind"] = "暴風城"
L["Strand of the Ancients"] = "遠祖灘頭"
L["Stratholme"] = "斯坦索姆"
L["Stratholme: Crusader's Square"] = "斯坦索姆：十字軍廣場"
L["Stratholme: The Gauntlet"] = "斯坦索姆：The Gauntlet"
L["Sunken Temple"] = "沉沒的神廟"
L["Sunwell Plateau"] = "太陽之井高地"
L["Support"] = "支援"
L["Suramar"] = "蘇拉瑪爾"
L["Swamp of Sorrows"] = "悲傷沼澤"
L["System"] = "系統設置"
L["Tabard"] = "隱藏戰袍"
L["Taint level: Basic (1)."] = "汙染等級：基本(1)"
L["Taint level: Disabled (0)."] = "汙染等級：停用(0)"
L["Taint level: Full (2)."] = "汙染等級：完整(2)"
L["Talador"] = "塔拉多爾"
L["Tanaan Jungle"] = "塔南森林"
L["Tanaris"] = "塔納利斯"
L["Target"] = "目標框架"
L["Target Tracking Disabled"] = "停用目標追蹤"
L["Target Tracking Enabled"] = "啟用目標追蹤"
L["Tea with Jaina"] = "與珍娜喝茶"
L["Tel'anor"] = "泰爾亞諾"
L["Teldrassil"] = "泰達希爾"
L["Tempest Keep"] = "風暴要塞"
L["Temple of Ahn'Qiraj"] = "安琪拉神廟"
L["Temple of Atal'Hakkar"] = "阿塔哈卡神廟"
L["Temple of Kotmogu"] = "科特魔古神廟"
L["Temple of Sethraliss"] = "瑟沙利斯神廟"
L["Temple of the Jade Serpent"] = "玉蛟寺"
L["Ten Years of Warcraft"] = "魔獸十周年"
L["Terokkar Forest"] = "泰洛卡森林"
L["Terrace of Endless Spring"] = "豐泉台"
L["Terror of Darkshore"] = "黑海岸之懼"
L["Text"] = "文字訊息"
L["Text size"] = "字體尺寸"
L["Text Size"] = "字體尺寸"
L["The Arcatraz"] = "亞克崔茲"
L["The Art of War"] = "戰爭的藝術"
L["The Bastion of Twilight"] = "暮光堡壘"
L["The Battle for Broken Shore"] = "破碎群島之戰"
L["The Battle for Shattrath"] = "撒塔斯之戰"
L["The Battle of Thunder Pass"] = "雷霆王座之戰"
L["The Black Morass"] = "黑色沼澤"
L["The Blood Furnace"] = "血熔爐"
L["The Botanica"] = "波塔尼卡"
L["The Burning Crusade"] = "燃燒的遠征"
L["The Culling of Stratholme"] = "斯坦索姆的抉擇"
L["The Deadmines"] = "死亡礦坑"
L["The Demon's Trail"] = "惡魔的蹤跡"
L["The Dragon Soul"] = "巨龍之魂"
L["The Everbloom"] = "永茂林"
L["The Eye"] = "風暴要塞"
L["The Eye of Eternity"] = "永恆之眼"
L["The Fall of Lordaeron"] = "羅德隆的淪陷"
L["The Fate of Val'sharah"] = "維爾薩拉的命運"
L["The Fleet in Krasarang (Alliance)"] = "喀撒朗的艦隊（聯盟）"
L["The Fleet in Krasarang (Horde)"] = "喀撒朗的艦隊（部落）"
L["The Forge of Souls"] = "眾魂熔爐"
L["The Frozen Halls"] = "冰封大廳"
L["The Halls of Reflection"] = "鏡像大廳"
L["The Invasion Begins"] = "入侵開始"
L["The King's Command"] = "國王的徵招"
L["The Mechanar"] = "麥克納爾"
L["The Nexus"] = "奧核之心"
L["The Nightborne Pact"] = "夜裔的協議"
L["The Nighthold"] = "暗夜堡"
L["The Obsidian Sanctum"] = "黑曜聖所"
L["The Oculus"] = "奧核之眼"
L["The Old Kingdom"] = "古王國"
L["The Pit of Saron"] = "薩隆陷坑"
L["The Return of Hope"] = "希望回歸"
L["The Ruby Sanctum"] = "晶紅聖所"
L["The Shattered Halls"] = "破碎大廳"
L["The Stockade"] = "監獄"
L["The Stonecore"] = "石岩之心"
L["The Violet Hold"] = "紫羅蘭堡"
L["The Vortex Pinnacle"] = "漩渦尖塔"
L["The Waning Crescent"] = "弦月旅店"
L["Themes"] = "主題"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "此指令會指派你當前的戰寵隊伍並選擇技能。|n|n按下Ctrl+C來複製，然後用Ctrl+V貼上到聊天視窗或是巨集中。"
L["This panel will close automatically if you enter combat."] = "此面板將在你進入戰鬥後自動關閉。"
L["Thousand Needles"] = "千針石林"
L["Throne of the Four Winds"] = "四風王座"
L["Throne of the Tides"] = "海潮王座"
L["Throne of Thunder"] = "雷霆王座"
L["Thunder Bluff"] = "雷霆崖"
L["Timeless Isle"] = "永恆島"
L["Timer"] = "計時框架"
L["Tiragarde Sound"] = "提拉加德海灣"
L["Tirisfal Glades"] = "提里斯法林地"
L["To begin, choose an options page."] = "請選擇一個選項開始使用"
L["To use the Find Item button, you need to deselect the WoW Token category."] = "要使用此搜尋物品按鈕，您需要取消選擇WoW的代幣類別"
L["Tol Barad"] = "托巴拉德"
L["Tol Dagor"] = "托達戈爾"
L["Tomb of Sargeras"] = "薩格拉斯之墓"
L["Tooltip"] = "提示訊息"
L["Tooltip title color"] = "鼠標提示訊息顏色。"
L["Top"] = "頂部"
L["Top Center"] = "頂級中心"
L["Townlong Steppes"] = "螳螂荒原"
L["Tracing started."] = "追蹤已開始。"
L["Tracing stopped."] = "追蹤已停止。"
L["Transparency"] = "透明度"
L["Trial of Style"] = "造型選拔賽"
L["Trial of the Champion"] = "勇士試煉"
L["Trial of the Crusader"] = "十字軍試煉"
L["Trial of Valor"] = "勇氣試煉"
L["True"] = "真實"
L["Twilight Highlands"] = "暮光高地"
L["Twilight Vineyards"] = "暮光葡萄園"
L["Twin Peaks"] = "雙子峰"
L["Uldaman"] = "奧達曼"
L["Uldir"] = "奧迪爾"
L["Ulduar"] = "奧杜亞"
L["Uldum"] = "奧丹姆"
L["Unclamp chat frame"] = "不限制視窗位置"
L["Underbog"] = "幽暗沼澤"
L["Undercity"] = "幽暗城"
L["Underrot"] = "幽腐深窟"
L["Un'Goro Crater"] = "安戈洛環形山"
L["Universal group color"] = "通用的隊伍著色"
L["Upper Blackrock Spire"] = "黑石塔上層"
L["Use arrow keys in chat"] = "允許使用方向鍵"
L["Use easy resizing"] = "使用簡單拉伸"
L["Use Leatrix Plus to move that frame."] = "使用Leatrix Plues來移動框架"
L["Use Leatrix Plus to reset that frame."] = "使用Leatrix Plues來重置框架"
L["Utgarde Keep"] = "俄特加德要塞"
L["Utgarde Pinnacle"] = "俄特加德之巔"
L["Vale of Eternal Blossoms"] = "永茂林谷地"
L["Valley of the Four Winds"] = "四風峽"
L["Val'sharah"] = "維爾薩拉"
L["Value must be a number."] = "值必須為數字。"
L["Various"] = "雜項"
L["Vashj'ir"] = "瓦許伊爾"
L["Vault of Archavon"] = "亞夏梵穹殿"
L["Vault of the Wardens"] = "看守者鐵獄"
L["Vendors"] = "商店"
L["Version"] = "版本"
L["Victory at The Nighthold"] = "暗夜堡的勝利"
L["Victory in Draenor!"] = "德拉諾的勝利！"
L["Video"] = "影像"
L["Viewport"] = "視窗背景"
L["Violet Hold"] = "紫羅蘭堡"
L["Visibility"] = "可見性"
L["Vision of Sailor's Memory"] = "水手回憶的想像"
L["Void Elves"] = "虛空精靈"
L["Vol'dun"] = "沃魯敦"
L["Vol'mar"] = "沃爾瑪"
L["Wailing Caverns"] = "哀嚎洞穴"
L["Wandering Isle"] = "漂流島"
L["Warbringers Azshara"] = "戰爭使者艾薩拉"
L["Warbringers Jaina"] = "戰爭使者 珍娜"
L["Warbringers Sylvanas"] = "戰火之源：希瓦娜斯"
L["Warfronts"] = "戰爭前線"
L["Warlords of Draenor"] = "德拉諾之霸"
L["Warsong Gulch"] = "戰歌峽谷"
L["was automatically declined."] = "已經自動拒絕。"
L["Waycrest Manor"] = "威奎斯特莊園"
L["Weather density"] = "天氣密度"
L["Welcome to Leatrix Plus."] = "歡迎使用Leatrix Plus"
L["Well of Eternity"] = "永恆之井"
L["Western Plaguelands"] = "西瘟疫之地"
L["Westfall"] = "西部荒野"
L["Wetlands"] = "濕地"
L["Widget"] = "窗口小部件"
L["Winter"] = "寒冬"
L["Wintergrasp"] = "冬握湖"
L["Winterspring"] = "冬泉谷"
L["World of Warcraft"] = "魔獸世界"
L["Wrath of the Lich King"] = "巫妖王之怒"
L["Wyrmrest Temple"] = "龍眠神殿"
L["YOU"] = "你"
L["You cannot do that in combat."] = "你無法在戰鬥中進行該項操作。"
L["You do not own this pet.  Only owned pets can be searched."] = "你未擁有此寵物。只有已收集的寵物能被搜尋。"
L["You have"] = "你有"
L["You need a battle pet team."] = "你需要一個戰寵隊伍。"
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "你需要進行重載插件後才能使部分設置生效。|n|n你無需立即點擊重載插件按鈕，但是你完成設置並希望其生效時，必須點擊它。"
L["Your UI needs to be reloaded."] = "你的插件需要重新載入。"
L["Zandalar"] = "贊達拉"
L["Zandalari Trolls"] = "贊達拉食人妖"
L["Zangarmarsh"] = "贊格沼澤"
L["Zones"] = "區域"
L["Zul'Aman"] = "祖阿曼"
L["Zuldazar"] = "祖達薩"
L["Zul'Drak"] = "祖爾德拉克"
L["Zul'Farrak"] = "祖爾法拉克"
L["Zul'Gurub"] = "祖爾格拉布"
L["Zygor addon not found."] = "你尚未安裝Zygor插件。"

end

-- ruRU: Russian
if GameLocale == "ruRU" then
L["A Falling Star"] = "Падающая звезда"
L["A Found Memento"] = "Памятная вещь"
L["A friend request from"] = "Запрос дружбы от"
L["A New Life for Undeath"] = "Новая жизнь нежити"
L["A Taste of Iron"] = "Вкус железа"
L["Accept resurrection"] = "Подтверждать восркешение"
L["Accept summon"] = "Подтверждать призыв"
L["Account achievements are being shared."] = "Достижения на учетную запись могут быть доступны другим персонажам."
L["Account achievements are hidden."] = "Достижения на учетную запись скрыты."
L["Addon"] = "Модификация"
L["Adventure"] = "Приключение"
L["Ahn'kahet (Old Kingdom)"] = "Ан'кахет (Старое Королевство)"
L["All 3 battle pet slots need to be unlocked."] = "Все 3 слота питомцев должны быть разблокированы."
L["Allied Races"] = "Союзные расы"
L["Alterac Valley"] = "Альтеракская долина"
L["And Justice for Thrall"] = "Правосудие для Тралла"
L["Antoran Wastes (Argus)"] = "Пустоши Анторуса (Аргуса)"
L["Antorus, the Burning Throne"] = "Анторус, Пылающий Трон"
L["Arathi Basin"] = "Низина Арати"
L["Arathi Blizzard"] = "Низина Арати"
L["Arathi Highlands"] = "Нагорье Арати"
L["Arcatraz"] = "Аркатрац"
L["Arcway"] = "Катакомбы Сурамара"
L["Ashenvale"] = "Ясеневый лес"
L["Ashran"] = "Ашран"
L["Astravar Harbor"] = "Гавань Астравар"
L["Atal'Dazar"] = "Атал'Дазар"
L["Auchenai Crypts"] = "Аукенайские гробницы"
L["Auchindoun"] = "Аукиндон"
L["Automate quests"] = "Автоматизация заданий"
L["Automation"] = "Автоматизация"
L["Azjol-Nerub"] = "Азжол-Неруб"
L["Azshara"] = "Азшара"
L["Azsuna"] = "Азсуна"
L["Azuremyst Isle"] = "Остров Лазурной Дымки"
L["Back to Main Menu"] = "Назад в главное меню"
L["Bad ID"] = "Плохой идентификатор"
L["Badlands"] = "Бесплодные земли"
L["Baradin Hold"] = "Крепость Барадин"
L["Barrens"] = "Южные степи"
L["Bastion of Twilight"] = "Сумеречный бастион"
L["Battle for Azeroth"] = "Battle for Azeroth"
L["Battle for Darkshore"] = "Битва за Темные берега"
L["Battle for Gilneas"] = "Битва за Гилнеас"
L["Battle of Dazar'alor"] = "Битва за Дазар'алор"
L["Battlegrounds"] = "Боевые зоны"
L["Bigger is Better (Alliance)"] = "Лучше больше, да лучше (Альянс)"
L["Bigger is Better (Horde)"] = "Лучше больше, да лучше (Horde)"
L["Black Morass"] = "Черные топи"
L["Black Rook Hold"] = "Крепость Черной Ладьи"
L["Black Temple"] = "Черный храм"
L["Blackfathom Deeps"] = "Непроглядная Пучина"
L["Blackrock Caverns"] = "Пещеры Черной горы"
L["Blackrock Depths"] = "Глубины Черной горы"
L["Blackrock Foundry"] = "Литейная клана Черной горы"
L["Blackrock Mountain"] = "Черная гора"
L["Blackrock Spire"] = "Пик Черной горы"
L["Blackwing Descent"] = "Твердыня Крыла Тьмы"
L["Blackwing Lair"] = "Логово Крыла Тьмы"
L["Blade's Edge Mountains"] = "Острогорье"
L["Blasted Lands"] = "Выжженные земли"
L["Block duels"] = "Блокировать дуэли"
L["Block friend requests"] = "Блокировать запр. дружбы"
L["Block party invites"] = "Блокировать пригл. в группу"
L["Block pet battle duels"] = "Блокировать битвы питомцев"
L["Blocks"] = "Блокировки"
L["Bloodmaul Slag Mines"] = "Шлаковые шахты Кровавого Молота"
L["Bloodmyst Isle"] = "Остров Кровавой Дымки"
L["Borean Tundra"] = "Борейская тундра"
L["Bottom"] = "Нижняя"
L["Broken Isles"] = "Расколотые острова"
L["Broken Shore"] = "Расколотый берег"
L["Buffs"] = "Эффекты"
L["Burning Steppes"] = "Пылающие степи"
L["Buyout Only"] = "Только выкуп"
L["Camera distance"] = "Дистанция камеры"
L["Cape of Stranglethorn"] = "Мыс Тернистой долины"
L["Cataclysm"] = "Cataclysm"
L["Cathedral of Eternal Night"] = "Собор Вечной Ночи"
L["Caverns of Time"] = "Пещеры Времени"
L["Chain style"] = "Стиль контура"
L["Character"] = "Персонаж"
L["Chat"] = "Чат"
L["Chat Frame"] = "Окно чата"
L["Checkbox labels are Ok."] = "Сокращать описания."
L["Class colored frames"] = "Рамки по цвету класса"
L["Click to configure the settings for this option."] = "Нажмите, чтобы настроить параметры на этой вкладке."
L["Click to reset the settings on this page."] = "Нажмите, чтобы сбросить настройки на этой странице."
L["Click to return to the main menu."] = "Нажмите, чтобы вернуться в главное меню."
L["Coilfang Reservoir"] = "Резервуар Кривого Клыка"
L["Color the backdrops based on faction"] = "Цвет фона на основе цвета фракции"
L["Combat log cannot be hidden while undocked."] = "Журнал боя не может быть скрыт, пока отсоединён."
L["Combat plates"] = "Индикаторы"
L["Configuration Panel"] = "Панель настройки"
L["Court of Stars"] = "Квартал Звезд"
L["Credits"] = "кредиты"
L["Crucible of Storms"] = "Горнило Штормов"
L["Crystalsong Forest"] = "Лес Хрустальной Песни"
L["Culling of Stratholme"] = "Очищение Стратхольма"
L["Customise minimap"] = "Настроить миникарту"
L["Dalaran"] = "Даларан"
L["Dark Soil scanning activated.  Reload UI to exit."] = "Сканирование темной земли активировано. Перезагрузите UI для выхода."
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "Сканирование темной земли уже активировано. Вы должны запустить его только один раз. Перезагрузите UI для выхода."
L["Darken the frame background"] = "Затемнить фон окна"
L["Darkheart Thicket"] = "Чаща Темного Сердца"
L["Darkness Falls"] = "Тьма наступает"
L["Darkshore"] = "Темные берега"
L["Darnassus"] = "Дарнас"
L["Deadmines"] = "Пещеры Стенаний"
L["Deepholm"] = "Подземье"
L["Deepwind Gorge"] = "Каньон Суровых Ветров"
L["Desolace"] = "Пустоши"
L["Destiny Unfulfilled"] = "Неисполненная судьба"
L["Dire Maul"] = "Забытый Город"
L["Dire Maul: Capital Gardens"] = "Забытый Город: Центральный сад"
L["Dire Maul: Gordok Commons"] = "Забытый Город: Палаты Гордока"
L["Dire Maul: Warpwood Quarter"] = "Забытый Город: Квартал Криводревов"
L["Disable bag automation"] = "Отключить автоматизацию сумок"
L["Disable chat fade"] = "Откл. затемнение сообщений чата"
L["Disable loot warnings"] = "Откл. предупреждения о добыче"
L["Disable sticky chat"] = "Отключить липкий чат"
L["Draenor"] = "Дренор"
L["Drag the frame overlay to position the frame."] = "Переместите рамки для изменения позиции окон."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "Переместите рамки для изменения позиции окон.|n|nЧтобы изменить масштаб окна, щелкните по его рамке, чтобы его выбрать, а затем отрегулируйте масштаб ползунком на странице настроек.|n|nЭта панель закроется автоматически, если Вы входите в бой."
L["Dragon Soul"] = "Душа Дракона"
L["Dragonblight"] = "Драконий Погост"
L["Drak'Tharon Keep"] = "Крепость Драк'Тарон"
L["Dread Wastes"] = "Жуткие пустоши"
L["Drustvar"] = "Друствар"
L["Dun Morogh"] = "Дун Морог"
L["Dungeon"] = "Подземелье"
L["Dungeons"] = "Подземелья"
L["durability"] = "прочности"
L["Durability"] = "Прочность"
L["Durotar"] = "Дуротар"
L["Duskwood"] = "Сумеречный лес"
L["Dustwallow Marsh"] = "Пылевые топи"
L["Eastern"] = "Восточные"
L["Eastern Kingdoms"] = "Восточные королевства"
L["Eastern Plaguelands"] = "Восточные Чумные земли"
L["ELITE"] = "Элитный"
L["Elwynn Forest"] = "Элвиннский лес"
L["Embassies"] = "Посольства"
L["Emerald Nightmare"] = "Изумрудный Кошмар"
L["Enable hotkey"] = "Вкл. горячую клавишу"
L["Enable viewport"] = "Включить полосы"
L["End Time"] = "Конец Времен"
L["Enhancements"] = "Улучшения"
L["Enigma"] = "загадка"
L["Error Text"] = "Сообщения об ошибках"
L["Everbloom"] = "Вечное Цветение"
L["Evermoon Terrace"] = "Терраса Вечной Луны"
L["Eversong Woods"] = "Леса Вечной Песни"
L["Extras"] = "Дополнения"
L["Eye of Azshara"] = "Око Азшары"
L["Eye of the Storm"] = "Око Бури"
L["Falanaar"] = "Фаланаар"
L["Fall of Deathwing"] = "Падение Смертокрыла"
L["Fall of the Lich King"] = "Падение Короля-лича"
L["False"] = "Ложь"
L["Faster auto loot"] = "Быстрый сбор добычи"
L["Fate of the Horde"] = "Судьба Орды"
L["Features"] = "Особенности"
L["Felsoul Hold"] = "Оплот Оскверненной Души"
L["Felwood"] = "Оскверненный лес"
L["Feralas"] = "Фералас"
L["Find Item"] = "Найти предмет"
L["Firelands"] = "Огненные Просторы"
L["Forge of Souls"] = "Кузня Душ"
L["Frames"] = "Рамки"
L["Freehold"] = "Вольная Гавань"
L["Frostfire Ridge"] = "Хребет Ледяного Огня"
L["Game Options"] = "Настройки игры"
L["Gate of the Setting Sun"] = "Врата Заходящего Солнца"
L["Ghost"] = "Призрак"
L["Ghostlands"] = "Призрачные земли"
L["Gnomeregan"] = "Гномреган"
L["Gold Only"] = "Только золото"
L["Gorgrond"] = "Горгронд"
L["Graphics and Sound"] = "Графика и звук"
L["Grim Batol"] = "Грим Батол"
L["Grimrail Depot"] = "Депо Мрачных Путей"
L["Grizzly Hills"] = "Седые холмы"
L["Groups"] = "Группы"
L["Gruul's Lair"] = "Логово Груула"
L["Gundrak"] = "Гундрак"
L["Halls of Lightning"] = "Чертоги Молний"
L["Halls of Origination"] = "Чертоги Созидания"
L["Halls of Reflection"] = "Залы Отражений"
L["Halls of Stone"] = "Чертоги Камня"
L["Halls of Valor"] = "Чертоги Доблести"
L["Havenswood"] = "Спасолесье"
L["Heart of Fear"] = "Сердце Страха"
L["Hellfire Citadel"] = "Цитадель Адского Пламени"
L["Hellfire Peninsula"] = "Полуостров Адского Пламени"
L["Hellfire Ramparts"] = "Бастионы Адского Пламени"
L["Help"] = "Справка"
L["Hide alerts"] = "Скрыть оповещения"
L["Hide bodyguard gossip"] = "Скрыть разговоры телохранителя"
L["Hide boss banner"] = "Скрыть баннер босса"
L["Hide chat buttons"] = "Скрыть кнопки чата"
L["Hide clean-up buttons"] = "Скрыть кнопку сортировки"
L["Hide crafted names"] = "Скрыть имя изготовителя"
L["Hide error messages"] = "Скр. сообщ. об ошибках"
L["Hide gryphons"] = "Скрыть грифонов"
L["Hide level-up display"] = "Скрыть окно увл. уровня"
L["Hide portrait numbers"] = "Скрыть числа на портрете"
L["Hide stance bar"] = "Скрыть окно стоек"
L["Hide talking frame"] = "Скрыть окно разговоров"
L["Hide the combat log"] = "Скрыть журнал боя"
L["Hide tooltips for world units during combat"] = "Скрыть подсказки для мировых объектов во время боя"
L["Hide zone text"] = "Скрыть название зоны"
L["Highmaul"] = "Земли клана Верховного Молота"
L["Highmountain"] = "Крутогорье"
L["Highmountain Tauren"] = "Таурен Крутогорья"
L["Hillsbrad Foothills"] = "Предгорья Хилсбрада"
L["Hinterlands"] = "Внутренние земли"
L["Home"] = "Домой"
L["Hour of Twilight"] = "Время Сумерек"
L["Howling Fjord"] = "Ревущий фьорд"
L["Hyjal Summit"] = "Вершина Хиджала"
L["Icecrown"] = "Ледяная Корона"
L["Icecrown Citadel"] = "Цитадель Ледяной Короны"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "Если флажок установлен, в окне персонажа будет добавлена кнопка, которая покажет прочность экипировки при наведении указателя мыши на нее.|n|nКроме этого, общий процент будет показан в окне чата, если Вы умрете."
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "Если флажок установлен, ползунок регулировки основной громкости будет отображен на окне персонажа.|n|nПолзунок может быть размещен в любом из двух местах на окне персонажа. Для переключения между ними, удерживая клавишу SHIFT щелкните правой кнопкой мыши по ползунку."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "Если флажок установлен, все серые предмены в Ваших сумках будут проданы автоматически при посещении торговца.|n|nВы можете удерживать клавишу SHIFT во время общения с торговцем для временного игнорирования этой настройки."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "Если флажок установлен, фон подсказки будет синим (дружественная цель) или красным (враждебная цель)."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "Если флажок установлен, BattleTag и Real ID запросы дружбы будут автоматически отклоняться.|n|nВключение этого параметра автоматически отклонит любые ожидающие запросы."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "Если флажок установлен, кнопки чата будут скрыты.|n|nЩелчек по вкладке чата автоматически покажет последние сообщения.|n|nИспользуйте колесо мыши для прокрутки истории чата. Удерживайте нажатой клавишу SHIFT для перехода на другую страницу чата или CTRL, для перехода к верхней или нижней части истории чата."
L["If checked, chat text will not fade out after a time period."] = "Если флажок установлен, текст чата не будет исчезать после определенного периода времени."
L["If checked, crafted items will no longer show the name of the crafter."] = "Если флажок установлен, имя изготовителя больше не будет отображаться на изготовленной вещи."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "Если флажок установлен, значения урона и лечения на рамках игрока и питомца будут скрыты."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "Если флажок установлен, перемещение вверх вкладки Общие (если изменение размера чата заблокировано) расширит форму чата.|n|nЕсли изменение размеров чата разблокировано, перемещение вкладки Общие приведет к перемещению окна чата."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "Если флажок установлен, индикаторы здоровья будут отображены только во время боя и скрыты после его завершения."
L["If checked, guild ranks will be shown for players in your guild."] = "Если флажок установлен, ранг в гильдии будет отображаться для игроков в Вашей гильдии."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "Если флажок установлен, чаты рейдов и подземелий будут окрашены в синий цвет (чтобы соответствовать цвету чата группы по умолчанию)."
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "Если флажок установлен, липкий чат будет отключен.|n|nОбратите внимание, что это не относится к временным окнам чата или Battle.net разговорам."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "Если флажок установлен, запросы призыва будут приниматься автоматически, если вы не в бою."
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "Если флажок установлен, список модификаций (доступный из меню игры) будет по умолчанию отображаться для Вашего текущего персонажа."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "Если флажок установлен, кнопка сортировки вещей в сумках и в банке отображаться не будет."
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "Если флажок установлен, баннер босса отображаться не будет.|n|nЭтот баннер обычно появляется после победы над боссом.  Он показывает имя босса и полученную с него добычу."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "Если флажок установлен, кнопка для переключения контейнера рейд будет отображена над его окном управления (на левой стороне экрана), а не на самом окне управления.|n|nЭто позволит переключать рамку контейнера рейда без необходимости открывать окно его управления."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "Если флажок установлен, журнал боя будет скрыт.|n|nЖурнал боя должен быть присоединён к основному окну чата для того, чтобы этот параметр работал.|n|nЕсли журнал боя откреплён, Вы можете закрепить его перетащив на вкладку чата (после этого необходимо перезагрузить UI) или сбросить настройки окна чата (из соответствующего меню)."
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "Если флажок установлен, то параметр 'Позволить другим просматривать только достижения персонажа' в панели настроек игрового меню ('Общение') будет выбран и заблокирован."
L["If checked, the editbox will be moved to the top of the chat frame."] = "Если флажок установлен, поле ввода текста будет перемещено в верхнюю часть окна чата."
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "Если флажок установлен, окно разговоров не будет отображаться, когда Вы будете говорить с активным гарнизонным телохранителем.|n|nВы можете удерживать клавишу SHIFT во время общения для временного игнорирования этой настройки."
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "Если флажок установлен, окно увеличения уровня не будет отображено.|n|nЭто окно обычно отображает цели подземелья, повышение уровня, награды за битву питомцев и др."
L["If checked, the main bar gryphons will not be shown."] = "Если флажок установлен, грифона на главном окне отображаться не будут."
L["If checked, the stance bar will not be shown."] = "Если флажок установлен, окно стоек отображаться не будет."
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "Если флажок установлен, окно разговоров не будет отображено.|n|nОкно разговоров появляется обычно в нижней части экрана, в процессе общения с некоторыми НПС."
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "Если флажок установлен, всплывающие подсказки будут выделены цветом, и у Вас появится возможность изменять их расположение и масштаб."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "Если флажок установлен, подсказки для мировых объектов будут скрыты во время боя.|n|nВы можете удерживать клавишу SHIFT для временного игнорирования этой настройки."
L["If checked, unit targets will be shown."] = "Если флажок установлен, будет отображаться цель цели."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "Если флажок установлен, Вы сможете нажимать кнопки со стрелками для перемещения курсора влево и вправо в окне чата.|n|nЕсли флажок не установлен, клавиши со стрелками будут использовать настройки назначения клавиш по умолчанию."
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "Если флажок установлен, Вы сможете изменить размер шрифта текста задания.|n|nВключение этого параметра будет влиять на размер текста других окон, наследующих один и тот же шрифт (например, окно поиска подземелий)."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "Если флажок установлен, Вы сможете изменить стандартный размер шрифта текста письма."
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "Если флажок установлен, Вы сможете создать темные полосы. Они накладываются на игровой мир.|n|nПолосы располагаются над игровым миром, но под интерфейсом, так что Вы сможете поместить элементы пользовательского интерфейса над темными полосами."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "Если флажок установлен, Вы сможете переместить рамку чата к краю экрана."
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "Если флажок установлен, Вы сможете сохранить текущий состав питомцев (включкая способности) в одну команду.|n|nКнопка будет добавлена в журнал питомцев. Щелчек по кнопке покажет дополнительные операции для Вашей текущей команды. При нажатии CTRL/C команда будет скопирована в память.|n|nВы можете вставить команду (с помощью CTRL/V) в окно чата или макроса для мгновенного выбора команды."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "Если флажок установлен, Вы сможете отобразить редкий, элитный или редкий элитный контур вокруг рамки игрока."
L["If checked, you will be able to zoom out to a greater distance."] = "Если флажок установлен, Вы сможете максимально отдалять камеру."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "Если флажок установлен, Ваши сумки не будут открываться или закрываться автоматически, когда Вы взаимодействуете с торговцами, банком или почтовым ящиком."
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "Если флажок установлен, история чата увеличится до 4096 линий. Если флажок не установлен, по умолчанию будет использоваться (128 линий).|n|nВключение этого параметра может помешать отображению некоторого текста во время входа в систему."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "Если флажок установлен, текст названия зоны не будет отображаться (напр., 'Стальгорн')."
L["Increase chat history"] = "Увеличить историю чата"
L["Interface"] = "Интерфейс"
L["Invalid battle pet team parameter."] = "Недопустимый параметр для команды боевых питомцев."
L["Invalid console variable."] = "Недопустимая консольная переменная."
L["Invalid parameter."] = "Неверный параметр."
L["Invalid quest ID."] = "Недопустимый идентификатор квеста."
L["Invalid sound ID"] = "Недопустимый идентификатор звука"
L["Invalid target."] = "Неверная цель."
L["Invite from whispers"] = "Приглашать по сообщению"
L["Iron Docks"] = "Железные доки"
L["Ironforge"] = "Стальгорн"
L["Isle of Conquest"] = "Остров Завоеваний"
L["Isle of Quel'Danas"] = "Остров Кель'Данас"
L["Isle of Thunder"] = "Остров Грома"
L["Jade Forest"] = "Нефритовый лес"
L["Jorundall"] = "Йорундалль"
L["Kalimdor"] = "Калимдор"
L["Karazhan"] = "Каражан"
L["Kezan"] = "Кезан"
L["Kings' Rest"] = "Гробница королей"
L["Krasarang Wilds"] = "Красарангские джунгли"
L["Krokuun (Argus)"] = "Крокуун (Аргуса)"
L["Kul Tiras"] = "Кул-Тирас"
L["Kun-Lai Summit"] = "Вершина Кунь-Лай"
L["Last Stand"] = "Последний рубеж"
L["Left"] = "Левая"
L["Legion"] = "Legion"
L["Lifetime honorable kills"] = "Всего почетных побед"
L["Lightforged Draenei"] = "Озаренный дреней"
L["Lion's Watch"] = "Львиный дозор"
L["Loch Modan"] = "Лок Модан"
L["Lockout sharing"] = "Совмесная блокировка"
L["Lost City of the Tol'vir"] = "Затерянный город Тол'вир"
L["Lost Isles"] = "Затерянные острова"
L["Lower Blackrock Spire"] = "Нижняя часть пика Черной горы"
L["Lunastre Estate"] = "Поместье Лунархов"
L["Mac'Aree (Argus)"] = "Мак'Ари (Аргуса)"
L["Madness of Deathwing"] = "Безумие Смертокрыла"
L["Maelstrom"] = "Водоворот"
L["Magisters' Terrace"] = "Терраса Магистров"
L["Magtheridon's Lair"] = "Логово Магтеридона"
L["Mail Text"] = "Текст сообщения"
L["Manage frames"] = "Управление рамками"
L["Manage tooltip"] = "Упр. вспл. подсказками"
L["Managed by Leatrix Plus"] = "Управляется Leatrix Plus"
L["Mana-Tombs"] = "Гробницы Маны"
L["Maraudon"] = "Мародон"
L["Maraudon: Earth Song Falls"] = "Мародон (Поющие водопады)"
L["Maraudon: Foulspore Cavern"] = "Мародон (Зловонная пещера)"
L["Maraudon: The Wicked Grotto"] = "Мародон (Оскверненный грот)"
L["Mardum"] = "Мардум"
L["Maw of Souls"] = "Утроба душ"
L["Max camera zoom"] = "Макс. масштаб. камеры"
L["Mechanics"] = "Механика"
L["Media"] = "СМИ"
L["Memory Usage"] = "Использовано памяти"
L["Minimap"] = "Миникарта"
L["Missing console variable."] = "Отсутствует переменная консоли."
L["Missing mount name."] = "Отсутствует имя монтирования."
L["Missing movie ID."] = "Отсутствует идентификатор фильма."
L["Missing pet name."] = "Отсутствует имя любимца."
L["Missing quest ID."] = "Отсутствует идентификатор квеста."
L["Missing sound file parameter."] = "Отсутствует параметр звукового файла."
L["Missing sound ID."] = "Отсутствует идентификатор звука."
L["Mists of Pandaria"] = "Mists of Pandaria"
L["Mogu'shan Palace"] = "Дворец Могу'шан"
L["Mogu'shan Vaults"] = "Подземелья Могу'шан"
L["Molten Core"] = "Огненные Недра"
L["Moon Guard Stronghold"] = "Цитадель Лунных стражей"
L["Moonglade"] = "Лунная поляна"
L["Motherlode"] = "Золотая жила"
L["Mount Hyjal"] = "Гора Хиджал"
L["Mount not found."] = "Гора не найдена."
L["Move editbox to top"] = "Перемест. окно ввода вверх"
L["Movie not playable."] = "Фильм не воспроизводится."
L["Movie number"] = "Номер фильма"
L["Movies"] = "Кино"
L["Mulgore"] = "Мулгор"
L["Music"] = "Музыка"
L["My Very Own Castle (Alliance)"] = "Мой собственный замок (Альянс)"
L["My Very Own Castle (Horde)"] = "Мой собственный замок (Орда)"
L["Mystical"] = "мистический"
L["Nagrand"] = "Награнд"
L["Nagrand (Draenor)"] = "Награнд (Дренор)"
L["Naxxramas"] = "Наксрамас"
L["Nazmir"] = "Назмир"
L["Neltharion's Lair"] = "Логово Нелтариона"
L["Netherstorm"] = "Пустоверть"
L["Nexus"] = "Нексус"
L["Nightborne"] = "Ночнорожденный"
L["Nighthold"] = "Цитадель Ночи"
L["No help is available for this page."] = "Справка недоступна для этой страницы."
L["No tooltip showing."] = "Нет всплывающих подсказок для отображения."
L["None"] = "Никто"
L["Northern Barrens"] = "Северные степи"
L["Northern Stranglethorn"] = "Северная Тернистая долина"
L["Northrend"] = "Нордскол"
L["Nude"] = "Раздеться"
L["Obsidian Sanctum"] = "Обсидиановое святилище"
L["Old Hillsbrad Foothills"] = "Старые предгорья Хилсбрада"
L["Onyxia's Lair"] = "Логово Ониксии"
L["Orgrimmar"] = "Оргриммар"
L["Outland"] = "Запределье"
L["Overall"] = "Всего"
L["Pandaria"] = "Пандария"
L["Particle density"] = "Плотность частиц"
L["Party from friends"] = "Пригл. в группу от друзей"
L["Pet"] = "Питомец"
L["Pit of Saron"] = "Яма Сарона"
L["Player"] = "Игрок"
L["Player Chain"] = "Контур рамки игрока"
L["Portal"] = "Портал"
L["Quest completed."] = "Задание выполнено."
L["Quest not completed."] = "Задание не завершено."
L["Quest Text"] = "Текст задания"
L["Queue from friends"] = "Запрос от друзей"
L["Ragefire Chasm"] = "Огненная Пропасть"
L["Raid"] = "Рейд"
L["Raid frame toggle"] = "Переключатель рейд. рамки"
L["Random"] = "случайный"
L["RARE"] = "Редкий"
L["RARE ELITE"] = "Редкий элитный"
L["Razorfen Downs"] = "Курганы Иглошкурых"
L["Razorfen Kraul"] = "Лабиринты Иглошкурых"
L["Redridge Mountains"] = "Красногорье"
L["Release in PvP"] = "Испускать дух в PvP"
L["Reload"] = "Перезагрузить"
L["Remove raid restrictions"] = "Снять ограничения рейда"
L["Repair automatically"] = "Автоматический ремонт"
L["Repaired for"] = "Стоимость ремонта"
L["Requires UI reload."] = "Требуется перезагрузка UI."
L["Reset"] = "Сбросить"
L["Resize mail text"] = "Измн. размер текста сообщ."
L["Resize quest text"] = "Измн. размер текста задания"
L["Resize Screen"] = "Экран изменения размера"
L["Rested bubbles"] = "Бонус отдыха"
L["result"] = "результат"
L["results"] = "Результаты"
L["Return to Karazhan"] = "Транспорт: флагманский корабль Легиона"
L["Return to the Black Temple"] = "Возвращение в Черный храм"
L["Right"] = "Правая"
L["Risking It All"] = "Рискнуть всем"
L["Ruby Sanctum"] = "Рубиновое святилище"
L["Ruins of Ahn'Qiraj"] = "Руины Ан'Киража"
L["Ruins of Elune'eth"] = "Руины Элун'ета"
L["Ruins of Gilneas"] = "Руины Гилнеаса"
L["Sanctum of Order"] = "Святилище Порядка"
L["Scale"] = "Масштаб"
L["Scarlet Halls"] = "Залы Алого ордена"
L["Scarlet Monastery"] = "Монастырь Алого ордена"
L["Scholomance"] = "Некроситет"
L["Search"] = "Поиск"
L["Searing Gorge"] = "Тлеющее ущелье"
L["Seat of the Triumvirate"] = "Престол Триумвирата"
L["Select the settings that you want to use."] = "Выберите параметры, которые вы хотите использовать."
L["Self Markers Allowed"] = "Разрешены самомаркировки"
L["Self Markers Blocked"] = "Заблокированные маркеры"
L["Sell junk automatically"] = "Автоматически продавать хлам"
L["SELLING JUNK"] = "ПРОДАЮ ХЛАМ"
L["Serpentshrine Cavern"] = "Змеиное святилище"
L["Sethekk Halls"] = "Сетеккские залы"
L["Settings"] = "Параметры"
L["Shaders"] = "Тени"
L["Shado-Pan Monastery"] = "Монастырь Шадо-Пан"
L["Shadow Labyrinth"] = "Темный лабиринт"
L["Shadowfang Keep"] = "Крепость Темного Клыка"
L["Shadowmoon Burial Grounds"] = "Некрополь Призрачной Луны"
L["Shadowmoon Valley"] = "Долина Призрачной Луны"
L["Shadowmoon Valley (Draenor)"] = "Долина Призрачной Луны (Дренор)"
L["Sholazar Basin"] = "Низина Шолазар"
L["Show auction controls"] = "Отобр. элементы упрл. аукциона"
L["Show character addons"] = "Модификации для игрока"
L["Show durability status"] = "Отобр. прочность экипировки"
L["Show guild ranks for your guild"] = "Отображать ранги для Вашей гильдии"
L["Show minimap button"] = "Отобр. иконку у миникарты"
L["Show pet save button"] = "Показать кнопку сохрн. питомцев"
L["Show player chain"] = "Отобр. контур игрока"
L["Show the unit's target"] = "Отображать цель цели"
L["Show volume slider"] = "Отобр. ползунок рег. громкости"
L["Shrine of the Storm"] = "Святилище Штормов"
L["Siege of Boralus"] = "Осада Боралуса"
L["Siege of Niuzao Temple"] = "Осада храма Нюцзао"
L["Siege of Orgrimmar"] = "Осада Оргриммара"
L["Silence rested emotes"] = "Заглушать звуки эмоций"
L["Silithus"] = "Силитус"
L["Silverpine Forest"] = "Серебряный бор"
L["Silvershard Mines"] = "Сверкающие копи"
L["Skyreach"] = "Небесный Путь"
L["Slave Pens"] = "Узилище"
L["Social"] = "Общение"
L["Sold junk for"] = "Проданный мусор для"
L["Sound system restarted."] = "Звуковая система перезапустилась."
L["Southern Barrens"] = "Южные степи"
L["Spell ID"] = "ID закл."
L["Spine of Deathwing"] = "Хребет Смертокрыла"
L["Spires of Arak"] = "Пики Арака"
L["Steamvault"] = "Паровое подземелье"
L["Stockade"] = "Тюрьма"
L["Stonecore"] = "Каменные Недра"
L["Stonetalon Mountains"] = "Когтистые горы"
L["Stop"] = "Стоп"
L["Storm Peaks"] = "Грозовая гряда"
L["Stormheim"] = "Штормхейм"
L["Stormsong Valley"] = "Долина Штормов"
L["Stormstout Brewery"] = "Хмелеварня Буйных Портеров"
L["Stormwind"] = "Штормград"
L["Strand of the Ancients"] = "Берег Древних"
L["Stratholme"] = "Стратхольм"
L["Sunken Temple"] = "Затонувший храм"
L["Sunwell Plateau"] = "Плато Солнечного Колодца"
L["Support"] = "Поддержка"
L["Suramar"] = "Сурамар"
L["Swamp of Sorrows"] = "Болото печали"
L["System"] = "Система"
L["Tabard"] = "Накидка"
L["Talador"] = "Таладор"
L["Tanaan Jungle"] = "Танаанские джунгли"
L["Tanaris"] = "Танарис"
L["Target"] = "Цель"
L["Target Tracking Disabled"] = "Отслеживание цели отключено"
L["Target Tracking Enabled"] = "Отслеживание цели включено"
L["Tel'anor"] = "Тел'анор"
L["Teldrassil"] = "Тельдрассил"
L["Tempest Keep"] = "Крепость Бурь"
L["Temple of Ahn'Qiraj"] = "Храм Ан'Кираж"
L["Temple of Kotmogu"] = "Храм Котмогу"
L["Temple of Sethraliss"] = "Храм Сетралисс"
L["Temple of the Jade Serpent"] = "Храм Зин-Малор"
L["Terokkar Forest"] = "Лес Тероккар"
L["Terrace of Endless Spring"] = "Терраса Вечной Весны"
L["Text"] = "Текст"
L["Text size"] = "Размер текста"
L["Text Size"] = "Размер текста"
L["The Arcatraz"] = "Аркатрац"
L["The Art of War"] = "Искусство войны"
L["The Bastion of Twilight"] = "Сумеречный бастион"
L["The Battle for Broken Shore"] = "Битва за Расколотый берег"
L["The Battle for Shattrath"] = "Битва за Шаттрат"
L["The Battle of Thunder Pass"] = "Хребет Ледяного Огня"
L["The Black Morass"] = "Черные топи"
L["The Blood Furnace"] = "Кузня Крови"
L["The Botanica"] = "Ботаника"
L["The Burning Crusade"] = "The Burning Crusade"
L["The Culling of Stratholme"] = "Очищение Стратхольма"
L["The Deadmines"] = "Мертвые копи"
L["The Demon's Trail"] = "По следу демона"
L["The Dragon Soul"] = "Душа Дракона"
L["The Everbloom"] = "Вечное Цветение"
L["The Eye"] = "Око"
L["The Eye of Eternity"] = "Око Вечности"
L["The Fate of Val'sharah"] = "Судьба Валь'шары"
L["The Forge of Souls"] = "Кузня Душ"
L["The Frozen Halls"] = "Ледяные залы"
L["The Halls of Reflection"] = "Залы Отражений"
L["The Invasion Begins"] = "Атака начинается"
L["The King's Command"] = "Приказ короля"
L["The Mechanar"] = "Механар"
L["The Nexus"] = "Нексус"
L["The Nightborne Pact"] = "Пакт ночнорожденных"
L["The Obsidian Sanctum"] = "Обсидиановое святилище"
L["The Oculus"] = "Окулус"
L["The Old Kingdom"] = "Старое Королевство"
L["The Pit of Saron"] = "Яма Сарона"
L["The Ruby Sanctum"] = "Рубиновое святилище"
L["The Shattered Halls"] = "Разрушенные залы"
L["The Stockade"] = "Тюрьма"
L["The Stonecore"] = "Каменные Недра"
L["The Violet Hold"] = "Аметистовая крепость"
L["The Vortex Pinnacle"] = "Вершина Смерча"
L["The Waning Crescent"] = "Лунный полумрак"
L["Themes"] = "Темы"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "Эта операция назначит текущую команду боевых питомцев и их способности.|n|nНажмите CTRL/C чтобы скопировать команду. После этого Вы сможете ее вставить в окно чата или макроса с помощью CTRL/V."
L["This panel will close automatically if you enter combat."] = "Это окно будет автоматически закрыто, если Вы вступите в бой."
L["Thousand Needles"] = "Тысяча Игл"
L["Throne of the Four Winds"] = "Трон Четырех Ветров"
L["Throne of the Tides"] = "Трон Приливов"
L["Throne of Thunder"] = "Престол Гроз"
L["Thunder Bluff"] = "Громовой Утес"
L["Timeless Isle"] = "Вневременный остров"
L["Timer"] = "Таймер"
L["Tiragarde Sound"] = "Тирагардское поморье"
L["Tirisfal Glades"] = "Тирисфальские леса"
L["To begin, choose an options page."] = "Для начала выберите страницу настроек."
L["Tol Barad"] = "Тол Барад"
L["Tol Dagor"] = "Тол Дагор"
L["Tomb of Sargeras"] = "Гробница Саргераса"
L["Tooltip"] = "Подсказки"
L["Tooltip title color"] = "Цвет заголовка всплывающей подсказки"
L["Top"] = "Верхняя"
L["Townlong Steppes"] = "Танлунские степи"
L["Tracing started."] = "Отслеживание началось."
L["Tracing stopped."] = "Трассировка остановилась."
L["Transparency"] = "Прозрачность"
L["Trial of the Champion"] = "Испытание чемпиона"
L["Trial of the Crusader"] = "Испытание крестоносца"
L["Trial of Valor"] = "Испытание доблести"
L["True"] = "Правда"
L["Twilight Highlands"] = "Сумеречное нагорье"
L["Twilight Vineyards"] = "Сумеречные виноградники"
L["Twin Peaks"] = "Два Пика"
L["Uldaman"] = "Ульдаман"
L["Uldir"] = "Ульдир"
L["Ulduar"] = "Ульдуар"
L["Uldum"] = "Ульдум"
L["Unclamp chat frame"] = "Разжать окно чата"
L["Underbog"] = "Нижетопь"
L["Undercity"] = "Подгород"
L["Underrot"] = "Подгнилье"
L["Un'Goro Crater"] = "Кратер Ун'Горо"
L["Universal group color"] = "Универсальные цвета групп"
L["Upper Blackrock Spire"] = "Верхняя часть пика Черной горы"
L["Use arrow keys in chat"] = "Использовать кнопки в чате"
L["Use easy resizing"] = "Испл. легкое измн. размера"
L["Use Leatrix Plus to move that frame."] = "Используйте Leatrix Plus, чтобы переместить эту рамку."
L["Use Leatrix Plus to reset that frame."] = "Используйте Leatrix Plus, чтобы сбросить положение этой рамки."
L["Utgarde Keep"] = "Крепость Утгард"
L["Utgarde Pinnacle"] = "Вершина Утгард"
L["Vale of Eternal Blossoms"] = "Вечноцветущий дол"
L["Valley of the Four Winds"] = "Долина Четырех Ветров"
L["Val'sharah"] = "Валь'шара"
L["Various"] = "Различный"
L["Vashj'ir"] = "Вайш'ир"
L["Vault of Archavon"] = "Склеп Аркавона"
L["Vault of the Wardens"] = "Казематы Стражей"
L["Vendors"] = "Продавцы"
L["Version"] = "Версия"
L["Video"] = "видео"
L["Viewport"] = "Полосы"
L["Violet Hold"] = "Аметистовая крепость"
L["Visibility"] = "Видимость"
L["Vol'dun"] = "Вол'дун"
L["Vol'mar"] = "Вол'мар"
L["Wailing Caverns"] = "Пещеры Стенаний"
L["Wandering Isle"] = "Скитающийся остров"
L["Warlords of Draenor"] = "Warlords of Draenor"
L["Warsong Gulch"] = "Ущелье Песни Войны"
L["was automatically declined."] = "был автоматически отклонён."
L["Waycrest Manor"] = "Усадьба Уэйкрестов"
L["Weather density"] = "Плотность погоды"
L["Welcome to Leatrix Plus."] = "Добро пожаловать в Leatrix Plus."
L["Well of Eternity"] = "Источник Вечности"
L["Western Plaguelands"] = "Западные Чумные земли"
L["Westfall"] = "Западный Край"
L["Wetlands"] = "Болотина"
L["Widget"] = "Виджет"
L["Winter"] = "зима"
L["Wintergrasp"] = "Озеро Ледяных Оков"
L["Winterspring"] = "Зимние Ключи"
L["Wrath of the Lich King"] = "Гнев Короля-лича"
L["Wyrmrest Temple"] = "Храм Драконьего Покоя"
L["YOU"] = "ВЫ"
L["You cannot do that in combat."] = "Вы не можете сделать это в бою."
L["You have"] = "У Вас"
L["You need a battle pet team."] = "Вам нужна команда боевых питомцев."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "Ваш UI нуждается в перезагрузке для вступления в силу ряда изменений.|n|nВы недолжны немедленно нажимать на кнопку перезагрузки, но после завершения редактирования параметров Вам необходимо будет это сделать, для вступления в силу ряда изменений."
L["Your UI needs to be reloaded."] = "Ваш UI нуждается в перезагрузке."
L["Zangarmarsh"] = "Зангартопь"
L["Zul'Drak"] = "Зул'Драк"
L["Zygor addon not found."] = "Модификация Zygor не найдена."

end

-- koKR: Korean
if GameLocale == "koKR" then
L["A Falling Star"] = "떨어지는 별"
L["A Found Memento"] = "찾아낸 기억의 조각"
L["A friend request from"] = "친구 신청"
L["A New Life for Undeath"] = "죽지 않는자에게 새 생명을"
L["A Taste of Iron"] = "강철의 맛"
L["Accept resurrection"] = "부활 수락"
L["Accept summon"] = "소환 수락"
L["Account achievements are being shared."] = "계정 업적을 공유하고 있습니다."
L["Account achievements are hidden."] = "계정 업적을 숨깁니다."
L["Addon"] = "애드온"
L["Adventure"] = "모험"
L["Ahn'kahet (Old Kingdom)"] = "안카헤트(고대왕국)"
L["All 3 battle pet slots need to be unlocked."] = "3개의 애완동물 슬롯을 잠금 해제하여야 합니다."
L["Allied Races"] = "동맹 종족"
L["Alterac Valley"] = "알터랙 계곡"
L["An Unexpected Reunion"] = "뜻밖의 재회"
L["And Justice for Thrall"] = "스랄의 정의"
L["Anduin's Theme"] = "안두인 테마"
L["Antoran Wastes (Argus)"] = "안토란 황무지(아르거스)"
L["Antorus Ending"] = "안토러스의 결말 "
L["Antorus, the Burning Throne"] = "안토러스-불타는 왕좌"
L["Arathi Basin"] = "아라시 분지"
L["Arathi Blizzard"] = "아라시 분지"
L["Arathi Highlands"] = "아라시 고원"
L["Arcatraz"] = "알카트라즈"
L["Arcway"] = "비전로"
L["Arenas"] = "투기장"
L["Arrival on Argus"] = "아르거스의 그림자"
L["Arrival to Zandalar"] = "잔달라에 도착하다"
L["Ashenvale"] = "잿빛 골짜기"
L["Ashran"] = "아쉬란"
L["Assault on the Broken Shore"] = "부서진 해변 공격"
L["Astravar Harbor"] = "아스트라바르 항구"
L["Atal'Dazar"] = "아탈다자르"
L["Auchenai Crypts"] = "아키나이 납골당"
L["Auchindoun"] = "아킨둔"
L["AutoFollow"] = "따라가기 설정됨"
L["AutoFollow disabled."] = "따라가기 해제."
L["Automate gossip"] = "대화 자동 넘김"
L["Automate quests"] = "퀘스트 자동 수락"
L["Automation"] = "자동화"
L["Azjol-Nerub"] = "아졸네룹"
L["Azshara"] = "아즈샤라"
L["Azsuna"] = "아즈스나"
L["Azuremyst Isle"] = "하늘안개 섬"
L["Back to Main Menu"] = "주 메뉴로 돌아가기"
L["Bad ID"] = "잘못된 ID"
L["Badlands"] = "황야의 땅"
L["Baradin Hold"] = "바라딘 요새"
L["Barrens"] = "남부 불모의 땅"
L["Bastion of Twilight"] = "황혼의 요새"
L["Battle for Azeroth"] = "격전의 아제로스"
L["Battle for Darkshore"] = "어둠해안 전투"
L["Battle for Gilneas"] = "길니아스 전투지"
L["Battle for Stromgarde"] = "스트롬가드 전투"
L["Battle of Angrathar the Wrathgate"] = "앙그라타르.분노의 관문 전투"
L["Battle of Dazar'alor"] = "다자알로 전투"
L["Battle of Serpent's Heart"] = "용의 심장의 전투"
L["Battlegrounds"] = "전장"
L["Bigger is Better (Alliance)"] = "더 크게 더 멋지게(얼라이언스)"
L["Bigger is Better (Horde)"] = "더 크게 더 멋지게(호드)"
L["Black Morass"] = "검은늪"
L["Black Rook Hold"] = "검은 떼까마귀 요새"
L["Black Temple"] = "검은 사원"
L["Blackfathom Deeps"] = "검은 심연 나락"
L["Blackrock Caverns"] = "검은바위 동굴"
L["Blackrock Depths"] = "검은바위 나락"
L["Blackrock Foundry"] = "검은바위 용광로"
L["Blackrock Mountain"] = "검은바위 산"
L["Blackrock Spire"] = "검은바위 첨탑"
L["Blackwing Descent"] = "검은날개 강림지"
L["Blackwing Lair"] = "검은날개 둥지"
L["Blade's Edge Mountains"] = "칼날 산맥"
L["Blasted Lands"] = "저주받은 땅"
L["Block duels"] = "결투 차단"
L["Block friend requests"] = "친구요청 차단"
L["Block party invites"] = "파티초대 차단"
L["Block pet battle duels"] = "애완동물대전 차단"
L["Blocks"] = "차단"
L["Bloodmaul Slag Mines"] = "피망치 잿가루 광산"
L["Bloodmyst Isle"] = "핏빛안개 섬"
L["Borean Tundra"] = "북풍의 땅"
L["Bottom"] = "하단"
L["Broken Isles"] = "부서진 섬"
L["Broken Shore"] = "부서진 해변"
L["Buffs"] = "버프"
L["Burning Steppes"] = "불타는 평원"
L["Buyout Only"] = "즉시구입가 만!"
L["Camera distance"] = "카메라 거리"
L["Cape of Stranglethorn"] = "가시덤불 곶"
L["Cataclysm"] = "대격변"
L["Cathedral of Eternal Night"] = "영원한 밤의 대성당"
L["Caverns of Time"] = "시간의 동굴"
L["Chain style"] = "테두리 스타일"
L["Character"] = "캐릭터"
L["Chat"] = "채팅"
L["Chat Frame"] = "채팅창"
L["Checkbox labels are Ok."] = "체크박스를 확인합니다."
L["Choose an Enigma pattern"] = "수수께끼 패턴 선택"
L["Cinematics"] = "시네마틱"
L["Class colored frames"] = "유닛프레임 직업색상"
L["Class Trials"] = "직업 체험"
L["click here for new selection"] = "목록을 갱신하려면 여기를 클릭하세요."
L["Click to configure the settings for this option."] = "설정을 구성하려면 클릭합니다."
L["Click to reset the settings on this page."] = "이 페이지를 재설정 하려면 클릭합니다."
L["Click to resize the screen to fit between the top and bottom borders."] = "상,하단간 화면에 맞게 화면 크기를 설정합니다. "
L["Click to return to the main menu."] = "주 메뉴 돌아가기 클릭"
L["Coilfang Reservoir"] = "갈퀴 송곳니 저수지"
L["Color the backdrops based on faction"] = "진영에 따른 배경색상"
L["Combat log cannot be hidden while undocked."] = "** 창(일반/전투) 연결이 해제되면 숨길수 없습니다."
L["Combat plates"] = "전투시 이름표 표시"
L["Configuration Panel"] = "설정창"
L["Connections for"] = "연결된 서버"
L["Cooldowns"] = "쿨다운 아이콘"
L["Court of Stars"] = "별의 궁정"
L["Credits"] = "크레딧"
L["Crucible of Storms"] = "폭풍의 용광로"
L["Crystalsong Forest"] = "수정노래 숲"
L["Culling of Stratholme"] = "옛 스트라솔름"
L["Customise minimap"] = "미니맵 설정"
L["Dalaran"] = "달라란"
L["Dark Iron Dwarves"] = "검은무쇠 드워프"
L["Dark Soil scanning activated.  Reload UI to exit."] = "어두운 토양 검사 활성화. 리로드-종료."
L["Dark Soil scanning is already activated.  You only need to run this once.  Reload UI to exit."] = "어두운 토양 검사가 이미 활성화됨."
L["Darken the frame background"] = "배경 어둡게"
L["Darkheart Thicket"] = "어둠심장 숲"
L["Darkmoon Faire"] = "다크문 축제"
L["Darkness Falls"] = "어둠이 드리운다."
L["Darkshore"] = "어둠해안"
L["Darnassus"] = "다르나서스"
L["Deadmines"] = "죽음의 폐광"
L["Deepholm"] = "심원의 영지"
L["Deepwind Gorge"] = "깊은바람 협곡"
L["Desolace"] = "잊혀진 땅"
L["Destiny Unfulfilled"] = "실현되지 않은 운명"
L["Dire Maul"] = "혈투의 전장"
L["Dire Maul: Capital Gardens"] = "혈투의 전장:수도정원"
L["Dire Maul: Gordok Commons"] = "혈투의 전장:고르독 광장"
L["Dire Maul: Warpwood Quarter"] = "혈투의 전장:굽이나무 지구"
L["Disable bag automation"] = "가방 자동열림 비활성"
L["Disable chat fade"] = "챗 사라짐 비활성"
L["Disable loot warnings"] = "전리품 경고 비활성"
L["Disable pet automation"] = "애완동물 자동 비활성"
L["Disable screen effects"] = "이펙트 비활성"
L["Disable screen glow"] = "빛 효과 비활성"
L["Disable sticky chat"] = "채널고정 사용안함"
L["Draenor"] = "드레노어"
L["Drag the frame overlay to position the frame."] = "위치 변경은 프레임 드레그 이동하세요."
L["Drag the frame overlays to position the frames.|n|nTo change the scale of a frame, click it to select it then adjust the scale slider.|n|nThis panel will close automatically if you enter combat."] = "위치는 드레그 이동, 크기는 슬라이더 조정 설정."
L["Drag to set the font size of mail text."] = "드래그하여 우편 글꼴 크기를 설정하십시오."
L["Drag to set the font size of quest text."] = "드래그하여 퀘스트 글꼴 크기를 설정하십시오."
L["Drag to set the minimap scale.|n|nNote that if you are using the default action bars, rescaling the minimap will also rescale the right action bars at startup so you may want to leave this at 100%."] = "드래그하여 미니맵 크기를 설정하십시오. |n|n블리자드(기본) 액션바를 사용시, 변경후 시작마다 오른쪽 액션바가 다시 조정되므로 100 %로 두는 것이 좋습니다."
L["Drag to set the scale of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널 크기를 설정하십시오."
L["Drag to set the scale of the selected frame."] = "드래그하여 선택된 프레임의 크기를 설정하십시오."
L["Drag to set the size of the bottom border."] = "드래그하여 아래쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the left border."] = "드래그하여 왼쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the right border."] = "드래그하여 오른쪽 테두리의 크기를 설정하십시오."
L["Drag to set the size of the top border."] = "드래그하여 윗쪽 테두리의 크기를 설정하십시오."
L["Drag to set the tooltip scale."] = "드래그하여 툴팁 크기를 설정하십시오."
L["Drag to set the transparency of the borders."] = "드래그하여  테두리의 투명도를 설정하십시오."
L["Drag to set the transparency of the Leatrix Plus panel."] = "드래그하여 Leatrix Plus 패널의 투명도를 설정하십시요."
L["Dragon Soul"] = "용의 영혼"
L["Dragonblight"] = "용의 안식처"
L["Drak'Tharon Keep"] = "드락타론 성채"
L["Dread Wastes"] = "공포의 황무지"
L["Drustvar"] = "드러스트바"
L["Dun Morogh"] = "던 모로"
L["Dungeon"] = "던전"
L["Dungeons"] = "던전"
L["Dup ID"] = "중복ID"
L["durability"] = "당신의"
L["Durability"] = "내구도"
L["Durotar"] = "듀로타"
L["Duskwood"] = "그늘숲"
L["Dustwallow Marsh"] = "먼지진흙 습지대"
L["Eastern"] = "동부 왕국"
L["Eastern Kingdoms"] = "동부 왕국"
L["Eastern Plaguelands"] = "동부 역병지대"
L["ELITE"] = "정예"
L["Elwynn Forest"] = "엘윈 숲"
L["Embassies"] = "대사관"
L["Embers of War"] = "전쟁의 불씨"
L["Emerald Nightmare"] = "에메랄드의 악몽"
L["Enable hotkey"] = "단축키 사용"
L["Enable viewport"] = "뷰포트 사용"
L["End Time"] = "시간의 끝"
L["Enhance dressup"] = "미리보기 강화"
L["Enhancements"] = "기능 향상"
L["Enigma"] = "수수께끼"
L["Enter the spell IDs for the cooldown icons that you want to see.|n|nIf a cooldown icon normally appears under the pet frame, check the pet checkbox.|n|nCooldown icons are saved to your class and specialisation."] = "표시할 주문 ID를 입력하세요.|n|n소환수 프레임 아래 표시하려면 소환수 박스를 체크하세요.|n|n쿨다운아이콘은 직업 및 특성으로 저장됩니다."
L["enter zone or track name"] = "지역 또는 트랙이름을 입력하세요."
L["Epilogue (Alliance)"] = "에필로그(얼라이언스)"
L["Epilogue (Horde)"] = "에필로그(호드)"
L["Error messages will be hidden"] = "오류메시지 숨김"
L["Error messages will be shown"] = "오류메시지 표시"
L["Error Text"] = "에러메시지"
L["Establish Your Garrison (Alliance)"] = "주둔지 건설(얼라이언스)"
L["Establish Your Garrison (Horde)"] = "주둔지 건설(호드)"
L["Events"] = "이벤트"
L["Everbloom"] = "상록숲"
L["Evermoon Terrace"] = "영원달 정원"
L["Eversong Woods"] = "영원노래 숲"
L["Extras"] = "기타"
L["Eye of Azshara"] = "아즈샤라의 눈"
L["Eye of the Storm"] = "폭풍의 눈"
L["Falanaar"] = "팔라나아르"
L["Fall of Deathwing"] = "데스윙의 추락"
L["Fall of the Lich King"] = "리치 왕의 몰락"
L["False"] = "거짓"
L["Faster auto loot"] = "빠른 전리품 획득"
L["Faster movie skip"] = "빠른 무비 넘김"
L["Fate of the Horde"] = "호드의 운명"
L["Features"] = "특징"
L["Felsoul Hold"] = "지옥영혼 요새"
L["Felwood"] = "악령숲"
L["Feralas"] = "페랄라스"
L["Find Item"] = "아이템찾기"
L["Firelands"] = "불의 땅"
L["Forge of Souls"] = "영혼의 제련소"
L["Frames"] = "프레임"
L["Freehold"] = "자유지대"
L["Frostfire Ridge"] = "서리불꽃 마루"
L["Game Options"] = "게임 설정"
L["Gate of the Setting Sun"] = "석양문"
L["Ghost"] = "유령"
L["Ghostlands"] = "유령의 땅"
L["Gnomeregan"] = "놈리건"
L["Gold Only"] = "골드 만!"
L["Gorgrond"] = "고르그론드"
L["Graphics and Sound"] = "그래픽,소리"
L["Grim Batol"] = "그림 바톨"
L["Grimrail Depot"] = "파멸철로 정비소"
L["Grizzly Hills"] = "회색 구릉지"
L["Groups"] = "그룹"
L["Gruul's Lair"] = "그룰의 둥지"
L["Gul'dan Ascendant"] = "굴단의 위상"
L["Gul'dan's Plan"] = "굴단의 계획"
L["Gundrak"] = "군드락"
L["Gundrak (rear entrance)"] = "군드락(후문)"
L["Halls of Lightning"] = "번개의 전당"
L["Halls of Origination"] = "시초의 전당"
L["Halls of Reflection"] = "투영의 전당"
L["Halls of Stone"] = "돌의 전당"
L["Halls of Valor"] = "용맹의 전당"
L["Harbingers Gul'dan"] = "굴단의 전조"
L["Harbingers Illidan"] = "일리단의 전조"
L["Harbingers Khadgar"] = "카드가의 전조"
L["Havenswood"] = "안식의 숲"
L["Heart of Fear"] = "공포의 심장"
L["Hellfire Citadel"] = "지옥불 성채"
L["Hellfire Peninsula"] = "지옥불 반도"
L["Hellfire Ramparts"] = "지옥불 성루"
L["Hellscream's Downfall (Alliance)"] = "헬스크림의 몰락(얼라이언스)"
L["Hellscream's Downfall (Horde)"] = "헬스크림의 몰락(호드)"
L["Help"] = "도움말"
L["Hide alerts"] = "경보,알림 숨김"
L["Hide bodyguard gossip"] = "경비병 잡담 숨김"
L["Hide boss banner"] = "보스 배너 숨김"
L["Hide chat buttons"] = "채팅 버튼 숨김"
L["Hide clean-up buttons"] = "가방정리 버튼 숨김"
L["Hide cooldown duration numbers (if enabled)"] = "주문 지속시간 숨김"
L["Hide crafted names"] = "제작자 이름 숨김"
L["Hide error messages"] = "에러메시지 숨김"
L["Hide gryphons"] = "그리핀 문양 숨김"
L["Hide level-up display"] = "레벨 업 표시 숨김"
L["Hide order hall bar"] = "전당 바 숨김"
L["Hide portrait numbers"] = "초상화 전투수치 숨김"
L["Hide social button"] = "소셜 버튼 숨김"
L["Hide stance bar"] = "태세바 숨김"
L["Hide talking frame"] = "대화 프레임 숨김"
L["Hide the clock"] = "시계 숨김"
L["Hide the combat log"] = "전투기록 숨김"
L["Hide the zone text bar"] = "지역명 숨김"
L["Hide the zoom buttons"] = "확대축소 버튼 숨김"
L["Hide tooltips for world units during combat"] = "전투중 월드유닛 툴팁 숨김"
L["Hide zone text"] = "지역명 숨김"
L["Highmaul"] = "높은 망치"
L["Highmountain"] = "높은산"
L["Highmountain Tauren"] = "높은산 타우렌"
L["Hillsbrad Foothills"] = "언덕마루 구릉지"
L["Hinterlands"] = "동부 내륙지"
L["Home"] = "홈"
L["Hour of Twilight"] = "황혼의 시간"
L["Howling Fjord"] = "울부짖는 협만"
L["Hyjal Summit"] = "하이잘 정상"
L["Icecrown"] = "얼음왕관"
L["Icecrown Citadel"] = "얼음왕관 성채"
L["If checked, a button will be added to the character sheet which will show your equipped item durability when you hover the pointer over it.|n|nIn addition, an overall percentage will be shown in the chat frame when you die."] = "케릭창에 내구도 정보 추가"
L["If checked, a group invite will be sent to anyone who whispers you with the keyword INV.|n|nYou need to be either ungrouped or party leader in your own group for this to work."] = "선택하면,그룹 초대장이 INV 키워드로 귓속말을 보냅니다.|n|n이 기능을 사용하려면 파티가 아니거나 파티장이여야 합니다."
L["If checked, a master volume slider will be shown on the character sheet.|n|nThe volume slider can be placed in either of two locations on the character sheet.  To toggle between them, hold the shift key down and right-click the slider."] = "케릭창 하단 소리 조절 표시. 마스터 볼륨."
L["If checked, a minimap button will be available.|n|nClick - Toggle options panel.|n|nSHIFT/Left-click - Toggle music.|n|nSHIFT/Right-click - Toggle stopwatch.|n|nCTRL/Left-click - Toggle minimap target tracking.|n|nCTRL/Right-click - Toggle errors (if enabled).|n|nCTRL/SHIFT/Left-click - Toggle Zygor (if installed).|n|nCTRL/SHIFT/Right-click - Toggle windowed mode."] = "\"선택하면 Leatrix_Plus 미니맵버튼을 사용할 수 있습니다.|n|n왼클릭-설정창.|n|nShift/왼클릭-배경음악 켜기/끄기.|n|nShift/오른클릭-초시계.|n|nCtrl/왼클릭-대상 미니맵 표시/해제.|n|nCtrl/오른클릭-오류 표시/해제(설정활성된 경우).|n|nCtrl/Shift/왼클릭-Zygor(설치된 경우).|n|nCtrl/Shift/오른클릭-원도우 모드 전환.\""
L["If checked, additional functionality will be added to the auction house.|n|nBuyout only - create buyout auctions without filling in the starting price.|n|nGold only - set the copper and silver prices at 99 to speed up new auctions.|n|nFind item - search the auction house for the item you are selling.|n|nIn addition, the auction price type and duration settings will be saved account-wide."] = "경매창의 추가 기능. |n|n즉시구입가 만! :시작가 없이 즉구가 입력만 생성.|n|n골드 만! :경매 99은99동 자동입력. |n|n아이템찾기 :경매에 아이템찾기 버튼 생성. |n|n경매 유형,기간 설정은 계정전체에 저장됩니다."
L["If checked, additional functionality will be added to the dressup frame.|n|nNude and tabard toggle buttons will be added, model positioning controls will be removed and special model animations will be disabled."] = "미리보기창에 추가기능.|n|n옷벗기,휘장숨김 버튼이 추가되고 모델컨트롤 제거, 특수 모델 애니메이션 비활성 됨. "
L["If checked, alert frames will not be shown."] = "경고,알림 프레임이 표시되지 않습니다."
L["If checked, all grey items in your bags will be sold automatically when you visit a merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인과 대화시 가방에 있는 모든 회색템이 자동 판매됩니다. |n|n이 설정을 무시하려면 shift 누르고 대화 합니다."
L["If checked, backdrops will be tinted blue (friendly) or red (hostile)."] = "적대적-붉은색, 우호적-파란색"
L["If checked, battle pets which are automatically summoned will be dismissed within a few seconds.|n|nThis includes dragging a pet onto the first team slot in the pet journal and entering a battle pet team save command.|n|nNote that pets which are automatically summoned during combat will be dismissed when combat ends."] = "자동으로 소환되는 전투팻은 몇초 이내 해제됩니다.|n|n애완동물도감의 그룹저장 포함?|n|n전투 중 자동 소환되는 애완 동물은 전투가 끝나면 해제됩니다."
L["If checked, BattleTag and Real ID friend requests will be automatically declined.|n|nEnabling this option will automatically decline any pending requests."] = "BattleTag과 실명ID 친구 요청이 자동으로 거절됩니다."
L["If checked, chat frame buttons will be hidden.|n|nClicking chat tabs will automatically show the latest messages.|n|nUse the mouse wheel to scroll through the chat history.  Hold down SHIFT for page jump or CTRL to jump to the top or bottom of the chat history."] = "채팅창의 버튼을 숨깁니다. 최근메시지 표시-탭 클릭. 마우스휠 사용가능."
L["If checked, chat text will not fade out after a time period."] = "채팅글이 일정시간후 사라짐 비활성."
L["If checked, class coloring will be used in the player frame, target frame and focus frame."] = "플레이어,대상,주시 프레임에서 직업 색상 사용."
L["If checked, confirmations will no longer appear when you choose a loot roll option or attempt to sell or mail a tradable item."] = "전리품 판매,우편발송 시 확인경고 표시안함."
L["If checked, converting a party group to a raid group will succeed even if there are low level characters in the group.|n|nEveryone in the group needs to have Leatrix Plus installed with this option enabled."] = "파티 구성원 중 저레벨이 있어도 공격대로 전환 할수 있습니다.|n|n그룹의 모든 사용자는 애드온 설치와 설정이 활성화 되어야 합니다. "
L["If checked, cooldown duration numbers will not be shown over the cooldowns.|n|nIf unchecked, cooldown duration numbers will be shown over the cooldowns if they are enabled in the game options panel ('ActionBars' menu)."] = "주문 지속시간 숨김"
L["If checked, crafted items will no longer show the name of the crafter."] = "제작된 아이템의 제작자 이름을 표시 하지 않습니다."
L["If checked, damage and healing numbers in the player and pet portrait frames will be hidden."] = "유닛프레임 초상화에 표시되는 데미지,힐 수치 표시 숨김."
L["If checked, dragging the General chat tab while the chat frame is locked will expand the chat frame upwards.|n|nIf the chat frame is unlocked, dragging the General chat tab will move the chat frame."] = "채팅창 잠긴 경우 탭(일반/전투)드레그로 위쪽을 길이 조절 할수있습니다."
L["If checked, duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, emote sounds will be silenced while your character is:|n|n- resting|n- in a pet battle|n- at the Halfhill Market|n- at the Grim Guzzler|n|nEmote sounds will be enabled when none of the above apply."] = "케릭터가 다음 경우 감정표현이 음소거:|n|n- 휴식.|n- 애완동물 대전.|n- 언덕골 시장.|n- 주정뱅이 선술집.|n|n감정표현 소리는 위의 상황에 적용되지 않을때 활성화 됩니다."
L["If checked, enemy nameplates will be shown during combat and hidden when combat ends."] = "전투시에만 이름표가 표시되고 비전투시 표시되지 않습니다."
L["If checked, guild ranks will be shown for players in your guild."] = "나의 길드등급 표시"
L["If checked, most error messages (such as 'Not enough rage') will not be shown.  Some important errors are excluded.|n|nIf you have the minimap button enabled, you can hold down the control key and right-click it to toggle error messages without affecting this setting."] = "오류 메시지를 숨깁니다.(예:\"잘못된 대상입니다.\")|n|n몇가지 중요한 오류는 제외됩니다."
L["If checked, party invitations from friends or guild members will be automatically accepted unless you are queued in Dungeon Finder."] = "던전찾기 대기하지 않을때 친구,길드원 파티초대 자동 허용함."
L["If checked, party invitations will be blocked unless the player inviting you is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, pet battle duel requests will be blocked unless the player requesting the duel is in your friends list or guild."] = "친구목록,길드원 제외"
L["If checked, profession filter settings will be saved for the remainder of your login session."] = "이 옵션을 선택하면 남은 로그인 세션 동안 전문기술 필터 설정이 저장됩니다."
L["If checked, quests will be selected, accepted and turned-in automatically.|n|nQuests which have a gold, currency or crafting reagent requirement will not be turned-in automatically.|n|nYou can hold the shift key down when you talk to a quest giver to override this setting."] = "퀘스트가 자동으로 선택,수락 및 완료 됩니다.|n|n골드,화페,제작 재료의 요구사항이 있는 퀘스트는 자동 완료 되지 않습니다.|n|n대화할때 Shift키 사용으로 이 설정을 무시 할수 있습니다."
L["If checked, raid chat and instance chat will both be colored blue (to match the default party chat color)."] = "파티,공격대 챗색상 모두 같은색(파티)으로"
L["If checked, repair costs will be taken from guild funds for characters that are guilded and have permission to repair."] = "길드 자금을 사용가능한 경우 길드 자금으로 수리합니다."
L["If checked, requests initiated by your party leader to join the Dungeon Finder queue will be automatically accepted if the party leader is in your friends list or guild.|n|nThis option requires that you have selected a role for your character in the Dungeon Finder window."] = "파티장이 친구,길드원인 경우 던전대기열 요청을 자동 허용. |n|n던전은 자동으로 입장 되지 않습니다."
L["If checked, resurrection requests will be accepted automatically as long as the player resurrecting you is not in combat.|n|nResurrection requests from a Brazier of Awakening or a Failure Detection Pylon will not be accepted automatically."] = "부활 플레이어가 전투중 아닌경우 부활요청이 자동 수락됩니다.|n|n고장감지변환기,각성의화로 부활요청은 자동수락 제외 됩니다."
L["If checked, spell IDs will be shown in buff icon tooltips located in the buff frame and under the target frame."] = "버프,디버프 툴팁에 주문id 표시"
L["If checked, sticky chat will be disabled.|n|nNote that this does not apply to temporary chat windows."] = "길드,파티,공격대..대화채널을 고정 되지 않게합니다."
L["If checked, summon requests will be accepted automatically unless you are in combat."] = "비전투시 소환 자동수락"
L["If checked, the addon list (accessible from the game menu) will show character based addons by default."] = "게임옵션의 애드온 열때 해당 케릭터의 목록 표시(기본-전체)"
L["If checked, the amount of time it takes to auto loot creatures will be significantly reduced."] = "자동 전리품 획득 시간이 크게 줄어듭니다."
L["If checked, the backpack clean-up button and the bank frame clean-up button will not be shown."] = "소지품,은행 정리버튼 숨김"
L["If checked, the boss banner will not be shown.|n|nThe boss banner appears when a boss is defeated.  It shows the name of the boss and the loot that was distributed."] = "보스를 물리칠때 표시되는 전리품 이름을 숨깁니다."
L["If checked, the button to toggle the raid container frame will be shown just above the raid management frame (left side of the screen) instead of in the raid management frame itself.|n|nThis allows you to toggle the raid container frame without needing to open the raid management frame."] = "블리자드 공격대 프레임을 토글(숨김/표시)하는 버튼을  공격대 관리 창 (화면의 왼쪽)  위에 표시됩니다."
L["If checked, the clock will be hidden."] = "시계를 숨깁니다."
L["If checked, the combat log will be hidden.|n|nThe combat log must be docked in order for this option to work.|n|nIf the combat log is undocked, you can dock it by dragging the tab (and reloading your UI) or by resetting the chat windows (from the chat menu)."] = "전투 로그 창을 숨깁니다."
L["If checked, the 'Display only character achievements to others' setting in the game options panel ('Social' menu) will be permanently checked and locked."] = "게임설정-소셜의 '해당 케릭터의 업적만 표시' 를 사용하고 설정 잠금."
L["If checked, the editbox will be moved to the top of the chat frame."] = "채팅입력창을 프레임 상단으로 이동 설정됩니다."
L["If checked, the game world will be resized to fit between the top and bottom borders.|n|nNote that if you enable this setting, the transparency slider will no longer affect the top and bottom borders."] = "상단과 하단 변경 사이즈 맞게 조정됨."
L["If checked, the gossip window will not be shown when you talk to an active garrison bodyguard.|n|nYou can hold the shift key down when you talk to a bodyguard to override this setting."] = "주둔지 경비와 대화 할 때 대화창이 표시되지 않습니다.|n|n이 설정을 무시하려면 shift 누르고 대화 합니다."
L["If checked, the grey screen of death and the netherworld effect will be disabled."] = "죽음시 회색화면과 netherworld 효과가 비활성화됩니다."
L["If checked, the level-up display will not be shown.|n|nThe level-up display shows encounter objectives, level-ups, pet battle rewards, etc."] = "레벨 업,교전의 목표,팻대결 보상 표시 숨김"
L["If checked, the main bar gryphons will not be shown."] = "스킬바의 그리핀 문양 제거"
L["If checked, the order hall command bar will not be shown."] = "직업 전당에서의 상단 전당 바 숨김"
L["If checked, the screen glow will be disabled.|n|nEnabling this option will also disable the drunken haze effect."] = "빛 효과가 비활성 됩니다.|n|n사용시 술취한 어지럼 효과가 비활성 됩니다."
L["If checked, the social button and quick-join notification will be hidden."] = "사용시, 소셜 버튼과 빠른참여 알림을 숨깁니다."
L["If checked, the stance bar will not be shown."] = "태세바 숨김.(드루이드...)"
L["If checked, the talking frame will not be shown.|n|nThe talking frame normally appears in the lower portion of the screen when certain NPCs communicate with you."] = "화면 하단의 NPC 대화 프레임 숨김"
L["If checked, the tooltip will be color coded and you will be able to modify the tooltip layout and scale."] = "툴팁의 크기,위치,배경색 설정"
L["If checked, the tracking button will be merged with the calendar button.|n|nLeft-click the tracking button to show the tracking menu or right-click it to show the calendar."] = "달력이 추적 버튼에 병합됩니다.|n|n추적 버튼의 왼쪽 클릭으로 추적메뉴,오른쪽 클릭으로 달력을 표시 합니다."
L["If checked, the zone text bar will be hidden.  The tracking button tooltip will show zone information."] = "상단의 지역명을 숨깁니다.추적 버튼 툴팁에 지역정보가 표시됩니다."
L["If checked, the zoom buttons will be hidden.  You can use the mousewheel to zoom regardless of this setting."] = "줌 버튼을 숨깁니다.설정과 상관없이 마우스휠로 확대/축소 할수있습니다."
L["If checked, tooltips for world units will be hidden during combat.|n|nYou can hold the shift key down to override this setting."] = "전투 중 월드 유닛에 대한 툴팁을 숨깁니다.|n|nShift 키를 누르고 있으면 이 설정을 무시할 수 있습니다."
L["If checked, unit targets will be shown."] = "대상의 대상 표시"
L["If checked, Wowhead links will be shown in the world map frame and the achievements frame."] = "세계지도와 업적 창에 와우헤드 링크가 표시됩니다. "
L["If checked, you can hold down the alt key while opening a gossip window to automatically select a single gossip option."] = "Alt 키를 누른 상태에서 대화창을 열면 자동으로 하나의 대화를 선택합니다."
L["If checked, you can hold down the control key and click a chat tab to view recent chat in a copy-friendly window."] = "Ctrl키를 누른 상태에서 채팅창 탭을 클릭하면 복사하기 쉬운 최근의 채팅을 볼수 있습니다."
L["If checked, you can open Leatrix Plus by pressing CTRL/Z."] = "Ctrl/Z 키로 Leatrix Plus를 열수 있습니다."
L["If checked, you can press the arrow keys to move the insertion point left and right in the chat frame.|n|nIf unchecked, the arrow keys will use the default keybind setting."] = "채팅 입력에서 삽입 포인터를 방향키로 이동 할수 있습니다."
L["If checked, you will be able to cancel cinematics without being prompted for confirmation."] = "재생 중지 확인 없이 무비를 취소 할수 있습니다."
L["If checked, you will be able to change the font size of quest text.|n|nEnabling this option will also change the text size of other frames which inherit the same font (such as the Dungeon Finder frame)."] = "퀘스트 글자 크기를 변경 할수 있습니다."
L["If checked, you will be able to change the font size of standard mail text.|n|nThis does not affect mail created using templates (such as auction house invoices)."] = "우편글자 크기를 변경할수 있습니다."
L["If checked, you will be able to change the position and scale of the following frames:|n|n- Player frame|n- Target frame|n- Buffs frame|n- Widget top center frame|n- Ghost frame|n- Timer bar|n- Player power bar"] = "다음 프레임의 위치와 크기를 변경할 수 있습니다.|n|n- 플레이어 프레임|n- 대상 프레임|n- 버프 프레임|n- 위젯 상단 중앙 프레임|n- 고스트 프레임|n- 타이머 바|n- 플레이어 파워 바"
L["If checked, you will be able to create a viewport.  A viewport adds adjustable black borders around the game world.|n|nThe borders are placed on top of the game world but under the UI so you can place UI elements over them."] = "UI배치를 위한 상.하 검은색 배경 생성"
L["If checked, you will be able to customise the minimap."] = "미니맵을 사용자 정의 할 수 있습니다."
L["If checked, you will be able to drag the chat frame to the edge of the screen."] = "화면 모서리로 채팅창을 옮길수 있습니다."
L["If checked, you will be able to place up to five beneficial cooldown icons above the target frame."] = "대상창(기본프레임) 위에 최대 5개의 쿨다운(버프류) 아이콘을 배치 할 수 있습니다."
L["If checked, you will be able to reposition the tooltip."] = "툴팁의 위치를 변경할수 있습니다."
L["If checked, you will be able to save your current battle pet team (including abilities) to a single command.|n|nA button will be added to the Pet Journal.  Clicking the button will toggle showing the assignment command for your current team.  Pressing CTRL/C will copy the command to memory.|n|nYou can then paste the command (with CTRL/V) into the chat window or a macro to instantly assign your team."] = "현재의 애완동물 그룹을 저장. 애완동물 도감의 생성된 버튼 클릭으로 코드를 crtl+c , 매크로 만들기 ctrl+v."
L["If checked, you will be able to show a rare, elite or rare elite chain around the player frame."] = "플레이어 프레임에 희귀,정예 문양 표시"
L["If checked, you will be able to zoom out to a greater distance."] = "사용시 게임설정-시점-최대시야거리: Max 고정."
L["If checked, you will release automatically after you die in Ashran, Tol Barad (PvP), Wintergrasp or any battleground.|n|nYou will not release automatically if you have the ability to self-resurrect (soulstone, reincarnation, etc)."] = "아쉬란,톨 바라드,겨울손아귀 또는 전장에서 사망시 자동 해제.|n|n자기부활(영혼석,윤회)능력 경우 자동 해제되지 않습니다."
L["If checked, your bags will not be opened or closed automatically when you interact with a merchant, bank or mailbox."] = "상인,은행 NPC 대화 할때"
L["If checked, your chat history will increase to 4096 lines.  If unchecked, the default will be used (128 lines).|n|nEnabling this option may prevent some chat text from showing during login."] = "기본 128행을 4096행으로 증가"
L["If checked, your gear will be repaired automatically when you visit a suitable merchant.|n|nYou can hold the shift key down when you talk to a merchant to override this setting."] = "상인을 방문 할때 장비가 자동으로 수리됩니다.|n|nShift키 누른채 대화시 자동 무시."
L["If checked, zone text will not be shown (eg. 'Ironforge')."] = "화면 가운데 표시되는 지역명 숨김. (예: 아이언포지)"
L["Increase chat history"] = "채팅 기록 증가"
L["Interface"] = "인터페이스"
L["Into the Portal"] = "차원문"
L["Invalid battle pet team parameter."] = "잘못된 매개변수"
L["Invalid console variable."] = "잘못된 콘솔 변수."
L["Invalid parameter."] = "잘못된 매개변수"
L["Invalid quest ID."] = "잘못된 퀘스트ID"
L["Invalid sound ID"] = "잘못된 사운드 ID"
L["Invalid taint level."] = "잘못된 오염 레벨입니다."
L["Invalid target."] = "잘못된 대상"
L["Invite from whispers"] = "귓속말 초대"
L["Iron Docks"] = "강철 선착장"
L["Ironforge"] = "아이언포지"
L["Island Expeditions"] = "군도 탐험"
L["Isle of Conquest"] = "정복의 섬"
L["Isle of Quel'Danas"] = "쿠엘다나스 섬"
L["Isle of Thunder"] = "천둥의 섬"
L["Jade Forest"] = "비취 숲"
L["Jade Forest Crash"] = "Jade Forest Crash"
L["Jaina Joins the Battle"] = "공성전 제이나 합류"
L["Jaina Returns to Kul Tiras"] = "쿨 티라스에 돌아온 제이나"
L["Jaina's Nightmare"] = "제이나의 악몽"
L["Jaina's Siege"] = "제이나-다자알로 전투 오프닝"
L["Jaina's Theme"] = "제이나 테마"
L["Jorundall"] = "조룬달"
L["Kalimdor"] = "칼림도어"
L["Karazhan"] = "카라잔"
L["Kezan"] = "케잔"
L["Kil'jaeden's Downfall"] = "킬제덴의 몰락"
L["Kings' Rest"] = "왕들의 안식처"
L["Krasarang Wilds"] = "크라사랑 밀림"
L["Krokuun (Argus)"] = "크로쿠운(아르거스)"
L["Kul Tiran Humans"] = "쿨 티란"
L["Kul Tiras"] = "쿨 티라스"
L["Kun-Lai Summit"] = "쿤라이 봉우리"
L["Last Stand"] = "최후의 저항"
L["Leatrix Plus will not overwrite LeaPlusDB at next logout."] = "Leatrix Plus는 다음 로그 아웃시 LeaPlusDB를 덮어 쓰지 않습니다."
L["Leaving Kezan"] = "케잔을 떠나다."
L["Leaving the Wandering Isle"] = "유랑도를 떠나다."
L["Left"] = "왼쪽"
L["Legion"] = "군단"
L["Lifetime honorable kills"] = "전체 명예 승수"
L["Lightforged Draenei"] = "빛벼림 드레나이"
L["Lion's Watch"] = "사자의 감시터"
L["Loch Modan"] = "모단 호수"
L["Lockout sharing"] = "업적공유 잠금"
L["Lost City of the Tol'vir"] = "토비르의 잃어버린 도시"
L["Lost Isles"] = "잃어버린 섬"
L["Lower Blackrock Spire"] = "검은바위 첨탑 하층"
L["Lunastre Estate"] = "루나스트르 장원"
L["Mac'Aree (Argus)"] = "마크아리(아르거스)"
L["Madness of Deathwing"] = "데스윙의 광기"
L["Maelstrom"] = "혼돈의 소용돌이"
L["Mag'har Orcs"] = "마그하르 오크"
L["Magisters' Terrace"] = "마법학자의 정원"
L["Magtheridon's Lair"] = "마그테리돈의 둥지"
L["Mail Text"] = "우편 글자"
L["Main Titles"] = "메인 타이틀"
L["Manage frames"] = "프레임 설정"
L["Manage tooltip"] = "툴팁 설정"
L["Managed by Leatrix Plus"] = "Leatrix Plus 에서 설정"
L["Mana-Tombs"] = "마나 무덤"
L["Maraudon"] = "마라우돈"
L["Maraudon: Earth Song Falls"] = "마라우돈:대지노래 폭포"
L["Maraudon: Foulspore Cavern"] = "마라우돈:썩은포자 동굴"
L["Maraudon: The Wicked Grotto"] = "마라우돈:악의 동굴"
L["Mardum"] = "마르둠"
L["Maw of Souls"] = "지옥어귀 벼랑"
L["Max camera zoom"] = "시야거리 최대 고정"
L["Mechanics"] = "기능"
L["Media"] = "미디어"
L["Memory Usage"] = "메모리 사용"
L["Merge the tracking and calendar buttons"] = "추적,달력 버튼 병합"
L["message shown."] = "메시지가 표시됩니다."
L["messages shown."] = "메시지가 표시됩니다."
L["Minimap"] = "미니맵"
L["Missing console variable."] = "누락된 콘솔 변수."
L["Missing mount name."] = "누락된 탈거."
L["Missing movie ID."] = "잘못된 무비 ID."
L["Missing pet name."] = "누락된 팻."
L["Missing quest ID."] = "퀘스트ID 없음"
L["Missing sound file parameter."] = "소리 파일 매개변수 에러"
L["Missing sound ID."] = "누락 된 사운드 ID."
L["Mists of Pandaria"] = "판다리아의 안개"
L["Mogu'shan Palace"] = "모구샨 궁전"
L["Mogu'shan Vaults"] = "모구샨 금고"
L["Molten Core"] = "화산 심장부"
L["Moon Guard Stronghold"] = "달빛 수호자 성채"
L["Moonglade"] = "달숲"
L["Motherlode"] = "왕노다지 광산!!"
L["Mount Hyjal"] = "하이잘 산"
L["Mount not found."] = "탈거를 찾을수 없습니다."
L["Move editbox to top"] = "입력창 상단"
L["Movie not playable."] = "무비를 재생할수 없습니다."
L["Movie number"] = "무비 번호"
L["Movies"] = "무비"
L["Mulgore"] = "멀고어"
L["Music"] = "배경음악"
L["Music Rolls"] = "주크박스"
L["My Very Own Castle (Alliance)"] = "나만의 성(얼라이언스)"
L["My Very Own Castle (Horde)"] = "나만의 성(호드)"
L["Mystical"] = "신비"
L["Nagrand"] = "나그란드"
L["Nagrand (Draenor)"] = "나그란드 (드레노어)"
L["Narration"] = "나레이션"
L["Naxxramas"] = "낙스라마스"
L["Nazmir"] = "나즈미르"
L["Neltharion's Lair"] = "넬타리온의 둥지"
L["Netherstorm"] = "황천의 폭풍"
L["Nexus"] = "마력의 탑"
L["Nightborne"] = "나이트본"
L["Nighthold"] = "밤의 요새"
L["No bad sound IDs found."] = "잘못된 ID를 찾을수 없습니다."
L["No help is available for this page."] = "도움말을 사용할수 없습니다."
L["No items with durability equipped."] = "내구성 갖춘 아이템이 없습니다."
L["No media duplicates found."] = "중복된 미디어가 없습니다."
L["No tooltip showing."] = "툴팁이 없습니다."
L["None"] = "없음"
L["Northern Barrens"] = "북부 불모의 땅"
L["Northern Stranglethorn"] = "북부 가시덤불"
L["Northrend"] = "노스렌드"
L["NOTICE!|nYou must fully restart your game client before you can use this version of Leatrix Plus."] = "주의!|nLeatrix Plus 이 버전을 적용하려면 게임 클라이언트를 다시 시작해야합니다."
L["Nude"] = "옷벗기"
L["Obsidian Sanctum"] = "흑요석 성소"
L["Old Hillsbrad Foothills"] = "옛 언덕마루 구릉지"
L["Onyxia's Lair"] = "오닉시아의 둥지"
L["Orgrimmar"] = "오그리마"
L["Outland"] = "아웃랜드"
L["Overall"] = "전체"
L["Pandaria"] = "판다리아"
L["Particle density"] = "입자 밀도"
L["Party from friends"] = "친구의 파티"
L["Pet"] = "소환수"
L["Pet Battles"] = "애완동물 대전"
L["Pet not found.  Only owned pets that are currently showing in the journal can be searched."] = "팻을 찾을수 없습니다. 도감의 현재 소유한 팻을 검색할수 있습니다."
L["Pit of Saron"] = "사론의 구덩이"
L["Plants vs Zombies"] = "식물 vs 좀비"
L["Player"] = "플레이어"
L["Player Chain"] = "플레이어 테두리"
L["Portal"] = "차원문"
L["Power"] = "파워"
L["Power of the Horde"] = "파워 오브 더 호드"
L["Press CTRL/C to copy."] = "Ctrl+C 를 눌러 복사."
L["Quest completed."] = "퀘스트 완료"
L["Quest not completed."] = "퀘스트 미완료"
L["Quest Text"] = "퀘스트 글자"
L["Queue from friends"] = "친구의 대기열"
L["Ragefire Chasm"] = "성난불길 협곡"
L["Raid"] = "공격대"
L["Raid frame toggle"] = "레이드 프레임 토글"
L["Random"] = "무작위 재생"
L["RARE"] = "희귀"
L["RARE ELITE"] = "희귀 정예"
L["Razorfen Downs"] = "가시덩굴 구릉"
L["Razorfen Kraul"] = "가시덩굴 우리"
L["Realm Of Torment"] = "Realm Of Torment"
L["Recent chat window"] = "최근 채팅 창"
L["Redridge Mountains"] = "붉은마루 산맥"
L["Reincarnation of Alleria Windrunner"] = "알레리아 원드러너의 환생"
L["Rejection of the Gift"] = "힘의 선물을 거부하다."
L["Release in PvP"] = "PvP지역 부활 수락 해제"
L["Reload"] = "리로드"
L["Remove raid restrictions"] = "공격대 제한 해제"
L["Repair Automatically"] = "자동 수리"
L["Repair automatically"] = "자동 수리"
L["Repair using guild funds if available"] = "길드 자금 사용"
L["Repaired for"] = "수리비"
L["Reposition the tooltip"] = "툴팁 위치 설정"
L["Requires UI reload."] = "UI 리로드 필요."
L["Requires you to be interacting with Larana Drome.  She can be found at Scribes' Sacellum, Dalaran, Northrend."] = "라라나 드롬과 상호 작용해야합니다. 그녀는 노스렌드,달라란,각인사의 성소 에서 찾을 수 있습니다."
L["Reset"] = "재설정"
L["Resize mail text"] = "우편 글자 설정"
L["Resize quest text"] = "퀘스트 글자 설정"
L["Resize Screen"] = "화면 크기 조정"
L["Resize the game world"] = "게임화면크기 재설정"
L["Rested bubbles"] = "휴식 버블"
L["result"] = "결과"
L["results"] = "결과들"
L["Return to Karazhan"] = "다시 찾은 카라잔"
L["Return to the Black Temple"] = "검은 사원으로 돌아가다."
L["Rev"] = "미탐험"
L["Right"] = "오른쪽"
L["Right-click to close"] = "창닫기:우클릭."
L["Right-click to close."] = "창닫기:우클릭. ."
L["right-click to go back"] = "마우스 오른쪽 클릭으로 뒤로 이동."
L["Rise of Argus"] = "일어나라.아르거스."
L["Risking It All"] = "위험한 도박"
L["Ruby Sanctum"] = "루비 성소"
L["Ruins of Ahn'Qiraj"] = "안퀴라즈 폐허"
L["Ruins of Elune'eth"] = "엘룬에스의 페허"
L["Ruins of Gilneas"] = "길니아스 폐허"
L["Sanctum of Order"] = "질서의 성소"
L["Save profession filters"] = "전문기술 필터 저장"
L["Scale"] = "크기"
L["Scarlet Halls"] = "붉은십자군 전당"
L["Scarlet Monastery"] = "붉은십자군 수도원"
L["Scholomance"] = "스칼로맨스"
L["Search"] = "검색"
L["Searing Gorge"] = "이글거리는 협곡"
L["Seat of the Triumvirate"] = "삼두정의 권좌"
L["Select the settings that you want to use."] = "사용하려는 설정을 선택합니다."
L["Selection of music tracks"] = "음악 트랙 선택"
L["Self Markers Allowed"] = "전술 징표 허용 "
L["Self Markers Blocked"] = "전술 징표 차단"
L["Sell junk automatically"] = "회색템 자동 판매"
L["SELLING JUNK"] = "자동판매"
L["Serpentshrine Cavern"] = "불뱀 제단"
L["Sethekk Halls"] = "세데크 전당"
L["Settings"] = "설정"
L["Shaders"] = "쉐이더"
L["Shado-Pan Monastery"] = "음영파 수도원"
L["Shadow Labyrinth"] = "어둠의 미궁"
L["Shadowfang Keep"] = "그림자송곳니 성채"
L["Shadowmoon Burial Grounds"] = "어둠달 지하묘지"
L["Shadowmoon Valley"] = "어둠달 골짜기"
L["Shadowmoon Valley (Draenor)"] = "어둠달 골짜기 (드레노어)"
L["Shipyard Construction (Alliance)"] = "조선소 건설 (얼라이언스)"
L["Shipyard Construction (Horde)"] = "조선소 건설 (호드)"
L["Sholazar Basin"] = "숄라자르 분지"
L["Show auction controls"] = "경매 추가 기능"
L["Show character addons"] = "케릭터 애드온 표시"
L["Show cooldowns"] = "쿨다운 아이콘 표시"
L["Show durability status"] = "내구도 표시"
L["Show guild ranks for your guild"] = "나의 길드 등급 표시"
L["Show minimap button"] = "미니맵 버튼 표시"
L["Show pet save button"] = "애완동물 저장 버튼"
L["Show player chain"] = "플레이어 테두리 표시"
L["Show the spell ID in buff icon tooltips"] = "툴팁 주문ID 표시"
L["Show the unit's target"] = "대상의대상 표시"
L["Show volume slider"] = "소리 조절 표시"
L["Show Wowhead links"] = "와우헤드 링크 표시"
L["Shrine of the Storm"] = "폭풍의 사원"
L["Siege of Boralus"] = "보랄러스 공성전"
L["Siege of Niuzao Temple"] = "니우짜오 사원 공성전투"
L["Siege of Orgrimmar"] = "오그리마 공성전"
L["Silence rested emotes"] = "감정표현 음소거"
L["Silithus"] = "실리더스"
L["Silverpine Forest"] = "은빛소나무 숲"
L["Silvershard Mines"] = "은빛수정 광산"
L["Skyreach"] = "하늘탑"
L["Slave Pens"] = "강제 노역소"
L["Social"] = "소셜"
L["Sold junk for"] = "회색템 판매"
L["Sound system restarted."] = "사운드 시스템 재시작."
L["Southern Barrens"] = "남부 불모의 땅"
L["Spell ID"] = "주문 ID"
L["Spine of Deathwing"] = "데스윙의 등"
L["Spires of Arak"] = "아라크 첨탑"
L["Steamvault"] = "증기 저장고"
L["Stockade"] = "스톰윈드 지하감옥"
L["Stonecore"] = "바위심장부"
L["Stonetalon Mountains"] = "돌발톱 산맥"
L["Stop"] = "중지"
L["Storm Peaks"] = "폭풍우 봉우리"
L["Stormheim"] = "스톰하임"
L["Stormheim (Alliance)"] = "Stormheim (Alliance)"
L["Stormheim (Horde)"] = "Stormheim (Horde)"
L["Stormsong Valley"] = "폭풍노래 계곡"
L["Stormstout Brewery"] = "스톰스타우트 양조장"
L["Stormwind"] = "스톰윈드"
L["Strand of the Ancients"] = "고대의 해안"
L["Stratholme"] = "스트라솔름"
L["Stratholme: Crusader's Square"] = "스트라솔름:십자군 광장"
L["Stratholme: The Gauntlet"] = "스트라솔름:투쟁의 거리"
L["Sunken Temple"] = "가라앉은 사원"
L["Sunwell Plateau"] = "태양샘 고원"
L["Support"] = "지원"
L["Suramar"] = "수라마르"
L["Swamp of Sorrows"] = "슬픔의 늪"
L["System"] = "시스템"
L["Tabard"] = "휘장숨김"
L["Taint level: Basic (1)."] = "오염 레벨: Basic (1)"
L["Taint level: Disabled (0)."] = "오염 레벨: 비활성(0)"
L["Taint level: Full (2)."] = "오염 레벨: Full (2)"
L["Talador"] = "탈라도르"
L["Tanaan Jungle"] = "타나안 밀림"
L["Tanaris"] = "타나리스"
L["Target"] = "대상"
L["Target Tracking Disabled"] = "대상 추적 사용안함"
L["Target Tracking Enabled"] = "대상 추적 사용"
L["Tea with Jaina"] = "Tea with Jaina"
L["Tel'anor"] = "텔아노르"
L["Teldrassil"] = "텔드랏실"
L["Tempest Keep"] = "폭풍우 요새"
L["Temple of Ahn'Qiraj"] = "안퀴라즈"
L["Temple of Atal'Hakkar"] = "아탈학카르 신전"
L["Temple of Kotmogu"] = "코트모구의 사원"
L["Temple of Sethraliss"] = "세스랄리스 사원"
L["Temple of the Jade Serpent"] = "옥룡사"
L["Ten Years of Warcraft"] = "워크래프트 10주년"
L["Terokkar Forest"] = "테로카르 숲"
L["Terrace of Endless Spring"] = "영원한 봄의 정원"
L["Terror of Darkshore"] = "어둠해안의 공포"
L["Text"] = "글자"
L["Text size"] = "글자 크기"
L["Text Size"] = "글자 크기"
L["The Arcatraz"] = "알카트라즈"
L["The Art of War"] = "전쟁의 기술"
L["The Bastion of Twilight"] = "황혼의 요새"
L["The Battle for Broken Shore"] = "부서진 해변 전투"
L["The Battle for Shattrath"] = "샤트라스 전투"
L["The Battle of Thunder Pass"] = "천둥 고개 전투"
L["The Black Morass"] = "검은늪"
L["The Blood Furnace"] = "피의 용광로"
L["The Botanica"] = "신록의 정원"
L["The Burning Crusade"] = "불타는 성전"
L["The Culling of Stratholme"] = "옛 스트라솔름"
L["The Deadmines"] = "죽음의 폐광"
L["The Demon's Trail"] = "악마의 발자취"
L["The Dragon Soul"] = "용의 영혼"
L["The Everbloom"] = "상록숲"
L["The Eye"] = "폭풍우 요새"
L["The Eye of Eternity"] = "영원의 눈"
L["The Fall of Lordaeron"] = "로데론의 몰락"
L["The Fate of Val'sharah"] = "발샤라의 운명"
L["The Fleet in Krasarang (Alliance)"] = "크라사랑 함대(얼라이언스)"
L["The Fleet in Krasarang (Horde)"] = "크라사랑 함대(호드)"
L["The Forge of Souls"] = "영혼의 제련소"
L["The Frozen Halls"] = "얼어붙은 전당"
L["The Halls of Reflection"] = "투영의 전당"
L["The Invasion Begins"] = "침공의 시작"
L["The King's Command"] = "국왕의 명령"
L["The Mechanar"] = "메카나르"
L["The Nexus"] = "마력의 탑"
L["The Nightborne Pact"] = "나이트본의 맹세"
L["The Nighthold"] = "The Nighthold"
L["The Obsidian Sanctum"] = "흑요석 성소"
L["The Oculus"] = "마력의 눈"
L["The Old Kingdom"] = "고대 왕국"
L["The Pit of Saron"] = "사론의 구덩이"
L["The Return of Hope"] = "The Return of Hope"
L["The Ruby Sanctum"] = "루비 성소"
L["The Shattered Halls"] = "으스러진 손의 전당"
L["The Stockade"] = "지하감옥"
L["The Stonecore"] = "바위심장부"
L["The Violet Hold"] = "보랏빛 요새"
L["The Vortex Pinnacle"] = "소용돌이 누각"
L["The Waning Crescent"] = "기우는 초승달"
L["Themes"] = "테마"
L["This command will assign your current pet team and selected abilities.|n|nPress CTRL/C to copy the command then paste it into a macro or chat window with CTRL/V."] = "현재 팻과 선택된 능력을 그룹으로 저장합니다. 생성된 코드를 복사 crtl+c , 매크로에 붙어넣기 ctrl+v 저장"
L["This panel will close automatically if you enter combat."] = "전투시 자동으로 닫힙니다."
L["Thousand Needles"] = "버섯구름 봉우리"
L["Throne of the Four Winds"] = "네 바람의 왕좌"
L["Throne of the Tides"] = "파도의 왕좌"
L["Throne of Thunder"] = "천둥의 왕좌"
L["Thunder Bluff"] = "썬더 블러프"
L["Timeless Isle"] = "영원의 섬"
L["Timer"] = "미러바"
L["Tiragarde Sound"] = "티라가드 해협"
L["Tirisfal Glades"] = "티리스팔 숲"
L["To begin, choose an options page."] = "설정 페이지를 선택합니다."
L["To use the Find Item button, you need to deselect the WoW Token category."] = "아이템찾기 사용하려면, 'WoW토큰' 카테고리 선택을 취소 해야 합니다. "
L["Tol Barad"] = "톨 바라드"
L["Tol Dagor"] = "톨 다고르"
L["Tomb of Sargeras"] = "살게라스의 무덤"
L["Tooltip"] = "툴팁"
L["Tooltip title color"] = "툴팁 제목 색상"
L["Top"] = "상단"
L["Top Center"] = "탑 센터"
L["Townlong Steppes"] = "탕랑 평원"
L["Tracing started."] = "추적 시작."
L["Tracing stopped."] = "추적 중지."
L["Transparency"] = "투명도"
L["Trial of Style"] = "멋의 대제전"
L["Trial of the Champion"] = "용사의 시험장"
L["Trial of the Crusader"] = "십자군의 시험장"
L["Trial of Valor"] = "용맹의 시험"
L["True"] = "참된"
L["Twilight Highlands"] = "황혼의 고원"
L["Twilight Vineyards"] = "황혼의 포도원"
L["Twin Peaks"] = "쌍둥이 봉우리"
L["Uldaman"] = "울다만"
L["Uldir"] = "울디르"
L["Ulduar"] = "울두아르"
L["Uldum"] = "울둠"
L["Unclamp chat frame"] = "채팅창 고정 해제"
L["Underbog"] = "지하수렁"
L["Undercity"] = "언더시티"
L["Underrot"] = "썩은굴"
L["Un'Goro Crater"] = "운고로 분화구"
L["Universal group color"] = "그룹 색상 통합"
L["Upper Blackrock Spire"] = "검은바위 첨탑 상층"
L["Use arrow keys in chat"] = "방향키 사용"
L["Use easy resizing"] = "쉬운 크기조절"
L["Use Leatrix Plus to move that frame."] = "프레임 이동 사용"
L["Use Leatrix Plus to reset that frame."] = "프레임 재설정 사용"
L["Utgarde Keep"] = "우트가드 성채"
L["Utgarde Pinnacle"] = "우트가드 첨탑"
L["Vale of Eternal Blossoms"] = "영원꽃 골짜기"
L["Valley of the Four Winds"] = "네 바람의 계곡"
L["Val'sharah"] = "발샤라"
L["Value must be a number."] = "값은 숫자 이여야 합니다."
L["Various"] = "기타"
L["Vashj'ir"] = "바쉬르"
L["Vault of Archavon"] = "아카본 석실"
L["Vault of the Wardens"] = "감시관의 금고"
L["Vendors"] = "상인"
L["Version"] = "버전"
L["Victory at The Nighthold"] = "밤의 요새 승리"
L["Victory in Draenor!"] = "드레노어의 승리"
L["Video"] = "비디오"
L["Viewport"] = "뷰포트"
L["Violet Hold"] = "보랏빛 요새"
L["Visibility"] = "가시성"
L["Vision of Sailor's Memory"] = "Vision of Sailor's Memory"
L["Void Elves"] = "공허 엘프"
L["Vol'dun"] = "볼둔"
L["Vol'mar"] = "볼마르"
L["Wailing Caverns"] = "통곡의 동굴"
L["Wandering Isle"] = "유랑도"
L["Warbringers Azshara"] = "Warbringers Azshara"
L["Warbringers Jaina"] = "Warbringers Jaina"
L["Warbringers Sylvanas"] = "전쟁인도자 실바나스"
L["Warfronts"] = "격전지"
L["Warlords of Draenor"] = "드레노어의 전쟁군주"
L["Warsong Gulch"] = "전쟁노래 협곡"
L["was automatically declined."] = "자동으로 거절되었습니다."
L["Waycrest Manor"] = "웨이크레스트 저택"
L["Weather density"] = "기상 밀도"
L["Welcome to Leatrix Plus."] = "Leatrix Plus 에 오신 것을 환영합니다."
L["Well of Eternity"] = "영원의 샘"
L["Western Plaguelands"] = "서부 역병지대"
L["Westfall"] = "서부 몰락지대"
L["Wetlands"] = "저습지"
L["Widget"] = "위젯"
L["Winter"] = "겨울"
L["Wintergrasp"] = "겨울손아귀 호수"
L["Winterspring"] = "여명의 설원"
L["World of Warcraft"] = "월드 오브 워크래프트"
L["Wrath of the Lich King"] = "리치 왕의 분노"
L["Wyrmrest Temple"] = "고룡쉼터 사원"
L["YOU"] = "당신"
L["You cannot do that in combat."] = "전투중으로 할수 없습니다."
L["You do not own this pet.  Only owned pets can be searched."] = "당신은 이 팻을 소유하고 있지 않습니다. 소유한 팻만 검색할수 있습니다."
L["You have"] = "장비 내구도"
L["You need a battle pet team."] = "애완동물대전 팀이 필요합니다."
L["Your UI needs to be reloaded for some of the changes to take effect.|n|nYou don't have to click the reload button immediately but you do need to click it when you are done making changes and you want the changes to take effect."] = "일부 변경사항을 적용하려면 UI를 다시 로드 하여야 합니다. 요구시 리로드 버튼 활성화."
L["Your UI needs to be reloaded."] = "당신의 UI는 다시 로드 해야 합니다."
L["Zandalar"] = "잔달라"
L["Zandalari Trolls"] = "잔달라 트롤"
L["Zangarmarsh"] = "장가르 습지대"
L["Zones"] = "지역"
L["Zul'Aman"] = "줄아만"
L["Zuldazar"] = "줄다자르"
L["Zul'Drak"] = "줄드락"
L["Zul'Farrak"] = "줄파락"
L["Zul'Gurub"] = "줄구룹"
L["Zygor addon not found."] = "Zygor 애드온 찾을수 없음."

end

-- esMX: Spanish (Mexico)
if GameLocale == "esMX" then

end

-- esES: Spanish (Spain)
if GameLocale == "esES" then

end

-- frFR: French
if GameLocale == "frFR" then

end

-- itIT: Italian
if GameLocale == "itIT" then

end

-- ptBR: Portugese (Brazil)
if GameLocale == "ptBR" then

end
