--[[
Copyright (c) 2009-2018, Hendrik "Nevcairiel" Leppkes < h.leppkes@gmail.com >
All rights reserved.
]]

local Mapster = LibStub("AceAddon-3.0"):GetAddon("Mapster")
local L = LibStub("AceLocale-3.0"):GetLocale("Mapster")

local MODNAME = "FogClear"
local FogClear = Mapster:NewModule(MODNAME, "AceHook-3.0", "AceEvent-3.0")

local mod, floor, ceil, tonumber = math.fmod, math.floor, math.ceil, tonumber
local ipairs, pairs = ipairs, pairs

-- data
-- [MapArtID] = {
--   key: w + h + x + y, 12-bits each for 48 total, value = string list of file data IDs
-- }
local errata = {
	[2] = {
		[11135190888888] = "440583",
		[13197228413334] = "271426",
		[14296286978048] = "271427",
		[14434447450410] = "271440",
		[15121943523376] = "271439",
		[15396972982429] = "271421",
		[16221086543932] = "271428",
		[16771278020782] = "440584",
		[17045082267912] = "271422",
		[17459076858168] = "271443,440585",
		[17801113980928] = "271435,271442",
		[22681707270557] = "271437,440582",
	},
	[8] = {
		[11823190344001] = "272176",
		[11960294576468] = "272180",
		[12784928563243] = "272169",
		[12785448386661] = "272177",
		[12853312172256] = "272185",
		[13059587616768] = "272172",
		[13815417983178] = "272178",
		[14298686496906] = "272186,457475",
		[14984068079836] = "272181",
		[15259114471424] = "272179",
		[16289603817472] = "457473",
		[17871142973731] = "272170,457474",
		[20757024600337] = "272173,457470",
		[25636710973502] = "272187,272171,457476,457477",
		[30653316981137] = "272168,272165,457471,457472",
	},
	[11] = {
		[14230503993473] = "270569,438215",
		[15052503658875] = "270585",
		[16014877565203] = "270559",
		[16427832447230] = "270574",
		[16564666638440] = "270554",
		[16702475337855] = "270584",
		[17665084698630] = "270564,438223",
		[17939408363526] = "438216,438217",
		[19107523063815] = "270553,438214",
		[19452142239801] = "270572,438218,438219,438220",
		[21650194219464] = "270573,438222",
		[23094594208123] = "270565,438224,438225,438226",
		[25912695947582] = "438227,438228,438229,438230",
		[30653182001360] = "270560,438221",
	},
	[15] = {
		[12579659292798] = "270360",
		[13473548488849] = "270352,438180",
		[14434900197520] = "270350",
		[14573646119056] = "438173,438174",
		[14777842974993] = "438169",
		[15123100291096] = "270347,438168",
		[15603818053737] = "270351,438179",
		[15671849947448] = "270346",
		[16290744914336] = "270348",
		[17115814473851] = "270349,438167",
		[17321637998959] = "270342,438166",
		[17870756888935] = "270353,438184",
		[18558807724150] = "270336,438176,438177,438178",
		[18764913758608] = "270361,438170,438171,438172",
		[19521465307405] = "270358,438181,438182,438183",
		[21032322392313] = "270343,438175",
	},
	[16] = {
		[14365660655732] = "270532",
		[14710750117987] = "270525,270521",
		[16222160650259] = "270530,442231",
		[17323230494786] = "270529,442225",
		[18282905403392] = "442238,442239",
		[18836654485724] = "270540,270527,442226,442227",
		[19588793131076] = "270543,442224",
		[22545240354994] = "442232,442233,442234,442235",
		[23301724307737] = "270520,442228,442229,442230",
		[23507984343355] = "270522,270550,270528,270536",
		[32239721205815] = "270534,270551,270546,270535,442236,442237",
	},
	[18] = {
		[11547725754470] = "391431",
		[13403638415360] = "438233",
		[13678381683162] = "438238",
		[14983918039137] = "391430",
		[16016102400374] = "438236,438237",
		[16152232489142] = "391434",
		[16358507941998] = "391425",
		[16497206632539] = "438234,438235",
		[18422761083148] = "438243,438244,438245,438246",
		[18695154835456] = "391435,438231",
		[20275687137286] = "391432,438232",
		[21169391075503] = "391429,391428",
		[23920367911223] = "438247,438248,438249,438250",
		[25431207510195] = "438239,438240,438241,438242",
	},
	[19] = {
		[11067764457571] = "272996",
		[12029434454248] = "273000",
		[12303623278847] = "440917",
		[13060292857985] = "273020",
		[13678231290108] = "273015",
		[14435991408762] = "273009,273002",
		[14571500347709] = "273016",
		[15466598084933] = "273003,440921",
		[16633118925124] = "273006",
		[17184553107606] = "272999,440935",
		[18008901566511] = "440926,440927,440928,440929",
		[19589414273114] = "273019,440914,440915,440916",
		[19657546043584] = "273017,440930",
		[20140480287050] = "440931,440932,440933,440934",
		[26805077176679] = "440922,440923,440924,440925",
		[29624922837199] = "273001,440918,440919,440920",
	},
	[22] = {
		[10448533131591] = "440742",
		[11135442800717] = "440744",
		[11960528941124] = "440735",
		[12097179971740] = "440741",
		[12303555957073] = "272613",
		[12785817161728] = "440734",
		[14915450319060] = "272598",
		[14984202768541] = "272620",
		[15602207866880] = "272610",
		[17251391734009] = "272616",
		[17526487896493] = "440740",
		[19315961704448] = "440736,440737,440738,440739",
		[19451690864890] = "272614,440725",
		[21857208078741] = "272599,440726,440727,440728",
		[24194324910095] = "272600,440729,440730,440731",
		[24810668937216] = "440732,440733",
		[28108985197050] = "272609,440743",
	},
	[23] = {
		[11616865059148] = "273102",
		[12716964212887] = "273121",
		[13335070609798] = "273107",
		[16564951601380] = "273113",
		[16565623779541] = "273094",
		[19930880794835] = "441018,441019",
		[21379074314240] = "273122,273103,441023,441024",
		[21720656445675] = "273120,441020,441021,441022",
		[22337052393704] = "441015,441016",
		[24673346547835] = "273114,441017",
		[25292459495872] = "273108,273101",
		[29691361538048] = "273095,273111,273100,273090",
		[31891290194263] = "441011,441012,441013,441014",
		[33815252689250] = "273119,273092,273112,273093",
	},
	[24] = {
		[12167812559111] = "271543,271530",
		[12441180295352] = "271542",
		[12512315044188] = "442692,442693",
		[12785398239521] = "271544",
		[13472711241999] = "271533",
		[13884539806047] = "271548",
		[13884723843407] = "271551",
		[14710232101278] = "271553",
		[15672624046182] = "442674,442675",
		[16359112564887] = "271523",
		[16701552357647] = "442677",
		[17045887201742] = "271514",
		[17183092052037] = "271521",
		[17734993707018] = "271522,442685,442686,442687",
		[18013327720548] = "271538,271513,442695,442696,442697,442698",
		[18148202783015] = "442680,442681,442682,442683",
		[18214555983933] = "271520,442678",
		[18283426013611] = "271532,442676",
		[18832761254099] = "271536,442688",
		[19038232506368] = "271535,442679",
		[19244993708489] = "271512,442694",
		[19656725299200] = "271554,442699",
		[20414703640631] = "271537,442689,442690,442691",
		[21306024615936] = "271529,442684",
		[22544233594920] = "271518,271527",
	},
	[26] = {
		[7218029682943] = "450678",
		[7973624971518] = "450649",
		[9210492153957] = "450634",
		[9279815459040] = "450633",
		[9897937502713] = "450668",
		[10104449175831] = "450639",
		[10172497514551] = "450670",
		[10172934013094] = "450671",
		[10653986992268] = "450648",
		[10860513988650] = "450666",
		[11342121459938] = "450677",
		[11753313693887] = "450650",
		[12372560441743] = "450628",
		[12991019200597] = "450669",
		[14022868951413] = "450667",
		[14571215228928] = "450679",
		[15740435951968] = "450674",
		[17182671773912] = "450665",
		[17731522220032] = "450637,450638",
		[18489869984154] = "450640,450641,450642,450643",
		[18901096173612] = "450675,450676",
		[20756218769710] = "450651,450652",
		[21444738396470] = "450672,450673",
		[21719348043913] = "450635,450636",
		[30037980172505] = "450644,450645,450646,450647",
		[30722020782148] = "450629,450630,450631,450632",
	},
	[27] = {
		[12098572558531] = "271933",
		[13130084667497] = "271927,440600",
		[13678516134140] = "271929",
		[13678733811981] = "271934",
		[14297075216543] = "271910",
		[15465172062551] = "271922",
		[15534377238812] = "440603",
		[16359714980076] = "271917,440597",
		[16495963652475] = "271937",
		[16564934787253] = "271928",
		[16774282760459] = "271938,271916",
		[19314554130640] = "271915,271921,440601,440602",
		[19727340433742] = "271912,271920,440598,440599",
		[20827221110789] = "271908,271935,271936,271909",
	},
	[28] = {
		[11754958016644] = "445524",
		[11961368850738] = "271401",
		[12647539675356] = "271417",
		[13610670190880] = "271408",
		[14502495478047] = "271400",
		[14984774910220] = "271409",
		[15466514252116] = "271406,438340",
		[15536224030976] = "438345,438346",
		[16223803830272] = "271392,442671",
		[16292659580971] = "442672,442673",
		[17114222375137] = "271389",
		[21171221782528] = "438354,438355,438356,438357",
		[25844346576896] = "271410,271396,438352,438353",
		[27355418870126] = "438341,438342,438343,438344",
		[28111601139739] = "438348,438349,438350,438351",
		[30034589065443] = "271398,438347",
	},
	[33] = {
		[20894815564200] = "450682,450683",
		[25089202454603] = "254509,254510,254511,254512",
		[25774954381673] = "254503,254504,450680,450681",
		[26943993200640] = "254505,254506,254507,254508",
		[29485706506278] = "450692,450693,450694,450695",
		[30309754155249] = "450684,450685,450686,450687",
		[33060109058219] = "254529,254530,254531,254532",
		[39243990290792] = "254527,254528,450688,450689,450690,450691",
	},
	[37] = {
		[12512984563712] = "270938,455906",
		[18833551360151] = "270927,455911,455912,455913",
		[18836066652415] = "270933,270943,270921,270928",
		[19316682846208] = "270919,270911,455907,455908",
		[20485284442370] = "270920,270914,270908,270929",
		[21996692746240] = "270912,270909,455909,455910",
		[22271051321344] = "270922,270934,270923,270937",
		[24057540534279] = "270944,270910,270935,270945",
		[24883681558765] = "270941,270925,270926,270917",
		[26326491099391] = "270906,270918,270936,270942",
	},
	[41] = {
		[15121759473991] = "271560",
		[15808937378222] = "271582",
		[18489700975012] = "271576,438414",
		[18490790986083] = "438426,438427,438428,438429",
		[18558304194847] = "271573,438425",
		[18970452128038] = "271567,438415",
		[19588308550074] = "271557,271583",
		[19726115881384] = "271559,438412",
		[20207605903652] = "271578,438413",
		[20277213147274] = "271572,438416,438417,438418",
		[23369187754170] = "271584,271565,438419,438420",
		[35191452073984] = "438421,438422,438423,438424",
	},
	[46] = {
		[24059351601360] = "271092,271085,271086,271089",
		[35259098186038] = "271095,271079,440578,440579,440580,440581",
		[42408675192832] = "271075,271076,271080,271081,440573,440574,440575,440576,440577",
	},
	[52] = {
		[12993131708568] = "271453,271454",
		[14090127147300] = "438381",
		[15052621566074] = "271466",
		[16015800471948] = "271449",
		[18421551874403] = "271448,271456,438391,438392",
		[19179430154352] = "271470,271477,438379,438380",
		[20001463939416] = "438385,438386",
		[20001782346096] = "271455,438382,438383,438384",
		[20552089731420] = "271444,271483,438377,438378",
		[21996743401573] = "438387,438388,438389,438390",
		[22201575518340] = "271473,271463,271467,271464",
		[22613978513536] = "271471,271461,271450,271451",
		[63981775777818] = "271481,271460,271474,271468",
	},
	[53] = {
		[15466111029248] = "252884",
		[18764276912452] = "252862,252863",
		[18765350375769] = "252886,252887,440640,440641",
		[20207705935924] = "252880,252881",
		[21308825927991] = "252899,440647,440648,440649",
		[21926361759744] = "252882,252883,440638,440639",
		[22685381115985] = "252894,252895,252896,252897",
		[22886942584832] = "440642,440643",
		[23987998662865] = "252890,252891,252892,252893",
		[27286516404520] = "252866,252867,440636,440637",
		[31272311193746] = "252898,440644,440645,440646",
	},
	[54] = {
		[12991220928798] = "440660",
		[15672186101899] = "272334",
		[15675089092608] = "440672,440673",
		[21033598517531] = "440668,440669,440670,440671",
		[21718410252590] = "272347,272371",
		[22203202535680] = "272364,272348,272358,272359",
		[24536981266432] = "272357,272342",
		[26943941067068] = "272344,272354,272350,272339",
		[28179280429166] = "272351,272340",
		[28386042990592] = "272362,272356,440664,440665",
		[29348100583801] = "272369,272363,440666,440667",
		[29419706245120] = "272372,440661,440662,440663",
		[31890031841494] = "272335,272343",
	},
	[55] = {
		[9554525298872] = "440798",
		[10791861891318] = "440805",
		[10928696373416] = "440793",
		[11479156957412] = "440797",
		[13059655688356] = "440795",
		[15602510143551] = "440807",
		[15672487305216] = "440810,440811",
		[15808333406583] = "440796",
		[16083815887101] = "440806",
		[16221555179728] = "440812",
		[16427395895539] = "440794",
		[16496501313631] = "440800",
		[16771547344896] = "440799",
		[20756068245504] = "440808,440809",
		[22269522907158] = "440819,440820,440821,440822",
		[24056164155756] = "440801,440802,440803,440804",
		[25847921057792] = "440813,440814,440815,440816,440817,440818",
	},
	[56] = {
		[15743775928400] = "272739,272746",
		[16360990843116] = "272747,272763",
		[17664749859054] = "272772,272760",
		[18007743365120] = "442700,442701",
		[18284146200655] = "272736,442717,442718,442719",
		[18421601271888] = "272759,272750,442713,442714",
		[18422121394418] = "442702,442703,442704,442705",
		[20072128360472] = "272768,272770,442720,442721",
		[22683167088640] = "442706,442707,442708,442709",
		[23850744136040] = "272740,272773,442715,442716",
		[24538021794050] = "272742,272751,272752,272764",
		[27636439285760] = "272756,272737,272769,442710,442711,442712",
	},
	[57] = {
		[12648025579688] = "441034",
		[13267441365192] = "273125,441031",
		[13472860696576] = "441026",
		[13541312077824] = "273145",
		[13815887212920] = "273142",
		[13884339363840] = "273143",
		[13885093822582] = "273126",
		[14502612292061] = "273141",
		[15741207789794] = "273137,441027",
		[15946493411653] = "273130",
		[16154211676239] = "273149,441025",
		[16771530371153] = "273146",
		[20070668628363] = "273124,441028,441029,441030",
		[21788454945146] = "273131,273134,441032,441033",
		[23780664176903] = "273129,273133",
	},
	[61] = {
		[12716862816332] = "273173",
		[16222092947657] = "273159",
		[17184384139366] = "441042,441043",
		[17184601251840] = "441048,441049",
		[17596298915963] = "273181",
		[17664010764295] = "273164,441041",
		[17733099401551] = "273174,441054",
		[18970652938303] = "273178,273167",
		[20482012586403] = "441039,441040",
		[20485904240835] = "273155,441055,441056,441057",
		[20621146800480] = "441050,441051,441052,441053",
		[20688454963440] = "273163,441035",
		[22063112908902] = "273171,441036",
		[22339920068905] = "273156,441044,441045,441046",
		[22612535124002] = "441037,441038",
		[25361431634152] = "273177,441047",
	},
	[62] = {
		[9624251371763] = "272807",
		[9899398070381] = "440837",
		[11342892752979] = "272822",
		[12029852606685] = "272826",
		[12235189330157] = "440833",
		[12853832712409] = "272815",
		[13335673258074] = "272830",
		[13609494491491] = "272814",
		[16565036519528] = "272811",
		[19863319503158] = "272810,440834",
		[20484058599605] = "272806,272812,440831,440832",
		[21787766460864] = "440835,440836",
	},
	[67] = {
		[13748309872668] = "271043,438260",
		[13953309704374] = "438259",
		[16770925392339] = "438258",
		[16838740365312] = "438262",
		[17183914934288] = "438261",
		[19040011055158] = "438254,438255,438256,438257",
		[20825106371043] = "271044,438263",
		[21581154845050] = "438264,438265",
		[22404983316810] = "271045,438251",
		[22544183922806] = "438266,438267",
		[22680649777391] = "438252,438253",
	},
	[68] = {
		[11410976555156] = "270387",
		[12648276492436] = "270380",
		[13955256258681] = "437337,437338",
		[15191318540541] = "270401,437321",
		[15877943603465] = "270390",
		[15878496063709] = "270402",
		[16153039306906] = "270388",
		[16222343995723] = "270398,437328",
		[16771763990528] = "437322",
		[16911048622080] = "437319,437320",
		[17253136330916] = "270386,437312",
		[18011046019072] = "270376,437333,437334,437335",
		[19040884793661] = "270405,437316,437317,437318",
		[19727122502017] = "270375,437313,437314,437315",
		[21032907997459] = "437329,437330,437331,437332",
		[21581960048718] = "270389,437336",
		[22337841631329] = "270400,437327",
		[23850827194703] = "437323,437324,437325,437326",
	},
	[69] = {
		[16083765490129] = "442249",
		[16909289341340] = "442250",
		[16911366619270] = "272968,442244",
		[18695590543360] = "272963,442255",
		[19246906081280] = "442268,442269,442270,442271",
		[21788302676084] = "272962,442240",
		[24608586060017] = "442264,442265,442266,442267",
		[24813000368128] = "442245,442246,442247,442248",
		[25706773197129] = "442260,442261,442262,442263",
		[28250602795265] = "442256,442257,442258,442259",
		[29624975470641] = "442251,442252,442253,442254",
		[29966239613114] = "272954,442241,442242,442243",
	},
	[70] = {
		[11274324668817] = "440778,440779",
		[12097800913185] = "440780",
		[12578954985813] = "440771",
		[13334197912064] = "272628",
		[14434262040697] = "440773",
		[14502009938457] = "272650",
		[15190948508059] = "440772",
		[15259449823517] = "272646",
		[16564616618079] = "440768",
		[16771698004111] = "272624",
		[18214120120689] = "440776,440777",
		[18354007785735] = "272648,272634,272635,272623",
		[19039892828528] = "272633,272647,440774,440775",
		[19933631987901] = "440764,440765,440766,440767",
		[20963535130624] = "272632,272641",
		[22131364962752] = "440769,440770",
		[25705901543603] = "272630,272649,272642,272636",
	},
	[71] = {
		[11066202202112] = "438321",
		[14571650756984] = "438337",
		[15121726013489] = "271111",
		[15260740804977] = "271125,438327",
		[15878513217536] = "271114,438320",
		[17183477760273] = "271127",
		[18831570956288] = "271126,438336",
		[18832425808344] = "271122,438317",
		[19864024928426] = "438318,438319",
		[20070552555922] = "271105,438324,438325,438326",
		[21240175972671] = "438328,438329,438330,438331",
		[21445259948188] = "438313,438314,438315,438316",
		[21788992532480] = "271104,271124,438322,438323",
		[22063566463172] = "271106,271129,438338,438339",
		[22407768691045] = "271108,271112,271113,271109",
		[23232921796632] = "438332,438333,438334,438335",
	},
	[74] = {
		[10930056720554] = "440592",
		[11823074214175] = "440586",
		[11960882688181] = "271675",
		[13128425050393] = "440591",
		[13196776271988] = "271696",
		[13336680296791] = "271700,271682",
		[14160190320994] = "271699",
		[14228441219263] = "271680",
		[14297074475237] = "440593",
		[14915349160173] = "440590",
		[15946377380138] = "440596",
		[18215428051045] = "271687,440587,440588,440589",
		[24057421557760] = "271705,271686,440594,440595",
	},
	[75] = {
		[14159570337813] = "271494",
		[18560182829056] = "271507,271504,438410,438411",
		[19177785417897] = "438397,438398,438399,438400",
		[20963586597087] = "271500,438407",
		[21787933446332] = "438405,438406",
		[23642571042816] = "438393,438394",
		[26392457138235] = "438395,438396",
		[29761422676281] = "438401,438402,438403,438404",
		[29966709715313] = "271503,271509,438408,438409",
	},
	[76] = {
		[11891205718357] = "272798",
		[12236146241737] = "440825",
		[12303975063763] = "272792",
		[12991002689628] = "272774",
		[13403034341587] = "272800",
		[14640153080046] = "272789",
		[14708469026915] = "272776",
		[15191920840984] = "272781,440827",
		[15396788433348] = "272801",
		[15465021440364] = "272805",
		[15877169942785] = "272782",
		[15946459828573] = "272784",
		[17460470083593] = "440823,440824",
		[17526722564244] = "272799",
		[18488727957935] = "440828,440829",
		[18832258978081] = "272795,440826",
		[21649823596544] = "272788,440830",
	},
	[81] = {
		[12647958712716] = "438209",
		[14161733206184] = "270412,438210",
		[14228825665939] = "438208",
		[14434983432569] = "270409",
		[14984823062757] = "270414",
		[15052805763193] = "438207",
		[16703229882371] = "438197,438198",
		[17183728230622] = "438199",
		[17595944603789] = "438185",
		[17871544303669] = "438193,438194,438195,438196",
		[20276727103889] = "270410,438204,438205,438206",
		[21033816604694] = "270434,438211,438212,438213",
		[22063097958400] = "270432,438192",
		[24193852858712] = "438200,438201,438202,438203",
		[40344726581375] = "438186,438187,438188,438189,438190,438191",
	},
	[82] = {
		[11891205841401] = "271658",
		[12853496889828] = "271657",
		[14366164463673] = "271653",
		[15740284568010] = "271663",
		[17940365271095] = "271673,438433,438434,438435",
		[18076562288649] = "271652,438436",
		[18420411228519] = "271664,438438",
		[18832695009662] = "271659,438431",
		[21099582418944] = "271660,438432",
		[21924466827581] = "271669,438437",
		[23574975819883] = "271665,438439",
		[23711441600743] = "271666,438430",
	},
	[83] = {
		[12784927801523] = "440938",
		[13541464350921] = "273051",
		[14021627273546] = "440937",
		[15396369518592] = "440936",
		[18080136941824] = "273072,273039,273037,273063",
		[21238966194402] = "273043,273075,273069,273061",
		[21720271036773] = "273046,273053,273071,273047",
		[22063785328832] = "273042,273065,273050,273036",
		[22820436955136] = "440943,440944,440945,440946",
		[23163851460647] = "440939,440940,440941,440942",
		[26186718966144] = "273059,273066,273073,273054",
		[29691747700736] = "273052,273062,273057,273058",
	},
	[85] = {
		[18627945107547] = "440652,440653,440654,440655",
		[18903663239378] = "440656,440657,440658,440659",
		[23781034107015] = "440650,440651",
		[29623447302417] = "252844,252845,252846,252847",
	},
	[86] = {
		[20070451032207] = "440714,440715,440716,440717",
		[21238397427893] = "272580,272544",
		[21651419193344] = "440721,440722,440723,440724",
		[22612835557376] = "272581,272562",
		[27835869007876] = "272565,272566,272577,272546",
		[29828128850071] = "272573,272545",
		[33609831924022] = "272567,272547,272555,272548",
		[37252113629390] = "272559,272543,272574,272575,440718,440719",
		[39860870054343] = "272564,272553,440720",
	},
	[88] = {
		[13335422443715] = "273191",
		[15190513205429] = "273200",
		[17114792743226] = "273206",
		[17457265951159] = "273199",
		[17664900133204] = "273185,445588",
		[18627308241164] = "273192,445585,445586,445587",
		[21787146093018] = "273198,445584",
		[22819363815424] = "273184,445581,445582,445583",
		[22887865991185] = "273203,445592",
		[24880678813998] = "273187,445593",
		[25225753153569] = "273207,445589,445590,445591",
		[25843372249206] = "273202,445578,445579,445580",
	},
	[99] = {
		[8799333294555] = "271603",
		[8799400526295] = "271598",
		[8800255865252] = "271592",
		[8800338407839] = "271625",
		[8800389185855] = "271633",
		[8800390365583] = "271630",
		[17594334474644] = "271627",
		[17594334523861] = "271635",
		[17594334573051] = "271596",
		[17594335674727] = "271591",
		[17594335736113] = "271628",
		[17595073274352] = "271614",
		[17595107181038] = "271615",
		[17596481892650] = "271601",
		[17596482269320] = "271608",
		[17596482339200] = "271599",
		[17596482490666] = "271637",
		[17596482593154] = "271612",
		[17596482896245] = "271588",
		[17596482953530] = "271610",
		[17596483490045] = "271604",
		[17596483752164] = "271586",
		[17598111056187] = "271587,271590",
		[35192962822149] = "271619,271602,271589,271638",
		[35192963825751] = "271632,271600,271617,271618",
	},
	[100] = {
		[17596481175839] = "271752",
		[17596481765614] = "271744",
		[17596481871998] = "271716",
		[17596483407872] = "271761",
		[17596583166358] = "271711,271717",
		[17599720407259] = "271740,271730",
		[17600776224885] = "271754,271733",
		[17600777474050] = "271762,271751",
		[17600777814166] = "271741,271723",
		[27769985917160] = "271742,271728,271758,271706",
		[29347513888768] = "271735,271736",
		[29484952834184] = "271715,271745",
		[35188668391424] = "271729,271707",
		[35188668940288] = "271731,271719",
		[35189288202615] = "271721,271725,271714,271737",
		[35191604977901] = "271712,271757,271713,271734",
		[35192962203648] = "271726,271756,271727,271710",
	},
	[102] = {
		[8800389882205] = "270497",
		[17594334986240] = "270493",
		[17595910681022] = "270498",
		[17596330918309] = "270482",
		[17596481724779] = "270492",
		[17596481732911] = "270463",
		[17596482162993] = "270509",
		[17596482203651] = "270510",
		[17596482453882] = "270481",
		[17596482506801] = "270488",
		[17596482580729] = "270513",
		[17596482850999] = "270508",
		[17596483010584] = "270474",
		[17596483088734] = "270512",
		[17596483121431] = "270476",
		[32650343542888] = "270511,270483,270489,270484",
		[35192962326613] = "270475,270515,270495,270505",
	},
	[105] = {
		[17596481151118] = "271836",
		[17596481757596] = "271830",
		[17596481855598] = "271835",
		[17596482924698] = "271852",
		[17596482933034] = "271848",
		[17596483899760] = "271843",
		[17596549382552] = "271838,271861",
		[17598527934754] = "271850,271864",
		[17599871394002] = "271855,271833",
		[17600777314349] = "271840,271849",
		[17600778350720] = "271866,271821",
		[17600778997916] = "271854,271825",
		[29003614536110] = "271826,271822",
		[35188651348381] = "271856,271820",
		[35188669009926] = "271867,271842",
		[35190110646598] = "271862,271844,271823,271831",
		[35192962179224] = "271851,271841,271865,271853",
		[35192963981337] = "271863,271857,271845,271839",
	},
	[107] = {
		[17594334035968] = "273241",
		[17595661877709] = "273266",
		[17596481139027] = "273262",
		[17596481343640] = "273222",
		[17596481372210] = "273235",
		[17596481728744] = "273267",
		[17596482412793] = "273233",
		[17596483109167] = "273271",
		[17596483453340] = "273280",
		[17597941207365] = "273224,273225",
		[17600776876083] = "273268,273226",
		[17600777326617] = "273223,273272",
		[17600777871450] = "273253,273242",
		[17600778309744] = "273249,273238",
		[19662363213952] = "273243,273273,273250,273251",
		[21169896644929] = "273276,273246",
		[35188667138250] = "273248,273279",
		[35190010519884] = "273221,273269,273236,273277",
	},
	[109] = {
		[17596481597696] = "272431",
		[17596483141725] = "272421",
		[17596483281204] = "272461",
		[17600777166977] = "272451,272471",
		[27221505204350] = "272429,272470,272446,272450",
		[33813725962685] = "272442,272443",
		[35190379737398] = "272454,272426,272439,272455",
		[35191252668674] = "272448,272449,272469,272452",
		[35191737975013] = "272430,272460,272434,272435",
		[35192962449563] = "272436,272440,272441,272427",
		[35192962498595] = "272428,272424,272433,272445",
		[35192963448840] = "272467,272465,272422,272453",
		[35192963637338] = "272459,272438,272463,272447",
	},
	[110] = {
		[17594335834263] = "270643",
		[17596213686700] = "270622",
		[17596449284510] = "270642",
		[17596482052272] = "270663",
		[17596482183196] = "270625",
		[17596482699359] = "270631",
		[17596482740224] = "270665",
		[17596482810066] = "270649",
		[17596483170385] = "270611",
		[17596483407872] = "270651",
		[17596483563667] = "270666",
		[17596483588502] = "270667",
		[17596483707177] = "270655",
		[17596483768391] = "270626",
		[17596484014189] = "270609",
		[17597170278771] = "270669,270657",
		[17597522383198] = "270638,270630",
		[17597825372492] = "270612,270658",
		[17598831481104] = "270664,270659",
		[17599066972418] = "270629,270606",
		[17599217795321] = "270644,270610",
		[17599937798350] = "270652,270653",
		[17600693379233] = "270619,270620",
		[17600777941090] = "270616,270617",
		[28591599689875] = "270628,270605",
		[35188600537504] = "270662,270632",
		[35188667932727] = "270621,270633",
	},
	[111] = {
		[8798241243352] = "270671",
		[16428253032704] = "270710",
		[17595291095523] = "270718",
		[17595509993942] = "270687",
		[17596481851431] = "270701",
		[17596481917064] = "270676",
		[17596481962226] = "270703",
		[17596482036116] = "270739",
		[17596482212125] = "270728",
		[17596482228360] = "270733",
		[17596482248731] = "270727",
		[17596482515153] = "270679",
		[17596482707862] = "270700",
		[17596482801922] = "270698",
		[17596482859037] = "270734",
		[17596482982005] = "270720",
		[17596483248538] = "270699",
		[17596483285079] = "270741",
		[17596483289304] = "270740",
		[17596483461458] = "270677",
		[17596483522642] = "270709",
		[17596483620864] = "270714",
		[17596483702862] = "270712",
		[17596483997750] = "270682",
		[17600776159294] = "270690,270729",
		[33331313922575] = "270711,270723",
		[35188432900522] = "270674,270731",
		[35191586468078] = "270692,270673,270702,270672",
	},
	[112] = {
		[17596231639467] = "272204",
		[17596481654816] = "272235",
		[17596481675418] = "272198",
		[17596481908935] = "272231",
		[17596482146358] = "272242",
		[17596482384065] = "272213",
		[17596482449460] = "272237",
		[17596482597254] = "272220",
		[17596482613506] = "272230",
		[17596482777231] = "272188",
		[17596483076149] = "272208",
		[17596483191147] = "272236",
		[17596483195147] = "272206",
		[17596483461199] = "272232",
		[17596483739881] = "272244",
		[17597792338254] = "272196,272197",
		[17600776020075] = "272199,272200",
		[35189976367438] = "272205,272229,272190,272238",
		[35191418667256] = "272224,272233,272191,272212",
	},
	[113] = {
		[8800389284108] = "272840",
		[17595677020620] = "272889",
		[17596112925106] = "272843",
		[17596481486852] = "272878",
		[17596481921386] = "272846",
		[17596482015521] = "272881",
		[17596482281817] = "272887",
		[17596482297856] = "272837",
		[17596482556176] = "272836",
		[17596482637989] = "272839",
		[17596482720071] = "272873",
		[17596482969619] = "272880",
		[17596482978069] = "272866",
		[17596483080346] = "272886",
		[17596483146003] = "272835",
		[17598343704877] = "272844,272847",
		[17600777842722] = "272879,272834",
		[26465591005333] = "272860,272855,272850,272856",
		[35188667642027] = "272851,272867",
		[35189742637404] = "272876,272888,272857,272877",
		[35192962449412] = "272861,272831,272883,272838",
	},
	[114] = {
		[17594334515588] = "272255",
		[17594620748299] = "272274",
		[17595190628841] = "272288",
		[17595760570823] = "272292",
		[17595828560323] = "272253",
		[17596481552678] = "272262",
		[17596481712283] = "272247",
		[17596481949734] = "272263",
		[17596481982486] = "272273",
		[17596482048301] = "272283",
		[17596482232454] = "272285",
		[17596482355597] = "272280",
		[17596482470149] = "272249",
		[17596482633738] = "272269",
		[17596482695188] = "272248",
		[17596482916688] = "272260",
		[17596482982096] = "272264",
		[17596483113098] = "272282",
		[17596483649709] = "272287",
		[17598679429401] = "272279,272265",
		[28112710865180] = "272267,272254,272268,272284",
		[35188668506161] = "272296,272294",
	},
	[119] = {
		[12786454298861] = "270870,270743",
		[13953562927115] = "270848",
		[16771143979148] = "270785",
		[16772905881666] = "270900,270819",
		[17803413065992] = "270903,270781,270794,270855",
		[17871729365229] = "270851,270871,270795,270769",
		[18354442703086] = "270822,270894,270835,270784",
		[19864612516021] = "270765,270824,270887,270801",
		[19933550116879] = "270826,270865,270759,270763",
		[25775543549952] = "270869,270890,270764,270762",
		[26255169835391] = "270761,270879,270880,270787",
		[26462302228694] = "270898,270840,270899,270812",
		[27216319848448] = "270806,270810",
		[31617351622656] = "270821,270758,270797,270775",
	},
	[120] = {
		[12922803151056] = "271192",
		[13472677097834] = "271358",
		[14640924405760] = "271232",
		[14710349390182] = "271313,271133",
		[15534161219848] = "271378",
		[15741107466240] = "271146,271257",
		[15741776732347] = "271267,271201",
		[16154731503781] = "271254,271233",
		[16155018498055] = "271149,271222",
		[16221454999755] = "271170",
		[17733401645174] = "271239,271157",
		[20551790489607] = "271351,271270,271175,271330",
		[20689363640652] = "271280,271346,271164,271387",
		[20894127751272] = "271352,271244",
		[21032220827648] = "271187,271231",
		[21376323498144] = "271333,271199,271364,271162",
		[21789998338267] = "271205,271248,271252,271236",
		[24469167771961] = "271322,271298,271290,271337",
	},
	[121] = {
		[17115093303425] = "271764",
		[18832609583565] = "271794,271778",
		[19108880814324] = "271801,271773,271779,271806",
		[19451756609957] = "271789,271812",
		[20207336054971] = "271785,271817",
		[22269558669449] = "271790,271765,271766,271767",
		[22544351801376] = "271809,271771,271772,271776",
		[22612837126144] = "271769,271770",
		[22819798847795] = "271768,271783,271795,271810",
		[24125303549993] = "271791,271807,271774,271796",
		[24467891843279] = "271781,271784",
		[26255621619758] = "271792,271775,271813,271797",
		[31274075042049] = "271798,271780,271814,271799",
		[32647826080038] = "271803,271788,271816,271805",
	},
	[122] = {
		[11960093769898] = "271946",
		[12166553231711] = "271992",
		[12235558957296] = "271945",
		[12441213640865] = "271993",
		[12854956183760] = "271980,271994",
		[13266233966815] = "271950",
		[14641544671435] = "271976",
		[15258543317092] = "271959",
		[15327951200256] = "271957",
		[15330116730905] = "271956,271974",
		[15946544877904] = "271941",
		[16359129182316] = "271984",
		[16633285185536] = "271954",
		[16772671918407] = "271969,271989",
		[17048841081048] = "271985,271968",
		[17251811893248] = "271970",
		[18077668749349] = "271940,271975,271953,271991",
		[18282905747513] = "271952,271967",
		[19521500475752] = "271997,271998,271963,271964",
		[20483540238336] = "271977,271978,271979,271958",
		[22888032121110] = "271962,271987,271983,271988",
		[23849349783732] = "271986,271960",
		[24056146067866] = "271965,271966,271972,271973",
	},
	[123] = {
		[14023269548199] = "254677,254678",
		[15054314250531] = "254688,254689",
		[15327918014740] = "254695",
		[15331138736143] = "254690,254691",
		[15602845774129] = "254687",
		[16359262883890] = "254692",
		[16840284381451] = "254679",
		[17046509297845] = "254684",
		[18489182826886] = "254693,254694",
		[19451489739081] = "254685,254686",
		[20621600170015] = "254680,254681,254682,254683",
		[21168989438418] = "254659,254660",
		[21169157005704] = "254657,254658",
		[21581676314654] = "294026,294027",
		[25638657732645] = "254653,254654,254655,254656",
		[27014706847866] = "254673,254674,254675,254676",
	},
	[124] = {
		[14228876079348] = "272524",
		[16016439251180] = "272529,272506",
		[16429207294307] = "272530,272516",
		[17115311161479] = "272507",
		[18421652168762] = "272517,272534,272496,272502",
		[20138650288179] = "272500,272501",
		[20209013571618] = "272523,272487,272539,272532",
		[21446669586566] = "272494,272495,272504,272533",
		[22132119912540] = "272521,272515,272522,272499",
		[22613623882103] = "272509,272491,272520,272484",
		[31272663851194] = "272535,272518,272490,272519",
		[32166236287315] = "272498,272531,272510,272541",
	},
	[125] = {
		[11616344011053] = "272922",
		[12373516443792] = "272933",
		[12511476949105] = "272927,272910",
		[12647589786070] = "272909",
		[14091385708687] = "272920",
		[14434094530856] = "272945",
		[15190360244430] = "272906",
		[15670691897662] = "272924",
		[16771243860397] = "272919",
		[17251945095636] = "272921",
		[20964441403762] = "272904,272925,272926,272952",
		[21036282622131] = "272934,272923,272908,272930",
		[21240745955613] = "272939,272953,272905,272935",
		[22130943512951] = "272948,272950",
		[24950892281978] = "272912,272913,272914,272946",
		[25361933770752] = "272943,272944,272931,272917",
	},
	[126] = {
		[14985728811199] = "273324,273292",
		[16290677915816] = "273329",
		[16978812792959] = "273322,273320",
		[17115480191217] = "273304,273305",
		[17940617752827] = "273309,273286,273310,273328",
		[18214975263065] = "273296,273300,273285,273287",
		[18283643408671] = "273330,273291",
		[18696193966327] = "273318,273298,273336,273303",
		[19658217644390] = "273311,273297,273331,273317",
		[20757159068085] = "273323,273289",
		[21101174354332] = "273326,273333",
		[21377077997656] = "273325,273307,273308,273319",
		[22064069824875] = "273312,273332,273282,273302",
		[23094729592832] = "273295,273301,273321,273288",
	},
	[127] = {
		[35191352443132] = "272721,272732,272715,272722",
		[35192963051524] = "272716,272728,272723,272733",
	},
	[132] = {
		[17321670213723] = "270966,271005",
		[18147025354928] = "270987,270962,270973,270997",
		[19794933841920] = "253268,271000",
		[28594415862004] = "270970,270961,270971,270996",
		[30655079612456] = "253267,270960,270995,270989",
		[34505182101609] = "253269,270985,253270,270986",
		[37394603053056] = "253264,271003,270968,270965,253265,253266,271002,271004,270984",
		[38350251344255] = "253271,253272,270974,270975,271001,270980",
	},
	[179] = {
		[9760398610791] = "440843",
		[10722622509067] = "440842",
		[10930256642192] = "440863",
		[11548313125232] = "440853",
		[11822686785944] = "440859",
		[11891490811925] = "440840",
		[12166233592156] = "440838",
		[13059822846083] = "440860",
		[14435420651681] = "440851,440852",
		[14571768213572] = "440862",
		[14572154749380] = "440854",
		[15190546432345] = "440850",
		[15258912506314] = "440841",
		[15877823877445] = "440861",
		[17045938561067] = "440839",
		[20964273565881] = "440855,440856,440857,440858",
		[24060493058069] = "440844,440845,440846,440847,440848,440849",
	},
	[184] = {
		[12167022793153] = "438477",
		[13335538594144] = "438476",
		[14433876201899] = "438440",
		[15260221739394] = "438482,438483",
		[16771596210378] = "438475",
		[18353369919488] = "438484,438485,438486,438487",
		[19245213647242] = "438498,438499",
		[19247192514655] = "438478,438479,438480,438481",
		[19316064383019] = "438443,438444,438445,438446",
		[19383306825938] = "438447,438448,438449,438450",
		[19383894024206] = "438488,438489,438490,438491",
		[19656757805389] = "438441,438442",
		[22062359921105] = "438492,438493",
		[22545626169344] = "438500,438501,438502,438503",
		[24057607668002] = "438494,438495,438496,438497",
	},
	[199] = {
		[68868055760900] = "466830,466834,466835,466836,466837,466838,466839,466840,466841,466831,466832,466833",
	},
	[203] = {
		[18557162418373] = "438644,438645",
		[18559293194245] = "438632,438633,438634,438635",
		[18697303810368] = "438646,438647,438648,438649",
		[19039187939764] = "438668,438669",
		[19385905340494] = "438636,438637,438638,438639",
		[20002753691665] = "438670,438671,438672,438673",
		[21998137417856] = "438640,438641,438642,438643",
		[25087039877336] = "438678,438679,438680,438681",
		[28798327447930] = "438682,438683,438684,438685",
		[30310641385725] = "438674,438675,438676,438677",
		[36907779653632] = "438662,438663,438664,438665,438666,438667",
	},
	[204] = {
		[14708317950480] = "440758",
		[14846294388987] = "440749",
		[14983833501760] = "440753",
		[16633386029492] = "440750",
		[17458338508996] = "440763",
		[18489080865225] = "440745,440746",
		[19246136574099] = "440754,440755,440756,440757",
		[19587920773406] = "440759,440760",
		[21649488121856] = "440751,440752",
		[24399207075957] = "440761,440762",
		[26392440938803] = "440747,440748",
	},
	[206] = {
		[15121457938660] = "440974",
		[15602795737368] = "440977",
		[19109300215843] = "440984,440985,440986,440987",
		[20000825393195] = "440982,440983",
		[21375399768389] = "440975,440976",
		[21719836033425] = "440978,440979,440980,440981",
		[23368398459042] = "440988,440989",
	},
	[209] = {
		[15466078269623] = "440973",
		[18354376057112] = "440955,440956,440957,440958",
		[20482616438894] = "440963,440964",
		[21033076269266] = "440969,440970,440971,440972",
		[24949566812192] = "440959,440960,440961,440962",
		[25432667308315] = "440965,440966,440967,440968",
		[25501536297223] = "440947,440948,440949,440950",
		[33749150404608] = "440951,440952,440953,440954",
	},
	[210] = {
		[13541480505519] = "440998",
		[18694718677214] = "440992,440993",
		[19658285302021] = "440994,440995,440996,440997",
		[23024767693245] = "440990,440991",
		[23300568317952] = "441003,441004,441005,441006",
		[23989154844940] = "440999,441000,441001,441002",
		[32990701379616] = "441007,441008,441009,441010",
	},
	[212] = {
		[16289839092096] = "438312",
		[18831755649024] = "438306,438307",
		[20070870589823] = "438294,438295,438296,438297",
		[24401203556529] = "438298,438299,438300,438301",
		[25430987899026] = "438280,438281,438282,438283",
		[25500865003834] = "438290,438291,438292,438293",
		[25981985308672] = "438276,438277,438278,438279",
		[28247868023204] = "438310,438311",
		[29553234334134] = "438308,438309",
		[31204399272233] = "438272,438273,438274,438275",
		[31755111350284] = "438268,438269,438270,438271",
		[32096576163840] = "438302,438303,438304,438305",
		[35464066891776] = "438284,438285,438286,438287,438288,438289",
	},
	[215] = {
		[10655228575863] = "438752",
		[12647338692789] = "438751",
		[15466161639765] = "438740",
		[16222428414344] = "438754,438755",
		[16359598952448] = "438743,438744",
		[16497105531284] = "438747,438748",
		[16771060613120] = "438753",
		[16908700238037] = "438750",
		[17390089371896] = "438749",
		[18626402910281] = "438741,438742",
		[24467842334836] = "438745,438746",
	},
	[216] = {
		[12167022793153] = "438541",
		[13335538594144] = "438540",
		[14433876201899] = "438504",
		[15260221739394] = "438546,438547",
		[16771596210378] = "438539",
		[17184870768654] = "438552,438553",
		[18353369919488] = "438548,438549,438550,438551",
		[19245213647242] = "438562,438563",
		[19247192514655] = "438542,438543,438544,438545",
		[19316064383019] = "438507,438508,438509,438510",
		[19383306825938] = "438523,438524,438525,438526",
		[19656757805389] = "438505,438506",
		[22062359921105] = "438556,438557",
		[22545626169344] = "438564,438565,438566,438567",
		[24057607668002] = "438558,438559,438560,438561",
	},
	[220] = {
		[12167022793153] = "438605",
		[13335538594144] = "438604",
		[14433876201899] = "438568",
		[15260221739394] = "438610,438611",
		[16771596210378] = "438603",
		[18353369919488] = "438612,438613,438614,438615",
		[19245213647242] = "438626,438627",
		[19247192514655] = "438606,438607,438608,438609",
		[19316064383019] = "438571,438572,438573,438574",
		[19383306825938] = "438587,438588,438589,438590",
		[19383894024206] = "438616,438617,438618,438619",
		[19656757805389] = "438569,438570",
		[22062359921105] = "438620,438621",
		[22545626169344] = "438628,438629,438630,438631",
		[24057607668002] = "438622,438623,438624,438625",
	},
	[225] = {
		[9760398610791] = "457676",
		[10722622509067] = "457675",
		[10930256642192] = "457696",
		[11548313125232] = "457686",
		[11822686785944] = "457692",
		[11891490811925] = "457673",
		[12166233592156] = "457671",
		[13059822846083] = "457693",
		[14435420651681] = "457684,457685",
		[14571768213572] = "457695",
		[14572154749380] = "457687",
		[15190546432345] = "457683",
		[15258912506314] = "457674",
		[15877823877445] = "457694",
		[17045938561067] = "457672",
		[20964273565881] = "457688,457689,457690,457691",
		[24060493058069] = "457677,457678,457679,457680,457681,457682",
	},
	[226] = {
		[9760398610791] = "440869",
		[10722622509067] = "440868",
		[10930256642192] = "440913",
		[11548313125232] = "440879",
		[11822686785944] = "440885",
		[11891490811925] = "440866",
		[12166233592156] = "440864",
		[13059822846083] = "440886",
		[14435420651681] = "440877,440878",
		[14571768213572] = "440912",
		[14572154749380] = "440880",
		[15190546432345] = "440876",
		[15258912506314] = "440867",
		[15877823877445] = "440911",
		[17045938561067] = "440865",
		[20964273565881] = "440881,440882,440883,440884",
		[24060493058069] = "440870,440871,440872,440873,440874,440875",
	},
	[227] = {
		[18557162418373] = "438698,438699",
		[18559293194245] = "438686,438687,438688,438689",
		[18697303810368] = "438700,438701,438702,438703",
		[19039187939764] = "438722,438723",
		[19385905340494] = "438690,438691,438692,438693",
		[20002753691665] = "438724,438725,438726,438727",
		[21998137417856] = "438694,438695,438696,438697",
		[25087039877336] = "438732,438733,438734,438735",
		[28798327447930] = "438736,438737,438738,438739",
		[30310641385725] = "438728,438729,438730,438731",
		[36907779653632] = "438716,438717,438718,438719,438720,438721",
	},
	[228] = {
		[68868122869760] = "464052,464056,464057,464058,464059,464060,464061,464062,464063,464053,464054,464055",
	},
	[252] = {
		[9829252169817] = "458560",
		[11342053667172] = "458579",
		[11960377815129] = "458554",
		[12028929429683] = "458572",
		[12166016196914] = "458587",
		[12510217839039] = "458548",
		[13128742785256] = "458589",
		[13334432837852] = "458555",
		[13541395968367] = "458552",
		[13609831162025] = "458570",
		[13678733918400] = "458574",
		[13953545023756] = "458547",
		[14159266873344] = "458569",
		[14503334846585] = "458571",
		[14709157158912] = "458588",
		[14777323225293] = "458546",
		[14777726218505] = "458553",
		[15122096165267] = "458558",
		[15534496735232] = "458573",
		[15810110501087] = "458556,458557",
		[16359078977629] = "458580",
		[16427849228618] = "458559",
		[17252064129269] = "458551",
		[17870455447897] = "458581,458582",
		[19451068334200] = "458549,458550",
		[21170080325632] = "458561,458562,458563,458564",
		[22269539938320] = "458583,458584,458585,458586",
		[23506894668156] = "458565,458566,458567,458568",
		[24813670854970] = "458575,458576,458577,458578",
	},
	[260] = {
		[10310591320257] = "458658",
		[10379058868439] = "458668",
		[10998355943598] = "458641",
		[11067797827599] = "458663",
		[11273099899157] = "458634",
		[13471871823993] = "458646",
		[13884171047314] = "458635",
		[13953663098880] = "458638",
		[13954232193313] = "458653",
		[14159637451101] = "458664",
		[14366633718144] = "458643",
		[14640522789337] = "458665",
		[15671850807363] = "458650",
		[16017025724707] = "458639,458640",
		[16289773154466] = "458642",
		[16291820667050] = "458661,458662",
		[17115227652232] = "458649",
		[18488946409754] = "458647,458648",
		[18489601781944] = "458636,458637",
		[18558101639601] = "458666,458667",
		[19106918486016] = "458651,458652",
		[20344472092799] = "458659,458660",
		[21445325471965] = "458654,458655,458656,458657",
		[27491549241344] = "458644,458645",
	},
	[289] = {
		[10310591320257] = "458693",
		[10379058868439] = "458715",
		[10998355943598] = "458676",
		[11067797827599] = "458698",
		[11273099899157] = "458669",
		[13471871823993] = "458681",
		[13884171047314] = "458670",
		[13953663098880] = "458673",
		[13954232193313] = "458688",
		[14159637451101] = "458699",
		[14366633718144] = "458678",
		[14640522789337] = "458700",
		[15671850807363] = "458685",
		[16017025724707] = "458674,458675",
		[16289773154466] = "458677",
		[16291820667050] = "458696,458697",
		[17115227652232] = "458684",
		[18488946409754] = "458682,458683",
		[18489601781944] = "458671,458672",
		[18558101639601] = "458701,458702",
		[19106918486016] = "458686,458687",
		[20344472092799] = "458694,458695",
		[21445325471965] = "458689,458690,458691,458692",
		[27491549241344] = "458679,458680",
	},
	[338] = {
		[9829252169817] = "458604",
		[11342053667172] = "458623",
		[11960377815129] = "458598",
		[12028929429683] = "458616",
		[12166016196914] = "458631",
		[12510217839039] = "458592",
		[13128742785256] = "458633",
		[13334432837852] = "458599",
		[13541395968367] = "458596",
		[13609831162025] = "458614",
		[13678733918400] = "458618",
		[13953545023756] = "458591",
		[14159266873344] = "458613",
		[14503334846585] = "458615",
		[14709157158912] = "458632",
		[14777323225293] = "458590",
		[14777726218505] = "458597",
		[15122096165267] = "458602",
		[15534496735232] = "458617",
		[15810110501087] = "458600,458601",
		[16359078977629] = "458624",
		[16427849228618] = "458603",
		[17252064129269] = "458595",
		[17870455447897] = "458625,458626",
		[19451068334200] = "458593,458594",
		[21170080325632] = "458605,458606,458607,458608",
		[22269539938320] = "458627,458628,458629,458630",
		[23506894668156] = "458609,458610,458611,458612",
		[24813670854970] = "458619,458620,458621,458622",
	},
	[339] = {
		[60965383516160] = "462974,462978,462979,462980,462981,462982,462983,462984,462985,462975,462976,462977",
	},
	[383] = {
		[12303807988128] = "614290",
		[13129045524779] = "614289",
		[13471669534720] = "614288",
		[13471803199563] = "614284",
		[13884758614037] = "614278",
		[14433741742080] = "614297",
		[14983330898440] = "614277",
		[15052687385058] = "614294",
		[15053005508759] = "614287",
		[15053861560650] = "614286",
		[15602644336696] = "614275",
		[16083882102962] = "614276",
		[16220180512914] = "614285",
		[16633638555863] = "614293",
		[17254429339691] = "614295,614296",
		[17389870342358] = "614283",
		[18145483768103] = "614291,614292",
		[19109217620326] = "614279,614280,614281,614282",
	},
	[388] = {
		[12030791295106] = "615423,615424",
		[13680277061706] = "615411,615412",
		[14160324419761] = "615408",
		[14298551902249] = "615404,615405",
		[14367538020695] = "615402,615403",
		[14641377841210] = "615418",
		[15809122603169] = "615413",
		[17116887941446] = "615414,615415",
		[17459094561021] = "615421,615422",
		[17665738289532] = "615425,615426,615427,615428",
		[17871275053295] = "615409,615410",
		[18764544393321] = "615416,615417",
		[19039407857965] = "615419,615420",
		[19660348051531] = "615429,615430,615431,615432",
		[20827423354994] = "615437,615438,615439,615440",
		[21581473833285] = "615406,615407",
		[26118722084864] = "615433,615434,615435,615436",
		[35051363201428] = "615398,615399,615400,615401",
	},
	[390] = {
		[15121440215364] = "538846",
		[16085156388873] = "538829,571508",
		[17941069082660] = "538836,538837,538838,538839",
		[21514582454470] = "538847,538848,538849,538850",
		[23781351866773] = "538851,538852,538853,538854",
		[25571616755724] = "538874,538875,538876,538877",
		[26463258509607] = "538870,538871,538872,538873",
		[41720458293430] = "538855,538856,538857,538858,538859,538860",
		[41925157093670] = "538830,538831,538832,538833,538834,538835",
		[44740776423830] = "538840,538841,538842,538843,538844,538845",
		[46534294261760] = "538861,538862,538863,538864,538865,538866,538867,538868,538869",
		[67971380728010] = "538890,538891,538892,538893,538894,538895,538896,538897",
	},
	[391] = {
		[15396049789424] = "614341",
		[15397207953599] = "614367",
		[15741158273337] = "614351,614352",
		[16495998792150] = "614340",
		[17184233664682] = "614361,614362",
		[17321620836712] = "614346,614347",
		[17389519167899] = "614348",
		[17802256031748] = "614344,614345",
		[17938503176698] = "614342,614343",
		[19727138476095] = "614353,614354,614355,614356",
		[20482080333888] = "614368,614369",
		[21307669930294] = "614363,614364,614365,614366",
		[21512686813448] = "614349,614350",
		[26463458132060] = "614357,614358,614359,614360",
	},
	[400] = {
		[14640102363521] = "614385",
		[16360203813049] = "614379,614380",
		[16977420227007] = "614374",
		[17527981359313] = "614372,614373",
		[17939727327665] = "614388,614389",
		[18626419757425] = "614394,614395",
		[19384029102442] = "614381,614382,614383,614384",
		[20208274489536] = "614390,614391,614392,614393",
		[20346989007089] = "614375,614376,614377,614378",
		[20619970727936] = "614386,614387",
		[24261332967892] = "614370,614371",
	},
	[402] = {
		[16634376126480] = "614447",
		[18352815825066] = "614466,614467,614468,614469",
		[18353269100860] = "614458,614459,614460,614461",
		[18700457197665] = "614452,614453,614454,614455,614456,614457",
		[20482801672202] = "614462,614463,614464,614465",
		[21308155658603] = "614435,614436,614437,614438",
		[23164319264771] = "614431,614432,614433,614434",
		[24059014283498] = "614443,614444,614445,614446",
		[24813317931115] = "614470,614471,614472,614473",
		[25638826627094] = "614439,614440,614441,614442",
		[30654911922443] = "614448,614449,614450,614451",
	},
	[430] = {
		[12926175465531] = "614501,614502",
		[13061433856003] = "614482,614483",
		[14025200746540] = "614495,614496",
		[14506437103704] = "614497,614498",
		[14572976328767] = "614493,614494",
		[14712562360397] = "614484,614485",
		[14916809707547] = "614490,614491",
		[15053911933143] = "614499,614500",
		[16909019214197] = "614492",
		[17322559500555] = "614507,614508",
		[17665938686031] = "614503,614504,614505,614506",
		[17732478476786] = "614509,614510",
		[18213918347469] = "614478,614479",
		[18695892697464] = "614480,614481",
		[19658269511699] = "614486,614487,614488,614489",
		[21031584940032] = "614511,614512",
	},
	[434] = {
		[14366298935388] = "642686",
		[14367707189373] = "642670,642671",
		[14983967457312] = "642683",
		[16221254492270] = "642680",
		[17183528054784] = "642665",
		[18009419411578] = "642674,642675,642676,642677",
		[18420864917910] = "642684,642685",
		[19933396869505] = "642687,642688,642689,642690",
		[22131213291833] = "642672,642673",
		[22199647572192] = "642678,642679",
		[22337019596800] = "642681,642682",
		[22338360664375] = "642666,642667,642668,642669",
	},
	[445] = {
		[19931854389725] = "615054,615055",
		[20207218921472] = "614718,614719",
		[32924902043823] = "614714,614715,614716,614717",
	},
	[498] = {
		[14159570337813] = "656197",
		[18560182829056] = "656230,656231,656232,656233",
		[19177785417897] = "656202,656203,656204,656205",
		[20963586597087] = "656224,656225",
		[21787933446332] = "656222,656223",
		[23642571042816] = "656198,656199",
		[26392457138235] = "656200,656201",
		[29761422676281] = "656218,656219,656220,656221",
		[29966709715313] = "656226,656227,656228,656229",
	},
	[499] = {
		[12926175465531] = "660517,660518",
		[13061433856003] = "660486,660487",
		[14025200746540] = "660511,660512",
		[14506437103704] = "660513,660514",
		[14572976328767] = "660509,660510",
		[14712562360397] = "660488,660489",
		[14916809707547] = "660506,660507",
		[15053911933143] = "660515,660516",
		[16909019214197] = "660508",
		[17665938686031] = "660519,660520,660521,660522",
		[17732478476786] = "660527,660528",
		[18695892697464] = "660484,660485",
		[18903375806731] = "660523,660524,660525,660526",
		[20277164232723] = "660490,660491,660492,660493",
		[21031584940032] = "660529,660530",
		[23848999325896] = "660482,660483",
	},
	[542] = {
		[12235475079378] = "1003336",
		[13680798863664] = "1003346,1003347",
		[14641915105313] = "1003352,1003353",
		[14916138184737] = "1003341",
		[17251794362649] = "1003354",
		[17526672179291] = "1003333",
		[17595710447808] = "1003355",
		[17733266927620] = "1003327,1003328",
		[18284298334345] = "1003356,1003357,1003358,1003359",
		[18766275383615] = "1003329,1003330,1003331,1003332",
		[18832727445504] = "1003334,1003335",
		[19384615539011] = "1003337,1003338,1003339,1003340",
		[21787983511844] = "1003360,1003361",
		[22613643104412] = "1003348,1003349,1003350,1003351",
		[24469217370229] = "1003323,1003324,1003325,1003326",
	},
	[551] = {
		[11960678945135] = "1126684",
		[12992914845758] = "1126693,1126694",
		[14366481056008] = "1126692",
		[15327515148475] = "1126689",
		[16359079497899] = "1126706",
		[16908649922943] = "1126703",
		[17047698973026] = "1126704,1126705",
		[18557750284601] = "1126701,1126702",
		[18833348190402] = "1126707,1126708",
		[22475313242374] = "1126690,1126691",
		[22890920005768] = "1126680,1126681,1126682,1126683",
		[23231444770910] = "1126699,1126700",
		[23575211463048] = "1126685,1126686,1126687,1126688",
		[25087241125911] = "1126695,1126696,1126697,1126698",
	},
	[552] = {
		[15465642295444] = "1036473",
		[17322007994596] = "1036441,1036442",
		[19108545057132] = "1036451,1036452,1036453,1036454",
		[19177215275008] = "1036457,1036458,1036459,1036460",
		[19727140032547] = "1036474,1036475,1036476,1036477",
		[20070032175146] = "1036445,1036446",
		[21100721955080] = "1036443,1036444",
		[21170232152362] = "1036461,1036462,1036463,1036464",
		[21238715326820] = "1036437,1036438,1036439,1036440",
		[22406107627791] = "1036471,1036472",
		[26735804764338] = "1036435,1036436",
		[27352853884928] = "1036455,1036456",
		[27906265501718] = "1036465,1036466,1036467,1036468",
		[29073206296954] = "1036447,1036448,1036449,1036450",
		[34156214809087] = "1036469,1036470",
	},
	[556] = {
		[11891155096012] = "1037676",
		[13884708090267] = "1037683",
		[15740788011013] = "1037665",
		[17872248217600] = "1037666,1037667,1037668,1037669",
		[19382266577363] = "1037655,1037656",
		[19382668374331] = "1037677,1037678",
		[19795590009138] = "1037679,1037680,1037681,1037682",
		[20001832214528] = "1037657,1037658,1037659,1037660",
		[21238748070048] = "1037651,1037652,1037653,1037654",
		[23781167915166] = "1037661,1037662",
		[27012091711638] = "1037670,1037671,1037672,1037673",
	},
	[559] = {
		[11616579445012] = "1037704",
		[12511041065115] = "1037688",
		[12922451116287] = "1037686",
		[13059839074565] = "1037689",
		[13473783926868] = "1037702,1037703",
		[13540741308744] = "1037705",
		[13610350842124] = "1037707",
		[14364955697362] = "1037684",
		[14915886731646] = "1037687",
		[15533841650139] = "1037708",
		[15740334526662] = "1037709",
		[15740889047390] = "1037685",
		[16360186871935] = "1037698,1037699",
		[17321168048211] = "1037706",
		[21583016386560] = "1037694,1037695,1037696,1037697",
		[25497846288384] = "1037700,1037701",
		[26255438950400] = "1037690,1037691,1037692,1037693",
	},
	[560] = {
		[11410135839091] = "1036374",
		[14296034652576] = "1036391",
		[14366147195130] = "1036382",
		[14434330267908] = "1036375",
		[14503519219786] = "1036378",
		[14915113857359] = "1036390",
		[14915148210359] = "1036379",
		[17183762776141] = "1036392",
		[17389351321923] = "1036389",
		[18008212517236] = "1036393,1036394",
		[19176778375381] = "1036380,1036381",
		[19590472151113] = "1036383,1036384,1036385,1036386",
		[20412722418108] = "1036376,1036377",
		[21649656504320] = "1036387,1036388",
		[22267812753915] = "1036372,1036373",
	},
	[567] = {
		[16083562983683] = "1036395",
		[16221857755490] = "1036410",
		[16224040771702] = "1036404,1036405",
		[17115984630140] = "1036413,1036414",
		[17184687300633] = "1036415,1036416",
		[17597238444399] = "1036402,1036403",
		[18008967143747] = "1036417,1036418,1036419,1036420",
		[18078039203840] = "1036421,1036422,1036423,1036424",
		[18833399316578] = "1036429,1036430",
		[19658369712128] = "1036398,1036399,1036400,1036401",
		[20345530405217] = "1036431,1036432,1036433,1036434",
		[20963249881100] = "1036396,1036397",
		[21719063978171] = "1036411,1036412",
		[24331981729951] = "1036425,1036426,1036427,1036428",
		[32374205186048] = "1036406,1036407,1036408,1036409",
	},
	[628] = {
		[11547725754470] = "1085238",
		[13403638415360] = "1085237",
		[13678381683162] = "1085244",
		[14983918039137] = "1085239",
		[16016102400374] = "1085242,1085243",
		[16152232489142] = "1085234",
		[16358507941998] = "1085231",
		[16497206632539] = "1085240,1085241",
		[18422761083148] = "1085249,1085250,1085251,1085252",
		[18695154835456] = "1085232,1085233",
		[20275687137286] = "1085235,1085236",
		[21169391075503] = "1085257,1085258",
		[23920367911223] = "1085253,1085254,1085255,1085256",
		[25431207510195] = "1085245,1085246,1085247,1085248",
	},
	[653] = {
		[12442304123220] = "1414545",
		[14160676569332] = "1414541,1414542",
		[15123118862569] = "1414543,1414544",
		[16429040869376] = "1414528,1414529",
		[16976799604831] = "1414530",
		[18694920704173] = "1414539,1414540",
		[19794482810880] = "1414546,1414547",
		[21649740009472] = "1414537,1414538",
		[22063432700305] = "1414531,1414532,1414533,1414534",
		[22681873965258] = "1414524,1414525,1414526,1414527",
		[24124647649349] = "1414535,1414536",
	},
	[657] = {
		[9073406447882] = "1414600",
		[9279849820241] = "1414615",
		[10310944444729] = "1414613",
		[11891206816083] = "1414601",
		[12166184804697] = "1414618",
		[12372192256118] = "1414619",
		[12784475611424] = "1414623",
		[13335171236066] = "1414616",
		[13678281134290] = "1414596",
		[13746817089723] = "1414604",
		[14090833359031] = "1414622",
		[14778833342876] = "1414599",
		[16564650086495] = "1414614",
		[17322008154484] = "1414602,1414603",
		[19862817280000] = "1414617,1417748",
		[20000858685722] = "1414620,1414621",
		[20413208436865] = "1414597,1414598",
		[26530986295481] = "1414624,1414625,1414626,1414627",
		[34982424809472] = "1414611,1414612",
		[43367274643809] = "1414605,1414606,1414607,1414608,1414609,1414610",
	},
	[664] = {
		[11753548976479] = "1414675",
		[12165966541213] = "1414676",
		[14847083065584] = "1414689",
		[14983665901984] = "1414690",
		[16429005439250] = "1414673,1414674",
		[16565422829818] = "1414665",
		[17184114892975] = "1414666",
		[17459463737724] = "1414681,1414682",
		[18834910486546] = "1414677,1414678,1414679,1414680",
		[20209634226176] = "1414669,1414670,1414671,1414672",
		[21375851966739] = "1414667,1414668",
		[22408590929920] = "1414683,1414684,1414685,1414686",
		[23436497011168] = "1414687,1414688",
	},
	[669] = {
		[12511056085252] = "1597370",
		[18970150559757] = "1597172,1597166",
		[21169695064233] = "1414556,1414557",
		[21445528731648] = "1414560,1414561,1414562,1414563",
		[22819499229284] = "1597182,1597179,1597167,1597186",
		[23231714578612] = "1597181,1597168,1597171,1597187",
		[23232586440788] = "1597169,1597369,1597185,1597180",
		[26599706820910] = "1597371,1597184,1597183,1597170",
	},
	[674] = {
		[11823173570796] = "1414595",
		[12785397821848] = "1414568",
		[14230000324653] = "1414580,1414581",
		[14711136690536] = "1414578,1414579",
		[14914610802937] = "1414577",
		[16770892349742] = "1414594",
		[17597656121375] = "1414566,1414567",
		[19450465398784] = "1414582,1414583",
		[19795539673498] = "1414569,1414570,1414571,1414572",
		[20413880152139] = "1414564,1414565",
		[21375600709811] = "1414584,1414585",
		[23438846517484] = "1414586,1414587,1414588,1414589",
		[23644449276148] = "1414573,1414574,1414575,1414576",
		[30585636520278] = "1414590,1414591,1414592,1414593",
	},
	[700] = {
		[25844630159572] = "1445120,1445121,1445122,1445123",
	},
	[704] = {
		[15190763536610] = "1414656",
		[15260942090419] = "1414628,1414629",
		[17047748702344] = "1414634,1414635",
		[19866019655985] = "1414636,1414637,1414638,1414639",
		[22477663027200] = "1414630,1414631,1414632,1414633",
		[24400297820445] = "1414640,1414641,1414642,1414643",
		[26600679960576] = "1414661,1414662,1414663,1414664",
		[28802489282560] = "1414644,1414645,1414646,1414647,1414648,1414649",
		[29417238466560] = "1414652,1414653,1414654,1414655",
		[32303809585483] = "1414657,1414658,1414659,1414660",
		[32989459488768] = "1414650,1414651",
	},
	[815] = {
		[58285323612160] = "1417775,1417779,1417780,1417781,1417782,1417783,1417784,1417785,1417786,1417776,1417777,1417778",
	},
	[855] = {
		[20346603778226] = "1710644,1710645,1710646,1710647",
		[21101981385068] = "1710648,1710649,1710650,1710651",
		[30586527994145] = "1710660,1710661,1710662,1710663",
		[34231191490698] = "1710664,1710665,1710666,1710667,1710668,1710669",
		[57387843743744] = "1710652,1710653,1710654,1710655,1710656,1710657,1710658,1710659",
	},
	[887] = {
		[48055171772676] = "2034238,2034245,2034246,2034247,2034248,2034249,2034250,2034251,2034252,2034239,2034240,2034241,2034242,2034243,2034244",
		[49900702430207] = "2034361,2034362,2034363,2034364,2034365,2034366,2034367,2034368,2034369",
		[52861509808455] = "2034321,2034329,2034330,2034331,2034332,2034333,2034334,2034335,2034336,2034322,2034323,2034324,2034325,2034326,2034327,2034328",
		[54505763230329] = "2034211,2034215,2034216,2034217,2034218,2034219,2034220,2034221,2034222,2034212,2034213,2034214",
		[61048267866194] = "2034269,2034280,2034286,2034287,2034288,2034289,2034290,2034291,2034292,2034270,2034271,2034272,2034273,2034274,2034275,2034276,2034277,2034278,2034279,2034281,2034282,2034283,2034284,2034285",
		[64197925885174] = "2034253,2034261,2034262,2034263,2034264,2034265,2034266,2034267,2034268,2034254,2034255,2034256,2034257,2034258,2034259,2034260",
		[64828631023616] = "2034293,2034304,2034314,2034315,2034316,2034317,2034318,2034319,2034320,2034294,2034295,2034296,2034297,2034298,2034299,2034300,2034301,2034302,2034303,2034305,2034306,2034307,2034308,2034309,2034310,2034311,2034312,2034313",
		[67291678412800] = "2034400,2034408,2034409,2034410,2034411,2034412,2034413,2034414,2034415,2034401,2034402,2034403,2034404,2034405,2034406,2034407",
		[68673313313984] = "2034337,2034348,2034354,2034355,2034356,2034357,2034358,2034359,2034360,2034338,2034339,2034340,2034341,2034342,2034343,2034344,2034345,2034346,2034347,2034349,2034350,2034351,2034352,2034353",
		[77664288559104] = "2034223,2034230,2034231,2034232,2034233,2034234,2034235,2034236,2034237,2034224,2034225,2034226,2034227,2034228,2034229",
		[85439906145529] = "2034370,2034381,2034392,2034394,2034395,2034396,2034397,2034398,2034399,2034371,2034372,2034373,2034374,2034375,2034376,2034377,2034378,2034379,2034380,2034382,2034383,2034384,2034385,2034386,2034387,2034388,2034389,2034390,2034391,2034393",
		[113413394272634] = "2034162,2034173,2034184,2034195,2034206,2034207,2034208,2034209,2034210,2034163,2034164,2034165,2034166,2034167,2034168,2034169,2034170,2034171,2034172,2034174,2034175,2034176,2034177,2034178,2034179,2034180,2034181,2034182,2034183,2034185,2034186,2034187,2034188,2034189,2034190,2034191,2034192,2034193,2034194,2034196,2034197,2034198,2034199,2034200,2034201,2034202,2034203,2034204,2034205",
	},
	[888] = {
		[36708100941337] = "2024042,2024043,2024044,2024045,2024046,2024047,2024048,2024049,2024050",
		[54992213799955] = "2023713,2023721,2023722,2023723,2023724,2023725,2023726,2023727,2023728,2023714,2023715,2023716,2023717,2023718,2023719,2023720",
		[57811122844691] = "2023997,2024008,2024010,2024011,2024012,2024013,2024014,2024015,2024016,2023998,2023999,2024000,2024001,2024002,2024003,2024004,2024005,2024006,2024007,2024009",
		[73204757450962] = "2023868,2023879,2023886,2023887,2023888,2023889,2023890,2023891,2023892,2023869,2023870,2023871,2023872,2023873,2023874,2023875,2023876,2023877,2023878,2023880,2023881,2023882,2023883,2023884,2023885",
		[75470705185639] = "2023693,2023704,2023706,2023707,2023708,2023709,2023710,2023711,2023712,2023694,2023695,2023696,2023697,2023698,2023699,2023700,2023701,2023702,2023703,2023705",
		[79524660135427] = "2023923,2023934,2023936,2023937,2023938,2023939,2023940,2023941,2023942,2023924,2023925,2023926,2023927,2023928,2023929,2023930,2023931,2023932,2023933,2023935",
		[84202316284469] = "2024017,2024028,2024035,2024036,2024037,2024038,2024039,2024040,2024041,2024018,2024019,2024020,2024021,2024022,2024023,2024024,2024025,2024026,2024027,2024029,2024030,2024031,2024032,2024033,2024034",
		[88592982673036] = "2023943,2023954,2023960,2023961,2023962,2023963,2023964,2023965,2023966,2023944,2023945,2023946,2023947,2023948,2023949,2023950,2023951,2023952,2023953,2023955,2023956,2023957,2023958,2023959",
		[92719844761600] = "2023967,2023978,2023989,2023991,2023992,2023993,2023994,2023995,2023996,2023968,2023969,2023970,2023971,2023972,2023973,2023974,2023975,2023976,2023977,2023979,2023980,2023981,2023982,2023983,2023984,2023985,2023986,2023987,2023988,2023990",
		[105434455511321] = "2023893,2023904,2023915,2023917,2023918,2023919,2023920,2023921,2023922,2023894,2023895,2023896,2023897,2023898,2023899,2023900,2023901,2023902,2023903,2023905,2023906,2023907,2023908,2023909,2023910,2023911,2023912,2023913,2023914,2023916",
	},
	[889] = {
		[45781537637607] = "2033961,2033965,2033966,2033967,2033968,2033969,2033970,2033971,2033972,2033962,2033963,2033964",
		[52858970846516] = "2033973,2033981,2033982,2033983,2033984,2033985,2033986,2033987,2033988,2033974,2033975,2033976,2033977,2033978,2033979,2033980",
		[54572363360226] = "2033949,2033953,2033954,2033955,2033956,2033957,2033958,2033959,2033960,2033950,2033951,2033952",
		[58354115429247] = "2033865,2033869,2033870,2033871,2033872,2033873,2033874,2033875,2033876,2033866,2033867,2033868",
		[60556912288085] = "2033917,2033925,2033926,2033927,2033928,2033929,2033930,2033931,2033932,2033918,2033919,2033920,2033921,2033922,2033923,2033924",
		[62753087746565] = "2033877,2033881,2033882,2033883,2033884,2033885,2033886,2033887,2033888,2033878,2033879,2033880",
		[62894534471900] = "2033933,2033941,2033942,2033943,2033944,2033945,2033946,2033947,2033948,2033934,2033935,2033936,2033937,2033938,2033939,2033940",
		[63645781489417] = "2033905,2033909,2033910,2033911,2033912,2033913,2033914,2033915,2033916,2033906,2033907,2033908",
		[66603189633883] = "2033889,2033897,2033898,2033899,2033900,2033901,2033902,2033903,2033904,2033890,2033891,2033892,2033893,2033894,2033895,2033896",
		[74641148478342] = "2033989,2033996,2033997,2033998,2033999,2034000,2034001,2034002,2034003,2033990,2033991,2033992,2033993,2033994,2033995",
		[78285281301761] = "2033845,2033856,2033858,2033859,2033860,2033861,2033862,2033863,2033864,2033846,2033847,2033848,2033849,2033850,2033851,2033852,2033853,2033854,2033855,2033857",
		[84058070339584] = "2034004,2034015,2034017,2034018,2034019,2034020,2034021,2034022,2034023,2034005,2034006,2034007,2034008,2034009,2034010,2034011,2034012,2034013,2034014,2034016",
		[88456669419156] = "2033821,2033832,2033838,2033839,2033840,2033841,2033842,2033843,2033844,2033822,2033823,2033824,2033825,2033826,2033827,2033828,2033829,2033830,2033831,2033833,2033834,2033835,2033836,2033837",
	},
	[907] = {
		[18215863410972] = "1710620,1710621,1710622,1710623",
		[19520762257783] = "1710634,1710635,1710636,1710637",
		[21515120615535] = "1710616,1710617,1710618,1710619",
		[31825826189366] = "1710624,1710625,1710626,1710627,1710628,1710629",
		[34230033711104] = "1710630,1710631,1710632,1710633",
		[48177772232704] = "1710638,1710639,1710640,1710641,1710642,1710643",
	},
	[910] = {
		[32099212030190] = "1710612,1710613,1710614,1710615",
		[43024852865024] = "1710597,1710598,1710599,1710600,1710601,1710602",
		[45366061826048] = "1710603,1710604,1710605,1710606,1710607,1710608,1710609,1710610,1710611",
	},
	[920] = {
		[56914812592228] = "2033569,2033577,2033578,2033579,2033580,2033581,2033582,2033583,2033584,2033570,2033571,2033572,2033573,2033574,2033575,2033576",
		[59043255501251] = "2033457,2033465,2033466,2033467,2033468,2033469,2033470,2033471,2033472,2033458,2033459,2033460,2033461,2033462,2033463,2033464",
		[61246798972383] = "2033625,2033636,2033638,2033639,2033640,2033641,2033642,2033643,2033644,2033626,2033627,2033628,2033629,2033630,2033631,2033632,2033633,2033634,2033635,2033637",
		[62418833121456] = "2033545,2033556,2033562,2033563,2033564,2033565,2033566,2033567,2033568,2033546,2033547,2033548,2033549,2033550,2033551,2033552,2033553,2033554,2033555,2033557,2033558,2033559,2033560,2033561",
		[65510187123887] = "2033783,2033794,2033796,2033797,2033798,2033799,2033800,2033801,2033802,2033784,2033785,2033786,2033787,2033788,2033789,2033790,2033791,2033792,2033793,2033795",
		[67227302781923] = "2033585,2033596,2033598,2033599,2033600,2033601,2033602,2033603,2033604,2033586,2033587,2033588,2033589,2033590,2033591,2033592,2033593,2033594,2033595,2033597",
		[71963075716811] = "2033525,2033536,2033538,2033539,2033540,2033541,2033542,2033543,2033544,2033526,2033527,2033528,2033529,2033530,2033531,2033532,2033533,2033534,2033535,2033537",
		[85365437838347] = "2033605,2033616,2033618,2033619,2033620,2033621,2033622,2033623,2033624,2033606,2033607,2033608,2033609,2033610,2033611,2033612,2033613,2033614,2033615,2033617",
		[89759014854656] = "2033803,2033813,2033814,2033815,2033816,2033817,2033818,2033819,2033820,2033804,2033805,2033806,2033807,2033808,2033809,2033810,2033811,2033812",
		[98423227568460] = "2033473,2033484,2033490,2033491,2033492,2033493,2033494,2033495,2033496,2033474,2033475,2033476,2033477,2033478,2033479,2033480,2033481,2033482,2033483,2033485,2033486,2033487,2033488,2033489",
		[122129617051648] = "2033497,2033508,2033518,2033519,2033520,2033521,2033522,2033523,2033524,2033498,2033499,2033500,2033501,2033502,2033503,2033504,2033505,2033506,2033507,2033509,2033510,2033511,2033512,2033513,2033514,2033515,2033516,2033517",
	},
	[921] = {
		[52933820752921] = "2038067,2038078,2038080,2038081,2038082,2038083,2038084,2038085,2038086,2038068,2038069,2038070,2038071,2038072,2038073,2038074,2038075,2038076,2038077,2038079",
		[65164206850409] = "2038047,2038058,2038060,2038061,2038062,2038063,2038064,2038065,2038066,2038048,2038049,2038050,2038051,2038052,2038053,2038054,2038055,2038056,2038057,2038059",
		[74168520331264] = "2038112,2038123,2038130,2038131,2038132,2038133,2038134,2038135,2038136,2038113,2038114,2038115,2038116,2038117,2038118,2038119,2038120,2038121,2038122,2038124,2038125,2038126,2038127,2038128,2038129",
		[74923849774081] = "2038087,2038098,2038105,2038106,2038107,2038108,2038109,2038110,2038111,2038088,2038089,2038090,2038091,2038092,2038093,2038094,2038095,2038096,2038097,2038099,2038100,2038101,2038102,2038103,2038104",
		[77324182700792] = "2037819,2037830,2037832,2037833,2037834,2037835,2037836,2037837,2037838,2037820,2037821,2037822,2037823,2037824,2037825,2037826,2037827,2037828,2037829,2037831",
		[78290846454699] = "2037884,2037895,2037902,2037903,2037904,2037905,2037906,2037907,2037908,2037885,2037886,2037887,2037888,2037889,2037890,2037891,2037892,2037893,2037894,2037896,2037897,2037898,2037899,2037900,2037901",
		[79320050757632] = "2037839,2037850,2037857,2037858,2037859,2037860,2037861,2037862,2037863,2037840,2037841,2037842,2037843,2037844,2037845,2037846,2037847,2037848,2037849,2037851,2037852,2037853,2037854,2037855,2037856",
		[81662582608735] = "2037789,2037800,2037811,2037813,2037814,2037815,2037816,2037817,2037818,2037790,2037791,2037792,2037793,2037794,2037795,2037796,2037797,2037798,2037799,2037801,2037802,2037803,2037804,2037805,2037806,2037807,2037808,2037809,2037810,2037812",
		[85157509349946] = "2037864,2037875,2037877,2037878,2037879,2037880,2037881,2037882,2037883,2037865,2037866,2037867,2037868,2037869,2037870,2037871,2037872,2037873,2037874,2037876",
		[94368786546688] = "2038137,2038148,2038154,2038155,2038156,2038157,2038158,2038159,2038160,2038138,2038139,2038140,2038141,2038142,2038143,2038144,2038145,2038146,2038147,2038149,2038150,2038151,2038152,2038153",
		[97873750089728] = "2038197,2038208,2038219,2038221,2038222,2038223,2038224,2038225,2038226,2038198,2038199,2038200,2038201,2038202,2038203,2038204,2038205,2038206,2038207,2038209,2038210,2038211,2038212,2038213,2038214,2038215,2038216,2038217,2038218,2038220",
		[104544525337813] = "2038161,2038172,2038183,2038191,2038192,2038193,2038194,2038195,2038196,2038162,2038163,2038164,2038165,2038166,2038167,2038168,2038169,2038170,2038171,2038173,2038174,2038175,2038176,2038177,2038178,2038179,2038180,2038181,2038182,2038184,2038185,2038186,2038187,2038188,2038189,2038190",
	},
	[967] = {
		[59047650034139] = "2033179,2033190,2033192,2033193,2033194,2033195,2033196,2033197,2033198,2033180,2033181,2033182,2033183,2033184,2033185,2033186,2033187,2033188,2033189,2033191",
		[63863552036864] = "2033137,2033148,2033154,2033155,2033156,2033157,2033158,2033159,2033160,2033138,2033139,2033140,2033141,2033142,2033143,2033144,2033145,2033146,2033147,2033149,2033150,2033151,2033152,2033153",
		[70800091678098] = "2033070,2033081,2033088,2033089,2033090,2033091,2033092,2033093,2033094,2033071,2033072,2033073,2033074,2033075,2033076,2033077,2033078,2033079,2033080,2033082,2033083,2033084,2033085,2033086,2033087",
		[72317492781056] = "2033199,2033210,2033221,2033223,2033224,2033225,2033226,2033227,2033228,2033200,2033201,2033202,2033203,2033204,2033205,2033206,2033207,2033208,2033209,2033211,2033212,2033213,2033214,2033215,2033216,2033217,2033218,2033219,2033220,2033222",
		[80216171832632] = "2033045,2033056,2033063,2033064,2033065,2033066,2033067,2033068,2033069,2033046,2033047,2033048,2033049,2033050,2033051,2033052,2033053,2033054,2033055,2033057,2033058,2033059,2033060,2033061,2033062",
		[91086552641536] = "2033229,2033240,2033251,2033262,2033272,2033273,2033274,2033275,2033276,2033230,2033231,2033232,2033233,2033234,2033235,2033236,2033237,2033238,2033239,2033241,2033242,2033243,2033244,2033245,2033246,2033247,2033248,2033249,2033250,2033252,2033253,2033254,2033255,2033256,2033257,2033258,2033259,2033260,2033261,2033263,2033264,2033265,2033266,2033267,2033268,2033269,2033270,2033271",
		[96425359184928] = "2033161,2033171,2033172,2033173,2033174,2033175,2033176,2033177,2033178,2033162,2033163,2033164,2033165,2033166,2033167,2033168,2033169,2033170",
		[111899752531023] = "2033415,2033426,2033437,2033448,2033452,2033453,2033454,2033455,2033456,2033416,2033417,2033418,2033419,2033420,2033421,2033422,2033423,2033424,2033425,2033427,2033428,2033429,2033430,2033431,2033432,2033433,2033434,2033435,2033436,2033438,2033439,2033440,2033441,2033442,2033443,2033444,2033445,2033446,2033447,2033449,2033450,2033451",
		[114030635668525] = "2033095,2033106,2033117,2033128,2033132,2033133,2033134,2033135,2033136,2033096,2033097,2033098,2033099,2033100,2033101,2033102,2033103,2033104,2033105,2033107,2033108,2033109,2033110,2033111,2033112,2033113,2033114,2033115,2033116,2033118,2033119,2033120,2033121,2033122,2033123,2033124,2033125,2033126,2033127,2033129,2033130,2033131",
	},
	[1186] = {
		[35055664059076] = "3020618,3020619,3020620,3020621,3020622,3020623",
		[36224030748721] = "3020682,3020683,3020684,3020685,3020686,3020687,3020688,3020689,3020690",
		[38355573215925] = "3020732,3020733,3020734,3020735,3020736,3020737,3020738,3020739,3020740",
		[40076886216761] = "3020574,3020578,3020579,3020580,3020581,3020582,3020583,3020584,3020585,3020575,3020576,3020577",
		[44541133799764] = "3020549,3020550,3020551,3020552,3020553,3020554,3020555,3020556,3020557",
		[48324984591027] = "3020658,3020662,3020663,3020664,3020665,3020666,3020667,3020668,3020669,3020659,3020660,3020661",
		[50653995083160] = "3020676,3020677,3020678,3020679,3020680,3020681",
		[50723198792880] = "3020670,3020671,3020672,3020673,3020674,3020675",
		[52928010608758] = "3020716,3020724,3020725,3020726,3020727,3020728,3020729,3020730,3020731,3020717,3020718,3020719,3020720,3020721,3020722,3020723",
		[53817376826253] = "3020598,3020602,3020603,3020604,3020605,3020606,3020607,3020608,3020609,3020599,3020600,3020601",
		[54297066013699] = "3020586,3020590,3020591,3020592,3020593,3020594,3020595,3020596,3020597,3020587,3020588,3020589",
		[54646520705828] = "3020558,3020566,3020567,3020568,3020569,3020570,3020571,3020572,3020573,3020559,3020560,3020561,3020562,3020563,3020564,3020565",
		[56024244261179] = "3020529,3020540,3020542,3020543,3020544,3020545,3020546,3020547,3020548,3020530,3020531,3020532,3020533,3020534,3020535,3020536,3020537,3020538,3020539,3020541",
		[58425570218034] = "3020624,3020632,3020633,3020634,3020635,3020636,3020637,3020638,3020639,3020625,3020626,3020627,3020628,3020629,3020630,3020631",
		[67284431037108] = "3020610,3020611,3020612,3020613,3020614,3020615,3020616,3020617",
		[68041754517869] = "3020741,3020745,3020746,3020747,3020748,3020749,3020750,3020751,3020752,3020742,3020743,3020744",
		[84131618387349] = "3020691,3020702,3020709,3020710,3020711,3020712,3020713,3020714,3020715,3020692,3020693,3020694,3020695,3020696,3020697,3020698,3020699,3020700,3020701,3020703,3020704,3020705,3020706,3020707,3020708",
		[96975097164927] = "3020640,3020650,3020651,3020652,3020653,3020654,3020655,3020656,3020657,3020641,3020642,3020643,3020644,3020645,3020646,3020647,3020648,3020649",
	},
	[1276] = {
		[69357941514797] = "3022276,3022287,3022289,3022290,3022291,3022292,3022293,3022294,3022295,3022277,3022278,3022279,3022280,3022281,3022282,3022283,3022284,3022285,3022286,3022288",
		[69698706018710] = "3022368,3022376,3022377,3022378,3022379,3022380,3022381,3022382,3022383,3022369,3022370,3022371,3022372,3022373,3022374,3022375",
		[72104442491001] = "3022412,3022423,3022430,3022431,3022432,3022433,3022434,3022435,3022436,3022413,3022414,3022415,3022416,3022417,3022418,3022419,3022420,3022421,3022422,3022424,3022425,3022426,3022427,3022428,3022429",
		[80354279432688] = "3022251,3022262,3022269,3022270,3022271,3022272,3022273,3022274,3022275,3022252,3022253,3022254,3022255,3022256,3022257,3022258,3022259,3022260,3022261,3022263,3022264,3022265,3022266,3022267,3022268",
		[93894738429038] = "3022332,3022343,3022354,3022362,3022363,3022364,3022365,3022366,3022367,3022333,3022334,3022335,3022336,3022337,3022338,3022339,3022340,3022341,3022342,3022344,3022345,3022346,3022347,3022348,3022349,3022350,3022351,3022352,3022353,3022355,3022356,3022357,3022358,3022359,3022360,3022361",
		[97881885434834] = "3022437,3022448,3022459,3022467,3022468,3022469,3022470,3022471,3022472,3022438,3022439,3022440,3022441,3022442,3022443,3022444,3022445,3022446,3022447,3022449,3022450,3022451,3022452,3022453,3022454,3022455,3022456,3022457,3022458,3022460,3022461,3022462,3022463,3022464,3022465,3022466",
		[101658558616774] = "3022296,3022307,3022318,3022326,3022327,3022328,3022329,3022330,3022331,3022297,3022298,3022299,3022300,3022301,3022302,3022303,3022304,3022305,3022306,3022308,3022309,3022310,3022311,3022312,3022313,3022314,3022315,3022316,3022317,3022319,3022320,3022321,3022322,3022323,3022324,3022325",
		[118419518271528] = "3022384,3022395,3022405,3022406,3022407,3022408,3022409,3022410,3022411,3022385,3022386,3022387,3022388,3022389,3022390,3022391,3022392,3022393,3022394,3022396,3022397,3022398,3022399,3022400,3022401,3022402,3022403,3022404",
	},
}

local db
local defaults = {
	profile = {
		colorR = 1,
		colorG = 1,
		colorB = 1,
		colorA = 1,
	},
}

local options

local function getOptions()
	if not options then
		options = {
			type = "group",
			name = L["FogClear"],
			arg = MODNAME,
			args = {
				intro = {
					order = 1,
					type = "description",
					name = L["The FogClear module removes the Fog of War from the World map, thus displaying the artwork for all the undiscovered zones, optionally with a color overlay on undiscovered areas."] .. "\n",
				},
				enabled = {
					order = 2,
					type = "toggle",
					name = L["Enable FogClear"],
					get = function() return Mapster:GetModuleEnabled(MODNAME) end,
					set = function(info, value) Mapster:SetModuleEnabled(MODNAME, value) end,
				},
				color = {
					order = 3,
					type = "color",
					name = L["Overlay Color"],
					get = "GetOverlayColor",
					set = "SetOverlayColor",
					handler = FogClear,
					hasAlpha = true,
				},
			}
		}
	end

	return options
end

function FogClear:OnInitialize()
	self.db = Mapster.db:RegisterNamespace(MODNAME, defaults)
	db = self.db.profile

	self.db.global.errata = nil

	self:SetEnabledState(Mapster:GetModuleEnabled(MODNAME))
	Mapster:RegisterModuleOptions(MODNAME, getOptions, L["FogClear"])
end

local function TexturePool_ResetVertexColor(pool, texture)
	texture:SetVertexColor(1,1,1)
	texture:SetAlpha(1)
	return TexturePool_HideAndClearAnchors(pool, texture)
end

function FogClear:OnEnable()
	for pin in WorldMapFrame:EnumeratePinsByTemplate("MapExplorationPinTemplate") do
		self:SecureHook(pin, "RefreshOverlays", "MapExplorationPin_RefreshOverlays")
		pin.overlayTexturePool.resetterFunc = TexturePool_ResetVertexColor
	end
end

function FogClear:OnDisable()
	self:UnhookAll()
end

function FogClear:Refresh()
	db = self.db.profile
	if not self:IsEnabled() then return end

	for pin in WorldMapFrame:EnumeratePinsByTemplate("MapExplorationPinTemplate") do
		pin:RefreshOverlays(true)
	end
end

function FogClear:MapExplorationPin_RefreshOverlays(pin, fullUpdate)
	local mapID = pin:GetMap():GetMapID()
	if not mapID then return end
	local artID = C_Map.GetMapArtID(mapID)
	if not artID or not errata[artID] then return end
	local data = errata[artID]

	local exploredTilesKeyed = {}
	local exploredMapTextures = C_MapExplorationInfo.GetExploredMapTextures(mapID)
	if exploredMapTextures then
		for _i, exploredTextureInfo in ipairs(exploredMapTextures) do
			local key = exploredTextureInfo.textureWidth * 2^36 + exploredTextureInfo.textureHeight * 2^24 + exploredTextureInfo.offsetX * 2^12 + exploredTextureInfo.offsetY
			exploredTilesKeyed[key] = true
		end
	end

	pin.layerIndex = pin:GetMap():GetCanvasContainer():GetCurrentLayerIndex()
	local layers = C_Map.GetMapArtLayers(mapID)
	local layerInfo = layers and layers[pin.layerIndex]
	if not layerInfo then return end
	local TILE_SIZE_WIDTH = layerInfo.tileWidth
	local TILE_SIZE_HEIGHT = layerInfo.tileHeight

	local r, g, b, a = self:GetOverlayColor()

	for key, files in pairs(data) do
		if not exploredTilesKeyed[key] then
			local width, height, offsetX, offsetY = mod(floor(key / 2^36), 2^12), mod(floor(key / 2^24), 2^12), mod(floor(key / 2^12), 2^12), mod(key, 2^12)
			local fileDataIDs = { strsplit(",", files) }
			local numTexturesWide = ceil(width/TILE_SIZE_WIDTH)
			local numTexturesTall = ceil(height/TILE_SIZE_HEIGHT)
			local texturePixelWidth, textureFileWidth, texturePixelHeight, textureFileHeight
			for j = 1, numTexturesTall do
				if ( j < numTexturesTall ) then
					texturePixelHeight = TILE_SIZE_HEIGHT
					textureFileHeight = TILE_SIZE_HEIGHT
				else
					texturePixelHeight = mod(height, TILE_SIZE_HEIGHT)
					if ( texturePixelHeight == 0 ) then
						texturePixelHeight = TILE_SIZE_HEIGHT
					end
					textureFileHeight = 16
					while(textureFileHeight < texturePixelHeight) do
						textureFileHeight = textureFileHeight * 2
					end
				end
				for k = 1, numTexturesWide do
					local texture = pin.overlayTexturePool:Acquire()
					if ( k < numTexturesWide ) then
						texturePixelWidth = TILE_SIZE_WIDTH
						textureFileWidth = TILE_SIZE_WIDTH
					else
						texturePixelWidth = mod(width, TILE_SIZE_WIDTH)
						if ( texturePixelWidth == 0 ) then
							texturePixelWidth = TILE_SIZE_WIDTH
						end
						textureFileWidth = 16
						while(textureFileWidth < texturePixelWidth) do
							textureFileWidth = textureFileWidth * 2
						end
					end
					texture:SetWidth(texturePixelWidth)
					texture:SetHeight(texturePixelHeight)
					texture:SetTexCoord(0, texturePixelWidth/textureFileWidth, 0, texturePixelHeight/textureFileHeight)
					texture:SetPoint("TOPLEFT", offsetX + (TILE_SIZE_WIDTH * (k-1)), -(offsetY + (TILE_SIZE_HEIGHT * (j - 1))))
					texture:SetTexture(tonumber(fileDataIDs[((j - 1) * numTexturesWide) + k]), nil, nil, "TRILINEAR")

					texture:SetVertexColor(r, g, b)
					texture:SetAlpha(a)
					texture:SetDrawLayer("ARTWORK", -1)
					texture:Show()

					if fullUpdate then
						pin.textureLoadGroup:AddTexture(texture)
					end
				end
			end
		end
	end
end

function FogClear:GetOverlayColor()
	return db.colorR, db.colorG, db.colorB, db.colorA
end

function FogClear:SetOverlayColor(info, r,g,b,a)
	db.colorR, db.colorG, db.colorB, db.colorA = r,g,b,a
	if self:IsEnabled() then self:Refresh() end
end
