MiDKP=MiDKP or {} local M = MiDKP local GetNumGroupMembers = GetNumGroupMembers local GetRaidRosterInfo = GetRaidRosterInfo M.OO={} M.OO.Entity={} local function entity_equal(e1,e2) if e1:GetID() ~= e2:GetID() then return false end return true end local function name_eq (e1,e2) if type(e1) ~= type(e2) then return false end if e1:GetType() ~= e2:GetType() then return false end if string.iequal(e1.name,e2.name) then return true end return false end function M.OO.Entity:new(etype) local new_inst={} setmetatable(new_inst,{__index=M.OO.Entity,__eq=entity_equal}) new_inst.ctime = M.U:GetTimeStamp() new_inst.type=etype new_inst.id = new_inst:GenerateID() return new_inst end function M.OO.Entity:GenerateID() local str = tostring(self) local cap = str:match("[^:]*: 0x(.*)$") or str:match("[^:]*: (.*)$") if cap then cap = ("0"):rep(8 - #cap) .. cap end return ("%x"):format(time())..":"..cap end function M.OO.Entity:GetType() return self.type or "Entity" end function M.OO.Entity:GetID() return self.id end function M.OO.Entity:GetTip() if self.ctime then return string.format(M.L.PAGE_HAPPENS_AT,self.ctime[1]) else return "" end end function M.OO.Entity:GetName() return self.name or "" end function M.OO.Entity:IsList() return string.find(self.type,"List") end function M.OO.Entity:IsMember() return string.find(self.type,"Member$") end function M.OO.Entity:Debug() print("Entity: ".. self:GetName()) print("Type: ".. self.type) print('============================================') for _field,_val in pairs(self) do M.U:Dump(" Field: ".._field) M.U:Dump(_val) print('...............') end print('============================================') end function M.OO.Entity:Self() return self end function inheri(base,t) local new_class={} function new_class:new(...) local new_inst=base:new(...) setmetatable(new_inst,{__index=new_class,__eq=entity_equal}) return new_inst end if base then setmetatable(new_class, {__index=base}) end function new_class:class() return new_class end function new_class:superClass() return base end if t then new_class.pageType = t end return new_class end M.OO.RaidEntity = inheri(M.OO.Entity) function M.OO.RaidEntity:new(...) local new_inst=M.OO.Entity:new(...) new_inst.ctime = M.U:GetTimeStamp() setmetatable(new_inst,{__index=M.OO.RaidEntity,__eq=entity_equal}) new_inst.save = {} return new_inst end function M.OO.RaidEntity:GetCTime() return self.ctime end function M.OO.RaidEntity:SetRaid( raid) self.raid = raid end function M.OO.RaidEntity:GetRaid() return self.raid end function M.OO.RaidEntity:GetPoint() self.point = self.point or 0 return self.point end function M.OO.RaidEntity:SetDeleted(tog) self.deleted = tog end function M.OO.RaidEntity:IsDeleted() return self.deleted end function M.OO.RaidEntity:Wipe() local save = self:GetRaid():GetSaveTable() if save then save [self.id] = nil end self:SetRaid(nil) end function M.OO.RaidEntity:Save() self:DoSave() self:SetTable() end function M.OO.RaidEntity:DoSave() end function M.OO.RaidEntity:SetTable() self:GetRaid():GetSaveTable()[self.id] = self.save end M.OO.Raid=inheri(M.OO.RaidEntity) function M.OO.Raid:Create(name,suite) local createName = function() local time = M.U:GetTimeStamp() return M.L.RAID_PAGE_NAME_PATTERN .. time[1] .. ")" end local newRaid = self:class():new("Raid") newRaid.name = name or createName() newRaid.dkp = suite newRaid.creator = UnitName("player") newRaid.status = MIDKP_STAT_INITED newRaid.save.entities = newRaid.save.entities or {} newRaid.active = false newRaid.memberList = M.OO.MemberList:Create() newRaid.eventList = M.OO.EventList:Create() newRaid.itemList = M.OO.ItemList:Create() newRaid.zoneList = M.OO.List:Create() return newRaid end function M.OO.Raid:Modify(name,suite) self.name = name self.dkp = suite end function M.OO.Raid:Load(_id) local newRaid = self:class():new("Raid") newRaid.id = _id newRaid.memberList = M.OO.MemberList:Create() newRaid.eventList = M.OO.EventList:Create() newRaid.itemList = M.OO.ItemList:Create() newRaid.save = M.DB[_id] newRaid.zoneList = M.OO.Zone:Build(newRaid.save.zones) newRaid.name = newRaid.save.name newRaid.dkp = M.Data.Suites:Find(newRaid.save.dkp) newRaid.creator = newRaid.save.creator newRaid.ctime = newRaid.save.ctime newRaid.startTime = newRaid.save.startTime newRaid.endTime = newRaid.save.endTime newRaid.status = newRaid.save.status newRaid.active = newRaid.save.active return newRaid end function M.OO.Raid:DeepLoad() self:GetEventList():RunList("DeepLoad") self:GetItemList():RunList("DeepLoad") self:GetMemberList():RunList("DeepLoad") end function M.OO.Raid:DoSave() local t =self.save t.name = self.name t.dkp = self.dkp and self.dkp:GetName() t.creator = self.creator t.ctime = self.ctime t.startTime =self.startTime t.endTime =self.endTime t.status = self.status t.active = self.active t.zones = {} if self.status ==MIDKP_STAT_ENDED then t.export = self:Export() end self.zoneList:Save(t.zones) end function M.OO.Raid:SetTable() M.DB[self.id] = self.save end function M.OO.Raid:SaveAll() self:Save() self:GetMemberList():Save() self:GetItemList():Save() self:GetEventList():Save() end function M.OO.Raid:GetPlaces() return self.zoneList:ToString() end function M.OO.Raid:GetStatusText() return MIDKP_RAID_STATUS[self.status] end function M.OO.Raid:GetStatus() return self.status end function M.OO.Raid:GetMemberList() return self.memberList end function M.OO.Raid:GetItemList() return self.itemList end function M.OO.Raid:GetEventList() return self.eventList end function M.OO.Raid:GetActualEventList() local list = M.OO.EventList:Create() self.eventList:RunList(function(event) list:Add(abs(event:GetPoint())>0 and event) end) return list end function M.OO.Raid:GetActualItemList() local list = M.OO.ItemList:Create() self.itemList:RunList(function(item) list:Add(abs(item:GetPoint())>0 and item) end) return list end function M.OO.Raid:GetSaveTable() return self.save.entities end function M.OO.Raid:GetDKP() return self.dkp end function M.OO.Raid:GetStartTime() return self.startTime end function M.OO.Raid:GetEndTime() return self.endTime end function M.OO.Raid:GetInfoText() local text = string.format(M.L.RAID_PAGE_TOTALMEMBER,self:GetMemberList():GetUndeleted():Count()) if self:GetStartTime() then text = text .. M.L.RAID_PAGE_START .. self:GetStartTime()[1] end if self:GetEndTime() then text = text .. M.L.RAID_PAGE_END .. self:GetEndTime()[1] end return text end function M.OO.Raid:IsRaidValid() return M.Debug or self.status == MIDKP_STAT_STARTED end function M.OO.Raid:SetList(source,dest) source:Clear() dest:RunList(function(entity) source:Add(entity) entity:SetRaid(self) end) end function M.OO.Raid:SetMemberList(list) self:SetList(self.memberList,list) end function M.OO.Raid:SetItemList(list) self:SetList(self.itemList,list) end function M.OO.Raid:SetEventList(list) self:SetList(self.eventList,list) end function M.OO.Raid:SetStartTime() self.startTime = M.U:GetTimeStamp() end function M.OO.Raid:SetEndTime() self.endTime = M.U:GetTimeStamp() end function M.OO.Raid:AddPlace(zone) self.zoneList:Add(zone) end function M.OO.Raid:Start() M.E:Assert(self:GetStatus()==MIDKP_STAT_INITED,"RAID_WRONG_STATUS") self:SetMemberList(M.OO.MemberList:GetCurrentRaidMembers()) self:GetMemberList():RunList(function(member) M.DO.Alt:CheckMember(member) end) M.E:Assert(self.memberList:Count() > 0 ,"RAID_NOT_IN_RAID") self:SetStartTime() self.status=MIDKP_STAT_STARTED self:GetMemberList():SetStartTime() M.E:FireEvent("RAID_STARTED",self) end function M.OO.Raid:End() M.E:Assert(self:GetStatus()==MIDKP_STAT_STARTED,"RAID_WRONG_STATUS") self:SetEndTime() self:GetMemberList():SetEndTime() self.status=MIDKP_STAT_ENDED M.E:FireEvent("MIDKP_TEXT_RAID_ENDED",self) end function M.OO.Raid:IsRunning() return self:GetStatus()==MIDKP_STAT_STARTED end function M.OO.Raid:Activate() M.E:Assert(not self:IsActivated(),"RAID_ACTIVATED") self.active = true end function M.OO.Raid:Deactivate() M.E:Assert(self:IsActivated(),"RAID_NOTACTIVATED") self.active = false end function M.OO.Raid:IsActivated() return self.active end function M.OO.Raid:AddMember(e) self:GetMemberList():Add(e) e:SetRaid(self) e:SetStartTime() e:UpdateDKP() return true end function M.OO.Raid:AddEvent(e) self:GetEventList():Add(e) e:SetRaid(self) end function M.OO.Raid:AddItem(e) self:GetItemList():Add(e) e:SetRaid(self) end function M.OO.Raid:DeleteMember(e) end function M.OO.Raid:DeleteEvent(e) self:GetEventList():Delete(e) e:Wipe() end function M.OO.Raid:DeleteItem(e) self:GetItemList():Delete(e) e:Wipe() end function M.OO.Raid:Export() local xml = "" xml = xml .. "<midkp><raid>" xml = xml .. "<name>" .. M.U:ParseHTMLText(self:GetName()) .. "</name>" xml = xml .. "<version>" .. "0.90" .. "</version>" xml = xml .. "<start>" ..self:GetStartTime()[1] .. "</start>" xml = xml .. "<end>" ..self:GetEndTime()[1] .. "</end>" xml = xml .. "<creator>" .. self.creator .. "</creator>" if (self.zoneList:Count()>0) then xml = xml .. "<places>" self.zoneList:RunList(function(entity) xml = xml .."<place>"..entity:GetName().."</place>" end) xml = xml .. "</places>" end xml = xml .. self.memberList:Export() xml = xml .. self.eventList:Export() xml = xml .. self.itemList:Export() xml = xml .. "</raid></midkp>" return xml end function M.OO.Raid:CompareMember(memberList) local updateMembersFromList = function() local list = M.OO.MemberList:Create() self.memberList:RunList(function(entity) list:Add(memberList:Find(entity)) end) return list end local findLeftMembersFromList = function() local list = M.OO.MemberList:Create() self.memberList:RunList(function(member) list:Add((not memberList:Find(member)) and member) end) return list end local findNewMembersFromList = function() local list = M.OO.MemberList:Create() memberList:RunList(function(member) list:Add((not self.memberList:Find(member)) and member) end) return list end local joinList = findNewMembersFromList() local leaveList = findLeftMembersFromList() local updateList = updateMembersFromList() return leaveList,joinList,updateList end M.OO.Member=inheri(M.OO.RaidEntity) function M.OO.Member:Create(name,class) local newMember = self:class():new("Member") newMember:Modify(name,class) getmetatable(newMember).__eq = name_eq newMember.events = M.OO.EventList:Create() newMember.items = M.OO.ItemList:Create() newMember.point = 0 newMember.usedPoint = 0 newMember.minor = M.OO.MemberList:Create() return newMember end function M.OO.Member:Modify(name, class) self.name = name if class and type(class) == 'string' then self.class = M.OO.Class:GetByName(class) elseif class and type(class) == 'table' and class:GetType() == 'Class' then self.class = class else M.E:ThrowError("MEMBER_INVALID_CLASS") end end function M.OO.Member:Load(t,id) local member = M.OO.Member:Create(t.name,t.class) member.id = id member.startTime = t.starttime member.endTime = t.endtime member.mainID = t.main member.deleted = t.deleted return member end function M.OO.Member:DeepLoad() if self.mainID then self:SetMain(self:GetRaid():GetMemberList():Find(self.mainID)) self.mainID = nil end self.history = M.Data.DKP:Find(self.name) end function M.OO.Member:DoSave() local t = self.save t.type = self:GetType() t.class = self:GetClass() and self:GetClass():GetName() t.name = self:GetName() t.starttime = self:GetStartTime() t.deleted = self.deleted t.endtime = self:GetEndTime() if self.main then t.main = self.main:GetID() else t.main = nil end end function M.OO.Member:GetTotalPoint() self.totaldkp = self:GetCurrentDKPPoint() + self:GetPoint() return self.totaldkp end function M.OO.Member:GetCurrentDKPPoint() return self:GetHistoryPoint(self:GetRaid():GetDKP()) end function M.OO.Member:GetHistory() return self.history end function M.OO.Member:GetHistoryPoint(index) return self.history and self.history:GetHistoryPoint(index) or 0 end function M.OO.Member:GetStatus() return self.online, self.zone, self.group end function M.OO.Member:GetInRaid() return self.inraid end function M.OO.Member:GetEndTime() return self.endTime end function M.OO.Member:GetStartTime() return self.startTime end function M.OO.Member:GetClass() return self.class end function M.OO.Member:GetEvents() return self.events end function M.OO.Member:GetItems() return self.items end function M.OO.Member:GetRenderName() local subFix ="" if self:GetMain() then subFix = M.L.MINOR elseif self:HasMinor() then subFix = M.L.MAIN end if not self.inraid then subFix = subFix..M.L.AWAY elseif not self.online then subFix = subFix..M.L.OFFLINE end return "|c"..self.class:GetColor() ..self.name.."|r"..subFix end function M.OO.Member:GetSETimeText() local text = "" if self:GetStartTime() then local ttime =self:GetStartTime()[1] if type(ttime)=='table' then ttime = ttime[1] end text = text .. M.L.MEMBER_PAGE_JOIN_TIME..ttime end if self:GetEndTime() then local ttime =self:GetEndTime()[1] if type(ttime)=='table' then ttime = ttime[1] end text = text .. M.L.MEMBER_PAGE_LEAVE_TIME..ttime end return text end function M.OO.Member:GetMain() return self.main end function M.OO.Member:HasMinor() for i = 1 ,self.minor:Count() do if not self.minor:Get(i):IsDeleted() then return true end end return false end function M.OO.Member:GetRealMember() return self:GetMain() or self end function M.OO.Member:GetLeftPoint() self.leftPoint = self:GetCurrentDKPPoint()-(self.usedPoint) return self.leftPoint end function M.OO.Member:HasDKPPoint(index) return self.history:GetPoint(index) end function M.OO.Member:SetStatus(online,zone,group) self.online = online self.zone = zone self.group = group end function M.OO.Member:SetInRaid(inraid) self.inraid = inraid end function M.OO.Member:SetEndTime() if self:GetRaid():IsRunning() then self.endTime = self.endTime or M.U:GetTimeStamp() end end function M.OO.Member:SetStartTime() if self:GetRaid() and self:GetRaid():IsRunning() then self.startTime = self.startTime or M.U:GetTimeStamp() end end function M.OO.Member:SetPoint(point) self.point = point self.totaldkp = self:GetCurrentDKPPoint() + self:GetPoint() self.leftPoint = self:GetCurrentDKPPoint()-(self.usedPoint) end function M.OO.Member:SetMain(main) self.main = main main.minor:Add(self) end function M.OO.Member:ClearMain() self.main.minor:Delete(self) self.main = nil end function M.OO.Member:ClearEndTime() self.endTime = nil end function M.OO.Member:UpdateStatus(member) self.online = member.online self.inraid = member.inraid self.group = member.group if self.endTime and self.inraid then self:ClearEndTime() end end function M.OO.Member:UpdateDKP() self.history= M.Data.DKP:Find(self.name) end function M.OO.Member:ClearPoint() self:SetPoint(0) self.usedPoint = 0 self.events:Clear() self.items:Clear() end function M.OO.Member:Export() local xml = "<member>" xml = xml .. "<name>"..self:GetName().."</name>" xml = xml .. "<class>"..self:GetClass():GetName().."</class>" xml = xml .. "</member>" return xml end function M.OO.Member:IsInRaid(includeOff) return (includeOff or self:GetStatus()) and self:GetInRaid() end function M.OO.Member:IsInFirstFive(includeOff) return self:IsInRaid(includeOff) and select(3, self:GetStatus()) <= 5 end M.OO.DKPMember = inheri(M.OO.RaidEntity) function M.OO.DKPMember:Create(name,class) local newMember = self:class():new("DKPMember") getmetatable(newMember).__eq = name_eq newMember.name = name newMember.class = class newMember.suites = {} return newMember end function M.OO.DKPMember:SetPoint(suite,point) self[suite:GetName()] = point self.suites[suite] = point end function M.OO.DKPMember:GetHistoryPoint(suite) local point if not suite then return false end if type(suite)=='table' and suite:GetType()=='Suite' then point = self[suite:GetName()] elseif type(suite)=='number' then if M.Data.Suites:Find(suite) then point = self[M.Data.Suites:Find(suite):GetName()] else point = 0 end end return point end function M.OO.DKPMember:GetClass() return self.class end M.OO.DKPSuite = inheri(M.OO.Entity) function M.OO.DKPSuite:Create(name,index) local newDKP = self:class():new("Suite") newDKP.name = name newDKP.id = index return newDKP end function M.OO.DKPSuite:GetName() return self.name end function M.OO.DKPSuite:GetIndex() return self.id end M.OO.Event=inheri(M.OO.RaidEntity) function M.OO.Event:CreateRaw(eventDrive,itemDrive) local newEvent = self:class():new("Event") newEvent.eventDrive = eventDrive if newEvent.eventDrive then newEvent.isBoss = true newEvent.isAuto = true end newEvent.itemDrive = itemDrive newEvent.members = M.OO.MemberList:Create() return newEvent end function M.OO.Event:Create(eventDrive,itemDrive,...) local newEvent = self:class():CreateRaw(eventDrive,itemDrive) if itemDrive then local item = ... M.E:Assert((item and item:GetType() == "Item"),"EVENT_INVALID_ITEM") newEvent.item = item newEvent.name = string.format(M.L.EVENT_PAGE_SPLIT_NAME_PAT, item:GetName()) item:SetEvent(newEvent) else local point,name = ... newEvent:Modify(point,name) end return newEvent end function M.OO.Event:Modify(point,name) if name and type(name) == 'string' then self.name = name elseif self.name then else M.E:ThrowError("EVENT_NAME_EMPTY") end if point and type(point) == 'number' then self.point = point elseif self.point then M.E:ThrowError("EVENT_POINT_INVALID") end end function M.OO.Event:DeepLoad() if self.itemID then self:SetItem(self:GetRaid():GetItemList():Find(self.itemID)) self.itemID = nil end if self.memberID then local _member for _,_member in pairs(self.memberID) do self:AddMember(self:GetRaid():GetMemberList():Find(_member)) end self.memberID = nil end end function M.OO.Event:Load(t,id) local eventDrive = false local itemDrive = false if t.item then itemDrive = true end if t.auto then eventDrive = true end local event if itemDrive then event = self:class():CreateRaw(eventDrive,itemDrive) event.itemID = t.item event.name = t.name else event = M.OO.Event:Create(eventDrive,itemDrive,t.point,t.name) end event.id = id event.isBoss = t.boss event.deleted = t.deleted event.ctime = t.ctime event.memberID = t.players return event end function M.OO.Event:Save() local t = self.save t.type = self:GetType() t.ctime = self:GetCTime() t.name = self:GetName() if self:GetItem() then t.item = self:GetItem():GetID() else t.point = self:GetPoint() end t.auto = self.isAuto t.boss = self.isBoss t.deleted = self.deleted t.players ={} self.members:RunList(function(member) tinsert(t.players,member:GetID()) end) local save = self:GetRaid():GetSaveTable() save [self.id] = t end function M.OO.Event:SetBoss(boss) self.isBoss=boss end function M.OO.Event:SetItem(item) if self:IsItemDrive() then self.item = item item:SetEvent(self) end end function M.OO.Event:SetMemberList(members) self.members = members:Copy() end function M.OO.Event:IsEventDrive() return self.eventDrive end function M.OO.Event:IsItemDrive() return self.itemDrive end function M.OO.Event:GetPoint() if self:IsItemDrive() then if self:GetItem() and self:GetItem():GetPoint() then local count = self:GetRealMemberList():Count() M.E:Assert(count > 0,"EVENT_EMPTY_MEMBERLIST") return string.twodigitfloat(self:GetItem():GetPoint()/count) end return 0 else return self.point end end function M.OO.Event:GetName() if self:IsItemDrive() and self.item then return string.format(M.L.EVENT_PAGE_SPLIT_NAME_PAT, self.item:GetName()) else return self.name end end function M.OO.Event:GetIcon() if self.isBoss then return 'Interface\\Icons\\spell_holy_sealofprotection' elseif self:GetItem() then return 'Interface\\Icons\\ability_druid_balanceofpower' else return 'Interface\\Icons\\inv_letter_16' end end function M.OO.Event:GetItem() if self.item and self.item:GetType() == 'Item' then return self.item else return nil end end function M.OO.Event:GetBoss() return self.isBoss end function M.OO.Event:GetRealMemberList() local list = M.OO.MemberList:Create() self.members:RunList(function(member) list:Add(not member:IsDeleted() and member:GetRealMember()) end) return list end function M.OO.Event:GetMemberList() M.E:Assert(self.members,"EVENT_EMPTY_MEMBERLIST") return self.members end function M.OO.Event:AddMember(member) M.E:Assert((member and member:GetType() == 'Member'),"EVENT_INVALID_MEMBER") if self.members:Find(member) then return end self.members:Add(member) end function M.OO.Event:DeleteMember(member) M.E:Assert((member and member:GetType() == 'Member'),"MEMBER_INVALID") M.E:Assert(self.members:Find(member),"MEMBER_NOT_INLIST") self.members:Delete(member) end function M.OO.Event:Export() local xml = "<event>" xml = xml .. "<name>"..M.U:ParseHTMLText(self:GetName()).."</name>" if self:GetBoss() then xml = xml .. "<boss>1</boss>" end xml = xml .. "<time>".. self:GetCTime()[1].."</time>" xml = xml .. self:GetMemberList():GetUndeleted():GetMainMemberList():ExportSimple() xml = xml .. "<point>" .. abs(self:GetPoint()) .."</point>" if self:GetPoint() < 0 then xml = xml .. "<punish>true</punish>" end xml = xml .. "</event>" return xml end function M.OO.Event:OnUpdated() local memberList = self:GetRealMemberList() memberList:RunList(function(member) member.events:Add(self) member:SetPoint(member:GetPoint() + self:GetPoint()) end) end function M.OO.Event:OnModify() local memberList = self:GetRealMemberList() self.oldMemberList:RunList(function (member) member.events:Delete(self) member:SetPoint(member:GetPoint() - self.oldPoint) end) memberList:RunList(function(member) member.events:Add(self) member:SetPoint(member:GetPoint() + self:GetPoint()) end) end function M.OO.Event:OnAdded() local memberList = self:GetRealMemberList() memberList:RunList(function(member) member.events:Add(self) member:SetPoint(member:GetPoint() + self:GetPoint()) end) end function M.OO.Event:OnDelete() local memberList = self:GetRealMemberList() memberList:RunList(function(member) member.events:Delete(self) member:SetPoint(member:GetPoint() - self:GetPoint()) end) end M.OO.Item=inheri(M.OO.RaidEntity) function M.OO.Item:Create(name,point) local newItem = self:class():new("Item") newItem:Modify(point,name) return newItem end function M.OO.Item:Modify(point,name) if name and type(name) == 'string' then self.name = name elseif self.name then else self.name = "" M.E:ThrowError("ITEM_INVALID_NAME") end if point and type(point) == 'number' then self.point = point elseif self.point then else self.point = 0 M.E:ThrowError("ITEM_INVALID_POINT") end end function M.OO.Item:Save() local t = self.save t.type = self:GetType() t.name = self:GetName() t.point = self:GetPoint() t.ctime = self:GetCTime() t.player = self:GetMember():GetID() if self.event then t.event = self:GetEvent():GetID() else t.event = nil end local save = self:GetRaid():GetSaveTable() save [self.id] = t end function M.OO.Item:Load(t,id) local item = M.OO.Item:Create(t.name,t.point) item.id = id item.ctime = t.ctime item.memberID = t.player item.eventID = t.event return item end function M.OO.Item:DeepLoad() if self.eventID then self:SetEvent(self:GetRaid():GetEventList():Find(self.eventID)) self.eventID = nil end if self.memberID then self:SetMember(self:GetRaid():GetMemberList():Find(self.memberID)) self.memberID = nil end end function M.OO.Item:SetSplit(toggle) self.isSplited = toggle end function M.OO.Item:SetEvent(event) M.E:Assert((event and event:GetType() == 'Event'),"EVENT_INVALID") self.event = event end function M.OO.Item:SetMember(member) M.E:Assert((member and member:GetType() == 'Member'),"MEMBER_INVALID") self.member = member end function M.OO.Item:GetEvent() return self.event end function M.OO.Item:GetMember() return self.member end function M.OO.Item:GetRealMemberName() return self.member:GetRealMember():GetName() end function M.OO.Item:GetLink() return M.U:FindItemLink(self.name) end function M.OO.Item:GetPlainName() local itemString = M.U:FindItemLink(self.name) if itemString then return select(1,GetItemInfo(itemString)) else return self.name end end function M.OO.Item:GetIcon() local itemLink = M.U:FindItemLink(self.name) if not itemLink then return false end return select(10,GetItemInfo(itemLink)) end function M.OO.Item:GetLink() return M.U:FindItemLink(self.name) end function M.OO.Item:IsSplited() return self.isSplited end function M.OO.Item:ClearEvent() self.event = nil end function M.OO.Item:ClearMember() self.member = nil end function M.OO.Item:Export() local xml = "<item>" xml = xml .. "<name>"..M.U:ParseHTMLText(self:GetName()).."</name>" xml = xml .. "<time>".. self:GetCTime()[1].."</time>" xml = xml .. "<looter>"..self:GetMember():GetRealMember():GetName().. "</looter>" xml = xml .. "<point>" .. abs(self:GetPoint()) .."</point>" xml = xml .. "</item>" return xml end function M.OO.Item:IsDeleted() return false end function M.OO.Item:OnUpdated() local member = self:GetMember():GetRealMember() member.items:Add(self) member:SetPoint(member:GetPoint() - self:GetPoint()) member.usedPoint = self:GetPoint() + member.usedPoint end function M.OO.Item:OnModify() local member = self:GetMember():GetRealMember() if (self.oldMember) then self.oldMember:SetPoint(self.oldMember:GetPoint()+(self.oldPoint or 0)) self.oldMember.usedPoint = self.oldMember.usedPoint - (self.oldPoint or 0) self.oldMember:GetItems():Delete(self) end member.items:Add(self) member:SetPoint(member:GetPoint() - self:GetPoint()) member.usedPoint = self:GetPoint() + member.usedPoint end function M.OO.Item:OnAdded() local member = self:GetMember():GetRealMember() member.items:Add(self) member:SetPoint(member:GetPoint() - self:GetPoint()) member.usedPoint = self:GetPoint() + member.usedPoint end function M.OO.Item:OnDelete() local member = self:GetMember():GetRealMember() member.items:Delete(self) member:SetPoint(member:GetPoint() + self:GetPoint()) member.usedPoint = self:GetPoint() - member.usedPoint end M.OO.IItem=inheri(M.OO.Entity) function M.OO.IItem:Create(name) local newItem = self:class():new("IItem") newItem.name = name getmetatable(newItem).__eq = name_eq return newItem end function M.OO.IItem:Modify(name) self.name = name end function M.OO.IItem:Save(t) table.insert(t,self:GetName()) end --[[Fragment will generate a section of report, like a list of events, or a list of dkp infos, called by report to produce a whole list ]] M.OO.Fragment = inheri(M.OO.Entity) M.OO.Fragment.FormatTable ={ Help = { Text = M.L.TEXT_HELP_MESSAGE }, Invalid = { Text = M.L.TEXT_INV_MESSAGE }, SelfEvents = { Title = M.L.TEXT_EVENT_TITLE_SELF, Empty = M.L.TEXT_EVENT_NONE_SELF, Listing = M.L.TEXT_EVENT_INFO, }, SelfItems = { Title = M.L.TEXT_ITEM_TITLE_SELF, Empty = M.L.TEXT_ITEM_NONE_SELF, Listing = M.L.TEXT_ITEM_INFO, }, SelfCurrentAndHis = { NotFound = M.L.TEXT_CURRENT_NONE_SELF, Info = M.L.TEXT_CURRENT_INFO_HIS, }, SelfCurrentBind = { NotFound = M.L.TEXT_CURRENT_NONE_SELF, Info = M.L.TEXT_CURRENT_INFO_SELF_BIND, }, SelfCurrentNotBind = { NotFound = M.L.TEXT_CURRENT_NONE_SELF, Info = M.L.TEXT_CURRENT_INFO_SELF_NOT_BIND, }, SelfHistory = { NotFound = M.L.TEXT_HISTORY_NONE_SELF, Info = M.L.TEXT_HISTORY_INFO_SELF, }, MemberEvents = { Title = M.L.TEXT_EVENT_TITLE_MEMBER, Empty = M.L.TEXT_EVENT_NONE_MEMBER, Listing = M.L.TEXT_EVENT_INFO, }, MemberItems = { Title = M.L.TEXT_ITEM_TITLE_MEMBER, Empty = M.L.TEXT_ITEM_NONE_MEMBER, Listing = M.L.TEXT_ITEM_INFO, }, MemberCurrentAndHis = { NotFound = M.L.TEXT_CURRENT_NONE_SELF, Info = M.L.TEXT_CURRENT_INFO_MEMBER_HIS, }, MemberCurrentBind = { NotFound = M.L.TEXT_CURRENT_NONE_MEMBER, Info = M.L.TEXT_CURRENT_INFO_MEMBER_BIND, }, MemberCurrentNotBind = { NotFound = M.L.TEXT_CURRENT_NONE_MEMBER, Info = M.L.TEXT_CURRENT_INFO_MEMBER_NOTBIND, }, MemberHistory = { NotFound = M.L.TEXT_HISTORY_NONE_MEMBER, Info = M.L.TEXT_HISTORY_INFO_MEMBER, }, Events = { Title = M.L.TEXT_EVENT_TITLE, Empty = M.L.TEXT_EVENT_NONE, Listing = M.L.TEXT_EVENT_INFO, }, Items = { Title = M.L.TEXT_ITEM_TITLE, Empty = M.L.TEXT_ITEM_NONE, Listing = M.L.TEXT_ITEM_DETAIL_INFO, }, EventDetail = { Info = M.L.TEXT_EVENT_DETAIL }, MembersHistory = { Title = M.L.TEXT_MEMBERS_TITLE_HIS, Empty = M.L.TEXT_MEMBERS_NONE, Listing = M.L.TEXT_MEMBERS_INFO_NOT_BIND, }, ClassCurrentBind = { NotFound = M.L.TEXT_CLASS_NOTFOUND, Listing = M.L.TEXT_MEMBERS_INFO_BIND, Title = M.L.TEXT_CLASS_TITLE, Empty = M.L.TEXT_CLASS_EMPTY, }, ClassCurrentAndHis = { NotFound = M.L.TEXT_CLASS_NOTFOUND, Listing = M.L.TEXT_MEMBERS_INFO_CAH, Title = M.L.TEXT_CLASS_TITLE, Empty = M.L.TEXT_CLASS_EMPTY, }, ClassCurrentNotBind = { NotFound = M.L.TEXT_CLASS_NOTFOUND, Listing = M.L.TEXT_MEMBERS_INFO_NOTBIND, Title = M.L.TEXT_CLASS_TITLE, Empty = M.L.TEXT_CLASS_EMPTY, }, MembersCurrentBind = { Listing = M.L.TEXT_MEMBERS_INFO_BIND, Title = M.L.TEXT_MEMBERS_TITLE, Empty = M.L.TEXT_MEMBERS_NONE, }, MembersCurrentAndHis = { Listing = M.L.TEXT_MEMBERS_INFO_CAH, Title = M.L.TEXT_MEMBERS_TITLE, Empty = M.L.TEXT_MEMBERS_NONE, }, MembersCurrentNotBind = { Listing = M.L.TEXT_MEMBERS_INFO_NOT_BIND, Title = M.L.TEXT_MEMBERS_TITLE, Empty = M.L.TEXT_MEMBERS_NONE, }, } M.OO.Fragment.DataMethod ={ SelfEvents = { Listing = { {"Events" ,{"GetName","GetPoint"}} } }, SelfItems = { Listing = { {"Items" , {"GetName","GetPoint"}} } }, SelfCurrentAndHis = { Info = { {"Member",{"GetLeftPoint","GetTotalPoint"}} } }, SelfCurrentBind = { Info = { {"Member",{"GetCurrentDKPPoint","GetTotalPoint"}} } }, SelfCurrentNotBind = { Info = { {"Member",{"GetPoint"}} } }, SelfHistory = { NotFound = { {"Suite",{"GetName"}} }, Info = { {"Suite",{"GetName"}}, {"Point", {"Singleton"}}, } }, MemberEvents = { Title = { {"Member" , {"GetName"}} }, Empty = { {"Member" , {"GetName"}} }, Listing = { {"Events" , {"GetName","GetPoint"}} } }, MemberItems = { Title = { {"Member" , {"GetName"}} }, Empty = { {"Member" , {"GetName"}} }, Listing = { {"Items" , {"GetName","GetPoint","GetMember"}} } }, MemberCurrentAndHis ={ Info = { {"Member" , {"GetName","GetLeftPoint","GetTotalPoint"}} }, NotFound = { {"Member" , {"GetName"}} } }, MemberCurrentBind = { Info = { {"Member" , {"GetName","GetCurrentDKPPoint","GetTotalPoint"}} }, NotFound = { {"Member" , {"GetName"}} } }, MemberCurrentNotBind = { Info = { {"Member" , {"GetName","GetPoint"}} }, NotFound = { {"Member" , {"GetName"}} } }, MemberHistory = { NotFound = { {"Member" , {"GetName"}}, {"Suite" , {"GetName"}}, }, Info = { {"Member" , {"GetName"}}, {"Suite" , {"GetName"}}, {"Point" , {"Singleton"}}, } }, Events = { Listing = { {"Events" , {"GetName","GetPoint"}} } }, Items = { Listing = { {"Items" , {"GetName","GetRealMemberName","GetPoint"}} } }, EventDetail = { Info = { {"Event" , {"GetName","GetPoint"}}, {"Members" , {"Count"}} } }, MembersHistory = { Param = {"Index"}, Title = { {"Suite" , {"GetName"}} }, Listing = { {"Members" , {"GetName",{"GetHistoryPoint","Index"}}} }, }, ClassCurrentAndHis = { Listing = { {"Members" , {"GetName","GetLeftPoint","GetTotalPoint"}} }, Title = { {"Class" , {"GetLocaleString"}} }, Empty = { {"Class" , {"GetLocaleString"}} } }, ClassCurrentBind = { Listing = { {"Members" , {"GetName","GetCurrentDKPPoint","GetTotalPoint"}} }, Title = { {"Class" , {"GetLocaleString"}} }, Empty = { {"Class" , {"GetLocaleString"}} } }, ClassCurrentNotBind = { Listing = { {"Members" , {"GetName","GetPoint"}} }, Title = { {"Class" , {"GetLocaleString"}} }, Empty = { {"Class" , {"GetLocaleString"}} } }, MembersCurrentBind = { Listing = { {"Members" , {"GetName","GetCurrentDKPPoint","GetTotalPoint"}} }, }, MembersCurrentAndHis = { Listing = { {"Members" , {"GetName","GetLeftPoint","GetTotalPoint"}} }, }, MembersCurrentNotBind = { Listing = { {"Members" , {"GetName","GetPoint"}} }, } } function M.OO.Fragment:Create(name) local newFrag = self:class():new("Frag") newFrag.name = name newFrag.messages = {} self.data ={} self.params = {} return newFrag end function M.OO.Fragment:AddData(data,name) self.data[name] = data end function M.OO.Fragment:AddParams(data,name) self.params[name] = data end function M.OO.Fragment:GetText() local templateTable = self.FormatTable[self.name] local dataMethod = self.DataMethod[self.name] if templateTable and templateTable.Text then tinsert(self.messages,templateTable.Text) return self.messages end local function getFromMethodParamTable(data,params,methodTable) if not params[methodTable[2]] then return false end if data[methodTable[1]] and data[methodTable[1]](data,params[methodTable[2]]) then return data[methodTable[1]](data,self.params[methodTable[2]]) else return false end end local function getFromMethodTable(fields,data,methodsTable) for _,_method in pairs( methodsTable ) do if type(_method)=='string' then if _method =='Singleton' then tinsert(fields,data) else if data[_method] and data[_method](data) then tinsert(fields,data[_method](data)) else return false end end elseif type(_method)=='table' then local val = getFromMethodParamTable(data,self.params,_method) if val then tinsert(fields,val) else return false end end end return fields end local function getData(dataNameTable) local fields = {} if not dataNameTable then return fields end for _i = 1 , #dataNameTable do local dataName = dataNameTable[_i][1] local _methodTable = dataNameTable[_i][2] local data = self.data[dataName] if not data then return false end if not getFromMethodTable(fields,data,_methodTable) then return false end end --[[for _dataName,_methodsTable in pairs(dataNameTable) do local data = self.data[_dataName] if not data then return false end if not getFromMethodTable(fields,data,_methodsTable) then return false end end]] return fields end if templateTable and dataMethod then if templateTable.Info then local infoTemplate = templateTable.Info local notFoundTemplate = templateTable.NotFound local infoMethod = dataMethod.Info local notFoundMethod = dataMethod.NotFound local fields = getData(infoMethod) if fields then tinsert(self.messages,string.format(infoTemplate,unpack(fields))) else fields = getData(notFoundMethod) tinsert(self.messages,string.format(notFoundTemplate,unpack(fields))) end elseif templateTable.Listing then local notFoundTemplate = templateTable.NotFound local listingTemplate = templateTable.Listing local titleTemplate = templateTable.Title local emptyTemplate = templateTable.Empty local notFoundMethod = dataMethod.NotFound local listingMethod = dataMethod.Listing local titleMethod = dataMethod.Title local emptyMethod = dataMethod.Empty local function getListingData(stringList,dataNameTable) if not dataNameTable then return false end local _dataName = dataNameTable[1] and dataNameTable[1][1] local _methodTable = dataNameTable[1] and dataNameTable[1][2] local datalist = self.data[_dataName] if not datalist or type(datalist)~= 'table' or not datalist:IsList() or datalist:Count() ==0 then return false end for _i = 1, datalist:Count() do local data = datalist:Get(_i) local fields = {_i} fields = getFromMethodTable(fields,data,_methodTable) if fields then tinsert(stringList,string.format(listingTemplate,unpack(fields))) else fields = getData(notFoundMethod) tinsert(stringList,string.format(notFoundTemplate,unpack(fields))) end end return true end local fields = getListingData(self.messages,listingMethod) if not fields then fields = getData(emptyMethod) tinsert(self.messages,string.format(emptyTemplate,unpack(fields))) else local titleFields = getData(titleMethod) tinsert(self.messages,1,string.format(titleTemplate,unpack(titleFields))) end end end return self.messages end --[[ report set the target, receive report types from do class, and concatenates reportfrags into a list and then report it ]] M.OO.Report = inheri(M.OO.Entity) --[[ define report content here ]] M.OO.Report.DataFields = { SelfEvents = { DataList = {"Member"}, { Name = "SelfEvents", Data ={ Events = {"Member","GetEvents"} } }, }, SelfItems = { DataList = {"Member"}, { Name = "SelfItems", Data ={ Items = {"Member","GetItems"} } }, }, SelfCurrentAndHis = { DataList = {"Member"}, { Name = "SelfCurrentAndHis", Data = { Member ={"Member"} } } }, SelfCurrentBinded = { DataList = {"Member"}, { Name = "SelfCurrentBind", Data = { Member ={"Member"} } } }, SelfCurrentNotBinded = { DataList = {"Member"}, { Name = "SelfCurrentNotBind", Data = { Member ={"Member"} } } }, SelfHistory ={ ParamList = {"Index"}, DataList = {"DKPMember","Suites"}, { Name = "SelfHistory", Data = { Suite = {"Suites","Get","Index"}, Point = {"DKPMember","GetHistoryPoint","Index"} } } }, MemberEvents = { DataList = {"Member"}, { Name = "MemberEvents", Data ={ Events = {"Member","GetEvents"}, Member = {"Member"} } }, }, MemberItems = { DataList = {"Member"}, { Name = "MemberItems", Data ={ Items = {"Member","GetItems"}, Member = {"Member"} } }, }, MemberCurrentAndHis = { DataList = {"Member"}, { Name = "MemberCurrentAndHis", Data = { Member ={"Member"} } } }, MemberCurrentBinded ={ DataList = {"Member"}, { Name = "MemberCurrentBind", Data = { Member ={"Member"} } } }, MemberCurrentNotBinded = { DataList = {"Member"}, { Name = "MemberCurrentNotBind", Data = { Member ={"Member"} } } }, MemberHistory = { ParamList = {"Index"}, DataList = {"DKPMember","Suites"}, { Name = "MemberHistory", Data = { Suite = {"Suites","Get","Index"}, Point = {"DKPMember","GetHistoryPoint","Index"}, Member = {"DKPMember"}, } } }, Events ={ DataList = {"Raid"}, { Name = "Events", Data = { Events = {"Raid","GetActualEventList"} } } }, Items ={ DataList = {"Raid"}, { Name = "Items", Data = { Items = {"Raid","GetActualItemList"} } } }, EventDetail = { DataList = {"Event"}, { Name = "EventDetail", Data = { Event = {"Event"}, Members = {"Event","GetRealMemberList"} } } }, MembersCurrentBinded = { DataList = {"Members"}, { Name = "MembersCurrentBind", Data = { Members = {"Members"}, } } }, MembersCurrentAndHis = { DataList = {"Members"}, { Name = "MembersCurrentAndHis", Data = { Members = {"Members"}, } } }, MembersCurrentNotBinded = { DataList = {"Members"}, { Name = "MembersCurrentNotBind", Data = { Members = {"Members"}, } } }, ClassCurrentAndHis = { DataList = {"Class","Members"}, { Name = "ClassCurrentAndHis", Data = { Members = {"Members"}, Class = {"Class"}, } } }, ClassCurrentBinded = { DataList = {"Class","Members"}, { Name = "ClassCurrentBind", Data = { Members = {"Members"}, Class = {"Class"}, } } }, ClassCurrentNotBinded = { DataList = {"Class","Members"}, { Name = "ClassCurrentNotBind", Data = { Members = {"Members"}, Class = {"Class"}, } } }, MembersHistory = { ParamList = {"Index"}, DataList = {"Members","Suites"}, { Name = "MembersHistory", Data = { Members = {"Members"}, Suite = {"Suites","Get","Index"} }, Param = { Index = "Index", } } }, Help = { { Name = "Help", } }, Invalid = { { Name = "Invalid", } } } function M.OO.Report:Create(rtype,hideReply) local newRep = self:class():new("Report") newRep.rtype = rtype newRep.messages = {} newRep.hideReply = hideReply newRep.data = {} newRep.param = {} return newRep end function M.OO.Report:SetData(...) if self.DataFields[self.rtype] then local i = 1 while(select(i,...)) do self.data[ self.DataFields[self.rtype].DataList[i] ] = select(i,...) i = i + 1 end end end function M.OO.Report:SetParam(...) if self.DataFields[self.rtype] then local i = 1 while(select(i,...)) do self.param[ self.DataFields[self.rtype].ParamList[i] ] = select(i,...) i = i + 1 end end end function M.OO.Report:SetTarget(target) if type(target)=='table' then self.target = target elseif type(target)=='string' then self.channel = target end end function M.OO.Report:Report() M.U:Debug("Report Type: "..self.rtype) for _index,_dataNames in pairs(self.DataFields[self.rtype]) do if _index ~='DataList' and _index~='ParamList' then local frag = M.OO.Fragment:Create(_dataNames.Name) local dataTable = _dataNames.Data if dataTable then for _name,_methodTable in pairs(dataTable) do local _entity = _methodTable[1] local _method = _methodTable[2] local _param = _methodTable[3] local data if _entity and self.data[_entity] then local entity = self.data[_entity] if _method and entity[_method] then if _param and self.param[_param] then data = entity[_method](entity,self.param[_param]) else data = entity[_method](entity) end else data = entity end end frag:AddData(data,_name) end end local paramTable = _dataNames.Param if paramTable then for _paramName,_paramVal in pairs(paramTable) do frag:AddParams(self.param[_paramVal],_paramName) end end table.append(self.messages,frag:GetText()) end end self:Print() end function M.OO.Report:Print() if not self.messages then return end if self.target then if self.target:GetType() =='Member' or self.target:GetType()=='DKPMember' then M.U:Whisper(self.target,self.messages,self.hideReply) elseif self.target:GetType() =='MemberList' then self.target:RunList(function(entity,i,...) M.U:Whisper(entity,...) end,self.messages,self.hideReply) end elseif self.channel then M.U:Send(self.messages,self.channel) end end M.OO.List=inheri(M.OO.Entity) function M.OO.List:Create() local newList = self:class():new("List") newList.data={} return newList end function M.OO.List:Add(node) if node then if self:Find(node) then return end table.insert(self.data,node) end end function M.OO.List:Delete(node) for MiDKP_63a9ce6f1eeac72ef41293b7d0303335,MiDKP_8d0644c92128c1ff68223fd74ba63b56 in pairs(self.data) do if MiDKP_8d0644c92128c1ff68223fd74ba63b56 == node then table.remove(self.data,MiDKP_63a9ce6f1eeac72ef41293b7d0303335) return true end end end function M.OO.List:Count() return getn(self.data) end function M.OO.List:Get(index) return self.data[index] end function M.OO.List:GetByOffset(offset,pageSize) assert(offset>=0) assert(pageSize>0) local newList = self:class():Create() local startIndex = offset + 1 if self:Count() <startIndex then return newList end local endIndex = min(offset + pageSize,self:Count()) for _i = startIndex, endIndex do newList:Add(self:Get(_i)) end return newList end function M.OO.List:Sort(sortType,asc) local function compare(e1,e2,tag) if tag then return e1>e2 else return e2>e1 end end local function cmp(e1,e2) if not e1 or not e2 then return false end if type(e1)~='table' and type(e2)~='table' and type(e1) == type(e2) then return compare(e1,e2,asc) end if not e1[sortType] or not e2[sortType] then return false end if e1[sortType] and e2[sortType] then if type(e1[sortType]) == 'table' and type(e2[sortType]) == 'table' then if e1[sortType].GetType then if e1[sortType]:GetType() == e2[sortType]:GetType() then return compare(e1[sortType]:GetName() ,e2[sortType]:GetName(),asc) end end return cmp(e1[sortType][2],e2[sortType][2]) end return compare(e1[sortType] , e2[sortType] ,asc) end end local function cmp_min_and_main(e1,e2) if e1 and e1.GetMain and e1:GetMain() then return false end if e2 and e2.GetMain and e2:GetMain() then return true end return cmp(e1,e2) end if sortType =='point' or sortType =='totaldkp' then table.sort(self.data,cmp_min_and_main) else table.sort(self.data,cmp) end return self end function M.OO.List:Clear() local num = getn(self.data) for _i = 1, num do table.remove(self.data,1) end end function M.OO.List:Copy() local list = self:class():Create() self:FilterList(function()return true end,list) return list end function M.OO.List:Find(id) if type(id)=='string' then for _i=1,self:Count() do if string.iequal(self:Get(_i):GetName(),id) or self:Get(_i):GetID() == id then return self:Get(_i) end end elseif type(id)=='number' then return self:Get(id) elseif type(id)=='table' then for _i,MiDKP_a4ae8f1b50c7593a1bada9f62d1883fb in pairs(self.data) do if MiDKP_a4ae8f1b50c7593a1bada9f62d1883fb == id then return MiDKP_a4ae8f1b50c7593a1bada9f62d1883fb,_i end end end end function M.OO.List:Save(t) if t then wipe(t) end self:RunList(function(e) e:Save(t)end) end function M.OO.List:ToString() if self:Count()==0 then return "" end local s = self:Get(1):ToString() for _i = 2, self:Count() do s = s .. "," ..self:Get(_i):ToString() end return s end function M.OO.List:ToArray() return self.data end function M.OO.List:SetData(list) assert(type(list) == 'table') for _i, _set in pairs(list) do if _set[1] then self:Add(_set[4]) end end end function M.OO.List:Export() local xml = "<"..string.lower(self.xmlName)..">" if self:GetUndeleted():Count() == 0 then xml = xml .. "<"..self.singleXmlName.."/>" end self:GetUndeleted():RunList(function(entity) xml = xml..entity:Export() end) xml = xml.."</"..string.lower(self.xmlName)..">" return xml end function M.OO.List:RunList(func,...) local count = self:Count() if type(func)=='function' then local _i for _i = 1, count do func(self:Get(_i),_i,...) end _i = nil elseif count>0 then self:RunList(self:Get(1)[func],...) end end function M.OO.List:FilterList(filterFunc,list,...) local count = self:Count() if type(filterFunc)=='function' then for _i = 1, count do if filterFunc(self:Get(_i),...) then list:Add(self:Get(_i)) end end else self:FilterList(self:Get(_i)[filterFunc],list,...) end return list end function M.OO.List:GetRaid() if self:Count() == 0 then return nil end return self:Get(1).GetRaid and self:Get(1):GetRaid() end function M.OO.List:GetUndeleted() return self end M.OO.RaidList=inheri(M.OO.List) function M.OO.RaidList:Create() local newList = self:class():new("RaidList") newList.data={} return newList end function M.OO.RaidList:GetActive() if self.activatedRaid then return self.activatedRaid end self:RunList(function(raid) if raid:IsActivated() then self.activatedRaid = raid end end) if self.activatedRaid then return self.activatedRaid end end function M.OO.RaidList:Deactivate() if self.activatedRaid then self.activatedRaid:Deactivate() self.activatedRaid = nil end end function M.OO.RaidList:SetActivate(raid) if not self:Find(raid) then end if raid:IsActivated() then return end local currentActive = self:GetActive() if currentActive then currentActive:Deactivate() end raid:Activate() self.activatedRaid = raid end M.OO.MemberList=inheri(M.OO.List) function M.OO.MemberList:Create() local newList = self:class():new("MemberList") newList.xmlName = "members" newList.singleXmlName = "member" newList.data={} return newList end function M.OO.MemberList:ClearMemberPoint() self:RunList( function(member) member:ClearPoint() end) end function M.OO.MemberList:UpdateMembersDKP() self:RunList("UpdateDKP") end function M.OO.MemberList:UpdateMemberStatus(member) local oldMember = self:Find(member) if oldMember then oldMember:UpdateStatus(member) end end function M.OO.MemberList:GetInFirstFive(includeOffline) local list = M.OO.MemberList:Create() self:GetUndeleted():RunList(function(entity) list:Add(entity:IsInFirstFive(includeOffline) and entity:GetRealMember()) end) return list end function M.OO.MemberList:GetLastThree(includeOffline) local list = M.OO.MemberList:Create() self:GetUndeleted():RunList(function(entity) list:Add(entity:IsInRaid(includeOffline) and (not entity:IsInFirstFive(includeOffline)) and entity:GetRealMember()) end) return list end function M.OO.MemberList:GetInRaid(includeOffline) local list = M.OO.MemberList:Create() self:GetUndeleted():RunList(function(entity) list:Add(entity:IsInRaid(includeOffline) and entity:GetRealMember()) end) return list end function M.OO.MemberList:GetMainMemberList() local list = M.OO.MemberList:Create() self:GetUndeleted():RunList(function(entity) list:Add(entity:GetRealMember()) end) return list end function M.OO.MemberList:AddTestMembers() local member = M.OO.Member:Create(UnitName("player"),select(2,UnitClass("player"))) member:SetStatus(true,"",1) member:SetInRaid(true) self:Add(member) member = M.OO.Member:Create("TestMember",M.OO.Class.MAGE) member:SetStatus(true,"",1) member:SetInRaid(true) self:Add(member) end function M.OO.MemberList:GetCurrentRaidMembers() local memberList = M.OO.MemberList:Create() if (GetNumGroupMembers() <= 0) then if M.Debug then memberList:AddTestMembers() end return memberList end local num = GetNumGroupMembers() for _i = 1, num do local name,_,subgroup,_,_,fileName,zone,online = GetRaidRosterInfo(_i) if name and M.U:IsValidName(name) then local member = M.OO.Member:Create(name,fileName) member:SetStatus(online,zone,subgroup) member:SetInRaid(true) memberList:Add(member) end end return memberList end function M.OO.MemberList:SetStartTime() self:RunList("SetStartTime") end function M.OO.MemberList:SetEndTime() self:RunList("SetEndTime") end function M.OO.MemberList:FilterMember(memberList) local newList = self:class():Create() if not memberList then return newList end memberList:RunList(function(entity) newList:Add(self:Find(entity:GetName())) end) return newList end function M.OO.MemberList:FilterClass(classList) local newList = self:class():Create() self:FilterList(function(entity) return classList[entity:GetClass():GetID()] end,newList) return newList end function M.OO.MemberList:ClearEndTime() self:RunList("ClearEndTime") end function M.OO.MemberList:ExportSimple() local xml = "<members>" if self:Count() == 0 then xml = xml .. "<member/>" end self:RunList(function(entity) xml = xml.."<member>"..entity:GetName().."</member>" end) xml = xml.."</members>" return xml end function M.OO.MemberList:GetUndeleted() local newList = self:class():Create() self:FilterList(function(entity) return not entity:IsDeleted() end,newList) return newList end M.OO.DKPMemberList = inheri(M.OO.MemberList) function M.OO.DKPMemberList:GetSuite(suite) local newList = self:class():Create() self:FilterList(function(entity) return entity:GetHistoryPoint(suite) end,newList) return newList end M.OO.EventList=inheri(M.OO.List) function M.OO.EventList:Create() local newList = self:class():new("EventList") newList.xmlName = "events" newList.singleXmlName = "event" newList.data={} return newList end function M.OO.EventList:OnAddMember(member) self:RunList(function(entity) if entity:GetMemberList():Find(member) and entity:GetMemberList():Count() == 1 then entity:SetDeleted(false) end end) end function M.OO.EventList:DeleteMember(member) self:RunList(function(entity) if entity:GetMemberList():Find(member) and entity:GetMemberList():Count() == 1 then entity:SetDeleted(true) end end) end function M.OO.EventList:GetUndeleted() local newList = self:class():Create() self:FilterList(function(entity) return not entity:IsDeleted() end,newList) return newList end function M.OO.EventList:UpdateMemberPoint() self:RunList(function(entity) entity:OnUpdated() end) end M.OO.ItemList=inheri(M.OO.List) function M.OO.ItemList:Create() local newList = self:class():new("ItemList") newList.xmlName = "items" newList.singleXmlName = "item" newList.data={} return newList end function M.OO.ItemList:DeleteMember(member) for _,MiDKP_2e00ffac12aadb3a1fd865993ec505b9 in pairs(self.data) do if MiDKP_2e00ffac12aadb3a1fd865993ec505b9:GetMember() == member then self:Delete(MiDKP_2e00ffac12aadb3a1fd865993ec505b9) end end end function M.OO.ItemList:HasMember(member) for _,MiDKP_2e00ffac12aadb3a1fd865993ec505b9 in pairs(self.data) do if MiDKP_2e00ffac12aadb3a1fd865993ec505b9:GetMember() == member then return true end end return false end function M.OO.ItemList:UpdateMemberPoint() self:RunList(function(entity) entity:OnUpdated() end) end M.OO.IItemList=inheri(M.OO.List) function M.OO.IItemList:Create() local newList = self:class():new("IItemList") newList.data={} return newList end function M.OO.IItemList:Reset() self:Load(M.DefaultIgnoreItems) end function M.OO.IItemList:Load(t) self:Clear() for _i,_val in pairs(t) do self:Add(M.OO.IItem:Create(_val)) end end M.OO.Boss=inheri(M.OO.Entity) function M.OO.Boss:Create() local boss = self:class():new("Boss") return boss end function M.OO.Boss:SetName(name) self.name = name end function M.OO.Boss:Load() M.U:Debug("Bosses Inited") M.OO.Boss.Kills = M.Bosses.bosses.kill M.OO.Boss.MultiKill = M.Bosses.bosses.multikill M.OO.Boss.Emote = M.Bosses.bosses.emote M.OO.Boss.Loot = M.Bosses.bosses.loot end function M.OO.Boss:Find(zone,dname) local bossName = M.OO.Boss.Kills[zone:GetName()][dname] if bossName then local boss = M.OO.Boss :Create() if type(bossName)=='string' then boss:SetName(bossName) else boss:SetName(dname) end return boss end end function M.OO.Boss:GetByEmote(emote) if M.OO.Boss.Emote[emote] then local boss = M.OO.Boss :Create() boss:SetName(M.OO.Boss.Emote[emote]) return boss end end function M.OO.Boss:SetMultiKill(tbl) self.killTable = tbl end function M.OO.Boss:FindMultiKill(zone,dname) local killTable = M.OO.Boss.MultiKill[zone:GetName()] if not killTable then return end for _bossName,_table in pairs(killTable) do for _name, _tag in pairs(_table) do if _name == dname and _tag then local boss = M.OO.Boss :Create() boss:SetName(_bossName) boss:SetMultiKill(_table) boss:ResetMultiKill() return boss end end end end function M.OO.Boss:ResetMultiKill() for _name in pairs(self.killTable) do self.killTable[_name] = 0 end end function M.OO.Boss:AddMultiKill(name) for _name,_ in pairs(self.killTable) do if _name == name then self.killTable[_name] = 1 return end end end function M.OO.Boss:DoneMultiKill() for _name,_val in pairs(self.killTable) do if _val == 0 then return false end end return true end M.OO.Zone=inheri(M.OO.Entity) function M.OO.Zone:Create() local zone = self:class():new("Zone") getmetatable(zone).__eq = name_eq return zone end function M.OO.Zone:Load() M.U:Debug("Loading Zones") local list = M.OO.List:Create() for _zone,_tag in pairs(M.Bosses.zones) do if _tag then local zone = self:Create() zone:SetName(_zone) list:Add(zone) end end M.OO.Zones = list end function M.OO.Zone:Build(t) local list = M.OO.List:Create() for _,_val in pairs(t)do local zone = self:Create() zone:SetName(_val) list:Add(zone) end return list end function M.OO.Zone:SetName(name) self.name = name end function M.OO.Zone:Find(text) return M.OO.Zones:Find(text) end function M.OO.Zone:ToString() return self.name end function M.OO.Zone:Save(t) table.insert(t,self:GetName()) end M.OO.Class = inheri(M.OO.Entity) M.OO.Armor = inheri(M.OO.Entity) function M.OO.Class:Create(index) assert(index>=1) assert(index<=19) local newClass = self:class():new("Class") newClass.localized = MIDKP_CLASS[index][1] newClass.color = MIDKP_CLASS[index][2] newClass.armor = MIDKP_CLASS[index][3] newClass.shortcut = MIDKP_CLASS[index][4] newClass.id = index newClass.name = MIDKP_CLASS[index][5] return newClass end function M.OO.Class:GetByName(name) if not name or type(name) ~= 'string' then return end if not M.OO.Class.ClassTable then return end for _,_class in pairs(M.OO.Class.ClassTable) do if _class.localized[1] == name or _class.localized[2] == name or string.upper(_class.shortcut) == string.upper(name) or string.upper(_class.name) == string.upper(name) then return _class end end end function M.OO.Class:GetByID(id) for _,_class in pairs(M.OO.Class.ClassTable) do if _class:GetID() == id then return _class end end return M.OO.Class.UNKNOWN end function M.OO.Class:GetLocale() return self.localized end function M.OO.Class:GetLocaleString() return self.localized[1] end function M.OO.Class:GetArmor() return M.OO.Armor:GetByName(self.armor) end function M.OO.Class:GetColor() return self.color end function M.OO.Class:GetRenderName() return "|c"..self.color..self.localized[1].."|r" end function M.OO.Class:GetCoord() return CLASS_ICON_TCOORDS[string.upper(self.name)] end function M.OO.Armor:Create(index) assert(index>=1) assert(index<=16) local newArmor = self:class():new("armor") newArmor.localized = MIDKP_ARMOR[index][1] newArmor.id = index newArmor.name = MIDKP_ARMOR[index][2] newArmor.classes = M.OO.List:Create() for MiDKP_63a9ce6f1eeac72ef41293b7d0303335,MiDKP_8d0644c92128c1ff68223fd74ba63b56 in pairs(MIDKP_ARMOR[index][3]) do newArmor.classes:Add(M.OO.Class:Create(MiDKP_8d0644c92128c1ff68223fd74ba63b56)) end return newArmor end function M.OO.Armor:GetByID(id) for _,_armor in pairs(M.OO.Armor.ArmorTable) do if _armor:GetID() == id then return _armor end end return M.OO.Armor.Unknown end function M.OO.Armor:GetByName(name) if not name or type(name) ~= 'string' then return M.OO.Armor.Unknown end for _,_armor in pairs(M.OO.Armor.ArmorTable) do if _armor:GetLocale() == name or _armor:GetName() == name then return _armor end end return M.OO.Armor.Unknown end function M.OO.Armor:GetName() return self.name end function M.OO.Armor:GetClasses() return self.classes end function M.OO.Armor:GetLocale() return self.localized end function M.OO.Armor:ToArray() return {[1] = true,[2] = true,[3] = true,[4] = true,[5] = true,[6] = true,[7] = true,[8] = true,[9] = true,[10] = true,[11] = true, [12] = true,[13] = true,[14] = true,[15] = true,[16] = true,[17] = true,[18] = true,[19] = true,} end M.OO.Class.UNKNOWN = M.OO.Class:Create(3) M.OO.Class.MAGE = M.OO.Class:Create(5) M.OO.Class.PRIEST = M.OO.Class:Create(6) M.OO.Class.WARLOCK = M.OO.Class:Create(7) M.OO.Class.ROGUE = M.OO.Class:Create(9) M.OO.Class.DRUID = M.OO.Class:Create(10) M.OO.Class.MONK = M.OO.Class:Create(11) M.OO.Class.DEMONHUNTER = M.OO.Class:Create(12) M.OO.Class.HUNTER = M.OO.Class:Create(14) M.OO.Class.SHAMAN = M.OO.Class:Create(15) M.OO.Class.WARRIOR = M.OO.Class:Create(17) M.OO.Class.PALADIN = M.OO.Class:Create(18) M.OO.Class.DEATHKNIGHT = M.OO.Class:Create(19) M.OO.Class.ClassTable={ M.OO.Class.UNKNOWN , M.OO.Class.MAGE , M.OO.Class.PRIEST , M.OO.Class.WARLOCK , M.OO.Class.ROGUE , M.OO.Class.DRUID , M.OO.Class.MONK , M.OO.Class.DEMONHUNTER , M.OO.Class.HUNTER , M.OO.Class.SHAMAN , M.OO.Class.WARRIOR , M.OO.Class.PALADIN , M.OO.Class.DEATHKNIGHT , } M.OO.Armor.Unknown = M.OO.Armor:Create(2) M.OO.Armor.Cloth = M.OO.Armor:Create(4) M.OO.Armor.Leather = M.OO.Armor:Create(8) M.OO.Armor.Mail = M.OO.Armor:Create(13) M.OO.Armor.Plate = M.OO.Armor:Create(16) M.OO.Armor.ArmorTable={ M.OO.Armor.Unknown, M.OO.Armor.Cloth, M.OO.Armor.Leather, M.OO.Armor.Mail, M.OO.Armor.Plate }
