/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.util.Disposable;

public interface Application
extends Disposable {
    public Array<ApplicationListener> getListeners();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void addListener(ApplicationListener listener) {
        Array<ApplicationListener> array = this.getListeners();
        synchronized (array) {
            this.getListeners().add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void removeListener(ApplicationListener listener) {
        Array<ApplicationListener> array = this.getListeners();
        synchronized (array) {
            this.getListeners().remove(listener);
        }
    }

    public ApplicationType getType();

    default public int getVersion() {
        return 0;
    }

    public long getJavaHeap();

    default public long getNativeHeap() {
        return 0L;
    }

    public String getClipboardText();

    public void setClipboardText(String var1);

    public void post(Runnable var1);

    public void exit();

    @Override
    default public void dispose() {
        if (Core.assets != null) {
            Core.assets.dispose();
            Core.assets = null;
        }
        if (Core.scene != null) {
            Core.scene.dispose();
            Core.scene = null;
        }
        if (Core.atlas != null) {
            Core.atlas.dispose();
            Core.atlas = null;
        }
        if (Core.batch != null) {
            Core.batch.dispose();
            Core.batch = null;
        }
        if (Core.input != null) {
            Core.input.dispose();
        }
        Fill.dispose();
        Events.dispose();
    }

    public static enum ApplicationType {
        Android,
        Desktop,
        HeadlessDesktop,
        WebGL,
        iOS;

    }
}

