/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc;

import io.anuke.arc.Core;
import io.anuke.arc.KeyBinds;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.input.InputDevice;
import io.anuke.arc.input.InputMultiplexer;
import io.anuke.arc.input.InputProcessor;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.input.KeyboardDevice;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.math.geom.Vector3;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.OS;

public abstract class Input
implements Disposable {
    protected static final float deadzone = 0.3f;
    protected KeyboardDevice keyboard = new KeyboardDevice();
    protected Array<InputDevice> devices = Array.with(this.keyboard);
    protected InputMultiplexer inputMultiplexer = new InputMultiplexer(this.keyboard);
    protected IntSet caughtKeys = new IntSet();
    protected Vector2 mouseReturn = new Vector2();

    public Vector2 mouseWorld(float x, float y) {
        return Core.camera.unproject(this.mouseReturn.set(x, y));
    }

    public Vector2 mouseScreen(float x, float y) {
        return Core.camera.project(this.mouseReturn.set(x, y));
    }

    public Vector2 mouseWorld() {
        return Core.camera.unproject(this.mouse());
    }

    public Vector2 mouse() {
        return this.mouseReturn.set(this.mouseX(), this.mouseY());
    }

    public abstract int mouseX();

    public abstract int mouseX(int var1);

    public abstract int deltaX();

    public abstract int deltaX(int var1);

    public abstract int mouseY();

    public abstract int mouseY(int var1);

    public abstract int deltaY();

    public abstract int deltaY(int var1);

    public abstract boolean isTouched();

    public abstract boolean justTouched();

    public abstract boolean isTouched(int var1);

    public float getPressure() {
        return this.getPressure(0);
    }

    public float getPressure(int pointer) {
        return this.isTouched(pointer) ? 1.0f : 0.0f;
    }

    public boolean shift() {
        return this.keyDown(KeyCode.SHIFT_LEFT) || this.keyDown(KeyCode.SHIFT_RIGHT);
    }

    public boolean ctrl() {
        return OS.isMac ? this.keyDown(KeyCode.SYM) : this.keyDown(KeyCode.CONTROL_LEFT) || this.keyDown(KeyCode.CONTROL_RIGHT);
    }

    public boolean alt() {
        return this.keyDown(KeyCode.ALT_LEFT) || this.keyDown(KeyCode.ALT_RIGHT);
    }

    public boolean keyDown(KeyCode key) {
        return this.keyboard.isKeyPressed(key);
    }

    public boolean keyTap(KeyCode key) {
        return this.keyboard.isKeyTapped(key);
    }

    public boolean keyRelease(KeyCode key) {
        return this.keyboard.isKeyReleased(key);
    }

    public float axis(KeyCode key) {
        return this.keyboard.getAxis(key);
    }

    public boolean keyDown(KeyBinds.KeyBind key) {
        return Core.keybinds.get((KeyBinds.KeyBind)key).key != null && this.keyboard.isKeyPressed(Core.keybinds.get((KeyBinds.KeyBind)key).key);
    }

    public boolean keyTap(KeyBinds.KeyBind key) {
        return Core.keybinds.get((KeyBinds.KeyBind)key).key != null && this.keyboard.isKeyTapped(Core.keybinds.get((KeyBinds.KeyBind)key).key);
    }

    public boolean keyRelease(KeyBinds.KeyBind key) {
        return Core.keybinds.get((KeyBinds.KeyBind)key).key != null && this.keyboard.isKeyReleased(Core.keybinds.get((KeyBinds.KeyBind)key).key);
    }

    public float axis(KeyBinds.KeyBind key) {
        KeyBinds.Axis axis = Core.keybinds.get(key);
        if (axis.key != null) {
            return this.keyboard.getAxis(axis.key);
        }
        return this.keyboard.isKeyPressed(axis.min) && this.keyboard.isKeyPressed(axis.max) ? 0.0f : (this.keyboard.isKeyPressed(axis.min) ? -1.0f : (this.keyboard.isKeyPressed(axis.max) ? 1.0f : 0.0f));
    }

    public float axisTap(KeyBinds.KeyBind key) {
        KeyBinds.Axis axis = Core.keybinds.get(key);
        if (axis.key != null) {
            return this.keyboard.getAxis(axis.key);
        }
        return this.keyboard.isKeyTapped(axis.min) ? -1.0f : (this.keyboard.isKeyTapped(axis.max) ? 1.0f : 0.0f);
    }

    public void getTextInput(TextInput input) {
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public Vector3 getAccelerometer() {
        return Vector3.Zero;
    }

    public Vector3 getGyroscope() {
        return Vector3.Zero;
    }

    public Vector3 getOrientation() {
        return Vector3.Zero;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public abstract long getCurrentEventTime();

    public void setCatch(KeyCode code, boolean c) {
        if (c) {
            this.caughtKeys.add(code.ordinal());
        } else {
            this.caughtKeys.remove(code.ordinal());
        }
    }

    public boolean isCatch(KeyCode code) {
        return this.caughtKeys.contains(code.ordinal());
    }

    public void addProcessor(InputProcessor processor) {
        this.inputMultiplexer.addProcessor(processor);
    }

    public void removeProcessor(InputProcessor processor) {
        this.inputMultiplexer.removeProcessor(processor);
    }

    public Array<InputProcessor> getInputProcessors() {
        return this.inputMultiplexer.getProcessors();
    }

    public Array<InputDevice> getDevices() {
        return this.devices;
    }

    public KeyboardDevice getKeyboard() {
        return this.keyboard;
    }

    public boolean isPeripheralAvailable(Peripheral peripheral) {
        return peripheral == Peripheral.HardwareKeyboard;
    }

    public int getRotation() {
        return 0;
    }

    public Orientation getNativeOrientation() {
        return Orientation.Landscape;
    }

    public boolean isCursorCatched() {
        return false;
    }

    public void setCursorCatched(boolean catched) {
    }

    public void setCursorPosition(int x, int y) {
    }

    @Override
    public void dispose() {
        this.inputMultiplexer = new InputMultiplexer();
    }

    public static class TextInput {
        public boolean multiline = false;
        public String title = "";
        public String text = "";
        public boolean numeric;
        public Consumer<String> accepted = s -> {};
        public Runnable canceled = () -> {};
        public int maxLength = -1;
    }

    public static enum Peripheral {
        HardwareKeyboard,
        OnscreenKeyboard,
        MultitouchScreen,
        Accelerometer,
        Compass,
        Vibrator,
        Gyroscope,
        RotationVector,
        Pressure;

    }

    public static enum Orientation {
        Landscape,
        Portrait;

    }
}

