/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc;

import io.anuke.arc.Core;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.OS;
import io.anuke.arc.util.io.DefaultSerializers;
import io.anuke.arc.util.io.ReusableByteInStream;
import io.anuke.arc.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class Settings {
    protected static final byte TYPE_BOOL = 0;
    protected static final byte TYPE_INT = 1;
    protected static final byte TYPE_LONG = 2;
    protected static final byte TYPE_FLOAT = 3;
    protected static final byte TYPE_STRING = 4;
    protected static final byte TYPE_BINARY = 5;
    protected FileHandle dataDirectory;
    protected String appName;
    protected ObjectMap<String, Object> defaults = new ObjectMap();
    protected ObjectMap<String, Object> values = new ObjectMap();
    protected Consumer<Throwable> errorHandler;
    protected boolean hasErrored;
    protected ByteArrayOutputStream byteStream = new Streams.OptimizedByteArrayOutputStream(16);
    protected ReusableByteInStream byteInputStream = new ReusableByteInStream();
    protected DataOutputStream dataOutput = new DataOutputStream(this.byteStream);
    protected DataInputStream dataInput = new DataInputStream(this.byteInputStream);
    protected ObjectMap<Class<?>, TypeSerializer<?>> serializers = new ObjectMap();

    public Settings() {
        DefaultSerializers.register(this);
    }

    public TypeSerializer getSerializer(Class type) {
        if (type.isAnonymousClass()) {
            return this.serializers.get(type.getSuperclass());
        }
        return this.serializers.get(type);
    }

    public <T> void setSerializer(Class<T> type, final TypeWriter<T> writer, final TypeReader<T> reader) {
        this.serializers.put(type, new TypeSerializer<T>(){

            @Override
            public void write(DataOutput stream, T object) throws IOException {
                writer.write(stream, object);
            }

            @Override
            public T read(DataInput stream) throws IOException {
                return reader.read(stream);
            }
        });
    }

    public <T> void setSerializer(Class<?> type, TypeSerializer<T> ser) {
        this.serializers.put(type, ser);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public void setErrorHandler(Consumer<Throwable> handler) {
        this.errorHandler = handler;
    }

    public void load() {
        try {
            this.loadValues();
            Core.keybinds.load();
        }
        catch (Throwable error) {
            if (this.errorHandler != null) {
                if (!this.hasErrored) {
                    this.errorHandler.accept(error);
                }
            } else {
                throw error;
            }
            this.hasErrored = true;
        }
    }

    public void save() {
        try {
            Core.keybinds.save();
            this.saveValues();
        }
        catch (Throwable error) {
            if (this.errorHandler != null) {
                if (!this.hasErrored) {
                    this.errorHandler.accept(error);
                }
            } else {
                throw error;
            }
            this.hasErrored = true;
        }
    }

    public void loadValues() {
        if (!this.getSettingsFile().exists() && !this.getBackupSettingsFile().exists()) {
            return;
        }
        try {
            this.loadValues(this.getSettingsFile());
        }
        catch (Exception e) {
            Log.err("Failed to load base settings file, attempting to load backup.", e);
            try {
                this.loadValues(this.getBackupSettingsFile());
                this.getBackupSettingsFile().copyTo(this.getSettingsFile());
                Log.info("Loaded backup settings file.");
            }
            catch (Exception e2) {
                Log.err("Failed to load backup settings file.", e2);
            }
        }
    }

    public void loadValues(FileHandle file) throws IOException {
        try (DataInputStream stream = new DataInputStream(file.read(8192));){
            int amount = stream.readInt();
            block17: for (int i = 0; i < amount; ++i) {
                String key = stream.readUTF();
                byte type = stream.readByte();
                switch (type) {
                    case 0: {
                        this.values.put(key, stream.readBoolean());
                        continue block17;
                    }
                    case 1: {
                        this.values.put(key, stream.readInt());
                        continue block17;
                    }
                    case 2: {
                        this.values.put(key, stream.readLong());
                        continue block17;
                    }
                    case 3: {
                        this.values.put(key, Float.valueOf(stream.readFloat()));
                        continue block17;
                    }
                    case 4: {
                        this.values.put(key, stream.readUTF());
                        continue block17;
                    }
                    case 5: {
                        int length = stream.readInt();
                        byte[] bytes = new byte[length];
                        stream.read(bytes);
                        this.values.put(key, bytes);
                    }
                }
            }
        }
    }

    public void saveValues() {
        FileHandle file = this.getSettingsFile();
        try (DataOutputStream stream = new DataOutputStream(file.write(false, 8192));){
            stream.writeInt(this.values.size);
            for (ObjectMap.Entry entry : this.values.entries()) {
                stream.writeUTF((String)entry.key);
                Object value = entry.value;
                if (value instanceof Boolean) {
                    stream.writeByte(0);
                    stream.writeBoolean((Boolean)value);
                    continue;
                }
                if (value instanceof Integer) {
                    stream.writeByte(1);
                    stream.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    stream.writeByte(2);
                    stream.writeLong((Long)value);
                    continue;
                }
                if (value instanceof Float) {
                    stream.writeByte(3);
                    stream.writeFloat(((Float)value).floatValue());
                    continue;
                }
                if (value instanceof String) {
                    stream.writeByte(4);
                    stream.writeUTF((String)value);
                    continue;
                }
                if (!(value instanceof byte[])) continue;
                stream.writeByte(5);
                stream.writeInt(((byte[])value).length);
                stream.write((byte[])value);
            }
        }
        catch (Throwable e) {
            file.delete();
            throw new RuntimeException("Error writing preferences: " + file, e);
        }
        file.copyTo(this.getBackupSettingsFile());
    }

    public FileHandle getSettingsFile() {
        return this.getDataDirectory().child("settings.bin");
    }

    public FileHandle getBackupSettingsFile() {
        return this.getDataDirectory().child("settings_backup.bin");
    }

    public FileHandle getDataDirectory() {
        return this.dataDirectory == null ? Core.files.absolute(OS.getAppDataDirectoryString(this.appName)) : this.dataDirectory;
    }

    public void setDataDirectory(FileHandle file) {
        this.dataDirectory = file;
    }

    public void defaults(Object ... objects) {
        for (int i = 0; i < objects.length; i += 2) {
            this.defaults.put((String)objects[i], objects[i + 1]);
        }
    }

    public void clear() {
        this.values.clear();
    }

    public Object getDefault(String name) {
        return this.defaults.get(name);
    }

    public boolean has(String name) {
        return this.values.containsKey(name);
    }

    public void putObject(String name, Object value) {
        this.putObject(name, value, value.getClass());
    }

    public void putObject(String name, Object value, Class<?> type) {
        if (!this.serializers.containsKey(type)) {
            throw new IllegalArgumentException(type + " does not have a serializer registered!");
        }
        this.byteStream.reset();
        TypeSerializer<?> serializer = this.serializers.get(type);
        try {
            serializer.write(this.dataOutput, value);
            this.put(name, this.byteStream.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getObject(String name, Class<T> type, Supplier<T> def) {
        if (!this.serializers.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type + " does not have a serializer registered!");
        }
        TypeSerializer<?> serializer = this.serializers.get(type);
        try {
            this.byteInputStream.setBytes(this.getBytes(name));
            Object obj = serializer.read(this.dataInput);
            if (obj == null) {
                return def.get();
            }
            return (T)obj;
        }
        catch (Exception e) {
            return def.get();
        }
    }

    public float getFloat(String name, float def) {
        return ((Float)this.values.get(name, Float.valueOf(def))).floatValue();
    }

    public int getInt(String name, int def) {
        return (Integer)this.values.get(name, def);
    }

    public boolean getBool(String name, boolean def) {
        return (Boolean)this.values.get(name, def);
    }

    public byte[] getBytes(String name, byte[] def) {
        return (byte[])this.values.get(name, def);
    }

    public String getString(String name, String def) {
        return (String)this.values.get(name, def);
    }

    public float getFloat(String name) {
        return this.getFloat(name, ((Float)this.defaults.get(name, Float.valueOf(0.0f))).floatValue());
    }

    public int getInt(String name) {
        return this.getInt(name, (Integer)this.defaults.get(name, 0));
    }

    public boolean getBool(String name) {
        return this.getBool(name, (Boolean)this.defaults.get(name, false));
    }

    public void getBoolOnce(String name, Runnable run) {
        if (!this.getBool(name, false)) {
            run.run();
            this.put(name, true);
            this.save();
        }
    }

    public byte[] getBytes(String name) {
        return this.getBytes(name, this.defaults.get(name, null));
    }

    public String getString(String name) {
        return this.getString(name, this.defaults.get(name, null));
    }

    public void putAll(ObjectMap<String, Object> map) {
        for (ObjectMap.Entry entry : map.entries()) {
            this.put((String)entry.key, entry.value);
        }
    }

    public void putSave(String name, Object object) {
        this.put(name, object);
        this.save();
    }

    public void put(String name, Object object) {
        if (!(object instanceof Float || object instanceof Integer || object instanceof Boolean || object instanceof String || object instanceof byte[])) {
            throw new IllegalArgumentException("Invalid object stored: " + (object == null ? null : object.getClass()) + ". Use putObject() for serialization.");
        }
        this.values.put(name, object);
    }

    public void remove(String name) {
        this.values.remove(name);
    }

    public Iterable<String> keys() {
        return this.values.keys();
    }

    public static interface TypeReader<T> {
        public T read(DataInput var1) throws IOException;
    }

    public static interface TypeWriter<T> {
        public void write(DataOutput var1, T var2) throws IOException;
    }

    public static interface TypeSerializer<T> {
        public void write(DataOutput var1, T var2) throws IOException;

        public T read(DataInput var1) throws IOException;
    }
}

