/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.assets;

import io.anuke.arc.assets.AssetLoaderParameters;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.util.reflect.ClassReflection;

public class AssetDescriptor<T> {
    public final String fileName;
    public final Class<T> type;
    public final AssetLoaderParameters params;
    public FileHandle file;
    public Consumer<T> loaded;

    public AssetDescriptor(Class<T> assetType) {
        this(ClassReflection.getSimpleName(assetType), assetType, null);
    }

    public AssetDescriptor(String fileName, Class<T> assetType) {
        this(fileName, assetType, null);
    }

    public AssetDescriptor(FileHandle file, Class<T> assetType) {
        this(file, assetType, null);
    }

    public AssetDescriptor(String fileName, Class<T> assetType, AssetLoaderParameters<T> params) {
        this.loaded = t -> {};
        this.fileName = fileName.replaceAll("\\\\", "/");
        this.type = assetType;
        this.params = params;
    }

    public AssetDescriptor(FileHandle file, Class<T> assetType, AssetLoaderParameters<T> params) {
        this.loaded = t -> {};
        this.fileName = file.path().replaceAll("\\\\", "/");
        this.file = file;
        this.type = assetType;
        this.params = params;
    }

    public String toString() {
        return this.fileName + ", " + this.type.getName();
    }
}

