/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.assets.loaders;

import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.AssetLoaderParameters;
import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.assets.loaders.AsynchronousAssetLoader;
import io.anuke.arc.assets.loaders.FileHandleResolver;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.util.Log;

public class ShaderProgramLoader
extends AsynchronousAssetLoader<Shader, ShaderProgramParameter> {
    private String vertexFileSuffix = ".vert";
    private String fragmentFileSuffix = ".frag";

    public ShaderProgramLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public ShaderProgramLoader(FileHandleResolver resolver, String vertexFileSuffix, String fragmentFileSuffix) {
        super(resolver);
        this.vertexFileSuffix = vertexFileSuffix;
        this.fragmentFileSuffix = fragmentFileSuffix;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ShaderProgramParameter parameter) {
        return null;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, ShaderProgramParameter parameter) {
    }

    @Override
    public Shader loadSync(AssetManager manager, String fileName, FileHandle file, ShaderProgramParameter parameter) {
        String fragmentCode;
        String vertFileName = null;
        String fragFileName = null;
        if (parameter != null) {
            if (parameter.vertexFile != null) {
                vertFileName = parameter.vertexFile;
            }
            if (parameter.fragmentFile != null) {
                fragFileName = parameter.fragmentFile;
            }
        }
        if (vertFileName == null && fileName.endsWith(this.fragmentFileSuffix)) {
            vertFileName = fileName.substring(0, fileName.length() - this.fragmentFileSuffix.length()) + this.vertexFileSuffix;
        }
        if (fragFileName == null && fileName.endsWith(this.vertexFileSuffix)) {
            fragFileName = fileName.substring(0, fileName.length() - this.vertexFileSuffix.length()) + this.fragmentFileSuffix;
        }
        FileHandle vertexFile = vertFileName == null ? file : this.resolve(vertFileName);
        FileHandle fragmentFile = fragFileName == null ? file : this.resolve(fragFileName);
        String vertexCode = vertexFile.readString();
        String string = fragmentCode = vertexFile.equals(fragmentFile) ? vertexCode : fragmentFile.readString();
        if (parameter != null) {
            if (parameter.prependVertexCode != null) {
                vertexCode = parameter.prependVertexCode + vertexCode;
            }
            if (parameter.prependFragmentCode != null) {
                fragmentCode = parameter.prependFragmentCode + fragmentCode;
            }
        }
        Shader shader = new Shader(vertexCode, fragmentCode);
        if ((parameter == null || parameter.logOnCompileFailure) && !shader.isCompiled()) {
            Log.err("Shader " + fileName + " failed to compile:\n" + shader.getLog(), new Object[0]);
        }
        return shader;
    }

    public static class ShaderProgramParameter
    extends AssetLoaderParameters<Shader> {
        public String vertexFile;
        public String fragmentFile;
        public boolean logOnCompileFailure = true;
        public String prependVertexCode;
        public String prependFragmentCode;
    }
}

