/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.audio;

import io.anuke.arc.Application;
import io.anuke.arc.Core;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Position;
import io.anuke.arc.util.Disposable;

public interface Sound
extends Disposable {
    default public float calcPan(float x, float y) {
        if (Core.app.getType() == Application.ApplicationType.HeadlessDesktop) {
            return 0.0f;
        }
        return Mathf.clamp((x - Core.camera.position.x) / (Core.camera.width / 2.0f), -0.9f, 0.9f);
    }

    default public float calcVolume(float x, float y) {
        return this.calcFalloff(x, y) * (float)Core.settings.getInt("sfxvol") / 100.0f;
    }

    default public float calcFalloff(float x, float y) {
        if (Core.app.getType() == Application.ApplicationType.HeadlessDesktop) {
            return 1.0f;
        }
        float dst = Mathf.dst(x, y, Core.camera.position.x, Core.camera.position.y);
        return Mathf.clamp(1.0f / (dst * dst / Core.audio.falloff));
    }

    default public int at(float x, float y, float pitch) {
        float vol = this.calcVolume(x, y);
        if (vol < 0.01f) {
            return -1;
        }
        return this.play(vol, pitch, this.calcPan(x, y));
    }

    default public int at(float x, float y) {
        return this.at(x, y, 1.0f);
    }

    default public int at(Position pos) {
        return this.at(pos.getX(), pos.getY());
    }

    default public int at(Position pos, float pitch) {
        return this.at(pos.getX(), pos.getY(), pitch);
    }

    default public int play() {
        return this.play(1.0f * (float)Core.settings.getInt("sfxvol") / 100.0f);
    }

    default public int play(float volume) {
        return this.play(volume, 1.0f, 0.0f);
    }

    public int play(float var1, float var2, float var3);

    default public int loop() {
        return this.loop(1.0f);
    }

    default public int loop(float volume) {
        return this.loop(1.0f, 1.0f, 0.0f);
    }

    public int loop(float var1, float var2, float var3);

    public void stop();

    public void pause();

    public void resume();

    @Override
    public void dispose();

    public void stop(int var1);

    public void pause(int var1);

    public void resume(int var1);

    public void setLooping(int var1, boolean var2);

    public void setPitch(int var1, float var2);

    public void setVolume(int var1, float var2);

    public void setPan(int var1, float var2, float var3);
}

