/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl;

import io.anuke.arc.Application;
import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Audio;
import io.anuke.arc.Core;
import io.anuke.arc.Settings;
import io.anuke.arc.audio.mock.MockAudio;
import io.anuke.arc.backends.sdl.SDLError;
import io.anuke.arc.backends.sdl.SdlConfig;
import io.anuke.arc.backends.sdl.SdlFiles;
import io.anuke.arc.backends.sdl.SdlGraphics;
import io.anuke.arc.backends.sdl.SdlInput;
import io.anuke.arc.backends.sdl.SdlNet;
import io.anuke.arc.backends.sdl.audio.ALAudio;
import io.anuke.arc.backends.sdl.jni.SDL;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.IntProvider;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.util.ArcNativesLoader;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.TaskQueue;

public class SdlApplication
implements Application {
    private final Array<ApplicationListener> listeners = new Array();
    private final TaskQueue runnables = new TaskQueue();
    private final int[] inputs = new int[34];
    final SdlGraphics graphics;
    final SdlInput input;
    final SdlConfig config;
    ALAudio audio;
    boolean running = true;
    long window;
    long context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdlApplication(ApplicationListener listener, SdlConfig config) {
        this.config = config;
        this.listeners.add(listener);
        this.init();
        Core.app = this;
        Core.files = new SdlFiles();
        Core.net = new SdlNet();
        this.graphics = new SdlGraphics(this);
        Core.graphics = this.graphics;
        this.input = new SdlInput();
        Core.input = this.input;
        Core.settings = new Settings();
        try {
            Audio audio;
            if (config.disableAudio) {
                audio = new MockAudio();
            } else {
                this.audio = new ALAudio(config.audioDeviceSimultaneousSources);
                audio = this.audio;
            }
            Core.audio = audio;
        }
        catch (Throwable t) {
            Log.err(t);
            Log.err("Error initializing; disabling audio.", new Object[0]);
            Core.audio = new MockAudio();
        }
        this.initIcon();
        this.graphics.updateSize(config.width, config.height);
        try {
            this.loop();
        }
        finally {
            try {
                this.cleanup();
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        }
    }

    private void initIcon() {
        if (this.config.windowIconPaths != null && this.config.windowIconPaths.length > 0) {
            String path = this.config.windowIconPaths[0];
            try {
                Pixmap p = new Pixmap(Core.files.getFileHandle(path, this.config.windowIconFileType));
                long surface = SDL.SDL_CreateRGBSurfaceFrom(p.getPixels(), p.getWidth(), p.getHeight());
                SDL.SDL_SetWindowIcon(this.window, surface);
                SDL.SDL_FreeSurface(surface);
                p.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        ArcNativesLoader.load();
        this.check(() -> SDL.SDL_Init(16432));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_CONTEXT_MAJOR_VERSION, 2));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_CONTEXT_MINOR_VERSION, 0));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_RED_SIZE, this.config.r));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_GREEN_SIZE, this.config.g));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_BLUE_SIZE, this.config.b));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_DEPTH_SIZE, this.config.depth));
        this.check(() -> SDL.SDL_GL_SetAttribute(SDL.SDL_GL_DOUBLEBUFFER, 1));
        int flags = 2;
        if (this.config.initialVisible) {
            flags |= 4;
        }
        if (!this.config.decorated) {
            flags |= 0x10;
        }
        if (this.config.resizable) {
            flags |= 0x20;
        }
        if (this.config.maximized) {
            flags |= 0x80;
        }
        this.window = SDL.SDL_CreateWindow(this.config.title, this.config.width, this.config.height, flags);
        if (this.window == 0L) {
            throw new SDLError();
        }
        this.context = SDL.SDL_GL_CreateContext(this.window);
        if (this.context == 0L) {
            throw new SDLError();
        }
        if (this.config.vSyncEnabled) {
            SDL.SDL_GL_SetSwapInterval(1);
        }
        SDL.SDL_StartTextInput();
    }

    private void loop() {
        this.graphics.updateSize(this.config.width, this.config.height);
        this.listen(ApplicationListener::init);
        while (this.running) {
            while (SDL.SDL_PollEvent(this.inputs)) {
                if (this.inputs[0] == 0) {
                    this.running = false;
                    continue;
                }
                if (this.inputs[0] == 1) {
                    int type = this.inputs[1];
                    if (type == SDL.SDL_WINDOWEVENT_SIZE_CHANGED) {
                        this.graphics.updateSize(this.inputs[2], this.inputs[3]);
                        this.listen(l -> l.resize(this.inputs[2], this.inputs[3]));
                        continue;
                    }
                    if (type == SDL.SDL_WINDOWEVENT_SHOWN) {
                        this.listen(ApplicationListener::resume);
                        continue;
                    }
                    if (type != SDL.SDL_WINDOWEVENT_HIDDEN) continue;
                    this.listen(ApplicationListener::pause);
                    continue;
                }
                if (this.inputs[0] != 2 && this.inputs[0] != 3 && this.inputs[0] != 4 && this.inputs[0] != 5 && this.inputs[0] != 6) continue;
                this.input.handleInput(this.inputs);
            }
            this.graphics.update();
            this.input.update();
            if (this.audio != null) {
                this.audio.update();
            }
            this.listen(ApplicationListener::update);
            this.runnables.run();
            SDL.SDL_GL_SwapWindow(this.window);
            this.input.prepareNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(Consumer<ApplicationListener> cons) {
        Array<ApplicationListener> array = this.listeners;
        synchronized (array) {
            for (ApplicationListener l : this.listeners) {
                cons.accept(l);
            }
        }
    }

    private void cleanup() {
        this.listen(l -> {
            l.pause();
            try {
                l.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        this.dispose();
        Core.audio.dispose();
        SDL.SDL_DestroyWindow(this.window);
        SDL.SDL_Quit();
    }

    private void check(IntProvider run) {
        if (run.get() != 0) {
            throw new SDLError();
        }
    }

    @Override
    public Array<ApplicationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public String getClipboardText() {
        return SDL.SDL_GetClipboardText();
    }

    @Override
    public void setClipboardText(String text) {
        SDL.SDL_SetClipboardText(text);
    }

    @Override
    public void post(Runnable runnable) {
        this.runnables.post(runnable);
    }

    @Override
    public void exit() {
        this.running = false;
    }
}

