/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl;

import io.anuke.arc.Files;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.ArcRuntimeException;
import java.io.File;

public final class SdlFiles
implements Files {
    public static final String externalPath = System.getProperty("user.home") + File.separator;
    public static final String localPath = new File("").getAbsolutePath() + File.separator;

    @Override
    public FileHandle getFileHandle(String fileName, Files.FileType type) {
        return new SdlFileHandle(fileName, type);
    }

    @Override
    public FileHandle classpath(String path) {
        return new SdlFileHandle(path, Files.FileType.Classpath);
    }

    @Override
    public FileHandle internal(String path) {
        return new SdlFileHandle(path, Files.FileType.Internal);
    }

    @Override
    public FileHandle external(String path) {
        return new SdlFileHandle(path, Files.FileType.External);
    }

    @Override
    public FileHandle absolute(String path) {
        return new SdlFileHandle(path, Files.FileType.Absolute);
    }

    @Override
    public FileHandle local(String path) {
        return new SdlFileHandle(path, Files.FileType.Local);
    }

    @Override
    public String getExternalStoragePath() {
        return externalPath;
    }

    @Override
    public boolean isExternalStorageAvailable() {
        return true;
    }

    @Override
    public String getLocalStoragePath() {
        return localPath;
    }

    @Override
    public boolean isLocalStorageAvailable() {
        return true;
    }

    public static final class SdlFileHandle
    extends FileHandle {
        public SdlFileHandle(String fileName, Files.FileType type) {
            super(fileName, type);
        }

        public SdlFileHandle(File file, Files.FileType type) {
            super(file, type);
        }

        @Override
        public FileHandle child(String name) {
            if (this.file.getPath().length() == 0) {
                return new SdlFileHandle(new File(name), this.type);
            }
            return new SdlFileHandle(new File(this.file, name), this.type);
        }

        @Override
        public FileHandle sibling(String name) {
            if (this.file.getPath().length() == 0) {
                throw new ArcRuntimeException("Cannot get the sibling of the root.");
            }
            return new SdlFileHandle(new File(this.file.getParent(), name), this.type);
        }

        @Override
        public File file() {
            if (this.type == Files.FileType.External) {
                return new File(externalPath, this.file.getPath());
            }
            if (this.type == Files.FileType.Local) {
                return new File(localPath, this.file.getPath());
            }
            return this.file;
        }
    }
}

