/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl;

import io.anuke.arc.Core;
import io.anuke.arc.Input;
import io.anuke.arc.backends.sdl.SdlKeymap;
import io.anuke.arc.input.InputDevice;
import io.anuke.arc.input.InputEventQueue;
import io.anuke.arc.input.KeyCode;
import java.nio.charset.Charset;

public class SdlInput
extends Input {
    private final InputEventQueue queue = new InputEventQueue();
    private int mouseX;
    private int mouseY;
    private int deltaX;
    private int deltaY;
    private int mousePressed;
    private Charset charset = Charset.forName("UTF-8");
    private byte[] strcpy = new byte[32];

    void handleInput(int[] input) {
        int type = input[0];
        if (type == 5) {
            boolean down = input[1] == 1;
            int keycode = input[2];
            KeyCode key = SdlKeymap.getCode(keycode);
            if (input[3] == 0) {
                if (down) {
                    this.queue.keyDown(key);
                } else {
                    this.queue.keyUp(key);
                }
            }
            if (key == KeyCode.BACKSPACE && down) {
                this.queue.keyTyped('\b');
            }
            if (key == KeyCode.ENTER && down) {
                this.queue.keyTyped('\r');
            }
            if (key == KeyCode.FORWARD_DEL && down) {
                this.queue.keyTyped('\u007f');
            }
        } else if (type == 3) {
            KeyCode key;
            boolean down = input[1] == 1;
            int keycode = input[4];
            int x = input[2];
            int y = Core.graphics.getHeight() - input[3];
            KeyCode keyCode = keycode == 1 ? KeyCode.MOUSE_LEFT : (keycode == 3 ? KeyCode.MOUSE_RIGHT : (key = keycode == 2 ? KeyCode.MOUSE_MIDDLE : null));
            if (key != null) {
                if (down) {
                    ++this.mousePressed;
                    this.queue.keyDown(key);
                    this.queue.touchDown(x, y, 0, key);
                } else {
                    this.mousePressed = Math.max(0, this.mousePressed - 1);
                    this.queue.keyUp(key);
                    this.queue.touchUp(x, y, 0, key);
                }
            }
        } else if (type == 2) {
            int x = input[1];
            int y = Core.graphics.getHeight() - input[2];
            this.deltaX = x - this.mouseX;
            this.deltaY = y - this.mouseY;
            this.mouseX = x;
            this.mouseY = y;
            if (this.mousePressed > 0) {
                this.queue.touchDragged(this.mouseX, this.mouseY, 0);
            } else {
                this.queue.mouseMoved(this.mouseX, this.mouseY);
            }
        } else if (type == 4) {
            int sx = input[1];
            int sy = input[2];
            this.queue.scrolled(-sx, -sy);
        } else if (type == 6) {
            int i;
            int length = 0;
            for (i = 0; i < 32; ++i) {
                char c = (char)input[i + 1];
                if (c != '\u0000') continue;
                length = i;
                break;
            }
            for (i = 0; i < length; ++i) {
                this.strcpy[i] = (byte)input[i + 1];
            }
            String s = new String(this.strcpy, 0, length, this.charset);
            for (int i2 = 0; i2 < s.length(); ++i2) {
                this.queue.keyTyped(s.charAt(i2));
            }
        }
    }

    void update() {
        this.queue.setProcessor(this.inputMultiplexer);
        this.queue.drain();
    }

    void prepareNext() {
        for (InputDevice device : this.devices) {
            device.update();
        }
    }

    @Override
    public int mouseX() {
        return this.mouseX;
    }

    @Override
    public int mouseX(int pointer) {
        return pointer == 0 ? this.mouseX : 0;
    }

    @Override
    public int deltaX() {
        return this.deltaX;
    }

    @Override
    public int deltaX(int pointer) {
        return pointer == 0 ? this.deltaX : 0;
    }

    @Override
    public int mouseY() {
        return this.mouseY;
    }

    @Override
    public int mouseY(int pointer) {
        return pointer == 0 ? this.mouseY : 0;
    }

    @Override
    public int deltaY() {
        return this.deltaY;
    }

    @Override
    public int deltaY(int pointer) {
        return pointer == 0 ? this.deltaY : 0;
    }

    @Override
    public boolean isTouched() {
        return this.keyDown(KeyCode.MOUSE_LEFT) || this.keyDown(KeyCode.MOUSE_RIGHT);
    }

    @Override
    public boolean justTouched() {
        return this.keyTap(KeyCode.MOUSE_LEFT) || this.keyTap(KeyCode.MOUSE_RIGHT);
    }

    @Override
    public boolean isTouched(int pointer) {
        return false;
    }

    @Override
    public long getCurrentEventTime() {
        return this.queue.getCurrentEventTime();
    }
}

