/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl.audio;

import io.anuke.arc.backends.sdl.audio.ALAudio;
import io.anuke.arc.backends.sdl.audio.ALMusic;
import io.anuke.arc.backends.sdl.audio.ALSound;
import io.anuke.arc.backends.sdl.audio.OggInputStream;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.io.Streams;
import java.io.ByteArrayOutputStream;

public class Ogg {

    public static class Sound
    extends ALSound {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Sound(ALAudio audio, FileHandle file) {
            super(audio);
            if (audio.noDevice) {
                return;
            }
            OggInputStream input = null;
            try {
                int length;
                input = new OggInputStream(file.read());
                ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[2048];
                while (!input.atEnd() && (length = input.read(buffer)) != -1) {
                    output.write(buffer, 0, length);
                }
                this.setup(output.toByteArray(), input.getChannels(), input.getSampleRate());
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(input);
                throw throwable;
            }
            Streams.closeQuietly(input);
        }
    }

    public static class Music
    extends ALMusic {
        private OggInputStream input;
        private OggInputStream previousInput;

        public Music(ALAudio audio, FileHandle file) {
            super(audio, file);
            if (audio.noDevice) {
                return;
            }
            this.input = new OggInputStream(file.read());
            this.setup(this.input.getChannels(), this.input.getSampleRate());
        }

        @Override
        public int read(byte[] buffer) {
            if (this.input == null) {
                this.input = new OggInputStream(this.file.read(), this.previousInput);
                this.setup(this.input.getChannels(), this.input.getSampleRate());
                this.previousInput = null;
            }
            return this.input.read(buffer);
        }

        @Override
        public void reset() {
            Streams.closeQuietly(this.input);
            this.previousInput = null;
            this.input = null;
        }

        @Override
        protected void loop() {
            Streams.closeQuietly(this.input);
            this.previousInput = this.input;
            this.input = null;
        }
    }
}

