/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl.jni;

import io.anuke.arc.util.OS;
import io.anuke.arc.util.SharedLibraryLoader;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class SDL {
    public static final int SDL_INIT_TIMER = 1;
    public static final int SDL_INIT_AUDIO = 16;
    public static final int SDL_INIT_VIDEO = 32;
    public static final int SDL_INIT_JOYSTICK = 512;
    public static final int SDL_INIT_HAPTIC = 4096;
    public static final int SDL_INIT_GAMECONTROLLER = 8192;
    public static final int SDL_INIT_EVENTS = 16384;
    public static final int SDL_INIT_NOPARACHUTE = 0x100000;
    public static final int SDL_INIT_EVERYTHING = 29233;
    public static final int SDL_WINDOW_FULLSCREEN = 1;
    public static final int SDL_WINDOW_OPENGL = 2;
    public static final int SDL_WINDOW_SHOWN = 4;
    public static final int SDL_WINDOW_HIDDEN = 8;
    public static final int SDL_WINDOW_BORDERLESS = 16;
    public static final int SDL_WINDOW_RESIZABLE = 32;
    public static final int SDL_WINDOW_MINIMIZED = 64;
    public static final int SDL_WINDOW_MAXIMIZED = 128;
    public static final int SDL_WINDOW_INPUT_GRABBED = 256;
    public static final int SDL_WINDOW_INPUT_FOCUS = 512;
    public static final int SDL_WINDOW_MOUSE_FOCUS = 1024;
    public static final int SDL_WINDOW_FULLSCREEN_DESKTOP = 4097;
    public static final int SDL_WINDOW_FOREIGN = 2048;
    public static final int SDL_WINDOW_ALLOW_HIGHDPI = 8192;
    public static final int SDL_WINDOW_MOUSE_CAPTURE = 16384;
    public static final int SDL_WINDOWEVENT_SHOWN;
    public static final int SDL_WINDOWEVENT_HIDDEN;
    public static final int SDL_WINDOWEVENT_RESIZED;
    public static final int SDL_WINDOWEVENT_SIZE_CHANGED;
    public static final int SDL_WINDOWEVENT_MINIMIZED;
    public static final int SDL_WINDOWEVENT_MAXIMIZED;
    public static final int SDL_WINDOWEVENT_RESTORED;
    public static final int SDL_SYSTEM_CURSOR_ARROW;
    public static final int SDL_SYSTEM_CURSOR_IBEAM;
    public static final int SDL_SYSTEM_CURSOR_WAIT;
    public static final int SDL_SYSTEM_CURSOR_CROSSHAIR;
    public static final int SDL_SYSTEM_CURSOR_WAITARROW;
    public static final int SDL_SYSTEM_CURSOR_SIZEALL;
    public static final int SDL_SYSTEM_CURSOR_NO;
    public static final int SDL_SYSTEM_CURSOR_SIZENS;
    public static final int SDL_SYSTEM_CURSOR_SIZEWE;
    public static final int SDL_SYSTEM_CURSOR_HAND;
    public static final int SDL_MESSAGEBOX_ERROR = 16;
    public static final int SDL_MESSAGEBOX_WARNING = 32;
    public static final int SDL_MESSAGEBOX_INFORMATION = 64;
    public static final int SDL_BUTTON_LEFT = 1;
    public static final int SDL_BUTTON_MIDDLE = 2;
    public static final int SDL_BUTTON_RIGHT = 3;
    public static final int SDL_EVENT_QUIT = 0;
    public static final int SDL_EVENT_WINDOW = 1;
    public static final int SDL_EVENT_MOUSE_MOTION = 2;
    public static final int SDL_EVENT_MOUSE_BUTTON = 3;
    public static final int SDL_EVENT_MOUSE_WHEEL = 4;
    public static final int SDL_EVENT_KEYBOARD = 5;
    public static final int SDL_EVENT_TEXT_INPUT = 6;
    public static final int SDL_EVENT_OTHER = 7;
    public static final int SDL_GL_RED_SIZE;
    public static final int SDL_GL_GREEN_SIZE;
    public static final int SDL_GL_BLUE_SIZE;
    public static final int SDL_GL_DEPTH_SIZE;
    public static final int SDL_GL_DOUBLEBUFFER;
    public static final int SDL_GL_CONTEXT_MAJOR_VERSION;
    public static final int SDL_GL_CONTEXT_MINOR_VERSION;

    public static native int SDL_Init(int var0);

    public static native int SDL_InitSubSystem(int var0);

    public static native void SDL_QuitSubSystem(int var0);

    public static native int SDL_WasInit(int var0);

    public static native void SDL_Quit();

    public static native boolean SDL_SetHint(String var0, String var1);

    public static native String SDL_GetError();

    public static native int SDL_SetClipboardText(String var0);

    public static native String SDL_GetClipboardText();

    private static native int SDL_WINDOWEVENT_SHOWN();

    private static native int SDL_WINDOWEVENT_HIDDEN();

    private static native int SDL_WINDOWEVENT_RESIZED();

    private static native int SDL_WINDOWEVENT_SIZE_CHANGED();

    private static native int SDL_WINDOWEVENT_MINIMIZED();

    private static native int SDL_WINDOWEVENT_MAXIMIZED();

    private static native int SDL_WINDOWEVENT_RESTORED();

    private static native int SDL_SYSTEM_CURSOR_ARROW();

    private static native int SDL_SYSTEM_CURSOR_IBEAM();

    private static native int SDL_SYSTEM_CURSOR_WAIT();

    private static native int SDL_SYSTEM_CURSOR_CROSSHAIR();

    private static native int SDL_SYSTEM_CURSOR_WAITARROW();

    private static native int SDL_SYSTEM_CURSOR_SIZEALL();

    private static native int SDL_SYSTEM_CURSOR_NO();

    private static native int SDL_SYSTEM_CURSOR_SIZENS();

    private static native int SDL_SYSTEM_CURSOR_SIZEWE();

    private static native int SDL_SYSTEM_CURSOR_HAND();

    public static native long SDL_CreateWindow(String var0, int var1, int var2, int var3);

    public static native void SDL_DestroyWindow(long var0);

    public static native void SDL_SetWindowIcon(long var0, long var2);

    public static native void SDL_RestoreWindow(long var0);

    public static native void SDL_MaximizeWindow(long var0);

    public static native void SDL_MinimizeWindow(long var0);

    public static native int SDL_SetWindowFullscreen(long var0, int var2);

    public static native void SDL_SetWindowBordered(long var0, boolean var2);

    public static native void SDL_SetWindowSize(long var0, int var2, int var3);

    public static native int SDL_GetWindowFlags(long var0);

    public static native void SDL_SetWindowTitle(long var0, String var2);

    public static native long SDL_CreateRGBSurfaceFrom(ByteBuffer var0, int var1, int var2);

    public static native long SDL_CreateColorCursor(long var0, int var2, int var3);

    public static native long SDL_CreateSystemCursor(int var0);

    public static native void SDL_SetCursor(long var0);

    public static native void SDL_FreeCursor(long var0);

    public static native void SDL_FreeSurface(long var0);

    public static native int SDL_ShowSimpleMessageBox(int var0, String var1, String var2);

    public static native void SDL_StartTextInput();

    public static native void SDL_StopTextInput();

    public static native boolean SDL_PollEvent(int[] var0);

    private static native int SDL_GL_RED_SIZE();

    private static native int SDL_GL_GREEN_SIZE();

    private static native int SDL_GL_BLUE_SIZE();

    private static native int SDL_GL_DEPTH_SIZE();

    private static native int SDL_GL_DOUBLEBUFFER();

    private static native int SDL_GL_CONTEXT_MAJOR_VERSION();

    private static native int SDL_GL_CONTEXT_MINOR_VERSION();

    public static native int SDL_GL_SetAttribute(int var0, int var1);

    public static native boolean SDL_GL_ExtensionSupported(String var0);

    public static native long SDL_GL_CreateContext(long var0);

    public static native int SDL_GL_SetSwapInterval(int var0);

    public static native void SDL_GL_SwapWindow(long var0);

    static {
        if (OS.isWindows) {
            new SharedLibraryLoader(){

                @Override
                public String mapLibraryName(String libraryName) {
                    return libraryName + ".dll";
                }

                @Override
                protected InputStream readFile(String path) {
                    return super.readFile(OS.is64Bit ? "OpenAL.dll" : "OpenAL32.dll");
                }
            }.load("OpenAL32");
        } else if (OS.isLinux) {
            new SharedLibraryLoader(){

                @Override
                public String mapLibraryName(String libraryName) {
                    return "lib" + libraryName + ".so";
                }
            }.load("openal");
        }
        new SharedLibraryLoader().load("sdl-arc");
        SDL_WINDOWEVENT_SHOWN = SDL.SDL_WINDOWEVENT_SHOWN();
        SDL_WINDOWEVENT_HIDDEN = SDL.SDL_WINDOWEVENT_HIDDEN();
        SDL_WINDOWEVENT_RESIZED = SDL.SDL_WINDOWEVENT_RESIZED();
        SDL_WINDOWEVENT_SIZE_CHANGED = SDL.SDL_WINDOWEVENT_SIZE_CHANGED();
        SDL_WINDOWEVENT_MINIMIZED = SDL.SDL_WINDOWEVENT_MINIMIZED();
        SDL_WINDOWEVENT_MAXIMIZED = SDL.SDL_WINDOWEVENT_MAXIMIZED();
        SDL_WINDOWEVENT_RESTORED = SDL.SDL_WINDOWEVENT_RESTORED();
        SDL_SYSTEM_CURSOR_ARROW = SDL.SDL_SYSTEM_CURSOR_ARROW();
        SDL_SYSTEM_CURSOR_IBEAM = SDL.SDL_SYSTEM_CURSOR_IBEAM();
        SDL_SYSTEM_CURSOR_WAIT = SDL.SDL_SYSTEM_CURSOR_WAIT();
        SDL_SYSTEM_CURSOR_CROSSHAIR = SDL.SDL_SYSTEM_CURSOR_CROSSHAIR();
        SDL_SYSTEM_CURSOR_WAITARROW = SDL.SDL_SYSTEM_CURSOR_WAITARROW();
        SDL_SYSTEM_CURSOR_SIZEALL = SDL.SDL_SYSTEM_CURSOR_SIZEALL();
        SDL_SYSTEM_CURSOR_NO = SDL.SDL_SYSTEM_CURSOR_NO();
        SDL_SYSTEM_CURSOR_SIZENS = SDL.SDL_SYSTEM_CURSOR_SIZENS();
        SDL_SYSTEM_CURSOR_SIZEWE = SDL.SDL_SYSTEM_CURSOR_SIZEWE();
        SDL_SYSTEM_CURSOR_HAND = SDL.SDL_SYSTEM_CURSOR_HAND();
        SDL_GL_RED_SIZE = SDL.SDL_GL_RED_SIZE();
        SDL_GL_GREEN_SIZE = SDL.SDL_GL_GREEN_SIZE();
        SDL_GL_BLUE_SIZE = SDL.SDL_GL_BLUE_SIZE();
        SDL_GL_DEPTH_SIZE = SDL.SDL_GL_DEPTH_SIZE();
        SDL_GL_DOUBLEBUFFER = SDL.SDL_GL_DOUBLEBUFFER();
        SDL_GL_CONTEXT_MAJOR_VERSION = SDL.SDL_GL_CONTEXT_MAJOR_VERSION();
        SDL_GL_CONTEXT_MINOR_VERSION = SDL.SDL_GL_CONTEXT_MINOR_VERSION();
    }
}

