/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.collection;

import io.anuke.arc.collection.IntArray;
import io.anuke.arc.collection.Sort;
import io.anuke.arc.function.BiFunction;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.FloatFunction;
import io.anuke.arc.function.Function;
import io.anuke.arc.function.IntFunction;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.ArcRuntimeException;
import io.anuke.arc.util.Select;
import io.anuke.arc.util.reflect.ArrayReflection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Array<T>
implements Iterable<T> {
    public static int iteratorsAllocated = 0;
    public T[] items;
    public int size;
    public boolean ordered;
    private ArrayIterable iterable;

    public Array() {
        this(true, 16);
    }

    public Array(int capacity) {
        this(true, capacity);
    }

    public Array(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new Object[capacity];
    }

    public Array(boolean ordered, int capacity, Class arrayType) {
        this.ordered = ordered;
        this.items = (Object[])ArrayReflection.newInstance(arrayType, capacity);
    }

    public Array(Class arrayType) {
        this(true, 16, arrayType);
    }

    public Array(Array<? extends T> array) {
        this(array.ordered, array.size, array.items.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public Array(T[] array) {
        this(true, array, 0, array.length);
    }

    public Array(boolean ordered, T[] array, int start, int count) {
        this(ordered, count, array.getClass().getComponentType());
        this.size = count;
        System.arraycopy(array, start, this.items, 0, this.size);
    }

    public static <T> Array<T> of(Class<T> arrayType) {
        return new Array<T>(arrayType);
    }

    public static <T> Array<T> of(boolean ordered, int capacity, Class<T> arrayType) {
        return new Array<T>(ordered, capacity, arrayType);
    }

    public static <T> Array<T> withArrays(Object ... arrays) {
        Array<Object> result = new Array<Object>();
        for (Object a : arrays) {
            if (a instanceof Array) {
                result.addAll((Array)a);
                continue;
            }
            result.add(a);
        }
        return result;
    }

    public static <T> Array<T> with(T ... array) {
        return new Array<T>(array);
    }

    public static <T> Array<T> with(Iterable<T> array) {
        Array<T> out = new Array<T>();
        for (T thing : array) {
            out.add(thing);
        }
        return out;
    }

    public static <T> Array<T> select(T[] array, Predicate<T> test) {
        Array<T> out = new Array<T>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (!test.test(array[i])) continue;
            out.add(array[i]);
        }
        return out;
    }

    public Array<T> copy() {
        return new Array<T>(this);
    }

    public float sumf(FloatFunction<T> summer) {
        float sum = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            sum += summer.get(this.items[i]);
        }
        return sum;
    }

    public int sum(IntFunction<T> summer) {
        int sum = 0;
        for (int i = 0; i < this.size; ++i) {
            sum += summer.get(this.items[i]);
        }
        return sum;
    }

    public <E extends T> void each(Predicate<? super T> pred, Consumer<E> consumer) {
        for (int i = 0; i < this.size; ++i) {
            if (!pred.test(this.items[i])) continue;
            consumer.accept(this.items[i]);
        }
    }

    public void each(Consumer<? super T> consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.items[i]);
        }
    }

    public void replace(Function<T, T> mapper) {
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = mapper.get(this.items[i]);
        }
    }

    public <R> Array<R> flatten() {
        Array<T> arr = new Array<T>();
        for (int i = 0; i < this.size; ++i) {
            arr.addAll((Array)this.items[i]);
        }
        return arr;
    }

    public <R> Array<R> map(Function<T, R> mapper) {
        Array<R> arr = new Array<R>(this.size);
        for (int i = 0; i < this.size; ++i) {
            arr.add(mapper.get(this.items[i]));
        }
        return arr;
    }

    public IntArray mapInt(IntFunction<T> mapper) {
        IntArray arr = new IntArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            arr.add(mapper.get(this.items[i]));
        }
        return arr;
    }

    public <R> R reduce(R initial, BiFunction<T, R, R> reducer) {
        R result = initial;
        for (int i = 0; i < this.size; ++i) {
            result = reducer.get(this.items[i], result);
        }
        return result;
    }

    public boolean contains(Predicate<T> predicate) {
        return this.find(predicate) != null;
    }

    public T min(FloatFunction<T> func) {
        T result = null;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < this.size; ++i) {
            T t = this.items[i];
            float val = func.get(t);
            if (!(val <= min)) continue;
            result = t;
            min = val;
        }
        return result;
    }

    public T max(FloatFunction<T> func) {
        T result = null;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size; ++i) {
            T t = this.items[i];
            float val = func.get(t);
            if (!(val >= max)) continue;
            result = t;
            max = val;
        }
        return result;
    }

    public T find(Predicate<T> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.items[i])) continue;
            return this.items[i];
        }
        return null;
    }

    public void add(T value) {
        T[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
    }

    public void add(T value1, T value2) {
        T[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(T value1, T value2, T value3) {
        T[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(T value1, T value2, T value3, T value4) {
        T[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int start, int count) {
        if (start + count > array.size) {
            throw new IllegalArgumentException("start + count must be <= size: " + start + " + " + count + " <= " + array.size);
        }
        this.addAll(array.items, start, count);
    }

    public void addAll(T ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(T[] array, int start, int count) {
        int sizeNeeded = this.size + count;
        T[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(8, (int)((float)sizeNeeded * 1.75f)));
        }
        System.arraycopy(array, start, items, this.size, count);
        this.size += count;
    }

    public void addAll(Iterable<? extends T> items) {
        for (T t : items) {
            this.add(t);
        }
    }

    public void set(Array<? extends T> array) {
        this.clear();
        this.addAll(array);
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void insert(int index, T value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        T[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items, index, items, index + 1, this.size - index);
        } else {
            items[this.size] = items[index];
        }
        ++this.size;
        items[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        T[] items = this.items;
        T firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    public boolean contains(T value) {
        return this.contains(value, false);
    }

    public boolean contains(T value, boolean identity) {
        T[] items = this.items;
        int i = this.size - 1;
        if (identity || value == null) {
            while (i >= 0) {
                if (items[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!value.equals(items[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOf(T value) {
        return this.indexOf(value, false);
    }

    public int indexOf(T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items[i] != value) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (items[i] != value) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!value.equals(items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean remove(T value) {
        return this.removeValue(value, false);
    }

    public boolean remove(Predicate<T> value) {
        for (int i = 0; i < this.size; ++i) {
            if (!value.test(this.items[i])) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeValue(T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items[i] != value) continue;
                this.remove(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items[i])) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    public T remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] items = this.items;
        T value = items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items, index + 1, items, index, this.size - index);
        } else {
            items[index] = items[this.size];
        }
        items[this.size] = null;
        return value;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        T[] items = this.items;
        int count = end - start + 1;
        if (this.ordered) {
            System.arraycopy(items, start + count, items, start, this.size - (start + count));
        } else {
            int lastIndex = this.size - 1;
            for (int i = 0; i < count; ++i) {
                items[start + i] = items[lastIndex - i];
            }
        }
        this.size -= count;
    }

    public Array<T> removeAll(Predicate<T> pred) {
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            if (!pred.test(iter.next())) continue;
            iter.remove();
        }
        return this;
    }

    public boolean removeAll(Array<? extends T> array) {
        return this.removeAll(array, false);
    }

    public boolean removeAll(Array<? extends T> array, boolean identity) {
        int size;
        int startSize = size = this.size;
        T[] items = this.items;
        if (identity) {
            int n = array.size;
            block0: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                for (int ii = 0; ii < size; ++ii) {
                    if (item != items[ii]) continue;
                    this.remove(ii);
                    --size;
                    continue block0;
                }
            }
        } else {
            int n = array.size;
            block2: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                for (int ii = 0; ii < size; ++ii) {
                    if (!item.equals(items[ii])) continue;
                    this.remove(ii);
                    --size;
                    continue block2;
                }
            }
        }
        return size != startSize;
    }

    public T pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        --this.size;
        T item = this.items[this.size];
        this.items[this.size] = null;
        return item;
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public T first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        T[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            items[i] = null;
        }
        this.size = 0;
    }

    public T[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public T[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(8, sizeNeeded));
        }
        return this.items;
    }

    public T[] setSize(int newSize) {
        this.truncate(newSize);
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected T[] resize(int newSize) {
        T[] items = this.items;
        Object[] newItems = (Object[])ArrayReflection.newInstance(items.getClass().getComponentType(), newSize);
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Sort.instance().sort(this.items, 0, this.size);
    }

    public void sort(Comparator<? super T> comparator) {
        Sort.instance().sort(this.items, comparator, 0, this.size);
    }

    public Array<T> selectFrom(Array<T> base, Predicate<T> predicate) {
        this.clear();
        base.each(t -> {
            if (predicate.test(t)) {
                this.add(t);
            }
        });
        return this;
    }

    public Array<T> select(Predicate<T> predicate) {
        Array<T> arr = new Array<T>();
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.items[i])) continue;
            arr.add(this.items[i]);
        }
        return arr;
    }

    public int count(Predicate<T> predicate) {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.items[i])) continue;
            ++count;
        }
        return count;
    }

    public T selectRanked(Comparator<T> comparator, int kthLowest) {
        if (kthLowest < 1) {
            throw new ArcRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().select(this.items, comparator, kthLowest, this.size);
    }

    public int selectRankedIndex(Comparator<T> comparator, int kthLowest) {
        if (kthLowest < 1) {
            throw new ArcRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().selectIndex(this.items, comparator, kthLowest, this.size);
    }

    public void reverse() {
        T[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void shuffle() {
        T[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int ii = Mathf.random(i);
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (this.size <= newSize) {
            return;
        }
        for (int i = newSize; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = newSize;
    }

    public T random() {
        if (this.size == 0) {
            return null;
        }
        return this.items[Mathf.random(0, this.size - 1)];
    }

    public T random(T exclude) {
        if (exclude == null) {
            return this.random();
        }
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return this.first();
        }
        int eidx = this.indexOf(exclude);
        if (eidx == -1) {
            return this.random();
        }
        int index = Mathf.random(0, this.size - 2);
        if (index >= eidx) {
            ++index;
        }
        return this.items[index];
    }

    public T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    public <V> V[] toArray(Class type) {
        Object[] result = (Object[])ArrayReflection.newInstance(type, this.size);
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h *= 31;
            T item = items[i];
            if (item == null) continue;
            h += item.hashCode();
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof Array)) {
            return false;
        }
        Array array = (Array)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            T o1 = items1[i];
            T o2 = items2[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator, Function<T, String> stringifier) {
        if (this.size == 0) {
            return "";
        }
        T[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(stringifier.get(items[0]));
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(stringifier.get(items[i]));
        }
        return buffer.toString();
    }

    public String toString(String separator) {
        return this.toString(separator, String::valueOf);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iterable == null) {
            this.iterable = new ArrayIterable(this);
        }
        return this.iterable.iterator();
    }

    public static class ArrayIterable<T>
    implements Iterable<T> {
        private final Array<T> array;
        private final boolean allowRemove;
        private ArrayIterator iterator1 = new ArrayIterator();
        private ArrayIterator iterator2 = new ArrayIterator();

        public ArrayIterable(Array<T> array) {
            this(array, true);
        }

        public ArrayIterable(Array<T> array, boolean allowRemove) {
            this.array = array;
            this.allowRemove = allowRemove;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterator1.done) {
                this.iterator1.index = 0;
                this.iterator1.done = false;
                return this.iterator1;
            }
            if (this.iterator2.done) {
                this.iterator2.index = 0;
                this.iterator2.done = false;
                return this.iterator2;
            }
            return new ArrayIterator();
        }

        private class ArrayIterator
        implements Iterator<T> {
            int index;
            boolean done = true;

            private ArrayIterator() {
                ++iteratorsAllocated;
            }

            @Override
            public boolean hasNext() {
                if (this.index >= ((ArrayIterable)ArrayIterable.this).array.size) {
                    this.done = true;
                }
                return this.index < ((ArrayIterable)ArrayIterable.this).array.size;
            }

            @Override
            public T next() {
                if (this.index >= ((ArrayIterable)ArrayIterable.this).array.size) {
                    throw new NoSuchElementException(String.valueOf(this.index));
                }
                return ((ArrayIterable)ArrayIterable.this).array.items[this.index++];
            }

            @Override
            public void remove() {
                if (!ArrayIterable.this.allowRemove) {
                    throw new ArcRuntimeException("Remove not allowed.");
                }
                --this.index;
                ArrayIterable.this.array.remove(this.index);
            }
        }
    }
}

