/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.collection;

import io.anuke.arc.collection.LongMap;

public class GridMap<T> {
    protected LongMap<T> map = new LongMap();

    private static long getHash(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    public T get(int x, int y) {
        return this.map.get(GridMap.getHash(x, y));
    }

    public T get(int x, int y, T defaultValue) {
        long hash = GridMap.getHash(x, y);
        if (!this.map.containsKey(hash)) {
            return defaultValue;
        }
        return this.map.get(hash);
    }

    public boolean containsKey(int x, int y) {
        return this.map.containsKey(GridMap.getHash(x, y));
    }

    public void put(int x, int y, T t) {
        this.map.put(GridMap.getHash(x, y), t);
    }

    public void remove(int x, int y) {
        this.map.remove(GridMap.getHash(x, y));
    }

    public LongMap.Values<T> values() {
        return this.map.values();
    }

    public LongMap.Keys keys() {
        return this.map.keys();
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size;
    }
}

