/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.files;

import io.anuke.arc.Files;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.util.ArcRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileHandle
extends FileHandle {
    private ZipFileHandle[] children = new ZipFileHandle[0];
    private ZipFileHandle parent;
    private final ZipEntry entry;
    private final ZipFile zip;

    public ZipFileHandle(FileHandle zipFileLoc) {
        super(new File(""), Files.FileType.Absolute);
        this.zip = null;
        this.entry = null;
        try {
            ZipFile zip = new ZipFile(zipFileLoc.file());
            Array<ZipFileHandle> handles = Array.with(Collections.list(zip.entries()).toArray(new ZipEntry[0])).map((T entry) -> new ZipFileHandle((ZipEntry)entry, zip));
            handles.add(this);
            handles.each(f -> f.init(handles));
            this.parent = null;
            handles.each(f -> {
                f.children = (ZipFileHandle[])handles.select(z -> z.parent == f).toArray(ZipFileHandle.class);
            });
        }
        catch (IOException e) {
            throw new ArcRuntimeException(e);
        }
    }

    private ZipFileHandle(ZipEntry entry, ZipFile file) {
        super(new File(entry.getName()), Files.FileType.Absolute);
        this.entry = entry;
        this.zip = file;
    }

    private void init(Array<ZipFileHandle> files) {
        this.parent = files.find(other -> other.isDirectory() && other != this && this.path().startsWith(other.path()) && !this.path().substring(1 + other.path().length()).contains("/"));
        if (this.parent == null) {
            this.parent = files.peek();
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public FileHandle child(String name) {
        for (ZipFileHandle child : this.children) {
            if (!child.name().equals(name)) continue;
            return child;
        }
        return new FileHandle(new File(this.file, name)){

            @Override
            public boolean exists() {
                return false;
            }
        };
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public FileHandle parent() {
        return this.parent;
    }

    @Override
    public FileHandle[] list() {
        return this.children;
    }

    @Override
    public boolean isDirectory() {
        return this.entry == null || this.entry.isDirectory();
    }

    @Override
    public InputStream read() {
        if (this.entry == null) {
            throw new RuntimeException("Not permitted.");
        }
        try {
            return this.zip.getInputStream(this.entry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long length() {
        return this.isDirectory() ? 0L : this.entry.getSize();
    }
}

