/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.freetype;

import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.AssetLoaderParameters;
import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.assets.loaders.AsynchronousAssetLoader;
import io.anuke.arc.assets.loaders.FileHandleResolver;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.freetype.FreeTypeFontGenerator;
import io.anuke.arc.graphics.g2d.BitmapFont;

public class FreetypeFontLoader
extends AsynchronousAssetLoader<BitmapFont, FreeTypeFontLoaderParameter> {
    public FreetypeFontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, FreeTypeFontLoaderParameter parameter) {
        if (parameter == null) {
            throw new RuntimeException("FreetypeFontParameter must be set in AssetManager#load to point at a TTF file!");
        }
    }

    @Override
    public BitmapFont loadSync(AssetManager manager, String fileName, FileHandle file, FreeTypeFontLoaderParameter parameter) {
        if (parameter == null) {
            throw new RuntimeException("FreetypeFontParameter must be set in AssetManager#load to point at a TTF file!");
        }
        FreeTypeFontGenerator generator = manager.get(parameter.fontFileName + ".gen", FreeTypeFontGenerator.class);
        return generator.generateFont(parameter.fontParameters);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, FreeTypeFontLoaderParameter parameter) {
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>();
        deps.add(new AssetDescriptor<FreeTypeFontGenerator>(parameter.fontFileName + ".gen", FreeTypeFontGenerator.class));
        return deps;
    }

    public static class FreeTypeFontLoaderParameter
    extends AssetLoaderParameters<BitmapFont> {
        public String fontFileName;
        public FreeTypeFontGenerator.FreeTypeFontParameter fontParameters = new FreeTypeFontGenerator.FreeTypeFontParameter();

        public FreeTypeFontLoaderParameter() {
        }

        public FreeTypeFontLoaderParameter(String fontFileName, FreeTypeFontGenerator.FreeTypeFontParameter fontParameters) {
            this.fontFileName = fontFileName;
            this.fontParameters = fontParameters;
        }
    }
}

