/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;

public class Fill {
    private static float[] vertices = new float[24];
    private static TextureRegion circleRegion;

    public static void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        TextureAtlas.AtlasRegion region = Core.atlas.white();
        float color = Core.batch.getPackedColor();
        float mcolor = Core.batch.getPackedMixColor();
        float u = region.getU();
        float v = region.getV();
        Fill.vertices[0] = x1;
        Fill.vertices[1] = y1;
        Fill.vertices[2] = color;
        Fill.vertices[3] = u;
        Fill.vertices[4] = v;
        Fill.vertices[5] = mcolor;
        Fill.vertices[6] = x2;
        Fill.vertices[7] = y2;
        Fill.vertices[8] = color;
        Fill.vertices[9] = u;
        Fill.vertices[10] = v;
        Fill.vertices[11] = mcolor;
        Fill.vertices[12] = x3;
        Fill.vertices[13] = y3;
        Fill.vertices[14] = color;
        Fill.vertices[15] = u;
        Fill.vertices[16] = v;
        Fill.vertices[17] = mcolor;
        Fill.vertices[18] = x4;
        Fill.vertices[19] = y4;
        Fill.vertices[20] = color;
        Fill.vertices[21] = u;
        Fill.vertices[22] = v;
        Fill.vertices[23] = mcolor;
        Draw.vert(region.getTexture(), vertices, 0, vertices.length);
    }

    public static void tri(float x1, float y1, float x2, float y2, float x3, float y3) {
        Fill.quad(x1, y1, x2, y2, x3, y3, x3, y3);
    }

    public static void poly(float x, float y, int sides, float radius) {
        Fill.poly(x, y, sides, radius, 0.0f);
    }

    public static void poly(float x, float y, int sides, float radius, float rotation) {
        float space = 360.0f / (float)sides;
        for (int i = 0; i < sides - 2; i += 3) {
            float px = Angles.trnsx(space * (float)i + rotation, radius);
            float py = Angles.trnsy(space * (float)i + rotation, radius);
            float px2 = Angles.trnsx(space * (float)(i + 1) + rotation, radius);
            float py2 = Angles.trnsy(space * (float)(i + 1) + rotation, radius);
            float px3 = Angles.trnsx(space * (float)(i + 2) + rotation, radius);
            float py3 = Angles.trnsy(space * (float)(i + 2) + rotation, radius);
            float px4 = Angles.trnsx(space * (float)(i + 3) + rotation, radius);
            float py4 = Angles.trnsy(space * (float)(i + 3) + rotation, radius);
            Fill.quad(x + px, y + py, x + px2, y + py2, x + px3, y + py3, x + px4, y + py4);
        }
        int mod = sides % 3;
        if (mod == 0) {
            return;
        }
        for (int i = sides - mod - 1; i < sides; ++i) {
            float px = Angles.trnsx(space * (float)i + rotation, radius);
            float py = Angles.trnsy(space * (float)i + rotation, radius);
            float px2 = Angles.trnsx(space * (float)(i + 1) + rotation, radius);
            float py2 = Angles.trnsy(space * (float)(i + 1) + rotation, radius);
            Fill.tri(x, y, x + px, y + py, x + px2, y + py2);
        }
    }

    public static void circle(float x, float y, float radius) {
        if (circleRegion == null || circleRegion.getTexture().isDisposed()) {
            circleRegion = Core.atlas.find("circle");
        }
        Draw.rect(circleRegion, x, y, radius * 2.0f, radius * 2.0f);
    }

    public static void rect(float x, float y, float w, float h) {
        Draw.rect(Core.atlas.white(), x, y, w, h);
    }

    public static void rect(float x, float y, float w, float h, float rot) {
        Draw.rect(Core.atlas.white(), x, y, w, h, rot);
    }

    public static void crect(float x, float y, float w, float h) {
        Draw.rect(Core.atlas.white(), x + w / 2.0f, y + h / 2.0f, w, h);
    }

    public static void square(float x, float y, float radius) {
        Fill.rect(x, y, radius * 2.0f, radius * 2.0f);
    }

    public static void square(float x, float y, float radius, float rotation) {
        Draw.rect(Core.atlas.white(), x, y, radius * 2.0f, radius * 2.0f, rotation);
    }

    public static void dispose() {
        circleRegion = null;
    }
}

