/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.SpriteBatch;
import io.anuke.arc.graphics.g2d.SpriteCache;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.util.Pack;

public class MultiCacheBatch
extends SpriteBatch {
    private static final int maxSpritesPerCache = 100000;
    Array<SpriteCache> caches = new Array();
    int currentid = -1;
    int maxCacheSize;
    int offset;

    public MultiCacheBatch(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    SpriteCache currentCache() {
        int needed;
        int n = needed = this.currentid == -1 ? this.offset / 100000 : this.currentid;
        if (needed >= this.caches.size) {
            this.caches.add(new SpriteCache(100000, false));
        }
        return this.caches.get(needed);
    }

    @Override
    public void flush() {
    }

    @Override
    public void setColor(Color tint) {
        this.currentCache().setColor(tint);
    }

    @Override
    void setColor(float r, float g, float b, float a) {
        this.currentCache().setColor(r, g, b, a);
    }

    @Override
    public void setPackedColor(float color) {
        this.currentCache().setPackedColor(color);
    }

    @Override
    public Color getColor() {
        return this.currentCache().getColor();
    }

    @Override
    public float getPackedColor() {
        return this.currentCache().getColor().toFloatBits();
    }

    @Override
    public void setProjection(Matrix3 projection) {
        this.currentid = 0;
        this.currentCache().setProjectionMatrix(projection);
    }

    public void beginCache() {
        this.currentid = this.offset / 100000;
        if (this.currentid < (this.offset + this.maxCacheSize) / 100000) {
            this.offset += this.maxCacheSize - this.offset % this.maxCacheSize + 2;
            this.currentid = this.offset / 100000;
        }
        this.currentCache().beginCache();
    }

    public int endCache() {
        int id = Pack.shortInt((short)this.currentCache().endCache(), (short)this.currentid);
        this.currentid = -1;
        return id;
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        this.currentCache().add(region, x, y, originX, originY, width, height, 1.0f, 1.0f, rotation);
        ++this.offset;
    }

    @Override
    void setShader(Shader shader) {
        this.setShader(shader, true);
    }

    @Override
    void setShader(Shader shader, boolean apply) {
        boolean drawing = this.currentCache().isDrawing();
        if (drawing) {
            this.currentCache().end();
        }
        this.currentCache().setShader(shader);
        if (drawing) {
            this.currentCache().begin();
        }
        if (apply && shader != null) {
            shader.apply();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SpriteCache cache : this.caches) {
            cache.dispose();
        }
    }

    public void beginDraw() {
        this.currentid = 0;
        this.currentCache().begin();
    }

    public void endDraw() {
        this.currentCache().end();
        this.currentid = -1;
    }

    public void drawCache(int id) {
        short cacheID = Pack.leftShort(id);
        short batch = Pack.rightShort(id);
        if (this.currentid != batch) {
            SpriteCache prev = this.currentCache();
            prev.end();
            this.currentid = batch;
            this.currentCache().setProjectionMatrix(prev.getProjectionMatrix());
            this.currentCache().begin();
        }
        this.currentCache().draw(cacheID);
    }
}

