/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.graphics.g2d;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Blending;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Mesh;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.VertexAttribute;
import io.anuke.arc.graphics.g2d.BatchShader;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.util.Disposable;

public class SpriteBatch
implements Disposable {
    static final int VERTEX_SIZE = 6;
    static final int SPRITE_SIZE = 24;
    protected Mesh mesh;
    protected final float[] vertices;
    protected int idx = 0;
    protected Texture lastTexture = null;
    protected float invTexWidth = 0.0f;
    protected float invTexHeight = 0.0f;
    protected boolean apply;
    protected final Matrix3 transformMatrix = new Matrix3();
    protected final Matrix3 projectionMatrix = new Matrix3();
    protected final Matrix3 combinedMatrix = new Matrix3();
    protected Blending blending = Blending.normal;
    protected final Shader shader;
    protected Shader customShader = null;
    private boolean ownsShader;
    protected final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected float colorPacked = Color.whiteFloatBits;
    protected final Color mixColor = Color.clear;
    protected float mixColorPacked = Color.clearFloatBits;
    int renderCalls = 0;
    int totalRenderCalls = 0;
    int maxSpritesInBatch = 0;

    public SpriteBatch() {
        this(4096, null);
    }

    public SpriteBatch(int size) {
        this(size, null);
    }

    public SpriteBatch(int size, Shader defaultShader) {
        if (size > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + size);
        }
        Mesh.VertexDataType vertexDataType = Core.gl30 != null ? Mesh.VertexDataType.VertexBufferObjectWithVAO : Mesh.VertexDataType.VertexArray;
        this.mesh = new Mesh(vertexDataType, false, size * 4, size * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"), new VertexAttribute(4, 4, "a_mix_color"));
        this.projectionMatrix.setOrtho(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        this.vertices = new float[size * 24];
        int len = size * 6;
        short[] indices = new short[len];
        short j = 0;
        int i = 0;
        while (i < len) {
            indices[i] = j;
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 3);
            indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.mesh.setIndices(indices);
        if (defaultShader == null) {
            this.shader = BatchShader.create();
            this.ownsShader = true;
        } else {
            this.shader = defaultShader;
        }
    }

    void setColor(Color tint) {
        this.color.set(tint);
        this.colorPacked = tint.toFloatBits();
    }

    void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
        this.colorPacked = this.color.toFloatBits();
    }

    protected Color getColor() {
        return this.color;
    }

    void setPackedColor(float packedColor) {
        Color.abgr8888ToColor(this.color, packedColor);
        this.colorPacked = packedColor;
    }

    protected float getPackedColor() {
        return this.colorPacked;
    }

    void setMixColor(Color tint) {
        this.mixColor.set(tint);
        this.mixColorPacked = tint.toFloatBits();
    }

    void setMixColor(float r, float g, float b, float a) {
        this.mixColor.set(r, g, b, a);
        this.mixColorPacked = this.mixColor.toFloatBits();
    }

    protected Color getMixColor() {
        return this.mixColor;
    }

    void setPackedMixColor(float packedColor) {
        Color.abgr8888ToColor(this.mixColor, packedColor);
        this.mixColorPacked = packedColor;
    }

    protected float getPackedMixColor() {
        return this.mixColorPacked;
    }

    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        int verticesLength;
        int remainingVertices = verticesLength = this.vertices.length;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if ((remainingVertices -= this.idx) == 0) {
            this.flush();
            remainingVertices = verticesLength;
        }
        int copyCount = Math.min(remainingVertices, count);
        System.arraycopy(spriteVertices, offset, this.vertices, this.idx, copyCount);
        this.idx += copyCount;
        count -= copyCount;
        while (count > 0) {
            this.flush();
            copyCount = Math.min(verticesLength, count);
            System.arraycopy(spriteVertices, offset += copyCount, this.vertices, 0, copyCount);
            this.idx += copyCount;
            count -= copyCount;
        }
    }

    protected void draw(TextureRegion region, float x, float y) {
        this.draw(region, x, y, region.getWidth(), region.getHeight());
    }

    protected void draw(TextureRegion region, float x, float y, float width, float height) {
        this.draw(region, x, y, 0.0f, 0.0f, width, height, 0.0f);
    }

    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        Texture texture = region.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == this.vertices.length) {
            this.flush();
        }
        if (!Mathf.isZero(rotation)) {
            float worldOriginX = x + originX;
            float worldOriginY = y + originY;
            float fx = -originX;
            float fy = -originY;
            float fx2 = width - originX;
            float fy2 = height - originY;
            float cos = Mathf.cosDeg(rotation);
            float sin = Mathf.sinDeg(rotation);
            float x1 = cos * fx - sin * fy;
            float y1 = sin * fx + cos * fy;
            float x2 = cos * fx - sin * fy2;
            float y2 = sin * fx + cos * fy2;
            float x3 = cos * fx2 - sin * fy2;
            float y3 = sin * fx2 + cos * fy2;
            float x4 = x1 + (x3 - x2);
            float y4 = y3 - (y2 - y1);
            x1 += worldOriginX;
            y1 += worldOriginY;
            x2 += worldOriginX;
            y2 += worldOriginY;
            x3 += worldOriginX;
            y3 += worldOriginY;
            x4 += worldOriginX;
            y4 += worldOriginY;
            float u = region.u;
            float v = region.v2;
            float u2 = region.u2;
            float v2 = region.v;
            float color = this.colorPacked;
            float mixColor = this.mixColorPacked;
            int idx = this.idx;
            this.vertices[idx] = x1;
            this.vertices[idx + 1] = y1;
            this.vertices[idx + 2] = color;
            this.vertices[idx + 3] = u;
            this.vertices[idx + 4] = v;
            this.vertices[idx + 5] = mixColor;
            this.vertices[idx + 6] = x2;
            this.vertices[idx + 7] = y2;
            this.vertices[idx + 8] = color;
            this.vertices[idx + 9] = u;
            this.vertices[idx + 10] = v2;
            this.vertices[idx + 11] = mixColor;
            this.vertices[idx + 12] = x3;
            this.vertices[idx + 13] = y3;
            this.vertices[idx + 14] = color;
            this.vertices[idx + 15] = u2;
            this.vertices[idx + 16] = v2;
            this.vertices[idx + 17] = mixColor;
            this.vertices[idx + 18] = x4;
            this.vertices[idx + 19] = y4;
            this.vertices[idx + 20] = color;
            this.vertices[idx + 21] = u2;
            this.vertices[idx + 22] = v;
            this.vertices[idx + 23] = mixColor;
            this.idx = idx + 24;
        } else {
            float fx2 = x + width;
            float fy2 = y + height;
            float u = region.u;
            float v = region.v2;
            float u2 = region.u2;
            float v2 = region.v;
            float color = this.colorPacked;
            float mixColor = this.mixColorPacked;
            int idx = this.idx;
            this.vertices[idx] = x;
            this.vertices[idx + 1] = y;
            this.vertices[idx + 2] = color;
            this.vertices[idx + 3] = u;
            this.vertices[idx + 4] = v;
            this.vertices[idx + 5] = mixColor;
            this.vertices[idx + 6] = x;
            this.vertices[idx + 7] = fy2;
            this.vertices[idx + 8] = color;
            this.vertices[idx + 9] = u;
            this.vertices[idx + 10] = v2;
            this.vertices[idx + 11] = mixColor;
            this.vertices[idx + 12] = fx2;
            this.vertices[idx + 13] = fy2;
            this.vertices[idx + 14] = color;
            this.vertices[idx + 15] = u2;
            this.vertices[idx + 16] = v2;
            this.vertices[idx + 17] = mixColor;
            this.vertices[idx + 18] = fx2;
            this.vertices[idx + 19] = y;
            this.vertices[idx + 20] = color;
            this.vertices[idx + 21] = u2;
            this.vertices[idx + 22] = v;
            this.vertices[idx + 23] = mixColor;
            this.idx = idx + 24;
        }
    }

    protected void flush() {
        if (this.idx == 0) {
            return;
        }
        this.renderCalls = 0;
        this.getShader().begin();
        this.setupMatrices();
        if (this.customShader != null && this.apply) {
            this.customShader.apply();
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int spritesInBatch = this.idx / 24;
        if (spritesInBatch > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = spritesInBatch;
        }
        int count = spritesInBatch * 6;
        if (this.blending != Blending.disabled) {
            Core.gl.glEnable(3042);
            Core.gl.glBlendFuncSeparate(this.blending.src, this.blending.dst, this.blending.src, this.blending.dst);
        } else {
            Core.gl.glDisable(3042);
        }
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.idx);
        mesh.getIndicesBuffer().position(0);
        mesh.getIndicesBuffer().limit(count);
        mesh.render(this.getShader(), 4, 0, count);
        this.idx = 0;
        this.getShader().end();
    }

    void setBlending(Blending blending) {
        this.flush();
        this.blending = blending;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
    }

    Matrix3 getProjection() {
        return this.projectionMatrix;
    }

    Matrix3 getTransform() {
        return this.transformMatrix;
    }

    void setProjection(Matrix3 projection) {
        this.flush();
        this.projectionMatrix.set(projection);
    }

    void setTransform(Matrix3 transform) {
        this.flush();
        this.transformMatrix.set(transform);
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        this.getShader().setUniformMatrix4("u_projTrans", BatchShader.copyTransform(this.combinedMatrix));
        this.getShader().setUniformi("u_texture", 0);
    }

    protected void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
    }

    void setShader(Shader shader) {
        this.setShader(shader, true);
    }

    void setShader(Shader shader, boolean apply) {
        this.flush();
        this.customShader = shader;
        this.apply = apply;
    }

    Shader getShader() {
        if (this.customShader == null) {
            return this.shader;
        }
        return this.customShader;
    }
}

