/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.input;

import io.anuke.arc.collection.IntArray;
import io.anuke.arc.input.InputProcessor;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.util.Time;

public class InputEventQueue
implements InputProcessor {
    private static final int SKIP = -1;
    private static final int KEY_DOWN = 0;
    private static final int KEY_UP = 1;
    private static final int KEY_TYPED = 2;
    private static final int TOUCH_DOWN = 3;
    private static final int TOUCH_UP = 4;
    private static final int TOUCH_DRAGGED = 5;
    private static final int MOUSE_MOVED = 6;
    private static final int SCROLLED = 7;
    private final IntArray queue = new IntArray();
    private final IntArray processingQueue = new IntArray();
    private InputProcessor processor;
    private long currentEventTime;

    public InputEventQueue() {
    }

    public InputEventQueue(InputProcessor processor) {
        this.processor = processor;
    }

    public InputProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        InputEventQueue inputEventQueue = this;
        synchronized (inputEventQueue) {
            if (this.processor == null) {
                this.queue.clear();
                return;
            }
            this.processingQueue.addAll(this.queue);
            this.queue.clear();
        }
        int[] q = this.processingQueue.items;
        InputProcessor localProcessor = this.processor;
        int i = 0;
        int n = this.processingQueue.size;
        block14: while (i < n) {
            int type = q[i++];
            this.currentEventTime = (long)q[i++] << 32 | (long)q[i++] & 0xFFFFFFFFL;
            switch (type) {
                case -1: {
                    i += q[i];
                    continue block14;
                }
                case 0: {
                    localProcessor.keyDown(KeyCode.byOrdinal(q[i++]));
                    continue block14;
                }
                case 1: {
                    localProcessor.keyUp(KeyCode.byOrdinal(q[i++]));
                    continue block14;
                }
                case 2: {
                    localProcessor.keyTyped((char)q[i++]);
                    continue block14;
                }
                case 3: {
                    localProcessor.touchDown(q[i++], q[i++], q[i++], KeyCode.byOrdinal(q[i++]));
                    continue block14;
                }
                case 4: {
                    localProcessor.touchUp(q[i++], q[i++], q[i++], KeyCode.byOrdinal(q[i++]));
                    continue block14;
                }
                case 5: {
                    localProcessor.touchDragged(q[i++], q[i++], q[i++]);
                    continue block14;
                }
                case 6: {
                    localProcessor.mouseMoved(q[i++], q[i++]);
                    continue block14;
                }
                case 7: {
                    localProcessor.scrolled((float)q[i++] / 256.0f, (float)q[i++] / 256.0f);
                    continue block14;
                }
            }
            throw new RuntimeException();
        }
        this.processingQueue.clear();
    }

    private synchronized int next(int nextType, int i) {
        int[] q = this.queue.items;
        int n = this.queue.size;
        block11: while (i < n) {
            int type = q[i];
            if (type == nextType) {
                return i;
            }
            i += 3;
            switch (type) {
                case -1: {
                    i += q[i];
                    continue block11;
                }
                case 0: {
                    ++i;
                    continue block11;
                }
                case 1: {
                    ++i;
                    continue block11;
                }
                case 2: {
                    ++i;
                    continue block11;
                }
                case 3: {
                    i += 4;
                    continue block11;
                }
                case 4: {
                    i += 4;
                    continue block11;
                }
                case 5: {
                    i += 3;
                    continue block11;
                }
                case 6: {
                    i += 2;
                    continue block11;
                }
                case 7: {
                    i += 2;
                    continue block11;
                }
            }
            throw new RuntimeException();
        }
        return -1;
    }

    private void queueTime() {
        long time = Time.nanos();
        this.queue.add((int)(time >> 32));
        this.queue.add((int)time);
    }

    @Override
    public synchronized boolean keyDown(KeyCode keycode) {
        this.queue.add(0);
        this.queueTime();
        this.queue.add(keycode.ordinal());
        return false;
    }

    @Override
    public synchronized boolean keyUp(KeyCode keycode) {
        this.queue.add(1);
        this.queueTime();
        this.queue.add(keycode.ordinal());
        return false;
    }

    @Override
    public synchronized boolean keyTyped(char character) {
        this.queue.add(2);
        this.queueTime();
        this.queue.add(character);
        return false;
    }

    @Override
    public synchronized boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        this.queue.add(3);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        this.queue.add(pointer);
        this.queue.add(button.ordinal());
        return false;
    }

    @Override
    public synchronized boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        this.queue.add(4);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        this.queue.add(pointer);
        this.queue.add(button.ordinal());
        return false;
    }

    @Override
    public synchronized boolean touchDragged(int screenX, int screenY, int pointer) {
        int i = this.next(5, 0);
        while (i >= 0) {
            if (this.queue.get(i + 5) == pointer) {
                this.queue.set(i, -1);
                this.queue.set(i + 3, 3);
            }
            i = this.next(5, i + 6);
        }
        this.queue.add(5);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        this.queue.add(pointer);
        return false;
    }

    @Override
    public synchronized boolean mouseMoved(int screenX, int screenY) {
        int i = this.next(6, 0);
        while (i >= 0) {
            this.queue.set(i, -1);
            this.queue.set(i + 3, 2);
            i = this.next(6, i + 5);
        }
        this.queue.add(6);
        this.queueTime();
        this.queue.add(screenX);
        this.queue.add(screenY);
        return false;
    }

    @Override
    public synchronized boolean scrolled(float amountX, float amountY) {
        this.queue.add(7);
        this.queueTime();
        this.queue.add((int)(amountX * 256.0f));
        this.queue.add((int)(amountY * 256.0f));
        return false;
    }

    public long getCurrentEventTime() {
        return this.currentEventTime;
    }
}

