/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.input;

import io.anuke.arc.collection.IntFloatMap;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.input.InputDevice;
import io.anuke.arc.input.InputProcessor;
import io.anuke.arc.input.KeyCode;

public class KeyboardDevice
extends InputDevice
implements InputProcessor {
    private final IntSet pressed = new IntSet();
    private final IntSet lastFramePressed = new IntSet();
    private final IntFloatMap axes = new IntFloatMap();

    @Override
    public void update() {
        this.lastFramePressed.clear();
        this.lastFramePressed.addAll(this.pressed);
        this.axes.clear();
    }

    @Override
    public boolean isKeyPressed(KeyCode key) {
        if (key == KeyCode.ANY_KEY) {
            return this.pressed.size > 0;
        }
        return this.pressed.contains(key.ordinal());
    }

    @Override
    public boolean isKeyTapped(KeyCode key) {
        return this.isKeyPressed(key) && !this.lastFramePressed.contains(key.ordinal());
    }

    @Override
    public boolean isKeyReleased(KeyCode key) {
        return !this.isKeyPressed(key) && this.lastFramePressed.contains(key.ordinal());
    }

    @Override
    public float getAxis(KeyCode keyCode) {
        return this.axes.get(keyCode.ordinal(), 0.0f);
    }

    @Override
    public boolean keyDown(KeyCode keycode) {
        this.pressed.add(keycode.ordinal());
        return false;
    }

    @Override
    public boolean keyUp(KeyCode keycode) {
        this.pressed.remove(keycode.ordinal());
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        this.keyDown(button);
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        if (pointer == 0) {
            this.keyUp(button);
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amountY) {
        this.axes.put(KeyCode.SCROLL.ordinal(), -amountY);
        return false;
    }

    @Override
    public String name() {
        return "Keyboard";
    }

    @Override
    public InputDevice.DeviceType type() {
        return InputDevice.DeviceType.keyboard;
    }
}

