/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.maps;

import io.anuke.arc.collection.Array;
import io.anuke.arc.maps.MapObject;
import io.anuke.arc.maps.MapProperties;
import io.anuke.arc.util.ArcRuntimeException;

public class MapLayer {
    public String name = "";
    public float opacity = 1.0f;
    public boolean visible = true;
    private float offsetX;
    private float offsetY;
    private float renderOffsetX;
    private float renderOffsetY;
    private boolean renderOffsetDirty = true;
    private MapLayer parent;
    public final Array<MapObject> objects = new Array();
    public final MapProperties properties = new MapProperties();

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
        this.invalidateRenderOffset();
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
        this.invalidateRenderOffset();
    }

    public float getRenderOffsetX() {
        if (this.renderOffsetDirty) {
            this.calculateRenderOffsets();
        }
        return this.renderOffsetX;
    }

    public float getRenderOffsetY() {
        if (this.renderOffsetDirty) {
            this.calculateRenderOffsets();
        }
        return this.renderOffsetY;
    }

    public void invalidateRenderOffset() {
        this.renderOffsetDirty = true;
    }

    public MapLayer getParent() {
        return this.parent;
    }

    public void setParent(MapLayer parent) {
        if (parent == this) {
            throw new ArcRuntimeException("Can't set self as the parent");
        }
        this.parent = parent;
    }

    protected void calculateRenderOffsets() {
        if (this.parent != null) {
            this.parent.calculateRenderOffsets();
            this.renderOffsetX = this.parent.getRenderOffsetX() + this.offsetX;
            this.renderOffsetY = this.parent.getRenderOffsetY() + this.offsetY;
        } else {
            this.renderOffsetX = this.offsetX;
            this.renderOffsetY = this.offsetY;
        }
        this.renderOffsetDirty = false;
    }
}

