/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.maps;

import io.anuke.arc.collection.Array;
import io.anuke.arc.maps.MapTile;
import io.anuke.arc.maps.TileSet;
import java.util.Iterator;

public class TileSets
implements Iterable<TileSet> {
    private Array<TileSet> tilesets = new Array();

    public TileSet getTileSet(int index) {
        return this.tilesets.get(index);
    }

    public TileSet getTileSet(String name) {
        for (TileSet tileset : this.tilesets) {
            if (!name.equals(tileset.name)) continue;
            return tileset;
        }
        return null;
    }

    public void addTileSet(TileSet tileset) {
        this.tilesets.add(tileset);
    }

    public void removeTileSet(int index) {
        this.tilesets.remove(index);
    }

    public void removeTileSet(TileSet tileset) {
        this.tilesets.removeValue(tileset, true);
    }

    public MapTile getTile(int id) {
        for (int i = this.tilesets.size - 1; i >= 0; --i) {
            TileSet tileset = this.tilesets.get(i);
            MapTile tile = tileset.get(id);
            if (tile == null) continue;
            return tile;
        }
        return null;
    }

    @Override
    public Iterator<TileSet> iterator() {
        return this.tilesets.iterator();
    }
}

